# Development Tasks for memx Library

This document outlines the development tasks for the `memx` library, based on the design specified in `specs/2.design.md`.

## Core Functionality

- [x] Implement `memchr` and `memrchr` for single-byte search.
- [x] Implement multi-byte search functions:
    - [x] `memchr_dbl`, `memchr_tpl`, `memchr_qpl`
    - [x] `memrchr_dbl`, `memrchr_tpl`, `memrchr_qpl`
- [x] Implement negated search functions:
    - [x] `memnechr`, `memnechr_dbl`, `memnechr_tpl`, `memnechr_qpl`
    - [x] `memrnechr`, `memrnechr_dbl`, `memrnechr_tpl`, `memrnechr_qpl`
- [x] Implement sub-slice search functions:
    - [x] `memmem`
    - [x] `memrmem`
- [x] Implement memory comparison functions:
    - [x] `memcmp`
    - [x] `memeq`
- [x] Implement memory manipulation functions:
    - [x] `memcpy`
    - [x] `memset`

## Iterators

- [x] Implement iterators for all search functions:
    - [x] `memchr_iter`, `memrchr_iter`
    - [x] `memchr_dbl_iter`, `memrchr_dbl_iter`
    - [x] `memchr_tpl_iter`, `memrchr_tpl_iter`
    - [x] `memchr_qpl_iter`, `memrchr_qpl_iter`
    - [x] `memmem_iter`, `memrmem_iter`

## Performance

- [x] Implement SSE2 and AVX2 optimizations for x86/x86-64 architectures.
- [x] Provide fallback implementations for other architectures.

## API and Design

- [x] Ensure `no_std` compatibility.
- [x] Create a comprehensive test suite to ensure correctness and reliability.
