//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cGib.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cGib.hpp"
#include "cAnimationManager.hpp"
#include "cTextureManager.hpp"
#include "cWorld.hpp"
#include <cstdlib>
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cGib::cGib (void)
{
	SetLayer (-7);
	SetCollisionModel (CollisionModel_Ray);
	SetContactModel (ContactModel_Slide);

	mAnimation.SetAnimation (cAnimationManager::GetInstance ().LoadAnimation ("gibs"));
	mAnimation.SetCurrentFrame (int (3.0f * rand () / (RAND_MAX + 1.0f)));
	mAnimation.SetNumberOfFrames (4);
	mAnimation.SetFrameDelay (99999999);

	SetRotation (360.0f * rand () / (RAND_MAX + 1.0f));
	SetVelocity (GetDirection (0) * 0.5f * rand () / (RAND_MAX + 1.0f));

	mTTL = 5000 + int (GetVelocity ().GetLenght () * 2000.0f);

	mBlood = new cParticleSystem (180);
	mBlood->SetTexture (cTextureManager::GetInstance ().LoadTexture ("tuli2.png"));
	mBlood->SetEmitDelay (10);
	mBlood->SetStartColor (0.6f, 0.0f, 0.0f, 0.2f);
	mBlood->SetEndColor (1.0f, 0.0f, 0.0f, 0.0f);
	mBlood->SetSpeed (0.001f, 0.0f);
	mBlood->SetSize (32.0f * rand () / (RAND_MAX + 1.0f), 0.5f);
	mBlood->SetEnergy (2000, 0.2f);
	mBlood->SetEmitter (this);
	mBlood->SetLayer (-8);
	//mBlood->SetBlending (true);
	cWorld::GetInstance ().SpawnObject (mBlood);
};

//! Destructor
cGib::~cGib (void)
{
	// Empty
};

void
cGib::Update (Uint32 deltaTime)
{
	SetVelocity (GetVelocity () * (1.0f - 0.001f * deltaTime));
	Rotate (GetVelocity ().GetLenght () * deltaTime * 2.0f);

	if ( mTTL < 2000 )
		mAnimation.SetAlpha (float (mTTL) / 2000.0f);

	if ( deltaTime > mTTL )
	{
		Kill ();
		if ( mBlood.IsValid () )
		{
			mBlood->SetEmitDelay (0);
			mBlood->KillEmptySystem (true);
			mBlood = NULL;
		}
	}
	else
		mTTL -= deltaTime;
}

//==============================================================================
// EOF
//==============================================================================
