//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cGameView.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarsk@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cGameView_hpp
#define cGameView_hpp
//==============================================================================
// Includes
#include "Types.hpp"
#include "cVector2f.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cGameMode;
class cPlayer;
//==============================================================================
	
//! GameView
class cGameView
{
	// Constructor & Destructor
	public:
		//! Constructor
		cGameView (cGameMode &game);
		//! Destructor
		~cGameView (void);
	
	// Public methods
	public:
		//! Update the view (sliding)
		void Update (Uint32 deltaTime);
		//! Render the game
		void Render (Uint32 deltaTime);
		//! Reset the view
		void Reset (void) { mSliding = 0.0f; };
		
	// Private methods
	private:
		void RenderSingle (Uint32 deltaTime);
		void RenderSplit (Uint32 deltaTime);
		void RenderGame (int x, int y, int w, int h, cPlayer *pPlayer, Uint32 deltaTime);
	
	// Member variables
	private:
		cGameMode &mGameMode;
		int mScreenW;
		int mScreenW2;
		int mScreenH;
		int mScreenH2;
		float mSliding;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cGameView_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
