/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Resolvable;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.IOException;

public class TeXParserUtils {
    public static TeXObject peek(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.peekStack(by);
        }
        return teXObjectList.peekStack(by);
    }

    public static TeXObject pop(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popStack(by);
        }
        return teXObjectList.popStack(teXParser, by);
    }

    public static int popModifier(TeXParser teXParser, TeXObjectList teXObjectList, int ... nArray) throws IOException {
        TeXObject teXObject = teXParser == teXObjectList || teXObjectList == null ? teXParser.peekStack() : teXObjectList.peekStack();
        int n = -1;
        if (teXObject instanceof CharObject) {
            int n2 = ((CharObject)teXObject).getCharCode();
            for (int n3 : nArray) {
                if (n2 != n3) continue;
                n = n3;
                break;
            }
            if (n != -1) {
                if (teXParser == teXObjectList || teXObjectList == null) {
                    teXParser.popStack();
                } else {
                    teXObjectList.popStack(teXParser);
                }
            }
        }
        return n;
    }

    public static String popLabelString(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.expandToString(TeXParserUtils.popArg(teXParser, teXObjectList), teXObjectList);
    }

    public static String popOptLabelString(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return teXParser.expandToString(teXObject, teXObjectList);
    }

    public static TeXObject popArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg();
        }
        return teXObjectList.popArg(teXParser);
    }

    public static TeXObject popArg(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg(by);
        }
        return teXObjectList.popArg(teXParser, by);
    }

    public static TeXObject popOptArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg(91, 93);
        }
        return teXObjectList.popArg(teXParser, 91, 93);
    }

    public static TeXObject popOptArg(byte by, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg(by, 91, 93);
        }
        return teXObjectList.popArg(teXParser, by, 91, 93);
    }

    public static TeXObject expandOnce(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.expandonce(teXObject, teXObjectList);
    }

    public static TeXObject expandFully(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.expandfully(teXObject, teXObjectList);
    }

    public static TeXObject popArgExpandOnce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
    }

    public static TeXObject popArgExpandFully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
    }

    public static TeXObject popOptArgExpandFully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
    }

    public static Numerical toNumerical(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXParser.isStack(teXObject) && ((TeXObjectList)teXObject).size() == 1 && ((TeXObjectList)teXObject).firstElement() instanceof Numerical) {
            return (Numerical)((TeXObjectList)teXObject).firstElement();
        }
        String string = teXParser.expandToString(teXObject, teXObjectList).trim();
        return new UserNumber(teXParser, string);
    }

    public static int popInt(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = TeXParserUtils.popNumericalArg(teXParser, teXObjectList);
        return numerical.number(teXParser);
    }

    public static Numerical popNumericalArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNumericalArg();
        }
        return teXObjectList.popNumericalArg(teXParser);
    }

    public static NumericRegister popNumericRegister(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        NumericRegister numericRegister = null;
        if (teXObject instanceof ControlSequence) {
            numericRegister = teXParser.getSettings().getNumericRegister(((ControlSequence)teXObject).getName());
        }
        if (numericRegister == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.register_not_numeric", teXObject.toString(teXParser));
        }
        return numericRegister;
    }

    public static TeXDimension popDimensionArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArgExpandFully(teXParser, teXObjectList);
        if (teXObject instanceof InternalQuantity) {
            teXObject = ((InternalQuantity)teXObject).getQuantity(teXParser, teXObjectList);
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList2 = (TeXObjectList)teXObject;
            return teXObjectList2.popDimension(teXParser);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", new Object[0]);
    }

    public static TeXDimension popOptDimensionArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArgExpandFully(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof InternalQuantity) {
            teXObject = ((InternalQuantity)teXObject).getQuantity(teXParser, teXObjectList);
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList2 = (TeXObjectList)teXObject;
            return teXObjectList2.popDimension(teXParser);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", new Object[0]);
    }

    public static boolean isControlSequence(TeXObject teXObject, String ... stringArray) {
        if (teXObject instanceof ControlSequence) {
            ControlSequence controlSequence = (ControlSequence)teXObject;
            for (String string : stringArray) {
                if (!controlSequence.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static ControlSequence popControlSequence(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        if (teXObject instanceof ControlSequence) {
            return (ControlSequence)teXObject;
        }
        if (teXParser.isStack(teXObject)) {
            if (teXObjectList == null) {
                teXParser.push(teXObject, true);
            } else {
                teXObjectList.push(teXObject, true);
            }
            teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
            if (teXObject instanceof ControlSequence) {
                return (ControlSequence)teXObject;
            }
        }
        throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.format(), teXObject.getClass().getSimpleName());
    }

    public static TeXObjectList toList(TeXObject teXObject, TeXParser teXParser) {
        if (teXParser.isStack(teXObject)) {
            return (TeXObjectList)teXObject;
        }
        return TeXParserUtils.createStack(teXParser, teXObject);
    }

    public static CsvList toCsvList(TeXObject teXObject, TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        if (teXObject instanceof CsvList) {
            return (CsvList)teXObject;
        }
        if (teXParser.isStack(teXObject) && (teXObjectList = (TeXObjectList)teXObject).size() == 1 && teXObjectList.firstElement() instanceof CsvList) {
            return (CsvList)teXObjectList.firstElement();
        }
        return CsvList.getList(teXParser, teXObject);
    }

    public static CsvList popCsvList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.toCsvList(teXObject, teXParser);
    }

    public static CsvList popOptCsvList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return TeXParserUtils.toCsvList(teXObject, teXParser);
    }

    public static KeyValList toKeyValList(TeXObject teXObject, TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        if (teXObject instanceof KeyValList) {
            return (KeyValList)teXObject;
        }
        if (teXParser.isStack(teXObject) && (teXObjectList = (TeXObjectList)teXObject).size() == 1 && teXObjectList.firstElement() instanceof KeyValList) {
            return (KeyValList)teXObjectList.firstElement();
        }
        return KeyValList.getList(teXParser, teXObject);
    }

    public static KeyValList popKeyValList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.toKeyValList(teXObject, teXParser);
    }

    public static KeyValList popOptKeyValList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return TeXParserUtils.toKeyValList(teXObject, teXParser);
    }

    public static boolean isTrue(String string, TeXParser teXParser) {
        TeXBoolean teXBoolean = TeXParserUtils.toBoolean(string, teXParser);
        return teXBoolean != null && teXBoolean.booleanValue();
    }

    public static boolean isFalse(String string, TeXParser teXParser) {
        TeXBoolean teXBoolean = TeXParserUtils.toBoolean(string, teXParser);
        return teXBoolean != null && !teXBoolean.booleanValue();
    }

    public static TeXBoolean toBoolean(String string, TeXParser teXParser) {
        return TeXParserUtils.toBoolean(teXParser.getControlSequence(string), teXParser);
    }

    public static TeXBoolean toBoolean(TeXObject teXObject, TeXParser teXParser) {
        TeXObject teXObject2;
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof TeXBoolean) {
            return (TeXBoolean)teXObject;
        }
        if (teXObject instanceof AssignedControlSequence && (teXObject2 = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXBoolean) {
            return (TeXBoolean)teXObject2;
        }
        return null;
    }

    public static int toInt(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        if (teXObject instanceof TeXNumber) {
            return ((TeXNumber)teXObject).getValue();
        }
        if (teXObject instanceof AssignedControlSequence && (object = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXNumber) {
            return ((TeXNumber)object).getValue();
        }
        object = teXParser.expandToString(teXObject, teXObjectList);
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object);
        }
    }

    public static float toFloat(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        if (teXObject instanceof TeXNumber) {
            return (float)((TeXNumber)teXObject).doubleValue();
        }
        if (teXObject instanceof AssignedControlSequence && (object = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXNumber) {
            return ((TeXNumber)object).getValue();
        }
        object = teXParser.expandToString(teXObject, teXObjectList);
        try {
            return Float.parseFloat((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object);
        }
    }

    public static double toDouble(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        if (teXObject instanceof TeXNumber) {
            return ((TeXNumber)teXObject).doubleValue();
        }
        if (teXObject instanceof AssignedControlSequence && (object = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXNumber) {
            return ((TeXNumber)object).getValue();
        }
        object = teXParser.expandToString(teXObject, teXObjectList);
        try {
            return Double.parseDouble((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object);
        }
    }

    public static TeXObjectList createStack(TeXParser teXParser, TeXObject ... teXObjectArray) {
        return TeXParserUtils.createStack(teXParser.getListener(), teXObjectArray);
    }

    public static TeXObjectList createStack(TeXParserListener teXParserListener, TeXObject ... teXObjectArray) {
        TeXObjectList teXObjectList = teXParserListener.createStack();
        for (TeXObject teXObject : teXObjectArray) {
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public static Group createGroup(TeXParser teXParser, TeXObject ... teXObjectArray) {
        return TeXParserUtils.createGroup(teXParser.getListener(), teXObjectArray);
    }

    public static Group createGroup(TeXParserListener teXParserListener, TeXObject ... teXObjectArray) {
        Group group = teXParserListener.createGroup();
        for (TeXObject teXObject : teXObjectArray) {
            group.add(teXObject);
        }
        return group;
    }

    public static TeXObjectList removeGroup(TeXObjectList teXObjectList) {
        TeXObject teXObject;
        if (teXObjectList instanceof Group && !(teXObjectList instanceof MathGroup)) {
            teXObjectList = ((Group)teXObjectList).toList();
        } else if (teXObjectList.size() == 1 && (teXObject = (TeXObject)teXObjectList.firstElement()) instanceof Group && !(teXObject instanceof MathGroup)) {
            teXObjectList = ((Group)teXObject).toList();
        }
        return teXObjectList;
    }

    public static void process(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public static TeXObject resolve(TeXObject teXObject, TeXParser teXParser) {
        if (teXObject != null && teXObject instanceof Resolvable) {
            teXObject = ((Resolvable)((Object)teXObject)).resolve(teXParser);
        }
        return teXObject;
    }

    public static boolean isVoid(TeXObject teXObject, TeXParser teXParser) {
        if (teXObject == null || teXObject.isEmpty() || teXObject instanceof Relax) {
            return true;
        }
        return teXObject instanceof Resolvable && ((teXObject = ((Resolvable)((Object)teXObject)).resolve(teXParser)).isEmpty() || teXObject instanceof Relax);
    }
}

