/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

public enum TeXFontSize {
    USER(-2),
    INHERIT(-1),
    NORMAL(0),
    LARGE(1),
    XLARGE(2),
    XXLARGE(3),
    HUGE(4),
    XHUGE(5),
    XXHUGE(6),
    SMALL(7),
    FOOTNOTE(8),
    SCRIPT(9),
    TINY(10),
    SMALLER(11),
    LARGER(12);

    private final int id;

    private TeXFontSize(int n2) {
        this.id = n2;
    }

    public int getValue() {
        return this.id;
    }

    public double deriveSize(int n) {
        if (this.id <= 0) {
            return n;
        }
        if (n == 10) {
            switch (this) {
                case SMALL: {
                    return 9.0;
                }
                case FOOTNOTE: {
                    return 8.0;
                }
                case SCRIPT: {
                    return 7.0;
                }
                case TINY: {
                    return 5.0;
                }
                case LARGE: {
                    return 12.0;
                }
                case XLARGE: {
                    return 14.0;
                }
                case XXLARGE: {
                    return 17.0;
                }
                case HUGE: {
                    return 20.0;
                }
                case XHUGE: {
                    return 25.0;
                }
                case XXHUGE: {
                    return 30.0;
                }
            }
        } else if (n == 11) {
            switch (this) {
                case SMALL: {
                    return 10.0;
                }
                case FOOTNOTE: {
                    return 9.0;
                }
                case SCRIPT: {
                    return 8.0;
                }
                case TINY: {
                    return 7.0;
                }
                case LARGE: {
                    return 14.0;
                }
                case XLARGE: {
                    return 18.0;
                }
                case XXLARGE: {
                    return 22.0;
                }
                case HUGE: {
                    return 25.0;
                }
                case XHUGE: {
                    return 30.0;
                }
                case XXHUGE: {
                    return 35.0;
                }
            }
        } else if (n == 12) {
            switch (this) {
                case SMALL: {
                    return 11.0;
                }
                case FOOTNOTE: {
                    return 10.0;
                }
                case SCRIPT: {
                    return 8.0;
                }
                case TINY: {
                    return 6.0;
                }
                case LARGE: {
                    return 18.0;
                }
                case XLARGE: {
                    return 22.0;
                }
                case XXLARGE: {
                    return 25.0;
                }
                case HUGE: {
                    return 30.0;
                }
                case XHUGE: {
                    return 24.0;
                }
                case XXHUGE: {
                    return 26.0;
                }
            }
        }
        switch (this) {
            case SMALL: {
                return Math.max(5.0, 0.8 * (double)n);
            }
            case FOOTNOTE: {
                return Math.max(5.0, 0.6 * (double)n);
            }
            case SCRIPT: {
                return Math.max(5.0, 0.5 * (double)n);
            }
            case TINY: {
                return Math.max(5.0, 0.3 * (double)n);
            }
            case LARGE: {
                return 1.2 * (double)n;
            }
            case XLARGE: {
                return 1.4 * (double)n;
            }
            case XXLARGE: {
                return 1.6 * (double)n;
            }
            case HUGE: {
                return 1.8 * (double)n;
            }
            case XHUGE: {
                return 2 * n;
            }
            case XXHUGE: {
                return 2.2 * (double)n;
            }
        }
        return n;
    }
}

