// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by ./generator. DO NOT EDIT.
package dynrpcserver

import (
	"context"
	"sync"

	stacks "github.com/hashicorp/terraform/internal/rpcapi/terraform1/stacks"
)

type Stacks struct {
	impl stacks.StacksServer
	mu   sync.RWMutex
}

var _ stacks.StacksServer = (*Stacks)(nil)

func NewStacksStub() *Stacks {
	return &Stacks{}
}

func (s *Stacks) ApplyStackChanges(a0 *stacks.ApplyStackChanges_Request, a1 stacks.Stacks_ApplyStackChangesServer) error {
	impl, err := s.realRPCServer()
	if err != nil {
		return err
	}
	return impl.ApplyStackChanges(a0, a1)
}

func (s *Stacks) ClosePlan(a0 context.Context, a1 *stacks.CloseStackPlan_Request) (*stacks.CloseStackPlan_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.ClosePlan(a0, a1)
}

func (s *Stacks) CloseStackConfiguration(a0 context.Context, a1 *stacks.CloseStackConfiguration_Request) (*stacks.CloseStackConfiguration_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.CloseStackConfiguration(a0, a1)
}

func (s *Stacks) CloseState(a0 context.Context, a1 *stacks.CloseStackState_Request) (*stacks.CloseStackState_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.CloseState(a0, a1)
}

func (s *Stacks) FindStackConfigurationComponents(a0 context.Context, a1 *stacks.FindStackConfigurationComponents_Request) (*stacks.FindStackConfigurationComponents_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.FindStackConfigurationComponents(a0, a1)
}

func (s *Stacks) InspectExpressionResult(a0 context.Context, a1 *stacks.InspectExpressionResult_Request) (*stacks.InspectExpressionResult_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.InspectExpressionResult(a0, a1)
}

func (s *Stacks) OpenPlan(a0 stacks.Stacks_OpenPlanServer) error {
	impl, err := s.realRPCServer()
	if err != nil {
		return err
	}
	return impl.OpenPlan(a0)
}

func (s *Stacks) OpenStackConfiguration(a0 context.Context, a1 *stacks.OpenStackConfiguration_Request) (*stacks.OpenStackConfiguration_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.OpenStackConfiguration(a0, a1)
}

func (s *Stacks) OpenStackInspector(a0 context.Context, a1 *stacks.OpenStackInspector_Request) (*stacks.OpenStackInspector_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.OpenStackInspector(a0, a1)
}

func (s *Stacks) OpenState(a0 stacks.Stacks_OpenStateServer) error {
	impl, err := s.realRPCServer()
	if err != nil {
		return err
	}
	return impl.OpenState(a0)
}

func (s *Stacks) PlanStackChanges(a0 *stacks.PlanStackChanges_Request, a1 stacks.Stacks_PlanStackChangesServer) error {
	impl, err := s.realRPCServer()
	if err != nil {
		return err
	}
	return impl.PlanStackChanges(a0, a1)
}

func (s *Stacks) ValidateStackConfiguration(a0 context.Context, a1 *stacks.ValidateStackConfiguration_Request) (*stacks.ValidateStackConfiguration_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.ValidateStackConfiguration(a0, a1)
}

func (s *Stacks) ActivateRPCServer(impl stacks.StacksServer) {
	s.mu.Lock()
	s.impl = impl
	s.mu.Unlock()
}

func (s *Stacks) realRPCServer() (stacks.StacksServer, error) {
	s.mu.RLock()
	impl := s.impl
	s.mu.RUnlock()
	if impl == nil {
		return nil, unavailableErr
	}
	return impl, nil
}
