/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef INC_COMMON_H
#define INC_COMMON_H

/* definitions */
#define MAX_PATH		1024

#define MAKEWORD(a, b)	((a & 0xff) | ((b & 0xff) << 8))
#define LOBYTE(w)		(w & 0xff)
#define HIBYTE(w)		(w >> 8)


/* check provileges */
int is_root();

/* reporting */
void error_report(char *format, ...);
void console_report(char *format, ...);

/* flag manipulation routines */
unsigned long flag_set(unsigned long *preg, unsigned long flag);
unsigned long flag_clear(unsigned long *preg, unsigned long flag);
bool flag_check(unsigned long reg, unsigned long flag);

long long flag_set(long long *preg, long long flag);
long long flag_clear(long long *preg, long long flag);
bool flag_check(long long reg, long long flag);


int create_pid_file(const char *filename);
int rem_pid_file(const char *filename);
int get_pid(const char *filename);
int signal_process(const char *pidfilename, int signal);
char *get_config_filepath(char *filename);
int wall_msg(const char *msg);
int wall_msg_cust(const char *msg, const char *welcome);

#endif /*INC_COMMON_H*/
