/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.ArrayList;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.Utils;

public class TextReporter
extends TestListenerAdapter {
    private final int m_verbose;
    private final String m_testName;

    public TextReporter(String string, int n) {
        this.m_testName = string;
        this.m_verbose = n;
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
        if (this.m_verbose >= 2) {
            this.logResults();
        }
    }

    private static List<ITestNGMethod> resultsToMethods(List<ITestResult> list) {
        ArrayList<ITestNGMethod> arrayList = new ArrayList<ITestNGMethod>(list.size());
        for (ITestResult iTestResult : list) {
            arrayList.add(iTestResult.getMethod());
        }
        return arrayList;
    }

    private void logResults() {
        String string;
        Throwable throwable;
        for (ITestResult comparable2 : this.getConfigurationFailures()) {
            throwable = comparable2.getThrowable();
            string = "";
            if (throwable != null && this.m_verbose >= 2) {
                string = Utils.shortStackTrace(throwable, false);
            }
            this.logResult("FAILED CONFIGURATION", Utils.detailedMethodName(comparable2.getMethod(), false), comparable2.getMethod().getDescription(), string, comparable2.getParameters(), comparable2.getMethod().getConstructorOrMethod().getParameterTypes());
        }
        for (ITestResult iTestResult : this.getConfigurationSkips()) {
            this.logResult("SKIPPED CONFIGURATION", Utils.detailedMethodName(iTestResult.getMethod(), false), iTestResult.getMethod().getDescription(), null, iTestResult.getParameters(), iTestResult.getMethod().getConstructorOrMethod().getParameterTypes());
        }
        for (ITestResult iTestResult : this.getPassedTests()) {
            this.logResult("PASSED", iTestResult, null);
        }
        for (ITestResult iTestResult : this.getFailedTests()) {
            throwable = iTestResult.getThrowable();
            string = "";
            if (throwable != null && this.m_verbose >= 2) {
                string = Utils.shortStackTrace(throwable, false);
            }
            this.logResult("FAILED", iTestResult, string);
        }
        Object object = this.getSkippedTests().iterator();
        while (object.hasNext()) {
            ITestResult iTestResult;
            throwable = (iTestResult = object.next()).getThrowable();
            this.logResult("SKIPPED", iTestResult, throwable != null ? Utils.shortStackTrace(throwable, false) : null);
        }
        object = TextReporter.resultsToMethods(this.getFailedTests());
        StringBuilder stringBuilder = new StringBuilder("\n===============================================\n");
        stringBuilder.append("    ").append(this.m_testName).append("\n");
        stringBuilder.append("    Tests run: ").append(Utils.calculateInvokedMethodCount(this.getAllTestMethods())).append(", Failures: ").append(Utils.calculateInvokedMethodCount((List<ITestNGMethod>)object)).append(", Skips: ").append(Utils.calculateInvokedMethodCount(TextReporter.resultsToMethods(this.getSkippedTests())));
        int n = this.getConfigurationFailures().size();
        int n2 = this.getConfigurationSkips().size();
        if (n > 0 || n2 > 0) {
            stringBuilder.append("\n").append("    Configuration Failures: ").append(n).append(", Skips: ").append(n2);
        }
        stringBuilder.append("\n===============================================\n");
        this.logResult("", stringBuilder.toString());
    }

    private void logResult(String string, ITestResult iTestResult, String string2) {
        this.logResult(string, iTestResult.getName(), iTestResult.getMethod().getDescription(), string2, iTestResult.getParameters(), iTestResult.getMethod().getConstructorOrMethod().getParameterTypes());
    }

    private void logResult(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Utils.isStringNotBlank(string)) {
            stringBuilder.append(string).append(": ");
        }
        stringBuilder.append(string2);
        System.out.println(stringBuilder);
    }

    private void logResult(String string, String string2, String string3, String string4, Object[] objectArray, Class<?>[] classArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (null != objectArray && objectArray.length > 0) {
            stringBuilder.append("(");
            if (objectArray.length != classArray.length) {
                stringBuilder.append(string2).append(": Wrong number of arguments were passed by ").append("the Data Provider: found ").append(objectArray.length).append(" but ").append("expected ").append(classArray.length).append(")");
            } else {
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(Utils.toString(objectArray[n], classArray[n]));
                }
                stringBuilder.append(")");
            }
        }
        if (!Utils.isStringEmpty(string3)) {
            stringBuilder.append("\n");
            for (n = 0; n < string.length() + 2; ++n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string3);
        }
        if (!Utils.isStringEmpty(string4)) {
            stringBuilder.append("\n").append(string4);
        }
        this.logResult(string, stringBuilder.toString());
    }
}

