searchData={"items":[{"type":"module","title":"epp_dodger","doc":"Bypassing the Erlang preprocessor.\n\nThis module tokenises and parses most Erlang source code without expanding\npreprocessor directives and macro applications, as long as these are\nsyntactically \"well-behaved\". Because the normal parse trees of the `erl_parse`\nmodule cannot represent these things (normally, they are expanded by the Erlang\npreprocessor [`//stdlib/epp`](`m:epp`) before the parser sees them), an extended\nsyntax tree is created, using the `m:erl_syntax` module.","ref":"epp_dodger.html"},{"type":"type","title":"epp_dodger.errorinfo/0","doc":"","ref":"epp_dodger.html#t:errorinfo/0"},{"type":"type","title":"epp_dodger.option/0","doc":"","ref":"epp_dodger.html#t:option/0"},{"type":"function","title":"epp_dodger.parse/1","doc":"","ref":"epp_dodger.html#parse/1"},{"type":"function","title":"epp_dodger.parse/2","doc":"","ref":"epp_dodger.html#parse/2"},{"type":"function","title":"epp_dodger.parse/3","doc":"Reads and parses program text from an I/O stream.\n\nCharacters are read from `IODevice` until end-of-file; apart from\nthis, the behavior is the same as for `parse_file/2`. `StartLocation`\nis the initial location.\n\n_See also: _`parse/2`, `parse_file/2`, `parse_form/2`, `quick_parse/3`.","ref":"epp_dodger.html#parse/3"},{"type":"function","title":"epp_dodger.parse_file/1","doc":"","ref":"epp_dodger.html#parse_file/1"},{"type":"function","title":"epp_dodger.parse_file/2","doc":"Reads and parses a file.\n\nIf successful, `{ok, Forms}` is returned, where `Forms` is a list of\nabstract syntax trees representing the \"program forms\" of the file\n(see `erl_syntax:is_form/1`). Otherwise, `{error, errorinfo()}` is\nreturned, typically if the file could not be opened. Note that parse\nerrors show up as error markers in the returned list of forms; they do\nnot cause this function to fail or return `{error, errorinfo()}`.\n\nOptions:\n\n- **`{no_fail, boolean()}`** - If `true`, this makes `epp_dodger` replace any\n  program forms that could not be parsed with nodes of type `text` (see\n  `erl_syntax:text/1`), representing the raw token sequence of the form, instead\n  of reporting a parse error. The default value is `false`.\n\n- **`{clever, boolean()}`** - If set to `true`, this makes `epp_dodger` try to\n  repair the source code as it seems fit, in certain cases where parsing would\n  otherwise fail. Currently, it inserts `++` operators between string literals\n  and macros where it looks like concatenation was intended. The default value\n  is `false`.\n\n_See also: _`parse/2`, `quick_parse_file/1`, `erl_syntax:is_form/1`.","ref":"epp_dodger.html#parse_file/2"},{"type":"function","title":"epp_dodger.parse_form/2","doc":"","ref":"epp_dodger.html#parse_form/2"},{"type":"function","title":"epp_dodger.parse_form/3","doc":"Reads and parses a single program form from an I/O stream.\n\nCharacters are read from `IODevice` until an end-of-form marker is\nfound (a period character followed by whitespace), or until\nend-of-file; apart from this, the behavior is similar to that of\n[`parse/3`](`parse/3`), except that the return values also contain the\nfinal location given that `StartLocation` is the initial location, and\nthat `{eof, Location}` may be returned.\n\n_See also: _`parse/3`, `parse_form/2`, `quick_parse_form/3`.","ref":"epp_dodger.html#parse_form/3"},{"type":"function","title":"epp_dodger.quick_parse/1","doc":"","ref":"epp_dodger.html#quick_parse/1"},{"type":"function","title":"epp_dodger.quick_parse/2","doc":"","ref":"epp_dodger.html#quick_parse/2"},{"type":"function","title":"epp_dodger.quick_parse/3","doc":"Similar to `parse/3`, but does a more quick-and-dirty processing of the code.\n\nSee `quick_parse_file/2` for details.\n\n_See also: _`parse/3`, `quick_parse/2`, `quick_parse_file/2`,\n`quick_parse_form/2`.","ref":"epp_dodger.html#quick_parse/3"},{"type":"function","title":"epp_dodger.quick_parse_file/1","doc":"","ref":"epp_dodger.html#quick_parse_file/1"},{"type":"function","title":"epp_dodger.quick_parse_file/2","doc":"Similar to `parse_file/2`, but does a more quick-and-dirty processing of the\ncode.\n\nMacro definitions and other preprocessor directives are discarded, and all\nmacro calls are replaced with atoms. This is useful when only the main structure\nof the code is of interest, and not the details. Furthermore, the quick-parse\nmethod can usually handle more strange cases than the normal, more exact\nparsing.\n\nOptions: see `parse_file/2`. However, note that for\n[`quick_parse_file/2`](`quick_parse_file/2`), the option `no_fail` is `true` by\ndefault.\n\n_See also: _`parse_file/2`, `quick_parse/2`.","ref":"epp_dodger.html#quick_parse_file/2"},{"type":"function","title":"epp_dodger.quick_parse_form/2","doc":"","ref":"epp_dodger.html#quick_parse_form/2"},{"type":"function","title":"epp_dodger.quick_parse_form/3","doc":"Similar to `parse_form/3`, but does a more quick-and-dirty processing of the\ncode. See `quick_parse_file/2` for details.\n\n_See also: _`parse/3`, `parse_form/3`, `quick_parse_form/2`.","ref":"epp_dodger.html#quick_parse_form/3"},{"type":"function","title":"epp_dodger.tokens_to_string/1","doc":"Generates a string corresponding to the given token sequence.\n\nThe string can be re-tokenized to yield the same token list again.","ref":"epp_dodger.html#tokens_to_string/1"},{"type":"module","title":"erl_comment_scan","doc":"Functions for reading comment lines from Erlang source code.","ref":"erl_comment_scan.html"},{"type":"type","title":"erl_comment_scan.comment/0","doc":"","ref":"erl_comment_scan.html#t:comment/0"},{"type":"type","title":"erl_comment_scan.commentLine/0","doc":"","ref":"erl_comment_scan.html#t:commentLine/0"},{"type":"function","title":"erl_comment_scan.file/1","doc":"Extracts comments from an Erlang source code file.\n\nReturns a list of entries representing _multi-line_ comments, listed\nin order of increasing line-numbers.  For each entry, `Text` is a list\nof strings representing the consecutive comment lines in top-down\norder; the strings contain _all_ characters following (but not\nincluding) the first comment-introducing `%` character on the line, up\nto (but not including) the line-terminating newline.\n\nFurthermore, `Line` is the line number and `Column` the left column of the\ncomment (that is, the column of the comment-introducing `%` character). `Indent` is\nthe indentation (or padding), measured in character positions between the last\nnon-whitespace character before the comment (or the left margin), and the left\ncolumn of the comment. `Line` and `Column` are always positive integers, and\n`Indentation` is a nonnegative integer.\n\nEvaluation exits with reason `{read, Reason}` if a read error occurred, where\n`Reason` is an atom corresponding to a Posix error code; see the module\n[`//kernel/file`](`m:file`) for details.","ref":"erl_comment_scan.html#file/1"},{"type":"function","title":"erl_comment_scan.join_lines/1","doc":"join_lines(CommentLines) ->\n\nJoins individual comment lines into multi-line comments.\n\nThe input is a list of entries representing individual comment lines,\n_in order of decreasing line-numbers_; see `scan_lines/1` for\ndetails. The result is a list of entries representing _multi-line_\ncomments, _still listed in order of decreasing line-numbers_, but\nwhere for each entry, `Text` is a list of consecutive comment lines in\norder of _increasing_ line-numbers (that is, top-down).\n\n_See also: _`scan_lines/1`.","ref":"erl_comment_scan.html#join_lines/1"},{"type":"function","title":"erl_comment_scan.scan_lines/1","doc":"Extracts individual comment lines from a source code string.\n\nReturns a list of comment lines found in the text, listed in order of\n_decreasing_ line-numbers, that is, the last comment line in the input\nis first in the resulting list. `Text` is a single string, containing\nall characters following (but not including) the first\ncomment-introducing `%` character on the line, up to (but not\nincluding) the line-terminating newline. For details on `Line`,\n`Column` and `Indent`, see `file/1`.","ref":"erl_comment_scan.html#scan_lines/1"},{"type":"function","title":"erl_comment_scan.string/1","doc":"Extracts comments from a string containing Erlang source code.\n\nExcept for reading directly from a string, the behavior is the same\nas for `file/1`.\n\n_See also: _`file/1`.","ref":"erl_comment_scan.html#string/1"},{"type":"module","title":"erl_prettypr","doc":"Pretty printing of abstract Erlang syntax trees.\n\nThis module is a front end to the pretty-printing library module `prettypr`, for\ntext formatting of abstract syntax trees defined by the module `erl_syntax`.","ref":"erl_prettypr.html"},{"type":"function","title":"erl_prettypr.best/1","doc":"","ref":"erl_prettypr.html#best/1"},{"type":"function","title":"erl_prettypr.best/2","doc":"Creates a fixed \"best\" abstract layout for a syntax tree.\n\nThis is similar to the [`layout/2`](`layout/2`) function, except that\nhere, the final layout has been selected with respect to the given\noptions. The atom `empty` is returned if no such layout could be\nproduced. For information on the options, see the\n[`format/2`](`format/2`) function.\n\n_See also: _`best/1`, `format/2`, `layout/2`, `prettypr:best/3`.","ref":"erl_prettypr.html#best/2"},{"type":"type","title":"erl_prettypr.clause_t/0","doc":"","ref":"erl_prettypr.html#t:clause_t/0"},{"type":"type","title":"erl_prettypr.context/0","doc":"","ref":"erl_prettypr.html#t:context/0"},{"type":"function","title":"erl_prettypr.format/1","doc":"","ref":"erl_prettypr.html#format/1"},{"type":"function","title":"erl_prettypr.format/2","doc":"Prettyprint-formats an abstract Erlang syntax tree as text.\n\nFor example, if you have a `.beam` file that has been compiled with\n`debug_info`, the following should print the source code for the\nmodule (as it looks in the debug info representation):\n\n```text\n     {ok,{_,[{abstract_code,{_,AC}}]}} =\n             beam_lib:chunks(\"myfile.beam\",[abstract_code]),\n     io:put_chars(erl_prettypr:format(erl_syntax:form_list(AC)))\n```\n\nAvailable options:\n\n- **`{hook, none | hook()}`** - Unless the value is `none`, the\n  given function is called for each node whose list of annotations is\n  not empty. The default value is `none`.\n\n- **`{paper, integer()}`** - Specifies the preferred maximum number of\n  characters on any line, including indentation. The default value is 80.\n\n- **`{ribbon, integer()}`** - Specifies the preferred maximum number of\n  characters on any line, not counting indentation. The default value is 65.\n\n- **`{user, term()}`** - User-specific data for use in hook functions. The\n  default value is `undefined`.\n\n- **`{encoding, epp:source_encoding()}`** - Specifies the encoding of the\n  generated file.\n\nA hook function (see the [`hook()`](`t:hook/0`) type) is passed the current\nsyntax tree node, the context, and a continuation. The context can be examined\nand manipulated by functions such as [`get_ctxt_user/1`](`get_ctxt_user/1`) and\n[`set_ctxt_user/2`](`set_ctxt_user/2`). The hook must return a \"document\" data\nstructure (see `layout/2` and `best/2`); this may be constructed in part or in\nwhole by applying the continuation function. For example, the following is a\ntrivial hook:\n\n```text\n      fun (Node, Ctxt, Cont) -> Cont(Node, Ctxt) end\n```\n\nwhich yields the same result as if no hook was given. The following, however:\n\n```text\n      fun (Node, Ctxt, Cont) ->\n          Doc = Cont(Node, Ctxt),\n          prettypr:beside(prettypr:text(\" \"),\n                          prettypr:beside(Doc,\n                                          prettypr:text(\" \")))\n      end\n```\n\nwill place the text of any annotated node (regardless of the annotation data)\nbetween HTML \"boldface begin\" and \"boldface end\" tags.\n\n_See also: _`m:erl_syntax`, `best/2`, `format/1`, `get_ctxt_user/1`, `layout/2`,\n`set_ctxt_user/2`.","ref":"erl_prettypr.html#format/2"},{"type":"function","title":"erl_prettypr.get_ctxt_hook/1","doc":"Returns the hook function field of the prettyprinter context.\n\n_See also: _`set_ctxt_hook/2`.","ref":"erl_prettypr.html#get_ctxt_hook/1"},{"type":"function","title":"erl_prettypr.get_ctxt_linewidth/1","doc":"Returns the line widh field of the prettyprinter context.\n\n_See also: _`set_ctxt_linewidth/2`.","ref":"erl_prettypr.html#get_ctxt_linewidth/1"},{"type":"function","title":"erl_prettypr.get_ctxt_paperwidth/1","doc":"Returns the paper widh field of the prettyprinter context.\n\n_See also: _`set_ctxt_paperwidth/2`.","ref":"erl_prettypr.html#get_ctxt_paperwidth/1"},{"type":"function","title":"erl_prettypr.get_ctxt_precedence/1","doc":"Returns the operator precedence field of the prettyprinter context.\n\n_See also: _`set_ctxt_precedence/2`.","ref":"erl_prettypr.html#get_ctxt_precedence/1"},{"type":"function","title":"erl_prettypr.get_ctxt_user/1","doc":"Returns the user data field of the prettyprinter context.\n\n_See also: _`set_ctxt_user/2`.","ref":"erl_prettypr.html#get_ctxt_user/1"},{"type":"type","title":"erl_prettypr.hook/0","doc":"","ref":"erl_prettypr.html#t:hook/0"},{"type":"function","title":"erl_prettypr.layout/1","doc":"","ref":"erl_prettypr.html#layout/1"},{"type":"function","title":"erl_prettypr.layout/2","doc":"Creates an abstract document layout for a syntax tree.\n\nThe result represents a set of possible layouts (see module\n`m:prettypr`). For information on the options, see `format/2`;\nhowever, note that the `paper` and `ribbon` options are ignored by\nthis function.\n\nThis function provides a low-level interface to the pretty printer, returning a\nflexible representation of possible layouts, independent of the paper width\neventually to be used for formatting. This can be included as part of another\ndocument and/or further processed directly by the functions in the `prettypr`\nmodule, or used in a hook function (see [`format/2`](`format/2`) for details).\n\n_See also: _`m:prettypr`, `format/2`, `layout/1`.","ref":"erl_prettypr.html#layout/2"},{"type":"function","title":"erl_prettypr.set_ctxt_hook/2","doc":"Updates the hook function field of the prettyprinter context.\n\n_See also: _`get_ctxt_hook/1`.","ref":"erl_prettypr.html#set_ctxt_hook/2"},{"type":"function","title":"erl_prettypr.set_ctxt_linewidth/2","doc":"Updates the line widh field of the prettyprinter context.\n\n> #### Note {: .info }\n>\n> Changing this value (and passing the resulting context to a\n> continuation function) does not affect the normal formatting, but may\n> affect user-defined behaviour in hook functions.\n\n_See also: _`get_ctxt_linewidth/1`.","ref":"erl_prettypr.html#set_ctxt_linewidth/2"},{"type":"function","title":"erl_prettypr.set_ctxt_paperwidth/2","doc":"Updates the paper widh field of the prettyprinter context.\n\n> #### Note {: .info }\n>\n> Changing this value (and passing the resulting context to a\n> continuation function) does not affect the normal formatting, but may\n> affect user-defined behaviour in hook functions.\n\n_See also: _`get_ctxt_paperwidth/1`.","ref":"erl_prettypr.html#set_ctxt_paperwidth/2"},{"type":"function","title":"erl_prettypr.set_ctxt_precedence/2","doc":"Updates the operator precedence field of the prettyprinter context.\n\nSee the [`//stdlib/erl_parse`](`m:erl_parse`) module for operator\nprecedences.\n\n_See also: _[//stdlib/erl_parse](`m:erl_parse`), `get_ctxt_precedence/1`.","ref":"erl_prettypr.html#set_ctxt_precedence/2"},{"type":"function","title":"erl_prettypr.set_ctxt_user/2","doc":"Updates the user data field of the prettyprinter context.\n\n_See also: _`get_ctxt_user/1`.","ref":"erl_prettypr.html#set_ctxt_user/2"},{"type":"type","title":"erl_prettypr.syntaxTree/0","doc":"An abstract syntax tree.\n\nSee the `m:erl_syntax` module for details.","ref":"erl_prettypr.html#t:syntaxTree/0"},{"type":"module","title":"erl_recomment","doc":"Inserting comments into abstract Erlang syntax trees\n\nThis module contains functions for inserting comments, described by position,\nindentation and text, as attachments on an abstract syntax tree, at the correct\nplaces.","ref":"erl_recomment.html"},{"type":"function","title":"erl_recomment.quick_recomment_forms/2","doc":"Like `recomment_forms/2`, but only inserts top-level comments.\n\nComments within function definitions or declarations (\"forms\") are\nsimply ignored.","ref":"erl_recomment.html#quick_recomment_forms/2"},{"type":"function","title":"erl_recomment.recomment_forms/2","doc":"Attaches comments to the syntax tree/trees representing a program.\n\nThe given `Forms` should be a single syntax tree of type `form_list`,\nor a list of syntax trees representing \"program forms\". The syntax\ntrees must contain valid position information (for details, see\n[`recomment_tree/2`](`recomment_tree/2`)). The result is a\ncorresponding syntax tree of type `form_list` in which all comments in\nthe list `Comments` have been attached at the proper places.\n\nAssuming `Forms` represents a program (or any sequence of \"program forms\"), any\ncomments whose first lines are not directly associated with a specific program\nform will become standalone comments inserted between the neighbouring program\nforms. Furthermore, comments whose column position is less than or equal to one\nwill not be attached to a program form that begins at a conflicting line number\n(this can happen with preprocessor-generated `line`\\-attributes).\n\nIf `Forms` is a syntax tree of some other type than `form_list`, the comments\nwill be inserted directly using [`recomment_tree/2`](`recomment_tree/2`), and\nany comments left over from that process are added as postcomments on the\nresult.\n\nEntries in `Comments` represent multi-line comments. For each entry, `Line` is\nthe line number and `Column` the left column of the comment (the column of the\nfirst comment-introducing \"`%`\" character). `Indentation` is the number of\ncharacter positions between the last non-whitespace character before the comment\n(or the left margin) and the left column of the comment. `Text` is a list of\nstrings representing the consecutive comment lines in top-down order, where each\nstring contains all characters following (but not including) the\ncomment-introducing \"`%`\" and up to (but not including) the terminating newline.\n(see module `m:erl_comment_scan`.)\n\nEvaluation exits with reason `{bad_position, Pos}` if the associated position\ninformation `Pos` of some subtree in the input does not have a recognizable\nformat, or with reason `{bad_tree, L, C}` if insertion of a comment at line `L`,\ncolumn `C`, fails because the tree structure is ill-formed.\n\n_See also: _`m:erl_comment_scan`, `quick_recomment_forms/2`, `recomment_tree/2`.","ref":"erl_recomment.html#recomment_forms/2"},{"type":"function","title":"erl_recomment.recomment_tree/2","doc":"Attaches comments to a syntax tree.\n\nThe result is a pair `{NewTree, Remainder}` where `NewTree` is the\ngiven `Tree` where comments from the list `Comments` have been\nattached at the proper places. `Remainder` is the list of entries in\n`Comments` which have not been inserted, because their line numbers\nare greater than those of any node in the tree. The entries in\n`Comments` are inserted in order; if two comments become attached to\nthe same node, they will appear in the same order in the program text.\n\nThe nodes of the syntax tree must contain valid position information. This can\nbe single integers, assumed to represent a line number, or 2- or 3-tuples where\nthe first or second element is an integer, in which case the leftmost integer\nelement is assumed to represent the line number. Line numbers less than one are\nignored (usually, the default line number for newly created nodes is zero).\n\nFor details on the `Line`, `Column` and `Indentation` fields, and the behaviour\nin case of errors, see [`recomment_forms/2`](`recomment_forms/2`).\n\n_See also: _`recomment_forms/2`.","ref":"erl_recomment.html#recomment_tree/2"},{"type":"type","title":"erl_recomment.syntaxTree/0","doc":"An abstract syntax tree. See the `m:erl_syntax` module for details.","ref":"erl_recomment.html#t:syntaxTree/0"},{"type":"module","title":"erl_syntax","doc":"Abstract Erlang syntax trees.\n\nThis module defines an abstract data type for representing Erlang source code as\nsyntax trees, in a way that is backwards compatible with the data structures\ncreated by the Erlang standard library parser module `m:erl_parse` (often referred\nto as \"parse trees\", which is a bit of a misnomer). This means that all\n`erl_parse` trees are valid abstract syntax trees, but the reverse is not true:\nabstract syntax trees can in general not be used as input to functions expecting\nan `erl_parse` tree. However, as long as an abstract syntax tree represents a\ncorrect Erlang program, the function `revert/1` should be able to transform it\nto the corresponding `erl_parse` representation.\n\nA recommended starting point for the first-time user is the documentation of the\n[`syntaxTree()`](`t:syntaxTree/0`) data type, and the function `type/1`.\n\n> #### Note {: .info }\n>\n> This module deals with the composition and decomposition of _syntactic_ entities\n> (as opposed to semantic ones); its purpose is to hide all direct references to\n> the data structures used to represent these entities. With few exceptions, the\n> functions in this module perform no semantic interpretation of their inputs, and\n> in general, the user is assumed to pass type-correct arguments — if this is not\n> done, the effects are not defined.\n\nWith the exception of the [`erl_parse()`](`t:erl_parse/0`) data structures, the\ninternal representations of abstract syntax trees are subject to change without\nnotice, and should not be documented outside this module. Furthermore, we do not\ngive any guarantees on how an abstract syntax tree may or may not be\nrepresented, _with the following exceptions_: no syntax tree is represented by a\nsingle atom, such as `none`, by a list constructor `[X | Y]`, or by the empty\nlist `[]`. This can be relied on when writing functions that operate on syntax\ntrees.","ref":"erl_syntax.html"},{"type":"function","title":"erl_syntax./0","doc":"Creates an abstract empty list.\n\nThe result represents \"`[]`\". The empty list is traditionally called\n\"nil\".\n\n_See also: _`is_list_skeleton/1`, `list/2`.","ref":"erl_syntax.html#nil/0"},{"type":"function","title":"erl_syntax.abstract/1","doc":"Returns the syntax tree corresponding to an Erlang term.\n\n`Term` must be a literal term, meaning one that can be represented as a\nsource code literal. Thus, it must not contain a process identifier,\nport, reference, or function value as a subterm. The function\nrecognises printable strings, in order to get a compact and readable\nrepresentation. Evaluation fails with reason `badarg` if `Term` is not\na literal term.\n\n_See also: _`concrete/1`, `is_literal/1`.","ref":"erl_syntax.html#abstract/1"},{"type":"function","title":"erl_syntax.add_ann/2","doc":"Appends the term `Annotation` to the list of user annotations of `Node`.\n\nNote: this is equivalent to\n[`set_ann(Node, [Annotation | get_ann(Node)])`](`set_ann/2`), but potentially\nmore efficient.\n\n_See also: _`get_ann/1`, `set_ann/2`.","ref":"erl_syntax.html#add_ann/2"},{"type":"function","title":"erl_syntax.add_postcomments/2","doc":"Appends `Comments` to the post-comments of `Node`.\n\nNote: This is equivalent to\n[`set_postcomments(Node, get_postcomments(Node) ++ Comments)`](`set_postcomments/2`),\nbut potentially more efficient.\n\n_See also: _`add_precomments/2`, `comment/2`, `get_postcomments/1`,\n`join_comments/2`, `set_postcomments/2`.","ref":"erl_syntax.html#add_postcomments/2"},{"type":"function","title":"erl_syntax.add_precomments/2","doc":"Appends `Comments` to the pre-comments of `Node`.\n\nNote: This is equivalent to\n[`set_precomments(Node, get_precomments(Node) ++ Comments)`](`set_precomments/2`),\nbut potentially more efficient.\n\n_See also: _`add_postcomments/2`, `comment/2`, `get_precomments/1`,\n`join_comments/2`, `set_precomments/2`.","ref":"erl_syntax.html#add_precomments/2"},{"type":"function","title":"erl_syntax.annotated_type/2","doc":"Creates an abstract annotated type expression.\n\nThe result represents \"`Name :: Type`\".\n\n_See also: _`annotated_type_body/1`, `annotated_type_name/1`.","ref":"erl_syntax.html#annotated_type/2"},{"type":"function","title":"erl_syntax.annotated_type_body/1","doc":"Returns the type subtrees of an `annotated_type` node.\n\n_See also: _`annotated_type/2`.","ref":"erl_syntax.html#annotated_type_body/1"},{"type":"function","title":"erl_syntax.annotated_type_name/1","doc":"Returns the name subtree of an `annotated_type` node.\n\n_See also: _`annotated_type/2`.","ref":"erl_syntax.html#annotated_type_name/1"},{"type":"type","title":"erl_syntax.annotation_or_location/0","doc":"","ref":"erl_syntax.html#t:annotation_or_location/0"},{"type":"function","title":"erl_syntax.application/2","doc":"Creates an abstract function application expression.\n\nIf `Arguments` is `[A1, ..., An]`, the result represents\n\"`Operator(A1, ..., An)`\".\n\n_See also: _`application/3`, `application_arguments/1`,\n`application_operator/1`.","ref":"erl_syntax.html#application/2"},{"type":"function","title":"erl_syntax.application/3","doc":"Creates an abstract function application expression.\n\nIf `Module` is `none`, this is call is equivalent to\n[`application(Function, Arguments)`](`application/2`), otherwise it is\nequivalent to [`application(module_qualifier(Module, Function),\nArguments)`](`application/2`).\n\n(This is a utility function.)\n\n_See also: _`application/2`, `module_qualifier/2`.","ref":"erl_syntax.html#application/3"},{"type":"function","title":"erl_syntax.application_arguments/1","doc":"Returns the list of argument subtrees of an `application` node.\n\n_See also: _`application/2`.","ref":"erl_syntax.html#application_arguments/1"},{"type":"function","title":"erl_syntax.application_operator/1","doc":"Returns the operator subtree of an `application` node.\n\nIf `Node` represents \"`M:F(...)`\", then the result is the subtree\nrepresenting \"`M:F`\".\n\n_See also: _`application/2`, `module_qualifier/2`.","ref":"erl_syntax.html#application_operator/1"},{"type":"function","title":"erl_syntax.arity_qualifier/2","doc":"Creates an abstract arity qualifier.\n\nThe result represents \"`Body/Arity`\".\n\n_See also: _`arity_qualifier_argument/1`, `arity_qualifier_body/1`.","ref":"erl_syntax.html#arity_qualifier/2"},{"type":"function","title":"erl_syntax.arity_qualifier_argument/1","doc":"Returns the argument (the arity) subtree of an `arity_qualifier` node.\n\n_See also: _`arity_qualifier/2`.","ref":"erl_syntax.html#arity_qualifier_argument/1"},{"type":"function","title":"erl_syntax.arity_qualifier_body/1","doc":"Returns the body subtree of an `arity_qualifier` node.\n\n_See also: _`arity_qualifier/2`.","ref":"erl_syntax.html#arity_qualifier_body/1"},{"type":"function","title":"erl_syntax.atom/1","doc":"Creates an abstract atom literal.\n\nThe print name of the atom is the character sequence represented by\n`Name`.\n\n_See also: _`atom_literal/1`, `atom_literal/2`, `atom_name/1`, `atom_value/1`,\n`is_atom/2`.","ref":"erl_syntax.html#atom/1"},{"type":"function","title":"erl_syntax.atom_literal/1","doc":"Returns the literal string represented by an `atom` node.\n\nThis includes surrounding single-quote characters if\nnecessary. Characters beyond 255 will be escaped.\n\nNote that, for example, the result of [`atom(\"x\\ny\")`](`atom/1`)\nrepresents any and all of `'x\\ny'`, `'x\\12y'`, `'x\\012y'`, and\n`'x\\^Jy'`; see `string/1`.\n\n_See also: _`atom/1`, `string/1`.","ref":"erl_syntax.html#atom_literal/1"},{"type":"function","title":"erl_syntax.atom_literal/2","doc":"Returns the literal string represented by an `atom` node.\n\nThis includes surrounding single-quote characters if\nnecessary. Depending on the encoding a character beyond 255 will be\nescaped (`latin1`) or copied as is (`utf8`).\n\n_See also: _`atom/1`, `atom_literal/1`, `string/1`.","ref":"erl_syntax.html#atom_literal/2"},{"type":"function","title":"erl_syntax.atom_name/1","doc":"Returns the printname of an `atom` node.\n\n_See also: _`atom/1`.","ref":"erl_syntax.html#atom_name/1"},{"type":"function","title":"erl_syntax.atom_value/1","doc":"Returns the value represented by an `atom` node.\n\n_See also: _`atom/1`.","ref":"erl_syntax.html#atom_value/1"},{"type":"function","title":"erl_syntax.attribute/1","doc":"","ref":"erl_syntax.html#attribute/1"},{"type":"function","title":"erl_syntax.attribute/2","doc":"Creates an abstract program attribute.\n\nIf `Arguments` is `[A1, ..., An]`, the result represents\n\"`-Name(A1, ..., An).`\". Otherwise, if `Arguments` is `none`,\nthe result represents \"`-Name.`\". The latter form makes it possible\nto represent preprocessor directives such as \"`-endif.`\". Attributes\nare source code forms.\n\n> #### Note {: .info }\n>\n> The preprocessor macro definition directive \"`-define(Name, Body).`\"\n> has relatively few requirements on the syntactical form of `Body`\n> (viewed as a sequence of tokens). The `text` node type can be used for\n> a `Body` that is not a normal Erlang construct.\n\n_See also: _`attribute/1`, `attribute_arguments/1`, `attribute_name/1`,\n`is_form/1`, `text/1`.","ref":"erl_syntax.html#attribute/2"},{"type":"function","title":"erl_syntax.attribute_arguments/1","doc":"Returns the list of argument subtrees of an `attribute` node, if any.\n\nIf `Node` represents \"`-Name.`\", the result is `none`. Otherwise, if\n`Node` represents \"`-Name(E1, ..., En).`\", `[E1, ..., E1]` is\nreturned.\n\n_See also: _`attribute/1`.","ref":"erl_syntax.html#attribute_arguments/1"},{"type":"function","title":"erl_syntax.attribute_name/1","doc":"Returns the name subtree of an `attribute` node.\n\n_See also: _`attribute/1`.","ref":"erl_syntax.html#attribute_name/1"},{"type":"function","title":"erl_syntax.binary/1","doc":"Creates an abstract binary-object template.\n\nIf `Fields` is `[F1, ..., Fn]`, the result represents \"`< >`\".\n\n_See also: _`binary_field/2`, `binary_fields/1`.","ref":"erl_syntax.html#binary/1"},{"type":"function","title":"erl_syntax.binary_comp/2","doc":"Creates an abstract binary comprehension.\n\nIf `Body` is `[E1, ..., En]`, the result represents \"`< >`\".\n\n_See also: _`binary_comp_body/1`, `binary_comp_template/1`, `generator/2`.","ref":"erl_syntax.html#binary_comp/2"},{"type":"function","title":"erl_syntax.binary_comp_body/1","doc":"Returns the list of body subtrees of a `binary_comp` node.\n\n_See also: _`binary_comp/2`.","ref":"erl_syntax.html#binary_comp_body/1"},{"type":"function","title":"erl_syntax.binary_comp_template/1","doc":"Returns the template subtree of a `binary_comp` node.\n\n_See also: _`binary_comp/2`.","ref":"erl_syntax.html#binary_comp_template/1"},{"type":"function","title":"erl_syntax.binary_field/1","doc":"","ref":"erl_syntax.html#binary_field/1"},{"type":"function","title":"erl_syntax.binary_field/2","doc":"Creates an abstract binary template field.\n\nIf `Types` is the empty list, the result simply represents\n\"`Body`\", otherwise, if `Types` is `[T1, ..., Tn]`, the result\nrepresents \"`Body/T1-...-Tn`\".\n\n_See also: _`binary/1`, `binary_field/1`, `binary_field/3`,\n`binary_field_body/1`, `binary_field_size/1`, `binary_field_types/1`.","ref":"erl_syntax.html#binary_field/2"},{"type":"function","title":"erl_syntax.binary_field/3","doc":"Creates an abstract binary template field.\n\nIf `Size` is `none`, this is equivalent to \"[`binary_field(Body,\nTypes)`](`binary_field/2`)\", otherwise it is equivalent to\n\"[`binary_field(size_qualifier(Body, Size),\nTypes)`](`binary_field/2`)\".\n\n(This is a utility function.)\n\n_See also: _`binary/1`, `binary_field/2`, `size_qualifier/2`.","ref":"erl_syntax.html#binary_field/3"},{"type":"function","title":"erl_syntax.binary_field_body/1","doc":"Returns the body subtree of a `binary_field`.\n\n_See also: _`binary_field/2`.","ref":"erl_syntax.html#binary_field_body/1"},{"type":"function","title":"erl_syntax.binary_field_size/1","doc":"Returns the size specifier subtree of a `binary_field` node, if any.\n\nIf `Node` represents \"`Body:Size`\" or \"`Body:Size/T1, ...,\nTn`\", the result is `Size`, otherwise `none` is returned.\n\n(This is a utility function.)\n\n_See also: _`binary_field/2`, `binary_field/3`.","ref":"erl_syntax.html#binary_field_size/1"},{"type":"function","title":"erl_syntax.binary_field_types/1","doc":"Returns the list of type-specifier subtrees of a `binary_field` node.\n\nIf `Node` represents \"`.../T1, ..., Tn`\", the result is `[T1,\n..., Tn]`, otherwise the result is the empty list.\n\n_See also: _`binary_field/2`.","ref":"erl_syntax.html#binary_field_types/1"},{"type":"function","title":"erl_syntax.binary_fields/1","doc":"Returns the list of field subtrees of a `binary` node.\n\n_See also: _`binary/1`, `binary_field/2`.","ref":"erl_syntax.html#binary_fields/1"},{"type":"function","title":"erl_syntax.binary_generator/2","doc":"Creates an abstract binary_generator.\n\nThe result represents \"`Pattern <= Body`\".\n\n_See also: _`binary_comp/2`, `binary_generator_body/1`,\n`binary_generator_pattern/1`, `list_comp/2`, `map_comp/2`.","ref":"erl_syntax.html#binary_generator/2"},{"type":"function","title":"erl_syntax.binary_generator_body/1","doc":"Returns the body subtree of a `generator` node.\n\n_See also: _`binary_generator/2`.","ref":"erl_syntax.html#binary_generator_body/1"},{"type":"function","title":"erl_syntax.binary_generator_pattern/1","doc":"Returns the pattern subtree of a `generator` node.\n\n_See also: _`binary_generator/2`.","ref":"erl_syntax.html#binary_generator_pattern/1"},{"type":"function","title":"erl_syntax.bitstring_type/2","doc":"Creates an abstract bitstring type.\n\nThe result represents \"`<<_:M, _:_N>>`\".\n\n_See also: _`bitstring_type_m/1`, `bitstring_type_n/1`.","ref":"erl_syntax.html#bitstring_type/2"},{"type":"function","title":"erl_syntax.bitstring_type_m/1","doc":"Returns the number of start bits, `M`, of a `bitstring_type` node.\n\n_See also: _`bitstring_type/2`.","ref":"erl_syntax.html#bitstring_type_m/1"},{"type":"function","title":"erl_syntax.bitstring_type_n/1","doc":"Returns the segment size, `N`, of a `bitstring_type` node.\n\n_See also: _`bitstring_type/2`.","ref":"erl_syntax.html#bitstring_type_n/1"},{"type":"function","title":"erl_syntax.block_expr/1","doc":"Creates an abstract block expression.\n\nIf `Body` is `[B1, ..., Bn]`, the result represents \"`begin B1, ...,\nBn end`\".\n\n_See also: _`block_expr_body/1`.","ref":"erl_syntax.html#block_expr/1"},{"type":"function","title":"erl_syntax.block_expr_body/1","doc":"Returns the list of body subtrees of a `block_expr` node.\n\n_See also: _`block_expr/1`.","ref":"erl_syntax.html#block_expr_body/1"},{"type":"function","title":"erl_syntax.case_expr/2","doc":"Creates an abstract case-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`case\nArgument of C1; ...; Cn end`\". More exactly, if each `Ci`\nrepresents \"`(Pi) Gi -> Bi`\", then the result represents \"`case\nArgument of P1G1 -> B1; ...; PnGn -> Bn end`\".\n\n_See also: _`case_expr_argument/1`, `case_expr_clauses/1`, `clause/3`,\n`if_expr/1`.","ref":"erl_syntax.html#case_expr/2"},{"type":"function","title":"erl_syntax.case_expr_argument/1","doc":"Returns the argument subtree of a `case_expr` node.\n\n_See also: _`case_expr/2`.","ref":"erl_syntax.html#case_expr_argument/1"},{"type":"function","title":"erl_syntax.case_expr_clauses/1","doc":"Returns the list of clause subtrees of a `case_expr` node.\n\n_See also: _`case_expr/2`.","ref":"erl_syntax.html#case_expr_clauses/1"},{"type":"function","title":"erl_syntax.catch_expr/1","doc":"Creates an abstract catch-expression.\n\nThe result represents \"`catch Expr`\".\n\n_See also: _`catch_expr_body/1`.","ref":"erl_syntax.html#catch_expr/1"},{"type":"function","title":"erl_syntax.catch_expr_body/1","doc":"Returns the body subtree of a `catch_expr` node.\n\n_See also: _`catch_expr/1`.","ref":"erl_syntax.html#catch_expr_body/1"},{"type":"function","title":"erl_syntax.char/1","doc":"Creates an abstract character literal.\n\nThe result represents \"`$Name`\", where `Name` corresponds to `Value`.\n\n> #### Note {: .info }\n\nThe literal corresponding to a particular character value is not\nuniquely defined. For example, the character \"`a`\" can be written both\nas \"`$a`\" and \"`$\\141`\", and a Tab character can be written as\n\"`$\\11`\", \"`$\\011`\", or \"`$\\t`\".\n\n_See also: _`char_literal/1`, `char_literal/2`, `char_value/1`, `is_char/2`.","ref":"erl_syntax.html#char/1"},{"type":"function","title":"erl_syntax.char_literal/1","doc":"Returns the literal string represented by a `char` node.\n\nThis includes the leading \"`$`\" character. Characters beyond 255 will\nbe escaped.\n\n_See also: _`char/1`.","ref":"erl_syntax.html#char_literal/1"},{"type":"function","title":"erl_syntax.char_literal/2","doc":"Returns the literal string represented by a `char` node.\n\nThis includes the leading \"`$`\" character. Depending on the encoding a\ncharacter beyond 255 will be escaped (`latin1`) or copied as is\n(`utf8`).\n\n_See also: _`char/1`.","ref":"erl_syntax.html#char_literal/2"},{"type":"function","title":"erl_syntax.char_value/1","doc":"Returns the value represented by a `char` node.\n\n_See also: _`char/1`.","ref":"erl_syntax.html#char_value/1"},{"type":"function","title":"erl_syntax.class_qualifier/2","doc":"Creates an abstract class qualifier.\n\nThe result represents \"`Class:Body`\".\n\n_See also: _`class_qualifier_argument/1`, `class_qualifier_body/1`,\n`class_qualifier_stacktrace/1`, `try_expr/4`.","ref":"erl_syntax.html#class_qualifier/2"},{"type":"function","title":"erl_syntax.class_qualifier/3","doc":"Creates an abstract class qualifier.\n\nThe result represents \"`Class:Body:Stacktrace`\".\n\n_See also: _`class_qualifier_argument/1`, `class_qualifier_body/1`,\n`try_expr/4`.","ref":"erl_syntax.html#class_qualifier/3"},{"type":"function","title":"erl_syntax.class_qualifier_argument/1","doc":"Returns the argument (the class) subtree of a `class_qualifier` node.\n\n_See also: _`class_qualifier/2`.","ref":"erl_syntax.html#class_qualifier_argument/1"},{"type":"function","title":"erl_syntax.class_qualifier_body/1","doc":"Returns the body subtree of a `class_qualifier` node.\n\n_See also: _`class_qualifier/2`.","ref":"erl_syntax.html#class_qualifier_body/1"},{"type":"function","title":"erl_syntax.class_qualifier_stacktrace/1","doc":"Returns the stacktrace subtree of a `class_qualifier` node.\n\n_See also: _`class_qualifier/2`.","ref":"erl_syntax.html#class_qualifier_stacktrace/1"},{"type":"function","title":"erl_syntax.clause/2","doc":"","ref":"erl_syntax.html#clause/2"},{"type":"function","title":"erl_syntax.clause/3","doc":"Creates an abstract clause.\n\nIf `Patterns` is `[P1, ..., Pn]` and `Body` is `[B1, ..., Bm]`, then\nif `Guard` is `none`, the result represents \"`(P1, ..., Pn) ->\nB1, ..., Bm`\", otherwise, unless `Guard` is a list, the result\nrepresents \"`(P1, ..., Pn) when Guard -> B1, ..., Bm`\".\n\nFor simplicity, the `Guard` argument may also be any of the following:\n\n- An empty list `[]`. This is equivalent to passing `none`.\n- A nonempty list `[E1, ..., Ej]` of syntax trees. This is equivalent to passing\n  `conjunction([E1, ..., Ej])`.\n- A nonempty list of lists of syntax trees\n  `[[E1_1, ..., E1_k1], ..., [Ej_1, ..., Ej_kj]]`, which is equivalent to\n  passing\n  `disjunction([conjunction([E1_1, ..., E1_k1]), ..., conjunction([Ej_1, ..., Ej_kj])])`.\n\n_See also: _`clause/2`, `clause_body/1`, `clause_guard/1`, `clause_patterns/1`.","ref":"erl_syntax.html#clause/3"},{"type":"function","title":"erl_syntax.clause_body/1","doc":"Return the list of body subtrees of a `clause` node.\n\n_See also: _`clause/3`.","ref":"erl_syntax.html#clause_body/1"},{"type":"function","title":"erl_syntax.clause_guard/1","doc":"Returns the guard subtree of a `clause` node, if any.\n\nIf `Node` represents \"`(P1, ..., Pn) when Guard -> B1, ...,\nBm`\", `Guard` is returned.  Otherwise, the result is `none`.\n\n_See also: _`clause/3`.","ref":"erl_syntax.html#clause_guard/1"},{"type":"function","title":"erl_syntax.clause_patterns/1","doc":"Returns the list of pattern subtrees of a `clause` node.\n\n_See also: _`clause/3`.","ref":"erl_syntax.html#clause_patterns/1"},{"type":"function","title":"erl_syntax.comment/1","doc":"","ref":"erl_syntax.html#comment/1"},{"type":"function","title":"erl_syntax.comment/2","doc":"Creates an abstract comment with the given padding and text.\n\nIf `Strings` is a (possibly empty) list `[\"Txt1\", ..., \"TxtN\"]`,\nthe result represents the source code text\n\n```text\n     Txt1\n     ...\n     TxtN\n```\n\n`Padding` states the number of empty character positions to the left of the\ncomment separating it horizontally from source code on the same line (if any).\nIf `Padding` is `none`, a default positive number is used. If `Padding` is an\ninteger less than 1, there should be no separating space. Comments are in\nthemselves regarded as source program forms.\n\n_See also: _`comment/1`, `is_form/1`.","ref":"erl_syntax.html#comment/2"},{"type":"function","title":"erl_syntax.comment_padding/1","doc":"Returns the amount of padding before the comment, or `none`.\n\n`none` means that a default padding may be used.\n\n_See also: _`comment/2`.","ref":"erl_syntax.html#comment_padding/1"},{"type":"function","title":"erl_syntax.comment_text/1","doc":"Returns the lines of text of the abstract comment.\n\n_See also: _`comment/2`.","ref":"erl_syntax.html#comment_text/1"},{"type":"function","title":"erl_syntax.compact_list/1","doc":"Yields the most compact form for an abstract list skeleton.\n\nThe result either represents \"`[E1, ..., En | Tail]`\", where\n`Tail` is not a list skeleton, or otherwise simply \"`[E1, ...,\nEn]`\". Annotations on subtrees of `Node` that represent list\nskeletons may be lost, but comments will be propagated to the\nresult. Returns `Node` itself if `Node` does not represent a list\nskeleton.\n\n_See also: _`list/2`, `normalize_list/1`.","ref":"erl_syntax.html#compact_list/1"},{"type":"function","title":"erl_syntax.concrete/1","doc":"Returns the Erlang term represented by a syntax tree.\n\nEvaluation fails with reason `badarg` if `Node` does not represent a\nliteral term.\n\n> #### Note {: .info }\n>\n> The set of syntax trees which have a concrete representation is larger\n> than the set of trees which can be built using the function\n> `abstract/1`.  An abstract character will be concretised as an\n> integer, while `abstract/1` does not at present yield an abstract\n> character for any input. (Use the `char/1` function to explicitly\n> create an abstract character.)\n\n> #### Note {: .info }\n>\n> `arity_qualifier` nodes are recognized. This is to follow the Erlang\n> Parser when it comes to wild attributes: both `{F, A}` and `F/A` are\n> recognized, which makes it possible to turn wild attributes into\n> recognized attributes without at the same time making it impossible to\n> compile files using the new syntax with the old version of the Erlang\n> Compiler.\n\n_See also: _`abstract/1`, `char/1`, `is_literal/1`.","ref":"erl_syntax.html#concrete/1"},{"type":"function","title":"erl_syntax.conjunction/1","doc":"Creates an abstract conjunction.\n\nIf `List` is `[E1, ..., En]`, the result represents \"`E1, ..., En`\".\n\n_See also: _`conjunction_body/1`, `disjunction/1`.","ref":"erl_syntax.html#conjunction/1"},{"type":"function","title":"erl_syntax.conjunction_body/1","doc":"Returns the list of body subtrees of a `conjunction` node.\n\n_See also: _`conjunction/1`.","ref":"erl_syntax.html#conjunction_body/1"},{"type":"function","title":"erl_syntax.cons/2","doc":"\"Optimizing\" list skeleton cons operation.\n\nCreates an abstract list skeleton whose first element is `Head` and\nwhose tail corresponds to `Tail`. This is similar to [`list([Head],\nTail)`](`list/2`), except that `Tail` must not be `none`,\nand the result does not necessarily represent exactly \"`[Head | Tail]`\", but\nmay depend on the `Tail` subtree.\n\nFor example, if `Tail` represents `[X, Y]`, the result may represent\n\"`[Head, X, Y]`\", rather than \"`[Head | [X, Y]]`\". Annotations on\n`Tail` itself may be lost if `Tail` represents a list skeleton, but\ncomments on `Tail` are propagated to the result.\n\n_See also: _`list/2`, `list_head/1`, `list_tail/1`.","ref":"erl_syntax.html#cons/2"},{"type":"function","title":"erl_syntax.constrained_function_type/2","doc":"Creates an abstract constrained function type.\n\nIf `FunctionConstraint` is `[C1, ..., Cn]`, the result represents\n\"`FunctionType when C1, ...Cn`\".\n\n_See also: _`constrained_function_type_argument/1`,\n`constrained_function_type_body/1`.","ref":"erl_syntax.html#constrained_function_type/2"},{"type":"function","title":"erl_syntax.constrained_function_type_argument/1","doc":"Returns the function constraint subtree of a `constrained_function_type` node.\n\n_See also: _`constrained_function_type/2`.","ref":"erl_syntax.html#constrained_function_type_argument/1"},{"type":"function","title":"erl_syntax.constrained_function_type_body/1","doc":"Returns the function type subtree of a `constrained_function_type` node.\n\n_See also: _`constrained_function_type/2`.","ref":"erl_syntax.html#constrained_function_type_body/1"},{"type":"function","title":"erl_syntax.constraint/2","doc":"Creates an abstract (subtype) constraint.\n\nThe result represents \"`Name :: Type`\".\n\n_See also: _`constraint_argument/1`, `constraint_body/1`.","ref":"erl_syntax.html#constraint/2"},{"type":"function","title":"erl_syntax.constraint_argument/1","doc":"Returns the name subtree of a `constraint` node.\n\n_See also: _`constraint/2`.","ref":"erl_syntax.html#constraint_argument/1"},{"type":"function","title":"erl_syntax.constraint_body/1","doc":"Returns the type subtree of a `constraint` node.\n\n_See also: _`constraint/2`.","ref":"erl_syntax.html#constraint_body/1"},{"type":"function","title":"erl_syntax.copy_ann/2","doc":"Copies the list of user annotations from `Source` to `Target`.\n\nNote: this is equivalent to [`set_ann(Target, get_ann(Source))`](`set_ann/2`),\nbut potentially more efficient.\n\n_See also: _`get_ann/1`, `set_ann/2`.","ref":"erl_syntax.html#copy_ann/2"},{"type":"function","title":"erl_syntax.copy_attrs/2","doc":"Copies the attributes from `Source` to `Target`.\n\nNote: this is equivalent to\n[`set_attrs(Target, get_attrs(Source))`](`set_attrs/2`), but potentially more\nefficient.\n\n_See also: _`get_attrs/1`, `set_attrs/2`.","ref":"erl_syntax.html#copy_attrs/2"},{"type":"function","title":"erl_syntax.copy_comments/2","doc":"Copies the pre- and postcomments from `Source` to `Target`.\n\nNote: This is equivalent to\n[`set_postcomments(set_precomments(Target, get_precomments(Source)), get_postcomments(Source))`](`set_postcomments/2`),\nbut potentially more efficient.\n\n_See also: _`comment/2`, `get_postcomments/1`, `get_precomments/1`,\n`set_postcomments/2`, `set_precomments/2`.","ref":"erl_syntax.html#copy_comments/2"},{"type":"function","title":"erl_syntax.copy_pos/2","doc":"Copies the annotation from `Source` to `Target`.\n\nThis is equivalent to [`set_pos(Target, get_pos(Source))`](`set_pos/2`), but\npotentially more efficient.\n\n_See also: _`get_pos/1`, `set_pos/2`.","ref":"erl_syntax.html#copy_pos/2"},{"type":"function","title":"erl_syntax.data/1","doc":"**For special purposes only**. Returns the associated data of a syntax tree node.\n\nEvaluation fails with reason `badarg` if [`is_tree(Node)`](`is_tree/1`) does not\nyield `true`.\n\n_See also: _`tree/2`.","ref":"erl_syntax.html#data/1"},{"type":"function","title":"erl_syntax.disjunction/1","doc":"Creates an abstract disjunction.\n\nIf `List` is `[E1, ..., En]`, the result represents \"`E1; ...; En`\".\n\n_See also: _`conjunction/1`, `disjunction_body/1`.","ref":"erl_syntax.html#disjunction/1"},{"type":"function","title":"erl_syntax.disjunction_body/1","doc":"Returns the list of body subtrees of a `disjunction` node.\n\n_See also: _`disjunction/1`.","ref":"erl_syntax.html#disjunction_body/1"},{"type":"function","title":"erl_syntax.else_expr/1","doc":"Creates an abstract else-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result\nrepresents \"`else C1; ...; Cn end`\". More exactly, if each `Ci` represents\n\"`(Pi) Gi -> Bi`\", then the result represents\n\"`else (P1) G1 -> B1; ...; (Pn) Gn -> Bn end`\".\n\n_See also: _`clause/3`, `else_expr_clauses/1`, `maybe_expr/2`.","ref":"erl_syntax.html#else_expr/1"},{"type":"function","title":"erl_syntax.else_expr_clauses/1","doc":"Returns the list of clause subtrees of an `else_expr` node.\n\n_See also: _`else_expr/1`.","ref":"erl_syntax.html#else_expr_clauses/1"},{"type":"type","title":"erl_syntax.encoding/0","doc":"","ref":"erl_syntax.html#t:encoding/0"},{"type":"function","title":"erl_syntax.eof_marker/0","doc":"Creates an abstract end-of-file marker.\n\nThis represents the end of input when reading a sequence of source\ncode forms. An end-of-file marker is itself regarded as a source code\nform (namely, the last in any sequence in which it occurs). It has no\ndefined lexical form.\n\n> #### Note {: .info }\n>\n> This is retained only for backwards compatibility with existing parsers\n> and tools.\n\n_See also: _`error_marker/1`, `is_form/1`, `warning_marker/1`.","ref":"erl_syntax.html#eof_marker/0"},{"type":"type","title":"erl_syntax.erl_parse/0","doc":"","ref":"erl_syntax.html#t:erl_parse/0"},{"type":"function","title":"erl_syntax.error_marker/1","doc":"Creates an abstract error marker.\n\nThe result represents an occurrence of an error in the source code,\nwith an associated Erlang I/O ErrorInfo structure given by `Error`\n(see module [`//stdlib/io`](`m:io`) for details). Error markers are\nregarded as source code forms, but have no defined lexical form.\n\n> #### Note {: .info }\n>\n> This is supported only for backwards compatibility with existing parsers\n> and tools.\n\n_See also: _`eof_marker/0`, `error_marker_info/1`, `is_form/1`,\n`warning_marker/1`.","ref":"erl_syntax.html#error_marker/1"},{"type":"function","title":"erl_syntax.error_marker_info/1","doc":"Returns the ErrorInfo structure of an `error_marker` node.\n\n_See also: _`error_marker/1`.","ref":"erl_syntax.html#error_marker_info/1"},{"type":"function","title":"erl_syntax.flatten_form_list/1","doc":"Flattens sublists of a `form_list` node.\n\nReturns `Node` with all subtrees of type `form_list` recursively\nexpanded, yielding a single \"flat\" abstract form sequence.\n\n_See also: _`form_list/1`.","ref":"erl_syntax.html#flatten_form_list/1"},{"type":"function","title":"erl_syntax.float/1","doc":"Creates an abstract floating-point literal.\n\nThe lexical representation is the decimal floating-point numeral of\n`Value`.\n\n_See also: _`float_literal/1`, `float_value/1`.","ref":"erl_syntax.html#float/1"},{"type":"function","title":"erl_syntax.float_literal/1","doc":"Returns the numeral string represented by a `float` node.\n\n_See also: _`float/1`.","ref":"erl_syntax.html#float_literal/1"},{"type":"function","title":"erl_syntax.float_value/1","doc":"Returns the value represented by a `float` node.\n\nNote that floating-point values should usually not be compared for\nequality.\n\n_See also: _`float/1`.","ref":"erl_syntax.html#float_value/1"},{"type":"function","title":"erl_syntax.form_list/1","doc":"Creates an abstract sequence of \"source code forms\".\n\nIf `Forms` is `[F1, ..., Fn]`, where each `Fi` is a form (see\n`is_form/1`), the result represents:\n\n```text\nF1\n...\nFn\n```\n\nwhere the `Fi` are separated by one or more line breaks. A node of type\n`form_list` is itself regarded as a source code form; see `flatten_form_list/1`.\n\n> #### Note {: .info }\n>\n> This is simply a way of grouping source code forms into a single syntax\ntree, usually to form an Erlang module definition.\n\n_See also: _`flatten_form_list/1`, `form_list_elements/1`, `is_form/1`.","ref":"erl_syntax.html#form_list/1"},{"type":"function","title":"erl_syntax.form_list_elements/1","doc":"Returns the list of subnodes of a `form_list` node.\n\n_See also: _`form_list/1`.","ref":"erl_syntax.html#form_list_elements/1"},{"type":"type","title":"erl_syntax.forms/0","doc":"","ref":"erl_syntax.html#t:forms/0"},{"type":"function","title":"erl_syntax.fun_expr/1","doc":"Creates an abstract fun-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`fun C1;\n...; Cn end`\". More exactly, if each `Ci` represents \"`(Pi1, ...,\nPim) Gi -> Bi`\", then the result represents \"`fun (P11, ...,\nP1m) G1 -> B1; ...; (Pn1, ..., Pnm) Gn -> Bn end`\".\n\n_See also: _`fun_expr_arity/1`, `fun_expr_clauses/1`.","ref":"erl_syntax.html#fun_expr/1"},{"type":"function","title":"erl_syntax.fun_expr_arity/1","doc":"Returns the arity of a `fun_expr` node.\n\nThe result is the number of parameter patterns in the first clause of\nthe fun-expression; subsequent clauses are ignored.\n\nAn exception is thrown if [`fun_expr_clauses(Node)`](`fun_expr_clauses/1`)\nreturns an empty list, or if the first element of that list is not a syntax tree\n`C` of type `clause` such that [`clause_patterns(C)`](`clause_patterns/1`) is a\nnonempty list.\n\n_See also: _`clause/3`, `clause_patterns/1`, `fun_expr/1`, `fun_expr_clauses/1`.","ref":"erl_syntax.html#fun_expr_arity/1"},{"type":"function","title":"erl_syntax.fun_expr_clauses/1","doc":"Returns the list of clause subtrees of a `fun_expr` node.\n\n_See also: _`fun_expr/1`.","ref":"erl_syntax.html#fun_expr_clauses/1"},{"type":"function","title":"erl_syntax.fun_type/0","doc":"Creates an abstract fun of any type.\n\nThe result represents \"`fun()`\".","ref":"erl_syntax.html#fun_type/0"},{"type":"function","title":"erl_syntax.function/2","doc":"Creates an abstract function definition.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`Name C1;\n...; Name Cn.`\". More exactly, if each `Ci` represents \"`(Pi1, ...,\nPim) Gi -> Bi`\", then the result represents \"`Name(P11, ...,\nP1m) G1 -> B1; ...; Name(Pn1, ..., Pnm) Gn -> Bn.`\".\nFunction definitions are source code forms.\n\n_See also: _`function_arity/1`, `function_clauses/1`, `function_name/1`,\n`is_form/1`.","ref":"erl_syntax.html#function/2"},{"type":"function","title":"erl_syntax.function_arity/1","doc":"Returns the arity of a `function` node.\n\nThe result is the number of parameter patterns in the first clause of\nthe function; subsequent clauses are ignored.\n\nAn exception is thrown if [`function_clauses(Node)`](`function_clauses/1`)\nreturns an empty list, or if the first element of that list is not a syntax tree\n`C` of type `clause` such that [`clause_patterns(C)`](`clause_patterns/1`) is a\nnonempty list.\n\n_See also: _`clause/3`, `clause_patterns/1`, `function/2`, `function_clauses/1`.","ref":"erl_syntax.html#function_arity/1"},{"type":"function","title":"erl_syntax.function_clauses/1","doc":"Returns the list of clause subtrees of a `function` node.\n\n_See also: _`function/2`.","ref":"erl_syntax.html#function_clauses/1"},{"type":"function","title":"erl_syntax.function_name/1","doc":"Returns the name subtree of a `function` node.\n\n_See also: _`function/2`.","ref":"erl_syntax.html#function_name/1"},{"type":"function","title":"erl_syntax.function_type/1","doc":"","ref":"erl_syntax.html#function_type/1"},{"type":"function","title":"erl_syntax.function_type/2","doc":"Creates an abstract function type.\n\nIf `Arguments` is `[T1, ..., Tn]` *and* it occurs within a function\nspecification, the result represents \"`(T1, ...Tn) -> Return`\";\notherwise it represents \"`fun((T1, ...Tn) -> Return)`\". If\n`Arguments` is `any_arity`, it represents \"`fun((...) -> Return)`\".\n\nNote that the `m:erl_parse` representation is identical for\n\"`FunctionType`\" and \"`fun(FunctionType)`\".\n\n_See also: _`function_type_arguments/1`, `function_type_return/1`.","ref":"erl_syntax.html#function_type/2"},{"type":"function","title":"erl_syntax.function_type_arguments/1","doc":"Returns the argument types subtrees of a `function_type` node.\n\nIf `Node` represents \"`fun((...) -> Return)`\", `any_arity` is\nreturned; otherwise, if `Node` represents \"`(T1, ...Tn) ->\nReturn`\" or \"`fun((T1, ...Tn) -> Return)`\", `[T1, ..., Tn]` is\nreturned.\n\n_See also: _`function_type/1`, `function_type/2`.","ref":"erl_syntax.html#function_type_arguments/1"},{"type":"function","title":"erl_syntax.function_type_return/1","doc":"Returns the return type subtrees of a `function_type` node.\n\n_See also: _`function_type/1`, `function_type/2`.","ref":"erl_syntax.html#function_type_return/1"},{"type":"function","title":"erl_syntax.generator/2","doc":"Creates an abstract list generator.\n\nThe result represents \"`Pattern <- Body`\".\n\n_See also: _`binary_comp/2`, `generator_body/1`, `generator_pattern/1`,\n`map_comp/2`, `list_comp/2`.","ref":"erl_syntax.html#generator/2"},{"type":"function","title":"erl_syntax.generator_body/1","doc":"Returns the body subtree of a `generator` node.\n\n_See also: _`generator/2`.","ref":"erl_syntax.html#generator_body/1"},{"type":"function","title":"erl_syntax.generator_pattern/1","doc":"Returns the pattern subtree of a `generator` node.\n\n_See also: _`generator/2`.","ref":"erl_syntax.html#generator_pattern/1"},{"type":"function","title":"erl_syntax.get_ann/1","doc":"Returns the list of user annotations associated with a syntax tree.\n\nFor a newly created node, this is the empty list. The annotations may\nbe any terms.\n\n_See also: _`get_attrs/1`, `set_ann/2`.","ref":"erl_syntax.html#get_ann/1"},{"type":"function","title":"erl_syntax.get_attrs/1","doc":"Returns a representation of the attributes associated with a syntax tree node.\n\nThe attributes are all the extra information that can be attached to a node.\nCurrently, this includes position information, source code comments, and user\nannotations. The result of this function cannot be inspected directly; only\nattached to another node (see `set_attrs/2`).\n\nFor accessing individual attributes, see `get_pos/1`, `get_ann/1`,\n`get_precomments/1` and `get_postcomments/1`.\n\n_See also: _`get_ann/1`, `get_pos/1`, `get_postcomments/1`, `get_precomments/1`,\n`set_attrs/2`.","ref":"erl_syntax.html#get_attrs/1"},{"type":"function","title":"erl_syntax.get_pos/1","doc":"Returns the annotation (see [`//stdlib/erl_anno`](`m:erl_anno`)) associated with\n`Node`.\n\nBy default, all new tree nodes have their associated position\ninformation set to the integer zero. Use\n[`//stdlib/erl_anno:location/1`](`erl_anno:location/1`) or\n[`//stdlib/erl_anno:line/1`](`erl_anno:line/1`) to get the position information.\n\n_See also: _`get_attrs/1`, `set_pos/2`.","ref":"erl_syntax.html#get_pos/1"},{"type":"function","title":"erl_syntax.get_postcomments/1","doc":"Returns the associated post-comments of a node.\n\nThis is a possibly empty list of abstract comments, in top-down\ntextual order. When the code is formatted, post-comments are typically\ndisplayed to the right of and/or below the node. For example:\n\n```erlang\n{foo, X, Y}     % Post-comment of tuple\n```\n\nIf possible, the comment should be moved past any following separator characters\non the same line, rather than placing the separators on the following line.\nFor example:\n\n```erlang\nfoo([X | Xs], Y) ->\n    foo(Xs, bar(X));     % Post-comment of 'bar(X)' node\n ...\n```\n\n(where the comment is moved past the rightmost \"`)`\" and the \"`;`\").\n\n_See also: _`comment/2`, `get_attrs/1`, `get_precomments/1`,\n`set_postcomments/2`.","ref":"erl_syntax.html#get_postcomments/1"},{"type":"function","title":"erl_syntax.get_precomments/1","doc":"Returns the associated pre-comments of a node.\n\nThis is a possibly empty list of abstract comments, in top-down\ntextual order. When the code is formatted, pre-comments are typically\ndisplayed directly above the node. For example:\n\n```erlang\n% Pre-comment of function\nfoo(X) -> {bar, X}.\n```\n\nIf possible, the comment should be moved before any preceding separator\ncharacters on the same line. For example:\n\n```erlang\nfoo([X | Xs]) ->\n    % Pre-comment of 'bar(X)' node\n    [bar(X) | foo(Xs)];\n...\n```\n\n(where the comment is moved before the \"`[`\").\n\n_See also: _`comment/2`, `get_attrs/1`, `get_postcomments/1`,\n`set_precomments/2`.","ref":"erl_syntax.html#get_precomments/1"},{"type":"type","title":"erl_syntax.guard/0","doc":"","ref":"erl_syntax.html#t:guard/0"},{"type":"function","title":"erl_syntax.has_comments/1","doc":"Yields `false` if the node has no associated comments, and `true` otherwise.\n\nNote: This is equivalent to\n`(get_precomments(Node) == []) and (get_postcomments(Node) == [])`, but\npotentially more efficient.\n\n_See also: _`get_postcomments/1`, `get_precomments/1`, `remove_comments/1`.","ref":"erl_syntax.html#has_comments/1"},{"type":"function","title":"erl_syntax.if_expr/1","doc":"Creates an abstract if-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`if C1; ...;\nCn end`\". More exactly, if each `Ci` represents \"`() Gi -> Bi`\",\nthen the result represents \"`if G1 -> B1; ...; Gn -> Bn end`\".\n\n_See also: _`case_expr/2`, `clause/3`, `if_expr_clauses/1`.","ref":"erl_syntax.html#if_expr/1"},{"type":"function","title":"erl_syntax.if_expr_clauses/1","doc":"Returns the list of clause subtrees of an `if_expr` node.\n\n_See also: _`if_expr/1`.","ref":"erl_syntax.html#if_expr_clauses/1"},{"type":"function","title":"erl_syntax.implicit_fun/1","doc":"Creates an abstract \"implicit fun\" expression.\n\nThe result represents \"`fun Name`\". `Name` should represent either\n`F/A` or `M:F/A`\n\n_See also: _`arity_qualifier/2`, `implicit_fun/2`, `implicit_fun/3`,\n`implicit_fun_name/1`, `module_qualifier/2`.","ref":"erl_syntax.html#implicit_fun/1"},{"type":"function","title":"erl_syntax.implicit_fun/2","doc":"Creates an abstract \"implicit fun\" expression.\n\nIf `Arity` is `none`, this is equivalent to\n[`implicit_fun(Name)`](`implicit_fun/1`), otherwise it is equivalent\nto [`implicit_fun(arity_qualifier(Name, Arity))`](`implicit_fun/1`).\n\n(This is a utility function.)\n\n_See also: _`implicit_fun/1`, `implicit_fun/3`.","ref":"erl_syntax.html#implicit_fun/2"},{"type":"function","title":"erl_syntax.implicit_fun/3","doc":"Creates an abstract module-qualified \"implicit fun\" expression.\n\nIf `Module` is `none`, this is equivalent to [`implicit_fun(Name,\nArity)`](`implicit_fun/2`), otherwise it is equivalent to\n`implicit_fun(module_qualifier(Module, arity_qualifier(Name, Arity))`.\n\n(This is a utility function.)\n\n_See also: _`implicit_fun/1`, `implicit_fun/2`.","ref":"erl_syntax.html#implicit_fun/3"},{"type":"function","title":"erl_syntax.implicit_fun_name/1","doc":"Returns the name subtree of an `implicit_fun` node.\n\nIf `Node` represents \"`fun N/A`\" or \"`fun M:N/A`\", then the\nresult is the subtree representing \"`N/A`\" or \"`M:N/A`\", respectively.\n\n_See also: _`arity_qualifier/2`, `implicit_fun/1`, `module_qualifier/2`.","ref":"erl_syntax.html#implicit_fun_name/1"},{"type":"function","title":"erl_syntax.infix_expr/3","doc":"Creates an abstract infix operator expression.\n\nThe result represents \"`Left Operator Right`\".\n\n_See also: _`infix_expr_left/1`, `infix_expr_operator/1`, `infix_expr_right/1`,\n`prefix_expr/2`.","ref":"erl_syntax.html#infix_expr/3"},{"type":"function","title":"erl_syntax.infix_expr_left/1","doc":"Returns the left argument subtree of an `infix_expr` node.\n\n_See also: _`infix_expr/3`.","ref":"erl_syntax.html#infix_expr_left/1"},{"type":"function","title":"erl_syntax.infix_expr_operator/1","doc":"Returns the operator subtree of an `infix_expr` node.\n\n_See also: _`infix_expr/3`.","ref":"erl_syntax.html#infix_expr_operator/1"},{"type":"function","title":"erl_syntax.infix_expr_right/1","doc":"Returns the right argument subtree of an `infix_expr` node.\n\n_See also: _`infix_expr/3`.","ref":"erl_syntax.html#infix_expr_right/1"},{"type":"function","title":"erl_syntax.integer/1","doc":"Creates an abstract integer literal.\n\nThe lexical representation is the canonical decimal numeral of `Value`.\n\n_See also: _`integer_literal/1`, `integer_value/1`, `is_integer/2`.","ref":"erl_syntax.html#integer/1"},{"type":"function","title":"erl_syntax.integer_literal/1","doc":"Returns the numeral string represented by an `integer` node.\n\n_See also: _`integer/1`.","ref":"erl_syntax.html#integer_literal/1"},{"type":"function","title":"erl_syntax.integer_range_type/2","doc":"Creates an abstract range type.\n\nThe result represents \"`Low .. High`\".\n\n_See also: _`integer_range_type_high/1`, `integer_range_type_low/1`.","ref":"erl_syntax.html#integer_range_type/2"},{"type":"function","title":"erl_syntax.integer_range_type_high/1","doc":"Returns the high limit of an `integer_range_type` node.\n\n_See also: _`integer_range_type/2`.","ref":"erl_syntax.html#integer_range_type_high/1"},{"type":"function","title":"erl_syntax.integer_range_type_low/1","doc":"Returns the low limit of an `integer_range_type` node.\n\n_See also: _`integer_range_type/2`.","ref":"erl_syntax.html#integer_range_type_low/1"},{"type":"function","title":"erl_syntax.integer_value/1","doc":"Returns the value represented by an `integer` node.\n\n_See also: _`integer/1`.","ref":"erl_syntax.html#integer_value/1"},{"type":"function","title":"erl_syntax.is_atom/2","doc":"Returns `true` if `Node` has type `atom` and represents `Value`, otherwise\n`false`.\n\n_See also: _`atom/1`.","ref":"erl_syntax.html#is_atom/2"},{"type":"function","title":"erl_syntax.is_char/2","doc":"Returns `true` if `Node` has type `char` and represents `Value`, otherwise\n`false`.\n\n_See also: _`char/1`.","ref":"erl_syntax.html#is_char/2"},{"type":"function","title":"erl_syntax.is_form/1","doc":"Returns `true` if `Node` is a syntax tree representing a so-called \"source code\nform\", otherwise `false`.\n\nForms are the Erlang source code units which, placed in sequence,\nconstitute an Erlang program. Current form types are:\n\n* `attribute`\n* `comment`\n* `error_marker`\n* `eof_marker`\n* `form_list`\n* `function`\n* `warning_marker`\n* `text`\n\n\n_See also: _`attribute/2`, `comment/2`, `eof_marker/0`, `error_marker/1`,\n`form_list/1`, `function/2`, `type/1`, `warning_marker/1`.","ref":"erl_syntax.html#is_form/1"},{"type":"function","title":"erl_syntax.is_integer/2","doc":"Returns `true` if `Node` has type `integer` and represents `Value`, otherwise\n`false`.\n\n_See also: _`integer/1`.","ref":"erl_syntax.html#is_integer/2"},{"type":"function","title":"erl_syntax.is_leaf/1","doc":"Returns `true` if `Node` is a leaf node, otherwise `false`.\n\nThe currently recognised leaf node types are:\n\n* `atom`\n* `char`\n* `comment`\n* `eof_marker`\n* `error_marker`\n* `float`\n* `fun_type`\n* `integer`\n* `nil`\n* `operator`\n* `string`\n* `text`\n* `underscore`\n* `variable`\n* `warning_marker`\n\nA node of type `map_expr` is a leaf node if and only if it has no argument and\nno fields. A node of type `map_type` is a leaf node if and only if it has no\nfields (`any_size`). A node of type `tuple` is a leaf node if and only if its\narity is zero. A node of type `tuple_type` is a leaf node if and only if it has\nno elements (`any_size`).\n\nNote: not all literals are leaf nodes, and vice versa. For example,\ntuples with nonzero arity and nonempty lists may be literals, but are\nnot leaf nodes. Variables, on the other hand, are leaf nodes but not\nliterals.\n\n_See also: _`is_literal/1`, `type/1`.","ref":"erl_syntax.html#is_leaf/1"},{"type":"function","title":"erl_syntax.is_list_skeleton/1","doc":"Returns `true` if `Node` has type `list` or `nil`, otherwise `false`.\n\n_See also: _`list/2`, `nil/0`.","ref":"erl_syntax.html#is_list_skeleton/1"},{"type":"function","title":"erl_syntax.is_literal/1","doc":"Returns `true` if `Node` represents a literal term, otherwise `false`.\n\nThis function returns `true` if and only if the value of\n[`concrete(Node)`](`concrete/1`) is defined.\n\n_See also: _`abstract/1`, `concrete/1`.","ref":"erl_syntax.html#is_literal/1"},{"type":"function","title":"erl_syntax.is_proper_list/1","doc":"Returns `true` if `Node` represents a proper list, and `false` otherwise.\n\nA proper list is a list skeleton either on the form \"`[]`\" or \"`[E1,\n..., En]`\", or \"`[... | Tail]`\" where recursively `Tail` also\nrepresents a proper list.\n\n> #### Note {: .info }\n>\n> Since `Node` is a syntax tree, the actual run-time values\n> corresponding to its subtrees can often be partially or completely\n> unknown. For example, if `Node` represents \"`[... | Ns]`\"\n> (where `Ns` is a variable), the function will return `false`\n> because it is not known whether `Ns` will be bound to a list at\n> run-time. Conversely, if `Node` represents, for example, \"`[1, 2, 3]`\" or\n> \"`[A | []]`\", the function will return `true`.\n\n_See also: _`list/2`.","ref":"erl_syntax.html#is_proper_list/1"},{"type":"function","title":"erl_syntax.is_string/2","doc":"Returns `true` if `Node` has type `string` and represents `Value`, otherwise\n`false`.\n\n_See also: _`string/1`.","ref":"erl_syntax.html#is_string/2"},{"type":"function","title":"erl_syntax.is_tree/1","doc":"**For special purposes only**. Returns `true` if `Tree` is an abstract syntax tree\nand `false` otherwise.\n\n> #### Note {: .info }\n>\n> This function yields `false` for all \"old-style\" `m:erl_parse`-compatible\n> \"parse trees\".\n\n_See also: _`tree/2`.","ref":"erl_syntax.html#is_tree/1"},{"type":"function","title":"erl_syntax.join_comments/2","doc":"Appends the comments of `Source` to the current comments of `Target`.\n\nNote: This is equivalent to\n[`add_postcomments(get_postcomments(Source), add_precomments(get_precomments(Source), Target))`](`add_postcomments/2`),\nbut potentially more efficient.\n\n_See also: _`add_postcomments/2`, `add_precomments/2`, `comment/2`,\n`get_postcomments/1`, `get_precomments/1`.","ref":"erl_syntax.html#join_comments/2"},{"type":"function","title":"erl_syntax.list/1","doc":"","ref":"erl_syntax.html#list/1"},{"type":"function","title":"erl_syntax.list/2","doc":"Constructs an abstract list skeleton.\n\nThe result has type `list` or `nil`. If `List` is a nonempty list\n`[E1, ..., En]`, the result has type `list` and represents either\n\"`[E1, ..., En]`\" if `Tail` is `none`, or otherwise \"`[E1, ...,\nEn | Tail]`\". If `List` is the empty list, `Tail` _must_ be `none`,\nand in that case the result has type `nil` and represents \"`[]`\" (see\n`nil/0`).\n\nThe difference between lists as semantic objects (built up of individual \"cons\"\nand \"nil\" terms) and the various syntactic forms for denoting lists may be\nbewildering at first. This module provides functions both for exact control of\nthe syntactic representation as well as for the simple composition and\ndeconstruction in terms of cons and head/tail operations.\n\n> #### Note {: .info }\n>\n> In [`list(Elements, none)`](`list/2`), the \"nil\" list terminator is\n> implicit and has no associated information (see `get_attrs/1`). However,\n> in the seemingly equivalent [`list(Elements, Tail)`](`list/2`) where\n> `Tail` has the type `nil`, the list terminator subtree `Tail` may have\n> attached attributes such as position, comments, and annotations, which\n> will be preserved in the result.\n\n_See also: _`compact_list/1`, `cons/2`, `get_attrs/1`, `is_list_skeleton/1`,\n`is_proper_list/1`, `list/1`, `list_elements/1`, `list_head/1`, `list_length/1`,\n`list_prefix/1`, `list_suffix/1`, `list_tail/1`, `nil/0`, `normalize_list/1`.","ref":"erl_syntax.html#list/2"},{"type":"function","title":"erl_syntax.list_comp/2","doc":"Creates an abstract list comprehension.\n\nIf `Body` is `[E1, ..., En]`, the result represents \"`[Template ||\nE1, ..., En]`\".\n\n_See also: _`generator/2`, `list_comp_body/1`, `list_comp_template/1`.","ref":"erl_syntax.html#list_comp/2"},{"type":"function","title":"erl_syntax.list_comp_body/1","doc":"Returns the list of body subtrees of a `list_comp` node.\n\n_See also: _`list_comp/2`.","ref":"erl_syntax.html#list_comp_body/1"},{"type":"function","title":"erl_syntax.list_comp_template/1","doc":"Returns the template subtree of a `list_comp` node.\n\n_See also: _`list_comp/2`.","ref":"erl_syntax.html#list_comp_template/1"},{"type":"function","title":"erl_syntax.list_elements/1","doc":"Returns the list of element subtrees of a list skeleton.\n\n`Node` must represent a proper list. For example, if `Node` represents\n\"`[X1, X2 | [X3, X4 | []]`\", then\n[`list_elements(Node)`](`list_elements/1`) yields the list `[X1, X2,\nX3, X4]`.\n\n_See also: _`is_proper_list/1`, `list/2`.","ref":"erl_syntax.html#list_elements/1"},{"type":"function","title":"erl_syntax.list_head/1","doc":"Returns the head element subtree of a `list` node.\n\nIf `Node` represents \"`[Head ...]`\", the result will represent \"`Head`\".\n\n_See also: _`cons/2`, `list/2`, `list_tail/1`.","ref":"erl_syntax.html#list_head/1"},{"type":"function","title":"erl_syntax.list_length/1","doc":"Returns the number of element subtrees of a list skeleton.\n\n`Node` must represent a proper list. For example, if `Node` represents\n\"`[X1 | [X2, X3 | [X4, X5, X6]]]`\", then\n[`list_length(Node)`](`list_length/1`) returns the integer 6.\n\n> #### Note {: .info }\n>\n> This is equivalent to [`length(list_elements(Node))`](`length/1`), but\n> potentially more efficient.\n\n_See also: _`is_proper_list/1`, `list/2`, `list_elements/1`.","ref":"erl_syntax.html#list_length/1"},{"type":"function","title":"erl_syntax.list_prefix/1","doc":"Returns the prefix element subtrees of a `list` node.\n\nIf `Node` represents \"`[E1, ..., En]`\" or \"`[E1, ..., En |\nTail]`\", the returned value is `[E1, ..., En]`.\n\n_See also: _`list/2`.","ref":"erl_syntax.html#list_prefix/1"},{"type":"function","title":"erl_syntax.list_suffix/1","doc":"Returns the suffix subtree of a `list` node, if one exists.\n\nIf `Node` represents \"`[E1, ..., En | Tail]`\", the returned value is\n`Tail`. Otherwise, if `Node` represents \"`[E1, ..., En]`\", `none` is\nreturned.\n\n> #### Note {: .info }\n>\n> Even if this function returns a `Tail` that is not `none`, the type\n> of `Tail` can be `nil` if the tail has been given explicitly and the\n> list skeleton has not been compacted (see `compact_list/1`).\n\n_See also: _`compact_list/1`, `list/2`, `nil/0`.","ref":"erl_syntax.html#list_suffix/1"},{"type":"function","title":"erl_syntax.list_tail/1","doc":"Returns the tail of a `list` node.\n\nIf `Node` represents a single-element list \"`[E]`\", then the result\nhas type `nil`, representing \"`[]`\". If `Node` represents \"`[E1,\nE2 ...]`\", the result will represent \"`[E2 ...]`\", and if `Node`\nrepresents \"`[Head | Tail]`\", the result will represent\n\"`Tail`\".\n\n_See also: _`cons/2`, `list/2`, `list_head/1`.","ref":"erl_syntax.html#list_tail/1"},{"type":"function","title":"erl_syntax.macro/1","doc":"","ref":"erl_syntax.html#macro/1"},{"type":"function","title":"erl_syntax.macro/2","doc":"Creates an abstract macro application.\n\nIf `Arguments` is `none`, the result represents \"`?Name`\",\notherwise, if `Arguments` is `[A1, ..., An]`, the result represents\n\"`?Name(A1, ..., An)`\".\n\nNotes: if `Arguments` is the empty list, the result will thus represent\n\"`?Name()`\", including a pair of matching parentheses.\n\nThe only syntactical limitation imposed by the preprocessor on the arguments to\na macro application (viewed as sequences of tokens) is that they must be\nbalanced with respect to parentheses, brackets, `begin ... end`, `case ... end`,\nand so on. The `text` node type can be used to represent arguments which are not\nregular Erlang constructs.\n\n_See also: _`macro/1`, `macro_arguments/1`, `macro_name/1`, `text/1`.","ref":"erl_syntax.html#macro/2"},{"type":"function","title":"erl_syntax.macro_arguments/1","doc":"Returns the list of argument subtrees of a `macro` node, if any.\n\nIf `Node` represents \"`?Name`\", `none` is returned. Otherwise, if\n`Node` represents \"`?Name(A1, ..., An)`\", `[A1, ..., An]` is\nreturned.\n\n_See also: _`macro/2`.","ref":"erl_syntax.html#macro_arguments/1"},{"type":"function","title":"erl_syntax.macro_name/1","doc":"Returns the name subtree of a `macro` node.\n\n_See also: _`macro/2`.","ref":"erl_syntax.html#macro_name/1"},{"type":"function","title":"erl_syntax.make_tree/2","doc":"Creates a syntax tree with the given type and subtrees.\n\n`Type` must be a node type name (see `type/1`) that does not denote a\nleaf node type (see `is_leaf/1`). `Groups` must be a _nonempty_ list\nof groups of syntax trees, representing the subtrees of a node of the\ngiven type, in left-to-right order as they would occur in the printed\nprogram text, grouped by category as done by `subtrees/1`.\n\nThe result of\n[`copy_attrs(Node, make_tree(type(Node), subtrees(Node)))`](`copy_attrs/2`) (see\n`update_tree/2`) represents the same source code text as the original `Node`,\nassuming that [`subtrees(Node)`](`subtrees/1`) yields a nonempty list. However,\nit does not necessarily have the same data representation as `Node`.\n\n_See also: _`copy_attrs/2`, `is_leaf/1`, `subtrees/1`, `type/1`,\n`update_tree/2`.","ref":"erl_syntax.html#make_tree/2"},{"type":"function","title":"erl_syntax.map_comp/2","doc":"Creates an abstract map comprehension.\n\nIf `Body` is `[E1, ..., En]`, the result represents \"`#{Template ||\nE1, ..., En}`\".\n\n_See also: _`generator/2`, `map_comp_body/1`, `map_comp_template/1`.","ref":"erl_syntax.html#map_comp/2"},{"type":"function","title":"erl_syntax.map_comp_body/1","doc":"Returns the list of body subtrees of a `map_comp` node.\n\n_See also: _`map_comp/2`.","ref":"erl_syntax.html#map_comp_body/1"},{"type":"function","title":"erl_syntax.map_comp_template/1","doc":"Returns the template subtree of a `map_comp` node.\n\n_See also: _`map_comp/2`.","ref":"erl_syntax.html#map_comp_template/1"},{"type":"function","title":"erl_syntax.map_expr/1","doc":"","ref":"erl_syntax.html#map_expr/1"},{"type":"function","title":"erl_syntax.map_expr/2","doc":"Creates an abstract map expression.\n\nIf `Fields` is `[F1, ..., Fn]`, then if `Argument` is `none`, the\nresult represents \"`#{F1, ..., Fn}`\", otherwise it represents\n\"`Argument#{F1, ..., Fn}`\".\n\n_See also: _`map_expr/1`, `map_expr_argument/1`, `map_expr_fields/1`,\n`map_field_assoc/2`, `map_field_exact/2`.","ref":"erl_syntax.html#map_expr/2"},{"type":"function","title":"erl_syntax.map_expr_argument/1","doc":"Returns the argument subtree of a `map_expr` node, if any.\n\nIf `Node` represents \"`#{...}`\", `none` is returned. Otherwise, if\n`Node` represents \"`Argument#{...}`\", `Argument` is returned.\n\n_See also: _`map_expr/2`.","ref":"erl_syntax.html#map_expr_argument/1"},{"type":"function","title":"erl_syntax.map_expr_fields/1","doc":"Returns the list of field subtrees of a `map_expr` node.\n\n_See also: _`map_expr/2`.","ref":"erl_syntax.html#map_expr_fields/1"},{"type":"function","title":"erl_syntax.map_field_assoc/2","doc":"Creates an abstract map assoc field.\n\nThe result represents \"`Name => Value`\".\n\n_See also: _`map_expr/2`, `map_field_assoc_name/1`, `map_field_assoc_value/1`.","ref":"erl_syntax.html#map_field_assoc/2"},{"type":"function","title":"erl_syntax.map_field_assoc_name/1","doc":"Returns the name subtree of a `map_field_assoc` node.\n\n_See also: _`map_field_assoc/2`.","ref":"erl_syntax.html#map_field_assoc_name/1"},{"type":"function","title":"erl_syntax.map_field_assoc_value/1","doc":"Returns the value subtree of a `map_field_assoc` node.\n\n_See also: _`map_field_assoc/2`.","ref":"erl_syntax.html#map_field_assoc_value/1"},{"type":"function","title":"erl_syntax.map_field_exact/2","doc":"Creates an abstract map exact field.\n\nThe result represents \"`Name := Value`\".\n\n_See also: _`map_expr/2`, `map_field_exact_name/1`, `map_field_exact_value/1`.","ref":"erl_syntax.html#map_field_exact/2"},{"type":"function","title":"erl_syntax.map_field_exact_name/1","doc":"Returns the name subtree of a `map_field_exact` node.\n\n_See also: _`map_field_exact/2`.","ref":"erl_syntax.html#map_field_exact_name/1"},{"type":"function","title":"erl_syntax.map_field_exact_value/1","doc":"Returns the value subtree of a `map_field_exact` node.\n\n_See also: _`map_field_exact/2`.","ref":"erl_syntax.html#map_field_exact_value/1"},{"type":"function","title":"erl_syntax.map_generator/2","doc":"Creates an abstract map_generator.\n\nThe result represents \"`Pattern <- Body`\".\n\n_See also: _`binary_comp/2`, `list_comp/2`, `map_comp/2`, `map_generator_body/1`,\n`map_generator_pattern/1`.","ref":"erl_syntax.html#map_generator/2"},{"type":"function","title":"erl_syntax.map_generator_body/1","doc":"Returns the body subtree of a `map_generator` node.\n\n_See also: _`map_generator/2`.","ref":"erl_syntax.html#map_generator_body/1"},{"type":"function","title":"erl_syntax.map_generator_pattern/1","doc":"Returns the pattern subtree of a `map_generator` node.\n\n_See also: _`map_generator/2`.","ref":"erl_syntax.html#map_generator_pattern/1"},{"type":"function","title":"erl_syntax.map_type/0","doc":"","ref":"erl_syntax.html#map_type/0"},{"type":"function","title":"erl_syntax.map_type/1","doc":"Creates an abstract type map.\n\nIf `Fields` is `[F1, ..., Fn]`, the result represents \"`#{F1, ...,\nFn}`\"; otherwise, if `Fields` is `any_size`, it represents\n\"`t:map/0`\".\n\n_See also: _`map_type_fields/1`.","ref":"erl_syntax.html#map_type/1"},{"type":"function","title":"erl_syntax.map_type_assoc/2","doc":"Creates an abstract map type assoc field.\n\nThe result represents \"`Name => Value`\".\n\n_See also: _`map_type/1`, `map_type_assoc_name/1`, `map_type_assoc_value/1`.","ref":"erl_syntax.html#map_type_assoc/2"},{"type":"function","title":"erl_syntax.map_type_assoc_name/1","doc":"Returns the name subtree of a `map_type_assoc` node.\n\n_See also: _`map_type_assoc/2`.","ref":"erl_syntax.html#map_type_assoc_name/1"},{"type":"function","title":"erl_syntax.map_type_assoc_value/1","doc":"Returns the value subtree of a `map_type_assoc` node.\n\n_See also: _`map_type_assoc/2`.","ref":"erl_syntax.html#map_type_assoc_value/1"},{"type":"function","title":"erl_syntax.map_type_exact/2","doc":"Creates an abstract map type exact field.\n\nThe result represents \"`Name := Value`\".\n\n_See also: _`map_type/1`, `map_type_exact_name/1`, `map_type_exact_value/1`.","ref":"erl_syntax.html#map_type_exact/2"},{"type":"function","title":"erl_syntax.map_type_exact_name/1","doc":"Returns the name subtree of a `map_type_exact` node.\n\n_See also: _`map_type_exact/2`.","ref":"erl_syntax.html#map_type_exact_name/1"},{"type":"function","title":"erl_syntax.map_type_exact_value/1","doc":"Returns the value subtree of a `map_type_exact` node.\n\n_See also: _`map_type_exact/2`.","ref":"erl_syntax.html#map_type_exact_value/1"},{"type":"function","title":"erl_syntax.map_type_fields/1","doc":"Returns the list of field subtrees of a `map_type` node.\n\nIf `Node` represents \"`t:map/0`\", `any_size` is returned; otherwise,\nif `Node` represents \"`#{F1, ..., Fn}`\", `[F1, ..., Fn]` is\nreturned.\n\n_See also: _`map_type/0`, `map_type/1`.","ref":"erl_syntax.html#map_type_fields/1"},{"type":"function","title":"erl_syntax.match_expr/2","doc":"Creates an abstract match-expression.\n\nThe result represents \"`Pattern = Body`\".\n\n_See also: _`match_expr_body/1`, `match_expr_pattern/1`.","ref":"erl_syntax.html#match_expr/2"},{"type":"function","title":"erl_syntax.match_expr_body/1","doc":"Returns the body subtree of a `match_expr` node.\n\n_See also: _`match_expr/2`.","ref":"erl_syntax.html#match_expr_body/1"},{"type":"function","title":"erl_syntax.match_expr_pattern/1","doc":"Returns the pattern subtree of a `match_expr` node.\n\n_See also: _`match_expr/2`.","ref":"erl_syntax.html#match_expr_pattern/1"},{"type":"function","title":"erl_syntax.maybe_expr/1","doc":"","ref":"erl_syntax.html#maybe_expr/1"},{"type":"function","title":"erl_syntax.maybe_expr/2","doc":"Creates an abstract maybe-expression.\n\nIf `Body` is `[B1, ..., Bn]`, and `OptionalElse` is `none`, the result\nrepresents \"`maybe B1, ..., Bn end`\".  If `Body` is `[B1, ...,\nBn]`, and `OptionalElse` reprsents an `else_expr` node with clauses\n`[C1, ..., Cn]`, the result represents \"`maybe B1, ..., Bn else\nC1; ..., Cn end`\".\n\nSee `clause` for documentation on `m:erl_parse` clauses.\n\n_See also: _`maybe_expr_body/1`, `maybe_expr_else/1`.","ref":"erl_syntax.html#maybe_expr/2"},{"type":"function","title":"erl_syntax.maybe_expr_body/1","doc":"Returns the list of body subtrees of a `maybe_expr` node.\n\n_See also: _`maybe_expr/2`.","ref":"erl_syntax.html#maybe_expr_body/1"},{"type":"function","title":"erl_syntax.maybe_expr_else/1","doc":"Returns the else subtree of a `maybe_expr` node.\n\n_See also: _`maybe_expr/2`.","ref":"erl_syntax.html#maybe_expr_else/1"},{"type":"function","title":"erl_syntax.maybe_match_expr/2","doc":"Creates an abstract maybe-expression, as used in `maybe` blocks.\n\nThe result represents \"`Pattern ?= Body`\".\n\n_See also: _`maybe_expr/2`, `maybe_match_expr_body/1`,\n`maybe_match_expr_pattern/1`.","ref":"erl_syntax.html#maybe_match_expr/2"},{"type":"function","title":"erl_syntax.maybe_match_expr_body/1","doc":"Returns the body subtree of a `maybe_expr` node.\n\n_See also: _`maybe_match_expr/2`.","ref":"erl_syntax.html#maybe_match_expr_body/1"},{"type":"function","title":"erl_syntax.maybe_match_expr_pattern/1","doc":"Returns the pattern subtree of a `maybe_expr` node.\n\n_See also: _`maybe_match_expr/2`.","ref":"erl_syntax.html#maybe_match_expr_pattern/1"},{"type":"function","title":"erl_syntax.meta/1","doc":"Creates a meta-representation of a syntax tree.\n\nThe result represents an Erlang expression \"`MetaTree`\" which, if\nevaluated, will yield a new syntax tree representing the same source\ncode text as `Tree` (although the actual data representation may be\ndifferent). The expression represented by `MetaTree` is\n_implementation independent_ with regard to the data structures used\nby the abstract syntax tree implementation. Comments attached to nodes\nof `Tree` will be preserved, but other attributes are lost.\n\nAny node in `Tree` whose node type is `variable` (see `type/1`), and whose list\nof annotations (see `get_ann/1`) contains the atom `meta_var`, will remain\nunchanged in the resulting tree, except that exactly one occurrence of\n`meta_var` is removed from its annotation list.\n\nThe main use of the function [`meta/1`](`meta/1`) is to transform a\ndata structure `Tree`, which represents a piece of program code, into\na form that is _representation independent when printed_. For example,\nsuppose `Tree` represents a variable named \"V\". Then (assuming a\nfunction `print/1` for printing syntax trees), evaluating\n`print(abstract(Tree))` — simply using `abstract/1` to map the actual\ndata structure onto a syntax tree representation — would output a\nstring that might look something like \"`{tree, variable, ..., \"V\",\n...}`\", which is obviously dependent on the implementation of the\nabstract syntax trees. This could, for example, be useful for caching\na syntax tree in a file. However, in some situations like in a program\ngenerator generator (with two \"generator\"), it may be\nunacceptable. Using `print(meta(Tree))` instead would output a\n_representation independent_ syntax tree generating expression; in the\nabove case, something like \"`erl_syntax:variable(\"V\")`\".\n\n_See also: _`abstract/1`, `get_ann/1`, `type/1`.","ref":"erl_syntax.html#meta/1"},{"type":"function","title":"erl_syntax.module_qualifier/2","doc":"Creates an abstract module qualifier.\n\nThe result represents \"`Module:Body`\".\n\n_See also: _`module_qualifier_argument/1`, `module_qualifier_body/1`.","ref":"erl_syntax.html#module_qualifier/2"},{"type":"function","title":"erl_syntax.module_qualifier_argument/1","doc":"Returns the argument (the module) subtree of a `module_qualifier` node.\n\n_See also: _`module_qualifier/2`.","ref":"erl_syntax.html#module_qualifier_argument/1"},{"type":"function","title":"erl_syntax.module_qualifier_body/1","doc":"Returns the body subtree of a `module_qualifier` node.\n\n_See also: _`module_qualifier/2`.","ref":"erl_syntax.html#module_qualifier_body/1"},{"type":"function","title":"erl_syntax.named_fun_expr/2","doc":"Creates an abstract named fun-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`fun\nName C1; ...; Name Cn end`\". More exactly, if each `Ci`\nrepresents \"`(Pi1, ..., Pim) Gi -> Bi`\", then the result\nrepresents \"`fun Name(P11, ..., P1m) G1 -> B1; ...;\nName(Pn1, ..., Pnm) Gn -> Bn end`\".\n\n_See also: _`named_fun_expr_arity/1`, `named_fun_expr_clauses/1`,\n`named_fun_expr_name/1`.","ref":"erl_syntax.html#named_fun_expr/2"},{"type":"function","title":"erl_syntax.named_fun_expr_arity/1","doc":"Returns the arity of a `named_fun_expr` node.\n\nThe result is the number of parameter patterns in the first clause of\nthe named fun-expression; subsequent clauses are ignored.\n\nAn exception is thrown if\n[`named_fun_expr_clauses(Node)`](`named_fun_expr_clauses/1`) returns an empty\nlist, or if the first element of that list is not a syntax tree `C` of type\n`clause` such that [`clause_patterns(C)`](`clause_patterns/1`) is a nonempty\nlist.\n\n_See also: _`clause/3`, `clause_patterns/1`, `named_fun_expr/2`,\n`named_fun_expr_clauses/1`.","ref":"erl_syntax.html#named_fun_expr_arity/1"},{"type":"function","title":"erl_syntax.named_fun_expr_clauses/1","doc":"Returns the list of clause subtrees of a `named_fun_expr` node.\n\n_See also: _`named_fun_expr/2`.","ref":"erl_syntax.html#named_fun_expr_clauses/1"},{"type":"function","title":"erl_syntax.named_fun_expr_name/1","doc":"Returns the name subtree of a `named_fun_expr` node.\n\n_See also: _`named_fun_expr/2`.","ref":"erl_syntax.html#named_fun_expr_name/1"},{"type":"function","title":"erl_syntax.normalize_list/1","doc":"Expands an abstract list skeleton to its most explicit form.\n\nIf `Node` represents \"`[E1, ..., En | Tail]`\", the result\nrepresents \"`[E1 | ... [En | Tail1] ... ]`\", where `Tail1` is\nthe result of [`normalize_list(Tail)`](`normalize_list/1`). If `Node`\nrepresents \"`[E1, ..., En]`\", the result simply represents \"`[E1\n| ... [En | []] ... ]`\". If `Node` does not represent a list\nskeleton, `Node` itself is returned.\n\n_See also: _`compact_list/1`, `list/2`.","ref":"erl_syntax.html#normalize_list/1"},{"type":"function","title":"erl_syntax.operator/1","doc":"Creates an abstract operator.\n\nThe name of the operator is the character sequence represented by\n`Name`. This is analogous to the print name of an atom, but an\noperator is never written within single-quotes; for example, the\nresult of [`operator('++')`](`operator/1`) represents \"`++`\" rather\nthan \"`'++'`\".\n\n_See also: _`atom/1`, `operator_literal/1`, `operator_name/1`.","ref":"erl_syntax.html#operator/1"},{"type":"function","title":"erl_syntax.operator_literal/1","doc":"Returns the literal string represented by an `operator` node.\n\nThis is simply the operator name as a string.\n\n_See also: _`operator/1`.","ref":"erl_syntax.html#operator_literal/1"},{"type":"function","title":"erl_syntax.operator_name/1","doc":"Returns the name of an `operator` node.\n\nNote that the name is returned as an atom.\n\n_See also: _`operator/1`.","ref":"erl_syntax.html#operator_name/1"},{"type":"type","title":"erl_syntax.padding/0","doc":"","ref":"erl_syntax.html#t:padding/0"},{"type":"function","title":"erl_syntax.parentheses/1","doc":"Creates an abstract parenthesised expression.\n\nThe result represents \"`(Body)`\", independently of the context.\n\n_See also: _`parentheses_body/1`.","ref":"erl_syntax.html#parentheses/1"},{"type":"function","title":"erl_syntax.parentheses_body/1","doc":"Returns the body subtree of a `parentheses` node.\n\n_See also: _`parentheses/1`.","ref":"erl_syntax.html#parentheses_body/1"},{"type":"function","title":"erl_syntax.prefix_expr/2","doc":"Creates an abstract prefix operator expression.\n\nThe result represents \"`Operator Argument`\".\n\n_See also: _`infix_expr/3`, `prefix_expr_argument/1`, `prefix_expr_operator/1`.","ref":"erl_syntax.html#prefix_expr/2"},{"type":"function","title":"erl_syntax.prefix_expr_argument/1","doc":"Returns the argument subtree of a `prefix_expr` node.\n\n_See also: _`prefix_expr/2`.","ref":"erl_syntax.html#prefix_expr_argument/1"},{"type":"function","title":"erl_syntax.prefix_expr_operator/1","doc":"Returns the operator subtree of a `prefix_expr` node.\n\n_See also: _`prefix_expr/2`.","ref":"erl_syntax.html#prefix_expr_operator/1"},{"type":"function","title":"erl_syntax.receive_expr/1","doc":"","ref":"erl_syntax.html#receive_expr/1"},{"type":"function","title":"erl_syntax.receive_expr/3","doc":"Creates an abstract receive-expression.\n\nIf `Timeout` is `none`, the result represents \"`receive C1; ...;\nCn end`\" (the `Action` argument is ignored).  Otherwise, if\n`Clauses` is `[C1, ..., Cn]` and `Action` is `[A1, ..., Am]`, the\nresult represents \"`receive C1; ...; Cn after Timeout -> A1,\n..., Am end`\". More exactly, if each `Ci` represents \"`(Pi) Gi\n-> Bi`\", then the result represents \"`receive P1 G1 -> B1; ...;\nPn Gn -> Bn ... end`\".\n\nNote that in Erlang, a receive-expression must have at least one clause if no\ntimeout part is specified.\n\n_See also: _`case_expr/2`, `clause/3`, `receive_expr/1`,\n`receive_expr_action/1`, `receive_expr_clauses/1`, `receive_expr_timeout/1`.","ref":"erl_syntax.html#receive_expr/3"},{"type":"function","title":"erl_syntax.receive_expr_action/1","doc":"Returns the list of action body subtrees of a `receive_expr` node.\n\nIf `Node` represents \"`receive C1; ...; Cn end`\", this is the\nempty list.\n\n_See also: _`receive_expr/3`.","ref":"erl_syntax.html#receive_expr_action/1"},{"type":"function","title":"erl_syntax.receive_expr_clauses/1","doc":"Returns the list of clause subtrees of a `receive_expr` node.\n\n_See also: _`receive_expr/3`.","ref":"erl_syntax.html#receive_expr_clauses/1"},{"type":"function","title":"erl_syntax.receive_expr_timeout/1","doc":"Returns the timeout subtree of a `receive_expr` node, if any.\n\nIf `Node` represents \"`receive C1; ...; Cn end`\", `none` is\nreturned. Otherwise, if `Node` represents \"`receive C1; ...; Cn\nafter Timeout -> ... end`\", `Timeout` is returned.\n\n_See also: _`receive_expr/3`.","ref":"erl_syntax.html#receive_expr_timeout/1"},{"type":"function","title":"erl_syntax.record_access/3","doc":"Creates an abstract record field access expression.\n\nThe result represents \"`Argument#Type.Field`\".\n\n_See also: _`record_access_argument/1`, `record_access_field/1`,\n`record_access_type/1`, `record_expr/3`.","ref":"erl_syntax.html#record_access/3"},{"type":"function","title":"erl_syntax.record_access_argument/1","doc":"Returns the argument subtree of a `record_access` node.\n\n_See also: _`record_access/3`.","ref":"erl_syntax.html#record_access_argument/1"},{"type":"function","title":"erl_syntax.record_access_field/1","doc":"Returns the field subtree of a `record_access` node.\n\n_See also: _`record_access/3`.","ref":"erl_syntax.html#record_access_field/1"},{"type":"function","title":"erl_syntax.record_access_type/1","doc":"Returns the type subtree of a `record_access` node.\n\n_See also: _`record_access/3`.","ref":"erl_syntax.html#record_access_type/1"},{"type":"function","title":"erl_syntax.record_expr/2","doc":"","ref":"erl_syntax.html#record_expr/2"},{"type":"function","title":"erl_syntax.record_expr/3","doc":"Creates an abstract record expression.\n\nIf `Fields` is `[F1, ..., Fn]`, then if `Argument` is `none`, the\nresult represents \"`#Type{F1, ..., Fn}`\", otherwise it\nrepresents \"`Argument#Type{F1, ..., Fn}`\".\n\n_See also: _`record_access/3`, `record_expr/2`, `record_expr_argument/1`,\n`record_expr_fields/1`, `record_expr_type/1`, `record_field/2`,\n`record_index_expr/2`.","ref":"erl_syntax.html#record_expr/3"},{"type":"function","title":"erl_syntax.record_expr_argument/1","doc":"Returns the argument subtree of a `record_expr` node, if any.\n\nIf `Node` represents \"`#Type{...}`\", `none` is returned. Otherwise,\nif `Node` represents \"`Argument#Type{...}`\", `Argument` is\nreturned.\n\n_See also: _`record_expr/3`.","ref":"erl_syntax.html#record_expr_argument/1"},{"type":"function","title":"erl_syntax.record_expr_fields/1","doc":"Returns the list of field subtrees of a `record_expr` node.\n\n_See also: _`record_expr/3`.","ref":"erl_syntax.html#record_expr_fields/1"},{"type":"function","title":"erl_syntax.record_expr_type/1","doc":"Returns the type subtree of a `record_expr` node.\n\n_See also: _`record_expr/3`.","ref":"erl_syntax.html#record_expr_type/1"},{"type":"function","title":"erl_syntax.record_field/1","doc":"","ref":"erl_syntax.html#record_field/1"},{"type":"function","title":"erl_syntax.record_field/2","doc":"Creates an abstract record field specification.\n\nIf `Value` is `none`, the result represents simply \"`Name`\",\notherwise it represents \"`Name = Value`\".\n\n_See also: _`record_expr/3`, `record_field_name/1`, `record_field_value/1`.","ref":"erl_syntax.html#record_field/2"},{"type":"function","title":"erl_syntax.record_field_name/1","doc":"Returns the name subtree of a `record_field` node.\n\n_See also: _`record_field/2`.","ref":"erl_syntax.html#record_field_name/1"},{"type":"function","title":"erl_syntax.record_field_value/1","doc":"Returns the value subtree of a `record_field` node, if any.\n\nIf `Node` represents \"`Name`\", `none` is returned. Otherwise, if\n`Node` represents \"`Name = Value`\", `Value` is returned.\n\n_See also: _`record_field/2`.","ref":"erl_syntax.html#record_field_value/1"},{"type":"function","title":"erl_syntax.record_index_expr/2","doc":"Creates an abstract record field index expression. The result represents\n\"`#Type.Field`\".\n\n> #### Note {: .info }\n>\n> The function name `record_index/2` is reserved by the Erlang compiler,\n> which is why that name could not be used for this constructor.\n\n_See also: _`record_expr/3`, `record_index_expr_field/1`,\n`record_index_expr_type/1`.","ref":"erl_syntax.html#record_index_expr/2"},{"type":"function","title":"erl_syntax.record_index_expr_field/1","doc":"Returns the field subtree of a `record_index_expr` node.\n\n_See also: _`record_index_expr/2`.","ref":"erl_syntax.html#record_index_expr_field/1"},{"type":"function","title":"erl_syntax.record_index_expr_type/1","doc":"Returns the type subtree of a `record_index_expr` node.\n\n_See also: _`record_index_expr/2`.","ref":"erl_syntax.html#record_index_expr_type/1"},{"type":"function","title":"erl_syntax.record_type/2","doc":"Creates an abstract record type.\n\nIf `Fields` is `[F1, ..., Fn]`, the result represents \"`#Name{F1,\n..., Fn}`\".\n\n_See also: _`record_type_fields/1`, `record_type_name/1`.","ref":"erl_syntax.html#record_type/2"},{"type":"function","title":"erl_syntax.record_type_field/2","doc":"Creates an abstract record type field.\n\nThe result represents \"`Name :: Type`\".\n\n_See also: _`record_type_field_name/1`, `record_type_field_type/1`.","ref":"erl_syntax.html#record_type_field/2"},{"type":"function","title":"erl_syntax.record_type_field_name/1","doc":"Returns the name subtree of a `record_type_field` node.\n\n_See also: _`record_type_field/2`.","ref":"erl_syntax.html#record_type_field_name/1"},{"type":"function","title":"erl_syntax.record_type_field_type/1","doc":"Returns the type subtree of a `record_type_field` node.\n\n_See also: _`record_type_field/2`.","ref":"erl_syntax.html#record_type_field_type/1"},{"type":"function","title":"erl_syntax.record_type_fields/1","doc":"Returns the fields subtree of a `record_type` node.\n\n_See also: _`record_type/2`.","ref":"erl_syntax.html#record_type_fields/1"},{"type":"function","title":"erl_syntax.record_type_name/1","doc":"Returns the name subtree of a `record_type` node.\n\n_See also: _`record_type/2`.","ref":"erl_syntax.html#record_type_name/1"},{"type":"function","title":"erl_syntax.remove_comments/1","doc":"Clears the associated comments of `Node`.\n\nNote: This is equivalent to\n[`set_precomments(set_postcomments(Node, []), [])`](`set_precomments/2`), but\npotentially more efficient.\n\n_See also: _`set_postcomments/2`, `set_precomments/2`.","ref":"erl_syntax.html#remove_comments/1"},{"type":"function","title":"erl_syntax.revert/1","doc":"Returns an `m:erl_parse`-compatible representation of a syntax tree, if possible.\n\nIf `Tree` represents a well-formed Erlang program or expression, the conversion\nshould work without problems. Typically, `is_tree/1` yields `true` if conversion\nfailed (that is, the result is still an abstract syntax tree), and `false`\notherwise.\n\nThe `is_tree/1` test is not completely foolproof. For a few special\nnode types (for example `arity_qualifier`), if such a node occurs in a\ncontext where it is not expected, it will be left unchanged as a\nnon-reverted subtree of the result.  This can only happen if `Tree`\ndoes not actually represent legal Erlang code.\n\n_See also: _[//stdlib/erl_parse](`m:erl_parse`), `revert_forms/1`.","ref":"erl_syntax.html#revert/1"},{"type":"function","title":"erl_syntax.revert_forms/1","doc":"Reverts a sequence of Erlang source code forms.\n\nThe sequence can be given either as a `form_list` syntax tree\n(possibly nested), or as a list of \"program form\" syntax trees. If\nsuccessful, the corresponding flat list of `m:erl_parse`-compatible\nsyntax trees is returned (see `revert/1`). If some program form could\nnot be reverted, `{error, Form}` is thrown. Standalone comments in the\nform sequence are discarded.\n\n_See also: _`form_list/1`, `is_form/1`, `revert/1`.","ref":"erl_syntax.html#revert_forms/1"},{"type":"function","title":"erl_syntax.set_ann/2","doc":"Sets the list of user annotations of `Node` to `Annotations`.\n\n_See also: _`add_ann/2`, `copy_ann/2`, `get_ann/1`.","ref":"erl_syntax.html#set_ann/2"},{"type":"function","title":"erl_syntax.set_attrs/2","doc":"Sets the attributes of `Node` to `Attributes`.\n\n_See also: _`copy_attrs/2`, `get_attrs/1`.","ref":"erl_syntax.html#set_attrs/2"},{"type":"function","title":"erl_syntax.set_pos/2","doc":"Sets the position information of `Node` to `Pos`.\n\n_See also: _`copy_pos/2`, `get_pos/1`.","ref":"erl_syntax.html#set_pos/2"},{"type":"function","title":"erl_syntax.set_postcomments/2","doc":"Sets the post-comments of `Node` to `Comments`.\n\n`Comments` should be a possibly empty list of abstract comments, in\ntop-down textual order\n\n_See also: _`add_postcomments/2`, `comment/2`, `copy_comments/2`,\n`get_postcomments/1`, `join_comments/2`, `remove_comments/1`,\n`set_precomments/2`.","ref":"erl_syntax.html#set_postcomments/2"},{"type":"function","title":"erl_syntax.set_precomments/2","doc":"Sets the pre-comments of `Node` to `Comments`.\n\n`Comments` should be a possibly empty list of abstract comments, in\ntop-down textual order.\n\n_See also: _`add_precomments/2`, `comment/2`, `copy_comments/2`,\n`get_precomments/1`, `join_comments/2`, `remove_comments/1`,\n`set_postcomments/2`.","ref":"erl_syntax.html#set_precomments/2"},{"type":"function","title":"erl_syntax.size_qualifier/2","doc":"Creates an abstract size qualifier.\n\nThe result represents \"`Body:Size`\".\n\n_See also: _`size_qualifier_argument/1`, `size_qualifier_body/1`.","ref":"erl_syntax.html#size_qualifier/2"},{"type":"function","title":"erl_syntax.size_qualifier_argument/1","doc":"Returns the argument subtree (the size) of a `size_qualifier` node.\n\n_See also: _`size_qualifier/2`.","ref":"erl_syntax.html#size_qualifier_argument/1"},{"type":"function","title":"erl_syntax.size_qualifier_body/1","doc":"Returns the body subtree of a `size_qualifier` node.\n\n_See also: _`size_qualifier/2`.","ref":"erl_syntax.html#size_qualifier_body/1"},{"type":"function","title":"erl_syntax.string/1","doc":"Creates an abstract string literal.\n\nThe result represents `\"Text\"` (including the surrounding\ndouble-quotes), where `Text` corresponds to the sequence of characters\nin `Value`, but not representing a _specific_ string literal.\n\nFor example, the result of [`string(\"x\\ny\")`](`string/1`) represents any and all\nof `\"x\\ny\"`, `\"x\\12y\"`, `\"x\\012y\"` and `\"x\\^Jy\"`; see `char/1`.\n\n_See also: _`char/1`, `is_string/2`, `string_literal/1`, `string_literal/2`,\n`string_value/1`.","ref":"erl_syntax.html#string/1"},{"type":"function","title":"erl_syntax.string_literal/1","doc":"Returns the literal string represented by a `string` node.\n\nThis includes surrounding double-quote characters. Characters beyond\n255 will be escaped.\n\n_See also: _`string/1`.","ref":"erl_syntax.html#string_literal/1"},{"type":"function","title":"erl_syntax.string_literal/2","doc":"Returns the literal string represented by a `string` node.\n\nThis includes surrounding double-quote characters. Depending on the\nencoding characters beyond 255 will be escaped (`latin1`) or copied as\nis (`utf8`).\n\n_See also: _`string/1`.","ref":"erl_syntax.html#string_literal/2"},{"type":"function","title":"erl_syntax.string_value/1","doc":"Returns the value represented by a `string` node.\n\n_See also: _`string/1`.","ref":"erl_syntax.html#string_value/1"},{"type":"function","title":"erl_syntax.subtrees/1","doc":"Returns the grouped list of all subtrees of a syntax tree.\n\nIf `Node` is a leaf node (see `is_leaf/1`), this is the empty list,\notherwise the result is always a nonempty list, containing the lists\nof subtrees of `Node`, in left-to-right order as they occur in the\nprinted program text, and grouped by category. Often, each group\ncontains only a single subtree.\n\nDepending on the type of `Node`, the size of some groups may be\nvariable (for example, the group consisting of all the elements of a\ntuple), while others always contain the same number of elements —\nusually exactly one (for example, the group containing the argument\nexpression of a case-expression). Note, however, that the exact\nstructure of the returned list (for a given node type) should in\ngeneral not be depended upon, since it might be subject to change\nwithout notice.\n\nThe function `subtrees/1` and the constructor functions `make_tree/2` and\n`update_tree/2` can be a great help if one wants to traverse a syntax tree,\nvisiting all its subtrees, but treat nodes of the tree in a uniform way in most\nor all cases. Using these functions makes this simple, and also assures that\nyour code is not overly sensitive to extensions of the syntax tree data type,\nbecause any node types not explicitly handled by your code can be left to a\ndefault case.\n\nFor example:\n\n```text\n     postorder(F, Tree) ->\n        F(case subtrees(Tree) of\n            [] -> Tree;\n            List -> update_tree(Tree,\n                                [[postorder(F, Subtree)\n                                  || Subtree &lt;- Group]\n                                 || Group &lt;- List])\n          end).\n```\n\nmaps the function `F` on `Tree` and all its subtrees, doing a post-order\ntraversal of the syntax tree. (Note the use of `update_tree/2` to preserve node\nattributes.) For a simple function like:\n\n```text\n     f(Node) ->\n        case type(Node) of\n            atom -> atom(\"a_\" ++ atom_name(Node));\n            _ -> Node\n        end.\n```\n\nthe call `postorder(fun f/1, Tree)` will yield a new representation of `Tree` in\nwhich all atom names have been extended with the prefix \"a_\", but nothing else\n(including comments, annotations, and line numbers) has been changed.\n\n_See also: _`copy_attrs/2`, `is_leaf/1`, `make_tree/2`, `type/1`.","ref":"erl_syntax.html#subtrees/1"},{"type":"type","title":"erl_syntax.syntaxTree/0","doc":"","ref":"erl_syntax.html#t:syntaxTree/0"},{"type":"type","title":"erl_syntax.syntaxTreeAttributes/0","doc":"","ref":"erl_syntax.html#t:syntaxTreeAttributes/0"},{"type":"function","title":"erl_syntax.text/1","doc":"Creates an abstract piece of source code text.\n\nThe result represents exactly the sequence of characters in\n`String`. This is useful in cases where one wants full control of the\nresulting output, such as the appearance of floating-point numbers or\nmacro definitions.\n\n_See also: _`text_string/1`.","ref":"erl_syntax.html#text/1"},{"type":"function","title":"erl_syntax.text_string/1","doc":"Returns the character sequence represented by a `text` node.\n\n_See also: _`text/1`.","ref":"erl_syntax.html#text_string/1"},{"type":"type","title":"erl_syntax.tree/0","doc":"","ref":"erl_syntax.html#t:tree/0"},{"type":"function","title":"erl_syntax.tree/1","doc":"","ref":"erl_syntax.html#tree/1"},{"type":"function","title":"erl_syntax.tree/2","doc":"**For special purposes only**. Creates an abstract syntax tree node with type tag\n`Type` and associated data `Data`.\n\nThis function and the related `is_tree/1` and `data/1` provide a uniform way to\nextend the set of `erl_parse` node types. The associated data is any term, whose\nformat may depend on the type tag.\n\n> #### Notes {: .info }\n>\n> - Any nodes created outside of this module must have type tags distinct from\n>   those currently defined by this module; see `type/1` for a complete list.\n>\n> - The type tag of a syntax tree node may also be used as a primary tag by the\n>   `erl_parse` representation; in that case, the selector functions for that node\n>   type _must_ handle both the abstract syntax tree and the `m:erl_parse` form. The\n>   function [`type(T)`](`type/1`) should return the correct type tag regardless\n>   of the representation of `T`, so that the user sees no difference between\n>   `erl_syntax` and `erl_parse` nodes.\n\n_See also: _`data/1`, `is_tree/1`, `type/1`.","ref":"erl_syntax.html#tree/2"},{"type":"function","title":"erl_syntax.try_after_expr/2","doc":"","ref":"erl_syntax.html#try_after_expr/2"},{"type":"function","title":"erl_syntax.try_expr/2","doc":"","ref":"erl_syntax.html#try_expr/2"},{"type":"function","title":"erl_syntax.try_expr/3","doc":"","ref":"erl_syntax.html#try_expr/3"},{"type":"function","title":"erl_syntax.try_expr/4","doc":"Creates an abstract try-expression.\n\nIf `Body` is `[B1, ..., Bn]`, `Clauses` is `[C1, ..., Cj]`, `Handlers`\nis `[H1, ..., Hk]`, and `After` is `[A1, ..., Am]`, the result\nrepresents \"`try B1, ..., Bn of C1; ...; Cj catch H1; ...; Hk after\nA1, ..., Am end`\".  More exactly, if each `Ci` represents \"`(CPi) CGi\n-> CBi`\", and each `Hi` represents \"`(HPi) HGi -> HBi`\", then the\nresult represents \"`try B1, ..., Bn of CP1 CG1 -> CB1; ...; CPj CGj ->\nCBj catch HP1 HG1 -> HB1; ...; HPk HGk -> HBk after A1, ..., Am end`\";\nsee `case_expr/2`. If `Clauses` is the empty list, the `of ...`\nsection is left out. If `After` is the empty list, the `after ...`\nsection is left out. If `Handlers` is the empty list, and `After` is\nnonempty, the `catch ...` section is left out.\n\n_See also: _`case_expr/2`, `class_qualifier/2`, `clause/3`, `try_after_expr/2`,\n`try_expr/2`, `try_expr/3`, `try_expr_after/1`, `try_expr_body/1`,\n`try_expr_clauses/1`, `try_expr_handlers/1`.","ref":"erl_syntax.html#try_expr/4"},{"type":"function","title":"erl_syntax.try_expr_after/1","doc":"Returns the list of \"after\" subtrees of a `try_expr` node.\n\n_See also: _`try_expr/4`.","ref":"erl_syntax.html#try_expr_after/1"},{"type":"function","title":"erl_syntax.try_expr_body/1","doc":"Returns the list of body subtrees of a `try_expr` node.\n\n_See also: _`try_expr/4`.","ref":"erl_syntax.html#try_expr_body/1"},{"type":"function","title":"erl_syntax.try_expr_clauses/1","doc":"Returns the list of case-clause subtrees of a `try_expr` node. If `Node`\nrepresents \"`try Body catch H1; ...; Hn end`\", the result is the empty\nlist.\n\n_See also: _`try_expr/4`.","ref":"erl_syntax.html#try_expr_clauses/1"},{"type":"function","title":"erl_syntax.try_expr_handlers/1","doc":"Returns the list of handler-clause subtrees of a `try_expr` node.\n\n_See also: _`try_expr/4`.","ref":"erl_syntax.html#try_expr_handlers/1"},{"type":"function","title":"erl_syntax.tuple/1","doc":"Creates an abstract tuple.\n\nIf `Elements` is `[X1, ..., Xn]`, the result represents \"`{X1, ...,\nXn}`\".\n\n> #### Note {: .info }\n>\n> The Erlang language has distinct 1-tuples, meaning `{X}` is always distinct\n> from `X` itself.\n\n_See also: _`tuple_elements/1`, `tuple_size/1`.","ref":"erl_syntax.html#tuple/1"},{"type":"function","title":"erl_syntax.tuple_elements/1","doc":"Returns the list of element subtrees of a `tuple` node.\n\n_See also: _`tuple/1`.","ref":"erl_syntax.html#tuple_elements/1"},{"type":"function","title":"erl_syntax.tuple_size/1","doc":"Returns the number of elements of a `tuple` node.\n\n> #### Note {: .info }\n>\n> This is equivalent to [`length(tuple_elements(Node))`](`length/1`),\n> but potentially more efficient.\n\n_See also: _`tuple/1`, `tuple_elements/1`.","ref":"erl_syntax.html#tuple_size/1"},{"type":"function","title":"erl_syntax.tuple_type/0","doc":"","ref":"erl_syntax.html#tuple_type/0"},{"type":"function","title":"erl_syntax.tuple_type/1","doc":"Creates an abstract type tuple.\n\nIf `Elements` is `[T1, ..., Tn]`, the result represents \"`{T1, ...,\nTn}`\"; otherwise, if `Elements` is `any_size`, it represents\n\"`t:tuple/0`\".\n\n_See also: _`tuple_type_elements/1`.","ref":"erl_syntax.html#tuple_type/1"},{"type":"function","title":"erl_syntax.tuple_type_elements/1","doc":"Returns the list of type element subtrees of a `tuple_type` node.\n\nIf `Node` represents \"`t:tuple/0`\", `any_size` is returned; otherwise,\nif `Node` represents \"`{T1, ..., Tn}`\", `[T1, ..., Tn]` is returned.\n\n_See also: _`tuple_type/0`, `tuple_type/1`.","ref":"erl_syntax.html#tuple_type_elements/1"},{"type":"function","title":"erl_syntax.type/1","doc":"Returns the type tag of `Node`.\n\nIf `Node` does not represent a syntax tree, evaluation fails with\nreason `badarg`. Node types currently defined by this module are:\n\n* `application`\n* `annotated_type`\n* `arity_qualifier`\n* `atom`\n* `attribute`\n* `binary`\n* `binary_field`\n* `bitstring_type`\n* `block_expr`\n* `case_expr`\n* `catch_expr`\n* `char`\n* `class_qualifier`\n* `clause`\n* `comment`\n* `conjunction`\n* `constrained_function_type`\n* `constraint`\n* `disjunction`\n* `else_expr`\n* `eof_marker`\n* `error_marker`\n* `float`\n* `form_list`\n* `fun_expr`\n* `fun_type`\n* `function`\n* `function_type`\n* `generator`\n* `if_expr`\n* `implicit_fun`\n* `infix_expr`\n* `integer`\n* `integer_range_type`\n* `list`\n* `list_comp`\n* `macro`\n* `map_expr`\n* `map_field_assoc`\n* `map_field_exact`\n* `map_type`\n* `map_type_assoc`\n* `map_type_exact`\n* `match_expr`\n* `maybe_expr`\n* `maybe_match_expr`\n* `module_qualifier`\n* `named_fun_expr`\n* `nil`\n* `operator`\n* `parentheses`\n* `prefix_expr`\n* `receive_expr`\n* `record_access`\n* `record_expr`\n* `record_field`\n* `record_index_expr`\n* `record_type`\n* `record_type_field`\n* `size_qualifier`\n* `string`\n* `text`\n* `try_expr`\n* `tuple`\n* `tuple_type`\n* `typed_record_field`\n* `type_application`\n* `type_union`\n* `underscore`\n* `user_type_application`\n* `variable`\n* `warning_marker`\n\nThe user may (for special purposes) create additional nodes with other type\ntags, using the `tree/2` function.\n\nNote: The primary constructor functions for a node type should always have the\nsame name as the node type itself.\n\n_See also: _`annotated_type/2`, `application/3`, `arity_qualifier/2`, `atom/1`,\n`attribute/2`, `binary/1`, `binary_field/2`, `bitstring_type/2`, `block_expr/1`,\n`case_expr/2`, `catch_expr/1`, `char/1`, `class_qualifier/2`, `clause/3`,\n`comment/2`, `conjunction/1`, `constrained_function_type/2`, `constraint/2`,\n`disjunction/1`, `else_expr/1`, `eof_marker/0`, `error_marker/1`, `float/1`,\n`form_list/1`, `fun_expr/1`, `fun_type/0`, `function/2`, `function_type/1`,\n`function_type/2`, `generator/2`, `if_expr/1`, `implicit_fun/2`, `infix_expr/3`,\n`integer/1`, `integer_range_type/2`, `list/2`, `list_comp/2`, `macro/2`,\n`map_expr/2`, `map_field_assoc/2`, `map_field_exact/2`, `map_type/0`,\n`map_type/1`, `map_type_assoc/2`, `map_type_exact/2`, `match_expr/2`,\n`maybe_expr/1`, `maybe_expr/2`, `maybe_match_expr/2`, `module_qualifier/2`,\n`named_fun_expr/2`, `nil/0`, `operator/1`, `parentheses/1`, `prefix_expr/2`,\n`receive_expr/3`, `record_access/3`, `record_expr/2`, `record_field/2`,\n`record_index_expr/2`, `record_type/2`, `record_type_field/2`,\n`size_qualifier/2`, `string/1`, `text/1`, `tree/2`, `try_expr/3`, `tuple/1`,\n`tuple_type/0`, `tuple_type/1`, `type_application/2`, `type_union/1`,\n`typed_record_field/2`, `underscore/0`, `user_type_application/2`, `variable/1`,\n`warning_marker/1`.","ref":"erl_syntax.html#type/1"},{"type":"function","title":"erl_syntax.type_application/2","doc":"Creates an abstract type application expression.\n\nIf `Arguments` is `[T1, ..., Tn]`, the result represents\n\"`TypeName(T1, ...Tn)`\".\n\n_See also: _`type_application/3`, `type_application_arguments/1`,\n`type_application_name/1`, `user_type_application/2`.","ref":"erl_syntax.html#type_application/2"},{"type":"function","title":"erl_syntax.type_application/3","doc":"Creates an abstract type application expression.\n\nIf `Module` is `none`, this is call is equivalent to\n[`type_application(TypeName, Arguments)`](`type_application/2`),\notherwise it is equivalent to\n[`type_application(module_qualifier(Module, TypeName),\nArguments)`](`type_application/2`).\n\n(This is a utility function.)\n\n_See also: _`module_qualifier/2`, `type_application/2`.","ref":"erl_syntax.html#type_application/3"},{"type":"function","title":"erl_syntax.type_application_arguments/1","doc":"Returns the arguments subtrees of a `type_application` node.\n\n_See also: _`type_application/2`.","ref":"erl_syntax.html#type_application_arguments/1"},{"type":"function","title":"erl_syntax.type_application_name/1","doc":"Returns the type name subtree of a `type_application` node.\n\n_See also: _`type_application/2`.","ref":"erl_syntax.html#type_application_name/1"},{"type":"function","title":"erl_syntax.type_union/1","doc":"Creates an abstract type union.\n\nIf `Types` is `[T1, ..., Tn]`, the result represents \"`T1 | ... |\nTn`\".\n\n_See also: _`type_union_types/1`.","ref":"erl_syntax.html#type_union/1"},{"type":"function","title":"erl_syntax.type_union_types/1","doc":"Returns the list of type subtrees of a `type_union` node.\n\n_See also: _`type_union/1`.","ref":"erl_syntax.html#type_union_types/1"},{"type":"function","title":"erl_syntax.typed_record_field/2","doc":"Creates an abstract typed record field specification.\n\nThe result represents \"`Field :: Type`\".\n\n_See also: _`typed_record_field_body/1`, `typed_record_field_type/1`.","ref":"erl_syntax.html#typed_record_field/2"},{"type":"function","title":"erl_syntax.typed_record_field_body/1","doc":"Returns the field subtree of a `typed_record_field` node.\n\n_See also: _`typed_record_field/2`.","ref":"erl_syntax.html#typed_record_field_body/1"},{"type":"function","title":"erl_syntax.typed_record_field_type/1","doc":"Returns the type subtree of a `typed_record_field` node.\n\n_See also: _`typed_record_field/2`.","ref":"erl_syntax.html#typed_record_field_type/1"},{"type":"function","title":"erl_syntax.underscore/0","doc":"Creates an abstract universal pattern (\"`_`\").\n\nThe lexical representation is a single underscore character. Note that\nthis is _not_ a variable, lexically speaking.\n\n_See also: _`variable/1`.","ref":"erl_syntax.html#underscore/0"},{"type":"function","title":"erl_syntax.update_tree/2","doc":"Creates a syntax tree with the same type and attributes as the given tree.\n\nThis is equivalent to [`copy_attrs(Node, make_tree(type(Node),\nGroups))`](`copy_attrs/2`).\n\n_See also: _`copy_attrs/2`, `make_tree/2`, `type/1`.","ref":"erl_syntax.html#update_tree/2"},{"type":"function","title":"erl_syntax.user_type_application/2","doc":"Creates an abstract user type.\n\nIf `Arguments` is `[T1, ..., Tn]`, the result represents\n\"`TypeName(T1, ...Tn)`\".\n\n_See also: _`type_application/2`, `user_type_application_arguments/1`,\n`user_type_application_name/1`.","ref":"erl_syntax.html#user_type_application/2"},{"type":"function","title":"erl_syntax.user_type_application_arguments/1","doc":"Returns the arguments subtrees of a `user_type_application` node.\n\n_See also: _`user_type_application/2`.","ref":"erl_syntax.html#user_type_application_arguments/1"},{"type":"function","title":"erl_syntax.user_type_application_name/1","doc":"Returns the type name subtree of a `user_type_application` node.\n\n_See also: _`user_type_application/2`.","ref":"erl_syntax.html#user_type_application_name/1"},{"type":"function","title":"erl_syntax.variable/1","doc":"Creates an abstract variable with the given name.\n\n`Name` may be any atom or string that represents a lexically valid\nvariable name, but _not_ a single underscore character; see\n`underscore/0`.\n\n> #### Note {: .info }\n>\n> No check is performed to verify whether the character sequence\n> represents a proper variable name, that is, whether its first character\n> is an uppercase Erlang character, or whether it contains illegal characters\n> such as control characters or whitespace.\n\n_See also: _`underscore/0`, `variable_literal/1`, `variable_name/1`.","ref":"erl_syntax.html#variable/1"},{"type":"function","title":"erl_syntax.variable_literal/1","doc":"Returns the name of a `variable` node as a string.\n\n_See also: _`variable/1`.","ref":"erl_syntax.html#variable_literal/1"},{"type":"function","title":"erl_syntax.variable_name/1","doc":"Returns the name of a `variable` node as an atom.\n\n_See also: _`variable/1`.","ref":"erl_syntax.html#variable_name/1"},{"type":"function","title":"erl_syntax.warning_marker/1","doc":"Creates an abstract warning marker.\n\nThe result represents an occurrence of a possible problem in the\nsource code, with an associated Erlang I/O ErrorInfo structure given\nby `Error` (see module [`//stdlib/io`](`m:io`) for details). Warning\nmarkers are regarded as source code forms, but have no defined lexical\nform.\n\n> #### Note {: .info }\n>\n> This is supported only for backwards compatibility with existing parsers\n> and tools.\n\n_See also: _`eof_marker/0`, `error_marker/1`, `is_form/1`,\n`warning_marker_info/1`.","ref":"erl_syntax.html#warning_marker/1"},{"type":"function","title":"erl_syntax.warning_marker_info/1","doc":"Returns the ErrorInfo structure of a `warning_marker` node.\n\n_See also: _`warning_marker/1`.","ref":"erl_syntax.html#warning_marker_info/1"},{"type":"type","title":"erl_syntax.wrapper/0","doc":"","ref":"erl_syntax.html#t:wrapper/0"},{"type":"module","title":"erl_syntax_lib","doc":"Support library for abstract Erlang syntax trees.\n\nThis module contains utility functions for working with the abstract data type\ndefined in the module `m:erl_syntax`.","ref":"erl_syntax_lib.html"},{"type":"function","title":"erl_syntax_lib.analyze_application/1","doc":"Returns the name of a called function.\n\nThe result is a representation of the name of the applied function\n`F/A`, if `Node` represents a function application \"`F(X_1, ...,\nX_A)`\". If the function is not explicitly named (that is, `F` is given\nby some expression), only the arity `A` is returned.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\napplication expression.\n\n_See also: _`analyze_function_name/1`.","ref":"erl_syntax_lib.html#analyze_application/1"},{"type":"function","title":"erl_syntax_lib.analyze_attribute/1","doc":"Analyzes an attribute node.\n\nIf `Node` represents a preprocessor directive, the atom `preprocessor`\nis returned. Otherwise, if `Node` represents a module attribute\n\"`-Name...`\", a tuple `{Name, Info}` is returned, where `Info` depends\non `Name`, as follows:\n\n- **`{module, Info}`** - where `Info = analyze_module_attribute(Node)`.\n\n- **`{export, Info}`** - where `Info = analyze_export_attribute(Node)`.\n\n- **`{import, Info}`** - where `Info = analyze_import_attribute(Node)`.\n\n- **`{file, Info}`** - where `Info = analyze_file_attribute(Node)`.\n\n- **`{record, Info}`** - where `Info = analyze_record_attribute(Node)`.\n\n- **`{Name, Info}`** - where `{Name, Info} = analyze_wild_attribute(Node)`.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nmodule attribute.\n\n_See also: _`analyze_export_attribute/1`, `analyze_file_attribute/1`,\n`analyze_import_attribute/1`, `analyze_module_attribute/1`,\n`analyze_record_attribute/1`, `analyze_wild_attribute/1`.","ref":"erl_syntax_lib.html#analyze_attribute/1"},{"type":"function","title":"erl_syntax_lib.analyze_export_attribute/1","doc":"Returns the list of function names declared by an export attribute.\n\nWe do not guarantee that each name occurs at most once in the\nlist. The order of listing is not defined.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nexport attribute.\n\n_See also: _`analyze_attribute/1`.","ref":"erl_syntax_lib.html#analyze_export_attribute/1"},{"type":"function","title":"erl_syntax_lib.analyze_file_attribute/1","doc":"Returns the file name and line number of a `file` attribute.\n\nThe result is the pair `{File, Line}` if `Node` represents\n\"`-file(File, Line).`\".\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\n`file` attribute.\n\n_See also: _`analyze_attribute/1`.","ref":"erl_syntax_lib.html#analyze_file_attribute/1"},{"type":"function","title":"erl_syntax_lib.analyze_form/1","doc":"Analyzes a \"source code form\" node.\n\nIf `Node` is a \"form\" type (see `erl_syntax:is_form/1`), the returned\nvalue is a tuple `{Type, Info}` where `Type` is the node type and\n`Info` depends on `Type`, as follows:\n\n- **`{attribute, Info}`** - where `Info = analyze_attribute(Node)`.\n\n- **`{error_marker, Info}`** - where\n  `Info = erl_syntax:error_marker_info(Node)`.\n\n- **`{function, Info}`** - where `Info = analyze_function(Node)`.\n\n- **`{warning_marker, Info}`** - where\n  `Info = erl_syntax:warning_marker_info(Node)`.\n\nFor other types of forms, only the node type is returned.\n\nThe evaluation throws `syntax_error` if `Node` is not well-formed.\n\n_See also: _`analyze_attribute/1`, `analyze_function/1`,\n`erl_syntax:error_marker_info/1`, `erl_syntax:is_form/1`,\n`erl_syntax:warning_marker_info/1`.","ref":"erl_syntax_lib.html#analyze_form/1"},{"type":"function","title":"erl_syntax_lib.analyze_forms/1","doc":"Analyzes a sequence of \"program forms\".\n\nThe given `Forms` may be a single syntax tree of type `form_list`, or\na list of \"program form\" syntax trees. The returned value is a list of\npairs `{Key, Info}`, where each value of `Key` occurs at most once in\nthe list; the absence of a particular key indicates that there is no\nwell-defined value for that key.\n\nEach entry in the resulting list contains the following corresponding\ninformation about the program forms:\n\n- **`{attributes, Attributes}`**\n\n  - `Attributes = [{atom(), term()}]`\n\n  `Attributes` is a list of pairs representing the names and\n  corresponding values of all so-called \"wild\" attributes (as, for\n  example, \"`-compile(...)`\") occurring in `Forms` (see\n  [`analyze_wild_attribute/1`](`analyze_wild_attribute/1`)). We do not\n  guarantee that each name occurs at most once in the list. The order\n  of listing is not defined.\n\n- **`{errors, Errors}`**\n\n  - `Errors = [term()]`\n\n  `Errors` is the list of error descriptors of all `error_marker` nodes that\n  occur in `Forms`. The order of listing is not defined.\n\n- **`{exports, Exports}`**\n\n  - `Exports = [FunctionName]`\n  - `FunctionName = atom() | {atom(), integer()} | {ModuleName, FunctionName}`\n  - `ModuleName = atom()`\n\n  `Exports` is a list of representations of those function names that are listed\n  by export declaration attributes in `Forms` (see\n  [`analyze_export_attribute/1`](`analyze_export_attribute/1`)). We do not\n  guarantee that each name occurs at most once in the list. The order of listing\n  is not defined.\n\n- **`{functions, Functions}`**\n\n  - `Functions = [{atom(), integer()}]`\n\n  `Functions` is a list of the names of the functions that are defined in\n  `Forms` (see [`analyze_function/1`](`analyze_function/1`)). We do not\n  guarantee that each name occurs at most once in the list. The order of listing\n  is not defined.\n\n- **`{imports, Imports}`**\n\n  - `Imports = [{Module, Names}]`\n  - `Module = atom()`\n  - `Names = [FunctionName]`\n  - `FunctionName = atom() | {atom(), integer()} | {ModuleName, FunctionName}`\n  - `ModuleName = atom()`\n\n  `Imports` is a list of pairs representing those module names and corresponding\n  function names that are listed by import declaration attributes in `Forms`\n  (see [`analyze_import_attribute/1`](`analyze_import_attribute/1`)), where each\n  `Module` occurs at most once in `Imports`. We do not guarantee that each name\n  occurs at most once in the lists of function names. The order of listing is\n  not defined.\n\n- **`{module, ModuleName}`**\n\n  - `ModuleName = atom()`\n\n  `ModuleName` is the name declared by a module attribute in `Forms`. If no\n  module name is defined in `Forms`, the result will contain no entry for the\n  `module` key. If multiple module name declarations should occur, all but the\n  first will be ignored.\n\n- **`{records, Records}`**\n\n  - `Records = [{atom(), Fields}]`\n  - `Fields = [{atom(), {Default, Type}}]`\n  - `Default = none | syntaxTree()`\n  - `Type = none | syntaxTree()`\n\n  `Records` is a list of pairs representing the names and corresponding field\n  declarations of all record declaration attributes occurring in `Forms`. For\n  fields declared without a default value, the corresponding value for `Default`\n  is the atom `none`. Similarly, for fields declared without a type, the\n  corresponding value for `Type` is the atom `none` (see\n  [`analyze_record_attribute/1`](`analyze_record_attribute/1`)). We do not\n  guarantee that each record name occurs at most once in the list. The order of\n  listing is not defined.\n\n- **`{warnings, Warnings}`**\n\n  - `Warnings = [term()]`\n\n  `Warnings` is the list of error descriptors of all `warning_marker` nodes that\n  occur in `Forms`. The order of listing is not defined.\n\nThe evaluation throws `syntax_error` if an ill-formed Erlang construct is\nencountered.\n\n_See also: _`analyze_export_attribute/1`, `analyze_function/1`,\n`analyze_import_attribute/1`, `analyze_record_attribute/1`,\n`analyze_wild_attribute/1`, `erl_syntax:error_marker_info/1`,\n`erl_syntax:warning_marker_info/1`.","ref":"erl_syntax_lib.html#analyze_forms/1"},{"type":"function","title":"erl_syntax_lib.analyze_function/1","doc":"Returns the name and arity of a function definition.\n\nThe result is a pair `{Name, A}` if `Node` represents a function\ndefinition \"`Name(P_1, ..., P_A) -> ...`\".\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nfunction definition.","ref":"erl_syntax_lib.html#analyze_function/1"},{"type":"function","title":"erl_syntax_lib.analyze_function_name/1","doc":"Returns the function name represented by a syntax tree.\n\nIf `Node` represents a function name, such as \"`foo/1`\" or\n\"`bloggs:fred/2`\", a uniform representation of that name is\nreturned. Different nestings of arity and module name qualifiers in\nthe syntax tree does not affect the result.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nfunction name.","ref":"erl_syntax_lib.html#analyze_function_name/1"},{"type":"function","title":"erl_syntax_lib.analyze_implicit_fun/1","doc":"Returns the name of an implicit fun expression \"`fun F`\".\n\nThe result is a representation of the function name `F`. (See\n[`analyze_function_name/1`](`analyze_function_name/1`).)\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nimplicit fun.\n\n_See also: _`analyze_function_name/1`.","ref":"erl_syntax_lib.html#analyze_implicit_fun/1"},{"type":"function","title":"erl_syntax_lib.analyze_import_attribute/1","doc":"Returns the module name and (if present) list of function names declared by an\nimport attribute.\n\nThe returned value is an atom `Module` or a pair `{Module, Names}`,\nwhere `Names` is a list of function names declared as imported from\nthe module named by `Module`. We do not guarantee that each name\noccurs at most once in `Names`. The order of listing is not defined.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nimport attribute.\n\n_See also: _`analyze_attribute/1`.","ref":"erl_syntax_lib.html#analyze_import_attribute/1"},{"type":"function","title":"erl_syntax_lib.analyze_module_attribute/1","doc":"Returns the module name and possible parameters declared by a module attribute.\n\nIf the attribute is a plain module declaration such as `-module(name)`, the\nresult is the module name. If the attribute is a parameterized module\ndeclaration, the result is a tuple containing the module name and a list of the\nparameter variable names.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nmodule attribute.\n\n_See also: _`analyze_attribute/1`.","ref":"erl_syntax_lib.html#analyze_module_attribute/1"},{"type":"function","title":"erl_syntax_lib.analyze_record_attribute/1","doc":"Returns the name and the list of fields of a record declaration attribute.\n\nThe result is a pair `{Name, Fields}`, if `Node` represents\n\"`-record(Name, {...}).`\", where `Fields` is a list of pairs\n`{Label, {Default, Type}}` for each field \"`Label`\", \"`Label = Default`\",\n\"`Label :: Type`\", or \"`Label = Default :: Type`\" in the declaration, listed in\nleft-to-right order. If the field has no default-value declaration, the value\nfor `Default` will be the atom `none`. If the field has no type declaration, the\nvalue for `Type` will be the atom `none`. We do not guarantee that each label\noccurs at most once in the list.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nrecord declaration attribute.\n\n_See also: _`analyze_attribute/1`, `analyze_record_field/1`.","ref":"erl_syntax_lib.html#analyze_record_attribute/1"},{"type":"function","title":"erl_syntax_lib.analyze_record_expr/1","doc":"Returns the record name and field name/names of a record expression.\n\nIf `Node` has type `record_expr`, `record_index_expr` or\n`record_access`, a pair `{Type, Info}` is returned, otherwise an atom\n`Type` is returned. `Type` is the node type of `Node`, and `Info`\ndepends on `Type`, as follows:\n\n- **`record_expr`:** - `{atom(), [{atom(), Value}]}`\n\n- **`record_access`:** - `{atom(), atom()}`\n\n- **`record_index_expr`:** - `{atom(), atom()}`\n\nFor a `record_expr` node, `Info` represents the record name and the list of\ndescriptors for the involved fields, listed in the order they appear. A field\ndescriptor is a pair `{Label, Value}`, if `Node` represents \"`Label = Value`\".\nFor a `record_access` node, `Info` represents the record name and the field\nname. For a `record_index_expr` node, `Info` represents the record name and the\nname field name.\n\nThe evaluation throws `syntax_error` if `Node` represents a record expression\nthat is not well-formed.\n\n_See also: _`analyze_record_attribute/1`, `analyze_record_field/1`.","ref":"erl_syntax_lib.html#analyze_record_expr/1"},{"type":"function","title":"erl_syntax_lib.analyze_record_field/1","doc":"Returns the label, value-expression, and type of a record field specifier.\n\nThe result is a pair `{Label, {Default, Type}}`, if `Node` represents\n\"`Label`\", \"`Label = Default`\", \"`Label :: Type`\", or \"`Label =\nDefault :: Type`\". If the field has no value-expression, the value for\n`Default` will be the atom `none`.  If the field has no type, the\nvalue for `Type` will be the atom `none`.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nrecord field specifier.\n\n_See also: _`analyze_record_attribute/1`, `analyze_record_expr/1`.","ref":"erl_syntax_lib.html#analyze_record_field/1"},{"type":"function","title":"erl_syntax_lib.analyze_type_application/1","doc":"Returns the name of a used type.\n\nThe result is a representation of the name of the used pre-defined or\nlocal type `N/A`, if `Node` represents a local (user) type application\n\"`N(T_1, ..., T_A)`\", or a representation of the name of the used\nremote type `M:N/A` if `Node` represents a remote user type\napplication \"`M:N(T_1, ..., T_A)`\".\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\n(user) type application expression.\n\n_See also: _`analyze_type_name/1`.","ref":"erl_syntax_lib.html#analyze_type_application/1"},{"type":"function","title":"erl_syntax_lib.analyze_type_name/1","doc":"Returns the type name represented by a syntax tree.\n\nIf `Node` represents a type name, such as \"`foo/1`\" or\n\"`bloggs:fred/2`\", a uniform representation of that name is returned.\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\ntype name.","ref":"erl_syntax_lib.html#analyze_type_name/1"},{"type":"function","title":"erl_syntax_lib.analyze_wild_attribute/1","doc":"Returns the name and value of a \"wild\" attribute.\n\nThe result is the pair `{Name, Value}`, if `Node` represents\n\"`-Name(Value)`\".\n\nNote that no checking is done whether `Name` is a reserved attribute name such\nas `module` or `export`: it is assumed that the attribute is \"wild\".\n\nThe evaluation throws `syntax_error` if `Node` does not represent a well-formed\nwild attribute.\n\n_See also: _`analyze_attribute/1`.","ref":"erl_syntax_lib.html#analyze_wild_attribute/1"},{"type":"function","title":"erl_syntax_lib.annotate_bindings/1","doc":"Adds or updates annotations on nodes in a syntax tree.\n\nEquivalent to [`annotate_bindings(Tree,\nBindings)`](`annotate_bindings/2`) where the top-level environment\n`Bindings` is taken from the annotation `{env, Bindings}` on the root\nnode of `Tree`. An exception is thrown if no such annotation should\nexist.\n\n_See also: _`annotate_bindings/2`.","ref":"erl_syntax_lib.html#annotate_bindings/1"},{"type":"function","title":"erl_syntax_lib.annotate_bindings/2","doc":"Adds or updates annotations on nodes in a syntax tree.\n\n`Bindings` specifies the set of bound variables in the environment of\nthe top level node. The following annotations are affected:\n\n- `{env, Vars}`, representing the input environment of the subtree.\n- `{bound, Vars}`, representing the variables that are bound in the subtree.\n- `{free, Vars}`, representing the free variables in the subtree.\n\n`Bindings` and `Vars` are ordered-set lists (see module `m:ordsets`) of atoms\nrepresenting variable names.\n\n_See also: _[//stdlib/ordsets](`m:ordsets`), `annotate_bindings/1`.","ref":"erl_syntax_lib.html#annotate_bindings/2"},{"type":"type","title":"erl_syntax_lib.appFunName/0","doc":"","ref":"erl_syntax_lib.html#t:appFunName/0"},{"type":"type","title":"erl_syntax_lib.field/0","doc":"","ref":"erl_syntax_lib.html#t:field/0"},{"type":"type","title":"erl_syntax_lib.field_default/0","doc":"","ref":"erl_syntax_lib.html#t:field_default/0"},{"type":"type","title":"erl_syntax_lib.field_type/0","doc":"","ref":"erl_syntax_lib.html#t:field_type/0"},{"type":"type","title":"erl_syntax_lib.fields/0","doc":"","ref":"erl_syntax_lib.html#t:fields/0"},{"type":"function","title":"erl_syntax_lib.fold/3","doc":"Folds a function over all nodes of a syntax tree.\n\nThe result is the value of `Function(X1, Function(X2, ... Function(Xn,\nStart) ... ))`, where `[X1, X2, ..., Xn]` are the nodes of `Tree` in a\npost-order traversal.\n\n_See also: _`fold_subtrees/3`, `foldl_listlist/3`.","ref":"erl_syntax_lib.html#fold/3"},{"type":"function","title":"erl_syntax_lib.fold_subtrees/3","doc":"Folds a function over the immediate subtrees of a syntax tree.\n\nThis is similar to [`fold/3`](`fold/3`), but only on the immediate\nsubtrees of `Tree`, in left-to-right order; it does not include the\nroot node of `Tree`.\n\n_See also: _`fold/3`.","ref":"erl_syntax_lib.html#fold_subtrees/3"},{"type":"function","title":"erl_syntax_lib.foldl_listlist/3","doc":"Like `lists:foldl/3`, but over a list of lists.\n\n_See also: _[//stdlib/lists:foldl/3](`lists:foldl/3`), `fold/3`.","ref":"erl_syntax_lib.html#foldl_listlist/3"},{"type":"function","title":"erl_syntax_lib.function_name_expansions/1","doc":"Creates a mapping from corresponding short names to full function names.\n\nNames are represented by nested tuples of atoms and integers (see\n[`analyze_function_name/1`](`analyze_function_name/1`)). The result is\na list containing a pair `{ShortName, Name}` for each element `Name`\nin the given list, where the corresponding `ShortName` is the\nrightmost-innermost part of `Name`.  The list thus represents a finite\nmapping from unqualified names to the corresponding qualified names.\n\nNote that the resulting list can contain more than one tuple\n`{ShortName, Name}` for the same `ShortName`, possibly with different\nvalues for `Name`, depending on the given list.\n\n_See also: _`analyze_function_name/1`.","ref":"erl_syntax_lib.html#function_name_expansions/1"},{"type":"type","title":"erl_syntax_lib.functionN/0","doc":"","ref":"erl_syntax_lib.html#t:functionN/0"},{"type":"type","title":"erl_syntax_lib.functionName/0","doc":"","ref":"erl_syntax_lib.html#t:functionName/0"},{"type":"type","title":"erl_syntax_lib.info/0","doc":"","ref":"erl_syntax_lib.html#t:info/0"},{"type":"type","title":"erl_syntax_lib.info_pair/0","doc":"","ref":"erl_syntax_lib.html#t:info_pair/0"},{"type":"function","title":"erl_syntax_lib.is_fail_expr/1","doc":"Returns `true` if `Tree` represents an expression that never terminates\nnormally.\n\nNote that the reverse does not apply. Currently, the detected cases\nare calls to [`exit/1`](`exit/1`), [`throw/1`](`throw/1`),\n`erlang:error/1` and `erlang:error/2`.\n\n_See also: _[//erts/erlang:error/1](`erlang:error/1`),\n[//erts/erlang:error/2](`erlang:error/2`),\n[//erts/erlang:exit/1](`erlang:exit/1`),\n[//erts/erlang:throw/1](`erlang:throw/1`).","ref":"erl_syntax_lib.html#is_fail_expr/1"},{"type":"type","title":"erl_syntax_lib.key/0","doc":"","ref":"erl_syntax_lib.html#t:key/0"},{"type":"function","title":"erl_syntax_lib.limit/2","doc":"Equivalent to [`limit(Tree, Depth, Text)`](`limit/3`) using the text `\"...\"` as\ndefault replacement.\n\n_See also: _`limit/3`, `erl_syntax:text/1`.","ref":"erl_syntax_lib.html#limit/2"},{"type":"function","title":"erl_syntax_lib.limit/3","doc":"Limits a syntax tree to a specified depth.\n\nReplaces all non-leaf subtrees in\n`Tree` at the given `Depth` by `Node`. If `Depth` is negative, the result is\nalways `Node`, even if `Tree` has no subtrees.\n\nWhen a group of subtrees (as, for example, the argument list of an\n`application` node) is at the specified depth, and there are two or\nmore subtrees in the group, these will be collectively replaced by\n`Node` even if they are leaf nodes.  Groups of subtrees that are above\nthe specified depth will be limited in size, as if each subsequent\ntree in the group were one level deeper than the previous. For example,\nif `Tree` represents a list of integers \"`[1, 2, 3, 4, 5, 6, 7, 8, 9,\n10]`\", the result of [`limit(Tree, 5)`](`limit/2`) will represent `[1,\n2, 3, 4, ...]`.\n\nThe resulting syntax tree is typically only useful for pretty-printing or\nsimilar visual formatting.\n\n_See also: _`limit/2`.","ref":"erl_syntax_lib.html#limit/3"},{"type":"function","title":"erl_syntax_lib.map/2","doc":"Applies a function to each node of a syntax tree.\n\nThe result of each application replaces the corresponding original\nnode. The order of traversal is bottom-up.\n\n_See also: _`map_subtrees/2`.","ref":"erl_syntax_lib.html#map/2"},{"type":"function","title":"erl_syntax_lib.map_subtrees/2","doc":"Applies a function to each immediate subtree of a syntax tree.\n\nThe result of each application replaces the corresponding original\nnode.\n\n_See also: _`map/2`.","ref":"erl_syntax_lib.html#map_subtrees/2"},{"type":"function","title":"erl_syntax_lib.mapfold/3","doc":"Combines map and fold in a single operation.\n\nThis is similar to [`map/2`](`map/2`), but also propagates an extra\nvalue from each application of the `Function` to the next, while doing\na post-order traversal of the tree like [`fold/3`](`fold/3`). The\nvalue `Start` is passed to the first function application, and the\nfinal result is the result of the last application.\n\n_See also: _`fold/3`, `map/2`.","ref":"erl_syntax_lib.html#mapfold/3"},{"type":"function","title":"erl_syntax_lib.mapfold_subtrees/3","doc":"Does a mapfold operation over the immediate subtrees of a syntax tree.\n\nThis is similar to [`mapfold/3`](`mapfold/3`), but only on the\nimmediate subtrees of `Tree`, in left-to-right order; it does not\ninclude the root node of `Tree`.\n\n_See also: _`mapfold/3`.","ref":"erl_syntax_lib.html#mapfold_subtrees/3"},{"type":"function","title":"erl_syntax_lib.mapfoldl_listlist/3","doc":"Like `lists:mapfoldl/3`, but over a list of lists.\n\nThe list of lists in the result has the same structure as the given\nlist of lists.","ref":"erl_syntax_lib.html#mapfoldl_listlist/3"},{"type":"type","title":"erl_syntax_lib.name/0","doc":"","ref":"erl_syntax_lib.html#t:name/0"},{"type":"function","title":"erl_syntax_lib.new_variable_name/1","doc":"Returns an atom which is not already in the set `Used`.\n\nThis is equivalent to [`new_variable_name(Function,\nUsed)`](`new_variable_name/2`), where `Function` maps a given integer\n`N` to the atom whose name consists of \"`V`\" followed by the numeral\nfor `N`.\n\n_See also: _`new_variable_name/2`.","ref":"erl_syntax_lib.html#new_variable_name/1"},{"type":"function","title":"erl_syntax_lib.new_variable_name/2","doc":"Returns a user-named atom which is not already in the set `Used`.\n\nThe atom is generated by applying the given `Function` to a generated\ninteger. Integers are generated using an algorithm which tries to keep\nthe names randomly distributed within a reasonably small range\nrelative to the number of elements in the set.\n\nThis function uses the module `m:rand` to generate new keys. The seed it uses can\nbe initialized by calling `rand:seed/1` or `rand:seed/2` before this function is\nfirst called.\n\n_See also: _[//stdlib/rand](`m:rand`), [//stdlib/sets](`m:sets`),\n`new_variable_name/1`.","ref":"erl_syntax_lib.html#new_variable_name/2"},{"type":"function","title":"erl_syntax_lib.new_variable_names/2","doc":"Like [`new_variable_name/1`](`new_variable_name/1`), but generates a list of `N`\nnew names.\n\n_See also: _`new_variable_name/1`.","ref":"erl_syntax_lib.html#new_variable_names/2"},{"type":"function","title":"erl_syntax_lib.new_variable_names/3","doc":"Like [`new_variable_name/2`](`new_variable_name/2`), but generates a list of `N`\nnew names.\n\n_See also: _`new_variable_name/2`.","ref":"erl_syntax_lib.html#new_variable_names/3"},{"type":"type","title":"erl_syntax_lib.ordset/1","doc":"","ref":"erl_syntax_lib.html#t:ordset/1"},{"type":"type","title":"erl_syntax_lib.set/1","doc":"","ref":"erl_syntax_lib.html#t:set/1"},{"type":"type","title":"erl_syntax_lib.shortname/0","doc":"","ref":"erl_syntax_lib.html#t:shortname/0"},{"type":"function","title":"erl_syntax_lib.strip_comments/1","doc":"Removes all comments from all nodes of a syntax tree.\n\nAll other attributes (such as position information) remain\nunchanged. Standalone comments in form lists are removed; any other\nstandalone comments are changed into null-comments (no text, no\nindentation).","ref":"erl_syntax_lib.html#strip_comments/1"},{"type":"type","title":"erl_syntax_lib.syntaxTree/0","doc":"An abstract syntax tree. See the `m:erl_syntax` module for details.","ref":"erl_syntax_lib.html#t:syntaxTree/0"},{"type":"function","title":"erl_syntax_lib.to_comment/1","doc":"","ref":"erl_syntax_lib.html#to_comment/1"},{"type":"function","title":"erl_syntax_lib.to_comment/2","doc":"Equivalent to [`to_comment(Tree, Prefix, F)`](`to_comment/3`) for a default\nformatting function `F`.\n\nThe default `F` simply calls `erl_prettypr:format/1`.\n\n_See also: _`to_comment/3`, `erl_prettypr:format/1`.","ref":"erl_syntax_lib.html#to_comment/2"},{"type":"function","title":"erl_syntax_lib.to_comment/3","doc":"Transforms a syntax tree into an abstract comment.\n\nThe lines of the comment contain the text for `Node`, as produced by\nthe given `Printer` function. Each line of the comment is prefixed by\nthe string `Prefix` (this does not include the initial \"`%`\" character\nof the comment line).\n\nFor example, the result of\n[`to_comment(erl_syntax:abstract([a,b,c]))`](`to_comment/1`) represents\n\n```erlang\n%% [a,b,c]\n```\n\n(see [`to_comment/1`](`to_comment/1`)).\n\n> #### Note {: .info }\n>\n> The text returned by the formatting function will be split\n> automatically into separate comment lines at each line break. No extra\n> work is needed.\n\n_See also: _`to_comment/1`, `to_comment/2`.","ref":"erl_syntax_lib.html#to_comment/3"},{"type":"type","title":"erl_syntax_lib.typeName/0","doc":"","ref":"erl_syntax_lib.html#t:typeName/0"},{"type":"function","title":"erl_syntax_lib.variables/1","doc":"Returns the names of variables occurring in a syntax tree.\n\nThe result is a set of variable names represented by atoms. Macro\nnames are not included.\n\n_See also: _[//stdlib/sets](`m:sets`).","ref":"erl_syntax_lib.html#variables/1"},{"type":"module","title":"merl","doc":"Metaprogramming in Erlang.\n\nMerl is a user-friendly interface to the `erl_syntax` module,\nmaking it easy both to build new ASTs from scratch and to match and\ndecompose existing ASTs. For details that are outside the scope of\nMerl itself, see the documentation of `m:erl_syntax`.","ref":"merl.html"},{"type":"module","title":"Quick start - merl","doc":"To enable the full power of Merl, your module needs to include the Merl header\nfile:\n\n```erlang\n-include_lib(\"syntax_tools/include/merl.hrl\").\n```\n\nThen, you can use the `?Q(Text)` macros in your code to create ASTs or match on\nexisting ASTs. For example:\n\n```erlang\nTuple = ?Q(\"{foo, 42}\"),\n?Q(\"{foo, _@Number}\") = Tuple,\nCall = ?Q(\"foo:bar(_@Number)\")\n```\n\nCalling `merl:print(Call)` will then print the following code:\n\n```erlang\nfoo:bar(42)\n```\n\nThe `?Q` macros turn the quoted code fragments into ASTs, and lifts\nmetavariables such as `_@Tuple` and `_@Number` to the level of your Erlang code,\nso you can use the corresponding Erlang variables `Tuple` and `Number` directly.\nThis is the most straightforward way to use Merl, and in many cases it's all you\nneed.\n\nYou can even write case switches using `?Q` macros as patterns. For example:\n\n```erlang\ncase AST of\n    ?Q(\"{foo, _@Foo}\") -> handle(Foo);\n    ?Q(\"{bar, _@Bar}\") when erl_syntax:is_integer(Bar) -> handle(Bar);\n    _ -> handle_default()\nend\n```\n\nThese case switches only allow `?Q(...)` or `_` as clause patterns, and the\nguards may contain any expressions, not just Erlang guard expressions.\n\nIf the macro `MERL_NO_TRANSFORM` is defined before the `merl.hrl` header file is\nincluded, the parse transform used by Merl will be disabled, and in that case,\nthe match expressions `?Q(...) = ...`, case switches using `?Q(...)` patterns,\nand automatic metavariables like `_@Tuple` cannot be used in your code, but the\nMerl macros and functions still work. To do metavariable substitution, you need\nto use the `?Q(Text, Map)` macro. For example:\n\n```erlang\nTuple = ?Q(\"{foo, _@bar, _@baz}\", [{bar, Bar}, {baz,Baz}])\n```\n\nThe text given to a `?Q(Text)` macro can be either a single string or a list of\nstrings. The latter is useful when you need to split a long expression over\nmultiple lines. For example:\n\n```erlang\n?Q([\"case _@Expr of\",\n    \"  {foo, X} -> f(X);\",\n    \"  {bar, X} -> g(X)\",\n    \"  _ -> h(X)\"\n\"end\"])\n```\n\nIf there is a syntax error somewhere in the text (like the missing semicolon in\nthe second clause above) this allows Merl to generate an error message pointing\nto the exact line in your source code. (Just remember to comma-separate the\nstrings in the list, otherwise Erlang will concatenate the string fragments as\nif they were a single string.)","ref":"merl.html#module-quick-start"},{"type":"module","title":"Metavariable syntax - merl","doc":"There are several ways to write a metavariable in your quoted code:\n\n- Atoms starting with `@`, for example `'@foo'` or `'@Foo'`\n- Variables starting with `_@`, for example `_@bar` or `_@Bar`\n- Strings starting with `\"'@`, for example `\"'@File\"`\n- Integers starting with 909, for example `9091` or `909123`\n\nFollowing the prefix, one or more `_` or `0` characters may be used to indicate\n\"lifting\" of the variable one or more levels, and after that, a `@` or `9`\ncharacter indicates a glob metavariable (matching zero or more elements in a\nsequence) rather than a normal metavariable. For example:\n\n- `'@_foo'` is lifted one level, and `_@__foo` is lifted two levels\n- `_@@bar` is a glob variable, and `_@_@bar` is a lifted glob variable\n- `90901` is a lifted variable,`90991` is a glob variable, and `9090091` is a\n  glob variable lifted two levels\n\n(Note that the last character in the name is never considered to be a lift or\nglob marker, hence, `_@__` and `90900` are only lifted one level, not two. Also\nnote that globs only matter for matching; when doing substitutions, a non-glob\nvariable can be used to inject a sequence of elements, and vice versa.)\n\nIf the name after the prefix and any lift and glob markers is `_` or `0`, the\nvariable is treated as an anonymous catch-all pattern in matches. For example,\n`_@_`, `_@@_`, `_@__`, or even `_@__@_`.\n\nFinally, if the name without any prefixes or lift/glob markers begins with an\nuppercase character, as in `_@Foo` or `_@_@Foo`, it will become a variable on\nthe Erlang level, and can be used to easily deconstruct and construct syntax\ntrees:\n\n```erlang\ncase Input of\n    ?Q(\"{foo, _@Number}\") -> ?Q(\"foo:bar(_@Number)\");\n    ...\n```\n\nWe refer to these as \"automatic metavariables\". If in addition the name ends\nwith `@`, as in `_@Foo@`, the value of the variable as an Erlang term will be\nautomatically converted to the corresponding abstract syntax tree when used to\nconstruct a larger tree. For example, in:\n\n```erlang\nBar = {bar, 42},\nFoo = ?Q(\"{foo, _@Bar@}\")\n```\n\n(where Bar is just some term, not a syntax tree) the result `Foo` will be a\nsyntax tree representing `{foo, {bar, 42}}`. This avoids the need for temporary\nvariables in order to inject data, as in\n\n```erlang\nTmpBar = erl_syntax:abstract(Bar),\nFoo = ?Q(\"{foo, _@TmpBar}\")\n```\n\nIf the context requires an integer rather than a variable, an atom, or a string,\nyou cannot use the uppercase convention to mark an automatic metavariable.\nInstead, if the integer (without the `909`\\-prefix and lift/glob markers) ends\nin a `9`, the integer will become an Erlang-level variable prefixed with `Q`,\nand if it ends with `99` it will also be automatically abstracted. For example,\nthe following will increment the arity of the exported function f:\n\n```erlang\ncase Form of\n    ?Q(\"-export([f/90919]).\") ->\n        Q2 = erl_syntax:concrete(Q1) + 1,\n        ?Q(\"-export([f/909299]).\");\n    ...\n```","ref":"merl.html#module-metavariable-syntax"},{"type":"module","title":"When to use the various forms of metavariables - merl","doc":"Merl can only parse a fragment of text if it follows the basic syntactical rules\nof Erlang. In most places, a normal Erlang variable can be used as metavariable,\nfor example:\n\n```erlang\n?Q(\"f(_@Arg)\") = Expr\n```\n\nbut if you want to match on something like the name of a function, you have to\nuse an atom as metavariable:\n\n```erlang\n?Q(\"'@Name'() -> _@@_.\" = Function\n```\n\n(note the anonymous glob variable `_@@_` to ignore the function body).\n\nIn some contexts, only a string or an integer is allowed. For example, the\ndirective `-file(Name, Line)` requires that `Name` is a string literal and\n`Line` an integer literal:\n\n```erlang\n?Q(\"-file(\\\"'@File\\\", 9090).\") = ?Q(\"-file(\\\"foo.erl\\\", 42).\")).\n```\n\nThis will extract the string literal `\"foo.erl\"` into the variable `Foo`. Note\nthe use of the anonymous variable `9090` to ignore the line number. To match and\nalso bind a metavariable that must be an integer literal, we can use the\nconvention of ending the integer with a 9, turning it into a Q-prefixed variable\non the Erlang level (see the previous section).\n\n#### Globs\n\nWhenever you want to match out a number of elements in a sequence (zero or more)\nrather than a fixed set of elements, you need to use a glob. For example:\n\n```erlang\n?Q(\"{_@@Elements}\") = ?Q({a, b, c})\n```\n\nwill bind Elements to the list of individual syntax trees representing the atoms\n`a`, `b`, and `c`. This can also be used with static prefix and suffix elements\nin the sequence. For example:\n\n```erlang\n?Q(\"{a, b, _@@Elements}\") = ?Q({a, b, c, d})\n```\n\nwill bind Elements to the list of the `c` and `d` subtrees, and\n\n```erlang\n?Q(\"{_@@Elements, c, d}\") = ?Q({a, b, c, d})\n```\n\nwill bind Elements to the list of the `a` and `b` subtrees. You can even use\nplain metavariables in the prefix or suffix:\n\n```erlang\n?Q(\"{_@First, _@@Rest}\") = ?Q({a, b, c})\n```\n\nor\n\n```erlang\n?Q(\"{_@@_, _@Last}\") = ?Q({a, b, c})\n```\n\n(ignoring all but the last element). However, you cannot have two globs as part\nof the same sequence.\n\n#### Lifted metavariables\n\nIn some cases, the Erlang syntax rules make it impossible to place a\nmetavariable directly where you would like it. For example, you cannot write:\n\n```erlang\n?Q(\"-export([_@@Name]).\")\n```\n\nto match out all name/arity pairs in the export list, or to insert a list of\nexports in a declaration, because the Erlang parser only allows elements on the\nform `A/I` (where `A` is an atom and `I` an integer) in the export list. A\nvariable like the above is not allowed, but neither is a single atom or integer,\nso `'@@Name'` or `909919` would not work either.\n\nWhat you have to do in such cases is to write your metavariable in a\nsyntactically valid position, and use lifting markers to denote where it should\nreally apply, as in:\n\n```erlang\n?Q(\"-export(['@_@Name'/0]).\")\n```\n\nThis causes the variable to be lifted (after parsing) to the next higher level\nin the syntax tree, replacing that entire subtree. In this case, the\n`'@_@Name'/0` will be replaced with `'@@Name'`, and the `/0` part was just used\nas dummy notation and will be discarded.\n\nYou may even need to apply lifting more than once. To match the entire export\nlist as a single syntax tree, you can write:\n\n```erlang\n?Q(\"-export(['@__Name'/0]).\")\n```\n\nusing two underscores, but with no glob marker this time. This will make the\nentire `['@__Name'/0]` part be replaced with `'@Name'`.\n\nSometimes, the tree structure of a code fragment is not very obvious, and parts\nof the structure may be invisible when printed as source code. For instance, a\nsimple function definition like the following:\n\n```erlang\nzero() -> 0.\n```\n\nconsists of the name (the atom `zero`), and a list of clauses containing the\nsingle clause `() -> 0`. The clause consists of an argument list (empty), a\nguard (empty), and a body (which is always a list of expressions) containing the\nsingle expression `0`. This means that to match out the name and the list of\nclauses of any function, you'll need to use a pattern like\n`?Q(\"'@Name'() -> _@_@Body.\")`, using a dummy clause whose body is a glob lifted\none level.\n\nTo visualize the structure of a syntax tree, you can use the function\n`merl:show(T)`, which prints a summary. For example, entering\n\n```erlang\nmerl:show(merl:quote(\"inc(X, Y) when Y > 0 -> X + Y.\"))\n```\n\nin the Erlang shell will print the following (where the `+` signs separate\ngroups of subtrees on the same level):\n\n```text\nfunction: inc(X, Y) when ... -> X + Y.\n  atom: inc\n  +\n  clause: (X, Y) when ... -> X + Y\n    variable: X\n    variable: Y\n    +\n    disjunction: Y > 0\n      conjunction: Y > 0\n        infix_expr: Y > 0\n          variable: Y\n          +\n          operator: >\n          +\n          integer: 0\n    +\n    infix_expr: X + Y\n      variable: X\n      +\n      operator: +\n      +\n      variable: Y\n```\n\nThis shows another important non-obvious case: a clause guard, even if it's as\nsimple as `Y > 0`, always consists of a single disjunction of one or more\nconjunctions of tests, much like a tuple of tuples. Thus:\n\n- `\"when _@Guard ->\"` will only match a guard with exactly one test\n- `\"when _@@Guard ->\"` will match a guard with one or more comma-separated tests\n  (but no semicolons), binding `Guard` to the list of tests\n- `\"when _@_Guard ->\"` will match just like the previous pattern, but binds\n  `Guard` to the conjunction subtree\n- `\"when _@_@Guard ->\"` will match an arbitrary nonempty guard, binding `Guard`\n  to the list of conjunction subtrees\n- `\"when _@__Guard ->\"` will match like the previous pattern, but binds `Guard`\n  to the whole disjunction subtree\n- and finally, `\"when _@__@Guard ->\"` will match any clause, binding `Guard` to\n  `[]` if the guard is empty and to `[Disjunction]` otherwise\n\nThus, the following pattern matches all possible clauses:\n\n```erlang\n     \"(_@Args) when _@__@Guard -> _@Body\"\n```","ref":"merl.html#module-when-to-use-the-various-forms-of-metavariables"},{"type":"function","title":"merl.alpha/2","doc":"Alpha converts a pattern (renames variables).\n\nSimilar to tsubst/1, but only renames variables (including globs).\n\n_See also: _`tsubst/2`.","ref":"merl.html#alpha/2"},{"type":"function","title":"merl.compile/1","doc":"","ref":"merl.html#compile/1"},{"type":"function","title":"merl.compile/2","doc":"Compile a syntax tree or list of syntax trees representing a module into a\nbinary BEAM object.\n\n_See also: _`compile/1`, `compile_and_load/2`.","ref":"merl.html#compile/2"},{"type":"function","title":"merl.compile_and_load/1","doc":"","ref":"merl.html#compile_and_load/1"},{"type":"function","title":"merl.compile_and_load/2","doc":"Compile a syntax tree or list of syntax trees representing a module and load the\nresulting module into memory.\n\n_See also: _`compile/2`, `compile_and_load/1`.","ref":"merl.html#compile_and_load/2"},{"type":"type","title":"merl.default_action/0","doc":"","ref":"merl.html#t:default_action/0"},{"type":"type","title":"merl.env/0","doc":"","ref":"merl.html#t:env/0"},{"type":"type","title":"merl.guard_test/0","doc":"","ref":"merl.html#t:guard_test/0"},{"type":"type","title":"merl.guarded_action/0","doc":"","ref":"merl.html#t:guarded_action/0"},{"type":"type","title":"merl.guarded_actions/0","doc":"","ref":"merl.html#t:guarded_actions/0"},{"type":"type","title":"merl.id/0","doc":"","ref":"merl.html#t:id/0"},{"type":"type","title":"merl.location/0","doc":"","ref":"merl.html#t:location/0"},{"type":"function","title":"merl.match/2","doc":"Match a pattern against a syntax tree (or patterns against syntax trees)\nreturning an environment mapping variable names to subtrees; the environment is\nalways sorted on keys.\n\n> #### Note {: .info }\n>\n> Multiple occurrences of metavariables in the pattern is not\n> allowed, but is not checked.\n\n_See also: _`switch/2`, `template/1`.","ref":"merl.html#match/2"},{"type":"function","title":"merl.meta_template/1","doc":"Turn a template into a syntax tree representing the template.\n\nMeta-variables in the template are turned into normal Erlang variables\nif their names (after the metavariable prefix characters) begin with\nan uppercase character. For example, `_@Foo` in the template becomes the\nvariable `Foo` in the meta-template. Furthermore, variables ending\nwith `@` are automatically wrapped in a call to merl:term/1, so\n`_@Foo@` in the template becomes `merl:term(Foo)` in the\nmeta-template.","ref":"merl.html#meta_template/1"},{"type":"type","title":"merl.pattern/0","doc":"","ref":"merl.html#t:pattern/0"},{"type":"type","title":"merl.pattern_or_patterns/0","doc":"","ref":"merl.html#t:pattern_or_patterns/0"},{"type":"function","title":"merl.print/1","doc":"Pretty-print a syntax tree or template to the standard output.\n\nThis is a utility function for development and debugging.","ref":"merl.html#print/1"},{"type":"function","title":"merl.qquote/2","doc":"","ref":"merl.html#qquote/2"},{"type":"function","title":"merl.qquote/3","doc":"Parse text and substitute meta-variables.\n\nTakes an initial scanner starting position as first argument.\n\nThe macro `?Q(Text, Env)` expands to `merl:qquote(?LINE, Text, Env)`.\n\n_See also: _`quote/2`.","ref":"merl.html#qquote/3"},{"type":"function","title":"merl.quote/1","doc":"","ref":"merl.html#quote/1"},{"type":"function","title":"merl.quote/2","doc":"Parse text.\n\nTakes an initial scanner starting position as first argument.\n\nThe macro `?Q(Text)` expands to `merl:quote(?LINE, Text)`.\n\n_See also: _`quote/1`.","ref":"merl.html#quote/2"},{"type":"function","title":"merl.show/1","doc":"Print the structure of a syntax tree or template to the standard output.\n\nThis is a utility function for development and debugging.","ref":"merl.html#show/1"},{"type":"function","title":"merl.subst/2","doc":"Substitute metavariables in a pattern or list of patterns, yielding a syntax\ntree or list of trees as result.\n\nBoth for normal metavariables and glob metavariables, the substituted\nvalue may be a single element or a list of elements. For example, if a\nlist representing `1, 2, 3` is substituted for `var` in either of\n`[foo, _@var, bar]` or `[foo, _@var, bar]`, the result represents\n`[foo, 1, 2, 3, bar]`.","ref":"merl.html#subst/2"},{"type":"function","title":"merl.switch/2","doc":"Match against one or more clauses with patterns and optional guards.\n\nNote that clauses following a default action will be ignored.\n\n_See also: _`match/2`.","ref":"merl.html#switch/2"},{"type":"type","title":"merl.switch_action/0","doc":"","ref":"merl.html#t:switch_action/0"},{"type":"type","title":"merl.switch_clause/0","doc":"","ref":"merl.html#t:switch_clause/0"},{"type":"type","title":"merl.template/0","doc":"","ref":"merl.html#t:template/0"},{"type":"function","title":"merl.template/1","doc":"Turn a syntax tree or list of trees into a template or templates.\n\nTemplates can be instantiated or matched against, and reverted back to\nnormal syntax trees using `tree/1`. If the input is already a\ntemplate, it is not modified further.\n\n_See also: _`match/2`, `subst/2`, `tree/1`.","ref":"merl.html#template/1"},{"type":"type","title":"merl.template_or_templates/0","doc":"","ref":"merl.html#t:template_or_templates/0"},{"type":"function","title":"merl.template_vars/1","doc":"Return an ordered list of the metavariables in the template.","ref":"merl.html#template_vars/1"},{"type":"function","title":"merl.term/1","doc":"Create a syntax tree for a constant term.","ref":"merl.html#term/1"},{"type":"type","title":"merl.text/0","doc":"","ref":"merl.html#t:text/0"},{"type":"type","title":"merl.tree/0","doc":"","ref":"merl.html#t:tree/0"},{"type":"function","title":"merl.tree/1","doc":"Revert a template to a normal syntax tree.\n\nAny remaining metavariables are turned into `@`\\-prefixed atoms or\n`909`\\-prefixed integers.\n\n_See also: _`template/1`.","ref":"merl.html#tree/1"},{"type":"type","title":"merl.tree_or_trees/0","doc":"","ref":"merl.html#t:tree_or_trees/0"},{"type":"function","title":"merl.tsubst/2","doc":"Like `subst/2`, but does not convert the result from a template back to a tree.\n\nUseful if you want to do multiple separate substitutions.\n\n_See also: _`subst/2`, `tree/1`.","ref":"merl.html#tsubst/2"},{"type":"function","title":"merl.var/1","doc":"Create a variable.","ref":"merl.html#var/1"},{"type":"module","title":"merl_transform","doc":"Parse transform for merl.\n\nEnables the use of automatic metavariables and using quasi-quotes in\nmatches and case switches. Also optimizes calls to functions in `merl`\nby partially evaluating them, turning strings to templates, and so on,\nat compile-time.\n\nUsing `-include_lib(\"syntax_tools/include/merl.hrl\").` enables this transform,\nunless the macro `MERL_NO_TRANSFORM` is defined first.","ref":"merl_transform.html"},{"type":"module","title":"prettypr","doc":"A generic pretty printer library.\n\nThis module uses a strict-style context passing implementation of John\nHughes algorithm, described in \"The design of a Pretty-printing\nLibrary\". The paragraph-style formatting, empty documents, floating\ndocuments, and null strings are my own additions to the algorithm.\n\nTo get started, you should read about the [`document()`](`t:document/0`) data\ntype; the main constructor functions: `text/1`, `above/2`, `beside/2`, `nest/2`,\n`sep/1`, and `par/2`; and the main layout function `format/3`.\n\nIf you simply want to format a paragraph of plain text, you probably want to use\nthe `text_par/2` function, as in the following example:\n\n```text\n  prettypr:format(prettypr:text_par(\"Lorem ipsum dolor sit amet\"), 20)\n```","ref":"prettypr.html"},{"type":"function","title":"prettypr.above/2","doc":"Concatenates documents vertically.\n\nReturns a document representing the concatenation of the documents\n`D1` and `D2` such that the first line of `D2` follows directly below\nthe last line of `D1`, and the first character of `D2` is in the same\nhorizontal column as the first character of `D1`, in all possible\nlayouts.\n\nExamples:\n\n```text\nab  cd  =>  ab\n            cd\n\n               abc\nabc   fgh  =>   de\n de    ij      fgh\n                ij\n```","ref":"prettypr.html#above/2"},{"type":"function","title":"prettypr.beside/2","doc":"Concatenates documents horizontally.\n\nReturns a document representing the concatenation of the documents\n`D1` and `D2` such that the last character of `D1` is horizontally\nadjacent to the first character of `D2`, in all possible\nlayouts. (Note: any indentation of `D2` is lost.)\n\nExamples:\n\n```text\nab  cd  =>  abcd\n\nab  ef      ab\ncd  gh  =>  cdef\n              gh\n```","ref":"prettypr.html#beside/2"},{"type":"function","title":"prettypr.best/3","doc":"Selects a \"best\" layout for a document, creating a corresponding fixed-layout\ndocument.\n\nIf no layout could be produced, the atom `empty` is returned instead.\nFor details about `PaperWidth` and `LineWidth`, see `format/3`. The\nfunction is idempotent.\n\nOne possible use of this function is to compute a fixed layout for a document,\nwhich can then be included as part of a larger document. For example:\n\n```text\n     above(text(\"Example:\"), nest(8, best(D, W - 12, L - 6)))\n```\n\nwill format `D` as a displayed-text example indented by 8, whose right margin is\nindented by 4 relative to the paper width `W` of the surrounding document, and\nwhose maximum individual line length is shorter by 6 than the line length `L` of\nthe surrounding document.\n\nThis function is used by the `format/3` function to prepare a document before\nbeing laid out as text.","ref":"prettypr.html#best/3"},{"type":"function","title":"prettypr.break/1","doc":"Forces a line break at the end of the given document.\n\nThis is a utility function; see `empty/0` for details.","ref":"prettypr.html#break/1"},{"type":"type","title":"prettypr.deep_string/0","doc":"","ref":"prettypr.html#t:deep_string/0"},{"type":"type","title":"prettypr.document/0","doc":"An abstract character-based \"document\" representing\na number of possible layouts, which can be processed to produce a\nsingle concrete layout.\n\nA concrete layout can then be rendered as a sequence of characters\ncontaining linebreaks, which can be passed to a printer or terminal\nthat uses a fixed-width font.\n\nFor example, a document `sep([text(\"foo\"), text(\"bar\")])`\nrepresents the two layouts:\n\n```text\nfoo bar\n```\n\nand:\n\n```text\nfoo\nbar\n```\n\nWhich layout is chosen depends on the available horizontal space.\nWhen processing a document, the main parameters are the _paper\nwidth_ and the _line width_ (also known as the \"ribbon\nwidth\"). In the resulting layout, no text should be printed beyond\nthe paper width (which by default is 80 characters) as long as it can\nbe avoided, and each single line of text (its indentation not\ncounted, hence \"ribbon\") should preferably be no wider than the\nspecified line width (which by default is 65).\n\nDocuments can be joined into a single new document using the\nconstructor functions of this module. Note that the new document\noften represents a larger number of possible layouts than just the\nsum of the components.","ref":"prettypr.html#t:document/0"},{"type":"function","title":"prettypr.empty/0","doc":"Yields the empty document, which has neither height nor width.\n\n(`empty` is thus different from an empty [`text`](`text/1`) string,\nwhich has zero width but height 1.)\n\nEmpty documents are occasionally useful; in particular, they have the property\nthat [`above(X, empty())`](`above/2`) will force a new line after `X` without\nleaving an empty line below it; since this is a common idiom, the utility\nfunction `break/1` will place a given document in such a context.\n\n_See also: _`text/1`.","ref":"prettypr.html#empty/0"},{"type":"function","title":"prettypr.floating/1","doc":"","ref":"prettypr.html#floating/1"},{"type":"function","title":"prettypr.floating/3","doc":"Creates a \"floating\" document.\n\nThe result represents the same set of layouts as `D`; however, a\nfloating document may be moved relative to other floating documents\nimmediately beside or above it, according to their relative horizontal\nand vertical priorities. These priorities are set with the `Hp` and\n`Vp` parameters; if omitted, both default to zero.\n\n> #### Note {: .info }\n>\n> Floating documents appear to work well, but are currently less general\n> than you might wish, losing effect when embedded in certain contexts. It is\n> possible to nest floating-operators (even with different priorities), but the\n> effects may be difficult to predict. In any case, note that the way the\n> algorithm reorders floating documents amounts to a \"bubblesort\", so don't expect\n> it to be able to sort large sequences of floating documents quickly.","ref":"prettypr.html#floating/3"},{"type":"function","title":"prettypr.follow/2","doc":"","ref":"prettypr.html#follow/2"},{"type":"function","title":"prettypr.follow/3","doc":"Separates two documents by either a single space, or a line break and\nindentation.\n\nIn other words, one of the layouts:\n\n```text\nabc def\n```\n\nor:\n\n```text\nabc\n def\n```\n\nwill be generated, using the optional offset in the latter case. This is often\nuseful for typesetting programming language constructs.\n\nThis is a utility function; see `par/2` for further details.\n\n_See also: _`follow/2`.","ref":"prettypr.html#follow/3"},{"type":"function","title":"prettypr.format/1","doc":"","ref":"prettypr.html#format/1"},{"type":"function","title":"prettypr.format/2","doc":"","ref":"prettypr.html#format/2"},{"type":"function","title":"prettypr.format/3","doc":"Computes a layout for a document and returns the corresponding text.\n\nSee [`document()`](`t:document/0`) for further information. Throws\n`no_layout` if no layout could be selected.\n\n`PaperWidth` specifies the total width (in character positions) of the field for\nwhich the text is to be laid out. `LineWidth` specifies the desired maximum\nwidth (in number of characters) of the text printed on any single line,\ndisregarding leading and trailing white space. These parameters need to be\nproperly balanced in order to produce good layouts. By default, `PaperWidth` is\n80 and `LineWidth` is 65.\n\n_See also: _`best/3`.","ref":"prettypr.html#format/3"},{"type":"function","title":"prettypr.nest/2","doc":"Indents a document a number of character positions to the right.\n\nNote that `N` can be negative, shifting the text to the left, or zero,\nin which case `D` is returned unchanged.","ref":"prettypr.html#nest/2"},{"type":"function","title":"prettypr.null_text/1","doc":"Similar to `text/1`, but the result is treated as having zero width.\n\nThis is regardless of the actual length of the string. Null text is\ntypically used for markup, which is supposed to have no effect on the\nactual layout.\n\nThe standard example is when formatting source code as HTML to be\nplaced within ` ... ` markup, and using elements like ` `\nand ` ` to make parts of the source code stand out. In this case,\nthe markup does not add to the width of the text when viewed in an\nHTML browser, so the layout engine should simply pretend that the\nmarkup has zero width.\n\n_See also: _`empty/0`, `text/1`.","ref":"prettypr.html#null_text/1"},{"type":"function","title":"prettypr.par/1","doc":"","ref":"prettypr.html#par/1"},{"type":"function","title":"prettypr.par/2","doc":"Arranges documents in a paragraph-like layout.\n\nReturns a document representing all possible left-aligned\nparagraph-like layouts of the (nonempty) sequence `Docs` of\ndocuments. Elements in `Docs` are separated horizontally by a single\nspace character and vertically with a single line break. All lines\nfollowing the first (if any) are indented to the same left column,\nwhose indentation is specified by the optional `Offset` parameter\nrelative to the position of the first element in `Docs`. For example,\nwith an offset of -4, the following layout can be produced, for a list\nof documents representing the numbers 0 to 15:\n\n```text\n    0 1 2 3\n4 5 6 7 8 9\n10 11 12 13\n14 15\n```\n\nor with an offset of +2:\n\n```text\n0 1 2 3 4 5 6\n  7 8 9 10 11\n  12 13 14 15\n```\n\nThe utility function `text_par/2` can be used to easily transform a string of\ntext into a `par` representation by splitting it into words.\n\nNote that whenever a document in `Docs` contains a line break, it will be placed\non a separate line. Thus, neither a layout such as:\n\n```text\nab cd\n   ef\n```\n\nnor:\n\n```text\nab\ncd ef\n```\n\nwill be generated. However, a useful idiom for making the former variant\npossible (when wanted) is [`beside(par([D1, text(\"\")], N), D2)`](`beside/2`) for\ntwo documents `D1` and `D2`. This will break the line between `D1` and `D2` if\n`D1` contains a line break (or if otherwise necessary), and optionally further\nindent `D2` by `N` character positions. The utility function `follow/3` creates\nthis context for two documents `D1` and `D2`, and an optional integer `N`.\n\n_See also: _`par/1`, `text_par/2`.","ref":"prettypr.html#par/2"},{"type":"function","title":"prettypr.sep/1","doc":"Arranges documents horizontally or vertically, separated by whitespace.\n\nReturns a document representing two alternative layouts of the\n(nonempty) sequence `Docs` of documents, such that either all elements\nin `Docs` are concatenated horizontally, and separated by a space\ncharacter, or all elements are concatenated vertically (without extra\nseparation).\n\n> #### Note {: .info }\n>\n> If some document in `Docs` contains a line break, the vertical layout\n> will always be selected.\n\nExamples:\n\n```text\n                             ab\nab  cd  ef  =>  ab cd ef  |  cd\n                             ef\n\nab           ab\ncd  ef  =>   cd\n             ef\n```\n\n_See also: _`par/2`.","ref":"prettypr.html#sep/1"},{"type":"function","title":"prettypr.text/1","doc":"Yields a document representing a fixed, unbreakable sequence of characters.\n\nThe string should contain only _printable_ characters (tabs allowed\nbut not recommended), and _not_ newline, line feed, vertical tab,\nand so on. A tab character (`\\t`) is interpreted as padding of 1-8 space\ncharacters to the next column of 8 characters _within the string_.\n\n_See also: _`empty/0`, `null_text/1`, `text_par/2`.","ref":"prettypr.html#text/1"},{"type":"function","title":"prettypr.text_par/1","doc":"","ref":"prettypr.html#text_par/1"},{"type":"function","title":"prettypr.text_par/2","doc":"Yields a document representing paragraph-formatted plain text.\n\nThe `Indentation` parameter specifies the extra indentation\nof the first line of the paragraph. For example, [`text_par(\"Lorem\nipsum dolor sit amet\", N)`](`text_par/2`) could represent:\n\n```text\nLorem ipsum dolor\nsit amet\n```\n\nif N = 0, or:\n\n```text\n  Lorem ipsum\ndolor sit amet\n```\n\nif `N` = 2, or:\n\n```text\nLorem ipsum dolor\n  sit amet\n```\n\nif `N` = -2.\n\n(The sign of the indentation is thus reversed compared to the `par/2` function,\nand the behaviour varies slightly depending on the sign in order to match the\nexpected layout of a paragraph of text.)\n\nNote that this is just a utility function, which does all the work of splitting\nthe given string into words separated by whitespace and setting up a\n[`par`](`par/2`) with the proper indentation, containing a list of\n[`text`](`text/1`) elements.\n\n_See also: _`par/2`, `text/1`, `text_par/1`.","ref":"prettypr.html#text_par/2"},{"type":"extras","title":"Syntax_Tools Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Syntax_Tools Release Notes\n\nThis document describes the changes made to the Syntax_Tools application.","ref":"notes.html"},{"type":"extras","title":"Syntax_Tools 3.2.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-3-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Annotation of `maybe` expressions has been corrected.\n\n  Own Id: OTP-19405 Aux Id: [PR-8811]\n\n[PR-8811]: https://github.com/erlang/otp/pull/8811","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 3.2.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- The documentation for `syntax_tools` has been polished after the migration to the new documentation system.\n\n  Own Id: OTP-19102 Aux Id: [PR-8515]\n\n[PR-8515]: https://github.com/erlang/otp/pull/8515","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 3.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- The `m:epp_dodger` module can now handle the `maybe` and `else` keywords.\n\n  Own Id: OTP-18608 Aux Id: [GH-7266], [PR-7267]\n\n- Reverting a `#wrapper` will no longer throw away changes made to positions/annotations.\n\n  Own Id: OTP-18805 Aux Id: [PR-7398]\n\n[GH-7266]: https://github.com/erlang/otp/issues/7266\n[PR-7267]: https://github.com/erlang/otp/pull/7267\n[PR-7398]: https://github.com/erlang/otp/pull/7398","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- The type `t:erl_syntax:annotation_or_location/0` is now exported.\n\n  Own Id: OTP-18715 Aux Id: [PR-7535]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-7535]: https://github.com/erlang/otp/pull/7535\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 3.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-3-1"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Map comprehensions as suggested in EEP 58 has now been implemented.\n\n  Own Id: OTP-18413 Aux Id: EEP-58, PR-6727","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 3.0.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-3-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- `erl_syntax_lib:annotate_bindings/1,2` will now properly annotate named\n  functions and their arguments.\n\n  Own Id: OTP-18380 Aux Id: PR-6523, GH-4733","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 3.0 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-3-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- The `erl_syntax_lib:analyze_attribute/1` function would return\n  `{Name, {Name, Value}}` instead of `{Name, Value}` (which is the documented\n  return value).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17894 Aux Id: PR-5509","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Added support for configurable features as described in EEP-60. Features can\n  be enabled/disabled during compilation with options\n  (`-enable-feature Feature`, `-disable-feature Feature` and\n  `+{feature, Feature, enable|disable}`) to `erlc` as well as with directives\n  (`-feature(Feature, enable|disable).`) in the file. Similar options can be\n  used to `erl` for enabling/disabling features allowed at runtime. The new\n  `maybe` expression (EEP-49) is fully supported as the feature `maybe_expr`.\n  The features support is documented in the reference manual.\n\n  Own Id: OTP-17988","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.6 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- The type spec of `erl_syntax:function_type/2` has been fixed.\n\n  Own Id: OTP-17302 Aux Id: PR-4705\n\n- Output parentheses around `BitStringExpr` when pretty-printing binary\n  comprehensions.\n\n  Own Id: OTP-17321","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Support for handling abstract code created before OTP R15 has been dropped.\n\n  Own Id: OTP-16678 Aux Id: PR-2627\n\n- The `igor` and `erl_tidy` modules have been the removed and are now maintained\n  by their original author Richard Carlsson. They can be found at\n  [github.com/richcarl/igor](https://github.com/richcarl/igor) and\n  [github.com/richcarl/erl_tidy](https://github.com/richcarl/erl_tidy),\n  respectively.\n\n  Own Id: OTP-17180","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.5 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- `epp_dodger` was unable to handle a parameterized macro in a function head.\n\n  Own Id: OTP-17064 Aux Id: GH-4445, PR-2964","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- All functions in `erl_tidy` in syntax_tools have now been deprecated and are\n  scheduled for removal in OTP 24. Users who still need it can find it at\n  [https://github.com/richcarl/erl_tidy](https://github.com/richcarl/erl_tidy).\n\n  Own Id: OTP-17167 Aux Id: OTP-17046","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.4 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-4"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- In the `syntax_tools` application, the `igor` module and all functions in\n  `erl_tidy` except `file/2` have been deprecated.\n\n  Own Id: OTP-17046","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.3.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Minor documentation fix of `erl_syntax:operator/1`.\n\n  Own Id: OTP-16732 Aux Id: PR-2659","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.3 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-3"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Remove incomplete support for `cond` expressions.\n\n  Own Id: OTP-15925 Aux Id: PR-2304\n\n- Improved indentation for code generated with `erl_prettypr` and `tidier`.\n\n  Own Id: OTP-16386 Aux Id: PR-2451","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.2.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Add missing calls to `erl_syntax:unwrap/1`. The nodes concerned represent\n  names and values of maps and map types.\n\n  Own Id: OTP-16012 Aux Id: PR-2348","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Correct links in the documentation.\n\n  Own Id: OTP-15761","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.1.7.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Add missing calls to `erl_syntax:unwrap/1`. The nodes concerned represent\n  names and values of maps and map types.\n\n  Own Id: OTP-16012 Aux Id: PR-2348","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1.7 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix pretty-printing of type funs.\n\n  Own Id: OTP-15519 Aux Id: ERL-815","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1.6 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix the `TypeName` type in erl_syntax_lib.\n\n  Own Id: OTP-15207 Aux Id: PR-1888\n\n- Correct unfolding of the stacktrace variable.\n\n  Own Id: OTP-15291 Aux Id: ERL-719\n\n- Correct `erl_syntax:revert/1` bug regarding the types `t:map/0` and\n  `t:tuple/0`.\n\n  Own Id: OTP-15294","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Support bitstrings as literals in module `erl_syntax`.\n\n  Own Id: OTP-15165 Aux Id: PR-1842","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.1.5 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-5"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Update to use the new string api instead of the old.\n\n  Own Id: OTP-15036","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.1.4.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Add missing calls to `erl_syntax:unwrap/1`. The nodes concerned represent\n  names and values of maps and map types.\n\n  Own Id: OTP-16012 Aux Id: PR-2348","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1.4.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix a bug regarding reverting map types.\n\n  Own Id: OTP-15098 Aux Id: ERIERL-177","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1.4 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1.3 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-3"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- General Unicode improvements.\n\n  Own Id: OTP-14462\n\n- A process trapping exits and calling `erl_tidy` no longer hangs if an error\n  occurs.\n\n  Own Id: OTP-14471 Aux Id: ERL-413","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.1.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-2"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.1.1.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix a bug regarding reverting map types.\n\n  Own Id: OTP-15098 Aux Id: ERIERL-177","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- The address to the FSF in the license header has been updated.\n\n  Own Id: OTP-14084","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 2.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix a bug where `erl_tidy` crashed on the tilde character when printing to\n  standard output.\n\n  Own Id: OTP-13725 Aux Id: ERL-151, PR-1071\n\n- `merl_transform` could get into an infinite loop when syntactically incorrect\n  text was passed to a `merl:qquote/2,3` call.\n\n  Own Id: OTP-13755","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Improve types and specs in OTP documentation generated from Erlang source\n  files.\n\n  Own Id: OTP-13720 Aux Id: ERL-120","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 2.0 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-2-0"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- The abstract data type in `erl_syntax` is augmented with types and function\n  specifications.\n\n  The module `erl_prettypr` pretty prints types and function specification, and\n  the output can be parsed.\n\n  The types of record fields are no longer ignored. As a consequence\n  `erl_syntax_lib:analyze_record_field/1` returns `{Default, Type}` instead of\n  `Default`. The functions `analyze_record_attribute`, `analyze_attribute`,\n  `analyze_form`, and `analyze_forms` in the `erl_syntax_lib` module are also\n  affected by this incompatible change.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12863","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.7 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-7"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Use the new `erl_anno` module.\n\n  Own Id: OTP-12732\n\n- The `merl` module has been added to the `syntax_tools` application. The Merl\n  library is a simpler way to work with erl_syntax parse trees.\n\n  Own Id: OTP-12769","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.18 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix bad format of error in epp_dodger:parse_file/3\n\n  Own Id: OTP-12406","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.17 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Teach Maps to erl_syntax\n\n  Affected functions:\n\n  - erl_syntax:abstract/1\n  - erl_syntax:concrete/1\n  - erl_syntax:is_leaf/1\n  - erl_syntax:is_literal/1\n\n  Own Id: OTP-12265","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.16 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- The default encoding for Erlang source files is now UTF-8. As a temporary\n  measure to ease the transition from the old default of Latin-1, if EDoc\n  encounters byte sequences that are not valid UTF-8 sequences, EDoc will re-try\n  in Latin-1 mode. This workaround will be removed in a future release.\n\n  Own Id: OTP-12008","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.15 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix reverting map in syntax_tools\n\n  There was a bug in erl_syntax when running e.g. erl_syntax:revert_forms,\n  affecting maps. Instead of getting Key/Value you got Key/Key in the resulting\n  abstract form.\n\n  Own Id: OTP-11930","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.14 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Add implementation of having erl_tidy print to screen instead of writing to\n  the file provided. (Thanks to Aaron France)\n\n  Own Id: OTP-11632\n\n- Support Maps syntax in syntax_tools (Thanks to Anthony Ramine).\n\n  Own Id: OTP-11663","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.13 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- In syntax_tools-1.6.12 (OTP R16B03) a bug was introduced which broke reverting\n  of local implicit funs. Implicit funs were mistakenly thought to be using\n  abstract terms for their name and arity. This has now been corrected. (Thanks\n  to Anthony Ramine)\n\n  Own Id: OTP-11576","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- The default encoding of Erlang files has been changed from ISO-8859-1 to\n  UTF-8.\n\n  The encoding of XML files has also been changed to UTF-8.\n\n  Own Id: OTP-10907","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.12 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fix transformation of implicit funs in igor (Thanks to Anthony Ramine)\n\n  Own Id: OTP-11506","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.11 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-11"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Miscellaneous updates due to Unicode support.\n\n  Own Id: OTP-10820","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.10 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-10"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.9 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Syntax Tools 1.6.9\n\n  Minor bugfixes, spec annotations and documentation cleanup. Thanks to Richard\n  Carlsson\n\n  Own Id: OTP-10208","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.8 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Minor suppressions and fixes of compilation warnings\n\n  Own Id: OTP-10016","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.7.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-7-2"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Variables are now now allowed in '`fun M:F/A`' as suggested by Richard O'Keefe\n  in EEP-23.\n\n  The representation of '`fun M:F/A`' in the abstract format has been changed in\n  an incompatible way. Tools that directly read or manipulate the abstract\n  format (such as parse transforms) may need to be updated. The compiler can\n  handle both the new and the old format (i.e. extracting the abstract format\n  from a pre-R15 BEAM file and compiling it using compile:forms/1,2 will work).\n  The `syntax_tools` application can also handle both formats.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9643\n\n- Eliminate use of deprecated regexp module\n\n  Own Id: OTP-9810","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.7.1 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- In a file containing declarations and comments without any empty lines between\n  them, the `recomment_forms()` function would associate a multi-line comment\n  with the declaration above it rather than the one following it. (Thanks to\n  Richard Carlsson and Kostis Sagonas.)\n\n  Own Id: OTP-9180","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.6.7 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-7"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Miscellaneous updates\n\n  Own Id: OTP-8976","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.6 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-6"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Minor changes and clean-ups.\n\n  Own Id: OTP-8709","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.5 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-5"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- The documentation is now possible to build in an open source environment after\n  a number of bugs are fixed and some features are added in the documentation\n  build process.\n\n  \\- The arity calculation is updated.\n\n  \\- The module prefix used in the function names for bif's are removed in the\n  generated links so the links will look like\n  \"http://www.erlang.org/doc/man/erlang.html#append_element-2\" instead of\n  \"http://www.erlang.org/doc/man/erlang.html#erlang:append_element-2\".\n\n  \\- Enhanced the menu positioning in the html documentation when a new page is\n  loaded.\n\n  \\- A number of corrections in the generation of man pages (thanks to Sergei\n  Golovan)\n\n  \\- The legal notice is taken from the xml book file so OTP's build process can\n  be used for non OTP applications.\n\n  Own Id: OTP-8343","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.4 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-4"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.3 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-3"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Miscellaneous updates.\n\n  Own Id: OTP-8190","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6-2"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Miscellaneous updates.\n\n  Own Id: OTP-8038","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.6 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-6"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Miscellaneous updates.\n\n  Own Id: OTP-7877","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.5.6 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-5-6"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Minor updates.\n\n  Own Id: OTP-7642","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.5.5 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-5-5"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Minor changes.\n\n  Own Id: OTP-7388","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.5.4 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-5-4"},{"type":"extras","title":"Improvements and New Features - Syntax_Tools Release Notes","doc":"- Minor updates, mostly cosmetic.\n\n  Own Id: OTP-7243","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Syntax_Tools 1.5.3 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- A missing directory (`examples`) has been added and another broken link in the\n  documentation has been fixed.\n\n  Own Id: OTP-6468","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.5.2 - Syntax_Tools Release Notes","doc":"","ref":"notes.html#syntax_tools-1-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Syntax_Tools Release Notes","doc":"- Fixed some broken links in the documentation.\n\n  Own Id: OTP-6420","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Syntax_Tools 1.5.1 - Syntax_Tools Release Notes","doc":"Miscellaneous changes.","ref":"notes.html#syntax_tools-1-5-1"},{"type":"extras","title":"Erlang Syntax and Metaprogramming tools","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Erlang Syntax and Metaprogramming tools","ref":"chapter.html"},{"type":"extras","title":"Overview - Erlang Syntax and Metaprogramming tools","doc":"This package contains modules for handling abstract syntax trees (ASTs) in\nErlang, in a way that is compatible with the \"abstract format\" parse trees of\nthe stdlib module `erl_parse`, together with utilities for reading source files,\n[pretty-printing syntax trees](`m:erl_prettypr`), and doing\n[metaprogramming](`m:merl`) in Erlang.\n\nThe abstract layer (defined in `m:erl_syntax`) is nicely structured and the node\ntypes are context-independent. The layer makes it possible to transparently\nattach source-code comments and user annotations to nodes of the tree. Using the\nabstract layer makes applications less sensitive to changes in the `m:erl_parse`\ndata structures, only requiring the `erl_syntax` module to be up-to-date.\n\nThe pretty printer `m:erl_prettypr` is implemented on top of the library module\n`m:prettypr`: this is a powerful and flexible generic pretty printing library,\nwhich is also distributed separately.\n\nFor a short demonstration of parsing and pretty-printing, simply compile the\nincluded module [assets/demo.erl](assets/demo.erl), and execute `demo:run()` from the Erlang\nshell. It will compile the remaining modules and give you further instructions.","ref":"chapter.html#overview"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.0-rc.2"}}