/** VSys:$mempool.cc:0.0.3-001$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: mempool.cc; File version: 0.0.3-001
 */
#include <string.h>

#include "mempool.h"
#include "logger.h"

#include "debug.h"

mempool::mempool( int hl ) {
	__LOCK_INIT( head );
	__LOCK_INIT( tail );

	head = tail = 0;
	head_mark = tail_mark = 0;
	heap_limit = hl;
	hdr.mph_type = MPH_DEFAULT;
	hdr.mph_size = 1;
	DEB(printf("Heap limit: %d bytes\n", hl ));
}

mempool::~mempool() {
	mempool_hdr * tmp;
	while( head ) {
		tmp = head->mph_next;
		delete head;
		head = tmp;
	}
	delete head;
}

void mempool::init( mempool_hdr * templ ) {
	hdr.mph_type = templ->mph_type;
	hdr.mph_size = templ->mph_size;
	if( heap_limit > 0 ) heap_limit = heap_limit/hdr.mph_size;
	DEB(fprintf(stderr, "Heap<%d> templ: %d mph_size, %d hl\n", 
				hdr.mph_type, hdr.mph_size, heap_limit));
}

void mempool :: put( mempool_hdr * nfl ) {
	DEB( printf( "MemPool::put() : %d/%d nodes\n",tail_mark - head_mark, heap_limit)); 
	if( tail_mark - head_mark > heap_limit && heap_limit > 0 ) {
		DEB( printf( "Overfulled heap: %d/%d.\n", (tail_mark - head_mark), heap_limit ));
		delete nfl;
		return;
	}
	memset(nfl, 0, sizeof( mempool_hdr ));
	__LOCK( tail );
	if( !tail ) {
		head = nfl;
	} else 
		tail->mph_next = nfl;
	tail = nfl;
	tail_mark++;
//	DEB( printf( "Watermarks: %u head, %u tail.\n", tail_mark, head_mark ));
	if( tail_mark > __TAIL_MARK_LIMIT ) {
		__LOCK( head );
		DEB( printf( "Truncating watermarks\n" ));
		DEB( printf( "Watermarks: %u tail, %u head.\n", tail_mark, head_mark ));
		tail_mark -= head_mark;
		head_mark = 0;
		__UNLOCK( head );
	}
	__UNLOCK( tail );
}

mempool_hdr * mempool :: get() {
//		DEB( printf( "Watermarks: %u head, %u tail.\n", tail_mark, head_mark ));
	DEB( printf( "MemPool::get() : %d/%d nodes\n",tail_mark - head_mark, heap_limit)); 
	mempool_hdr *tmp;
	if( !head ) goto empty;
	__LOCK( head );
	if( !head ) goto empty;
   	tmp = head;
	if( !head->mph_next ) {
		__LOCK( tail );
//			DEB( printf( "Truncating watermarks\n" ));
//			DEB( printf( "Watermarks: %u tail, %u head.\n", tail_mark, head_mark ));
		tail_mark -= head_mark;
		head_mark = 0;
		if( head->mph_next ) {
			head = head->mph_next;
		} else {
			head = tail = 0;
		}
		__UNLOCK( tail );
	} else
		head = head->mph_next;
	DEB(printf( "Heap used\n" ));
	head_mark++;
	__UNLOCK( head );
	return tmp;
empty:
	tmp = (mempool_hdr *) new char[hdr.mph_size];
	tmp->mph_size = hdr.mph_size;
	tmp->mph_type = hdr.mph_type;
	return tmp;
}

void mempool::dump() {
	char buf[128];
	snprintf( buf, 128, "Heap<%x>: %d/%d nodes, %d/%d bytes", 
			hdr.mph_type, tail_mark - head_mark, heap_limit,
			(tail_mark - head_mark)*hdr.mph_size, heap_limit*hdr.mph_size );
	writelog( buf );
}
