/** VSys:$logger.cc:0.0.3-018$ **/
/*
 *  Transfered by VSys script on   11 17:05:09 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: logger.cc; File version: 0.0.3-018
 */
#ifdef WIN32
#include <winsock2.h>
#include "win32/types.h"
#include "win32/version.h"
#include "win32/process.h"
#else
#include <sys/types.h>
#include <unistd.h>
#include "config.h"
#endif

#include <time.h>

#include "logger.h"

FILE *_lf = stderr;

void openlog() {
	if( _lf && _lf != stderr ) return;
	if( cfg.log ) _lf = fopen( cfg.log, "a" );
	if( !_lf ) {
		fprintf( stderr, "Unable to open `%s' log file!\n", cfg.log);
		fprintf( stderr, "Logging to stderr...\n" );
		_lf = stderr;
	}
	time_t tm = time(0);
	fprintf(_lf,"%s[%d]: Session opened on %s", cfg.bin, getpid(), ctime(&tm));
	fprintf(_lf,"%s[%d]: binary version `%s'\n",  cfg.bin, getpid(), VERSION);
}

void writelog( const char * str ) {
	fprintf( _lf, "%s[%d]: %s\n",  cfg.bin, getpid(), str );
	fflush( _lf );
}

void closelog() {
	time_t tm = time(0);
	fprintf(_lf,"%s[%d]: Session closed on %s", cfg.bin, getpid(), ctime(&tm));
	if( _lf && _lf != stderr ) fclose( _lf );
}
