;;;; -*- Mode: Lisp; Syntax: Common-Lisp; indent-tabs-mode: nil; Package: C -*-
;;;; vim: set filetype=lisp tabstop=8 shiftwidth=2 expandtab:

;;;;
;;;;  Copyright (c) 2010, Juan Jose Garcia-Ripoll
;;;;
;;;;    This program is free software; you can redistribute it and/or
;;;;    modify it under the terms of the GNU Library General Public
;;;;    License as published by the Free Software Foundation; either
;;;;    version 2 of the License, or (at your option) any later version.
;;;;
;;;;    See file '../Copyright' for full details.
;;;;
;;;;  CMPTYPES -- Data types for the Lisp core structures
;;;;

(in-package "COMPILER")

(defstruct (info)
  (local-vars nil)      ;;; List of var-objects created directly in the form.
  (type '(VALUES &REST T)) ;;; Type of the form.
  (sp-change nil)       ;;; Whether execution of the form may change
                        ;;; the value of a special variable.
  (volatile nil)        ;;; whether there is a possible setjmp. Beppe
  )

(defstruct (c1form (:include info)
                   (:print-object print-c1form)
                   (:constructor do-make-c1form))
  (name nil)
  (parents nil)
  (env (cmp-env-copy)) ;; Environment in which this form was compiled
  (args '())
  (side-effects nil) ;;; Does it have side effects
  (form nil)
  (toplevel-form nil)
  (file nil)
  (file-position 0))

(defun print-c1form (form stream)
  (format stream "#<form ~A ~X>" (c1form-name form) (si:pointer form)))

(defvar *c1form-level* 0)
(defun print-c1forms (form)
  (cond ((consp form)
         (let ((*c1form-level* (1+ *c1form-level*)))
           (mapc #'print-c1forms form)))
        ((c1form-p form)
         (format t "~% ~D > ~A, parent ~A" *c1form-level* form (c1form-parents form))
         (print-c1forms (c1form-args form))
         form)))

(defstruct (inline-info)
  name                  ;;; Function name
  arg-rep-types         ;;; List of representation types for the arguments
  return-rep-type       ;;; Representation type for the output
  arg-types             ;;; List of lisp types for the arguments
  return-type           ;;; Lisp type for the output
  exact-return-type     ;;; Only use this expansion when the output is
                        ;;; declared to have a subtype of RETURN-TYPE
  multiple-values       ;;; Works with all destinations, including VALUES / RETURN
  expansion             ;;; C template containing the expansion
  one-liner             ;;; Whether the expansion spans more than one line
)
