/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.module;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class DB2ModuleCondition
extends DB2Object<DB2Module> {
    private Integer id;
    private String owner;
    private DB2OwnerType ownerType;
    private String sqlState;
    private Timestamp createTime;
    private String remarks;

    public DB2ModuleCondition(DB2Module db2Module, ResultSet dbResult) throws DBException {
        super(db2Module, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONDNAME"), true);
        this.id = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"CONDID");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        this.sqlState = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQLSTATE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public Integer getId() {
        return this.id;
    }

    @Property(viewable=true, order=3, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=4, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=true, order=5)
    public String getSqlState() {
        return this.sqlState;
    }

    @Property(viewable=false, order=7, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }
}

