/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;

public class MySQLTableConstraint
extends MySQLTableConstraintBase {
    private final List<MySQLTableConstraintColumn> columns = new ArrayList<MySQLTableConstraintColumn>();
    private String checkClause;

    public MySQLTableConstraint(MySQLTable table, String name, String remarks, DBSEntityConstraintType constraintType, boolean persisted) {
        super(table, name, remarks, constraintType, persisted);
    }

    public MySQLTableConstraint(MySQLTable table, String name, String description, DBSEntityConstraintType constraintType, boolean persisted, JDBCResultSet resultSet) {
        super(table, name, description, constraintType, persisted, resultSet);
        this.checkClause = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CHECK_CLAUSE");
    }

    protected MySQLTableConstraint(DBRProgressMonitor monitor, MySQLTable table, DBSEntityConstraint source) throws DBException {
        super(table, source, false);
        List columns;
        if (source instanceof DBSEntityReferrer && (columns = ((DBSEntityReferrer)source).getAttributeReferences(monitor)) != null) {
            this.columns.clear();
            for (DBSEntityAttributeRef col : columns) {
                if (col.getAttribute() == null) continue;
                MySQLTableColumn ownCol = table.getAttribute(monitor, col.getAttribute().getName());
                this.columns.add(new MySQLTableConstraintColumn((AbstractTableConstraint<MySQLTable, ? extends MySQLTableConstraintColumn>)this, ownCol, col.getAttribute().getOrdinalPosition()));
            }
        }
    }

    public List<MySQLTableConstraintColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void addAttributeReference(DBSTableColumn column) throws DBException {
        this.columns.add(new MySQLTableConstraintColumn((AbstractTableConstraint<MySQLTable, ? extends MySQLTableConstraintColumn>)this, (MySQLTableColumn)column, this.columns.size()));
    }

    public void setAttributeReferences(List<MySQLTableConstraintColumn> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public void setCheckClause(String clause) {
        this.checkClause = clause;
    }

    @Property(viewable=true, editable=true, order=4, visibleIf=MySQLCheckConstraintsValueValidator.class)
    public String getCheckClause() {
        return this.checkClause;
    }

    public void addColumn(MySQLTableConstraintColumn column) {
        this.columns.add(column);
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((MySQLTable)this.getTable()).getContainer(), this.getTable(), this});
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return (MySQLDataSource)((MySQLTable)this.getTable()).getDataSource();
    }

    public static class MySQLCheckConstraintsValueValidator
    implements IPropertyValueValidator<MySQLTableConstraint, Object> {
        public boolean isValidValue(MySQLTableConstraint object, Object value) throws IllegalArgumentException {
            return object.getDataSource().supportsCheckConstraints();
        }
    }
}

