/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObjectWithLongId;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DuckDBSequence
extends GenericSequence
implements DBPObjectWithLongId,
GenericScriptObject {
    private long oid;
    private long startValue;
    private boolean cycle = false;
    private boolean temporary;
    private String sql;

    public DuckDBSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, lastValue, minValue, maxValue, incrementBy);
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"sequence_oid");
        this.startValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"start_value");
        this.cycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"cycle");
        this.temporary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"temporary");
        this.sql = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sql");
    }

    public DuckDBSequence(@NotNull GenericStructContainer container, @NotNull String name) {
        super(container, name);
    }

    @Property(viewable=true, order=0)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=6)
    public long getStartValue() {
        return this.startValue;
    }

    @Property(viewable=true, order=7)
    public boolean isCycle() {
        return this.cycle;
    }

    @Property(viewable=true, order=8)
    public boolean isTemporary() {
        return this.temporary;
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        if (CommonUtils.isEmpty((String)this.sql)) {
            this.sql = "CREATE SEQUENCE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        return this.sql;
    }
}

