/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerAuthentication;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SQLServerDataSourceProvider
extends JDBCDataSourceProvider {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        boolean isDriverAzure;
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return connectionInfo.getUrl();
        }
        StringBuilder url = new StringBuilder();
        boolean isJtds = SQLServerUtils.isDriverJtds(driver);
        boolean isSqlServer = SQLServerUtils.isDriverSqlServer(driver);
        boolean bl = isDriverAzure = isSqlServer && SQLServerUtils.isDriverAzure(driver);
        if (isSqlServer) {
            if (isJtds) {
                url.append("jdbc:jtds:sqlserver://");
                url.append(connectionInfo.getHostName());
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort()) && !connectionInfo.getHostPort().equals(driver.getDefaultPort())) {
                    url.append(":").append(connectionInfo.getHostPort());
                }
            } else {
                url.append("jdbc:sqlserver://");
                url.append(";serverName=").append(connectionInfo.getHostName());
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort()) && !connectionInfo.getHostPort().equals(driver.getDefaultPort())) {
                    url.append(";port=").append(connectionInfo.getHostPort());
                }
            }
            if (isJtds) {
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    url.append("/").append(connectionInfo.getDatabaseName());
                }
            } else {
                url.append(";");
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    url.append("databaseName=").append(connectionInfo.getDatabaseName());
                }
                if (isDriverAzure) {
                    url.append(";encrypt=true");
                }
            }
        } else if (isJtds) {
            url.append("jdbc:jtds:sybase://");
            url.append(connectionInfo.getHostName());
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":").append(connectionInfo.getHostPort());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                url.append("/").append(connectionInfo.getDatabaseName());
            }
        } else {
            url.append("jdbc:sybase:Tds:");
            url.append(connectionInfo.getHostName());
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":").append(connectionInfo.getHostPort());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                url.append("?ServiceName=").append(connectionInfo.getDatabaseName());
            }
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new SQLServerDataSource(monitor, container);
    }

    public DBPAuthModelDescriptor detectConnectionAuthModel(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        if (driver.getProviderDescriptor().matchesId("sqlserver") && (CommonUtils.isEmpty((String)connectionInfo.getAuthModelId()) || connectionInfo.getAuthModelId().equals("native"))) {
            SQLServerAuthentication authSchema = SQLServerUtils.detectAuthSchema(connectionInfo);
            String amId = authSchema.getReplacedByAuthModelId();
            DBPAuthModelDescriptor authModel = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getAuthModel(amId);
            if (authModel != null) {
                return authModel;
            }
            log.error((Object)("Replacement auth model " + amId + " not found"));
        }
        return super.detectConnectionAuthModel(driver, connectionInfo);
    }
}

