/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.rulers;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.ui.internal.texteditor.rulers.ExtensionPointHelper;
import org.eclipse.ui.internal.texteditor.rulers.RulerColumnMessages;
import org.eclipse.ui.internal.texteditor.rulers.RulerColumnPlacementConstraint;

public final class RulerColumnPlacement {
    private static final String ID = "id";
    private static final String GRAVITY = "gravity";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private final float fGravity;
    private final Set<RulerColumnPlacementConstraint> fConstraints;

    public RulerColumnPlacement() {
        this.fGravity = 1.0f;
        this.fConstraints = Collections.emptySet();
    }

    public RulerColumnPlacement(IConfigurationElement element) throws InvalidRegistryObjectException, CoreException {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        ExtensionPointHelper helper = new ExtensionPointHelper(element);
        this.fGravity = helper.getDefaultAttribute(GRAVITY, 1.0f);
        if (this.fGravity < 0.0f || this.fGravity > 1.0f) {
            helper.fail(RulerColumnMessages.RulerColumnPlacement_illegal_gravity_msg);
        }
        this.fConstraints = this.readIds(element.getChildren());
    }

    private Set<RulerColumnPlacementConstraint> readIds(IConfigurationElement[] children) throws CoreException {
        LinkedHashSet<RulerColumnPlacementConstraint> constraints = new LinkedHashSet<RulerColumnPlacementConstraint>((int)((double)children.length / 0.75) + 1, 0.75f);
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                boolean before;
                ExtensionPointHelper childHelper;
                String name;
                block11: {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    name = child.getName();
                    childHelper = new ExtensionPointHelper(child);
                    if (name != null) break block11;
                    childHelper.fail(RulerColumnMessages.RulerColumnPlacement_illegal_child_msg);
                    break block12;
                }
                switch (name) {
                    case "after": {
                        before = false;
                        break;
                    }
                    case "before": {
                        before = true;
                        break;
                    }
                    default: {
                        childHelper.fail(RulerColumnMessages.RulerColumnPlacement_illegal_child_msg);
                        break block12;
                    }
                }
                constraints.add(new RulerColumnPlacementConstraint(childHelper.getNonNullAttribute(ID), before));
            }
            ++n2;
        }
        return Collections.unmodifiableSet(constraints);
    }

    public float getGravity() {
        return this.fGravity;
    }

    public Set<RulerColumnPlacementConstraint> getConstraints() {
        return this.fConstraints;
    }
}

