/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;

public class HistoryStore {
    private IDialogSettings settingsManager;
    private int historySize;
    private String sectionName;

    public HistoryStore(IDialogSettings settingsManager, String sectionName, int historySize) {
        if (sectionName == null) {
            throw new IllegalStateException("No section loaded");
        }
        this.settingsManager = settingsManager;
        this.historySize = historySize;
        this.sectionName = sectionName;
    }

    public Iterable<String> get() {
        return this.getHistory();
    }

    public String get(int index) {
        return this.getHistory().get(index);
    }

    public void add(String historyItem) {
        List<String> history = this.getHistory();
        if (historyItem != null && !historyItem.isEmpty()) {
            history.add(0, historyItem);
        }
        this.write(history);
    }

    public void remove(String historyItem) {
        List<String> history = this.getHistory();
        int indexInHistory = history.indexOf(historyItem);
        if (indexInHistory >= 0) {
            history.remove(indexInHistory);
        }
        this.write(history);
    }

    public boolean isEmpty() {
        return this.getHistory().isEmpty();
    }

    private List<String> getHistory() {
        String[] historyEntries = this.settingsManager.getArray(this.sectionName);
        ArrayList<String> result = new ArrayList<String>();
        if (historyEntries != null) {
            result.addAll(Arrays.asList(historyEntries));
        }
        return result;
    }

    private void write(List<String> history) {
        int itemCount = history.size();
        HashSet<String> distinctItems = new HashSet<String>(itemCount);
        int i = 0;
        while (i < itemCount) {
            String item = history.get(i);
            if (distinctItems.contains(item)) {
                history.remove(i--);
                --itemCount;
            } else {
                distinctItems.add(item);
            }
            ++i;
        }
        while (history.size() > this.historySize) {
            history.remove(this.historySize);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        this.settingsManager.put(this.sectionName, names);
    }

    public int indexOf(String entry) {
        return this.getHistory().indexOf(entry);
    }

    public int size() {
        return this.getHistory().size();
    }
}

