/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.plan.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class PlanNodesTree
extends DatabaseObjectListControl<DBCPlanNode> {
    private String query;
    private DBPDataSource dataSource;
    private static final String CONFIG_COLOR_INDEXSCAN_BACKGROUND = "org.jkiss.dbeaver.sql.plan.view.color.indexscan.background";
    private static final String CONFIG_COLOR_INDEXSCAN_FOREGROUND = "org.jkiss.dbeaver.sql.plan.view.color.indexscan.foreground";
    private static final String CONFIG_COLOR_TABLESCAN_BACKGROUND = "org.jkiss.dbeaver.sql.plan.view.color.tablescan.background";
    private static final String CONFIG_COLOR_TABLESCAN_FOREGROUND = "org.jkiss.dbeaver.sql.plan.view.color.tablescan.foreground";
    private static ITreeContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DBCPlanNode) {
                Collection nestedNodes = ((DBCPlanNode)parentElement).getNested();
                return CommonUtils.isEmpty((Collection)nestedNodes) ? new Object[]{} : nestedNodes.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof DBCPlanNode) {
                return ((DBCPlanNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DBCPlanNode && !CommonUtils.isEmpty((Collection)((DBCPlanNode)element).getNested());
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public PlanNodesTree(Composite parent, int style, IWorkbenchSite site) {
        super(parent, style, site, (IContentProvider)CONTENT_PROVIDER);
        this.setFitWidth(true);
    }

    protected ObjectViewerRenderer createRenderer() {
        return new PlanTreeRenderer();
    }

    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        return "ExecutionPlan/" + this.dataSource.getContainer().getDriver().getId();
    }

    protected LoadingJob<Collection<DBCPlanNode>> createLoadService(boolean forUpdate) {
        return null;
    }

    public void showPlan(DBPDataSource dataSource, DBCPlan plan) {
        this.dataSource = dataSource;
        ArrayList nodes = new ArrayList(plan.getPlanNodes(Collections.singletonMap("keepOriginal", true)));
        TreeViewer itemsViewer = (TreeViewer)this.getItemsViewer();
        itemsViewer.getControl().setRedraw(false);
        try {
            this.clearListData();
            this.setListData(nodes, false, false);
            itemsViewer.expandToLevel(10);
        }
        finally {
            itemsViewer.getControl().setRedraw(true);
        }
    }

    public boolean supportsDataGrouping() {
        return false;
    }

    protected Color getObjectBackground(DBCPlanNode item) {
        if (item.getNodeKind() == DBCPlanNodeKind.TABLE_SCAN) {
            return UIUtils.getColorRegistry().get(CONFIG_COLOR_TABLESCAN_BACKGROUND);
        }
        if (item.getNodeKind() == DBCPlanNodeKind.INDEX_SCAN) {
            return UIUtils.getColorRegistry().get(CONFIG_COLOR_INDEXSCAN_BACKGROUND);
        }
        return super.getObjectBackground((Object)item);
    }

    protected Color getObjectForeground(DBCPlanNode item) {
        if (item.getNodeKind() == DBCPlanNodeKind.TABLE_SCAN) {
            return UIUtils.getColorRegistry().get(CONFIG_COLOR_TABLESCAN_FOREGROUND);
        }
        if (item.getNodeKind() == DBCPlanNodeKind.INDEX_SCAN) {
            return UIUtils.getColorRegistry().get(CONFIG_COLOR_INDEXSCAN_FOREGROUND);
        }
        return super.getObjectForeground((Object)item);
    }

    private class PlanTreeRenderer
    extends ObjectListControl.ViewerRenderer {
        private PlanTreeRenderer() {
            super((ObjectListControl)PlanNodesTree.this);
        }

        public boolean isHyperlink(Object element, Object cellValue) {
            return cellValue instanceof DBSObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)((DBSObject)cellValue));
            }
        }
    }
}

