/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMetaModel;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseProcedureBase;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class AltibaseProcedurePackaged
extends AltibaseProcedureBase {
    private String pkgSchema;
    private String pkgName;

    public AltibaseProcedurePackaged(GenericStructContainer container, String pkgSchema, String pkgName, String procedureName, boolean valid, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        super(container, procedureName, true, procedureType, functionResultType);
        this.pkgSchema = pkgSchema;
        this.pkgName = pkgName;
    }

    @Override
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return "-- Unable to get package dependent object source";
    }

    public void loadProcedureColumns(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load procedure columns");){
                JDBCPreparedStatement dbStat = ((AltibaseMetaModel)((GenericDataSource)this.getDataSource()).getMetaModel()).prepareProcedurePackagedColumnLoadStatement(session, this.pkgSchema, this.pkgName, this.getName());
                dbStat.setFetchSize(1000);
                dbStat.executeStatement();
                try (JDBCResultSet dbResult = dbStat.getResultSet();){
                    while (dbResult.next()) {
                        int precision;
                        boolean isFunction = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SUB_TYPE") == 1;
                        String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARA_NAME");
                        int position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARA_ORDER");
                        int columnSize = precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRECISION");
                        int scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SCALE");
                        int columnTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INOUT_TYPE");
                        int valueType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE");
                        String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
                        String defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT_VAL");
                        boolean notNull = defaultValue == null;
                        DBSProcedureParameterKind parameterType = switch (columnTypeNum) {
                            case 0 -> DBSProcedureParameterKind.IN;
                            case 2 -> DBSProcedureParameterKind.INOUT;
                            case 1 -> DBSProcedureParameterKind.OUT;
                            default -> DBSProcedureParameterKind.UNKNOWN;
                        };
                        if (!isFunction && columnName == null && position == 0) {
                            return;
                        }
                        if (isFunction && columnName == null && position == 1) continue;
                        if (isFunction) {
                            --position;
                        }
                        AltibaseProcedureParameter column = new AltibaseProcedureParameter(this, columnName, typeName, valueType, position, columnSize, scale, precision, notNull, "", parameterType);
                        this.addColumn(column);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, this.getDataSource());
        }
    }
}

