/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AISqlFormatter;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.impl.MessageChunk;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;

public class AITextUtils {
    private static final Log log = Log.getLog(AITextUtils.class);
    public static final String SQL_LANGUAGE_ID = "sql";
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("```[\\w+]*\\R([\\s\\S]*?)\\R```");

    private AITextUtils() {
    }

    public static String extractCode(String markdown) {
        Matcher matcher = CODE_BLOCK_PATTERN.matcher(markdown);
        if (matcher.find()) {
            String code = matcher.group(1).trim();
            if (code.endsWith(";")) {
                code = code.substring(0, code.length() - 1);
            }
            return code;
        }
        return markdown;
    }

    @NotNull
    public static String convertToSQL(@NotNull AIMessage prompt, @NotNull MessageChunk[] response, @Nullable DBPDataSource dataSource) {
        StringBuilder builder = new StringBuilder();
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.includeSourceTextInQuery")) {
            builder.append(SQLUtils.generateCommentLine((DBPDataSource)dataSource, (String)prompt.getContent()));
        }
        MessageChunk[] messageChunkArray = response;
        int n = response.length;
        int n2 = 0;
        while (n2 < n) {
            MessageChunk chunk = messageChunkArray[n2];
            if (chunk instanceof MessageChunk.Code) {
                MessageChunk.Code code = (MessageChunk.Code)chunk;
                builder.append(code.text()).append(System.lineSeparator());
            } else if (chunk instanceof MessageChunk.Text) {
                MessageChunk.Text text = (MessageChunk.Text)chunk;
                builder.append(SQLUtils.generateCommentLine((DBPDataSource)dataSource, (String)text.text()));
            }
            ++n2;
        }
        return builder.toString().trim();
    }

    @NotNull
    public static MessageChunk[] splitIntoChunks(@NotNull String text) {
        return AITextUtils.splitIntoChunks((SQLDialect)BasicSQLDialect.INSTANCE, text);
    }

    @NotNull
    public static MessageChunk[] splitIntoChunks(@NotNull SQLDialect dialect, @NotNull String text) {
        ArrayList<Record> chunks = new ArrayList<Record>();
        StringBuilder buffer = new StringBuilder();
        String codeBlockTag = null;
        String[] stringArray = (String[])text.lines().toArray(String[]::new);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("```")) {
                if (!buffer.isEmpty()) {
                    if (codeBlockTag != null) {
                        chunks.add(new MessageChunk.Code(buffer.toString(), codeBlockTag));
                    } else {
                        chunks.add(new MessageChunk.Text(buffer.toString()));
                    }
                    buffer.setLength(0);
                }
                codeBlockTag = codeBlockTag != null ? null : line.substring(3);
            } else {
                String firstKeyword;
                if (codeBlockTag == null && !SQLUtils.isCommentLine((SQLDialect)dialect, (String)line) && (firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)line)) != null && ArrayUtils.contains((Object[])SQLConstants.QUERY_KEYWORDS, (Object)firstKeyword)) {
                    codeBlockTag = SQL_LANGUAGE_ID;
                }
                if (!buffer.isEmpty()) {
                    buffer.append('\n');
                }
                buffer.append(line);
            }
            ++n2;
        }
        if (!buffer.isEmpty()) {
            if (codeBlockTag != null) {
                chunks.add(new MessageChunk.Code(buffer.toString(), codeBlockTag));
            } else {
                chunks.add(new MessageChunk.Text(buffer.toString()));
            }
        }
        return (MessageChunk[])chunks.toArray(MessageChunk[]::new);
    }

    @NotNull
    public static List<DBSObject> loadCustomEntities(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull Set<String> ids) {
        monitor.beginTask("Load custom entities", ids.size());
        try {
            List<DBSObject> list = AITextUtils.loadCheckedEntitiesById(monitor, dataSource.getContainer().getProject(), ids);
            return list;
        }
        catch (Exception e) {
            log.error((Object)e);
            List<DBSObject> list = List.of();
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    private static List<DBSObject> loadCheckedEntitiesById(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull Set<String> ids) throws DBException {
        ArrayList<DBSObject> output = new ArrayList<DBSObject>();
        for (String id : ids) {
            output.add(DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)id));
            monitor.worked(1);
        }
        return output;
    }

    public static MessageChunk[] processAndSplitCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIDatabaseContext context, @NotNull AISqlFormatter sqlFormatter, @NotNull String text) {
        String processedCompletion = sqlFormatter.formatGeneratedQuery(monitor, context.getExecutionContext().getDataSource(), text);
        return AITextUtils.splitIntoChunks(SQLUtils.getDialectFromDataSource((DBPDataSource)context.getExecutionContext().getDataSource()), processedCompletion);
    }

    @NotNull
    public static String extractGeneratedSqlQuery(@NotNull DBRProgressMonitor monitor, @NotNull AIDatabaseContext dbContext, @NotNull AIMessage userMessage, @NotNull String result) throws DBException {
        AISqlFormatter sqlFormatter = AIAssistantRegistry.getInstance().getDescriptor().createSqlFormatter();
        MessageChunk[] messageChunks = AITextUtils.processAndSplitCompletion(monitor, dbContext, sqlFormatter, result);
        return AITextUtils.convertToSQL(userMessage, messageChunks, dbContext.getExecutionContext().getDataSource());
    }
}

