/*
    This file is part of Kismet

    Kismet is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Kismet is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Kismet; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "dot11_ie_7_country.h"

void dot11_ie_7_country::parse(std::shared_ptr<kaitai::kstream> p_io) {
    m_country_code = p_io->read_bytes(2);
    m_environment = p_io->read_u1();
    m_country_list.reset(new shared_dot11d_country_triplet_vector());
}

void dot11_ie_7_country::parse_channels() {
    while (!p_io_c->is_eof()) {
        // Do our best to read all the channel codings; if we allow broken
        // country tags, read as far as we can and then stop, otherwise
        // pass the error upstream
        try {
            std::shared_ptr<dot11d_country_triplet> c(new dot11d_country_triplet());
            c->parse(p_io_c);
            m_country_list->push_back(c);
        } catch (std::exception& e) {
            if (i_allow_fragments)
                break;
            else
                throw(e);
        }
    }
}

void dot11_ie_7_country::dot11d_country_triplet::parse(std::shared_ptr<kaitai::kstream> p_io) {
    m_first_channel = p_io->read_u1();
    m_num_channels = p_io->read_u1();
    m_max_power = p_io->read_u1();
}

