/*  mvcase - rename files, changing names case
    Copyright (C) 1997  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <shhopt.h>

#define VERSION_INT 0
#define VERSION_DEC 1

void usage (void)
{

   printf ("mvcase version %d.%d\n", VERSION_INT, VERSION_DEC);
   printf ("Usage: mvcase [options] file(s)...\n");


   printf ("Options:\n");
   printf ("-u | --upper : convert names to uppercase\n");
   printf ("-l | --lower : convert names to lowercase\n");
   printf ("-h | --help  : print this help message\n");
   printf ("-p | --path  : convert pathname also\n");

   exit (0);

}

int main (int argc, char **argv)
{
  int i,j,k;
  int static flag_upper = 0;
  int static flag_lower = 0;
  int static flag_path  = 0;
  int static flag_help  = 0;
  char *aux_char = NULL;
  char *ptr_char = NULL;

  static optStruct myoptions[] = {
    {'u', "upper", OPT_FLAG, &flag_upper, 0 },
    {'l', "lower", OPT_FLAG, &flag_lower, 0 },
    {'h', "help",  OPT_FLAG, &flag_help, 0 },
    {'p', "path",  OPT_FLAG, &flag_path, 0 },
    {' ', " ",     OPT_END, (void *) NULL, 0 } 
  };

  optParseOptions (&argc, argv, myoptions, 0);

  if (flag_help)
    usage ();

  if ( ((flag_lower == 1) && (flag_upper == 1)) || (argc == 1) )
    usage ();

  if ((flag_lower == 0) && (flag_upper == 0)) 
    flag_lower = 1;

  for (i=1; i<argc; i++)
    {

      aux_char = (char *) realloc ((char *)aux_char, strlen (argv[i]));
      ptr_char = aux_char;
      
      strcpy (aux_char,argv[i]);

      if (!flag_path)
	if ((ptr_char = (char *) rindex (aux_char,'/'))==NULL)
	  ptr_char = aux_char;


      for (j = (int) (ptr_char-aux_char); j <= strlen(argv[i]); j++)
	if (flag_lower)
	  aux_char[j] = tolower (argv[i][j]);
	else
	  aux_char[j] = toupper (argv[i][j]);

      printf ("%s -> %s\n", argv[i], aux_char);

      if (rename(argv[i], aux_char))
	  {
	    printf ("Could not move file %s...\n", argv[i]);
	    free ((void *)aux_char);
	    exit (-1);
	  }

    }

  free ((void *)aux_char);

  exit (0);
}

