/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class OrRule
extends AbstractRule {
    static final long serialVersionUID = 2088765995061413165L;
    private final Rule rule1;
    private final Rule rule2;

    private OrRule(Rule firstParam, Rule secondParam) {
        this.rule1 = firstParam;
        this.rule2 = secondParam;
    }

    public static Rule getRule(Rule firstParam, Rule secondParam) {
        return new OrRule(firstParam, secondParam);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid OR rule - expected two rules but received " + stack.size());
        }
        Object o2 = stack.pop();
        Object o1 = stack.pop();
        if (o2 instanceof Rule && o1 instanceof Rule) {
            Rule p2 = (Rule)o2;
            Rule p1 = (Rule)o1;
            return new OrRule(p1, p2);
        }
        throw new IllegalArgumentException("Invalid OR rule: " + o2 + "..." + o1);
    }

    public boolean evaluate(LoggingEvent event) {
        return this.rule1.evaluate(event) || this.rule2.evaluate(event);
    }
}

