/* util.c
	$Id: util.c,v 1.3 2001/09/09 20:01:25 gwiley Exp $
   Glen Wiley <gwiley@ieee.org>

	these are some utilities used by xmpdvmkpkg 

Copyright (c)1999,2000,2001 Glen Wiley

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sub-license, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


*/

#if HAVE_CONFIG_H
 #include "config.h"
#endif

#include <errno.h>
#if HAVE_FCNTL_H
 #include <fcntl.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#if HAVE_UNISTD_H
 #include <unistd.h>
#endif
#include <Xm/Xm.h>
#include <Xm/ToggleB.h>
#include <Xm/Text.h>
#include "../pdv.h"
#include "xmpdvmkpkg.h"

#define MAXSTATUSMSG 255

/*---------------------------------------- xu_SetMainTitle
 set main window title bar and icon label
 newtitle  = string to use for title/label
 newprefix = string to use as prefix to subsequent new titles, if NULL
           then the previous non-NULL value is used
 topshell  = top level shell, if NULL then the previous non-NULL value 
           passed in is used as the default
*/
void
xu_SetMainTitle(const char *newtitle, const char *newprefix, Widget topshell)
{
	static Widget shellw  = NULL;
	static char   *prefix = NULL;
	static int    pfxlen  = 0;
	int      nargs = 0;
	Arg      args[3];
	char     *title;
	char     *icontitle;

	if(topshell)
		shellw = topshell;

	if(newprefix)
	{
		if(prefix)
			free(prefix);
		pfxlen = strlen(newprefix);
		prefix = (char *) malloc(pfxlen + 1);
		strcpy(prefix, newprefix);
	}

	title = (char *) malloc(strlen(newtitle) + pfxlen + 1);
	sprintf(title, "%s%s", (prefix ? prefix : ""), newtitle);

	icontitle = (char *) malloc(strlen(newtitle) + 1);
	strcpy(icontitle, newtitle);

	XtSetArg(args[nargs], XmNtitle,    title); nargs++;
	XtSetArg(args[nargs], XmNiconName, icontitle); nargs++;
	XtSetValues(shellw, args, nargs);

	free(title);
	free(icontitle);

	return;
} /* xu_SetMainTitle */

/*---------------------------------------- spectowidgets
	populate the widgets with the info in the newly populated spec file
	this will handle a "cleared" (NULL members) spec as well
*/
void
spectowidgets(void)
{
	XmTextSetString(g_specwidgets.tx_fnpkg
	 , (g_pdvspec.fn_pkg ? g_pdvspec.fn_pkg : ""));
	XmTextSetString(g_specwidgets.tx_fnpayld
	 , (g_pdvspec.fn_payld ? g_pdvspec.fn_payld : ""));
	XmTextSetString(g_specwidgets.tx_fnoutput
	 , (g_pdvspec.fn_output ? g_pdvspec.fn_output : ""));
	XmTextSetString(g_specwidgets.tx_exec
	 , (g_pdvspec.fn_exec ? g_pdvspec.fn_exec : ""));
	XmTextSetString(g_specwidgets.tx_fnhelp
	 , (g_pdvspec.fn_helpmsg ? g_pdvspec.fn_helpmsg : ""));
	XmTextSetString(g_specwidgets.tx_fnagrmsg
	 , (g_pdvspec.fn_agrmsg ? g_pdvspec.fn_agrmsg : ""));

	if(g_pdvspec.compress != NULL && g_pdvspec.compress[0] == 'y')
		XmToggleButtonSetState(g_specwidgets.tb_compress, True, False);
	else
		XmToggleButtonSetState(g_specwidgets.tb_compress, False, False);

	if(g_pdvspec.tar != NULL && g_pdvspec.tar[0] == 'y')
		XmToggleButtonSetState(g_specwidgets.tb_tar, True, False);
	else
		XmToggleButtonSetState(g_specwidgets.tb_tar, False, False);

	return;
} /* spectowidgets */

/*---------------------------------------- widgetstospec
	populate the spec with the info in the widgets
	we do not keep the strings provided by the Xm routine
	since XtFree must be called - we need to allocate using
	malloc to be able to reliably use freespecmembers()
*/
void
widgetstospec(struct pdvspec_st *spec)
{
	char *val;

	freespecmembers(spec);

	val = XmTextGetString(g_specwidgets.tx_fnpkg);
	if(val)
	{
		spec->fn_pkg = strdup(val);
		XtFree(val);
	}

	val = XmTextGetString(g_specwidgets.tx_fnpayld);
	if(val)
	{
		spec->fn_payld = strdup(val);
		XtFree(val);
	}

	val = XmTextGetString(g_specwidgets.tx_fnoutput);
	if(val)
	{
		spec->fn_output = strdup(val);
		XtFree(val);
	}

	val = XmTextGetString(g_specwidgets.tx_exec);
	if(val)
	{	
		spec->fn_exec = strdup(val);
		XtFree(val);
	}

	val = XmTextGetString(g_specwidgets.tx_fnhelp);
	if(val)
	{
		spec->fn_helpmsg = strdup(val);
		XtFree(val);
	}

	val = XmTextGetString(g_specwidgets.tx_fnagrmsg);
	if(val)
	{
		spec->fn_agrmsg = strdup(val);
		XtFree(val);
	}

	spec->compress = strdup("n");
	spec->tar      = strdup("n");

	if(XmToggleButtonGetState(g_specwidgets.tb_compress) == True)
		spec->compress[0] = 'y';

	if(XmToggleButtonGetState(g_specwidgets.tb_tar) == True)
		spec->tar[0] = 'y';

	return;
} /* widgetstospec */

/*---------------------------------------- cmpspecandwidgets
	compare the global pdv spec to the global widgets
	return 0 if they match
*/
int
cmpspecandwidgets(void)
{
	int    retval = 0;
	struct pdvspec_st spec;

	widgetstospec(&spec);

	retval = cmpspec(&spec, &g_pdvspec);

	freespecmembers(&spec);

	return retval;
} /* cmpspecandwidgets */

/*---------------------------------------- statusmsg
	display a status message in the status text widget
*/
void
statusmsg(char *fmt, ...)
{
	va_list ap;
	char msg[MAXSTATUSMSG];

	va_start(ap, fmt);
	vsnprintf(msg, MAXSTATUSMSG, fmt, ap);
	va_end(ap);
	msg[MAXSTATUSMSG-1] = '\0';

	if(g_statusw == NULL)
		fprintf(stderr, msg);
	else
		XmTextSetString(g_statusw, msg);

	return;
} /* statusmsg */

/* util.c */
