#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/file.h>
#include <fcntl.h>
#include "timselsysdep.h"
#include "uostr.h"
#include "uoio.h"
#include "uogetopt.h"
#include "smtp.h"
#include "smtptools.h"
#include "str_ulong.h"
#include "strdupsub.h"
#include "strcasestr.h"

char *myhostname=0;

static const char *wordchars=
	"abcdefghijklmnopqrstuvwxyz"
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	"1234567890"
	"@-_.=#$*";
static struct uogetopt myopts[]={
	{'w',"wordchars",UOGO_STRING,&wordchars,0,"'word' characters\n"
		"Default: A-Za-z0-9@-_.=#$*\n","CHARS"},
	{0,0} /* --help and --version */
};

struct rewrite {
	const char *header;
	const char *from;
	const char *to;
	struct rewrite *next;
};
struct rewrite *anker;

int 
main(int argc, char **argv)
{
	char buf[128];
	const char *argv0;
	uoio_t o;
	uoio_t input;
	uoio_t e;
	int got_it=0;
	argv0=strrchr(argv[0],'/'); if (!argv0) argv0=argv[0]; else argv0++;

	uoio_assign_r(&input,0,read,0);
	uoio_assign_w(&o,1,write,0);
	uoio_assign_w(&e,2,write,0);

	if (gethostname(buf,sizeof(buf)-1)==-1) {
		uoio_write_cstrmulti(&e,argv0,": hostname too long, gethostname failed: ",strerror(errno),"\n",0);
		uoio_flush(&e);
		_exit(1);
	} else {
		buf[sizeof(buf)-1]=0;
		myhostname=malloc(strlen(buf)+1);
		if (!myhostname) {
			write(2,argv0,strlen(argv0));
			write(2,": out of memory\n",16);
			_exit(1);
		}
		memcpy(myhostname,buf,strlen(buf)+1);
	}


	uogetopt(argv0,PACKAGE,VERSION,&argc,argv,uogetopt_out,
		"usage: mkmail header old now [header old new [...]]\n",myopts,0);
	if (argc==1 || argc%3!=1) {
		uoio_write_cstrmulti(&e,"usage: ",argv0,
			"  Headername Old New [Header Old New [H O N[...]]]\n",
			"  Headername: A (caseinsensitively treated) name of a header\n"
			"  Old: (casesensitive) something to replace with New\n",0);
		uoio_flush(&e);
		_exit(2);
	}


	/* read header */
	while (1) {
		ssize_t len;
		char *s;
		char *dop=0;
		int i;
		len=uoio_getdelim_zc(&input,&s,'\n');
		if (len==-1) {
			uoio_write_cstrmulti(&e,argv0,": cannot read stdin: ",
				strerror(errno),0);
			uoio_flush(&e);
			_exit(1);
		}
		if (len==0) break;
		if (len==1) {uoio_write_char(&o,*s); break; }
		if (*s==' ' || *s=='\t') {
			if (got_it) 
				goto hack_it;
			uoio_write_mem(&o,s,len);
			continue;
		}
		dop=strchr(s,':');
		if (!dop) {uoio_write_mem(&o,s,len); continue; }
		got_it=0;
		*dop=0;
		for (i=1;i<argc;i+=3) {
			if (0==strcasecmp(s,argv[i])) {
				*dop=':';
				got_it=i;
				goto hack_it;
			}
		}
		*dop=':';
		uoio_write_mem(&o,s,len);
		continue;
	  hack_it:
	  	{
			int j;
			int need_free=0;
			s[len-1]=0; /* terminate string, away with \n */
			for (j=got_it;j<argc;j+=3) {
				if (0==strcasecmp(argv[j],argv[got_it])) {
					char *x;
					if (!*wordchars)
						x=strdupsub(s,argv[j+1],argv[j+2],&len,strcasestr);
					else
						x=strdupsubw(s,argv[j+1],argv[j+2],wordchars,&len,strcasestr);
					if (!x) { 
						write(2,argv0,strlen(argv0));
						write(2,": out of memory\n",16);
						_exit(1);
					}
					if (need_free) free(s);
					need_free=1;
					s=x;
				}
			}
			uoio_write_cstr(&o,s);
			uoio_write_char(&o,'\n');
		}
	}
	while (1) {
		ssize_t len;
		char *s;
		len=uoio_getdelim_zc(&input,&s,'\n');
		if (len==-1) {
			uoio_write_cstrmulti(&e,argv0,": cannot read stdin: ",
				strerror(errno),0);
			uoio_flush(&e);
			_exit(1);
		}
		if (len==0) break;
		uoio_write_mem(&o,s,len);
	}
	if (-1==uoio_flush(&o)) {
		uoio_write_cstrmulti(&e,argv0,": cannot write to stdout: ",
			strerror(errno),0);
		uoio_flush(&e);
		_exit(1);
	}
	_exit(0);
}
