/*
** icmp.h -- redefine structures for IP and ICMP headers
** Copyright (C) 2002 Nik Reiman <nik@aboleo.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA
*/

#include <sys/types.h>
#include <netinet/in.h>

#ifndef ICMP_ECHO
#define ICMP_ECHO 0
#endif
#ifndef ICMP_ECHOREPLY
#define ICMP_ECHOREPLY 8
#endif

#ifndef IP_MAXPACKET
#define IP_MAXPACKET 65535
#endif

typedef char s_8bits;
typedef unsigned char u_8bits;
typedef short s_16bits;
typedef unsigned short u_16bits;
typedef int s_32bits;
typedef unsigned int u_32bits;

struct icmp_hdr
{
  u_8bits type;
  u_8bits code;
  u_16bits cksum;
  union
  {
    struct
    {
      u_16bits id;
      u_16bits seq;
    }
    echo;
  }
  un;
};

struct ip_hdr
{
#ifdef WORDS_BIGENDIAN
  u_8bits version:4, hdrlen:4;
#else
  u_8bits hdrlen:4, version:4;
#endif
  u_8bits tos;
  u_16bits tot_len;
  u_16bits id;
  u_16bits frag_off;
  u_8bits ttl;
  u_8bits protocol;
  u_16bits check;
  u_32bits saddr;
  u_32bits daddr;
};
