/*
** config.c -- Read in a portmon configuration file
** Copyright (C) 2002 Nik Reiman <nik@aboleo.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "portmon.h"
#include "config.h"

int read_config(char *config_fname)
{
 FILE *fd;
 char *fline = (char *)malloc(256 * sizeof(char));
 char *tmp = (char *)malloc(64 * sizeof(char));
 int host_num = 0, i, j, k, digit_state = 0;
 struct hostent *host = NULL;

 if((fd = fopen(config_fname, "r")) == NULL) {
  perror("fopen");
  return (-1);
 }

 // read lines off of the file until EOF
 while((fline = fgets(fline, 256 * sizeof(char), fd)) != NULL) {
  // perl-style comments
  if(fline[0] == '#' || isspace(fline[0]))
   continue;

  memset(tmp, '\0', 64);
  // get the hostname
  for(k = i = 0; i < strlen(fline); i++) {
   if(isspace(fline[i])) {
    strncpy(tmp, fline, i);
    // lookup the hostname
    // if the string is an IP addy, it will just put that there
    if((host = gethostbyname(tmp)) == NULL) {
     fprintf(stderr, "Unable to resolve hostname %s\n", tmp);
     k = 1;
     break;
    }

    // reallocate array to hold the new entry
    hosts = (struct host_struct *)realloc(hosts,
                                          (host_num +
                                           1) * sizeof(struct host_struct));
    if(hosts == NULL) {
     perror("realloc");
     return (-1);
    }

    strncpy(hosts[host_num].name, fline, i);
    hosts[host_num].name[i] = '\0';
    break;
   }
  }

  if(k == 1)
   continue;

  // get each port
  for(j = k = 0; i < strlen(fline); i++) {
   if(fline[i] == '#')
    break;
   else if(isdigit(fline[i]) && digit_state == 0) {
    hosts[host_num].ports[j].port = atoi(&fline[i]);
    hosts[host_num].ports[j].addr.sin_family = AF_INET;
    hosts[host_num].ports[j].addr.sin_port =
     htons(hosts[host_num].ports[j].port);
    memcpy(&hosts[host_num].ports[j].addr.sin_addr, host->h_addr,
           sizeof(host->h_addr));
    memset(hosts[host_num].ports[j].addr.sin_zero, '\0', 8);
    j++;
    digit_state = 1;
   }
   else if(isspace(fline[i]) && digit_state == 1) {
    hosts[host_num].ports[j - 1].is_down = 0;
    hosts[host_num].ports[j - 1].downtime = 0;
    digit_state = 0;
    snprintf(err_msg, STRLARGE, "Added host %s:%d\n", hosts[host_num].name,
             hosts[host_num].ports[j - 1].port);
    log_write(err_msg);
   }
   else {
   }
  }
  // number of ports we found
  hosts[host_num].num_ports = j;

  host_num++;
 }
 return (host_num);
}
