/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola;

import com.charliemouse.cambozola.Accessory;
import com.charliemouse.cambozola.PercentArea;
import com.charliemouse.cambozola.ViewerAttributeInterface;
import com.charliemouse.cambozola.shared.AppID;
import com.charliemouse.cambozola.shared.CamStream;
import com.charliemouse.cambozola.shared.ExceptionReporter;
import com.charliemouse.cambozola.shared.ImageChangeEvent;
import com.charliemouse.cambozola.shared.ImageChangeListener;
import com.charliemouse.cambozola.watermark.Watermark;
import com.charliemouse.cambozola.watermark.WatermarkCollection;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Viewer
extends Applet
implements MouseListener,
MouseMotionListener,
KeyListener,
ImageChangeListener,
ExceptionReporter,
ViewerAttributeInterface {
    private static final int DEFAULT_WIDTH = 352;
    private static final int DEFAULT_HEIGHT = 300;
    private static final String PAR_FAILUREIMAGE = "failureimage";
    private static final String PAR_DELAY = "delay";
    private static final String PAR_RETRIES = "retries";
    private static final String PAR_URL = "url";
    private static final String PAR_ACCESSORIES = "accessories";
    private static final String PAR_WATERMARK = "watermark";
    private static final String PAR_ACCESSORYSTYLE = "accessorystyle";
    private static final String PAR_DEBUG = "debug";
    private static final int VAL_STYLE_INDENT = 0;
    private static final int VAL_STYLE_OVERLAY = 1;
    private static final int VAL_STYLE_ALWAYSON = 2;
    private static boolean ms_standalone = false;
    private Properties m_parameters = null;
    private URL m_documentBase = null;
    private URL m_codeBase = null;
    private URL m_mainURL = null;
    private Vector m_alternateURLs = null;
    private CamStream m_imgStream = null;
    private String m_msg = null;
    private AppID m_props = null;
    private boolean m_displayAccessories = false;
    private int m_accessoryStyle = 0;
    private PercentArea m_area = new PercentArea();
    private Vector m_accessories = new Vector();
    private Image m_offscreenAccBar = null;
    private Image m_backingStore = null;
    private boolean m_readingStream = false;
    private int m_retryCount = 1;
    private int m_retryDelay = 1000;
    private Image m_failureImage = null;
    private boolean m_loadFailure = false;
    private Watermark m_wmHit = null;
    private WatermarkCollection m_wmCollection = null;
    private boolean m_debug = false;

    public Viewer() {
        this.m_props = AppID.getAppID();
        this.m_alternateURLs = new Vector();
        this.m_parameters = new Properties();
        ((Hashtable)this.m_parameters).put(PAR_ACCESSORYSTYLE, "indent");
        this.m_wmCollection = new WatermarkCollection();
    }

    public void init() {
        String string;
        String string2;
        Object object;
        if (!ms_standalone) {
            this.m_documentBase = this.getDocumentBase();
            this.m_codeBase = this.getCodeBase();
            ((Hashtable)this.m_parameters).put(PAR_FAILUREIMAGE, this.getHTMLParameterValue(PAR_FAILUREIMAGE));
            ((Hashtable)this.m_parameters).put(PAR_DELAY, this.getHTMLParameterValue(PAR_DELAY));
            ((Hashtable)this.m_parameters).put(PAR_RETRIES, this.getHTMLParameterValue(PAR_RETRIES));
            ((Hashtable)this.m_parameters).put(PAR_URL, this.getHTMLParameterValue(PAR_URL));
            ((Hashtable)this.m_parameters).put(PAR_ACCESSORIES, this.getHTMLParameterValue(PAR_ACCESSORIES));
            ((Hashtable)this.m_parameters).put(PAR_WATERMARK, this.getHTMLParameterValue(PAR_WATERMARK));
            ((Hashtable)this.m_parameters).put(PAR_WATERMARK, this.getHTMLParameterValue("watermarks"));
            ((Hashtable)this.m_parameters).put(PAR_ACCESSORYSTYLE, this.getHTMLParameterValue(PAR_ACCESSORYSTYLE));
            ((Hashtable)this.m_parameters).put(PAR_DEBUG, this.getHTMLParameterValue(PAR_DEBUG));
        }
        this.m_props = AppID.getAppID();
        this.m_alternateURLs = new Vector();
        String string3 = this.getParameterValue(PAR_WATERMARK);
        if (string3 != null) {
            this.m_wmCollection.populate(string3, this.m_documentBase);
        }
        String string4 = this.m_props.getAppNameVersion() + " " + this.m_props.getCopyright();
        this.setMessage(string4);
        System.err.println("// " + string4);
        System.err.println("// Build date: " + this.m_props.getBuildDate());
        System.err.println("// Available from " + this.m_props.getLocURL());
        String string5 = this.getParameterValue(PAR_FAILUREIMAGE);
        if (string5 != null && !string5.equals("")) {
            try {
                object = new URL(this.m_documentBase, string5);
                this.setFailureImageURL((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Unable to access URL for failure image -" + string5);
            }
        }
        if ((object = this.getParameterValue(PAR_DELAY)) != null && !((String)object).equals("")) {
            try {
                int n = Integer.parseInt((String)object);
                this.setRetryDelay(n);
            }
            catch (Exception exception) {
                System.err.println("Unable to set retry delay");
            }
        }
        this.m_debug = (string2 = this.getParameterValue(PAR_DEBUG)) != null && string2.equalsIgnoreCase("true");
        String string6 = this.getParameterValue(PAR_RETRIES);
        if (string6 != null && !string6.equals("")) {
            try {
                int n = Integer.parseInt(string6);
                this.setRetryCount(n);
            }
            catch (Exception exception) {
                System.err.println("Unable to set retry count");
            }
        }
        if ((string = this.getParameterValue(PAR_URL)) == null && !string.equals("")) {
            throw new IllegalArgumentException("Missing URL");
        }
        this.m_mainURL = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                URL uRL = new URL(this.m_codeBase, stringTokenizer.nextToken());
                this.m_alternateURLs.addElement(uRL);
                if (this.m_mainURL != null) continue;
                this.m_mainURL = uRL;
            }
            catch (MalformedURLException malformedURLException) {
                this.reportError(malformedURLException);
            }
        }
        this.setCurrentURL(this.m_mainURL);
        this.setAlternateURLs(this.m_alternateURLs);
        this.configureAccessories(this.getParameterValue(PAR_ACCESSORIES));
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void destroy() {
        this.stop();
    }

    public static void main(String[] stringArray) {
        ms_standalone = true;
        Frame frame = new Frame(AppID.getAppID().getAppName());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        Viewer viewer = new Viewer();
        int n = 352;
        int n2 = 300;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                int n3 = string.indexOf("=") + 1;
                if (string.equals("-noaccessories")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_ACCESSORIES, "none");
                    continue;
                }
                if (string.startsWith("-accessories=")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_ACCESSORIES, string.substring(n3));
                    continue;
                }
                if (string.startsWith("-retries=")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_RETRIES, string.substring(n3));
                    continue;
                }
                if (string.startsWith("-delay=")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_DELAY, string.substring(n3));
                    continue;
                }
                if (string.startsWith("-failureimage=")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_FAILUREIMAGE, string.substring(n3));
                    continue;
                }
                if (string.startsWith("-watermark=") || string.startsWith("-watermarks=")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_WATERMARK, string.substring(n3));
                    continue;
                }
                if (string.startsWith("-accessorystyle=")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_ACCESSORYSTYLE, string.substring(n3));
                    continue;
                }
                if (string.startsWith("-width=")) {
                    n = Integer.parseInt(string.substring(n3));
                    continue;
                }
                if (string.startsWith("-height=")) {
                    n2 = Integer.parseInt(string.substring(n3));
                    continue;
                }
                if (string.startsWith("-debug")) {
                    ((Hashtable)viewer.m_parameters).put(PAR_DEBUG, "true");
                    continue;
                }
                Viewer.usage();
                System.exit(0);
                continue;
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(string.trim());
        }
        ((Component)frame).setSize(n, n2);
        if (stringBuffer.length() == 0) {
            Viewer.usage();
            System.exit(0);
        }
        ((Hashtable)viewer.m_parameters).put(PAR_URL, stringBuffer.toString());
        frame.add("Center", viewer);
        viewer.init();
        ((Component)frame).setVisible(true);
        viewer.start();
    }

    private String getHTMLParameterValue(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    private String getParameterValue(String string) {
        return this.m_parameters.getProperty(string, null);
    }

    void setFailureImageURL(URL uRL) {
        try {
            this.m_failureImage = this.createImage((ImageProducer)uRL.getContent());
            this.m_failureImage.getWidth(this);
        }
        catch (IOException iOException) {
            System.err.println("Unable to access failure image contents - " + iOException);
        }
    }

    void setRetryCount(int n) {
        if (n < 1) {
            return;
        }
        this.m_retryCount = n;
    }

    void setRetryDelay(int n) {
        if (n < 0) {
            return;
        }
        this.m_retryDelay = n;
    }

    private void configureAccessories(String string) {
        String string2 = this.getParameterValue(PAR_ACCESSORYSTYLE);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("indent")) {
                this.m_accessoryStyle = 0;
            } else if (string2.equalsIgnoreCase("overlay")) {
                this.m_accessoryStyle = 1;
            } else if (string2.equalsIgnoreCase("always")) {
                this.m_accessoryStyle = 2;
            }
        }
        if (string == null || string.equals("") || string.equalsIgnoreCase("default")) {
            string = "Home,ZoomOut,ZoomIn,Pan,ChangeStream,Info,WWWHelp";
        } else if (string.equalsIgnoreCase("none")) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                Class<?> clazz = Class.forName("com.charliemouse.cambozola.accessories." + string3 + "Accessory");
                Accessory accessory = (Accessory)clazz.newInstance();
                accessory.setViewerAttributes(this);
                if (!accessory.isEnabled()) continue;
                accessory.getIconImage();
                this.m_accessories.addElement(accessory);
            }
            catch (Exception exception) {
                System.err.println("Unable to load accessory - " + string3);
                exception.printStackTrace();
            }
        }
    }

    public synchronized void reportError(Throwable throwable) {
        this.reportNote(throwable.getMessage());
        this.m_loadFailure = true;
        this.stop();
    }

    public synchronized void reportFailure(String string) {
        this.m_loadFailure = true;
        this.reportNote(string);
    }

    public synchronized void reportNote(String string) {
        System.err.println(string);
        this.setMessage(string);
        this.m_readingStream = false;
        this.repaint();
    }

    private synchronized void setMessage(String string) {
        this.m_msg = string;
    }

    public void start() {
    }

    public void stop() {
        if (this.m_imgStream != null) {
            this.m_imgStream.unhook();
            this.m_imgStream = null;
        }
        this.m_readingStream = false;
        Enumeration enumeration = this.m_accessories.elements();
        while (enumeration.hasMoreElements()) {
            ((Accessory)enumeration.nextElement()).terminate();
        }
    }

    public void setCurrentURL(URL uRL) {
        this.m_loadFailure = false;
        String string = this.m_props.getAppNameVersion() + "/Java " + System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        this.m_mainURL = uRL;
        if (this.m_imgStream != null) {
            this.m_msg = "";
            this.m_imgStream.removeImageChangeListener(this);
            this.m_imgStream.unhook();
        }
        this.m_imgStream = new CamStream(this.m_mainURL, string, this.m_documentBase, this.m_retryCount, this.m_retryDelay, this, this.m_debug);
        this.m_imgStream.addImageChangeListener(this);
        this.m_imgStream.start();
    }

    public void displayURL(URL uRL, String string) {
        if (ms_standalone) {
            return;
        }
        if (string == null) {
            this.getAppletContext().showDocument(uRL);
        } else {
            this.getAppletContext().showDocument(uRL, string);
        }
    }

    public Vector getAlternateURLs() {
        return this.m_alternateURLs;
    }

    public void setAlternateURLs(Vector vector) {
        this.m_alternateURLs = vector;
    }

    public void imageChanged(ImageChangeEvent imageChangeEvent) {
        this.update(this.getGraphics());
        this.getToolkit().sync();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Object object;
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.m_backingStore == null || this.m_backingStore.getWidth(this) != dimension.width || this.m_backingStore.getHeight(this) != dimension.height) {
            this.m_backingStore = this.createImage(dimension.width, dimension.height);
            this.m_wmCollection.recalculateLocations(dimension);
        }
        Graphics graphics2 = this.m_backingStore.getGraphics();
        if (this.m_loadFailure && this.m_failureImage != null) {
            this.paintFrame(graphics2, this.m_failureImage, dimension, null);
        } else if (!this.m_readingStream) {
            graphics2.setPaintMode();
            if (this.isDisplayingAccessories() && this.m_accessoryStyle == 0) {
                graphics2.setColor(Color.white);
                graphics2.fillRect(30, 0, dimension.width, dimension.height);
            }
            object = graphics2.getFontMetrics();
            int n = ((FontMetrics)object).stringWidth(this.m_msg);
            graphics2.setColor(Color.black);
            graphics2.drawString(this.m_msg, (dimension.width - n) / 2, dimension.height / 2);
            this.paintAccessories(graphics2);
        }
        if (this.m_imgStream != null) {
            object = this.m_imgStream.getCurrent();
            if (this.m_debug) {
                System.err.println("// Image to render = " + object);
            }
            if (object != null) {
                this.m_loadFailure = false;
                this.m_readingStream = true;
                this.paintFrame(graphics2, (Image)object, dimension, this.m_wmCollection);
            }
        }
        graphics.drawImage(this.m_backingStore, 0, 0, null);
        graphics2.dispose();
    }

    public void paintFrame(Graphics graphics, Image image, Dimension dimension, WatermarkCollection watermarkCollection) {
        int n = 0;
        if (this.isDisplayingAccessories() && this.m_accessoryStyle == 0) {
            n = 30;
        }
        int n2 = image.getWidth(this);
        int n3 = image.getHeight(this);
        if (n2 == -1 || n3 == -1) {
            return;
        }
        Rectangle rectangle = this.m_area.getArea(n2, n3);
        graphics.drawImage(image, n, 0, dimension.width, dimension.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this);
        if (watermarkCollection != null) {
            watermarkCollection.paint(graphics);
        }
        this.paintAccessories(graphics);
    }

    private void paintAccessories(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.m_accessories.size();
        if (this.isDisplayingAccessories() && n > 0) {
            if (this.m_offscreenAccBar == null) {
                this.m_offscreenAccBar = this.createImage(30, this.m_accessories.size() * 30);
                Graphics graphics2 = this.m_offscreenAccBar.getGraphics();
                int n2 = 0;
                Enumeration enumeration = this.m_accessories.elements();
                while (enumeration.hasMoreElements()) {
                    graphics2.setColor(Color.lightGray);
                    Accessory accessory = (Accessory)enumeration.nextElement();
                    int n3 = n2 * 30;
                    graphics2.fill3DRect(0, n3, 30, 30, true);
                    graphics2.drawImage(accessory.getIconImage(), 3, n3 + 3, new ImageObserver(){

                        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                            return true;
                        }
                    });
                    ++n2;
                }
                graphics2.dispose();
            }
            graphics.drawImage(this.m_offscreenAccBar, 0, 0, null);
            if (this.m_accessoryStyle == 0) {
                int n4 = this.m_accessories.size() * 30;
                graphics.setColor(Color.white);
                graphics.fillRect(0, n4, 30, dimension.height);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.m_readingStream) {
            return;
        }
        if (keyEvent.getKeyCode() == 36) {
            this.m_area.reset();
        } else if (keyEvent.getKeyCode() == 33) {
            this.m_area.zoomIn();
        } else if (keyEvent.getKeyCode() == 34) {
            this.m_area.zoomOut();
        } else if (keyEvent.getKeyCode() == 37) {
            this.m_area.panHorizontal(-1);
        } else if (keyEvent.getKeyCode() == 39) {
            this.m_area.panHorizontal(1);
        } else if (keyEvent.getKeyCode() == 38) {
            this.m_area.panVertical(-1);
        } else if (keyEvent.getKeyCode() == 40) {
            this.m_area.panVertical(1);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isDisplayingAccessories()) {
            this.setDisplayingAccessories(false);
            this.repaint();
        }
    }

    public boolean isDisplayingAccessories() {
        return this.m_displayAccessories || this.m_accessoryStyle == 2;
    }

    public void setDisplayingAccessories(boolean bl) {
        this.m_displayAccessories = bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!ms_standalone && !this.isDisplayingAccessories() && this.m_wmHit != null) {
            this.displayURL(this.m_wmHit.getURL(), null);
            return;
        }
        if (mouseEvent.getX() >= 30) {
            return;
        }
        int n = mouseEvent.getY() / 30;
        if (n < this.m_accessories.size()) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY() - n * 30);
            ((Accessory)this.m_accessories.elementAt(n)).actionPerformed(point);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Watermark watermark;
        boolean bl = false;
        Point point = mouseEvent.getPoint();
        boolean bl2 = this.isDisplayingAccessories();
        if (point.x < 30) {
            if (this.m_accessories.size() > 0) {
                String string;
                this.setDisplayingAccessories(true);
                int n = mouseEvent.getY() / 30;
                String string2 = "";
                if (n < this.m_accessories.size() && (string = ((Accessory)this.m_accessories.elementAt(n)).getDescription()) != null) {
                    string2 = string;
                }
                this.showStatus(string2);
            }
        } else {
            this.setDisplayingAccessories(false);
        }
        if (!this.m_displayAccessories && !ms_standalone && (watermark = this.m_wmCollection.isOverClickableWatermark(point)) != this.m_wmHit) {
            this.m_wmHit = watermark;
            bl = true;
            this.setCursor(this.m_wmHit != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }
        if (this.isDisplayingAccessories() != bl2) {
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    public void showStatus(String string) {
        if (!ms_standalone) {
            super.showStatus(string);
        }
    }

    public PercentArea getViewArea() {
        return this.m_area;
    }

    public CamStream getStream() {
        return this.m_imgStream;
    }

    public boolean isStandalone() {
        return ms_standalone;
    }

    public Vector getAccessories() {
        return this.m_accessories;
    }

    public static void usage() {
        System.err.println("Usage: WebCamURL [otherURLs] [-accessories=comma separated accessory list]");
        System.err.println("Current set of accessories are:");
        System.err.println(" o ZoomIn       - Zooms in to the image");
        System.err.println(" o ZoomOut      - Zooms out of the image");
        System.err.println(" o Home         - Shows all the image");
        System.err.println(" o Pan          - Pan around a zoomed-in image");
        System.err.println(" o ChangeStream - Swap to a different stream (if > 1 listed)");
        System.err.println(" o Info         - Displays information about the stream");
        System.err.println(" o WWWHelp      - Displays a web page showing help");
        System.err.println("");
        System.err.println(" -debug                      Write debug information");
        System.err.println(" -width={width}              Sets the width of the application");
        System.err.println(" -height={height}            Sets the height of the application");
        System.err.println(" -noaccessories              Will not display any accessories");
        System.err.println(" -accessories=none           Will not display any accessories");
        System.err.println(" -accessories=default        Will display the default set of accessories");
        System.err.println(" -accessorystyle={see below} Defines how the accessories will appear on top-left");
        System.err.println("   indent                      Will squeeze the image [default]");
        System.err.println("   overlay                     Will overlay the accessories onto the image");
        System.err.println("   always                      Always display the accessories (overlaid)");
        System.err.println(" -retries={num}              The number of retries (default = 1)");
        System.err.println(" -delay={num}                The number of milliseconds between retries");
        System.err.println(" -failureimage={url}         Image to display if failure to connect");
        System.err.println(" -watermark={see below}      List of watermarks, separated by '|'");
        System.err.println("   imageURL|corner|linkURL     Watermark information, separated by '|'");
    }
}

