# 0.79.1 release notes

**Release date:**  2022-09-30

## Summary

We recommend repository maintainers move to 0.79.1, which should be much
easier to package. Details in the [Packaging fixes](#packaging-fixes) section below.

We recommend users of our zip, dmg, and Windows installer packages upgrade
from 0.79.0 to fix some audio and usability bugs.

This maintenance release was made possible by everyone who tried 0.79.0,
submitted bugs and pull requests, and tested the updates: thank you!


## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## Fixes and regressions

- Fixed a CD-DA playback regression in **Might and Magic 6** when using
  multi-image mounts *(kcgen)*

- Allowed the ++esc++ key and window-close events to exit from the paused
  state *(Wengier)*

- Fixed a bug that prevented automounted drives from being used by
  `[autoexec]` commands *(kcgen)*

- Fixed an audio filter reset regression flagged in **Blues Brothers: Jukebox
  Adventure** *(kcgen)*

- Fixed a 16-bit stereo DMA regression detected when using the Sound Blaster's
  `modern` filter *(kcgen)*


<figure markdown>
  <video controls width=690><source src="https://www.dosbox-staging.org/static/videos/release-notes/0.79.1/303-by-acme-sb16-modern.mp4" type="video/mp4">Your browser does not support the <code>video</code> element.</video>

  <figcaption markdown>
  303 by Acme --- 30fps encoding, 120k cycles, and SB16 using the `modern` filter
  </figcaption>
</figure>


## Functionality refinements

- Improved ability to pipe between applications by using `Y:` as a temporary
  path *(Wengier)*

- Switched to warning-level logging for MIDI configuration issues *(Michael
  Drueing)*

- Improved the lookup of resources when XDG variables aren't set correctly
  *(kcgen, Eli Schwartz)*

- Updated the Dutch language to use the US keyboard layout by default
  *(Wengier)*

- Included Xbox compatible controller mapperfiles for 180+ games:
  [conf](https://github.com/dosbox-staging/dosbox-staging/pull/1977),
  [wiki](https://github.com/dosbox-staging/dosbox-staging/wiki/Keymapper)
  *(nemo93)*



## Translation improvements

- Added Dutch translation *(Robert de Rooy)*
- Fixed outdated content in German translation *(Burrito78)*
- Synced Italian translation *(Kappa971)*

- Dropped non-existant `KEYB` help messages from translation system
  *(Wengier)*

- Replaced more escape codes with markup tags in the translations *(Robert de
  Rooy)*

- Moved the mount type descriptions into the translation system *(Wengier)*


## Wiki updates since 0.79.0

- New [Keymapper page](https://github.com/dosbox-staging/dosbox-staging/wiki/Keymapper)
  with examples for those with Xbox controllers (nemo93)

- New [FAQ](https://github.com/dosbox-staging/dosbox-staging/wiki/Frequently-Asked-Questions)
  answering questions about audio settings, configuration files, video output,
  and other topics *(nemo93)*

- Notable additions to the [UniVBE](https://github.com/dosbox-staging/dosbox-staging/wiki/UniVBE),
  [Special keys](https://github.com/dosbox-staging/dosbox-staging/wiki/Special-Keys),
  [Getting started](https://github.com/dosbox-staging/dosbox-staging/wiki/Get-Started),
  [Suggested audio settings](https://github.com/dosbox-staging/dosbox-staging/wiki/Audio-configuration-recommendations),
  [Config examples](https://github.com/dosbox-staging/dosbox-staging/wiki/Config-file-examples),
  [AUTOTYPE candidates](https://github.com/dosbox-staging/dosbox-staging/wiki/AUTOTYPE-Candidates),
  and [Games with CD-DA, GUS and MIDI audio](https://github.com/dosbox-staging/dosbox-staging/wiki/Games-with-CD-DA,-GUS-and-MIDI-audio)
  pages *(nemo93)*


## Packaging fixes

- Adjusted Meson's FluidSynth dependency spec to match upstream's packaging
  *(Kirk Klobe)*

- Switched Meson to use SpeexDSP from the host first and fallback to wrap
  *(kcgen)*

- Switched Meson to use shared (instead of static) libraries by default
  *(kcgen)*

- Fixed installation of `resources` when using `meson install` *(kcgen, Eli
  Schwartz)*


Packagers will get shared libs and installed resources with these standard
steps:

```
meson setup --prefix /writable/install/path build
meson install -C build
```

## Thank you

Thanks to our financial contributors who allow us to purchase
hardware, licenses, and other non-trivial expenses to keep the team
and project going.

To support our work, donate to our
[GitHub Sponsors](https://github.com/sponsors/dosbox-staging) or
[Open Collective](https://opencollective.com/dosbox-staging).

We are grateful for all community contributions as well as the
original DOSBox project, upon which DOSBox Staging is based.

