# 0.78.1 release notes

**Release date:** 2022-01-07

## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## Fixes and regressions

Maintenance changes to 0.78.1 are as follows *(reported-by; fixed-by)*:

- Fixed a crash when exiting fullscreen mode and also using OpenGL output
  *(NicknineTheEagle; kcgen)*

- Fixed a crash and host input lockup when using SDL's kmsdrm video driver
  *(GranMinigun)*

- Fixed an early exit bug when using the `-exit` and `-c exit` command-line
  arguments *(pheener and d10sfan, kcgen)*

- Fixed a memory leak when changing one or more serial port types at runtime
  *(kcgen)*

- Fixed a regression that failed to apply aspect correction when using
  pixel-perfect output modes *(Diduz; kcgen)*

- Fixed a regression that disabled the keyboard input when using the debugger
  *(LowLevelMahn; kcgen)*

- Fixed a regression that impacted 32-bit performance on some Windows systems
  *(RaymanXY; Kirk Klobe and kcgen)*

- Fixed a regression that causes a crash when opening UPX-compressed code-page
  files *(FeralChild64; Wengier)*


## Functionality refinements

- Improved the modem's command-mode handling *(NicknineTheEagle)*

- Corrected the modem's DTR drop delay units from ms to hundredths of a second
  *(NicknineTheEagle)*

- Reverted the allowance that let the VESA refresh rate use the host rate
  *(RaymanXY; kcgen)*

- Allowed read-only image mounting for write-protected disk and floppy images
  *(Burrito78; Wengier)*


## Documentation-related improvements

- Updated the German messages and config file text *(Burrito78)*

- Updated the Italian messages and config file text *(Kappa971)*

- Fixed a documentation conflict describing the command line's version flag
  *(arrowgent)*

- Documented how to install gmock, a dependency added during 0.78.0, on Fedora
  *(oturpe)*


## Development and packaging fixes

- Fixed a compilation issue with Loguru on ARM32 using GCC 8
  *(rtissera; kcgen)*

- Fixed a compilation issue with older C++17 compilers missing
  `std::filesystem` support *(jowtron; gulrak and kcgen)*

- Fixed a build tool-specific bug that exposed the UI when running gmock tests
  *(oturpe and voyageur; brandonrobertz and kcgen)*


## Known issues

- The MSYS2-built debugger will fail to open if launched from the Windows UI.

    - As a work-around, run it from within a command console.

    - Thanks to *Sherman Perry* for investigating this issue and isolating it
    - to the Windows Console API.

- Audio might stutter on some Windows platforms. If your system is affected,
  adjust the mixer's settings in your config file as follows:

      ``` ini
      [mixer]
      blocksize = 1024
      prebuffer = 25
      ```

    !!! tip

        Run `dosbox -editconf` to open your config file.

    Thanks to *Genju* for reporting this regression and isolating the solution.


## Thank you

We are extremely grateful for all contributions, including the invaluable
improvements merged in from the DOSBox project.

