# 0.75.1 release notes

**Release date:** 2020-08-19


## Summary

This is a small bugfix release from 0.75.x stable branch---it includes a few
changes and bugfixes backported from upcoming 0.76.x version.


## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


Brave souls interested in the latest features can test our work-in-progress
[0.76.x&nbsp;alpha builds](../development-builds.md) :smile:. Please report any issues in
our [bugtracker](https://github.com/dosbox-staging/dosbox-staging/issues).

Also, check out our growing [Wiki](https://github.com/dosbox-staging/dosbox-staging/wiki).


## New features in detail

### Add support for binding more controller axes

Users can now comfortably use both sticks, as commonly found on modern
controllers (like DualShock or any Xbox controller). Previously, only
one stick could be mapped.

This change does not make old games "magically" recognize all features of
modern controllers. You need to map additional controller events to emulated
keyboard, mouse, or joystick events using DOSBox's keymapper (++ctrl+f1++).

This was a highly-requested community patches that wasn't accepted by the
upstream DOSBox project. We've included the 10-axes per controller version
of the patch in DOSBox Staging.

### Provide Windows x64 builds

Windows 64-bit builds are now provided alongside 32-bit builds.
Additional performance optimizations ([WPO]) are enabled for both
builds. Linux and macOS builds have been similarly optimized using [LTO]
since the 0.75.0 release.

Both Windows builds now require SSE 4.2 instruction set, which is now on par
with the Linux and macOS builds that have required SSE 4.2 support since
the 0.75.0 release.

*Steam Hardware survey indicates that 97.45% users have CPUs supporting
SSE 4.2, so your CPU is very likely good enough :smile:*

[wpo]: https://docs.microsoft.com/en-us/cpp/build/reference/gl-whole-program-optimization?view=vs-2019
[lto]: https://en.wikipedia.org/wiki/Interprocedural_optimization

### Log base address of emulated memory

This change was created per request from users of Cheat Engine, but it
might be useful for other memory scanners/debuggers as well.

Base memory address of DOS's emulated memory region is now logged to the
console:

    MEMORY: Base address: 0x5c758e0
    MEMORY: Using 4096 DOS memory pages (16 MiB)

Users previously had to debug the dosbox binary to discover the base
address; an easy but tedious process.

## Bugfixes

- Correct CD audio playback for games using single BIN/CUE; fixes a regression
  in **The Secret of Monkey Island**. (#385)

- Fix build issue for Windows x64 target after VS2019 update. (#389)

- Fix a crash happening after bindings for 2 controllers were added and then
  one controller is disconnected. (#405)

- Fix a crash on exit after removing controller actions bound to keyboard
  events. (#405)

- Prevent crash on SDL2 re-creating OpenGL window. (#509)

- Provide detailed help for `DIR /?` command. (#506)

- Fix pixel-perfect mode not respecting `aspect = false` setting. (#544)


## Contributors

### Maintainers

<div class="compact" markdown>

- Patryk Obara
- kcgen

</div>

### Direct contributors

<div class="compact" markdown>

- Expack3
- kcgen
- nemo93
- Patryk Obara
- WengierWu

</div>

### Indirect contributors

- cfoesch


## Changelog

You can read detailed changelog via Git, e.g. using the following command:

```
git shortlog ^v0.75.0 v0.75.1
```

## Thank you

We are extremely grateful for all contributions, including the invaluable
improvements merged in from the DOSBox project.

