/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '__mark_inode_dirty' function
 *
 * Notes:
 *  - Enforce Exploit Detection pCFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_PCFI_MARK_INODE_DIRTY_H
#define P_LKRG_EXPLOIT_DETECTION_PCFI_MARK_INODE_DIRTY_H

/* per-instance private data */
struct p_pcfi_mark_inode_dirty_data {
    ktime_t entry_stamp;
};


int p_pcfi_mark_inode_dirty_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_pcfi_mark_inode_dirty_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_pcfi_mark_inode_dirty_hook(int p_isra);
void p_uninstall_pcfi_mark_inode_dirty_hook(void);

#endif
