/***************************************************************************
                          menumanager.cpp  -  description
                             -------------------
    begin                : Tue Feb 29 2000
    copyright            : (C) 2000 by Michael Speck
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include "menumanager.h"

MenuManager::MenuManager(SDL_Surface *bkgnd, int cx, int cy, SFnt *fnt, SFnt *enlgt_fnt, int n, char *vck)
			: backgnd(bkgnd), font(fnt), enlgt_font(enlgt_fnt), menu_num(n), x(cx), y(cy), val_ctrl_keys(vck)
{
	int i;
	//menu pointer
	menus = 0;
	menus = new Menu*[menu_num];
	for (i = 0; i < menu_num; i++)
		menus[i] = 0;
	cur_menu = 0;
}

int MenuManager::InsertMenu(int i, Menu *m)
{
	if (i >= 0 && i < menu_num && m != 0 && menus[i] == 0) {
		menus[i] = m;
		return 0;
	}
	return 1;
}

MenuManager::~MenuManager()
{
	for (int i = 0; i < menu_num; i++)
		if (menus[i]) delete menus[i];
	delete menus;
}

Menu* MenuManager::CurMenu()
{
	return cur_menu;
}

Menu* MenuManager::GetMenu(int i)
{
    return menus[i];
}

void MenuManager::SetCurMenu(int i)
{
	if (i >= 0 && i < menu_num)
		cur_menu = menus[i];
}

int MenuManager::KeyEvent(SDL_KeyboardEvent *event)
{
	int code = event->keysym.sym;
	//string?
	if (cur_menu->CurItem()->Type() == ET_STRING) {
		cur_menu->CurItem()->EditStr(code, event->keysym.unicode);
	}
	//waiting for a ctrl key?
	if (cur_menu->CurItem()->Type() == ET_KEY &&
		cur_menu->CurItem()->Pos() == 0 &&
		val_ctrl_keys[code]) {
		    //check all menus for keys
		    for (int j = 0; j < menu_num; j++)
			    for (int i = 0; i < menus[j]->ItemNum(); i++)
				    if (menus[j]->Item(i)->Type() == ET_KEY && menus[j]->Item(i)->Pos() == code && menus[j]->Item(i) != cur_menu->CurItem())
					    return MR_CONTINUE;
			//directly to KeyEvent
			cur_menu->CurItem()->SetKey(code);
			return MR_CONTINUE;
		}
	//enter pressed?
	if (code == SDLK_RETURN) {
		switch (cur_menu->CurItem()->Type()) {
			case ET_SUBMENU:
				cur_menu->CurItem()->SetUsed(1);
				cur_menu->Hide(1);
				cur_menu = cur_menu->CurItem()->Submenu();
				cur_menu->Prepare(0);
				cur_menu->Show(1);
				return MR_CONTINUE;
			case ET_ACTION:
				return cur_menu->CurItem()->ActionId();
		}
	}
	//items changed?
	return cur_menu->KeyEvent(code);
}

void MenuManager::Activate()
{
	MenuItem	*item;
	for (int i = 0; i < menu_num; i++)
		for (int j = 0; j < menus[i]->ItemNum(); j++) {
			if (menus[i]->Item(j) == 0) continue;
			item = menus[i]->Item(j);
			item->SetXY(x, y + j * font->lh + (font->lh / 2) - (menus[i]->ItemNum() * font->lh) / 2);
			item->SetFont(font, enlgt_font);
			item->SetBackgnd(backgnd);
			item->ComputeStr();
	}
}

void MenuManager::Prepare()
{
	SetCurMenu(0);
	CurMenu()->Prepare(0);
}

int MenuManager::ButtonEvent(SDL_MouseButtonEvent button)
{
    switch (cur_menu->CurItem()->Type()) {
        case ET_SEPARATOR:
        case ET_STRING:
            return MR_CONTINUE;
		case ET_SUBMENU:
    		cur_menu->CurItem()->SetUsed(1);
			cur_menu->Hide(1);
			cur_menu = cur_menu->CurItem()->Submenu();
			cur_menu->Prepare(0);
			cur_menu->Show(1);
			return MR_CONTINUE;
		case ET_ACTION:
			return cur_menu->CurItem()->ActionId();
		default:
            return cur_menu->CurItem()->ButtonEvent(button);
	}
}
