#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 127
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 80
#define ALIAS_COUNT 2
#define TOKEN_COUNT 47
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 7

enum {
  sym_symbol = 1,
  anon_sym_LPAREN = 2,
  anon_sym_for = 3,
  anon_sym_in = 4,
  anon_sym_RPAREN = 5,
  anon_sym_LBRACK = 6,
  anon_sym_RBRACK = 7,
  sym_keyword = 8,
  sym_integer = 9,
  sym_float = 10,
  anon_sym_true = 11,
  anon_sym_false = 12,
  anon_sym_DQUOTE = 13,
  anon_sym_SQUOTE = 14,
  anon_sym_BQUOTE = 15,
  anon_sym_DOLLAR_LBRACE = 16,
  anon_sym_RBRACE = 17,
  aux_sym__escape_sequence_token1 = 18,
  sym_escape_sequence = 19,
  anon_sym_LBRACE = 20,
  anon_sym_COMMA = 21,
  anon_sym_COLON = 22,
  anon_sym_QMARK_DOT = 23,
  anon_sym_DOT = 24,
  anon_sym_PLUS = 25,
  anon_sym_DASH = 26,
  anon_sym_STAR = 27,
  anon_sym_SLASH = 28,
  anon_sym_PERCENT = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_EQ_EQ = 32,
  anon_sym_BANG_EQ = 33,
  anon_sym_EQ_TILDE = 34,
  anon_sym_GT_EQ = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_GT = 37,
  anon_sym_LT = 38,
  anon_sym_QMARK_COLON = 39,
  anon_sym_BANG = 40,
  anon_sym_QMARK = 41,
  sym_ident = 42,
  sym_comment = 43,
  sym__unescaped_single_quote_string_fragment = 44,
  sym__unescaped_double_quote_string_fragment = 45,
  sym__unescaped_backtick_string_fragment = 46,
  sym_source_file = 47,
  sym_ast_block = 48,
  sym_loop_widget = 49,
  sym_list = 50,
  sym_array = 51,
  sym_literal = 52,
  sym_number = 53,
  sym_boolean = 54,
  sym_string = 55,
  sym_string_interpolation = 56,
  sym__escape_sequence = 57,
  sym_expr = 58,
  sym_simplexpr = 59,
  sym_json_array = 60,
  sym_json_object = 61,
  sym_json_access = 62,
  sym_json_safe_access = 63,
  sym_json_dot_access = 64,
  sym_json_safe_dot_access = 65,
  sym_function_call = 66,
  sym_binary_expression = 67,
  sym_unary_expression = 68,
  sym_ternary_expression = 69,
  sym_parenthesized_expression = 70,
  aux_sym_source_file_repeat1 = 71,
  aux_sym_string_repeat1 = 72,
  aux_sym_string_repeat2 = 73,
  aux_sym_string_repeat3 = 74,
  aux_sym_string_repeat4 = 75,
  aux_sym_string_repeat5 = 76,
  aux_sym_string_repeat6 = 77,
  aux_sym_json_array_repeat1 = 78,
  aux_sym_json_object_repeat1 = 79,
  alias_sym_index = 80,
  alias_sym_string_fragment = 81,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_symbol] = "symbol",
  [anon_sym_LPAREN] = "(",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_keyword] = "keyword",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_RBRACE] = "}",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON] = ":",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_DOT] = ".",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_BANG] = "!",
  [anon_sym_QMARK] = "\?",
  [sym_ident] = "ident",
  [sym_comment] = "comment",
  [sym__unescaped_single_quote_string_fragment] = "_unescaped_single_quote_string_fragment",
  [sym__unescaped_double_quote_string_fragment] = "_unescaped_double_quote_string_fragment",
  [sym__unescaped_backtick_string_fragment] = "_unescaped_backtick_string_fragment",
  [sym_source_file] = "source_file",
  [sym_ast_block] = "ast_block",
  [sym_loop_widget] = "loop_widget",
  [sym_list] = "list",
  [sym_array] = "array",
  [sym_literal] = "literal",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_string] = "string",
  [sym_string_interpolation] = "string_interpolation",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_expr] = "expr",
  [sym_simplexpr] = "simplexpr",
  [sym_json_array] = "json_array",
  [sym_json_object] = "json_object",
  [sym_json_access] = "json_access",
  [sym_json_safe_access] = "json_safe_access",
  [sym_json_dot_access] = "json_dot_access",
  [sym_json_safe_dot_access] = "json_safe_dot_access",
  [sym_function_call] = "function_call",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_string_repeat3] = "string_repeat3",
  [aux_sym_string_repeat4] = "string_repeat4",
  [aux_sym_string_repeat5] = "string_repeat5",
  [aux_sym_string_repeat6] = "string_repeat6",
  [aux_sym_json_array_repeat1] = "json_array_repeat1",
  [aux_sym_json_object_repeat1] = "json_object_repeat1",
  [alias_sym_index] = "index",
  [alias_sym_string_fragment] = "string_fragment",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_symbol] = sym_symbol,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_keyword] = sym_keyword,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_ident] = sym_ident,
  [sym_comment] = sym_comment,
  [sym__unescaped_single_quote_string_fragment] = sym__unescaped_single_quote_string_fragment,
  [sym__unescaped_double_quote_string_fragment] = sym__unescaped_double_quote_string_fragment,
  [sym__unescaped_backtick_string_fragment] = sym__unescaped_backtick_string_fragment,
  [sym_source_file] = sym_source_file,
  [sym_ast_block] = sym_ast_block,
  [sym_loop_widget] = sym_loop_widget,
  [sym_list] = sym_list,
  [sym_array] = sym_array,
  [sym_literal] = sym_literal,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_string] = sym_string,
  [sym_string_interpolation] = sym_string_interpolation,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_expr] = sym_expr,
  [sym_simplexpr] = sym_simplexpr,
  [sym_json_array] = sym_json_array,
  [sym_json_object] = sym_json_object,
  [sym_json_access] = sym_json_access,
  [sym_json_safe_access] = sym_json_safe_access,
  [sym_json_dot_access] = sym_json_dot_access,
  [sym_json_safe_dot_access] = sym_json_safe_dot_access,
  [sym_function_call] = sym_function_call,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_string_repeat3] = aux_sym_string_repeat3,
  [aux_sym_string_repeat4] = aux_sym_string_repeat4,
  [aux_sym_string_repeat5] = aux_sym_string_repeat5,
  [aux_sym_string_repeat6] = aux_sym_string_repeat6,
  [aux_sym_json_array_repeat1] = aux_sym_json_array_repeat1,
  [aux_sym_json_object_repeat1] = aux_sym_json_object_repeat1,
  [alias_sym_index] = alias_sym_index,
  [alias_sym_string_fragment] = alias_sym_string_fragment,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__unescaped_single_quote_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym__unescaped_double_quote_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym__unescaped_backtick_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_ast_block] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_loop_widget] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_simplexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_json_array] = {
    .visible = true,
    .named = true,
  },
  [sym_json_object] = {
    .visible = true,
    .named = true,
  },
  [sym_json_access] = {
    .visible = true,
    .named = true,
  },
  [sym_json_safe_access] = {
    .visible = true,
    .named = true,
  },
  [sym_json_dot_access] = {
    .visible = true,
    .named = true,
  },
  [sym_json_safe_dot_access] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_json_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_json_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_index] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_condition = 3,
  field_consequence = 4,
  field_left = 5,
  field_name = 6,
  field_operator = 7,
  field_right = 8,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_right] = "right",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 3},
  [6] = {.index = 6, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 1},
    {field_operator, 0},
  [2] =
    {field_name, 0},
  [3] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [6] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_string_fragment,
  },
  [4] = {
    [2] = alias_sym_index,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym_string_repeat1, 2,
    aux_sym_string_repeat1,
    alias_sym_string_fragment,
  aux_sym_string_repeat3, 2,
    aux_sym_string_repeat3,
    alias_sym_string_fragment,
  aux_sym_string_repeat5, 2,
    aux_sym_string_repeat5,
    alias_sym_string_fragment,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 7,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 7,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 71,
  [73] = 73,
  [74] = 74,
  [75] = 71,
  [76] = 76,
  [77] = 51,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 48,
  [84] = 53,
  [85] = 47,
  [86] = 86,
  [87] = 55,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 91,
  [96] = 96,
  [97] = 96,
  [98] = 93,
  [99] = 99,
  [100] = 92,
  [101] = 89,
  [102] = 94,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 110,
  [113] = 110,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
};

static inline bool sym_symbol_character_set_1(int32_t c) {
  return (c < '('
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= ')' || (c < '{'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '?'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '?' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead == '%') ADVANCE(64);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(21);
      if (lookahead == ')') ADVANCE(22);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(57);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == ':') ADVANCE(51);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(5);
      if (lookahead == '>') ADVANCE(75);
      if (lookahead == '?') ADVANCE(83);
      if (lookahead == '[') ADVANCE(23);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead == ']') ADVANCE(24);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 't') ADVANCE(30);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '}') ADVANCE(44);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(81);
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(21);
      if (lookahead == ')') ADVANCE(22);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '[') ADVANCE(23);
      if (lookahead == ']') ADVANCE(24);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 't') ADVANCE(89);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '}') ADVANCE(44);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(6);
      if (lookahead == '%') ADVANCE(64);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '(') ADVANCE(21);
      if (lookahead == ')') ADVANCE(22);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(51);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '=') ADVANCE(5);
      if (lookahead == '>') ADVANCE(76);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '[') ADVANCE(23);
      if (lookahead == ']') ADVANCE(24);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '}') ADVANCE(44);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '!' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 4:
      if (lookahead == '&') ADVANCE(65);
      END_STATE();
    case 5:
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '~') ADVANCE(70);
      END_STATE();
    case 6:
      if (lookahead == '=') ADVANCE(68);
      END_STATE();
    case 7:
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == 'x') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(46);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 8:
      if (lookahead == '{') ADVANCE(43);
      END_STATE();
    case 9:
      if (lookahead == '{') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 10:
      if (lookahead == '|') ADVANCE(66);
      END_STATE();
    case 11:
      if (lookahead == '}') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(11);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 14:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(11);
      END_STATE();
    case 16:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 17:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(25);
      END_STATE();
    case 18:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead == '%') ADVANCE(64);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(21);
      if (lookahead == ')') ADVANCE(22);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(57);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == ':') ADVANCE(51);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(5);
      if (lookahead == '>') ADVANCE(75);
      if (lookahead == '?') ADVANCE(83);
      if (lookahead == '[') ADVANCE(23);
      if (lookahead == ']') ADVANCE(24);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 't') ADVANCE(30);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '}') ADVANCE(44);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 19:
      if (eof) ADVANCE(20);
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(21);
      if (lookahead == ')') ADVANCE(22);
      if (lookahead == ':') ADVANCE(17);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '[') ADVANCE(23);
      if (lookahead == ']') ADVANCE(24);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 't') ADVANCE(30);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (lookahead == '!' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(25);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'a') ADVANCE(29);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(37);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(39);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'l') ADVANCE(31);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'r') ADVANCE(32);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 's') ADVANCE(28);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'u') ADVANCE(27);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_symbol);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_true);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_false);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(48);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(47);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(72);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(71);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(74);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(69);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == ':') ADVANCE(80);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(33);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(52);
      if (lookahead == ':') ADVANCE(79);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(88);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(87);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(86);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'f') ADVANCE(1);
      if (lookahead == 'i') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'o') ADVANCE(3);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(4);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(5);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 19},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 1},
  [16] = {.lex_state = 1},
  [17] = {.lex_state = 1},
  [18] = {.lex_state = 1},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 1},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 19},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 2},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 19},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 2},
  [55] = {.lex_state = 2},
  [56] = {.lex_state = 19},
  [57] = {.lex_state = 19},
  [58] = {.lex_state = 19},
  [59] = {.lex_state = 19},
  [60] = {.lex_state = 2},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 2},
  [63] = {.lex_state = 2},
  [64] = {.lex_state = 2},
  [65] = {.lex_state = 19},
  [66] = {.lex_state = 2},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 2},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 2},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 19},
  [77] = {.lex_state = 19},
  [78] = {.lex_state = 19},
  [79] = {.lex_state = 19},
  [80] = {.lex_state = 19},
  [81] = {.lex_state = 19},
  [82] = {.lex_state = 19},
  [83] = {.lex_state = 19},
  [84] = {.lex_state = 19},
  [85] = {.lex_state = 19},
  [86] = {.lex_state = 19},
  [87] = {.lex_state = 19},
  [88] = {.lex_state = 0, .external_lex_state = 2},
  [89] = {.lex_state = 0, .external_lex_state = 3},
  [90] = {.lex_state = 0, .external_lex_state = 4},
  [91] = {.lex_state = 0, .external_lex_state = 4},
  [92] = {.lex_state = 0, .external_lex_state = 2},
  [93] = {.lex_state = 0, .external_lex_state = 3},
  [94] = {.lex_state = 0, .external_lex_state = 4},
  [95] = {.lex_state = 0, .external_lex_state = 4},
  [96] = {.lex_state = 0, .external_lex_state = 2},
  [97] = {.lex_state = 0, .external_lex_state = 2},
  [98] = {.lex_state = 0, .external_lex_state = 3},
  [99] = {.lex_state = 0, .external_lex_state = 3},
  [100] = {.lex_state = 0, .external_lex_state = 2},
  [101] = {.lex_state = 0, .external_lex_state = 3},
  [102] = {.lex_state = 0, .external_lex_state = 4},
  [103] = {.lex_state = 0, .external_lex_state = 4},
  [104] = {.lex_state = 0, .external_lex_state = 3},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 0, .external_lex_state = 2},
  [107] = {.lex_state = 0, .external_lex_state = 4},
  [108] = {.lex_state = 0, .external_lex_state = 3},
  [109] = {.lex_state = 0, .external_lex_state = 2},
  [110] = {.lex_state = 0, .external_lex_state = 2},
  [111] = {.lex_state = 0, .external_lex_state = 2},
  [112] = {.lex_state = 0, .external_lex_state = 4},
  [113] = {.lex_state = 0, .external_lex_state = 3},
  [114] = {.lex_state = 0, .external_lex_state = 3},
  [115] = {.lex_state = 0, .external_lex_state = 4},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 2},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 0},
};

enum {
  ts_external_token__unescaped_single_quote_string_fragment = 0,
  ts_external_token__unescaped_double_quote_string_fragment = 1,
  ts_external_token__unescaped_backtick_string_fragment = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__unescaped_single_quote_string_fragment] = sym__unescaped_single_quote_string_fragment,
  [ts_external_token__unescaped_double_quote_string_fragment] = sym__unescaped_double_quote_string_fragment,
  [ts_external_token__unescaped_backtick_string_fragment] = sym__unescaped_backtick_string_fragment,
};

static const bool ts_external_scanner_states[5][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__unescaped_single_quote_string_fragment] = true,
    [ts_external_token__unescaped_double_quote_string_fragment] = true,
    [ts_external_token__unescaped_backtick_string_fragment] = true,
  },
  [2] = {
    [ts_external_token__unescaped_double_quote_string_fragment] = true,
  },
  [3] = {
    [ts_external_token__unescaped_backtick_string_fragment] = true,
  },
  [4] = {
    [ts_external_token__unescaped_single_quote_string_fragment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_symbol] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_QMARK_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__unescaped_single_quote_string_fragment] = ACTIONS(1),
    [sym__unescaped_double_quote_string_fragment] = ACTIONS(1),
    [sym__unescaped_backtick_string_fragment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(126),
    [sym_ast_block] = STATE(59),
    [sym_loop_widget] = STATE(79),
    [sym_list] = STATE(79),
    [sym_array] = STATE(79),
    [sym_literal] = STATE(79),
    [sym_number] = STATE(83),
    [sym_boolean] = STATE(83),
    [sym_string] = STATE(79),
    [sym_expr] = STATE(79),
    [aux_sym_source_file_repeat1] = STATE(59),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [sym_keyword] = ACTIONS(13),
    [sym_integer] = ACTIONS(15),
    [sym_float] = ACTIONS(17),
    [anon_sym_true] = ACTIONS(19),
    [anon_sym_false] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(21),
    [anon_sym_SQUOTE] = ACTIONS(23),
    [anon_sym_BQUOTE] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_RBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(60), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [65] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    ACTIONS(53), 1,
      anon_sym_RPAREN,
    STATE(63), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [130] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    ACTIONS(55), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [195] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(40), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [257] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(41), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [319] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(71), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [381] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(72), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [443] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(64), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [505] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(69), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [567] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(30), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [629] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(70), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [691] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(61), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [753] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(62), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [815] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(74), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [877] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(66), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [939] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(38), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1001] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(39), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1063] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(67), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1125] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(73), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1187] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(27), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1249] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(75), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1311] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(43), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1373] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      sym_integer,
    ACTIONS(37), 1,
      sym_float,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_BQUOTE,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym_ident,
    STATE(37), 1,
      sym_simplexpr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 2,
      sym_number,
      sym_boolean,
    ACTIONS(49), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(42), 13,
      sym_literal,
      sym_string,
      sym_json_array,
      sym_json_object,
      sym_json_access,
      sym_json_safe_access,
      sym_json_dot_access,
      sym_json_safe_dot_access,
      sym_function_call,
      sym_binary_expression,
      sym_unary_expression,
      sym_ternary_expression,
      sym_parenthesized_expression,
  [1435] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(61), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(59), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1470] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(65), 1,
      sym_symbol,
    ACTIONS(68), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      sym_keyword,
    ACTIONS(77), 1,
      sym_integer,
    ACTIONS(80), 1,
      sym_float,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(89), 1,
      anon_sym_SQUOTE,
    ACTIONS(92), 1,
      anon_sym_BQUOTE,
    ACTIONS(95), 1,
      anon_sym_LBRACE,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(26), 2,
      sym_ast_block,
      aux_sym_source_file_repeat1,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    ACTIONS(63), 3,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [1529] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(106), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(98), 18,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1567] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(110), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(108), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(114), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(112), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1631] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
    ACTIONS(116), 5,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
  [1683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(134), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(140), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(138), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(144), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(142), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(146), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(150), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(154), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1875] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(160), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(158), 13,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [1917] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(160), 1,
      anon_sym_QMARK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(158), 11,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_QMARK_COLON,
  [1963] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(160), 1,
      anon_sym_QMARK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
    ACTIONS(158), 6,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
  [2013] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(160), 1,
      anon_sym_QMARK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
    ACTIONS(158), 8,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_COLON,
  [2061] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(160), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(158), 18,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(59), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2131] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(160), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(158), 15,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(162), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2203] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(168), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(166), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(172), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(170), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(174), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(178), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(182), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(186), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(190), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2427] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      sym_keyword,
    ACTIONS(15), 1,
      sym_integer,
    ACTIONS(17), 1,
      sym_float,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_for,
    ACTIONS(196), 1,
      anon_sym_RPAREN,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(58), 2,
      sym_ast_block,
      aux_sym_source_file_repeat1,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [2487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(198), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(202), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(208), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(206), 21,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_QMARK_DOT,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_COLON,
  [2583] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      sym_keyword,
    ACTIONS(15), 1,
      sym_integer,
    ACTIONS(17), 1,
      sym_float,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(210), 1,
      anon_sym_RBRACK,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(57), 2,
      sym_ast_block,
      aux_sym_source_file_repeat1,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [2640] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      sym_keyword,
    ACTIONS(15), 1,
      sym_integer,
    ACTIONS(17), 1,
      sym_float,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(212), 1,
      anon_sym_RBRACK,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(26), 2,
      sym_ast_block,
      aux_sym_source_file_repeat1,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [2697] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      sym_keyword,
    ACTIONS(15), 1,
      sym_integer,
    ACTIONS(17), 1,
      sym_float,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(214), 1,
      anon_sym_RPAREN,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(26), 2,
      sym_ast_block,
      aux_sym_source_file_repeat1,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [2754] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      sym_keyword,
    ACTIONS(15), 1,
      sym_integer,
    ACTIONS(17), 1,
      sym_float,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(216), 1,
      ts_builtin_sym_end,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(26), 2,
      sym_ast_block,
      aux_sym_source_file_repeat1,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [2811] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(218), 1,
      anon_sym_RBRACK,
    ACTIONS(220), 1,
      anon_sym_COMMA,
    STATE(117), 1,
      aux_sym_json_array_repeat1,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [2865] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(222), 1,
      anon_sym_RBRACE,
    ACTIONS(224), 1,
      anon_sym_COMMA,
    STATE(118), 1,
      aux_sym_json_object_repeat1,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [2919] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
    ACTIONS(226), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [2969] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(220), 1,
      anon_sym_COMMA,
    ACTIONS(228), 1,
      anon_sym_RPAREN,
    STATE(119), 1,
      aux_sym_json_array_repeat1,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3023] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(230), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3072] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      sym_keyword,
    ACTIONS(15), 1,
      sym_integer,
    ACTIONS(17), 1,
      sym_float,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    STATE(124), 1,
      sym_ast_block,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(83), 2,
      sym_number,
      sym_boolean,
    STATE(79), 6,
      sym_loop_widget,
      sym_list,
      sym_array,
      sym_literal,
      sym_string,
      sym_expr,
  [3125] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(232), 1,
      anon_sym_RBRACK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3173] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(234), 1,
      anon_sym_RPAREN,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3221] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(236), 1,
      anon_sym_COLON,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3269] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(238), 1,
      anon_sym_COLON,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3317] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(240), 1,
      anon_sym_RBRACK,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3365] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(242), 1,
      anon_sym_RBRACE,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3413] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3461] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(246), 1,
      anon_sym_COLON,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3509] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(248), 1,
      anon_sym_RBRACE,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3557] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(100), 1,
      anon_sym_LBRACK,
    ACTIONS(102), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(132), 1,
      anon_sym_QMARK,
    ACTIONS(250), 1,
      anon_sym_RBRACE,
    ACTIONS(118), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(122), 2,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_COLON,
    ACTIONS(128), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(130), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(126), 3,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [3605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(252), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(190), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(256), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(260), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(266), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(264), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(268), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(272), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3766] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(178), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3789] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(198), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(174), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3835] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(276), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(208), 4,
      sym_symbol,
      sym_integer,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 11,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_keyword,
      sym_float,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
  [3881] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(280), 1,
      anon_sym_DQUOTE,
    ACTIONS(282), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(288), 1,
      sym__unescaped_double_quote_string_fragment,
    STATE(106), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(285), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(88), 2,
      sym_string_interpolation,
      aux_sym_string_repeat2,
  [3908] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_BQUOTE,
    ACTIONS(293), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(297), 1,
      sym__unescaped_backtick_string_fragment,
    STATE(108), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(295), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(93), 2,
      sym_string_interpolation,
      aux_sym_string_repeat6,
  [3935] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 1,
      anon_sym_SQUOTE,
    ACTIONS(301), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(307), 1,
      sym__unescaped_single_quote_string_fragment,
    STATE(107), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(304), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(90), 2,
      sym_string_interpolation,
      aux_sym_string_repeat4,
  [3962] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 1,
      anon_sym_SQUOTE,
    ACTIONS(312), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(316), 1,
      sym__unescaped_single_quote_string_fragment,
    STATE(107), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(314), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(90), 2,
      sym_string_interpolation,
      aux_sym_string_repeat4,
  [3989] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 1,
      anon_sym_DQUOTE,
    ACTIONS(318), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(322), 1,
      sym__unescaped_double_quote_string_fragment,
    STATE(106), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(320), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(88), 2,
      sym_string_interpolation,
      aux_sym_string_repeat2,
  [4016] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(297), 1,
      sym__unescaped_backtick_string_fragment,
    ACTIONS(324), 1,
      anon_sym_BQUOTE,
    STATE(108), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(295), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(99), 2,
      sym_string_interpolation,
      aux_sym_string_repeat6,
  [4043] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(316), 1,
      sym__unescaped_single_quote_string_fragment,
    ACTIONS(326), 1,
      anon_sym_SQUOTE,
    STATE(107), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(314), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(91), 2,
      sym_string_interpolation,
      aux_sym_string_repeat4,
  [4070] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(316), 1,
      sym__unescaped_single_quote_string_fragment,
    ACTIONS(324), 1,
      anon_sym_SQUOTE,
    STATE(107), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(314), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(90), 2,
      sym_string_interpolation,
      aux_sym_string_repeat4,
  [4097] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(322), 1,
      sym__unescaped_double_quote_string_fragment,
    ACTIONS(326), 1,
      anon_sym_DQUOTE,
    STATE(106), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(320), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(92), 2,
      sym_string_interpolation,
      aux_sym_string_repeat2,
  [4124] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_DQUOTE,
    ACTIONS(318), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(322), 1,
      sym__unescaped_double_quote_string_fragment,
    STATE(106), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(320), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(100), 2,
      sym_string_interpolation,
      aux_sym_string_repeat2,
  [4151] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(297), 1,
      sym__unescaped_backtick_string_fragment,
    ACTIONS(310), 1,
      anon_sym_BQUOTE,
    STATE(108), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(295), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(99), 2,
      sym_string_interpolation,
      aux_sym_string_repeat6,
  [4178] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 1,
      anon_sym_BQUOTE,
    ACTIONS(330), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(336), 1,
      sym__unescaped_backtick_string_fragment,
    STATE(108), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(333), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(99), 2,
      sym_string_interpolation,
      aux_sym_string_repeat6,
  [4205] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(322), 1,
      sym__unescaped_double_quote_string_fragment,
    ACTIONS(324), 1,
      anon_sym_DQUOTE,
    STATE(106), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(320), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(88), 2,
      sym_string_interpolation,
      aux_sym_string_repeat2,
  [4232] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(297), 1,
      sym__unescaped_backtick_string_fragment,
    ACTIONS(326), 1,
      anon_sym_BQUOTE,
    STATE(108), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(295), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(98), 2,
      sym_string_interpolation,
      aux_sym_string_repeat6,
  [4259] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_SQUOTE,
    ACTIONS(312), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(316), 1,
      sym__unescaped_single_quote_string_fragment,
    STATE(107), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(314), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(95), 2,
      sym_string_interpolation,
      aux_sym_string_repeat4,
  [4286] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      sym__unescaped_single_quote_string_fragment,
    STATE(103), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(339), 2,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(341), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [4307] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(352), 1,
      sym__unescaped_backtick_string_fragment,
    STATE(104), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(347), 2,
      anon_sym_BQUOTE,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(349), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [4328] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_BQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(355), 1,
      sym_symbol,
    STATE(65), 2,
      sym_string,
      sym_expr,
  [4351] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 1,
      sym__unescaped_double_quote_string_fragment,
    STATE(109), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(320), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(357), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4372] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym__unescaped_single_quote_string_fragment,
    STATE(103), 1,
      aux_sym_string_repeat3,
    STATE(115), 1,
      sym__escape_sequence,
    ACTIONS(314), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(359), 2,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4393] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      sym__unescaped_backtick_string_fragment,
    STATE(104), 1,
      aux_sym_string_repeat5,
    STATE(114), 1,
      sym__escape_sequence,
    ACTIONS(295), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(361), 2,
      anon_sym_BQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4414] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      sym__unescaped_double_quote_string_fragment,
    STATE(109), 1,
      aux_sym_string_repeat1,
    STATE(111), 1,
      sym__escape_sequence,
    ACTIONS(363), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(365), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [4435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(371), 3,
      sym__unescaped_double_quote_string_fragment,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4448] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(375), 3,
      sym__unescaped_double_quote_string_fragment,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4461] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(371), 3,
      sym__unescaped_single_quote_string_fragment,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4474] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(371), 3,
      sym__unescaped_backtick_string_fragment,
      anon_sym_BQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(379), 3,
      sym__unescaped_backtick_string_fragment,
      anon_sym_BQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    ACTIONS(383), 3,
      sym__unescaped_single_quote_string_fragment,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
  [4513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 1,
      anon_sym_COMMA,
    STATE(116), 1,
      aux_sym_json_array_repeat1,
    ACTIONS(226), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [4527] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(220), 1,
      anon_sym_COMMA,
    ACTIONS(390), 1,
      anon_sym_RBRACK,
    STATE(116), 1,
      aux_sym_json_array_repeat1,
  [4540] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(224), 1,
      anon_sym_COMMA,
    ACTIONS(392), 1,
      anon_sym_RBRACE,
    STATE(120), 1,
      aux_sym_json_object_repeat1,
  [4553] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(220), 1,
      anon_sym_COMMA,
    ACTIONS(394), 1,
      anon_sym_RPAREN,
    STATE(116), 1,
      aux_sym_json_array_repeat1,
  [4566] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 1,
      anon_sym_RBRACE,
    ACTIONS(398), 1,
      anon_sym_COMMA,
    STATE(120), 1,
      aux_sym_json_object_repeat1,
  [4579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      anon_sym_LBRACK,
    ACTIONS(403), 1,
      sym_ident,
  [4589] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 1,
      sym_symbol,
  [4596] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 1,
      sym_ident,
  [4603] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 1,
      anon_sym_RPAREN,
  [4610] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 1,
      anon_sym_in,
  [4617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 65,
  [SMALL_STATE(4)] = 130,
  [SMALL_STATE(5)] = 195,
  [SMALL_STATE(6)] = 257,
  [SMALL_STATE(7)] = 319,
  [SMALL_STATE(8)] = 381,
  [SMALL_STATE(9)] = 443,
  [SMALL_STATE(10)] = 505,
  [SMALL_STATE(11)] = 567,
  [SMALL_STATE(12)] = 629,
  [SMALL_STATE(13)] = 691,
  [SMALL_STATE(14)] = 753,
  [SMALL_STATE(15)] = 815,
  [SMALL_STATE(16)] = 877,
  [SMALL_STATE(17)] = 939,
  [SMALL_STATE(18)] = 1001,
  [SMALL_STATE(19)] = 1063,
  [SMALL_STATE(20)] = 1125,
  [SMALL_STATE(21)] = 1187,
  [SMALL_STATE(22)] = 1249,
  [SMALL_STATE(23)] = 1311,
  [SMALL_STATE(24)] = 1373,
  [SMALL_STATE(25)] = 1435,
  [SMALL_STATE(26)] = 1470,
  [SMALL_STATE(27)] = 1529,
  [SMALL_STATE(28)] = 1567,
  [SMALL_STATE(29)] = 1599,
  [SMALL_STATE(30)] = 1631,
  [SMALL_STATE(31)] = 1683,
  [SMALL_STATE(32)] = 1715,
  [SMALL_STATE(33)] = 1747,
  [SMALL_STATE(34)] = 1779,
  [SMALL_STATE(35)] = 1811,
  [SMALL_STATE(36)] = 1843,
  [SMALL_STATE(37)] = 1875,
  [SMALL_STATE(38)] = 1917,
  [SMALL_STATE(39)] = 1963,
  [SMALL_STATE(40)] = 2013,
  [SMALL_STATE(41)] = 2061,
  [SMALL_STATE(42)] = 2099,
  [SMALL_STATE(43)] = 2131,
  [SMALL_STATE(44)] = 2171,
  [SMALL_STATE(45)] = 2203,
  [SMALL_STATE(46)] = 2235,
  [SMALL_STATE(47)] = 2267,
  [SMALL_STATE(48)] = 2299,
  [SMALL_STATE(49)] = 2331,
  [SMALL_STATE(50)] = 2363,
  [SMALL_STATE(51)] = 2395,
  [SMALL_STATE(52)] = 2427,
  [SMALL_STATE(53)] = 2487,
  [SMALL_STATE(54)] = 2519,
  [SMALL_STATE(55)] = 2551,
  [SMALL_STATE(56)] = 2583,
  [SMALL_STATE(57)] = 2640,
  [SMALL_STATE(58)] = 2697,
  [SMALL_STATE(59)] = 2754,
  [SMALL_STATE(60)] = 2811,
  [SMALL_STATE(61)] = 2865,
  [SMALL_STATE(62)] = 2919,
  [SMALL_STATE(63)] = 2969,
  [SMALL_STATE(64)] = 3023,
  [SMALL_STATE(65)] = 3072,
  [SMALL_STATE(66)] = 3125,
  [SMALL_STATE(67)] = 3173,
  [SMALL_STATE(68)] = 3221,
  [SMALL_STATE(69)] = 3269,
  [SMALL_STATE(70)] = 3317,
  [SMALL_STATE(71)] = 3365,
  [SMALL_STATE(72)] = 3413,
  [SMALL_STATE(73)] = 3461,
  [SMALL_STATE(74)] = 3509,
  [SMALL_STATE(75)] = 3557,
  [SMALL_STATE(76)] = 3605,
  [SMALL_STATE(77)] = 3628,
  [SMALL_STATE(78)] = 3651,
  [SMALL_STATE(79)] = 3674,
  [SMALL_STATE(80)] = 3697,
  [SMALL_STATE(81)] = 3720,
  [SMALL_STATE(82)] = 3743,
  [SMALL_STATE(83)] = 3766,
  [SMALL_STATE(84)] = 3789,
  [SMALL_STATE(85)] = 3812,
  [SMALL_STATE(86)] = 3835,
  [SMALL_STATE(87)] = 3858,
  [SMALL_STATE(88)] = 3881,
  [SMALL_STATE(89)] = 3908,
  [SMALL_STATE(90)] = 3935,
  [SMALL_STATE(91)] = 3962,
  [SMALL_STATE(92)] = 3989,
  [SMALL_STATE(93)] = 4016,
  [SMALL_STATE(94)] = 4043,
  [SMALL_STATE(95)] = 4070,
  [SMALL_STATE(96)] = 4097,
  [SMALL_STATE(97)] = 4124,
  [SMALL_STATE(98)] = 4151,
  [SMALL_STATE(99)] = 4178,
  [SMALL_STATE(100)] = 4205,
  [SMALL_STATE(101)] = 4232,
  [SMALL_STATE(102)] = 4259,
  [SMALL_STATE(103)] = 4286,
  [SMALL_STATE(104)] = 4307,
  [SMALL_STATE(105)] = 4328,
  [SMALL_STATE(106)] = 4351,
  [SMALL_STATE(107)] = 4372,
  [SMALL_STATE(108)] = 4393,
  [SMALL_STATE(109)] = 4414,
  [SMALL_STATE(110)] = 4435,
  [SMALL_STATE(111)] = 4448,
  [SMALL_STATE(112)] = 4461,
  [SMALL_STATE(113)] = 4474,
  [SMALL_STATE(114)] = 4487,
  [SMALL_STATE(115)] = 4500,
  [SMALL_STATE(116)] = 4513,
  [SMALL_STATE(117)] = 4527,
  [SMALL_STATE(118)] = 4540,
  [SMALL_STATE(119)] = 4553,
  [SMALL_STATE(120)] = 4566,
  [SMALL_STATE(121)] = 4579,
  [SMALL_STATE(122)] = 4589,
  [SMALL_STATE(123)] = 4596,
  [SMALL_STATE(124)] = 4603,
  [SMALL_STATE(125)] = 4610,
  [SMALL_STATE(126)] = 4617,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simplexpr, 1),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_simplexpr, 1),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [65] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(79),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(52),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(56),
  [74] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(79),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(84),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(84),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(85),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(96),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(94),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(101),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(15),
  [98] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 2),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [106] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 2),
  [108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_array, 2),
  [110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_array, 2),
  [112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_object, 6),
  [114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_object, 6),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, .production_id = 6),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_safe_access, 5),
  [136] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_safe_access, 5),
  [138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 5, .production_id = 3),
  [140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 5, .production_id = 3),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_object, 5),
  [144] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_object, 5),
  [146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_access, 4),
  [148] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_access, 4),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 4, .production_id = 3),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 4, .production_id = 3),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_array, 4),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_array, 4),
  [158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 5),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 5),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_dot_access, 3, .production_id = 4),
  [164] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_dot_access, 3, .production_id = 4),
  [166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_safe_dot_access, 3, .production_id = 4),
  [168] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_safe_dot_access, 3, .production_id = 4),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 3, .production_id = 3),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 3, .production_id = 3),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_array, 3),
  [184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_array, 3),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json_object, 2),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json_object, 2),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_json_array_repeat1, 2),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_json_object_repeat1, 4),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ast_block, 1),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ast_block, 1),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_widget, 7),
  [274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_widget, 7),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2),
  [282] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(22),
  [285] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(111),
  [288] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(111),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat4, 2),
  [301] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat4, 2), SHIFT_REPEAT(8),
  [304] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat4, 2), SHIFT_REPEAT(115),
  [307] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat4, 2), SHIFT_REPEAT(115),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [320] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat6, 2),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat6, 2), SHIFT_REPEAT(7),
  [333] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat6, 2), SHIFT_REPEAT(114),
  [336] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat6, 2), SHIFT_REPEAT(114),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat3, 2),
  [341] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat3, 2), SHIFT_REPEAT(115),
  [344] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat3, 2), SHIFT_REPEAT(115),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat5, 2),
  [349] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat5, 2), SHIFT_REPEAT(114),
  [352] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat5, 2), SHIFT_REPEAT(114),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 1, .production_id = 1),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat4, 1, .production_id = 1),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat6, 1, .production_id = 1),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(111),
  [368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(111),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_interpolation, 3),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_interpolation, 3),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 1),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 1),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat5, 1),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat5, 1),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat3, 1),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat3, 1),
  [387] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_json_array_repeat1, 2), SHIFT_REPEAT(14),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_json_object_repeat1, 2),
  [398] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_json_object_repeat1, 2), SHIFT_REPEAT(10),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [413] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_yuck_external_scanner_create(void);
void tree_sitter_yuck_external_scanner_destroy(void *);
bool tree_sitter_yuck_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_yuck_external_scanner_serialize(void *, char *);
void tree_sitter_yuck_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_yuck(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_symbol,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_yuck_external_scanner_create,
      tree_sitter_yuck_external_scanner_destroy,
      tree_sitter_yuck_external_scanner_scan,
      tree_sitter_yuck_external_scanner_serialize,
      tree_sitter_yuck_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
