#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 993
#define LARGE_STATE_COUNT 20
#define SYMBOL_COUNT 189
#define ALIAS_COUNT 2
#define TOKEN_COUNT 82
#define EXTERNAL_TOKEN_COUNT 5
#define FIELD_COUNT 33
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 88

enum ts_symbol_identifiers {
  sym_lower_case_identifier = 1,
  anon_sym_LBRACE_DASH = 2,
  anon_sym_DASH_RBRACE = 3,
  sym_line_comment = 4,
  anon_sym_LPAREN = 5,
  anon_sym_COMMA = 6,
  anon_sym_RPAREN = 7,
  sym__upper_case_identifier_without_leading_whitespace = 8,
  sym__lower_case_identifier_without_leading_whitespace = 9,
  anon_sym_DOT = 10,
  anon_sym_PIPE = 11,
  anon_sym_LBRACE = 12,
  anon_sym_RBRACE = 13,
  anon_sym_SQUOTE = 14,
  aux_sym_char_constant_expr_token1 = 15,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 16,
  aux_sym_string_constant_expr_token1 = 17,
  anon_sym_DQUOTE = 18,
  aux_sym_string_constant_expr_token2 = 19,
  anon_sym_LBRACK = 20,
  anon_sym_RBRACK = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_then = 24,
  anon_sym_let = 25,
  anon_sym_in = 26,
  anon_sym_COLON_COLON = 27,
  anon_sym_left = 28,
  anon_sym_right = 29,
  anon_sym_non = 30,
  sym_upper_case_identifier = 31,
  sym_number_literal = 32,
  sym_string_escape = 33,
  sym_invalid_string_escape = 34,
  sym_module = 35,
  sym_effect = 36,
  sym_where = 37,
  sym_import = 38,
  sym_as = 39,
  sym_exposing = 40,
  sym_when = 41,
  sym_is = 42,
  sym_type = 43,
  sym_alias = 44,
  sym_port = 45,
  sym_infix = 46,
  sym_double_dot = 47,
  sym_eq = 48,
  sym_arrow = 49,
  sym_colon = 50,
  sym_backslash = 51,
  sym_underscore = 52,
  sym_dot = 53,
  anon_sym_PLUS = 54,
  anon_sym_DASH = 55,
  anon_sym_STAR = 56,
  anon_sym_SLASH = 57,
  anon_sym_SLASH_SLASH = 58,
  anon_sym_CARET = 59,
  anon_sym_EQ_EQ = 60,
  anon_sym_SLASH_EQ = 61,
  anon_sym_LT = 62,
  anon_sym_GT = 63,
  anon_sym_LT_EQ = 64,
  anon_sym_GT_EQ = 65,
  anon_sym_AMP_AMP = 66,
  anon_sym_PIPE_PIPE = 67,
  anon_sym_PLUS_PLUS = 68,
  anon_sym_LT_PIPE = 69,
  anon_sym_PIPE_GT = 70,
  anon_sym_LT_LT = 71,
  anon_sym_GT_GT = 72,
  anon_sym_LT_SLASH_GT = 73,
  anon_sym_LT_QMARK_GT = 74,
  anon_sym_PIPE_DOT = 75,
  anon_sym_PIPE_EQ = 76,
  sym__virtual_end_decl = 77,
  sym__virtual_open_section = 78,
  sym__virtual_end_section = 79,
  sym_minus_without_trailing_whitespace = 80,
  sym__block_comment_content = 81,
  sym_file = 82,
  sym_block_comment = 83,
  sym_module_declaration = 84,
  aux_sym__import_list = 85,
  aux_sym__top_decl_list = 86,
  sym_exposing_list = 87,
  sym_exposed_value = 88,
  sym_exposed_type = 89,
  sym_exposed_union_constructors = 90,
  sym_exposed_operator = 91,
  sym__dot_without_leading_whitespace = 92,
  sym_upper_case_qid = 93,
  sym_value_qid = 94,
  sym_field_accessor_function_expr = 95,
  sym_import_clause = 96,
  sym_as_clause = 97,
  sym_value_declaration = 98,
  sym_function_declaration_left = 99,
  sym_type_declaration = 100,
  sym_lower_type_name = 101,
  sym_union_variant = 102,
  sym__more_union_variants = 103,
  sym_type_alias_declaration = 104,
  sym_type_expression = 105,
  sym__type_expression_inner = 106,
  sym_type_ref = 107,
  sym__single_type_expression = 108,
  sym_type_ref_without_args = 109,
  sym_type_variable = 110,
  sym_record_type = 111,
  sym_field_type = 112,
  sym_type_annotation = 113,
  sym_port_annotation = 114,
  sym__expression = 115,
  sym_bin_op_expr = 116,
  sym_operator = 117,
  sym_operator_as_function_expr = 118,
  sym__operator_as_function_inner = 119,
  sym__call_or_atom = 120,
  sym_function_call_expr = 121,
  sym__function_call_target = 122,
  sym__atom = 123,
  sym_field_access_expr = 124,
  sym__field_access_start = 125,
  sym__field_access_segment = 126,
  sym_negate_expr = 127,
  sym_parenthesized_expr = 128,
  sym__literal_expr_group = 129,
  sym_char_constant_expr = 130,
  sym_number_constant_expr = 131,
  sym_string_constant_expr = 132,
  sym_anonymous_function_expr = 133,
  sym_value_expr = 134,
  sym_unit_expr = 135,
  sym_list_expr = 136,
  sym_record_expr = 137,
  sym_record_base_identifier = 138,
  sym__record_base = 139,
  sym__record_inner = 140,
  sym_field = 141,
  sym_if_else_expr = 142,
  sym__if = 143,
  sym__then = 144,
  sym__else = 145,
  sym_when_is_expr = 146,
  sym__more_when_is_branches = 147,
  sym_when_is_branch = 148,
  sym_let_in_expr = 149,
  sym__inner_declaration = 150,
  sym_pattern = 151,
  sym_cons_pattern = 152,
  sym__single_pattern_cons = 153,
  sym__single_pattern = 154,
  sym_lower_pattern = 155,
  sym_anything_pattern = 156,
  sym_record_pattern = 157,
  sym_list_pattern = 158,
  sym_union_pattern = 159,
  sym_nullary_constructor_argument_pattern = 160,
  sym__union_argument_pattern = 161,
  sym__parenthesized_pattern = 162,
  sym_infix_declaration = 163,
  sym_operator_identifier = 164,
  aux_sym_exposing_list_repeat1 = 165,
  aux_sym_upper_case_qid_repeat1 = 166,
  aux_sym_value_qid_repeat1 = 167,
  aux_sym_function_declaration_left_repeat1 = 168,
  aux_sym_type_declaration_repeat1 = 169,
  aux_sym_type_declaration_repeat2 = 170,
  aux_sym_union_variant_repeat1 = 171,
  aux_sym_type_expression_repeat1 = 172,
  aux_sym_type_ref_repeat1 = 173,
  aux_sym_record_type_repeat1 = 174,
  aux_sym_bin_op_expr_repeat1 = 175,
  aux_sym_function_call_expr_repeat1 = 176,
  aux_sym_field_access_expr_repeat1 = 177,
  aux_sym_string_constant_expr_repeat1 = 178,
  aux_sym_string_constant_expr_repeat2 = 179,
  aux_sym_anonymous_function_expr_repeat1 = 180,
  aux_sym_list_expr_repeat1 = 181,
  aux_sym__record_inner_repeat1 = 182,
  aux_sym_if_else_expr_repeat1 = 183,
  aux_sym__more_when_is_branches_repeat1 = 184,
  aux_sym_let_in_expr_repeat1 = 185,
  aux_sym_record_pattern_repeat1 = 186,
  aux_sym_list_pattern_repeat1 = 187,
  aux_sym_union_pattern_repeat1 = 188,
  alias_sym_close_char = 189,
  alias_sym_close_quote = 190,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_lower_case_identifier] = "lower_case_identifier",
  [anon_sym_LBRACE_DASH] = "{-",
  [anon_sym_DASH_RBRACE] = "-}",
  [sym_line_comment] = "line_comment",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [sym__upper_case_identifier_without_leading_whitespace] = "upper_case_identifier",
  [sym__lower_case_identifier_without_leading_whitespace] = "lower_case_identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SQUOTE] = "open_char",
  [aux_sym_char_constant_expr_token1] = "regular_string_part",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "open_quote",
  [aux_sym_string_constant_expr_token1] = "regular_string_part",
  [anon_sym_DQUOTE] = "open_quote",
  [aux_sym_string_constant_expr_token2] = "regular_string_part",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_left] = "lower_case_identifier",
  [anon_sym_right] = "lower_case_identifier",
  [anon_sym_non] = "lower_case_identifier",
  [sym_upper_case_identifier] = "upper_case_identifier",
  [sym_number_literal] = "number_literal",
  [sym_string_escape] = "string_escape",
  [sym_invalid_string_escape] = "invalid_string_escape",
  [sym_module] = "module",
  [sym_effect] = "effect",
  [sym_where] = "where",
  [sym_import] = "import",
  [sym_as] = "as",
  [sym_exposing] = "exposing",
  [sym_when] = "when",
  [sym_is] = "is",
  [sym_type] = "type",
  [sym_alias] = "alias",
  [sym_port] = "port",
  [sym_infix] = "infix",
  [sym_double_dot] = "double_dot",
  [sym_eq] = "eq",
  [sym_arrow] = "arrow",
  [sym_colon] = "colon",
  [sym_backslash] = "backslash",
  [sym_underscore] = "underscore",
  [sym_dot] = "dot",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_LT_PIPE] = "<|",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LT_SLASH_GT] = "</>",
  [anon_sym_LT_QMARK_GT] = "<\?>",
  [anon_sym_PIPE_DOT] = "|.",
  [anon_sym_PIPE_EQ] = "|=",
  [sym__virtual_end_decl] = "_virtual_end_decl",
  [sym__virtual_open_section] = "_virtual_open_section",
  [sym__virtual_end_section] = "_virtual_end_section",
  [sym_minus_without_trailing_whitespace] = "operator_identifier",
  [sym__block_comment_content] = "_block_comment_content",
  [sym_file] = "file",
  [sym_block_comment] = "block_comment",
  [sym_module_declaration] = "module_declaration",
  [aux_sym__import_list] = "_import_list",
  [aux_sym__top_decl_list] = "_top_decl_list",
  [sym_exposing_list] = "exposing_list",
  [sym_exposed_value] = "exposed_value",
  [sym_exposed_type] = "exposed_type",
  [sym_exposed_union_constructors] = "exposed_union_constructors",
  [sym_exposed_operator] = "exposed_operator",
  [sym__dot_without_leading_whitespace] = "dot",
  [sym_upper_case_qid] = "upper_case_qid",
  [sym_value_qid] = "value_qid",
  [sym_field_accessor_function_expr] = "field_accessor_function_expr",
  [sym_import_clause] = "import_clause",
  [sym_as_clause] = "as_clause",
  [sym_value_declaration] = "value_declaration",
  [sym_function_declaration_left] = "function_declaration_left",
  [sym_type_declaration] = "type_declaration",
  [sym_lower_type_name] = "lower_type_name",
  [sym_union_variant] = "union_variant",
  [sym__more_union_variants] = "_more_union_variants",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_type_expression] = "type_expression",
  [sym__type_expression_inner] = "_type_expression_inner",
  [sym_type_ref] = "type_ref",
  [sym__single_type_expression] = "_single_type_expression",
  [sym_type_ref_without_args] = "type_ref",
  [sym_type_variable] = "type_variable",
  [sym_record_type] = "record_type",
  [sym_field_type] = "field_type",
  [sym_type_annotation] = "type_annotation",
  [sym_port_annotation] = "port_annotation",
  [sym__expression] = "_expression",
  [sym_bin_op_expr] = "bin_op_expr",
  [sym_operator] = "operator",
  [sym_operator_as_function_expr] = "operator_as_function_expr",
  [sym__operator_as_function_inner] = "_operator_as_function_inner",
  [sym__call_or_atom] = "_call_or_atom",
  [sym_function_call_expr] = "function_call_expr",
  [sym__function_call_target] = "_function_call_target",
  [sym__atom] = "_atom",
  [sym_field_access_expr] = "field_access_expr",
  [sym__field_access_start] = "_field_access_start",
  [sym__field_access_segment] = "_field_access_segment",
  [sym_negate_expr] = "negate_expr",
  [sym_parenthesized_expr] = "parenthesized_expr",
  [sym__literal_expr_group] = "_literal_expr_group",
  [sym_char_constant_expr] = "char_constant_expr",
  [sym_number_constant_expr] = "number_constant_expr",
  [sym_string_constant_expr] = "string_constant_expr",
  [sym_anonymous_function_expr] = "anonymous_function_expr",
  [sym_value_expr] = "value_expr",
  [sym_unit_expr] = "unit_expr",
  [sym_list_expr] = "list_expr",
  [sym_record_expr] = "record_expr",
  [sym_record_base_identifier] = "record_base_identifier",
  [sym__record_base] = "_record_base",
  [sym__record_inner] = "_record_inner",
  [sym_field] = "field",
  [sym_if_else_expr] = "if_else_expr",
  [sym__if] = "_if",
  [sym__then] = "_then",
  [sym__else] = "_else",
  [sym_when_is_expr] = "when_is_expr",
  [sym__more_when_is_branches] = "_more_when_is_branches",
  [sym_when_is_branch] = "when_is_branch",
  [sym_let_in_expr] = "let_in_expr",
  [sym__inner_declaration] = "_inner_declaration",
  [sym_pattern] = "pattern",
  [sym_cons_pattern] = "cons_pattern",
  [sym__single_pattern_cons] = "_single_pattern_cons",
  [sym__single_pattern] = "_single_pattern",
  [sym_lower_pattern] = "lower_pattern",
  [sym_anything_pattern] = "anything_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym_nullary_constructor_argument_pattern] = "nullary_constructor_argument_pattern",
  [sym__union_argument_pattern] = "_union_argument_pattern",
  [sym__parenthesized_pattern] = "_parenthesized_pattern",
  [sym_infix_declaration] = "infix_declaration",
  [sym_operator_identifier] = "operator_identifier",
  [aux_sym_exposing_list_repeat1] = "exposing_list_repeat1",
  [aux_sym_upper_case_qid_repeat1] = "upper_case_qid_repeat1",
  [aux_sym_value_qid_repeat1] = "value_qid_repeat1",
  [aux_sym_function_declaration_left_repeat1] = "function_declaration_left_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_type_declaration_repeat2] = "type_declaration_repeat2",
  [aux_sym_union_variant_repeat1] = "union_variant_repeat1",
  [aux_sym_type_expression_repeat1] = "type_expression_repeat1",
  [aux_sym_type_ref_repeat1] = "type_ref_repeat1",
  [aux_sym_record_type_repeat1] = "record_type_repeat1",
  [aux_sym_bin_op_expr_repeat1] = "bin_op_expr_repeat1",
  [aux_sym_function_call_expr_repeat1] = "function_call_expr_repeat1",
  [aux_sym_field_access_expr_repeat1] = "field_access_expr_repeat1",
  [aux_sym_string_constant_expr_repeat1] = "string_constant_expr_repeat1",
  [aux_sym_string_constant_expr_repeat2] = "string_constant_expr_repeat2",
  [aux_sym_anonymous_function_expr_repeat1] = "anonymous_function_expr_repeat1",
  [aux_sym_list_expr_repeat1] = "list_expr_repeat1",
  [aux_sym__record_inner_repeat1] = "_record_inner_repeat1",
  [aux_sym_if_else_expr_repeat1] = "if_else_expr_repeat1",
  [aux_sym__more_when_is_branches_repeat1] = "_more_when_is_branches_repeat1",
  [aux_sym_let_in_expr_repeat1] = "let_in_expr_repeat1",
  [aux_sym_record_pattern_repeat1] = "record_pattern_repeat1",
  [aux_sym_list_pattern_repeat1] = "list_pattern_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [alias_sym_close_char] = "close_char",
  [alias_sym_close_quote] = "close_quote",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_lower_case_identifier] = sym_lower_case_identifier,
  [anon_sym_LBRACE_DASH] = anon_sym_LBRACE_DASH,
  [anon_sym_DASH_RBRACE] = anon_sym_DASH_RBRACE,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym__upper_case_identifier_without_leading_whitespace] = sym_upper_case_identifier,
  [sym__lower_case_identifier_without_leading_whitespace] = sym_lower_case_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_constant_expr_token1] = aux_sym_char_constant_expr_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym_string_constant_expr_token1] = aux_sym_char_constant_expr_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym_string_constant_expr_token2] = aux_sym_char_constant_expr_token1,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_left] = sym_lower_case_identifier,
  [anon_sym_right] = sym_lower_case_identifier,
  [anon_sym_non] = sym_lower_case_identifier,
  [sym_upper_case_identifier] = sym_upper_case_identifier,
  [sym_number_literal] = sym_number_literal,
  [sym_string_escape] = sym_string_escape,
  [sym_invalid_string_escape] = sym_invalid_string_escape,
  [sym_module] = sym_module,
  [sym_effect] = sym_effect,
  [sym_where] = sym_where,
  [sym_import] = sym_import,
  [sym_as] = sym_as,
  [sym_exposing] = sym_exposing,
  [sym_when] = sym_when,
  [sym_is] = sym_is,
  [sym_type] = sym_type,
  [sym_alias] = sym_alias,
  [sym_port] = sym_port,
  [sym_infix] = sym_infix,
  [sym_double_dot] = sym_double_dot,
  [sym_eq] = sym_eq,
  [sym_arrow] = sym_arrow,
  [sym_colon] = sym_colon,
  [sym_backslash] = sym_backslash,
  [sym_underscore] = sym_underscore,
  [sym_dot] = sym_dot,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_LT_PIPE] = anon_sym_LT_PIPE,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LT_SLASH_GT] = anon_sym_LT_SLASH_GT,
  [anon_sym_LT_QMARK_GT] = anon_sym_LT_QMARK_GT,
  [anon_sym_PIPE_DOT] = anon_sym_PIPE_DOT,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [sym__virtual_end_decl] = sym__virtual_end_decl,
  [sym__virtual_open_section] = sym__virtual_open_section,
  [sym__virtual_end_section] = sym__virtual_end_section,
  [sym_minus_without_trailing_whitespace] = sym_operator_identifier,
  [sym__block_comment_content] = sym__block_comment_content,
  [sym_file] = sym_file,
  [sym_block_comment] = sym_block_comment,
  [sym_module_declaration] = sym_module_declaration,
  [aux_sym__import_list] = aux_sym__import_list,
  [aux_sym__top_decl_list] = aux_sym__top_decl_list,
  [sym_exposing_list] = sym_exposing_list,
  [sym_exposed_value] = sym_exposed_value,
  [sym_exposed_type] = sym_exposed_type,
  [sym_exposed_union_constructors] = sym_exposed_union_constructors,
  [sym_exposed_operator] = sym_exposed_operator,
  [sym__dot_without_leading_whitespace] = sym_dot,
  [sym_upper_case_qid] = sym_upper_case_qid,
  [sym_value_qid] = sym_value_qid,
  [sym_field_accessor_function_expr] = sym_field_accessor_function_expr,
  [sym_import_clause] = sym_import_clause,
  [sym_as_clause] = sym_as_clause,
  [sym_value_declaration] = sym_value_declaration,
  [sym_function_declaration_left] = sym_function_declaration_left,
  [sym_type_declaration] = sym_type_declaration,
  [sym_lower_type_name] = sym_lower_type_name,
  [sym_union_variant] = sym_union_variant,
  [sym__more_union_variants] = sym__more_union_variants,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_type_expression] = sym_type_expression,
  [sym__type_expression_inner] = sym__type_expression_inner,
  [sym_type_ref] = sym_type_ref,
  [sym__single_type_expression] = sym__single_type_expression,
  [sym_type_ref_without_args] = sym_type_ref,
  [sym_type_variable] = sym_type_variable,
  [sym_record_type] = sym_record_type,
  [sym_field_type] = sym_field_type,
  [sym_type_annotation] = sym_type_annotation,
  [sym_port_annotation] = sym_port_annotation,
  [sym__expression] = sym__expression,
  [sym_bin_op_expr] = sym_bin_op_expr,
  [sym_operator] = sym_operator,
  [sym_operator_as_function_expr] = sym_operator_as_function_expr,
  [sym__operator_as_function_inner] = sym__operator_as_function_inner,
  [sym__call_or_atom] = sym__call_or_atom,
  [sym_function_call_expr] = sym_function_call_expr,
  [sym__function_call_target] = sym__function_call_target,
  [sym__atom] = sym__atom,
  [sym_field_access_expr] = sym_field_access_expr,
  [sym__field_access_start] = sym__field_access_start,
  [sym__field_access_segment] = sym__field_access_segment,
  [sym_negate_expr] = sym_negate_expr,
  [sym_parenthesized_expr] = sym_parenthesized_expr,
  [sym__literal_expr_group] = sym__literal_expr_group,
  [sym_char_constant_expr] = sym_char_constant_expr,
  [sym_number_constant_expr] = sym_number_constant_expr,
  [sym_string_constant_expr] = sym_string_constant_expr,
  [sym_anonymous_function_expr] = sym_anonymous_function_expr,
  [sym_value_expr] = sym_value_expr,
  [sym_unit_expr] = sym_unit_expr,
  [sym_list_expr] = sym_list_expr,
  [sym_record_expr] = sym_record_expr,
  [sym_record_base_identifier] = sym_record_base_identifier,
  [sym__record_base] = sym__record_base,
  [sym__record_inner] = sym__record_inner,
  [sym_field] = sym_field,
  [sym_if_else_expr] = sym_if_else_expr,
  [sym__if] = sym__if,
  [sym__then] = sym__then,
  [sym__else] = sym__else,
  [sym_when_is_expr] = sym_when_is_expr,
  [sym__more_when_is_branches] = sym__more_when_is_branches,
  [sym_when_is_branch] = sym_when_is_branch,
  [sym_let_in_expr] = sym_let_in_expr,
  [sym__inner_declaration] = sym__inner_declaration,
  [sym_pattern] = sym_pattern,
  [sym_cons_pattern] = sym_cons_pattern,
  [sym__single_pattern_cons] = sym__single_pattern_cons,
  [sym__single_pattern] = sym__single_pattern,
  [sym_lower_pattern] = sym_lower_pattern,
  [sym_anything_pattern] = sym_anything_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym_nullary_constructor_argument_pattern] = sym_nullary_constructor_argument_pattern,
  [sym__union_argument_pattern] = sym__union_argument_pattern,
  [sym__parenthesized_pattern] = sym__parenthesized_pattern,
  [sym_infix_declaration] = sym_infix_declaration,
  [sym_operator_identifier] = sym_operator_identifier,
  [aux_sym_exposing_list_repeat1] = aux_sym_exposing_list_repeat1,
  [aux_sym_upper_case_qid_repeat1] = aux_sym_upper_case_qid_repeat1,
  [aux_sym_value_qid_repeat1] = aux_sym_value_qid_repeat1,
  [aux_sym_function_declaration_left_repeat1] = aux_sym_function_declaration_left_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_type_declaration_repeat2] = aux_sym_type_declaration_repeat2,
  [aux_sym_union_variant_repeat1] = aux_sym_union_variant_repeat1,
  [aux_sym_type_expression_repeat1] = aux_sym_type_expression_repeat1,
  [aux_sym_type_ref_repeat1] = aux_sym_type_ref_repeat1,
  [aux_sym_record_type_repeat1] = aux_sym_record_type_repeat1,
  [aux_sym_bin_op_expr_repeat1] = aux_sym_bin_op_expr_repeat1,
  [aux_sym_function_call_expr_repeat1] = aux_sym_function_call_expr_repeat1,
  [aux_sym_field_access_expr_repeat1] = aux_sym_field_access_expr_repeat1,
  [aux_sym_string_constant_expr_repeat1] = aux_sym_string_constant_expr_repeat1,
  [aux_sym_string_constant_expr_repeat2] = aux_sym_string_constant_expr_repeat2,
  [aux_sym_anonymous_function_expr_repeat1] = aux_sym_anonymous_function_expr_repeat1,
  [aux_sym_list_expr_repeat1] = aux_sym_list_expr_repeat1,
  [aux_sym__record_inner_repeat1] = aux_sym__record_inner_repeat1,
  [aux_sym_if_else_expr_repeat1] = aux_sym_if_else_expr_repeat1,
  [aux_sym__more_when_is_branches_repeat1] = aux_sym__more_when_is_branches_repeat1,
  [aux_sym_let_in_expr_repeat1] = aux_sym_let_in_expr_repeat1,
  [aux_sym_record_pattern_repeat1] = aux_sym_record_pattern_repeat1,
  [aux_sym_list_pattern_repeat1] = aux_sym_list_pattern_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [alias_sym_close_char] = alias_sym_close_char,
  [alias_sym_close_quote] = alias_sym_close_quote,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_lower_case_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__upper_case_identifier_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym__lower_case_identifier_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_char_constant_expr_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_constant_expr_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_constant_expr_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_left] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_right] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_non] = {
    .visible = true,
    .named = true,
  },
  [sym_upper_case_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_invalid_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_effect] = {
    .visible = true,
    .named = true,
  },
  [sym_where] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_as] = {
    .visible = true,
    .named = true,
  },
  [sym_exposing] = {
    .visible = true,
    .named = true,
  },
  [sym_when] = {
    .visible = true,
    .named = true,
  },
  [sym_is] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_port] = {
    .visible = true,
    .named = true,
  },
  [sym_infix] = {
    .visible = true,
    .named = true,
  },
  [sym_double_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym__virtual_end_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_open_section] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_end_section] = {
    .visible = false,
    .named = true,
  },
  [sym_minus_without_trailing_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym__block_comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__import_list] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__top_decl_list] = {
    .visible = false,
    .named = false,
  },
  [sym_exposing_list] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_value] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_type] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_union_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__dot_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym_upper_case_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_value_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_field_accessor_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_as_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_value_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration_left] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lower_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_union_variant] = {
    .visible = true,
    .named = true,
  },
  [sym__more_union_variants] = {
    .visible = false,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expression_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_type_ref] = {
    .visible = true,
    .named = true,
  },
  [sym__single_type_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_type_ref_without_args] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_port_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_bin_op_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_as_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__operator_as_function_inner] = {
    .visible = false,
    .named = true,
  },
  [sym__call_or_atom] = {
    .visible = false,
    .named = true,
  },
  [sym_function_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__function_call_target] = {
    .visible = false,
    .named = true,
  },
  [sym__atom] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__field_access_start] = {
    .visible = false,
    .named = true,
  },
  [sym__field_access_segment] = {
    .visible = false,
    .named = true,
  },
  [sym_negate_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_expr_group] = {
    .visible = false,
    .named = true,
  },
  [sym_char_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_number_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_string_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_value_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_list_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_record_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_record_base_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__record_base] = {
    .visible = false,
    .named = true,
  },
  [sym__record_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_if_else_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__if] = {
    .visible = false,
    .named = true,
  },
  [sym__then] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym_when_is_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__more_when_is_branches] = {
    .visible = false,
    .named = true,
  },
  [sym_when_is_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__inner_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_cons_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__single_pattern_cons] = {
    .visible = false,
    .named = true,
  },
  [sym__single_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_lower_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_anything_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nullary_constructor_argument_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__union_argument_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__parenthesized_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_infix_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_exposing_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_upper_case_qid_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_qid_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declaration_left_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_variant_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_ref_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bin_op_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_call_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_access_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_constant_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_constant_expr_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__record_inner_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_else_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__more_when_is_branches_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_close_char] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_close_quote] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_arg = 1,
  field_argPattern = 2,
  field_asClause = 3,
  field_associativity = 4,
  field_baseRecord = 5,
  field_body = 6,
  field_branch = 7,
  field_child = 8,
  field_constructor = 9,
  field_doubleDot = 10,
  field_exposing = 11,
  field_expr = 12,
  field_exprList = 13,
  field_expression = 14,
  field_field = 15,
  field_fieldType = 16,
  field_functionDeclarationLeft = 17,
  field_moduleDeclaration = 18,
  field_moduleName = 19,
  field_name = 20,
  field_operator = 21,
  field_param = 22,
  field_part = 23,
  field_pattern = 24,
  field_patternAs = 25,
  field_patternList = 26,
  field_precedence = 27,
  field_target = 28,
  field_typeExpression = 29,
  field_typeName = 30,
  field_typeVariable = 31,
  field_unionVariant = 32,
  field_valueDeclaration = 33,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_argPattern] = "argPattern",
  [field_asClause] = "asClause",
  [field_associativity] = "associativity",
  [field_baseRecord] = "baseRecord",
  [field_body] = "body",
  [field_branch] = "branch",
  [field_child] = "child",
  [field_constructor] = "constructor",
  [field_doubleDot] = "doubleDot",
  [field_exposing] = "exposing",
  [field_expr] = "expr",
  [field_exprList] = "exprList",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_fieldType] = "fieldType",
  [field_functionDeclarationLeft] = "functionDeclarationLeft",
  [field_moduleDeclaration] = "moduleDeclaration",
  [field_moduleName] = "moduleName",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_param] = "param",
  [field_part] = "part",
  [field_pattern] = "pattern",
  [field_patternAs] = "patternAs",
  [field_patternList] = "patternList",
  [field_precedence] = "precedence",
  [field_target] = "target",
  [field_typeExpression] = "typeExpression",
  [field_typeName] = "typeName",
  [field_typeVariable] = "typeVariable",
  [field_unionVariant] = "unionVariant",
  [field_valueDeclaration] = "valueDeclaration",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 1},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 1},
  [13] = {.index = 10, .length = 1},
  [14] = {.index = 11, .length = 2},
  [15] = {.index = 13, .length = 1},
  [16] = {.index = 14, .length = 1},
  [17] = {.index = 15, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 1},
  [21] = {.index = 22, .length = 2},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 2},
  [31] = {.index = 41, .length = 1},
  [32] = {.index = 42, .length = 1},
  [33] = {.index = 43, .length = 3},
  [34] = {.index = 46, .length = 2},
  [35] = {.index = 48, .length = 2},
  [36] = {.index = 50, .length = 2},
  [37] = {.index = 52, .length = 1},
  [38] = {.index = 53, .length = 1},
  [39] = {.index = 54, .length = 2},
  [40] = {.index = 56, .length = 2},
  [41] = {.index = 58, .length = 1},
  [42] = {.index = 59, .length = 1},
  [43] = {.index = 60, .length = 1},
  [44] = {.index = 61, .length = 2},
  [45] = {.index = 63, .length = 1},
  [46] = {.index = 64, .length = 3},
  [47] = {.index = 67, .length = 3},
  [48] = {.index = 70, .length = 2},
  [49] = {.index = 72, .length = 1},
  [50] = {.index = 73, .length = 1},
  [51] = {.index = 74, .length = 2},
  [52] = {.index = 76, .length = 2},
  [53] = {.index = 78, .length = 2},
  [54] = {.index = 80, .length = 1},
  [55] = {.index = 81, .length = 3},
  [56] = {.index = 84, .length = 2},
  [57] = {.index = 86, .length = 2},
  [58] = {.index = 88, .length = 2},
  [59] = {.index = 90, .length = 1},
  [60] = {.index = 91, .length = 2},
  [61] = {.index = 93, .length = 1},
  [62] = {.index = 94, .length = 2},
  [63] = {.index = 96, .length = 4},
  [64] = {.index = 100, .length = 3},
  [65] = {.index = 103, .length = 3},
  [66] = {.index = 106, .length = 2},
  [67] = {.index = 108, .length = 3},
  [68] = {.index = 111, .length = 1},
  [69] = {.index = 112, .length = 2},
  [70] = {.index = 114, .length = 2},
  [71] = {.index = 116, .length = 2},
  [72] = {.index = 118, .length = 2},
  [73] = {.index = 120, .length = 4},
  [74] = {.index = 124, .length = 3},
  [75] = {.index = 127, .length = 1},
  [76] = {.index = 128, .length = 2},
  [77] = {.index = 130, .length = 2},
  [78] = {.index = 132, .length = 2},
  [79] = {.index = 134, .length = 2},
  [80] = {.index = 136, .length = 1},
  [81] = {.index = 137, .length = 2},
  [82] = {.index = 139, .length = 3},
  [83] = {.index = 142, .length = 1},
  [84] = {.index = 143, .length = 3},
  [85] = {.index = 146, .length = 2},
  [86] = {.index = 148, .length = 2},
  [87] = {.index = 150, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_constructor, 0},
  [1] =
    {field_child, 0},
  [2] =
    {field_child, 0, .inherited = true},
  [3] =
    {field_pattern, 1},
  [4] =
    {field_moduleName, 1},
  [5] =
    {field_moduleDeclaration, 0},
  [6] =
    {field_argPattern, 1},
    {field_constructor, 0},
  [8] =
    {field_child, 1},
  [9] =
    {field_patternList, 1},
  [10] =
    {field_part, 1},
  [11] =
    {field_name, 0},
    {field_typeExpression, 2},
  [13] =
    {field_part, 0, .inherited = true},
  [14] =
    {field_part, 0},
  [15] =
    {field_exposing, 2},
    {field_name, 1},
  [17] =
    {field_exposing, 2},
    {field_moduleName, 1},
  [19] =
    {field_asClause, 2},
    {field_moduleName, 1},
  [21] =
    {field_name, 0},
  [22] =
    {field_body, 2},
    {field_functionDeclarationLeft, 0},
  [24] =
    {field_operator, 0, .inherited = true},
  [25] =
    {field_body, 2},
    {field_pattern, 0},
  [27] =
    {field_child, 0},
    {field_patternAs, 2},
  [29] =
    {field_part, 0},
    {field_part, 2},
  [31] =
    {field_child, 0, .inherited = true},
    {field_patternAs, 2},
  [33] =
    {field_patternList, 1},
    {field_patternList, 2, .inherited = true},
  [35] =
    {field_patternList, 0, .inherited = true},
    {field_patternList, 1, .inherited = true},
  [37] =
    {field_part, 1},
    {field_part, 2, .inherited = true},
  [39] =
    {field_part, 0, .inherited = true},
    {field_part, 1, .inherited = true},
  [41] =
    {field_part, 1, .inherited = true},
  [42] =
    {field_name, 1},
  [43] =
    {field_asClause, 2},
    {field_exposing, 3},
    {field_moduleName, 1},
  [46] =
    {field_name, 1},
    {field_unionVariant, 3},
  [48] =
    {field_name, 1},
    {field_typeExpression, 3},
  [50] =
    {field_exposing, 3},
    {field_name, 2},
  [52] =
    {field_field, 0},
  [53] =
    {field_exprList, 1},
  [54] =
    {field_part, 0},
    {field_part, 1},
  [56] =
    {field_arg, 1},
    {field_target, 0},
  [58] =
    {field_target, 0},
  [59] =
    {field_fieldType, 1},
  [60] =
    {field_baseRecord, 0},
  [61] =
    {field_name, 0},
    {field_part, 1, .inherited = true},
  [63] =
    {field_unionVariant, 0, .inherited = true},
  [64] =
    {field_name, 1},
    {field_unionVariant, 3},
    {field_unionVariant, 4, .inherited = true},
  [67] =
    {field_name, 1},
    {field_typeName, 2},
    {field_unionVariant, 4},
  [70] =
    {field_name, 2},
    {field_typeExpression, 4},
  [72] =
    {field_expression, 1},
  [73] =
    {field_operator, 1},
  [74] =
    {field_baseRecord, 0, .inherited = true},
    {field_field, 1},
  [76] =
    {field_baseRecord, 1, .inherited = true},
    {field_field, 1, .inherited = true},
  [78] =
    {field_field, 0},
    {field_field, 1, .inherited = true},
  [80] =
    {field_valueDeclaration, 0},
  [81] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
  [84] =
    {field_fieldType, 1},
    {field_fieldType, 2, .inherited = true},
  [86] =
    {field_fieldType, 0, .inherited = true},
    {field_fieldType, 1, .inherited = true},
  [88] =
    {field_baseRecord, 1, .inherited = true},
    {field_fieldType, 2},
  [90] =
    {field_doubleDot, 2},
  [91] =
    {field_exposing, 5},
    {field_name, 2},
  [93] =
    {field_unionVariant, 1},
  [94] =
    {field_unionVariant, 0, .inherited = true},
    {field_unionVariant, 1, .inherited = true},
  [96] =
    {field_name, 1},
    {field_typeName, 2},
    {field_unionVariant, 4},
    {field_unionVariant, 5, .inherited = true},
  [100] =
    {field_name, 2},
    {field_typeExpression, 5},
    {field_typeVariable, 3},
  [103] =
    {field_associativity, 1},
    {field_operator, 3, .inherited = true},
    {field_precedence, 2},
  [106] =
    {field_expression, 2},
    {field_name, 0},
  [108] =
    {field_baseRecord, 0, .inherited = true},
    {field_field, 1},
    {field_field, 2, .inherited = true},
  [111] =
    {field_field, 1},
  [112] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [114] =
    {field_exprList, 1},
    {field_exprList, 2, .inherited = true},
  [116] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
  [118] =
    {field_expr, 3},
    {field_param, 1},
  [120] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
    {field_exprList, 3, .inherited = true},
  [124] =
    {field_baseRecord, 1, .inherited = true},
    {field_fieldType, 2},
    {field_fieldType, 3, .inherited = true},
  [127] =
    {field_valueDeclaration, 1, .inherited = true},
  [128] =
    {field_valueDeclaration, 0, .inherited = true},
    {field_valueDeclaration, 1, .inherited = true},
  [130] =
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
  [132] =
    {field_body, 5},
    {field_valueDeclaration, 2, .inherited = true},
  [134] =
    {field_branch, 4},
    {field_expr, 1},
  [136] =
    {field_branch, 0, .inherited = true},
  [137] =
    {field_branch, 5},
    {field_expr, 2},
  [139] =
    {field_body, 6},
    {field_valueDeclaration, 2, .inherited = true},
    {field_valueDeclaration, 3, .inherited = true},
  [142] =
    {field_branch, 1},
  [143] =
    {field_branch, 4},
    {field_branch, 5, .inherited = true},
    {field_expr, 1},
  [146] =
    {field_branch, 0, .inherited = true},
    {field_branch, 1, .inherited = true},
  [148] =
    {field_expr, 2},
    {field_pattern, 0},
  [150] =
    {field_branch, 5},
    {field_branch, 6, .inherited = true},
    {field_expr, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [1] = alias_sym_close_quote,
  },
  [11] = {
    [2] = alias_sym_close_char,
  },
  [12] = {
    [2] = alias_sym_close_quote,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 5,
  [7] = 5,
  [8] = 5,
  [9] = 5,
  [10] = 5,
  [11] = 5,
  [12] = 5,
  [13] = 5,
  [14] = 4,
  [15] = 2,
  [16] = 2,
  [17] = 2,
  [18] = 4,
  [19] = 2,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 34,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 42,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 20,
  [66] = 66,
  [67] = 67,
  [68] = 21,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 23,
  [77] = 24,
  [78] = 22,
  [79] = 25,
  [80] = 27,
  [81] = 26,
  [82] = 20,
  [83] = 83,
  [84] = 83,
  [85] = 83,
  [86] = 83,
  [87] = 83,
  [88] = 83,
  [89] = 28,
  [90] = 21,
  [91] = 91,
  [92] = 92,
  [93] = 34,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 35,
  [98] = 40,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 36,
  [103] = 37,
  [104] = 39,
  [105] = 105,
  [106] = 41,
  [107] = 31,
  [108] = 108,
  [109] = 34,
  [110] = 29,
  [111] = 30,
  [112] = 112,
  [113] = 113,
  [114] = 32,
  [115] = 24,
  [116] = 116,
  [117] = 33,
  [118] = 25,
  [119] = 91,
  [120] = 95,
  [121] = 101,
  [122] = 105,
  [123] = 108,
  [124] = 112,
  [125] = 101,
  [126] = 105,
  [127] = 108,
  [128] = 112,
  [129] = 22,
  [130] = 101,
  [131] = 105,
  [132] = 108,
  [133] = 112,
  [134] = 101,
  [135] = 91,
  [136] = 101,
  [137] = 105,
  [138] = 108,
  [139] = 112,
  [140] = 27,
  [141] = 105,
  [142] = 108,
  [143] = 112,
  [144] = 23,
  [145] = 26,
  [146] = 91,
  [147] = 92,
  [148] = 92,
  [149] = 92,
  [150] = 91,
  [151] = 92,
  [152] = 91,
  [153] = 92,
  [154] = 94,
  [155] = 46,
  [156] = 51,
  [157] = 52,
  [158] = 53,
  [159] = 54,
  [160] = 55,
  [161] = 56,
  [162] = 74,
  [163] = 57,
  [164] = 60,
  [165] = 62,
  [166] = 63,
  [167] = 67,
  [168] = 69,
  [169] = 42,
  [170] = 59,
  [171] = 75,
  [172] = 61,
  [173] = 42,
  [174] = 70,
  [175] = 72,
  [176] = 71,
  [177] = 28,
  [178] = 73,
  [179] = 64,
  [180] = 43,
  [181] = 66,
  [182] = 44,
  [183] = 45,
  [184] = 47,
  [185] = 48,
  [186] = 49,
  [187] = 50,
  [188] = 36,
  [189] = 189,
  [190] = 31,
  [191] = 189,
  [192] = 32,
  [193] = 34,
  [194] = 194,
  [195] = 41,
  [196] = 29,
  [197] = 39,
  [198] = 40,
  [199] = 35,
  [200] = 33,
  [201] = 189,
  [202] = 202,
  [203] = 34,
  [204] = 189,
  [205] = 189,
  [206] = 189,
  [207] = 207,
  [208] = 30,
  [209] = 37,
  [210] = 48,
  [211] = 60,
  [212] = 62,
  [213] = 63,
  [214] = 67,
  [215] = 69,
  [216] = 70,
  [217] = 71,
  [218] = 73,
  [219] = 43,
  [220] = 42,
  [221] = 75,
  [222] = 44,
  [223] = 45,
  [224] = 46,
  [225] = 47,
  [226] = 49,
  [227] = 50,
  [228] = 51,
  [229] = 52,
  [230] = 53,
  [231] = 54,
  [232] = 55,
  [233] = 56,
  [234] = 42,
  [235] = 59,
  [236] = 61,
  [237] = 66,
  [238] = 64,
  [239] = 72,
  [240] = 74,
  [241] = 57,
  [242] = 242,
  [243] = 242,
  [244] = 242,
  [245] = 242,
  [246] = 242,
  [247] = 242,
  [248] = 248,
  [249] = 248,
  [250] = 248,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 248,
  [256] = 248,
  [257] = 257,
  [258] = 248,
  [259] = 23,
  [260] = 24,
  [261] = 23,
  [262] = 21,
  [263] = 20,
  [264] = 24,
  [265] = 23,
  [266] = 24,
  [267] = 26,
  [268] = 22,
  [269] = 25,
  [270] = 27,
  [271] = 33,
  [272] = 33,
  [273] = 30,
  [274] = 28,
  [275] = 32,
  [276] = 41,
  [277] = 74,
  [278] = 35,
  [279] = 33,
  [280] = 40,
  [281] = 36,
  [282] = 37,
  [283] = 39,
  [284] = 29,
  [285] = 31,
  [286] = 51,
  [287] = 47,
  [288] = 63,
  [289] = 48,
  [290] = 67,
  [291] = 69,
  [292] = 49,
  [293] = 75,
  [294] = 50,
  [295] = 64,
  [296] = 296,
  [297] = 44,
  [298] = 20,
  [299] = 299,
  [300] = 59,
  [301] = 52,
  [302] = 21,
  [303] = 61,
  [304] = 53,
  [305] = 54,
  [306] = 70,
  [307] = 57,
  [308] = 55,
  [309] = 60,
  [310] = 71,
  [311] = 66,
  [312] = 73,
  [313] = 56,
  [314] = 314,
  [315] = 45,
  [316] = 62,
  [317] = 46,
  [318] = 43,
  [319] = 319,
  [320] = 22,
  [321] = 321,
  [322] = 25,
  [323] = 26,
  [324] = 319,
  [325] = 319,
  [326] = 319,
  [327] = 319,
  [328] = 319,
  [329] = 27,
  [330] = 21,
  [331] = 20,
  [332] = 28,
  [333] = 30,
  [334] = 31,
  [335] = 25,
  [336] = 32,
  [337] = 337,
  [338] = 337,
  [339] = 339,
  [340] = 26,
  [341] = 22,
  [342] = 337,
  [343] = 337,
  [344] = 337,
  [345] = 36,
  [346] = 27,
  [347] = 29,
  [348] = 37,
  [349] = 39,
  [350] = 41,
  [351] = 337,
  [352] = 35,
  [353] = 40,
  [354] = 52,
  [355] = 355,
  [356] = 57,
  [357] = 60,
  [358] = 62,
  [359] = 63,
  [360] = 67,
  [361] = 69,
  [362] = 362,
  [363] = 70,
  [364] = 71,
  [365] = 73,
  [366] = 43,
  [367] = 44,
  [368] = 45,
  [369] = 46,
  [370] = 47,
  [371] = 48,
  [372] = 49,
  [373] = 50,
  [374] = 51,
  [375] = 375,
  [376] = 53,
  [377] = 54,
  [378] = 55,
  [379] = 56,
  [380] = 59,
  [381] = 75,
  [382] = 382,
  [383] = 383,
  [384] = 64,
  [385] = 61,
  [386] = 74,
  [387] = 387,
  [388] = 314,
  [389] = 296,
  [390] = 390,
  [391] = 355,
  [392] = 382,
  [393] = 383,
  [394] = 355,
  [395] = 382,
  [396] = 383,
  [397] = 355,
  [398] = 382,
  [399] = 383,
  [400] = 355,
  [401] = 382,
  [402] = 383,
  [403] = 382,
  [404] = 383,
  [405] = 355,
  [406] = 28,
  [407] = 66,
  [408] = 39,
  [409] = 29,
  [410] = 35,
  [411] = 411,
  [412] = 40,
  [413] = 31,
  [414] = 36,
  [415] = 41,
  [416] = 32,
  [417] = 37,
  [418] = 30,
  [419] = 64,
  [420] = 66,
  [421] = 60,
  [422] = 62,
  [423] = 63,
  [424] = 73,
  [425] = 67,
  [426] = 69,
  [427] = 74,
  [428] = 428,
  [429] = 428,
  [430] = 430,
  [431] = 51,
  [432] = 70,
  [433] = 75,
  [434] = 428,
  [435] = 430,
  [436] = 428,
  [437] = 430,
  [438] = 52,
  [439] = 428,
  [440] = 430,
  [441] = 441,
  [442] = 428,
  [443] = 430,
  [444] = 44,
  [445] = 61,
  [446] = 53,
  [447] = 54,
  [448] = 45,
  [449] = 59,
  [450] = 46,
  [451] = 47,
  [452] = 48,
  [453] = 430,
  [454] = 49,
  [455] = 43,
  [456] = 71,
  [457] = 55,
  [458] = 56,
  [459] = 57,
  [460] = 50,
  [461] = 461,
  [462] = 461,
  [463] = 463,
  [464] = 463,
  [465] = 23,
  [466] = 24,
  [467] = 467,
  [468] = 468,
  [469] = 33,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 57,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 63,
  [485] = 67,
  [486] = 60,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 62,
  [491] = 69,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 503,
  [505] = 501,
  [506] = 500,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 503,
  [512] = 508,
  [513] = 513,
  [514] = 514,
  [515] = 508,
  [516] = 501,
  [517] = 517,
  [518] = 508,
  [519] = 500,
  [520] = 510,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 524,
  [526] = 524,
  [527] = 527,
  [528] = 467,
  [529] = 467,
  [530] = 530,
  [531] = 23,
  [532] = 467,
  [533] = 24,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 540,
  [546] = 534,
  [547] = 539,
  [548] = 535,
  [549] = 549,
  [550] = 541,
  [551] = 33,
  [552] = 507,
  [553] = 543,
  [554] = 536,
  [555] = 537,
  [556] = 544,
  [557] = 538,
  [558] = 540,
  [559] = 559,
  [560] = 536,
  [561] = 544,
  [562] = 562,
  [563] = 536,
  [564] = 537,
  [565] = 565,
  [566] = 543,
  [567] = 544,
  [568] = 565,
  [569] = 535,
  [570] = 540,
  [571] = 565,
  [572] = 537,
  [573] = 539,
  [574] = 565,
  [575] = 535,
  [576] = 538,
  [577] = 543,
  [578] = 565,
  [579] = 565,
  [580] = 534,
  [581] = 538,
  [582] = 541,
  [583] = 534,
  [584] = 541,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 586,
  [591] = 585,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 586,
  [597] = 585,
  [598] = 592,
  [599] = 593,
  [600] = 594,
  [601] = 595,
  [602] = 586,
  [603] = 585,
  [604] = 592,
  [605] = 593,
  [606] = 594,
  [607] = 607,
  [608] = 595,
  [609] = 586,
  [610] = 585,
  [611] = 592,
  [612] = 593,
  [613] = 595,
  [614] = 586,
  [615] = 585,
  [616] = 592,
  [617] = 593,
  [618] = 595,
  [619] = 586,
  [620] = 585,
  [621] = 592,
  [622] = 593,
  [623] = 592,
  [624] = 624,
  [625] = 625,
  [626] = 593,
  [627] = 627,
  [628] = 594,
  [629] = 595,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 627,
  [635] = 632,
  [636] = 636,
  [637] = 630,
  [638] = 607,
  [639] = 587,
  [640] = 640,
  [641] = 632,
  [642] = 630,
  [643] = 632,
  [644] = 630,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 632,
  [654] = 654,
  [655] = 632,
  [656] = 656,
  [657] = 630,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 630,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 652,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 663,
  [675] = 675,
  [676] = 676,
  [677] = 669,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 664,
  [684] = 666,
  [685] = 678,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 664,
  [690] = 679,
  [691] = 664,
  [692] = 587,
  [693] = 673,
  [694] = 663,
  [695] = 675,
  [696] = 696,
  [697] = 669,
  [698] = 678,
  [699] = 679,
  [700] = 680,
  [701] = 681,
  [702] = 666,
  [703] = 686,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 664,
  [708] = 686,
  [709] = 627,
  [710] = 673,
  [711] = 663,
  [712] = 675,
  [713] = 669,
  [714] = 678,
  [715] = 679,
  [716] = 680,
  [717] = 681,
  [718] = 666,
  [719] = 686,
  [720] = 720,
  [721] = 721,
  [722] = 664,
  [723] = 723,
  [724] = 724,
  [725] = 663,
  [726] = 675,
  [727] = 669,
  [728] = 680,
  [729] = 681,
  [730] = 686,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 673,
  [736] = 663,
  [737] = 675,
  [738] = 669,
  [739] = 680,
  [740] = 681,
  [741] = 680,
  [742] = 686,
  [743] = 675,
  [744] = 658,
  [745] = 659,
  [746] = 720,
  [747] = 747,
  [748] = 681,
  [749] = 607,
  [750] = 747,
  [751] = 682,
  [752] = 720,
  [753] = 747,
  [754] = 682,
  [755] = 720,
  [756] = 747,
  [757] = 682,
  [758] = 720,
  [759] = 759,
  [760] = 747,
  [761] = 682,
  [762] = 720,
  [763] = 720,
  [764] = 747,
  [765] = 682,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 772,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 772,
  [779] = 779,
  [780] = 780,
  [781] = 768,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 658,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 772,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 652,
  [802] = 784,
  [803] = 794,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 784,
  [813] = 794,
  [814] = 814,
  [815] = 659,
  [816] = 816,
  [817] = 768,
  [818] = 818,
  [819] = 819,
  [820] = 784,
  [821] = 794,
  [822] = 822,
  [823] = 823,
  [824] = 768,
  [825] = 825,
  [826] = 772,
  [827] = 827,
  [828] = 784,
  [829] = 829,
  [830] = 830,
  [831] = 768,
  [832] = 832,
  [833] = 784,
  [834] = 768,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 772,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 849,
  [855] = 855,
  [856] = 849,
  [857] = 857,
  [858] = 852,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 860,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 857,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 863,
  [873] = 869,
  [874] = 874,
  [875] = 874,
  [876] = 860,
  [877] = 847,
  [878] = 878,
  [879] = 879,
  [880] = 865,
  [881] = 881,
  [882] = 865,
  [883] = 883,
  [884] = 849,
  [885] = 885,
  [886] = 860,
  [887] = 847,
  [888] = 870,
  [889] = 889,
  [890] = 860,
  [891] = 857,
  [892] = 865,
  [893] = 865,
  [894] = 865,
  [895] = 863,
  [896] = 869,
  [897] = 897,
  [898] = 898,
  [899] = 878,
  [900] = 900,
  [901] = 901,
  [902] = 874,
  [903] = 903,
  [904] = 841,
  [905] = 847,
  [906] = 851,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 852,
  [912] = 870,
  [913] = 913,
  [914] = 818,
  [915] = 857,
  [916] = 845,
  [917] = 851,
  [918] = 852,
  [919] = 919,
  [920] = 863,
  [921] = 869,
  [922] = 849,
  [923] = 874,
  [924] = 898,
  [925] = 925,
  [926] = 897,
  [927] = 860,
  [928] = 849,
  [929] = 929,
  [930] = 851,
  [931] = 931,
  [932] = 932,
  [933] = 847,
  [934] = 934,
  [935] = 835,
  [936] = 851,
  [937] = 937,
  [938] = 860,
  [939] = 870,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 865,
  [944] = 944,
  [945] = 852,
  [946] = 870,
  [947] = 851,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 908,
  [952] = 919,
  [953] = 870,
  [954] = 954,
  [955] = 908,
  [956] = 919,
  [957] = 957,
  [958] = 908,
  [959] = 919,
  [960] = 497,
  [961] = 908,
  [962] = 919,
  [963] = 908,
  [964] = 919,
  [965] = 845,
  [966] = 863,
  [967] = 889,
  [968] = 940,
  [969] = 969,
  [970] = 889,
  [971] = 940,
  [972] = 845,
  [973] = 889,
  [974] = 940,
  [975] = 845,
  [976] = 889,
  [977] = 940,
  [978] = 889,
  [979] = 940,
  [980] = 845,
  [981] = 863,
  [982] = 869,
  [983] = 869,
  [984] = 984,
  [985] = 874,
  [986] = 852,
  [987] = 874,
  [988] = 988,
  [989] = 989,
  [990] = 865,
  [991] = 847,
  [992] = 992,
};

static TSCharacterRange sym__upper_case_identifier_without_leading_whitespace_character_set_1[] = {
  {'A', 'Z'}, {0xc0, 0xd6}, {0xd8, 0xde}, {0x100, 0x100}, {0x102, 0x102}, {0x104, 0x104}, {0x106, 0x106}, {0x108, 0x108},
  {0x10a, 0x10a}, {0x10c, 0x10c}, {0x10e, 0x10e}, {0x110, 0x110}, {0x112, 0x112}, {0x114, 0x114}, {0x116, 0x116}, {0x118, 0x118},
  {0x11a, 0x11a}, {0x11c, 0x11c}, {0x11e, 0x11e}, {0x120, 0x120}, {0x122, 0x122}, {0x124, 0x124}, {0x126, 0x126}, {0x128, 0x128},
  {0x12a, 0x12a}, {0x12c, 0x12c}, {0x12e, 0x12e}, {0x130, 0x130}, {0x132, 0x132}, {0x134, 0x134}, {0x136, 0x136}, {0x139, 0x139},
  {0x13b, 0x13b}, {0x13d, 0x13d}, {0x13f, 0x13f}, {0x141, 0x141}, {0x143, 0x143}, {0x145, 0x145}, {0x147, 0x147}, {0x14a, 0x14a},
  {0x14c, 0x14c}, {0x14e, 0x14e}, {0x150, 0x150}, {0x152, 0x152}, {0x154, 0x154}, {0x156, 0x156}, {0x158, 0x158}, {0x15a, 0x15a},
  {0x15c, 0x15c}, {0x15e, 0x15e}, {0x160, 0x160}, {0x162, 0x162}, {0x164, 0x164}, {0x166, 0x166}, {0x168, 0x168}, {0x16a, 0x16a},
  {0x16c, 0x16c}, {0x16e, 0x16e}, {0x170, 0x170}, {0x172, 0x172}, {0x174, 0x174}, {0x176, 0x176}, {0x178, 0x179}, {0x17b, 0x17b},
  {0x17d, 0x17d}, {0x181, 0x182}, {0x184, 0x184}, {0x186, 0x187}, {0x189, 0x18b}, {0x18e, 0x191}, {0x193, 0x194}, {0x196, 0x198},
  {0x19c, 0x19d}, {0x19f, 0x1a0}, {0x1a2, 0x1a2}, {0x1a4, 0x1a4}, {0x1a6, 0x1a7}, {0x1a9, 0x1a9}, {0x1ac, 0x1ac}, {0x1ae, 0x1af},
  {0x1b1, 0x1b3}, {0x1b5, 0x1b5}, {0x1b7, 0x1b8}, {0x1bc, 0x1bc}, {0x1c4, 0x1c4}, {0x1c7, 0x1c7}, {0x1ca, 0x1ca}, {0x1cd, 0x1cd},
  {0x1cf, 0x1cf}, {0x1d1, 0x1d1}, {0x1d3, 0x1d3}, {0x1d5, 0x1d5}, {0x1d7, 0x1d7}, {0x1d9, 0x1d9}, {0x1db, 0x1db}, {0x1de, 0x1de},
  {0x1e0, 0x1e0}, {0x1e2, 0x1e2}, {0x1e4, 0x1e4}, {0x1e6, 0x1e6}, {0x1e8, 0x1e8}, {0x1ea, 0x1ea}, {0x1ec, 0x1ec}, {0x1ee, 0x1ee},
  {0x1f1, 0x1f1}, {0x1f4, 0x1f4}, {0x1f6, 0x1f8}, {0x1fa, 0x1fa}, {0x1fc, 0x1fc}, {0x1fe, 0x1fe}, {0x200, 0x200}, {0x202, 0x202},
  {0x204, 0x204}, {0x206, 0x206}, {0x208, 0x208}, {0x20a, 0x20a}, {0x20c, 0x20c}, {0x20e, 0x20e}, {0x210, 0x210}, {0x212, 0x212},
  {0x214, 0x214}, {0x216, 0x216}, {0x218, 0x218}, {0x21a, 0x21a}, {0x21c, 0x21c}, {0x21e, 0x21e}, {0x220, 0x220}, {0x222, 0x222},
  {0x224, 0x224}, {0x226, 0x226}, {0x228, 0x228}, {0x22a, 0x22a}, {0x22c, 0x22c}, {0x22e, 0x22e}, {0x230, 0x230}, {0x232, 0x232},
  {0x23a, 0x23b}, {0x23d, 0x23e}, {0x241, 0x241}, {0x243, 0x246}, {0x248, 0x248}, {0x24a, 0x24a}, {0x24c, 0x24c}, {0x24e, 0x24e},
  {0x370, 0x370}, {0x372, 0x372}, {0x376, 0x376}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x38f},
  {0x391, 0x3a1}, {0x3a3, 0x3ab}, {0x3cf, 0x3cf}, {0x3d2, 0x3d4}, {0x3d8, 0x3d8}, {0x3da, 0x3da}, {0x3dc, 0x3dc}, {0x3de, 0x3de},
  {0x3e0, 0x3e0}, {0x3e2, 0x3e2}, {0x3e4, 0x3e4}, {0x3e6, 0x3e6}, {0x3e8, 0x3e8}, {0x3ea, 0x3ea}, {0x3ec, 0x3ec}, {0x3ee, 0x3ee},
  {0x3f4, 0x3f4}, {0x3f7, 0x3f7}, {0x3f9, 0x3fa}, {0x3fd, 0x42f}, {0x460, 0x460}, {0x462, 0x462}, {0x464, 0x464}, {0x466, 0x466},
  {0x468, 0x468}, {0x46a, 0x46a}, {0x46c, 0x46c}, {0x46e, 0x46e}, {0x470, 0x470}, {0x472, 0x472}, {0x474, 0x474}, {0x476, 0x476},
  {0x478, 0x478}, {0x47a, 0x47a}, {0x47c, 0x47c}, {0x47e, 0x47e}, {0x480, 0x480}, {0x48a, 0x48a}, {0x48c, 0x48c}, {0x48e, 0x48e},
  {0x490, 0x490}, {0x492, 0x492}, {0x494, 0x494}, {0x496, 0x496}, {0x498, 0x498}, {0x49a, 0x49a}, {0x49c, 0x49c}, {0x49e, 0x49e},
  {0x4a0, 0x4a0}, {0x4a2, 0x4a2}, {0x4a4, 0x4a4}, {0x4a6, 0x4a6}, {0x4a8, 0x4a8}, {0x4aa, 0x4aa}, {0x4ac, 0x4ac}, {0x4ae, 0x4ae},
  {0x4b0, 0x4b0}, {0x4b2, 0x4b2}, {0x4b4, 0x4b4}, {0x4b6, 0x4b6}, {0x4b8, 0x4b8}, {0x4ba, 0x4ba}, {0x4bc, 0x4bc}, {0x4be, 0x4be},
  {0x4c0, 0x4c1}, {0x4c3, 0x4c3}, {0x4c5, 0x4c5}, {0x4c7, 0x4c7}, {0x4c9, 0x4c9}, {0x4cb, 0x4cb}, {0x4cd, 0x4cd}, {0x4d0, 0x4d0},
  {0x4d2, 0x4d2}, {0x4d4, 0x4d4}, {0x4d6, 0x4d6}, {0x4d8, 0x4d8}, {0x4da, 0x4da}, {0x4dc, 0x4dc}, {0x4de, 0x4de}, {0x4e0, 0x4e0},
  {0x4e2, 0x4e2}, {0x4e4, 0x4e4}, {0x4e6, 0x4e6}, {0x4e8, 0x4e8}, {0x4ea, 0x4ea}, {0x4ec, 0x4ec}, {0x4ee, 0x4ee}, {0x4f0, 0x4f0},
  {0x4f2, 0x4f2}, {0x4f4, 0x4f4}, {0x4f6, 0x4f6}, {0x4f8, 0x4f8}, {0x4fa, 0x4fa}, {0x4fc, 0x4fc}, {0x4fe, 0x4fe}, {0x500, 0x500},
  {0x502, 0x502}, {0x504, 0x504}, {0x506, 0x506}, {0x508, 0x508}, {0x50a, 0x50a}, {0x50c, 0x50c}, {0x50e, 0x50e}, {0x510, 0x510},
  {0x512, 0x512}, {0x514, 0x514}, {0x516, 0x516}, {0x518, 0x518}, {0x51a, 0x51a}, {0x51c, 0x51c}, {0x51e, 0x51e}, {0x520, 0x520},
  {0x522, 0x522}, {0x524, 0x524}, {0x526, 0x526}, {0x528, 0x528}, {0x52a, 0x52a}, {0x52c, 0x52c}, {0x52e, 0x52e}, {0x531, 0x556},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1e00, 0x1e00}, {0x1e02, 0x1e02},
  {0x1e04, 0x1e04}, {0x1e06, 0x1e06}, {0x1e08, 0x1e08}, {0x1e0a, 0x1e0a}, {0x1e0c, 0x1e0c}, {0x1e0e, 0x1e0e}, {0x1e10, 0x1e10}, {0x1e12, 0x1e12},
  {0x1e14, 0x1e14}, {0x1e16, 0x1e16}, {0x1e18, 0x1e18}, {0x1e1a, 0x1e1a}, {0x1e1c, 0x1e1c}, {0x1e1e, 0x1e1e}, {0x1e20, 0x1e20}, {0x1e22, 0x1e22},
  {0x1e24, 0x1e24}, {0x1e26, 0x1e26}, {0x1e28, 0x1e28}, {0x1e2a, 0x1e2a}, {0x1e2c, 0x1e2c}, {0x1e2e, 0x1e2e}, {0x1e30, 0x1e30}, {0x1e32, 0x1e32},
  {0x1e34, 0x1e34}, {0x1e36, 0x1e36}, {0x1e38, 0x1e38}, {0x1e3a, 0x1e3a}, {0x1e3c, 0x1e3c}, {0x1e3e, 0x1e3e}, {0x1e40, 0x1e40}, {0x1e42, 0x1e42},
  {0x1e44, 0x1e44}, {0x1e46, 0x1e46}, {0x1e48, 0x1e48}, {0x1e4a, 0x1e4a}, {0x1e4c, 0x1e4c}, {0x1e4e, 0x1e4e}, {0x1e50, 0x1e50}, {0x1e52, 0x1e52},
  {0x1e54, 0x1e54}, {0x1e56, 0x1e56}, {0x1e58, 0x1e58}, {0x1e5a, 0x1e5a}, {0x1e5c, 0x1e5c}, {0x1e5e, 0x1e5e}, {0x1e60, 0x1e60}, {0x1e62, 0x1e62},
  {0x1e64, 0x1e64}, {0x1e66, 0x1e66}, {0x1e68, 0x1e68}, {0x1e6a, 0x1e6a}, {0x1e6c, 0x1e6c}, {0x1e6e, 0x1e6e}, {0x1e70, 0x1e70}, {0x1e72, 0x1e72},
  {0x1e74, 0x1e74}, {0x1e76, 0x1e76}, {0x1e78, 0x1e78}, {0x1e7a, 0x1e7a}, {0x1e7c, 0x1e7c}, {0x1e7e, 0x1e7e}, {0x1e80, 0x1e80}, {0x1e82, 0x1e82},
  {0x1e84, 0x1e84}, {0x1e86, 0x1e86}, {0x1e88, 0x1e88}, {0x1e8a, 0x1e8a}, {0x1e8c, 0x1e8c}, {0x1e8e, 0x1e8e}, {0x1e90, 0x1e90}, {0x1e92, 0x1e92},
  {0x1e94, 0x1e94}, {0x1e9e, 0x1e9e}, {0x1ea0, 0x1ea0}, {0x1ea2, 0x1ea2}, {0x1ea4, 0x1ea4}, {0x1ea6, 0x1ea6}, {0x1ea8, 0x1ea8}, {0x1eaa, 0x1eaa},
  {0x1eac, 0x1eac}, {0x1eae, 0x1eae}, {0x1eb0, 0x1eb0}, {0x1eb2, 0x1eb2}, {0x1eb4, 0x1eb4}, {0x1eb6, 0x1eb6}, {0x1eb8, 0x1eb8}, {0x1eba, 0x1eba},
  {0x1ebc, 0x1ebc}, {0x1ebe, 0x1ebe}, {0x1ec0, 0x1ec0}, {0x1ec2, 0x1ec2}, {0x1ec4, 0x1ec4}, {0x1ec6, 0x1ec6}, {0x1ec8, 0x1ec8}, {0x1eca, 0x1eca},
  {0x1ecc, 0x1ecc}, {0x1ece, 0x1ece}, {0x1ed0, 0x1ed0}, {0x1ed2, 0x1ed2}, {0x1ed4, 0x1ed4}, {0x1ed6, 0x1ed6}, {0x1ed8, 0x1ed8}, {0x1eda, 0x1eda},
  {0x1edc, 0x1edc}, {0x1ede, 0x1ede}, {0x1ee0, 0x1ee0}, {0x1ee2, 0x1ee2}, {0x1ee4, 0x1ee4}, {0x1ee6, 0x1ee6}, {0x1ee8, 0x1ee8}, {0x1eea, 0x1eea},
  {0x1eec, 0x1eec}, {0x1eee, 0x1eee}, {0x1ef0, 0x1ef0}, {0x1ef2, 0x1ef2}, {0x1ef4, 0x1ef4}, {0x1ef6, 0x1ef6}, {0x1ef8, 0x1ef8}, {0x1efa, 0x1efa},
  {0x1efc, 0x1efc}, {0x1efe, 0x1efe}, {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f5f}, {0x1f68, 0x1f6f}, {0x1fb8, 0x1fbb}, {0x1fc8, 0x1fcb}, {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec},
  {0x1ff8, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210b, 0x210d}, {0x2110, 0x2112}, {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124},
  {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x2130, 0x2133}, {0x213e, 0x213f}, {0x2145, 0x2145}, {0x2183, 0x2183}, {0x2c00, 0x2c2f},
  {0x2c60, 0x2c60}, {0x2c62, 0x2c64}, {0x2c67, 0x2c67}, {0x2c69, 0x2c69}, {0x2c6b, 0x2c6b}, {0x2c6d, 0x2c70}, {0x2c72, 0x2c72}, {0x2c75, 0x2c75},
  {0x2c7e, 0x2c80}, {0x2c82, 0x2c82}, {0x2c84, 0x2c84}, {0x2c86, 0x2c86}, {0x2c88, 0x2c88}, {0x2c8a, 0x2c8a}, {0x2c8c, 0x2c8c}, {0x2c8e, 0x2c8e},
  {0x2c90, 0x2c90}, {0x2c92, 0x2c92}, {0x2c94, 0x2c94}, {0x2c96, 0x2c96}, {0x2c98, 0x2c98}, {0x2c9a, 0x2c9a}, {0x2c9c, 0x2c9c}, {0x2c9e, 0x2c9e},
  {0x2ca0, 0x2ca0}, {0x2ca2, 0x2ca2}, {0x2ca4, 0x2ca4}, {0x2ca6, 0x2ca6}, {0x2ca8, 0x2ca8}, {0x2caa, 0x2caa}, {0x2cac, 0x2cac}, {0x2cae, 0x2cae},
  {0x2cb0, 0x2cb0}, {0x2cb2, 0x2cb2}, {0x2cb4, 0x2cb4}, {0x2cb6, 0x2cb6}, {0x2cb8, 0x2cb8}, {0x2cba, 0x2cba}, {0x2cbc, 0x2cbc}, {0x2cbe, 0x2cbe},
  {0x2cc0, 0x2cc0}, {0x2cc2, 0x2cc2}, {0x2cc4, 0x2cc4}, {0x2cc6, 0x2cc6}, {0x2cc8, 0x2cc8}, {0x2cca, 0x2cca}, {0x2ccc, 0x2ccc}, {0x2cce, 0x2cce},
  {0x2cd0, 0x2cd0}, {0x2cd2, 0x2cd2}, {0x2cd4, 0x2cd4}, {0x2cd6, 0x2cd6}, {0x2cd8, 0x2cd8}, {0x2cda, 0x2cda}, {0x2cdc, 0x2cdc}, {0x2cde, 0x2cde},
  {0x2ce0, 0x2ce0}, {0x2ce2, 0x2ce2}, {0x2ceb, 0x2ceb}, {0x2ced, 0x2ced}, {0x2cf2, 0x2cf2}, {0xa640, 0xa640}, {0xa642, 0xa642}, {0xa644, 0xa644},
  {0xa646, 0xa646}, {0xa648, 0xa648}, {0xa64a, 0xa64a}, {0xa64c, 0xa64c}, {0xa64e, 0xa64e}, {0xa650, 0xa650}, {0xa652, 0xa652}, {0xa654, 0xa654},
  {0xa656, 0xa656}, {0xa658, 0xa658}, {0xa65a, 0xa65a}, {0xa65c, 0xa65c}, {0xa65e, 0xa65e}, {0xa660, 0xa660}, {0xa662, 0xa662}, {0xa664, 0xa664},
  {0xa666, 0xa666}, {0xa668, 0xa668}, {0xa66a, 0xa66a}, {0xa66c, 0xa66c}, {0xa680, 0xa680}, {0xa682, 0xa682}, {0xa684, 0xa684}, {0xa686, 0xa686},
  {0xa688, 0xa688}, {0xa68a, 0xa68a}, {0xa68c, 0xa68c}, {0xa68e, 0xa68e}, {0xa690, 0xa690}, {0xa692, 0xa692}, {0xa694, 0xa694}, {0xa696, 0xa696},
  {0xa698, 0xa698}, {0xa69a, 0xa69a}, {0xa722, 0xa722}, {0xa724, 0xa724}, {0xa726, 0xa726}, {0xa728, 0xa728}, {0xa72a, 0xa72a}, {0xa72c, 0xa72c},
  {0xa72e, 0xa72e}, {0xa732, 0xa732}, {0xa734, 0xa734}, {0xa736, 0xa736}, {0xa738, 0xa738}, {0xa73a, 0xa73a}, {0xa73c, 0xa73c}, {0xa73e, 0xa73e},
  {0xa740, 0xa740}, {0xa742, 0xa742}, {0xa744, 0xa744}, {0xa746, 0xa746}, {0xa748, 0xa748}, {0xa74a, 0xa74a}, {0xa74c, 0xa74c}, {0xa74e, 0xa74e},
  {0xa750, 0xa750}, {0xa752, 0xa752}, {0xa754, 0xa754}, {0xa756, 0xa756}, {0xa758, 0xa758}, {0xa75a, 0xa75a}, {0xa75c, 0xa75c}, {0xa75e, 0xa75e},
  {0xa760, 0xa760}, {0xa762, 0xa762}, {0xa764, 0xa764}, {0xa766, 0xa766}, {0xa768, 0xa768}, {0xa76a, 0xa76a}, {0xa76c, 0xa76c}, {0xa76e, 0xa76e},
  {0xa779, 0xa779}, {0xa77b, 0xa77b}, {0xa77d, 0xa77e}, {0xa780, 0xa780}, {0xa782, 0xa782}, {0xa784, 0xa784}, {0xa786, 0xa786}, {0xa78b, 0xa78b},
  {0xa78d, 0xa78d}, {0xa790, 0xa790}, {0xa792, 0xa792}, {0xa796, 0xa796}, {0xa798, 0xa798}, {0xa79a, 0xa79a}, {0xa79c, 0xa79c}, {0xa79e, 0xa79e},
  {0xa7a0, 0xa7a0}, {0xa7a2, 0xa7a2}, {0xa7a4, 0xa7a4}, {0xa7a6, 0xa7a6}, {0xa7a8, 0xa7a8}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7b6, 0xa7b6},
  {0xa7b8, 0xa7b8}, {0xa7ba, 0xa7ba}, {0xa7bc, 0xa7bc}, {0xa7be, 0xa7be}, {0xa7c0, 0xa7c0}, {0xa7c2, 0xa7c2}, {0xa7c4, 0xa7c7}, {0xa7c9, 0xa7c9},
  {0xa7d0, 0xa7d0}, {0xa7d6, 0xa7d6}, {0xa7d8, 0xa7d8}, {0xa7f5, 0xa7f5}, {0xff21, 0xff3a}, {0x10400, 0x10427}, {0x104b0, 0x104d3}, {0x10570, 0x1057a},
  {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
};

static TSCharacterRange sym__upper_case_identifier_without_leading_whitespace_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6},
  {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377},
  {0x37a, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f},
  {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f},
  {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824},
  {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d},
  {0x950, 0x950}, {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2},
  {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a},
  {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e},
  {0xa72, 0xa74}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd},
  {0xad0, 0xad0}, {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33},
  {0xb35, 0xb39}, {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0},
  {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61},
  {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde},
  {0xce0, 0xce1}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56},
  {0xd5f, 0xd61}, {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30},
  {0xe32, 0xe33}, {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0},
  {0xeb2, 0xeb3}, {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c},
  {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070},
  {0x1075, 0x1081}, {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d},
  {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be},
  {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16f1, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731},
  {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x1884},
  {0x1887, 0x18a8}, {0x18aa, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9},
  {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5},
  {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3},
  {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f},
  {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126},
  {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2ce4},
  {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96},
  {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde},
  {0x2e2f, 0x2e2f}, {0x3005, 0x3006}, {0x3031, 0x3035}, {0x303b, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff},
  {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x3400}, {0x4dbf, 0x4dbf}, {0x4e00, 0x4e00}, {0x9fff, 0xa48c},
  {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6e5}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a},
  {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946},
  {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42},
  {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0},
  {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26},
  {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xac00}, {0xd7a3, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
  {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c},
  {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb},
  {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7},
  {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa},
  {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x10340}, {0x10342, 0x10349}, {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3},
  {0x103c8, 0x103cf}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a},
  {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755},
  {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838},
  {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915},
};

static TSCharacterRange sym__lower_case_identifier_without_leading_whitespace_character_set_1[] = {
  {'a', 'z'}, {0xb5, 0xb5}, {0xdf, 0xf6}, {0xf8, 0xff}, {0x101, 0x101}, {0x103, 0x103}, {0x105, 0x105}, {0x107, 0x107},
  {0x109, 0x109}, {0x10b, 0x10b}, {0x10d, 0x10d}, {0x10f, 0x10f}, {0x111, 0x111}, {0x113, 0x113}, {0x115, 0x115}, {0x117, 0x117},
  {0x119, 0x119}, {0x11b, 0x11b}, {0x11d, 0x11d}, {0x11f, 0x11f}, {0x121, 0x121}, {0x123, 0x123}, {0x125, 0x125}, {0x127, 0x127},
  {0x129, 0x129}, {0x12b, 0x12b}, {0x12d, 0x12d}, {0x12f, 0x12f}, {0x131, 0x131}, {0x133, 0x133}, {0x135, 0x135}, {0x137, 0x138},
  {0x13a, 0x13a}, {0x13c, 0x13c}, {0x13e, 0x13e}, {0x140, 0x140}, {0x142, 0x142}, {0x144, 0x144}, {0x146, 0x146}, {0x148, 0x149},
  {0x14b, 0x14b}, {0x14d, 0x14d}, {0x14f, 0x14f}, {0x151, 0x151}, {0x153, 0x153}, {0x155, 0x155}, {0x157, 0x157}, {0x159, 0x159},
  {0x15b, 0x15b}, {0x15d, 0x15d}, {0x15f, 0x15f}, {0x161, 0x161}, {0x163, 0x163}, {0x165, 0x165}, {0x167, 0x167}, {0x169, 0x169},
  {0x16b, 0x16b}, {0x16d, 0x16d}, {0x16f, 0x16f}, {0x171, 0x171}, {0x173, 0x173}, {0x175, 0x175}, {0x177, 0x177}, {0x17a, 0x17a},
  {0x17c, 0x17c}, {0x17e, 0x180}, {0x183, 0x183}, {0x185, 0x185}, {0x188, 0x188}, {0x18c, 0x18d}, {0x192, 0x192}, {0x195, 0x195},
  {0x199, 0x19b}, {0x19e, 0x19e}, {0x1a1, 0x1a1}, {0x1a3, 0x1a3}, {0x1a5, 0x1a5}, {0x1a8, 0x1a8}, {0x1aa, 0x1ab}, {0x1ad, 0x1ad},
  {0x1b0, 0x1b0}, {0x1b4, 0x1b4}, {0x1b6, 0x1b6}, {0x1b9, 0x1ba}, {0x1bd, 0x1bf}, {0x1c6, 0x1c6}, {0x1c9, 0x1c9}, {0x1cc, 0x1cc},
  {0x1ce, 0x1ce}, {0x1d0, 0x1d0}, {0x1d2, 0x1d2}, {0x1d4, 0x1d4}, {0x1d6, 0x1d6}, {0x1d8, 0x1d8}, {0x1da, 0x1da}, {0x1dc, 0x1dd},
  {0x1df, 0x1df}, {0x1e1, 0x1e1}, {0x1e3, 0x1e3}, {0x1e5, 0x1e5}, {0x1e7, 0x1e7}, {0x1e9, 0x1e9}, {0x1eb, 0x1eb}, {0x1ed, 0x1ed},
  {0x1ef, 0x1f0}, {0x1f3, 0x1f3}, {0x1f5, 0x1f5}, {0x1f9, 0x1f9}, {0x1fb, 0x1fb}, {0x1fd, 0x1fd}, {0x1ff, 0x1ff}, {0x201, 0x201},
  {0x203, 0x203}, {0x205, 0x205}, {0x207, 0x207}, {0x209, 0x209}, {0x20b, 0x20b}, {0x20d, 0x20d}, {0x20f, 0x20f}, {0x211, 0x211},
  {0x213, 0x213}, {0x215, 0x215}, {0x217, 0x217}, {0x219, 0x219}, {0x21b, 0x21b}, {0x21d, 0x21d}, {0x21f, 0x21f}, {0x221, 0x221},
  {0x223, 0x223}, {0x225, 0x225}, {0x227, 0x227}, {0x229, 0x229}, {0x22b, 0x22b}, {0x22d, 0x22d}, {0x22f, 0x22f}, {0x231, 0x231},
  {0x233, 0x239}, {0x23c, 0x23c}, {0x23f, 0x240}, {0x242, 0x242}, {0x247, 0x247}, {0x249, 0x249}, {0x24b, 0x24b}, {0x24d, 0x24d},
  {0x24f, 0x293}, {0x295, 0x2af}, {0x371, 0x371}, {0x373, 0x373}, {0x377, 0x377}, {0x37b, 0x37d}, {0x390, 0x390}, {0x3ac, 0x3ce},
  {0x3d0, 0x3d1}, {0x3d5, 0x3d7}, {0x3d9, 0x3d9}, {0x3db, 0x3db}, {0x3dd, 0x3dd}, {0x3df, 0x3df}, {0x3e1, 0x3e1}, {0x3e3, 0x3e3},
  {0x3e5, 0x3e5}, {0x3e7, 0x3e7}, {0x3e9, 0x3e9}, {0x3eb, 0x3eb}, {0x3ed, 0x3ed}, {0x3ef, 0x3f3}, {0x3f5, 0x3f5}, {0x3f8, 0x3f8},
  {0x3fb, 0x3fc}, {0x430, 0x45f}, {0x461, 0x461}, {0x463, 0x463}, {0x465, 0x465}, {0x467, 0x467}, {0x469, 0x469}, {0x46b, 0x46b},
  {0x46d, 0x46d}, {0x46f, 0x46f}, {0x471, 0x471}, {0x473, 0x473}, {0x475, 0x475}, {0x477, 0x477}, {0x479, 0x479}, {0x47b, 0x47b},
  {0x47d, 0x47d}, {0x47f, 0x47f}, {0x481, 0x481}, {0x48b, 0x48b}, {0x48d, 0x48d}, {0x48f, 0x48f}, {0x491, 0x491}, {0x493, 0x493},
  {0x495, 0x495}, {0x497, 0x497}, {0x499, 0x499}, {0x49b, 0x49b}, {0x49d, 0x49d}, {0x49f, 0x49f}, {0x4a1, 0x4a1}, {0x4a3, 0x4a3},
  {0x4a5, 0x4a5}, {0x4a7, 0x4a7}, {0x4a9, 0x4a9}, {0x4ab, 0x4ab}, {0x4ad, 0x4ad}, {0x4af, 0x4af}, {0x4b1, 0x4b1}, {0x4b3, 0x4b3},
  {0x4b5, 0x4b5}, {0x4b7, 0x4b7}, {0x4b9, 0x4b9}, {0x4bb, 0x4bb}, {0x4bd, 0x4bd}, {0x4bf, 0x4bf}, {0x4c2, 0x4c2}, {0x4c4, 0x4c4},
  {0x4c6, 0x4c6}, {0x4c8, 0x4c8}, {0x4ca, 0x4ca}, {0x4cc, 0x4cc}, {0x4ce, 0x4cf}, {0x4d1, 0x4d1}, {0x4d3, 0x4d3}, {0x4d5, 0x4d5},
  {0x4d7, 0x4d7}, {0x4d9, 0x4d9}, {0x4db, 0x4db}, {0x4dd, 0x4dd}, {0x4df, 0x4df}, {0x4e1, 0x4e1}, {0x4e3, 0x4e3}, {0x4e5, 0x4e5},
  {0x4e7, 0x4e7}, {0x4e9, 0x4e9}, {0x4eb, 0x4eb}, {0x4ed, 0x4ed}, {0x4ef, 0x4ef}, {0x4f1, 0x4f1}, {0x4f3, 0x4f3}, {0x4f5, 0x4f5},
  {0x4f7, 0x4f7}, {0x4f9, 0x4f9}, {0x4fb, 0x4fb}, {0x4fd, 0x4fd}, {0x4ff, 0x4ff}, {0x501, 0x501}, {0x503, 0x503}, {0x505, 0x505},
  {0x507, 0x507}, {0x509, 0x509}, {0x50b, 0x50b}, {0x50d, 0x50d}, {0x50f, 0x50f}, {0x511, 0x511}, {0x513, 0x513}, {0x515, 0x515},
  {0x517, 0x517}, {0x519, 0x519}, {0x51b, 0x51b}, {0x51d, 0x51d}, {0x51f, 0x51f}, {0x521, 0x521}, {0x523, 0x523}, {0x525, 0x525},
  {0x527, 0x527}, {0x529, 0x529}, {0x52b, 0x52b}, {0x52d, 0x52d}, {0x52f, 0x52f}, {0x560, 0x588}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff},
  {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e01, 0x1e01}, {0x1e03, 0x1e03}, {0x1e05, 0x1e05},
  {0x1e07, 0x1e07}, {0x1e09, 0x1e09}, {0x1e0b, 0x1e0b}, {0x1e0d, 0x1e0d}, {0x1e0f, 0x1e0f}, {0x1e11, 0x1e11}, {0x1e13, 0x1e13}, {0x1e15, 0x1e15},
  {0x1e17, 0x1e17}, {0x1e19, 0x1e19}, {0x1e1b, 0x1e1b}, {0x1e1d, 0x1e1d}, {0x1e1f, 0x1e1f}, {0x1e21, 0x1e21}, {0x1e23, 0x1e23}, {0x1e25, 0x1e25},
  {0x1e27, 0x1e27}, {0x1e29, 0x1e29}, {0x1e2b, 0x1e2b}, {0x1e2d, 0x1e2d}, {0x1e2f, 0x1e2f}, {0x1e31, 0x1e31}, {0x1e33, 0x1e33}, {0x1e35, 0x1e35},
  {0x1e37, 0x1e37}, {0x1e39, 0x1e39}, {0x1e3b, 0x1e3b}, {0x1e3d, 0x1e3d}, {0x1e3f, 0x1e3f}, {0x1e41, 0x1e41}, {0x1e43, 0x1e43}, {0x1e45, 0x1e45},
  {0x1e47, 0x1e47}, {0x1e49, 0x1e49}, {0x1e4b, 0x1e4b}, {0x1e4d, 0x1e4d}, {0x1e4f, 0x1e4f}, {0x1e51, 0x1e51}, {0x1e53, 0x1e53}, {0x1e55, 0x1e55},
  {0x1e57, 0x1e57}, {0x1e59, 0x1e59}, {0x1e5b, 0x1e5b}, {0x1e5d, 0x1e5d}, {0x1e5f, 0x1e5f}, {0x1e61, 0x1e61}, {0x1e63, 0x1e63}, {0x1e65, 0x1e65},
  {0x1e67, 0x1e67}, {0x1e69, 0x1e69}, {0x1e6b, 0x1e6b}, {0x1e6d, 0x1e6d}, {0x1e6f, 0x1e6f}, {0x1e71, 0x1e71}, {0x1e73, 0x1e73}, {0x1e75, 0x1e75},
  {0x1e77, 0x1e77}, {0x1e79, 0x1e79}, {0x1e7b, 0x1e7b}, {0x1e7d, 0x1e7d}, {0x1e7f, 0x1e7f}, {0x1e81, 0x1e81}, {0x1e83, 0x1e83}, {0x1e85, 0x1e85},
  {0x1e87, 0x1e87}, {0x1e89, 0x1e89}, {0x1e8b, 0x1e8b}, {0x1e8d, 0x1e8d}, {0x1e8f, 0x1e8f}, {0x1e91, 0x1e91}, {0x1e93, 0x1e93}, {0x1e95, 0x1e9d},
  {0x1e9f, 0x1e9f}, {0x1ea1, 0x1ea1}, {0x1ea3, 0x1ea3}, {0x1ea5, 0x1ea5}, {0x1ea7, 0x1ea7}, {0x1ea9, 0x1ea9}, {0x1eab, 0x1eab}, {0x1ead, 0x1ead},
  {0x1eaf, 0x1eaf}, {0x1eb1, 0x1eb1}, {0x1eb3, 0x1eb3}, {0x1eb5, 0x1eb5}, {0x1eb7, 0x1eb7}, {0x1eb9, 0x1eb9}, {0x1ebb, 0x1ebb}, {0x1ebd, 0x1ebd},
  {0x1ebf, 0x1ebf}, {0x1ec1, 0x1ec1}, {0x1ec3, 0x1ec3}, {0x1ec5, 0x1ec5}, {0x1ec7, 0x1ec7}, {0x1ec9, 0x1ec9}, {0x1ecb, 0x1ecb}, {0x1ecd, 0x1ecd},
  {0x1ecf, 0x1ecf}, {0x1ed1, 0x1ed1}, {0x1ed3, 0x1ed3}, {0x1ed5, 0x1ed5}, {0x1ed7, 0x1ed7}, {0x1ed9, 0x1ed9}, {0x1edb, 0x1edb}, {0x1edd, 0x1edd},
  {0x1edf, 0x1edf}, {0x1ee1, 0x1ee1}, {0x1ee3, 0x1ee3}, {0x1ee5, 0x1ee5}, {0x1ee7, 0x1ee7}, {0x1ee9, 0x1ee9}, {0x1eeb, 0x1eeb}, {0x1eed, 0x1eed},
  {0x1eef, 0x1eef}, {0x1ef1, 0x1ef1}, {0x1ef3, 0x1ef3}, {0x1ef5, 0x1ef5}, {0x1ef7, 0x1ef7}, {0x1ef9, 0x1ef9}, {0x1efb, 0x1efb}, {0x1efd, 0x1efd},
  {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, {0x1f70, 0x1f7d},
  {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ff7}, {0x210a, 0x210a}, {0x210e, 0x210f}, {0x2113, 0x2113},
  {0x212f, 0x212f}, {0x2134, 0x2134}, {0x2139, 0x2139}, {0x213c, 0x213d}, {0x2146, 0x2149}, {0x214e, 0x214e}, {0x2184, 0x2184}, {0x2c30, 0x2c5f},
  {0x2c61, 0x2c61}, {0x2c65, 0x2c66}, {0x2c68, 0x2c68}, {0x2c6a, 0x2c6a}, {0x2c6c, 0x2c6c}, {0x2c71, 0x2c71}, {0x2c73, 0x2c74}, {0x2c76, 0x2c7b},
  {0x2c81, 0x2c81}, {0x2c83, 0x2c83}, {0x2c85, 0x2c85}, {0x2c87, 0x2c87}, {0x2c89, 0x2c89}, {0x2c8b, 0x2c8b}, {0x2c8d, 0x2c8d}, {0x2c8f, 0x2c8f},
  {0x2c91, 0x2c91}, {0x2c93, 0x2c93}, {0x2c95, 0x2c95}, {0x2c97, 0x2c97}, {0x2c99, 0x2c99}, {0x2c9b, 0x2c9b}, {0x2c9d, 0x2c9d}, {0x2c9f, 0x2c9f},
  {0x2ca1, 0x2ca1}, {0x2ca3, 0x2ca3}, {0x2ca5, 0x2ca5}, {0x2ca7, 0x2ca7}, {0x2ca9, 0x2ca9}, {0x2cab, 0x2cab}, {0x2cad, 0x2cad}, {0x2caf, 0x2caf},
  {0x2cb1, 0x2cb1}, {0x2cb3, 0x2cb3}, {0x2cb5, 0x2cb5}, {0x2cb7, 0x2cb7}, {0x2cb9, 0x2cb9}, {0x2cbb, 0x2cbb}, {0x2cbd, 0x2cbd}, {0x2cbf, 0x2cbf},
  {0x2cc1, 0x2cc1}, {0x2cc3, 0x2cc3}, {0x2cc5, 0x2cc5}, {0x2cc7, 0x2cc7}, {0x2cc9, 0x2cc9}, {0x2ccb, 0x2ccb}, {0x2ccd, 0x2ccd}, {0x2ccf, 0x2ccf},
  {0x2cd1, 0x2cd1}, {0x2cd3, 0x2cd3}, {0x2cd5, 0x2cd5}, {0x2cd7, 0x2cd7}, {0x2cd9, 0x2cd9}, {0x2cdb, 0x2cdb}, {0x2cdd, 0x2cdd}, {0x2cdf, 0x2cdf},
  {0x2ce1, 0x2ce1}, {0x2ce3, 0x2ce4}, {0x2cec, 0x2cec}, {0x2cee, 0x2cee}, {0x2cf3, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d},
  {0xa641, 0xa641}, {0xa643, 0xa643}, {0xa645, 0xa645}, {0xa647, 0xa647}, {0xa649, 0xa649}, {0xa64b, 0xa64b}, {0xa64d, 0xa64d}, {0xa64f, 0xa64f},
  {0xa651, 0xa651}, {0xa653, 0xa653}, {0xa655, 0xa655}, {0xa657, 0xa657}, {0xa659, 0xa659}, {0xa65b, 0xa65b}, {0xa65d, 0xa65d}, {0xa65f, 0xa65f},
  {0xa661, 0xa661}, {0xa663, 0xa663}, {0xa665, 0xa665}, {0xa667, 0xa667}, {0xa669, 0xa669}, {0xa66b, 0xa66b}, {0xa66d, 0xa66d}, {0xa681, 0xa681},
  {0xa683, 0xa683}, {0xa685, 0xa685}, {0xa687, 0xa687}, {0xa689, 0xa689}, {0xa68b, 0xa68b}, {0xa68d, 0xa68d}, {0xa68f, 0xa68f}, {0xa691, 0xa691},
  {0xa693, 0xa693}, {0xa695, 0xa695}, {0xa697, 0xa697}, {0xa699, 0xa699}, {0xa69b, 0xa69b}, {0xa723, 0xa723}, {0xa725, 0xa725}, {0xa727, 0xa727},
  {0xa729, 0xa729}, {0xa72b, 0xa72b}, {0xa72d, 0xa72d}, {0xa72f, 0xa731}, {0xa733, 0xa733}, {0xa735, 0xa735}, {0xa737, 0xa737}, {0xa739, 0xa739},
  {0xa73b, 0xa73b}, {0xa73d, 0xa73d}, {0xa73f, 0xa73f}, {0xa741, 0xa741}, {0xa743, 0xa743}, {0xa745, 0xa745}, {0xa747, 0xa747}, {0xa749, 0xa749},
  {0xa74b, 0xa74b}, {0xa74d, 0xa74d}, {0xa74f, 0xa74f}, {0xa751, 0xa751}, {0xa753, 0xa753}, {0xa755, 0xa755}, {0xa757, 0xa757}, {0xa759, 0xa759},
  {0xa75b, 0xa75b}, {0xa75d, 0xa75d}, {0xa75f, 0xa75f}, {0xa761, 0xa761}, {0xa763, 0xa763}, {0xa765, 0xa765}, {0xa767, 0xa767}, {0xa769, 0xa769},
  {0xa76b, 0xa76b}, {0xa76d, 0xa76d}, {0xa76f, 0xa76f}, {0xa771, 0xa778}, {0xa77a, 0xa77a}, {0xa77c, 0xa77c}, {0xa77f, 0xa77f}, {0xa781, 0xa781},
  {0xa783, 0xa783}, {0xa785, 0xa785}, {0xa787, 0xa787}, {0xa78c, 0xa78c}, {0xa78e, 0xa78e}, {0xa791, 0xa791}, {0xa793, 0xa795}, {0xa797, 0xa797},
  {0xa799, 0xa799}, {0xa79b, 0xa79b}, {0xa79d, 0xa79d}, {0xa79f, 0xa79f}, {0xa7a1, 0xa7a1}, {0xa7a3, 0xa7a3}, {0xa7a5, 0xa7a5}, {0xa7a7, 0xa7a7},
  {0xa7a9, 0xa7a9}, {0xa7af, 0xa7af}, {0xa7b5, 0xa7b5}, {0xa7b7, 0xa7b7}, {0xa7b9, 0xa7b9}, {0xa7bb, 0xa7bb}, {0xa7bd, 0xa7bd}, {0xa7bf, 0xa7bf},
  {0xa7c1, 0xa7c1}, {0xa7c3, 0xa7c3}, {0xa7c8, 0xa7c8}, {0xa7ca, 0xa7ca}, {0xa7d1, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d5}, {0xa7d7, 0xa7d7},
  {0xa7d9, 0xa7d9}, {0xa7f6, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xab30, 0xab5a}, {0xab60, 0xab68}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xff41, 0xff5a}, {0x10428, 0x1044f}, {0x104d8, 0x104fb}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static TSCharacterRange sym_upper_case_identifier_character_set_1[] = {
  {'A', 'Z'}, {0xc0, 0xd6}, {0xd8, 0xde}, {0x100, 0x100}, {0x102, 0x102}, {0x104, 0x104}, {0x106, 0x106}, {0x108, 0x108},
  {0x10a, 0x10a}, {0x10c, 0x10c}, {0x10e, 0x10e}, {0x110, 0x110}, {0x112, 0x112}, {0x114, 0x114}, {0x116, 0x116}, {0x118, 0x118},
  {0x11a, 0x11a}, {0x11c, 0x11c}, {0x11e, 0x11e}, {0x120, 0x120}, {0x122, 0x122}, {0x124, 0x124}, {0x126, 0x126}, {0x128, 0x128},
  {0x12a, 0x12a}, {0x12c, 0x12c}, {0x12e, 0x12e}, {0x130, 0x130}, {0x132, 0x132}, {0x134, 0x134}, {0x136, 0x136}, {0x139, 0x139},
  {0x13b, 0x13b}, {0x13d, 0x13d}, {0x13f, 0x13f}, {0x141, 0x141}, {0x143, 0x143}, {0x145, 0x145}, {0x147, 0x147}, {0x14a, 0x14a},
  {0x14c, 0x14c}, {0x14e, 0x14e}, {0x150, 0x150}, {0x152, 0x152}, {0x154, 0x154}, {0x156, 0x156}, {0x158, 0x158}, {0x15a, 0x15a},
  {0x15c, 0x15c}, {0x15e, 0x15e}, {0x160, 0x160}, {0x162, 0x162}, {0x164, 0x164}, {0x166, 0x166}, {0x168, 0x168}, {0x16a, 0x16a},
  {0x16c, 0x16c}, {0x16e, 0x16e}, {0x170, 0x170}, {0x172, 0x172}, {0x174, 0x174}, {0x176, 0x176}, {0x178, 0x179}, {0x17b, 0x17b},
  {0x17d, 0x17d}, {0x181, 0x182}, {0x184, 0x184}, {0x186, 0x187}, {0x189, 0x18b}, {0x18e, 0x191}, {0x193, 0x194}, {0x196, 0x198},
  {0x19c, 0x19d}, {0x19f, 0x1a0}, {0x1a2, 0x1a2}, {0x1a4, 0x1a4}, {0x1a6, 0x1a7}, {0x1a9, 0x1a9}, {0x1ac, 0x1ac}, {0x1ae, 0x1af},
  {0x1b1, 0x1b3}, {0x1b5, 0x1b5}, {0x1b7, 0x1b8}, {0x1bc, 0x1bc}, {0x1c4, 0x1c4}, {0x1c7, 0x1c7}, {0x1ca, 0x1ca}, {0x1cd, 0x1cd},
  {0x1cf, 0x1cf}, {0x1d1, 0x1d1}, {0x1d3, 0x1d3}, {0x1d5, 0x1d5}, {0x1d7, 0x1d7}, {0x1d9, 0x1d9}, {0x1db, 0x1db}, {0x1de, 0x1de},
  {0x1e0, 0x1e0}, {0x1e2, 0x1e2}, {0x1e4, 0x1e4}, {0x1e6, 0x1e6}, {0x1e8, 0x1e8}, {0x1ea, 0x1ea}, {0x1ec, 0x1ec}, {0x1ee, 0x1ee},
  {0x1f1, 0x1f1}, {0x1f4, 0x1f4}, {0x1f6, 0x1f8}, {0x1fa, 0x1fa}, {0x1fc, 0x1fc}, {0x1fe, 0x1fe}, {0x200, 0x200}, {0x202, 0x202},
  {0x204, 0x204}, {0x206, 0x206}, {0x208, 0x208}, {0x20a, 0x20a}, {0x20c, 0x20c}, {0x20e, 0x20e}, {0x210, 0x210}, {0x212, 0x212},
  {0x214, 0x214}, {0x216, 0x216}, {0x218, 0x218}, {0x21a, 0x21a}, {0x21c, 0x21c}, {0x21e, 0x21e}, {0x220, 0x220}, {0x222, 0x222},
  {0x224, 0x224}, {0x226, 0x226}, {0x228, 0x228}, {0x22a, 0x22a}, {0x22c, 0x22c}, {0x22e, 0x22e}, {0x230, 0x230}, {0x232, 0x232},
  {0x23a, 0x23b}, {0x23d, 0x23e}, {0x241, 0x241}, {0x243, 0x246}, {0x248, 0x248}, {0x24a, 0x24a}, {0x24c, 0x24c}, {0x24e, 0x24e},
  {0x370, 0x370}, {0x372, 0x372}, {0x376, 0x376}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x38f},
  {0x391, 0x3a1}, {0x3a3, 0x3ab}, {0x3cf, 0x3cf}, {0x3d2, 0x3d4}, {0x3d8, 0x3d8}, {0x3da, 0x3da}, {0x3dc, 0x3dc}, {0x3de, 0x3de},
  {0x3e0, 0x3e0}, {0x3e2, 0x3e2}, {0x3e4, 0x3e4}, {0x3e6, 0x3e6}, {0x3e8, 0x3e8}, {0x3ea, 0x3ea}, {0x3ec, 0x3ec}, {0x3ee, 0x3ee},
  {0x3f4, 0x3f4}, {0x3f7, 0x3f7}, {0x3f9, 0x3fa}, {0x3fd, 0x42f}, {0x460, 0x460}, {0x462, 0x462}, {0x464, 0x464}, {0x466, 0x466},
  {0x468, 0x468}, {0x46a, 0x46a}, {0x46c, 0x46c}, {0x46e, 0x46e}, {0x470, 0x470}, {0x472, 0x472}, {0x474, 0x474}, {0x476, 0x476},
  {0x478, 0x478}, {0x47a, 0x47a}, {0x47c, 0x47c}, {0x47e, 0x47e}, {0x480, 0x480}, {0x48a, 0x48a}, {0x48c, 0x48c}, {0x48e, 0x48e},
  {0x490, 0x490}, {0x492, 0x492}, {0x494, 0x494}, {0x496, 0x496}, {0x498, 0x498}, {0x49a, 0x49a}, {0x49c, 0x49c}, {0x49e, 0x49e},
  {0x4a0, 0x4a0}, {0x4a2, 0x4a2}, {0x4a4, 0x4a4}, {0x4a6, 0x4a6}, {0x4a8, 0x4a8}, {0x4aa, 0x4aa}, {0x4ac, 0x4ac}, {0x4ae, 0x4ae},
  {0x4b0, 0x4b0}, {0x4b2, 0x4b2}, {0x4b4, 0x4b4}, {0x4b6, 0x4b6}, {0x4b8, 0x4b8}, {0x4ba, 0x4ba}, {0x4bc, 0x4bc}, {0x4be, 0x4be},
  {0x4c0, 0x4c1}, {0x4c3, 0x4c3}, {0x4c5, 0x4c5}, {0x4c7, 0x4c7}, {0x4c9, 0x4c9}, {0x4cb, 0x4cb}, {0x4cd, 0x4cd}, {0x4d0, 0x4d0},
  {0x4d2, 0x4d2}, {0x4d4, 0x4d4}, {0x4d6, 0x4d6}, {0x4d8, 0x4d8}, {0x4da, 0x4da}, {0x4dc, 0x4dc}, {0x4de, 0x4de}, {0x4e0, 0x4e0},
  {0x4e2, 0x4e2}, {0x4e4, 0x4e4}, {0x4e6, 0x4e6}, {0x4e8, 0x4e8}, {0x4ea, 0x4ea}, {0x4ec, 0x4ec}, {0x4ee, 0x4ee}, {0x4f0, 0x4f0},
  {0x4f2, 0x4f2}, {0x4f4, 0x4f4}, {0x4f6, 0x4f6}, {0x4f8, 0x4f8}, {0x4fa, 0x4fa}, {0x4fc, 0x4fc}, {0x4fe, 0x4fe}, {0x500, 0x500},
  {0x502, 0x502}, {0x504, 0x504}, {0x506, 0x506}, {0x508, 0x508}, {0x50a, 0x50a}, {0x50c, 0x50c}, {0x50e, 0x50e}, {0x510, 0x510},
  {0x512, 0x512}, {0x514, 0x514}, {0x516, 0x516}, {0x518, 0x518}, {0x51a, 0x51a}, {0x51c, 0x51c}, {0x51e, 0x51e}, {0x520, 0x520},
  {0x522, 0x522}, {0x524, 0x524}, {0x526, 0x526}, {0x528, 0x528}, {0x52a, 0x52a}, {0x52c, 0x52c}, {0x52e, 0x52e}, {0x531, 0x556},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1e00, 0x1e00}, {0x1e02, 0x1e02},
  {0x1e04, 0x1e04}, {0x1e06, 0x1e06}, {0x1e08, 0x1e08}, {0x1e0a, 0x1e0a}, {0x1e0c, 0x1e0c}, {0x1e0e, 0x1e0e}, {0x1e10, 0x1e10}, {0x1e12, 0x1e12},
  {0x1e14, 0x1e14}, {0x1e16, 0x1e16}, {0x1e18, 0x1e18}, {0x1e1a, 0x1e1a}, {0x1e1c, 0x1e1c}, {0x1e1e, 0x1e1e}, {0x1e20, 0x1e20}, {0x1e22, 0x1e22},
  {0x1e24, 0x1e24}, {0x1e26, 0x1e26}, {0x1e28, 0x1e28}, {0x1e2a, 0x1e2a}, {0x1e2c, 0x1e2c}, {0x1e2e, 0x1e2e}, {0x1e30, 0x1e30}, {0x1e32, 0x1e32},
  {0x1e34, 0x1e34}, {0x1e36, 0x1e36}, {0x1e38, 0x1e38}, {0x1e3a, 0x1e3a}, {0x1e3c, 0x1e3c}, {0x1e3e, 0x1e3e}, {0x1e40, 0x1e40}, {0x1e42, 0x1e42},
  {0x1e44, 0x1e44}, {0x1e46, 0x1e46}, {0x1e48, 0x1e48}, {0x1e4a, 0x1e4a}, {0x1e4c, 0x1e4c}, {0x1e4e, 0x1e4e}, {0x1e50, 0x1e50}, {0x1e52, 0x1e52},
  {0x1e54, 0x1e54}, {0x1e56, 0x1e56}, {0x1e58, 0x1e58}, {0x1e5a, 0x1e5a}, {0x1e5c, 0x1e5c}, {0x1e5e, 0x1e5e}, {0x1e60, 0x1e60}, {0x1e62, 0x1e62},
  {0x1e64, 0x1e64}, {0x1e66, 0x1e66}, {0x1e68, 0x1e68}, {0x1e6a, 0x1e6a}, {0x1e6c, 0x1e6c}, {0x1e6e, 0x1e6e}, {0x1e70, 0x1e70}, {0x1e72, 0x1e72},
  {0x1e74, 0x1e74}, {0x1e76, 0x1e76}, {0x1e78, 0x1e78}, {0x1e7a, 0x1e7a}, {0x1e7c, 0x1e7c}, {0x1e7e, 0x1e7e}, {0x1e80, 0x1e80}, {0x1e82, 0x1e82},
  {0x1e84, 0x1e84}, {0x1e86, 0x1e86}, {0x1e88, 0x1e88}, {0x1e8a, 0x1e8a}, {0x1e8c, 0x1e8c}, {0x1e8e, 0x1e8e}, {0x1e90, 0x1e90}, {0x1e92, 0x1e92},
  {0x1e94, 0x1e94}, {0x1e9e, 0x1e9e}, {0x1ea0, 0x1ea0}, {0x1ea2, 0x1ea2}, {0x1ea4, 0x1ea4}, {0x1ea6, 0x1ea6}, {0x1ea8, 0x1ea8}, {0x1eaa, 0x1eaa},
  {0x1eac, 0x1eac}, {0x1eae, 0x1eae}, {0x1eb0, 0x1eb0}, {0x1eb2, 0x1eb2}, {0x1eb4, 0x1eb4}, {0x1eb6, 0x1eb6}, {0x1eb8, 0x1eb8}, {0x1eba, 0x1eba},
  {0x1ebc, 0x1ebc}, {0x1ebe, 0x1ebe}, {0x1ec0, 0x1ec0}, {0x1ec2, 0x1ec2}, {0x1ec4, 0x1ec4}, {0x1ec6, 0x1ec6}, {0x1ec8, 0x1ec8}, {0x1eca, 0x1eca},
  {0x1ecc, 0x1ecc}, {0x1ece, 0x1ece}, {0x1ed0, 0x1ed0}, {0x1ed2, 0x1ed2}, {0x1ed4, 0x1ed4}, {0x1ed6, 0x1ed6}, {0x1ed8, 0x1ed8}, {0x1eda, 0x1eda},
  {0x1edc, 0x1edc}, {0x1ede, 0x1ede}, {0x1ee0, 0x1ee0}, {0x1ee2, 0x1ee2}, {0x1ee4, 0x1ee4}, {0x1ee6, 0x1ee6}, {0x1ee8, 0x1ee8}, {0x1eea, 0x1eea},
  {0x1eec, 0x1eec}, {0x1eee, 0x1eee}, {0x1ef0, 0x1ef0}, {0x1ef2, 0x1ef2}, {0x1ef4, 0x1ef4}, {0x1ef6, 0x1ef6}, {0x1ef8, 0x1ef8}, {0x1efa, 0x1efa},
  {0x1efc, 0x1efc}, {0x1efe, 0x1efe}, {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f5f}, {0x1f68, 0x1f6f}, {0x1fb8, 0x1fbb}, {0x1fc8, 0x1fcb}, {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec},
  {0x1ff8, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210b, 0x210d}, {0x2110, 0x2112}, {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124},
  {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x2130, 0x2133}, {0x213e, 0x213f}, {0x2145, 0x2145}, {0x2183, 0x2183}, {0x2c00, 0x2c2e},
  {0x2c60, 0x2c60}, {0x2c62, 0x2c64}, {0x2c67, 0x2c67}, {0x2c69, 0x2c69}, {0x2c6b, 0x2c6b}, {0x2c6d, 0x2c70}, {0x2c72, 0x2c72}, {0x2c75, 0x2c75},
  {0x2c7e, 0x2c80}, {0x2c82, 0x2c82}, {0x2c84, 0x2c84}, {0x2c86, 0x2c86}, {0x2c88, 0x2c88}, {0x2c8a, 0x2c8a}, {0x2c8c, 0x2c8c}, {0x2c8e, 0x2c8e},
  {0x2c90, 0x2c90}, {0x2c92, 0x2c92}, {0x2c94, 0x2c94}, {0x2c96, 0x2c96}, {0x2c98, 0x2c98}, {0x2c9a, 0x2c9a}, {0x2c9c, 0x2c9c}, {0x2c9e, 0x2c9e},
  {0x2ca0, 0x2ca0}, {0x2ca2, 0x2ca2}, {0x2ca4, 0x2ca4}, {0x2ca6, 0x2ca6}, {0x2ca8, 0x2ca8}, {0x2caa, 0x2caa}, {0x2cac, 0x2cac}, {0x2cae, 0x2cae},
  {0x2cb0, 0x2cb0}, {0x2cb2, 0x2cb2}, {0x2cb4, 0x2cb4}, {0x2cb6, 0x2cb6}, {0x2cb8, 0x2cb8}, {0x2cba, 0x2cba}, {0x2cbc, 0x2cbc}, {0x2cbe, 0x2cbe},
  {0x2cc0, 0x2cc0}, {0x2cc2, 0x2cc2}, {0x2cc4, 0x2cc4}, {0x2cc6, 0x2cc6}, {0x2cc8, 0x2cc8}, {0x2cca, 0x2cca}, {0x2ccc, 0x2ccc}, {0x2cce, 0x2cce},
  {0x2cd0, 0x2cd0}, {0x2cd2, 0x2cd2}, {0x2cd4, 0x2cd4}, {0x2cd6, 0x2cd6}, {0x2cd8, 0x2cd8}, {0x2cda, 0x2cda}, {0x2cdc, 0x2cdc}, {0x2cde, 0x2cde},
  {0x2ce0, 0x2ce0}, {0x2ce2, 0x2ce2}, {0x2ceb, 0x2ceb}, {0x2ced, 0x2ced}, {0x2cf2, 0x2cf2}, {0xa640, 0xa640}, {0xa642, 0xa642}, {0xa644, 0xa644},
  {0xa646, 0xa646}, {0xa648, 0xa648}, {0xa64a, 0xa64a}, {0xa64c, 0xa64c}, {0xa64e, 0xa64e}, {0xa650, 0xa650}, {0xa652, 0xa652}, {0xa654, 0xa654},
  {0xa656, 0xa656}, {0xa658, 0xa658}, {0xa65a, 0xa65a}, {0xa65c, 0xa65c}, {0xa65e, 0xa65e}, {0xa660, 0xa660}, {0xa662, 0xa662}, {0xa664, 0xa664},
  {0xa666, 0xa666}, {0xa668, 0xa668}, {0xa66a, 0xa66a}, {0xa66c, 0xa66c}, {0xa680, 0xa680}, {0xa682, 0xa682}, {0xa684, 0xa684}, {0xa686, 0xa686},
  {0xa688, 0xa688}, {0xa68a, 0xa68a}, {0xa68c, 0xa68c}, {0xa68e, 0xa68e}, {0xa690, 0xa690}, {0xa692, 0xa692}, {0xa694, 0xa694}, {0xa696, 0xa696},
  {0xa698, 0xa698}, {0xa69a, 0xa69a}, {0xa722, 0xa722}, {0xa724, 0xa724}, {0xa726, 0xa726}, {0xa728, 0xa728}, {0xa72a, 0xa72a}, {0xa72c, 0xa72c},
  {0xa72e, 0xa72e}, {0xa732, 0xa732}, {0xa734, 0xa734}, {0xa736, 0xa736}, {0xa738, 0xa738}, {0xa73a, 0xa73a}, {0xa73c, 0xa73c}, {0xa73e, 0xa73e},
  {0xa740, 0xa740}, {0xa742, 0xa742}, {0xa744, 0xa744}, {0xa746, 0xa746}, {0xa748, 0xa748}, {0xa74a, 0xa74a}, {0xa74c, 0xa74c}, {0xa74e, 0xa74e},
  {0xa750, 0xa750}, {0xa752, 0xa752}, {0xa754, 0xa754}, {0xa756, 0xa756}, {0xa758, 0xa758}, {0xa75a, 0xa75a}, {0xa75c, 0xa75c}, {0xa75e, 0xa75e},
  {0xa760, 0xa760}, {0xa762, 0xa762}, {0xa764, 0xa764}, {0xa766, 0xa766}, {0xa768, 0xa768}, {0xa76a, 0xa76a}, {0xa76c, 0xa76c}, {0xa76e, 0xa76e},
  {0xa779, 0xa779}, {0xa77b, 0xa77b}, {0xa77d, 0xa77e}, {0xa780, 0xa780}, {0xa782, 0xa782}, {0xa784, 0xa784}, {0xa786, 0xa786}, {0xa78b, 0xa78b},
  {0xa78d, 0xa78d}, {0xa790, 0xa790}, {0xa792, 0xa792}, {0xa796, 0xa796}, {0xa798, 0xa798}, {0xa79a, 0xa79a}, {0xa79c, 0xa79c}, {0xa79e, 0xa79e},
  {0xa7a0, 0xa7a0}, {0xa7a2, 0xa7a2}, {0xa7a4, 0xa7a4}, {0xa7a6, 0xa7a6}, {0xa7a8, 0xa7a8}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7b6, 0xa7b6},
  {0xa7b8, 0xa7b8}, {0xa7ba, 0xa7ba}, {0xa7bc, 0xa7bc}, {0xa7be, 0xa7be}, {0xa7c2, 0xa7c2}, {0xa7c4, 0xa7c6}, {0xff21, 0xff3a}, {0x10400, 0x10427},
  {0x104b0, 0x104d3}, {0x10c80, 0x10cb2}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, {0x1d400, 0x1d419}, {0x1d434, 0x1d44d}, {0x1d468, 0x1d481}, {0x1d49c, 0x1d49c},
  {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b5}, {0x1d4d0, 0x1d4e9}, {0x1d504, 0x1d505}, {0x1d507, 0x1d50a},
  {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d538, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d56c, 0x1d585},
  {0x1d5a0, 0x1d5b9}, {0x1d5d4, 0x1d5ed}, {0x1d608, 0x1d621}, {0x1d63c, 0x1d655}, {0x1d670, 0x1d689}, {0x1d6a8, 0x1d6c0}, {0x1d6e2, 0x1d6fa}, {0x1d71c, 0x1d734},
  {0x1d756, 0x1d76e}, {0x1d790, 0x1d7a8}, {0x1d7ca, 0x1d7ca}, {0x1e900, 0x1e921},
};

static TSCharacterRange sym_upper_case_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6},
  {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377},
  {0x37a, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f},
  {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f},
  {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824},
  {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x8a0, 0x8b4}, {0x8b6, 0x8bd}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc60, 0xc61}, {0xc80, 0xc80}, {0xc85, 0xc8c},
  {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcde, 0xcde}, {0xce0, 0xce1}, {0xcf1, 0xcf2},
  {0xd05, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61}, {0xd7a, 0xd7f},
  {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe33}, {0xe40, 0xe46},
  {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb3}, {0xebd, 0xebd},
  {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c}, {0x1000, 0x102a},
  {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081}, {0x108e, 0x108e},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c},
  {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16f1, 0x16f8}, {0x1700, 0x170c}, {0x170e, 0x1711}, {0x1720, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x1884}, {0x1887, 0x18a8},
  {0x18aa, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16},
  {0x1a20, 0x1a54}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4b}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23},
  {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6},
  {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c},
  {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128},
  {0x212a, 0x212d}, {0x212f, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e},
  {0x2c60, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f},
  {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6},
  {0x2dd8, 0x2dde}, {0x2e2f, 0x2e2f}, {0x3005, 0x3006}, {0x3031, 0x3035}, {0x303b, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa},
  {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, {0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xa000, 0xa48c},
  {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6e5}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7bf}, {0xa7c2, 0xa7c6}, {0xa7f7, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873},
  {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2},
  {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76},
  {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab67}, {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06},
  {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44},
  {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff21, 0xff3a},
  {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026},
  {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f},
  {0x1032d, 0x10340}, {0x10342, 0x10349}, {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x10400, 0x1049d}, {0x104b0, 0x104d3},
  {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f45}, {0x10fe0, 0x10ff6},
  {0x11003, 0x11037}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2},
  {0x111c1, 0x111c4}, {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x1145f}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x118ff}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3},
  {0x11a00, 0x11a00}, {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ac0, 0x11af8}, {0x11c00, 0x11c08},
  {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65},
  {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x12000, 0x12399}, {0x12480, 0x12543}, {0x13000, 0x1342e}, {0x14400, 0x14646},
  {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e},
  {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e2c0, 0x1e2eb}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d},
  {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d},
};

static TSCharacterRange sym_lower_case_identifier_character_set_1[] = {
  {'a', 'z'}, {0xb5, 0xb5}, {0xdf, 0xf6}, {0xf8, 0xff}, {0x101, 0x101}, {0x103, 0x103}, {0x105, 0x105}, {0x107, 0x107},
  {0x109, 0x109}, {0x10b, 0x10b}, {0x10d, 0x10d}, {0x10f, 0x10f}, {0x111, 0x111}, {0x113, 0x113}, {0x115, 0x115}, {0x117, 0x117},
  {0x119, 0x119}, {0x11b, 0x11b}, {0x11d, 0x11d}, {0x11f, 0x11f}, {0x121, 0x121}, {0x123, 0x123}, {0x125, 0x125}, {0x127, 0x127},
  {0x129, 0x129}, {0x12b, 0x12b}, {0x12d, 0x12d}, {0x12f, 0x12f}, {0x131, 0x131}, {0x133, 0x133}, {0x135, 0x135}, {0x137, 0x138},
  {0x13a, 0x13a}, {0x13c, 0x13c}, {0x13e, 0x13e}, {0x140, 0x140}, {0x142, 0x142}, {0x144, 0x144}, {0x146, 0x146}, {0x148, 0x149},
  {0x14b, 0x14b}, {0x14d, 0x14d}, {0x14f, 0x14f}, {0x151, 0x151}, {0x153, 0x153}, {0x155, 0x155}, {0x157, 0x157}, {0x159, 0x159},
  {0x15b, 0x15b}, {0x15d, 0x15d}, {0x15f, 0x15f}, {0x161, 0x161}, {0x163, 0x163}, {0x165, 0x165}, {0x167, 0x167}, {0x169, 0x169},
  {0x16b, 0x16b}, {0x16d, 0x16d}, {0x16f, 0x16f}, {0x171, 0x171}, {0x173, 0x173}, {0x175, 0x175}, {0x177, 0x177}, {0x17a, 0x17a},
  {0x17c, 0x17c}, {0x17e, 0x180}, {0x183, 0x183}, {0x185, 0x185}, {0x188, 0x188}, {0x18c, 0x18d}, {0x192, 0x192}, {0x195, 0x195},
  {0x199, 0x19b}, {0x19e, 0x19e}, {0x1a1, 0x1a1}, {0x1a3, 0x1a3}, {0x1a5, 0x1a5}, {0x1a8, 0x1a8}, {0x1aa, 0x1ab}, {0x1ad, 0x1ad},
  {0x1b0, 0x1b0}, {0x1b4, 0x1b4}, {0x1b6, 0x1b6}, {0x1b9, 0x1ba}, {0x1bd, 0x1bf}, {0x1c6, 0x1c6}, {0x1c9, 0x1c9}, {0x1cc, 0x1cc},
  {0x1ce, 0x1ce}, {0x1d0, 0x1d0}, {0x1d2, 0x1d2}, {0x1d4, 0x1d4}, {0x1d6, 0x1d6}, {0x1d8, 0x1d8}, {0x1da, 0x1da}, {0x1dc, 0x1dd},
  {0x1df, 0x1df}, {0x1e1, 0x1e1}, {0x1e3, 0x1e3}, {0x1e5, 0x1e5}, {0x1e7, 0x1e7}, {0x1e9, 0x1e9}, {0x1eb, 0x1eb}, {0x1ed, 0x1ed},
  {0x1ef, 0x1f0}, {0x1f3, 0x1f3}, {0x1f5, 0x1f5}, {0x1f9, 0x1f9}, {0x1fb, 0x1fb}, {0x1fd, 0x1fd}, {0x1ff, 0x1ff}, {0x201, 0x201},
  {0x203, 0x203}, {0x205, 0x205}, {0x207, 0x207}, {0x209, 0x209}, {0x20b, 0x20b}, {0x20d, 0x20d}, {0x20f, 0x20f}, {0x211, 0x211},
  {0x213, 0x213}, {0x215, 0x215}, {0x217, 0x217}, {0x219, 0x219}, {0x21b, 0x21b}, {0x21d, 0x21d}, {0x21f, 0x21f}, {0x221, 0x221},
  {0x223, 0x223}, {0x225, 0x225}, {0x227, 0x227}, {0x229, 0x229}, {0x22b, 0x22b}, {0x22d, 0x22d}, {0x22f, 0x22f}, {0x231, 0x231},
  {0x233, 0x239}, {0x23c, 0x23c}, {0x23f, 0x240}, {0x242, 0x242}, {0x247, 0x247}, {0x249, 0x249}, {0x24b, 0x24b}, {0x24d, 0x24d},
  {0x24f, 0x293}, {0x295, 0x2af}, {0x371, 0x371}, {0x373, 0x373}, {0x377, 0x377}, {0x37b, 0x37d}, {0x390, 0x390}, {0x3ac, 0x3ce},
  {0x3d0, 0x3d1}, {0x3d5, 0x3d7}, {0x3d9, 0x3d9}, {0x3db, 0x3db}, {0x3dd, 0x3dd}, {0x3df, 0x3df}, {0x3e1, 0x3e1}, {0x3e3, 0x3e3},
  {0x3e5, 0x3e5}, {0x3e7, 0x3e7}, {0x3e9, 0x3e9}, {0x3eb, 0x3eb}, {0x3ed, 0x3ed}, {0x3ef, 0x3f3}, {0x3f5, 0x3f5}, {0x3f8, 0x3f8},
  {0x3fb, 0x3fc}, {0x430, 0x45f}, {0x461, 0x461}, {0x463, 0x463}, {0x465, 0x465}, {0x467, 0x467}, {0x469, 0x469}, {0x46b, 0x46b},
  {0x46d, 0x46d}, {0x46f, 0x46f}, {0x471, 0x471}, {0x473, 0x473}, {0x475, 0x475}, {0x477, 0x477}, {0x479, 0x479}, {0x47b, 0x47b},
  {0x47d, 0x47d}, {0x47f, 0x47f}, {0x481, 0x481}, {0x48b, 0x48b}, {0x48d, 0x48d}, {0x48f, 0x48f}, {0x491, 0x491}, {0x493, 0x493},
  {0x495, 0x495}, {0x497, 0x497}, {0x499, 0x499}, {0x49b, 0x49b}, {0x49d, 0x49d}, {0x49f, 0x49f}, {0x4a1, 0x4a1}, {0x4a3, 0x4a3},
  {0x4a5, 0x4a5}, {0x4a7, 0x4a7}, {0x4a9, 0x4a9}, {0x4ab, 0x4ab}, {0x4ad, 0x4ad}, {0x4af, 0x4af}, {0x4b1, 0x4b1}, {0x4b3, 0x4b3},
  {0x4b5, 0x4b5}, {0x4b7, 0x4b7}, {0x4b9, 0x4b9}, {0x4bb, 0x4bb}, {0x4bd, 0x4bd}, {0x4bf, 0x4bf}, {0x4c2, 0x4c2}, {0x4c4, 0x4c4},
  {0x4c6, 0x4c6}, {0x4c8, 0x4c8}, {0x4ca, 0x4ca}, {0x4cc, 0x4cc}, {0x4ce, 0x4cf}, {0x4d1, 0x4d1}, {0x4d3, 0x4d3}, {0x4d5, 0x4d5},
  {0x4d7, 0x4d7}, {0x4d9, 0x4d9}, {0x4db, 0x4db}, {0x4dd, 0x4dd}, {0x4df, 0x4df}, {0x4e1, 0x4e1}, {0x4e3, 0x4e3}, {0x4e5, 0x4e5},
  {0x4e7, 0x4e7}, {0x4e9, 0x4e9}, {0x4eb, 0x4eb}, {0x4ed, 0x4ed}, {0x4ef, 0x4ef}, {0x4f1, 0x4f1}, {0x4f3, 0x4f3}, {0x4f5, 0x4f5},
  {0x4f7, 0x4f7}, {0x4f9, 0x4f9}, {0x4fb, 0x4fb}, {0x4fd, 0x4fd}, {0x4ff, 0x4ff}, {0x501, 0x501}, {0x503, 0x503}, {0x505, 0x505},
  {0x507, 0x507}, {0x509, 0x509}, {0x50b, 0x50b}, {0x50d, 0x50d}, {0x50f, 0x50f}, {0x511, 0x511}, {0x513, 0x513}, {0x515, 0x515},
  {0x517, 0x517}, {0x519, 0x519}, {0x51b, 0x51b}, {0x51d, 0x51d}, {0x51f, 0x51f}, {0x521, 0x521}, {0x523, 0x523}, {0x525, 0x525},
  {0x527, 0x527}, {0x529, 0x529}, {0x52b, 0x52b}, {0x52d, 0x52d}, {0x52f, 0x52f}, {0x560, 0x588}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff},
  {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e01, 0x1e01}, {0x1e03, 0x1e03}, {0x1e05, 0x1e05},
  {0x1e07, 0x1e07}, {0x1e09, 0x1e09}, {0x1e0b, 0x1e0b}, {0x1e0d, 0x1e0d}, {0x1e0f, 0x1e0f}, {0x1e11, 0x1e11}, {0x1e13, 0x1e13}, {0x1e15, 0x1e15},
  {0x1e17, 0x1e17}, {0x1e19, 0x1e19}, {0x1e1b, 0x1e1b}, {0x1e1d, 0x1e1d}, {0x1e1f, 0x1e1f}, {0x1e21, 0x1e21}, {0x1e23, 0x1e23}, {0x1e25, 0x1e25},
  {0x1e27, 0x1e27}, {0x1e29, 0x1e29}, {0x1e2b, 0x1e2b}, {0x1e2d, 0x1e2d}, {0x1e2f, 0x1e2f}, {0x1e31, 0x1e31}, {0x1e33, 0x1e33}, {0x1e35, 0x1e35},
  {0x1e37, 0x1e37}, {0x1e39, 0x1e39}, {0x1e3b, 0x1e3b}, {0x1e3d, 0x1e3d}, {0x1e3f, 0x1e3f}, {0x1e41, 0x1e41}, {0x1e43, 0x1e43}, {0x1e45, 0x1e45},
  {0x1e47, 0x1e47}, {0x1e49, 0x1e49}, {0x1e4b, 0x1e4b}, {0x1e4d, 0x1e4d}, {0x1e4f, 0x1e4f}, {0x1e51, 0x1e51}, {0x1e53, 0x1e53}, {0x1e55, 0x1e55},
  {0x1e57, 0x1e57}, {0x1e59, 0x1e59}, {0x1e5b, 0x1e5b}, {0x1e5d, 0x1e5d}, {0x1e5f, 0x1e5f}, {0x1e61, 0x1e61}, {0x1e63, 0x1e63}, {0x1e65, 0x1e65},
  {0x1e67, 0x1e67}, {0x1e69, 0x1e69}, {0x1e6b, 0x1e6b}, {0x1e6d, 0x1e6d}, {0x1e6f, 0x1e6f}, {0x1e71, 0x1e71}, {0x1e73, 0x1e73}, {0x1e75, 0x1e75},
  {0x1e77, 0x1e77}, {0x1e79, 0x1e79}, {0x1e7b, 0x1e7b}, {0x1e7d, 0x1e7d}, {0x1e7f, 0x1e7f}, {0x1e81, 0x1e81}, {0x1e83, 0x1e83}, {0x1e85, 0x1e85},
  {0x1e87, 0x1e87}, {0x1e89, 0x1e89}, {0x1e8b, 0x1e8b}, {0x1e8d, 0x1e8d}, {0x1e8f, 0x1e8f}, {0x1e91, 0x1e91}, {0x1e93, 0x1e93}, {0x1e95, 0x1e9d},
  {0x1e9f, 0x1e9f}, {0x1ea1, 0x1ea1}, {0x1ea3, 0x1ea3}, {0x1ea5, 0x1ea5}, {0x1ea7, 0x1ea7}, {0x1ea9, 0x1ea9}, {0x1eab, 0x1eab}, {0x1ead, 0x1ead},
  {0x1eaf, 0x1eaf}, {0x1eb1, 0x1eb1}, {0x1eb3, 0x1eb3}, {0x1eb5, 0x1eb5}, {0x1eb7, 0x1eb7}, {0x1eb9, 0x1eb9}, {0x1ebb, 0x1ebb}, {0x1ebd, 0x1ebd},
  {0x1ebf, 0x1ebf}, {0x1ec1, 0x1ec1}, {0x1ec3, 0x1ec3}, {0x1ec5, 0x1ec5}, {0x1ec7, 0x1ec7}, {0x1ec9, 0x1ec9}, {0x1ecb, 0x1ecb}, {0x1ecd, 0x1ecd},
  {0x1ecf, 0x1ecf}, {0x1ed1, 0x1ed1}, {0x1ed3, 0x1ed3}, {0x1ed5, 0x1ed5}, {0x1ed7, 0x1ed7}, {0x1ed9, 0x1ed9}, {0x1edb, 0x1edb}, {0x1edd, 0x1edd},
  {0x1edf, 0x1edf}, {0x1ee1, 0x1ee1}, {0x1ee3, 0x1ee3}, {0x1ee5, 0x1ee5}, {0x1ee7, 0x1ee7}, {0x1ee9, 0x1ee9}, {0x1eeb, 0x1eeb}, {0x1eed, 0x1eed},
  {0x1eef, 0x1eef}, {0x1ef1, 0x1ef1}, {0x1ef3, 0x1ef3}, {0x1ef5, 0x1ef5}, {0x1ef7, 0x1ef7}, {0x1ef9, 0x1ef9}, {0x1efb, 0x1efb}, {0x1efd, 0x1efd},
  {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, {0x1f70, 0x1f7d},
  {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ff7}, {0x210a, 0x210a}, {0x210e, 0x210f}, {0x2113, 0x2113},
  {0x212f, 0x212f}, {0x2134, 0x2134}, {0x2139, 0x2139}, {0x213c, 0x213d}, {0x2146, 0x2149}, {0x214e, 0x214e}, {0x2184, 0x2184}, {0x2c30, 0x2c5e},
  {0x2c61, 0x2c61}, {0x2c65, 0x2c66}, {0x2c68, 0x2c68}, {0x2c6a, 0x2c6a}, {0x2c6c, 0x2c6c}, {0x2c71, 0x2c71}, {0x2c73, 0x2c74}, {0x2c76, 0x2c7b},
  {0x2c81, 0x2c81}, {0x2c83, 0x2c83}, {0x2c85, 0x2c85}, {0x2c87, 0x2c87}, {0x2c89, 0x2c89}, {0x2c8b, 0x2c8b}, {0x2c8d, 0x2c8d}, {0x2c8f, 0x2c8f},
  {0x2c91, 0x2c91}, {0x2c93, 0x2c93}, {0x2c95, 0x2c95}, {0x2c97, 0x2c97}, {0x2c99, 0x2c99}, {0x2c9b, 0x2c9b}, {0x2c9d, 0x2c9d}, {0x2c9f, 0x2c9f},
  {0x2ca1, 0x2ca1}, {0x2ca3, 0x2ca3}, {0x2ca5, 0x2ca5}, {0x2ca7, 0x2ca7}, {0x2ca9, 0x2ca9}, {0x2cab, 0x2cab}, {0x2cad, 0x2cad}, {0x2caf, 0x2caf},
  {0x2cb1, 0x2cb1}, {0x2cb3, 0x2cb3}, {0x2cb5, 0x2cb5}, {0x2cb7, 0x2cb7}, {0x2cb9, 0x2cb9}, {0x2cbb, 0x2cbb}, {0x2cbd, 0x2cbd}, {0x2cbf, 0x2cbf},
  {0x2cc1, 0x2cc1}, {0x2cc3, 0x2cc3}, {0x2cc5, 0x2cc5}, {0x2cc7, 0x2cc7}, {0x2cc9, 0x2cc9}, {0x2ccb, 0x2ccb}, {0x2ccd, 0x2ccd}, {0x2ccf, 0x2ccf},
  {0x2cd1, 0x2cd1}, {0x2cd3, 0x2cd3}, {0x2cd5, 0x2cd5}, {0x2cd7, 0x2cd7}, {0x2cd9, 0x2cd9}, {0x2cdb, 0x2cdb}, {0x2cdd, 0x2cdd}, {0x2cdf, 0x2cdf},
  {0x2ce1, 0x2ce1}, {0x2ce3, 0x2ce4}, {0x2cec, 0x2cec}, {0x2cee, 0x2cee}, {0x2cf3, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d},
  {0xa641, 0xa641}, {0xa643, 0xa643}, {0xa645, 0xa645}, {0xa647, 0xa647}, {0xa649, 0xa649}, {0xa64b, 0xa64b}, {0xa64d, 0xa64d}, {0xa64f, 0xa64f},
  {0xa651, 0xa651}, {0xa653, 0xa653}, {0xa655, 0xa655}, {0xa657, 0xa657}, {0xa659, 0xa659}, {0xa65b, 0xa65b}, {0xa65d, 0xa65d}, {0xa65f, 0xa65f},
  {0xa661, 0xa661}, {0xa663, 0xa663}, {0xa665, 0xa665}, {0xa667, 0xa667}, {0xa669, 0xa669}, {0xa66b, 0xa66b}, {0xa66d, 0xa66d}, {0xa681, 0xa681},
  {0xa683, 0xa683}, {0xa685, 0xa685}, {0xa687, 0xa687}, {0xa689, 0xa689}, {0xa68b, 0xa68b}, {0xa68d, 0xa68d}, {0xa68f, 0xa68f}, {0xa691, 0xa691},
  {0xa693, 0xa693}, {0xa695, 0xa695}, {0xa697, 0xa697}, {0xa699, 0xa699}, {0xa69b, 0xa69b}, {0xa723, 0xa723}, {0xa725, 0xa725}, {0xa727, 0xa727},
  {0xa729, 0xa729}, {0xa72b, 0xa72b}, {0xa72d, 0xa72d}, {0xa72f, 0xa731}, {0xa733, 0xa733}, {0xa735, 0xa735}, {0xa737, 0xa737}, {0xa739, 0xa739},
  {0xa73b, 0xa73b}, {0xa73d, 0xa73d}, {0xa73f, 0xa73f}, {0xa741, 0xa741}, {0xa743, 0xa743}, {0xa745, 0xa745}, {0xa747, 0xa747}, {0xa749, 0xa749},
  {0xa74b, 0xa74b}, {0xa74d, 0xa74d}, {0xa74f, 0xa74f}, {0xa751, 0xa751}, {0xa753, 0xa753}, {0xa755, 0xa755}, {0xa757, 0xa757}, {0xa759, 0xa759},
  {0xa75b, 0xa75b}, {0xa75d, 0xa75d}, {0xa75f, 0xa75f}, {0xa761, 0xa761}, {0xa763, 0xa763}, {0xa765, 0xa765}, {0xa767, 0xa767}, {0xa769, 0xa769},
  {0xa76b, 0xa76b}, {0xa76d, 0xa76d}, {0xa76f, 0xa76f}, {0xa771, 0xa778}, {0xa77a, 0xa77a}, {0xa77c, 0xa77c}, {0xa77f, 0xa77f}, {0xa781, 0xa781},
  {0xa783, 0xa783}, {0xa785, 0xa785}, {0xa787, 0xa787}, {0xa78c, 0xa78c}, {0xa78e, 0xa78e}, {0xa791, 0xa791}, {0xa793, 0xa795}, {0xa797, 0xa797},
  {0xa799, 0xa799}, {0xa79b, 0xa79b}, {0xa79d, 0xa79d}, {0xa79f, 0xa79f}, {0xa7a1, 0xa7a1}, {0xa7a3, 0xa7a3}, {0xa7a5, 0xa7a5}, {0xa7a7, 0xa7a7},
  {0xa7a9, 0xa7a9}, {0xa7af, 0xa7af}, {0xa7b5, 0xa7b5}, {0xa7b7, 0xa7b7}, {0xa7b9, 0xa7b9}, {0xa7bb, 0xa7bb}, {0xa7bd, 0xa7bd}, {0xa7bf, 0xa7bf},
  {0xa7c3, 0xa7c3}, {0xa7fa, 0xa7fa}, {0xab30, 0xab5a}, {0xab60, 0xab67}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff41, 0xff5a},
  {0x10428, 0x1044f}, {0x104d8, 0x104fb}, {0x10cc0, 0x10cf2}, {0x118c0, 0x118df}, {0x16e60, 0x16e7f}, {0x1d41a, 0x1d433}, {0x1d44e, 0x1d454}, {0x1d456, 0x1d467},
  {0x1d482, 0x1d49b}, {0x1d4b6, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d4cf}, {0x1d4ea, 0x1d503}, {0x1d51e, 0x1d537}, {0x1d552, 0x1d56b},
  {0x1d586, 0x1d59f}, {0x1d5ba, 0x1d5d3}, {0x1d5ee, 0x1d607}, {0x1d622, 0x1d63b}, {0x1d656, 0x1d66f}, {0x1d68a, 0x1d6a5}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6e1},
  {0x1d6fc, 0x1d714}, {0x1d716, 0x1d71b}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d755}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d78f}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7c9},
  {0x1d7cb, 0x1d7cb}, {0x1e922, 0x1e943},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 96,
        '&', 29,
        '\'', 84,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 127,
        '.', 79,
        '/', 130,
        '0', 105,
        ':', 119,
        '<', 135,
        '=', 117,
        '>', 136,
        '[', 100,
        '\\', 2,
        ']', 101,
        '^', 132,
        '_', 121,
        '{', 82,
        '|', 81,
        '}', 83,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym__upper_case_identifier_without_leading_whitespace_character_set_1, 611, lookahead)) ADVANCE(76);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(15);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(15);
      if (lookahead == '\r') SKIP(1);
      if (lookahead == 'u') ADVANCE(42);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(110);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(26);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(26);
      if (lookahead == '\r') SKIP(3);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(28);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(28);
      if (lookahead == '\r') SKIP(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(24);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '\r') SKIP(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(20);
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '-') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '{') ADVANCE(98);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(97);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '\n', 113,
        '\r', 111,
        'u', 114,
        '"', 110,
        '\'', 110,
        '\\', 110,
        'n', 110,
        'r', 110,
        't', 110,
      );
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(34);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(34);
      if (lookahead == '\r') SKIP(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(13);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '{') ADVANCE(87);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(88);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(85);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '\n', 112,
        '\r', 111,
        'u', 114,
        '"', 110,
        '\'', 110,
        '\\', 110,
        'n', 110,
        'r', 110,
        't', 110,
      );
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '"', 96,
        '&', 29,
        '\'', 84,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 127,
        '.', 123,
        '/', 130,
        '0', 105,
        ':', 119,
        '<', 135,
        '=', 117,
        '>', 136,
        '[', 100,
        '\\', 2,
        ']', 101,
        '^', 132,
        '_', 121,
        '{', 82,
        '|', 81,
        '}', 83,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(15);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '"', 96,
        '&', 29,
        '\'', 84,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 128,
        '.', 78,
        '/', 130,
        '0', 105,
        ':', 38,
        '<', 135,
        '=', 39,
        '>', 136,
        '[', 100,
        '\\', 120,
        ']', 101,
        '^', 132,
        '{', 82,
        '|', 37,
        '}', 83,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '"', 96,
        '&', 29,
        '\'', 84,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 128,
        '.', 122,
        '/', 130,
        '0', 105,
        ':', 38,
        '<', 135,
        '=', 39,
        '>', 136,
        '[', 100,
        '\\', 120,
        ']', 101,
        '^', 132,
        '{', 82,
        '|', 37,
        '}', 83,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(89);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(89);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '{') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(20);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(23);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '{') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(91);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(61);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        '&', 29,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 125,
        '.', 36,
        '/', 130,
        ':', 38,
        '<', 135,
        '=', 117,
        '>', 136,
      );
      if (lookahead == '\\') SKIP(8);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '|') ADVANCE(37);
      if (lookahead == '}') ADVANCE(83);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(24);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '&', 29,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        '-', 126,
        '.', 78,
        '/', 130,
        ':', 38,
        '<', 135,
        '=', 39,
        '>', 136,
      );
      if (lookahead == '\\') SKIP(4);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '|') ADVANCE(37);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(26);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '&', 29,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        '-', 126,
        '/', 130,
        ':', 38,
        '<', 135,
        '=', 39,
        '>', 136,
      );
      if (lookahead == '\\') SKIP(4);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '|') ADVANCE(37);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(26);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        '&', 29,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 125,
        '.', 78,
        '/', 130,
        ':', 38,
        '<', 135,
        '=', 39,
        '>', 136,
      );
      if (lookahead == '\\') SKIP(6);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '|') ADVANCE(37);
      if (lookahead == '}') ADVANCE(83);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(28);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 28:
      ADVANCE_MAP(
        '&', 29,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 125,
        '/', 130,
        ':', 38,
        '<', 135,
        '=', 39,
        '>', 136,
      );
      if (lookahead == '\\') SKIP(6);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '|') ADVANCE(37);
      if (lookahead == '}') ADVANCE(83);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(28);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 29:
      if (lookahead == '&') ADVANCE(139);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(72);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == '}') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(68);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 34:
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '\\') SKIP(12);
      if (lookahead == '{') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(34);
      END_STATE();
    case 35:
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '\\') SKIP(12);
      if (lookahead == '{') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(34);
      if (set_contains(sym__upper_case_identifier_without_leading_whitespace_character_set_1, 611, lookahead)) ADVANCE(76);
      if (set_contains(sym__lower_case_identifier_without_leading_whitespace_character_set_1, 623, lookahead)) ADVANCE(77);
      END_STATE();
    case 36:
      if (lookahead == '.') ADVANCE(115);
      END_STATE();
    case 37:
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '=') ADVANCE(149);
      if (lookahead == '>') ADVANCE(143);
      if (lookahead == '|') ADVANCE(140);
      END_STATE();
    case 38:
      if (lookahead == ':') ADVANCE(102);
      END_STATE();
    case 39:
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 40:
      if (lookahead == '>') ADVANCE(146);
      END_STATE();
    case 41:
      if (lookahead == '>') ADVANCE(147);
      END_STATE();
    case 42:
      if (lookahead == '{') ADVANCE(60);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(110);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 48:
      if (lookahead == '}') ADVANCE(110);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 49:
      if (lookahead == '}') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 50:
      if (lookahead == '}') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 51:
      if (lookahead == '}') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 52:
      if (lookahead == '}') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 53:
      if (lookahead == '}') ADVANCE(111);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(94);
      END_STATE();
    case 62:
      if (eof) ADVANCE(67);
      if (lookahead == '\n') SKIP(66);
      END_STATE();
    case 63:
      if (eof) ADVANCE(67);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '\r') SKIP(62);
      END_STATE();
    case 64:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 96,
        '&', 29,
        '\'', 84,
        '(', 73,
        ')', 75,
        '*', 129,
        '+', 124,
        ',', 74,
        '-', 127,
        '.', 123,
        '/', 130,
        '0', 105,
        ':', 119,
        '<', 135,
        '=', 117,
        '>', 136,
        '[', 100,
        '\\', 2,
        ']', 101,
        '^', 132,
        '_', 121,
        '{', 82,
        '|', 81,
        '}', 83,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 65:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 96,
        '\'', 84,
        '(', 73,
        ')', 75,
        ',', 74,
        '-', 31,
        '.', 78,
        '0', 105,
        ':', 119,
        '=', 116,
        '[', 100,
      );
      if (lookahead == '\\') SKIP(63);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '}') ADVANCE(83);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(66);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 66:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 96,
        '\'', 84,
        '(', 73,
        ')', 75,
        ',', 74,
        '-', 31,
        '0', 105,
        ':', 119,
        '=', 116,
        '[', 100,
      );
      if (lookahead == '\\') SKIP(63);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '}') ADVANCE(83);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(66);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(106);
      if (set_contains(sym_upper_case_identifier_character_set_1, 636, lookahead)) ADVANCE(103);
      if (set_contains(sym_lower_case_identifier_character_set_1, 642, lookahead)) ADVANCE(104);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LBRACE_DASH);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_DASH_RBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n') ADVANCE(94);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead != 0) ADVANCE(90);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n') ADVANCE(94);
      if (lookahead == '"') ADVANCE(70);
      if (lookahead != 0) ADVANCE(90);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym__upper_case_identifier_without_leading_whitespace);
      if (set_contains(sym__upper_case_identifier_without_leading_whitespace_character_set_2, 431, lookahead)) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym__lower_case_identifier_without_leading_whitespace);
      if (set_contains(sym__upper_case_identifier_without_leading_whitespace_character_set_2, 431, lookahead)) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(115);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '=') ADVANCE(149);
      if (lookahead == '>') ADVANCE(143);
      if (lookahead == '|') ADVANCE(140);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '-') ADVANCE(68);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      if (lookahead == '-') ADVANCE(72);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      if (lookahead == '-') ADVANCE(68);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '{') ADVANCE(87);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(88);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'') ADVANCE(85);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '\n') ADVANCE(94);
      if (lookahead == '"') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(23);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '{') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(94);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(94);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(94);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(18);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token2);
      if (lookahead == '-') ADVANCE(98);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(97);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(99);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token2);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(99);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_upper_case_identifier);
      if (set_contains(sym_upper_case_identifier_character_set_2, 611, lookahead)) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_lower_case_identifier);
      if (set_contains(sym_upper_case_identifier_character_set_2, 611, lookahead)) ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'e') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_string_escape);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(88);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(10);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '{') ADVANCE(52);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_double_dot);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_eq);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_eq);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_arrow);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_colon);
      if (lookahead == ':') ADVANCE(102);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_backslash);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_dot);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_dot);
      if (lookahead == '.') ADVANCE(115);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(141);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(72);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == '}') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(131);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '<') ADVANCE(144);
      if (lookahead == '=') ADVANCE(137);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '|') ADVANCE(142);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(145);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LT_PIPE);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT_SLASH_GT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_LT_QMARK_GT);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PIPE_DOT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'i') ADVANCE(4);
      if (lookahead == 'l') ADVANCE(5);
      if (lookahead == 'm') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(7);
      if (lookahead == 'p') ADVANCE(8);
      if (lookahead == 'r') ADVANCE(9);
      if (lookahead == 't') ADVANCE(10);
      if (lookahead == 'w') ADVANCE(11);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(12);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'f') ADVANCE(15);
      if (lookahead == 'l') ADVANCE(16);
      if (lookahead == 'x') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'm') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(26);
      END_STATE();
    case 10:
      if (lookahead == 'h') ADVANCE(27);
      if (lookahead == 'y') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 13:
      if (lookahead == 'i') ADVANCE(30);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(sym_as);
      END_STATE();
    case 15:
      if (lookahead == 'f') ADVANCE(31);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(33);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 19:
      if (lookahead == 'p') ADVANCE(34);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(35);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_is);
      END_STATE();
    case 22:
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 23:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 25:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 26:
      if (lookahead == 'g') ADVANCE(41);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(43);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 33:
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(50);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_non);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'h') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(60);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(61);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 50:
      if (lookahead == 'x') ADVANCE(63);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_left);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_port);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_type);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_when);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_alias);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_infix);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_right);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_where);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_effect);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_import);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_module);
      END_STATE();
    case 71:
      if (lookahead == 'g') ADVANCE(72);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_exposing);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 65},
  [2] = {.lex_state = 17, .external_lex_state = 2},
  [3] = {.lex_state = 17, .external_lex_state = 2},
  [4] = {.lex_state = 17, .external_lex_state = 2},
  [5] = {.lex_state = 17, .external_lex_state = 2},
  [6] = {.lex_state = 17, .external_lex_state = 2},
  [7] = {.lex_state = 17, .external_lex_state = 2},
  [8] = {.lex_state = 17, .external_lex_state = 2},
  [9] = {.lex_state = 17, .external_lex_state = 2},
  [10] = {.lex_state = 17, .external_lex_state = 2},
  [11] = {.lex_state = 17, .external_lex_state = 2},
  [12] = {.lex_state = 17, .external_lex_state = 2},
  [13] = {.lex_state = 17, .external_lex_state = 2},
  [14] = {.lex_state = 17, .external_lex_state = 3},
  [15] = {.lex_state = 17, .external_lex_state = 3},
  [16] = {.lex_state = 17, .external_lex_state = 3},
  [17] = {.lex_state = 17, .external_lex_state = 4},
  [18] = {.lex_state = 17, .external_lex_state = 4},
  [19] = {.lex_state = 17, .external_lex_state = 4},
  [20] = {.lex_state = 16, .external_lex_state = 2},
  [21] = {.lex_state = 16, .external_lex_state = 2},
  [22] = {.lex_state = 16, .external_lex_state = 2},
  [23] = {.lex_state = 16, .external_lex_state = 2},
  [24] = {.lex_state = 16, .external_lex_state = 2},
  [25] = {.lex_state = 17, .external_lex_state = 2},
  [26] = {.lex_state = 17, .external_lex_state = 2},
  [27] = {.lex_state = 17, .external_lex_state = 2},
  [28] = {.lex_state = 16, .external_lex_state = 2},
  [29] = {.lex_state = 16, .external_lex_state = 2},
  [30] = {.lex_state = 16, .external_lex_state = 2},
  [31] = {.lex_state = 16, .external_lex_state = 2},
  [32] = {.lex_state = 16, .external_lex_state = 2},
  [33] = {.lex_state = 16, .external_lex_state = 2},
  [34] = {.lex_state = 16, .external_lex_state = 2},
  [35] = {.lex_state = 16, .external_lex_state = 2},
  [36] = {.lex_state = 16, .external_lex_state = 2},
  [37] = {.lex_state = 16, .external_lex_state = 2},
  [38] = {.lex_state = 16, .external_lex_state = 2},
  [39] = {.lex_state = 16, .external_lex_state = 2},
  [40] = {.lex_state = 16, .external_lex_state = 2},
  [41] = {.lex_state = 16, .external_lex_state = 2},
  [42] = {.lex_state = 17, .external_lex_state = 2},
  [43] = {.lex_state = 17, .external_lex_state = 2},
  [44] = {.lex_state = 17, .external_lex_state = 2},
  [45] = {.lex_state = 17, .external_lex_state = 2},
  [46] = {.lex_state = 17, .external_lex_state = 2},
  [47] = {.lex_state = 17, .external_lex_state = 2},
  [48] = {.lex_state = 17, .external_lex_state = 2},
  [49] = {.lex_state = 17, .external_lex_state = 2},
  [50] = {.lex_state = 17, .external_lex_state = 2},
  [51] = {.lex_state = 17, .external_lex_state = 2},
  [52] = {.lex_state = 17, .external_lex_state = 2},
  [53] = {.lex_state = 17, .external_lex_state = 2},
  [54] = {.lex_state = 17, .external_lex_state = 2},
  [55] = {.lex_state = 17, .external_lex_state = 2},
  [56] = {.lex_state = 17, .external_lex_state = 2},
  [57] = {.lex_state = 17, .external_lex_state = 2},
  [58] = {.lex_state = 17, .external_lex_state = 2},
  [59] = {.lex_state = 17, .external_lex_state = 2},
  [60] = {.lex_state = 17, .external_lex_state = 2},
  [61] = {.lex_state = 17, .external_lex_state = 2},
  [62] = {.lex_state = 17, .external_lex_state = 2},
  [63] = {.lex_state = 17, .external_lex_state = 2},
  [64] = {.lex_state = 17, .external_lex_state = 2},
  [65] = {.lex_state = 16, .external_lex_state = 3},
  [66] = {.lex_state = 17, .external_lex_state = 2},
  [67] = {.lex_state = 17, .external_lex_state = 2},
  [68] = {.lex_state = 16, .external_lex_state = 3},
  [69] = {.lex_state = 17, .external_lex_state = 2},
  [70] = {.lex_state = 17, .external_lex_state = 2},
  [71] = {.lex_state = 17, .external_lex_state = 2},
  [72] = {.lex_state = 17, .external_lex_state = 2},
  [73] = {.lex_state = 17, .external_lex_state = 2},
  [74] = {.lex_state = 17, .external_lex_state = 2},
  [75] = {.lex_state = 17, .external_lex_state = 2},
  [76] = {.lex_state = 16, .external_lex_state = 3},
  [77] = {.lex_state = 16, .external_lex_state = 3},
  [78] = {.lex_state = 16, .external_lex_state = 3},
  [79] = {.lex_state = 17, .external_lex_state = 3},
  [80] = {.lex_state = 17, .external_lex_state = 3},
  [81] = {.lex_state = 17, .external_lex_state = 3},
  [82] = {.lex_state = 16, .external_lex_state = 4},
  [83] = {.lex_state = 17, .external_lex_state = 2},
  [84] = {.lex_state = 17, .external_lex_state = 2},
  [85] = {.lex_state = 17, .external_lex_state = 2},
  [86] = {.lex_state = 17, .external_lex_state = 2},
  [87] = {.lex_state = 17, .external_lex_state = 2},
  [88] = {.lex_state = 17, .external_lex_state = 2},
  [89] = {.lex_state = 16, .external_lex_state = 3},
  [90] = {.lex_state = 16, .external_lex_state = 4},
  [91] = {.lex_state = 17, .external_lex_state = 2},
  [92] = {.lex_state = 17, .external_lex_state = 2},
  [93] = {.lex_state = 16, .external_lex_state = 3},
  [94] = {.lex_state = 17, .external_lex_state = 2},
  [95] = {.lex_state = 17, .external_lex_state = 2},
  [96] = {.lex_state = 17, .external_lex_state = 2},
  [97] = {.lex_state = 16, .external_lex_state = 3},
  [98] = {.lex_state = 16, .external_lex_state = 3},
  [99] = {.lex_state = 17, .external_lex_state = 2},
  [100] = {.lex_state = 17, .external_lex_state = 2},
  [101] = {.lex_state = 17, .external_lex_state = 2},
  [102] = {.lex_state = 16, .external_lex_state = 3},
  [103] = {.lex_state = 16, .external_lex_state = 3},
  [104] = {.lex_state = 16, .external_lex_state = 3},
  [105] = {.lex_state = 17, .external_lex_state = 2},
  [106] = {.lex_state = 16, .external_lex_state = 3},
  [107] = {.lex_state = 16, .external_lex_state = 3},
  [108] = {.lex_state = 17, .external_lex_state = 2},
  [109] = {.lex_state = 16, .external_lex_state = 3},
  [110] = {.lex_state = 16, .external_lex_state = 3},
  [111] = {.lex_state = 16, .external_lex_state = 3},
  [112] = {.lex_state = 17, .external_lex_state = 2},
  [113] = {.lex_state = 17, .external_lex_state = 2},
  [114] = {.lex_state = 16, .external_lex_state = 3},
  [115] = {.lex_state = 16, .external_lex_state = 4},
  [116] = {.lex_state = 17, .external_lex_state = 2},
  [117] = {.lex_state = 16, .external_lex_state = 3},
  [118] = {.lex_state = 17, .external_lex_state = 4},
  [119] = {.lex_state = 17, .external_lex_state = 2},
  [120] = {.lex_state = 17, .external_lex_state = 2},
  [121] = {.lex_state = 17, .external_lex_state = 2},
  [122] = {.lex_state = 17, .external_lex_state = 2},
  [123] = {.lex_state = 17, .external_lex_state = 2},
  [124] = {.lex_state = 17, .external_lex_state = 2},
  [125] = {.lex_state = 17, .external_lex_state = 2},
  [126] = {.lex_state = 17, .external_lex_state = 2},
  [127] = {.lex_state = 17, .external_lex_state = 2},
  [128] = {.lex_state = 17, .external_lex_state = 2},
  [129] = {.lex_state = 16, .external_lex_state = 4},
  [130] = {.lex_state = 17, .external_lex_state = 2},
  [131] = {.lex_state = 17, .external_lex_state = 2},
  [132] = {.lex_state = 17, .external_lex_state = 2},
  [133] = {.lex_state = 17, .external_lex_state = 2},
  [134] = {.lex_state = 17, .external_lex_state = 2},
  [135] = {.lex_state = 17, .external_lex_state = 2},
  [136] = {.lex_state = 17, .external_lex_state = 2},
  [137] = {.lex_state = 17, .external_lex_state = 2},
  [138] = {.lex_state = 17, .external_lex_state = 2},
  [139] = {.lex_state = 17, .external_lex_state = 2},
  [140] = {.lex_state = 17, .external_lex_state = 4},
  [141] = {.lex_state = 17, .external_lex_state = 2},
  [142] = {.lex_state = 17, .external_lex_state = 2},
  [143] = {.lex_state = 17, .external_lex_state = 2},
  [144] = {.lex_state = 16, .external_lex_state = 4},
  [145] = {.lex_state = 17, .external_lex_state = 4},
  [146] = {.lex_state = 17, .external_lex_state = 2},
  [147] = {.lex_state = 17, .external_lex_state = 2},
  [148] = {.lex_state = 17, .external_lex_state = 2},
  [149] = {.lex_state = 17, .external_lex_state = 2},
  [150] = {.lex_state = 17, .external_lex_state = 2},
  [151] = {.lex_state = 17, .external_lex_state = 2},
  [152] = {.lex_state = 17, .external_lex_state = 2},
  [153] = {.lex_state = 17, .external_lex_state = 2},
  [154] = {.lex_state = 17, .external_lex_state = 2},
  [155] = {.lex_state = 17, .external_lex_state = 3},
  [156] = {.lex_state = 17, .external_lex_state = 3},
  [157] = {.lex_state = 17, .external_lex_state = 3},
  [158] = {.lex_state = 17, .external_lex_state = 3},
  [159] = {.lex_state = 17, .external_lex_state = 3},
  [160] = {.lex_state = 17, .external_lex_state = 3},
  [161] = {.lex_state = 17, .external_lex_state = 3},
  [162] = {.lex_state = 17, .external_lex_state = 3},
  [163] = {.lex_state = 17, .external_lex_state = 3},
  [164] = {.lex_state = 17, .external_lex_state = 3},
  [165] = {.lex_state = 17, .external_lex_state = 3},
  [166] = {.lex_state = 17, .external_lex_state = 3},
  [167] = {.lex_state = 17, .external_lex_state = 3},
  [168] = {.lex_state = 17, .external_lex_state = 3},
  [169] = {.lex_state = 17, .external_lex_state = 3},
  [170] = {.lex_state = 17, .external_lex_state = 3},
  [171] = {.lex_state = 17, .external_lex_state = 3},
  [172] = {.lex_state = 17, .external_lex_state = 3},
  [173] = {.lex_state = 17, .external_lex_state = 3},
  [174] = {.lex_state = 17, .external_lex_state = 3},
  [175] = {.lex_state = 17, .external_lex_state = 3},
  [176] = {.lex_state = 17, .external_lex_state = 3},
  [177] = {.lex_state = 16, .external_lex_state = 4},
  [178] = {.lex_state = 17, .external_lex_state = 3},
  [179] = {.lex_state = 17, .external_lex_state = 3},
  [180] = {.lex_state = 17, .external_lex_state = 3},
  [181] = {.lex_state = 17, .external_lex_state = 3},
  [182] = {.lex_state = 17, .external_lex_state = 3},
  [183] = {.lex_state = 17, .external_lex_state = 3},
  [184] = {.lex_state = 17, .external_lex_state = 3},
  [185] = {.lex_state = 17, .external_lex_state = 3},
  [186] = {.lex_state = 17, .external_lex_state = 3},
  [187] = {.lex_state = 17, .external_lex_state = 3},
  [188] = {.lex_state = 16, .external_lex_state = 4},
  [189] = {.lex_state = 17, .external_lex_state = 2},
  [190] = {.lex_state = 16, .external_lex_state = 4},
  [191] = {.lex_state = 17, .external_lex_state = 2},
  [192] = {.lex_state = 16, .external_lex_state = 4},
  [193] = {.lex_state = 16, .external_lex_state = 4},
  [194] = {.lex_state = 65},
  [195] = {.lex_state = 16, .external_lex_state = 4},
  [196] = {.lex_state = 16, .external_lex_state = 4},
  [197] = {.lex_state = 16, .external_lex_state = 4},
  [198] = {.lex_state = 16, .external_lex_state = 4},
  [199] = {.lex_state = 16, .external_lex_state = 4},
  [200] = {.lex_state = 16, .external_lex_state = 4},
  [201] = {.lex_state = 17, .external_lex_state = 2},
  [202] = {.lex_state = 65},
  [203] = {.lex_state = 16, .external_lex_state = 4},
  [204] = {.lex_state = 17, .external_lex_state = 2},
  [205] = {.lex_state = 17, .external_lex_state = 2},
  [206] = {.lex_state = 17, .external_lex_state = 2},
  [207] = {.lex_state = 65},
  [208] = {.lex_state = 16, .external_lex_state = 4},
  [209] = {.lex_state = 16, .external_lex_state = 4},
  [210] = {.lex_state = 17, .external_lex_state = 4},
  [211] = {.lex_state = 17, .external_lex_state = 4},
  [212] = {.lex_state = 17, .external_lex_state = 4},
  [213] = {.lex_state = 17, .external_lex_state = 4},
  [214] = {.lex_state = 17, .external_lex_state = 4},
  [215] = {.lex_state = 17, .external_lex_state = 4},
  [216] = {.lex_state = 17, .external_lex_state = 4},
  [217] = {.lex_state = 17, .external_lex_state = 4},
  [218] = {.lex_state = 17, .external_lex_state = 4},
  [219] = {.lex_state = 17, .external_lex_state = 4},
  [220] = {.lex_state = 17, .external_lex_state = 4},
  [221] = {.lex_state = 17, .external_lex_state = 4},
  [222] = {.lex_state = 17, .external_lex_state = 4},
  [223] = {.lex_state = 17, .external_lex_state = 4},
  [224] = {.lex_state = 17, .external_lex_state = 4},
  [225] = {.lex_state = 17, .external_lex_state = 4},
  [226] = {.lex_state = 17, .external_lex_state = 4},
  [227] = {.lex_state = 17, .external_lex_state = 4},
  [228] = {.lex_state = 17, .external_lex_state = 4},
  [229] = {.lex_state = 17, .external_lex_state = 4},
  [230] = {.lex_state = 17, .external_lex_state = 4},
  [231] = {.lex_state = 17, .external_lex_state = 4},
  [232] = {.lex_state = 17, .external_lex_state = 4},
  [233] = {.lex_state = 17, .external_lex_state = 4},
  [234] = {.lex_state = 17, .external_lex_state = 4},
  [235] = {.lex_state = 17, .external_lex_state = 4},
  [236] = {.lex_state = 17, .external_lex_state = 4},
  [237] = {.lex_state = 17, .external_lex_state = 4},
  [238] = {.lex_state = 17, .external_lex_state = 4},
  [239] = {.lex_state = 17, .external_lex_state = 4},
  [240] = {.lex_state = 17, .external_lex_state = 4},
  [241] = {.lex_state = 17, .external_lex_state = 4},
  [242] = {.lex_state = 17, .external_lex_state = 2},
  [243] = {.lex_state = 17, .external_lex_state = 2},
  [244] = {.lex_state = 17, .external_lex_state = 2},
  [245] = {.lex_state = 17, .external_lex_state = 2},
  [246] = {.lex_state = 17, .external_lex_state = 2},
  [247] = {.lex_state = 17, .external_lex_state = 2},
  [248] = {.lex_state = 17, .external_lex_state = 2},
  [249] = {.lex_state = 17, .external_lex_state = 2},
  [250] = {.lex_state = 17, .external_lex_state = 2},
  [251] = {.lex_state = 65},
  [252] = {.lex_state = 65},
  [253] = {.lex_state = 65},
  [254] = {.lex_state = 65},
  [255] = {.lex_state = 17, .external_lex_state = 2},
  [256] = {.lex_state = 17, .external_lex_state = 2},
  [257] = {.lex_state = 65},
  [258] = {.lex_state = 17, .external_lex_state = 2},
  [259] = {.lex_state = 25, .external_lex_state = 5},
  [260] = {.lex_state = 25, .external_lex_state = 5},
  [261] = {.lex_state = 25, .external_lex_state = 6},
  [262] = {.lex_state = 27},
  [263] = {.lex_state = 27},
  [264] = {.lex_state = 25, .external_lex_state = 6},
  [265] = {.lex_state = 27},
  [266] = {.lex_state = 27},
  [267] = {.lex_state = 27},
  [268] = {.lex_state = 27},
  [269] = {.lex_state = 27},
  [270] = {.lex_state = 27},
  [271] = {.lex_state = 25, .external_lex_state = 5},
  [272] = {.lex_state = 25, .external_lex_state = 6},
  [273] = {.lex_state = 27},
  [274] = {.lex_state = 27},
  [275] = {.lex_state = 27},
  [276] = {.lex_state = 27},
  [277] = {.lex_state = 24},
  [278] = {.lex_state = 27},
  [279] = {.lex_state = 27},
  [280] = {.lex_state = 27},
  [281] = {.lex_state = 27},
  [282] = {.lex_state = 27},
  [283] = {.lex_state = 27},
  [284] = {.lex_state = 27},
  [285] = {.lex_state = 27},
  [286] = {.lex_state = 27},
  [287] = {.lex_state = 27},
  [288] = {.lex_state = 27},
  [289] = {.lex_state = 27},
  [290] = {.lex_state = 27},
  [291] = {.lex_state = 27},
  [292] = {.lex_state = 27},
  [293] = {.lex_state = 27},
  [294] = {.lex_state = 27},
  [295] = {.lex_state = 27},
  [296] = {.lex_state = 65},
  [297] = {.lex_state = 27},
  [298] = {.lex_state = 27, .external_lex_state = 5},
  [299] = {.lex_state = 65},
  [300] = {.lex_state = 27},
  [301] = {.lex_state = 27},
  [302] = {.lex_state = 27, .external_lex_state = 5},
  [303] = {.lex_state = 27},
  [304] = {.lex_state = 27},
  [305] = {.lex_state = 27},
  [306] = {.lex_state = 27},
  [307] = {.lex_state = 27},
  [308] = {.lex_state = 27},
  [309] = {.lex_state = 27},
  [310] = {.lex_state = 27},
  [311] = {.lex_state = 27},
  [312] = {.lex_state = 27},
  [313] = {.lex_state = 27},
  [314] = {.lex_state = 65},
  [315] = {.lex_state = 27},
  [316] = {.lex_state = 27},
  [317] = {.lex_state = 27},
  [318] = {.lex_state = 27},
  [319] = {.lex_state = 65},
  [320] = {.lex_state = 27, .external_lex_state = 5},
  [321] = {.lex_state = 65},
  [322] = {.lex_state = 27, .external_lex_state = 5},
  [323] = {.lex_state = 27, .external_lex_state = 5},
  [324] = {.lex_state = 65},
  [325] = {.lex_state = 65},
  [326] = {.lex_state = 65},
  [327] = {.lex_state = 65},
  [328] = {.lex_state = 65},
  [329] = {.lex_state = 27, .external_lex_state = 5},
  [330] = {.lex_state = 27, .external_lex_state = 6},
  [331] = {.lex_state = 27, .external_lex_state = 6},
  [332] = {.lex_state = 27, .external_lex_state = 5},
  [333] = {.lex_state = 27, .external_lex_state = 5},
  [334] = {.lex_state = 27, .external_lex_state = 5},
  [335] = {.lex_state = 27, .external_lex_state = 6},
  [336] = {.lex_state = 27, .external_lex_state = 5},
  [337] = {.lex_state = 65},
  [338] = {.lex_state = 65},
  [339] = {.lex_state = 65},
  [340] = {.lex_state = 27, .external_lex_state = 6},
  [341] = {.lex_state = 27, .external_lex_state = 6},
  [342] = {.lex_state = 65},
  [343] = {.lex_state = 65},
  [344] = {.lex_state = 65},
  [345] = {.lex_state = 27, .external_lex_state = 5},
  [346] = {.lex_state = 27, .external_lex_state = 6},
  [347] = {.lex_state = 27, .external_lex_state = 5},
  [348] = {.lex_state = 27, .external_lex_state = 5},
  [349] = {.lex_state = 27, .external_lex_state = 5},
  [350] = {.lex_state = 27, .external_lex_state = 5},
  [351] = {.lex_state = 65},
  [352] = {.lex_state = 27, .external_lex_state = 5},
  [353] = {.lex_state = 27, .external_lex_state = 5},
  [354] = {.lex_state = 27, .external_lex_state = 5},
  [355] = {.lex_state = 65},
  [356] = {.lex_state = 27, .external_lex_state = 5},
  [357] = {.lex_state = 27, .external_lex_state = 5},
  [358] = {.lex_state = 27, .external_lex_state = 5},
  [359] = {.lex_state = 27, .external_lex_state = 5},
  [360] = {.lex_state = 27, .external_lex_state = 5},
  [361] = {.lex_state = 27, .external_lex_state = 5},
  [362] = {.lex_state = 65},
  [363] = {.lex_state = 27, .external_lex_state = 5},
  [364] = {.lex_state = 27, .external_lex_state = 5},
  [365] = {.lex_state = 27, .external_lex_state = 5},
  [366] = {.lex_state = 27, .external_lex_state = 5},
  [367] = {.lex_state = 27, .external_lex_state = 5},
  [368] = {.lex_state = 27, .external_lex_state = 5},
  [369] = {.lex_state = 27, .external_lex_state = 5},
  [370] = {.lex_state = 27, .external_lex_state = 5},
  [371] = {.lex_state = 27, .external_lex_state = 5},
  [372] = {.lex_state = 27, .external_lex_state = 5},
  [373] = {.lex_state = 27, .external_lex_state = 5},
  [374] = {.lex_state = 27, .external_lex_state = 5},
  [375] = {.lex_state = 65},
  [376] = {.lex_state = 27, .external_lex_state = 5},
  [377] = {.lex_state = 27, .external_lex_state = 5},
  [378] = {.lex_state = 27, .external_lex_state = 5},
  [379] = {.lex_state = 27, .external_lex_state = 5},
  [380] = {.lex_state = 27, .external_lex_state = 5},
  [381] = {.lex_state = 27, .external_lex_state = 5},
  [382] = {.lex_state = 65},
  [383] = {.lex_state = 65},
  [384] = {.lex_state = 27, .external_lex_state = 5},
  [385] = {.lex_state = 27, .external_lex_state = 5},
  [386] = {.lex_state = 27, .external_lex_state = 5},
  [387] = {.lex_state = 65},
  [388] = {.lex_state = 65},
  [389] = {.lex_state = 65},
  [390] = {.lex_state = 65},
  [391] = {.lex_state = 65},
  [392] = {.lex_state = 65},
  [393] = {.lex_state = 65},
  [394] = {.lex_state = 65},
  [395] = {.lex_state = 65},
  [396] = {.lex_state = 65},
  [397] = {.lex_state = 65},
  [398] = {.lex_state = 65},
  [399] = {.lex_state = 65},
  [400] = {.lex_state = 65},
  [401] = {.lex_state = 65},
  [402] = {.lex_state = 65},
  [403] = {.lex_state = 65},
  [404] = {.lex_state = 65},
  [405] = {.lex_state = 65},
  [406] = {.lex_state = 27, .external_lex_state = 6},
  [407] = {.lex_state = 27, .external_lex_state = 5},
  [408] = {.lex_state = 27, .external_lex_state = 6},
  [409] = {.lex_state = 27, .external_lex_state = 6},
  [410] = {.lex_state = 27, .external_lex_state = 6},
  [411] = {.lex_state = 65},
  [412] = {.lex_state = 27, .external_lex_state = 6},
  [413] = {.lex_state = 27, .external_lex_state = 6},
  [414] = {.lex_state = 27, .external_lex_state = 6},
  [415] = {.lex_state = 27, .external_lex_state = 6},
  [416] = {.lex_state = 27, .external_lex_state = 6},
  [417] = {.lex_state = 27, .external_lex_state = 6},
  [418] = {.lex_state = 27, .external_lex_state = 6},
  [419] = {.lex_state = 27, .external_lex_state = 6},
  [420] = {.lex_state = 27, .external_lex_state = 6},
  [421] = {.lex_state = 27, .external_lex_state = 6},
  [422] = {.lex_state = 27, .external_lex_state = 6},
  [423] = {.lex_state = 27, .external_lex_state = 6},
  [424] = {.lex_state = 27, .external_lex_state = 6},
  [425] = {.lex_state = 27, .external_lex_state = 6},
  [426] = {.lex_state = 27, .external_lex_state = 6},
  [427] = {.lex_state = 27, .external_lex_state = 6},
  [428] = {.lex_state = 27},
  [429] = {.lex_state = 27},
  [430] = {.lex_state = 27},
  [431] = {.lex_state = 27, .external_lex_state = 6},
  [432] = {.lex_state = 27, .external_lex_state = 6},
  [433] = {.lex_state = 27, .external_lex_state = 6},
  [434] = {.lex_state = 27},
  [435] = {.lex_state = 27},
  [436] = {.lex_state = 27},
  [437] = {.lex_state = 27},
  [438] = {.lex_state = 27, .external_lex_state = 6},
  [439] = {.lex_state = 27},
  [440] = {.lex_state = 27},
  [441] = {.lex_state = 27},
  [442] = {.lex_state = 27},
  [443] = {.lex_state = 27},
  [444] = {.lex_state = 27, .external_lex_state = 6},
  [445] = {.lex_state = 27, .external_lex_state = 6},
  [446] = {.lex_state = 27, .external_lex_state = 6},
  [447] = {.lex_state = 27, .external_lex_state = 6},
  [448] = {.lex_state = 27, .external_lex_state = 6},
  [449] = {.lex_state = 27, .external_lex_state = 6},
  [450] = {.lex_state = 27, .external_lex_state = 6},
  [451] = {.lex_state = 27, .external_lex_state = 6},
  [452] = {.lex_state = 27, .external_lex_state = 6},
  [453] = {.lex_state = 27},
  [454] = {.lex_state = 27, .external_lex_state = 6},
  [455] = {.lex_state = 27, .external_lex_state = 6},
  [456] = {.lex_state = 27, .external_lex_state = 6},
  [457] = {.lex_state = 27, .external_lex_state = 6},
  [458] = {.lex_state = 27, .external_lex_state = 6},
  [459] = {.lex_state = 27, .external_lex_state = 6},
  [460] = {.lex_state = 27, .external_lex_state = 6},
  [461] = {.lex_state = 65},
  [462] = {.lex_state = 65},
  [463] = {.lex_state = 65},
  [464] = {.lex_state = 65},
  [465] = {.lex_state = 65},
  [466] = {.lex_state = 65},
  [467] = {.lex_state = 65},
  [468] = {.lex_state = 65},
  [469] = {.lex_state = 65},
  [470] = {.lex_state = 65},
  [471] = {.lex_state = 65},
  [472] = {.lex_state = 65},
  [473] = {.lex_state = 65},
  [474] = {.lex_state = 65},
  [475] = {.lex_state = 65},
  [476] = {.lex_state = 65},
  [477] = {.lex_state = 65},
  [478] = {.lex_state = 65},
  [479] = {.lex_state = 65},
  [480] = {.lex_state = 65},
  [481] = {.lex_state = 65},
  [482] = {.lex_state = 65},
  [483] = {.lex_state = 65},
  [484] = {.lex_state = 65},
  [485] = {.lex_state = 65},
  [486] = {.lex_state = 65},
  [487] = {.lex_state = 65},
  [488] = {.lex_state = 65},
  [489] = {.lex_state = 65},
  [490] = {.lex_state = 65},
  [491] = {.lex_state = 65},
  [492] = {.lex_state = 65},
  [493] = {.lex_state = 65},
  [494] = {.lex_state = 65},
  [495] = {.lex_state = 65},
  [496] = {.lex_state = 17, .external_lex_state = 2},
  [497] = {.lex_state = 17, .external_lex_state = 2},
  [498] = {.lex_state = 65},
  [499] = {.lex_state = 65},
  [500] = {.lex_state = 65},
  [501] = {.lex_state = 65},
  [502] = {.lex_state = 65},
  [503] = {.lex_state = 65},
  [504] = {.lex_state = 65, .external_lex_state = 5},
  [505] = {.lex_state = 65, .external_lex_state = 5},
  [506] = {.lex_state = 65, .external_lex_state = 5},
  [507] = {.lex_state = 65},
  [508] = {.lex_state = 65},
  [509] = {.lex_state = 65},
  [510] = {.lex_state = 65},
  [511] = {.lex_state = 65, .external_lex_state = 6},
  [512] = {.lex_state = 65},
  [513] = {.lex_state = 65},
  [514] = {.lex_state = 65, .external_lex_state = 6},
  [515] = {.lex_state = 65},
  [516] = {.lex_state = 65, .external_lex_state = 6},
  [517] = {.lex_state = 65},
  [518] = {.lex_state = 65},
  [519] = {.lex_state = 65, .external_lex_state = 6},
  [520] = {.lex_state = 65},
  [521] = {.lex_state = 65, .external_lex_state = 6},
  [522] = {.lex_state = 65, .external_lex_state = 6},
  [523] = {.lex_state = 65},
  [524] = {.lex_state = 65},
  [525] = {.lex_state = 65},
  [526] = {.lex_state = 65},
  [527] = {.lex_state = 65},
  [528] = {.lex_state = 65, .external_lex_state = 6},
  [529] = {.lex_state = 65, .external_lex_state = 5},
  [530] = {.lex_state = 65},
  [531] = {.lex_state = 65, .external_lex_state = 6},
  [532] = {.lex_state = 65, .external_lex_state = 6},
  [533] = {.lex_state = 65, .external_lex_state = 6},
  [534] = {.lex_state = 65},
  [535] = {.lex_state = 65},
  [536] = {.lex_state = 65},
  [537] = {.lex_state = 65},
  [538] = {.lex_state = 65},
  [539] = {.lex_state = 65},
  [540] = {.lex_state = 65},
  [541] = {.lex_state = 65},
  [542] = {.lex_state = 24},
  [543] = {.lex_state = 65},
  [544] = {.lex_state = 65},
  [545] = {.lex_state = 65, .external_lex_state = 5},
  [546] = {.lex_state = 65, .external_lex_state = 5},
  [547] = {.lex_state = 65, .external_lex_state = 5},
  [548] = {.lex_state = 65, .external_lex_state = 5},
  [549] = {.lex_state = 65},
  [550] = {.lex_state = 65, .external_lex_state = 5},
  [551] = {.lex_state = 65, .external_lex_state = 6},
  [552] = {.lex_state = 65},
  [553] = {.lex_state = 65, .external_lex_state = 5},
  [554] = {.lex_state = 65, .external_lex_state = 5},
  [555] = {.lex_state = 65, .external_lex_state = 5},
  [556] = {.lex_state = 65, .external_lex_state = 5},
  [557] = {.lex_state = 65, .external_lex_state = 5},
  [558] = {.lex_state = 65, .external_lex_state = 6},
  [559] = {.lex_state = 65, .external_lex_state = 6},
  [560] = {.lex_state = 65, .external_lex_state = 6},
  [561] = {.lex_state = 65, .external_lex_state = 6},
  [562] = {.lex_state = 65, .external_lex_state = 6},
  [563] = {.lex_state = 65, .external_lex_state = 6},
  [564] = {.lex_state = 65, .external_lex_state = 6},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 65, .external_lex_state = 6},
  [567] = {.lex_state = 65, .external_lex_state = 6},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 65, .external_lex_state = 6},
  [570] = {.lex_state = 65, .external_lex_state = 6},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 65, .external_lex_state = 6},
  [573] = {.lex_state = 65, .external_lex_state = 6},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 65, .external_lex_state = 6},
  [576] = {.lex_state = 65, .external_lex_state = 6},
  [577] = {.lex_state = 65, .external_lex_state = 6},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 65, .external_lex_state = 6},
  [581] = {.lex_state = 65, .external_lex_state = 6},
  [582] = {.lex_state = 65, .external_lex_state = 6},
  [583] = {.lex_state = 65, .external_lex_state = 6},
  [584] = {.lex_state = 65, .external_lex_state = 6},
  [585] = {.lex_state = 9},
  [586] = {.lex_state = 21},
  [587] = {.lex_state = 65},
  [588] = {.lex_state = 65},
  [589] = {.lex_state = 0, .external_lex_state = 6},
  [590] = {.lex_state = 21},
  [591] = {.lex_state = 9},
  [592] = {.lex_state = 21},
  [593] = {.lex_state = 9},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0, .external_lex_state = 5},
  [596] = {.lex_state = 21},
  [597] = {.lex_state = 9},
  [598] = {.lex_state = 21},
  [599] = {.lex_state = 9},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0, .external_lex_state = 5},
  [602] = {.lex_state = 21},
  [603] = {.lex_state = 9},
  [604] = {.lex_state = 21},
  [605] = {.lex_state = 9},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 65},
  [608] = {.lex_state = 0, .external_lex_state = 5},
  [609] = {.lex_state = 21},
  [610] = {.lex_state = 9},
  [611] = {.lex_state = 21},
  [612] = {.lex_state = 9},
  [613] = {.lex_state = 0, .external_lex_state = 5},
  [614] = {.lex_state = 21},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 21},
  [617] = {.lex_state = 9},
  [618] = {.lex_state = 0, .external_lex_state = 5},
  [619] = {.lex_state = 21},
  [620] = {.lex_state = 9},
  [621] = {.lex_state = 21},
  [622] = {.lex_state = 9},
  [623] = {.lex_state = 21},
  [624] = {.lex_state = 21},
  [625] = {.lex_state = 9},
  [626] = {.lex_state = 9},
  [627] = {.lex_state = 65},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0, .external_lex_state = 5},
  [630] = {.lex_state = 0, .external_lex_state = 5},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 65},
  [633] = {.lex_state = 65},
  [634] = {.lex_state = 65, .external_lex_state = 5},
  [635] = {.lex_state = 65},
  [636] = {.lex_state = 0, .external_lex_state = 5},
  [637] = {.lex_state = 0, .external_lex_state = 5},
  [638] = {.lex_state = 65, .external_lex_state = 5},
  [639] = {.lex_state = 65, .external_lex_state = 5},
  [640] = {.lex_state = 65, .external_lex_state = 6},
  [641] = {.lex_state = 65},
  [642] = {.lex_state = 0, .external_lex_state = 5},
  [643] = {.lex_state = 65},
  [644] = {.lex_state = 0, .external_lex_state = 5},
  [645] = {.lex_state = 65},
  [646] = {.lex_state = 0, .external_lex_state = 5},
  [647] = {.lex_state = 65},
  [648] = {.lex_state = 65, .external_lex_state = 6},
  [649] = {.lex_state = 65, .external_lex_state = 6},
  [650] = {.lex_state = 21},
  [651] = {.lex_state = 65, .external_lex_state = 6},
  [652] = {.lex_state = 65},
  [653] = {.lex_state = 65},
  [654] = {.lex_state = 9},
  [655] = {.lex_state = 65},
  [656] = {.lex_state = 65, .external_lex_state = 6},
  [657] = {.lex_state = 0, .external_lex_state = 5},
  [658] = {.lex_state = 65},
  [659] = {.lex_state = 65},
  [660] = {.lex_state = 65},
  [661] = {.lex_state = 65},
  [662] = {.lex_state = 0, .external_lex_state = 5},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 65, .external_lex_state = 5},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0, .external_lex_state = 6},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 35},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 35},
  [682] = {.lex_state = 0, .external_lex_state = 5},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 35},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 65, .external_lex_state = 6},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 35},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 35},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0, .external_lex_state = 5},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 65, .external_lex_state = 6},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 35},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 35},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 13},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0, .external_lex_state = 5},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 35},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 35},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0, .external_lex_state = 5},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 35},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 35},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 35},
  [744] = {.lex_state = 65, .external_lex_state = 5},
  [745] = {.lex_state = 65, .external_lex_state = 5},
  [746] = {.lex_state = 13},
  [747] = {.lex_state = 0, .external_lex_state = 5},
  [748] = {.lex_state = 35},
  [749] = {.lex_state = 65, .external_lex_state = 6},
  [750] = {.lex_state = 0, .external_lex_state = 5},
  [751] = {.lex_state = 0, .external_lex_state = 5},
  [752] = {.lex_state = 13},
  [753] = {.lex_state = 0, .external_lex_state = 5},
  [754] = {.lex_state = 0, .external_lex_state = 5},
  [755] = {.lex_state = 13},
  [756] = {.lex_state = 0, .external_lex_state = 5},
  [757] = {.lex_state = 0, .external_lex_state = 5},
  [758] = {.lex_state = 13},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0, .external_lex_state = 5},
  [761] = {.lex_state = 0, .external_lex_state = 5},
  [762] = {.lex_state = 13},
  [763] = {.lex_state = 13},
  [764] = {.lex_state = 0, .external_lex_state = 5},
  [765] = {.lex_state = 0, .external_lex_state = 5},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 65, .external_lex_state = 6},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0, .external_lex_state = 7},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0, .external_lex_state = 7},
  [775] = {.lex_state = 0, .external_lex_state = 5},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0, .external_lex_state = 7},
  [779] = {.lex_state = 65},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 65},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 65, .external_lex_state = 6},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 65},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0, .external_lex_state = 7},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 65, .external_lex_state = 6},
  [796] = {.lex_state = 65},
  [797] = {.lex_state = 0, .external_lex_state = 5},
  [798] = {.lex_state = 0, .external_lex_state = 5},
  [799] = {.lex_state = 65},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 65, .external_lex_state = 6},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 65},
  [808] = {.lex_state = 65},
  [809] = {.lex_state = 0, .external_lex_state = 6},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 65},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 65},
  [815] = {.lex_state = 65, .external_lex_state = 6},
  [816] = {.lex_state = 65},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0, .external_lex_state = 5},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 65},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 65},
  [826] = {.lex_state = 0, .external_lex_state = 7},
  [827] = {.lex_state = 35},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0, .external_lex_state = 5},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0, .external_lex_state = 7},
  [840] = {.lex_state = 35},
  [841] = {.lex_state = 0, .external_lex_state = 5},
  [842] = {.lex_state = 65},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0, .external_lex_state = 8},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 35},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0, .external_lex_state = 7},
  [850] = {.lex_state = 65},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 65},
  [854] = {.lex_state = 0, .external_lex_state = 7},
  [855] = {.lex_state = 0, .external_lex_state = 6},
  [856] = {.lex_state = 0, .external_lex_state = 7},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 65},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 35},
  [871] = {.lex_state = 0, .external_lex_state = 6},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 35},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0, .external_lex_state = 6},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0, .external_lex_state = 6},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 65},
  [884] = {.lex_state = 0, .external_lex_state = 7},
  [885] = {.lex_state = 65},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 35},
  [888] = {.lex_state = 35},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 65},
  [898] = {.lex_state = 65},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 65},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0, .external_lex_state = 6},
  [904] = {.lex_state = 0, .external_lex_state = 6},
  [905] = {.lex_state = 35},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0, .external_lex_state = 8},
  [909] = {.lex_state = 0, .external_lex_state = 6},
  [910] = {.lex_state = 0, .external_lex_state = 6},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 35},
  [913] = {.lex_state = 0, .external_lex_state = 6},
  [914] = {.lex_state = 0, .external_lex_state = 6},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0, .external_lex_state = 8},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0, .external_lex_state = 8},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0, .external_lex_state = 7},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 65},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 65},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0, .external_lex_state = 7},
  [929] = {.lex_state = 0, .external_lex_state = 6},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 24},
  [933] = {.lex_state = 35},
  [934] = {.lex_state = 0, .external_lex_state = 6},
  [935] = {.lex_state = 0, .external_lex_state = 6},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0, .external_lex_state = 9},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 35},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0, .external_lex_state = 6},
  [942] = {.lex_state = 0, .external_lex_state = 6},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0, .external_lex_state = 6},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 35},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0, .external_lex_state = 6},
  [949] = {.lex_state = 65},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0, .external_lex_state = 8},
  [952] = {.lex_state = 0, .external_lex_state = 8},
  [953] = {.lex_state = 35},
  [954] = {.lex_state = 0, .external_lex_state = 6},
  [955] = {.lex_state = 0, .external_lex_state = 8},
  [956] = {.lex_state = 0, .external_lex_state = 8},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0, .external_lex_state = 8},
  [959] = {.lex_state = 0, .external_lex_state = 8},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0, .external_lex_state = 8},
  [962] = {.lex_state = 0, .external_lex_state = 8},
  [963] = {.lex_state = 0, .external_lex_state = 8},
  [964] = {.lex_state = 0, .external_lex_state = 8},
  [965] = {.lex_state = 0, .external_lex_state = 8},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0, .external_lex_state = 8},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0, .external_lex_state = 8},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0, .external_lex_state = 8},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 35},
  [992] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_lower_case_identifier] = ACTIONS(1),
    [anon_sym_LBRACE_DASH] = ACTIONS(3),
    [anon_sym_DASH_RBRACE] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym__upper_case_identifier_without_leading_whitespace] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_left] = ACTIONS(1),
    [anon_sym_right] = ACTIONS(1),
    [anon_sym_non] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [sym_string_escape] = ACTIONS(1),
    [sym_module] = ACTIONS(1),
    [sym_effect] = ACTIONS(1),
    [sym_where] = ACTIONS(1),
    [sym_import] = ACTIONS(1),
    [sym_as] = ACTIONS(1),
    [sym_exposing] = ACTIONS(1),
    [sym_when] = ACTIONS(1),
    [sym_is] = ACTIONS(1),
    [sym_type] = ACTIONS(1),
    [sym_alias] = ACTIONS(1),
    [sym_port] = ACTIONS(1),
    [sym_infix] = ACTIONS(1),
    [sym_double_dot] = ACTIONS(1),
    [sym_eq] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_dot] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_LT_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_QMARK_GT] = ACTIONS(1),
    [anon_sym_PIPE_DOT] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [sym__virtual_end_decl] = ACTIONS(1),
    [sym__virtual_open_section] = ACTIONS(1),
    [sym__virtual_end_section] = ACTIONS(1),
    [sym_minus_without_trailing_whitespace] = ACTIONS(1),
    [sym__block_comment_content] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(950),
    [sym_block_comment] = STATE(1),
    [sym_module_declaration] = STATE(948),
    [aux_sym__import_list] = STATE(207),
    [aux_sym__top_decl_list] = STATE(251),
    [sym_upper_case_qid] = STATE(314),
    [sym_import_clause] = STATE(881),
    [sym_value_declaration] = STATE(954),
    [sym_function_declaration_left] = STATE(926),
    [sym_type_declaration] = STATE(954),
    [sym_type_alias_declaration] = STATE(954),
    [sym_type_annotation] = STATE(954),
    [sym_port_annotation] = STATE(954),
    [sym__literal_expr_group] = STATE(481),
    [sym_char_constant_expr] = STATE(486),
    [sym_number_constant_expr] = STATE(486),
    [sym_string_constant_expr] = STATE(486),
    [sym_unit_expr] = STATE(481),
    [sym_pattern] = STATE(924),
    [sym_cons_pattern] = STATE(493),
    [sym__single_pattern_cons] = STATE(878),
    [sym__single_pattern] = STATE(494),
    [sym_lower_pattern] = STATE(481),
    [sym_anything_pattern] = STATE(481),
    [sym_record_pattern] = STATE(481),
    [sym_list_pattern] = STATE(481),
    [sym_union_pattern] = STATE(481),
    [sym__parenthesized_pattern] = STATE(487),
    [sym_infix_declaration] = STATE(954),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_lower_case_identifier] = ACTIONS(9),
    [anon_sym_LBRACE_DASH] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(21),
    [sym_upper_case_identifier] = ACTIONS(23),
    [sym_number_literal] = ACTIONS(25),
    [sym_module] = ACTIONS(27),
    [sym_effect] = ACTIONS(29),
    [sym_import] = ACTIONS(31),
    [sym_type] = ACTIONS(33),
    [sym_port] = ACTIONS(35),
    [sym_infix] = ACTIONS(37),
    [sym_underscore] = ACTIONS(39),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(70),
    [sym_operator_as_function_expr] = STATE(70),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__atom] = STATE(72),
    [sym_field_access_expr] = STATE(29),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(70),
    [sym_parenthesized_expr] = STATE(29),
    [sym__literal_expr_group] = STATE(70),
    [sym_char_constant_expr] = STATE(60),
    [sym_number_constant_expr] = STATE(60),
    [sym_string_constant_expr] = STATE(60),
    [sym_anonymous_function_expr] = STATE(70),
    [sym_value_expr] = STATE(29),
    [sym_unit_expr] = STATE(70),
    [sym_list_expr] = STATE(70),
    [sym_record_expr] = STATE(29),
    [sym_if_else_expr] = STATE(70),
    [sym__if] = STATE(820),
    [sym_when_is_expr] = STATE(70),
    [sym_let_in_expr] = STATE(70),
    [aux_sym_function_call_expr_repeat1] = STATE(4),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(48),
    [anon_sym_COMMA] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_RBRACE] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(56),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(62),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(51),
    [anon_sym_else] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(68),
    [anon_sym_then] = ACTIONS(51),
    [anon_sym_let] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [sym_upper_case_identifier] = ACTIONS(74),
    [sym_number_literal] = ACTIONS(77),
    [sym_when] = ACTIONS(80),
    [sym_is] = ACTIONS(51),
    [sym_backslash] = ACTIONS(83),
    [sym_dot] = ACTIONS(86),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_SLASH_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_SLASH_EQ] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_PLUS_PLUS] = ACTIONS(51),
    [anon_sym_LT_PIPE] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(51),
    [anon_sym_LT_SLASH_GT] = ACTIONS(51),
    [anon_sym_LT_QMARK_GT] = ACTIONS(51),
    [anon_sym_PIPE_DOT] = ACTIONS(51),
    [anon_sym_PIPE_EQ] = ACTIONS(51),
    [sym_minus_without_trailing_whitespace] = ACTIONS(89),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(70),
    [sym_operator_as_function_expr] = STATE(70),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__atom] = STATE(72),
    [sym_field_access_expr] = STATE(29),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(70),
    [sym_parenthesized_expr] = STATE(29),
    [sym__literal_expr_group] = STATE(70),
    [sym_char_constant_expr] = STATE(60),
    [sym_number_constant_expr] = STATE(60),
    [sym_string_constant_expr] = STATE(60),
    [sym_anonymous_function_expr] = STATE(70),
    [sym_value_expr] = STATE(29),
    [sym_unit_expr] = STATE(70),
    [sym_list_expr] = STATE(70),
    [sym_record_expr] = STATE(29),
    [sym_if_else_expr] = STATE(70),
    [sym__if] = STATE(820),
    [sym_when_is_expr] = STATE(70),
    [sym_let_in_expr] = STATE(70),
    [aux_sym_function_call_expr_repeat1] = STATE(4),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(94),
    [anon_sym_COMMA] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(96),
    [anon_sym_RBRACE] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(98),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(100),
    [anon_sym_DQUOTE] = ACTIONS(102),
    [anon_sym_LBRACK] = ACTIONS(104),
    [anon_sym_RBRACK] = ACTIONS(51),
    [anon_sym_else] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_then] = ACTIONS(51),
    [anon_sym_let] = ACTIONS(108),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(112),
    [sym_when] = ACTIONS(114),
    [sym_is] = ACTIONS(51),
    [sym_backslash] = ACTIONS(116),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_SLASH_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_SLASH_EQ] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_PLUS_PLUS] = ACTIONS(51),
    [anon_sym_LT_PIPE] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(51),
    [anon_sym_LT_SLASH_GT] = ACTIONS(51),
    [anon_sym_LT_QMARK_GT] = ACTIONS(51),
    [anon_sym_PIPE_DOT] = ACTIONS(51),
    [anon_sym_PIPE_EQ] = ACTIONS(51),
    [sym_minus_without_trailing_whitespace] = ACTIONS(120),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(70),
    [sym_operator_as_function_expr] = STATE(70),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__atom] = STATE(72),
    [sym_field_access_expr] = STATE(29),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(70),
    [sym_parenthesized_expr] = STATE(29),
    [sym__literal_expr_group] = STATE(70),
    [sym_char_constant_expr] = STATE(60),
    [sym_number_constant_expr] = STATE(60),
    [sym_string_constant_expr] = STATE(60),
    [sym_anonymous_function_expr] = STATE(70),
    [sym_value_expr] = STATE(29),
    [sym_unit_expr] = STATE(70),
    [sym_list_expr] = STATE(70),
    [sym_record_expr] = STATE(29),
    [sym_if_else_expr] = STATE(70),
    [sym__if] = STATE(820),
    [sym_when_is_expr] = STATE(70),
    [sym_let_in_expr] = STATE(70),
    [aux_sym_function_call_expr_repeat1] = STATE(4),
    [sym_lower_case_identifier] = ACTIONS(122),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(125),
    [anon_sym_COMMA] = ACTIONS(128),
    [anon_sym_RPAREN] = ACTIONS(128),
    [anon_sym_LBRACE] = ACTIONS(130),
    [anon_sym_RBRACE] = ACTIONS(128),
    [anon_sym_SQUOTE] = ACTIONS(133),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(136),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(142),
    [anon_sym_RBRACK] = ACTIONS(128),
    [anon_sym_else] = ACTIONS(128),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_then] = ACTIONS(128),
    [anon_sym_let] = ACTIONS(148),
    [anon_sym_COLON_COLON] = ACTIONS(128),
    [sym_upper_case_identifier] = ACTIONS(151),
    [sym_number_literal] = ACTIONS(154),
    [sym_when] = ACTIONS(157),
    [sym_is] = ACTIONS(128),
    [sym_backslash] = ACTIONS(160),
    [sym_dot] = ACTIONS(163),
    [anon_sym_PLUS] = ACTIONS(128),
    [anon_sym_DASH] = ACTIONS(128),
    [anon_sym_STAR] = ACTIONS(128),
    [anon_sym_SLASH] = ACTIONS(128),
    [anon_sym_SLASH_SLASH] = ACTIONS(128),
    [anon_sym_CARET] = ACTIONS(128),
    [anon_sym_EQ_EQ] = ACTIONS(128),
    [anon_sym_SLASH_EQ] = ACTIONS(128),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(128),
    [anon_sym_LT_EQ] = ACTIONS(128),
    [anon_sym_GT_EQ] = ACTIONS(128),
    [anon_sym_AMP_AMP] = ACTIONS(128),
    [anon_sym_PIPE_PIPE] = ACTIONS(128),
    [anon_sym_PLUS_PLUS] = ACTIONS(128),
    [anon_sym_LT_PIPE] = ACTIONS(128),
    [anon_sym_PIPE_GT] = ACTIONS(128),
    [anon_sym_LT_LT] = ACTIONS(128),
    [anon_sym_GT_GT] = ACTIONS(128),
    [anon_sym_LT_SLASH_GT] = ACTIONS(128),
    [anon_sym_LT_QMARK_GT] = ACTIONS(128),
    [anon_sym_PIPE_DOT] = ACTIONS(128),
    [anon_sym_PIPE_EQ] = ACTIONS(128),
    [sym_minus_without_trailing_whitespace] = ACTIONS(166),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(981),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(982),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(189),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(872),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(873),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(197),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(966),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(983),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(197),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(981),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(982),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(199),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(201),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(966),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(983),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(205),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(920),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(896),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(207),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(209),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(920),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(896),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(211),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(213),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(863),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(921),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(199),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(201),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_upper_case_qid] = STATE(40),
    [sym_value_qid] = STATE(40),
    [sym_field_accessor_function_expr] = STATE(42),
    [sym__expression] = STATE(895),
    [sym_bin_op_expr] = STATE(300),
    [sym_operator_as_function_expr] = STATE(42),
    [sym__operator_as_function_inner] = STATE(75),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(303),
    [sym__function_call_target] = STATE(245),
    [sym__atom] = STATE(303),
    [sym_field_access_expr] = STATE(38),
    [sym__field_access_start] = STATE(641),
    [sym_negate_expr] = STATE(306),
    [sym_parenthesized_expr] = STATE(38),
    [sym__literal_expr_group] = STATE(306),
    [sym_char_constant_expr] = STATE(309),
    [sym_number_constant_expr] = STATE(309),
    [sym_string_constant_expr] = STATE(309),
    [sym_anonymous_function_expr] = STATE(306),
    [sym_value_expr] = STATE(38),
    [sym_unit_expr] = STATE(306),
    [sym_list_expr] = STATE(306),
    [sym_record_expr] = STATE(284),
    [sym_if_else_expr] = STATE(306),
    [sym__if] = STATE(802),
    [sym_when_is_expr] = STATE(306),
    [sym_let_in_expr] = STATE(306),
    [sym_operator_identifier] = STATE(869),
    [sym_lower_case_identifier] = ACTIONS(92),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(169),
    [anon_sym_RPAREN] = ACTIONS(207),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [sym_upper_case_identifier] = ACTIONS(110),
    [sym_number_literal] = ACTIONS(187),
    [sym_when] = ACTIONS(209),
    [sym_backslash] = ACTIONS(191),
    [sym_dot] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_SLASH_SLASH] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_EQ_EQ] = ACTIONS(185),
    [anon_sym_SLASH_EQ] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(185),
    [anon_sym_LT_EQ] = ACTIONS(185),
    [anon_sym_GT_EQ] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_LT_LT] = ACTIONS(185),
    [anon_sym_GT_GT] = ACTIONS(185),
    [anon_sym_LT_SLASH_GT] = ACTIONS(185),
    [anon_sym_LT_QMARK_GT] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_PIPE_EQ] = ACTIONS(185),
    [sym_minus_without_trailing_whitespace] = ACTIONS(193),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_upper_case_qid] = STATE(98),
    [sym_value_qid] = STATE(98),
    [sym_field_accessor_function_expr] = STATE(174),
    [sym_operator_as_function_expr] = STATE(174),
    [sym__operator_as_function_inner] = STATE(171),
    [sym__atom] = STATE(175),
    [sym_field_access_expr] = STATE(110),
    [sym__field_access_start] = STATE(635),
    [sym_negate_expr] = STATE(174),
    [sym_parenthesized_expr] = STATE(110),
    [sym__literal_expr_group] = STATE(174),
    [sym_char_constant_expr] = STATE(164),
    [sym_number_constant_expr] = STATE(164),
    [sym_string_constant_expr] = STATE(164),
    [sym_anonymous_function_expr] = STATE(174),
    [sym_value_expr] = STATE(110),
    [sym_unit_expr] = STATE(174),
    [sym_list_expr] = STATE(174),
    [sym_record_expr] = STATE(110),
    [sym_if_else_expr] = STATE(174),
    [sym__if] = STATE(833),
    [sym_when_is_expr] = STATE(174),
    [sym_let_in_expr] = STATE(174),
    [aux_sym_function_call_expr_repeat1] = STATE(14),
    [sym_lower_case_identifier] = ACTIONS(215),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(218),
    [anon_sym_RPAREN] = ACTIONS(128),
    [anon_sym_LBRACE] = ACTIONS(221),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(230),
    [anon_sym_LBRACK] = ACTIONS(233),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(128),
    [sym_upper_case_identifier] = ACTIONS(239),
    [sym_number_literal] = ACTIONS(242),
    [sym_when] = ACTIONS(245),
    [sym_backslash] = ACTIONS(248),
    [sym_dot] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(128),
    [anon_sym_DASH] = ACTIONS(128),
    [anon_sym_STAR] = ACTIONS(128),
    [anon_sym_SLASH] = ACTIONS(128),
    [anon_sym_SLASH_SLASH] = ACTIONS(128),
    [anon_sym_CARET] = ACTIONS(128),
    [anon_sym_EQ_EQ] = ACTIONS(128),
    [anon_sym_SLASH_EQ] = ACTIONS(128),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(128),
    [anon_sym_LT_EQ] = ACTIONS(128),
    [anon_sym_GT_EQ] = ACTIONS(128),
    [anon_sym_AMP_AMP] = ACTIONS(128),
    [anon_sym_PIPE_PIPE] = ACTIONS(128),
    [anon_sym_PLUS_PLUS] = ACTIONS(128),
    [anon_sym_LT_PIPE] = ACTIONS(128),
    [anon_sym_PIPE_GT] = ACTIONS(128),
    [anon_sym_LT_LT] = ACTIONS(128),
    [anon_sym_GT_GT] = ACTIONS(128),
    [anon_sym_LT_SLASH_GT] = ACTIONS(128),
    [anon_sym_LT_QMARK_GT] = ACTIONS(128),
    [anon_sym_PIPE_DOT] = ACTIONS(128),
    [anon_sym_PIPE_EQ] = ACTIONS(128),
    [sym__virtual_end_decl] = ACTIONS(254),
    [sym__virtual_end_section] = ACTIONS(254),
    [sym_minus_without_trailing_whitespace] = ACTIONS(256),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_upper_case_qid] = STATE(98),
    [sym_value_qid] = STATE(98),
    [sym_field_accessor_function_expr] = STATE(174),
    [sym_operator_as_function_expr] = STATE(174),
    [sym__operator_as_function_inner] = STATE(171),
    [sym__atom] = STATE(175),
    [sym_field_access_expr] = STATE(110),
    [sym__field_access_start] = STATE(635),
    [sym_negate_expr] = STATE(174),
    [sym_parenthesized_expr] = STATE(110),
    [sym__literal_expr_group] = STATE(174),
    [sym_char_constant_expr] = STATE(164),
    [sym_number_constant_expr] = STATE(164),
    [sym_string_constant_expr] = STATE(164),
    [sym_anonymous_function_expr] = STATE(174),
    [sym_value_expr] = STATE(110),
    [sym_unit_expr] = STATE(174),
    [sym_list_expr] = STATE(174),
    [sym_record_expr] = STATE(110),
    [sym_if_else_expr] = STATE(174),
    [sym__if] = STATE(833),
    [sym_when_is_expr] = STATE(174),
    [sym_let_in_expr] = STATE(174),
    [aux_sym_function_call_expr_repeat1] = STATE(14),
    [sym_lower_case_identifier] = ACTIONS(259),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_SQUOTE] = ACTIONS(265),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [anon_sym_LBRACK] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(273),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [sym_upper_case_identifier] = ACTIONS(275),
    [sym_number_literal] = ACTIONS(277),
    [sym_when] = ACTIONS(279),
    [sym_backslash] = ACTIONS(281),
    [sym_dot] = ACTIONS(283),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_SLASH_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_SLASH_EQ] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_PLUS_PLUS] = ACTIONS(51),
    [anon_sym_LT_PIPE] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(51),
    [anon_sym_LT_SLASH_GT] = ACTIONS(51),
    [anon_sym_LT_QMARK_GT] = ACTIONS(51),
    [anon_sym_PIPE_DOT] = ACTIONS(51),
    [anon_sym_PIPE_EQ] = ACTIONS(51),
    [sym__virtual_end_decl] = ACTIONS(285),
    [sym__virtual_end_section] = ACTIONS(285),
    [sym_minus_without_trailing_whitespace] = ACTIONS(287),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_upper_case_qid] = STATE(98),
    [sym_value_qid] = STATE(98),
    [sym_field_accessor_function_expr] = STATE(174),
    [sym_operator_as_function_expr] = STATE(174),
    [sym__operator_as_function_inner] = STATE(171),
    [sym__atom] = STATE(175),
    [sym_field_access_expr] = STATE(110),
    [sym__field_access_start] = STATE(635),
    [sym_negate_expr] = STATE(174),
    [sym_parenthesized_expr] = STATE(110),
    [sym__literal_expr_group] = STATE(174),
    [sym_char_constant_expr] = STATE(164),
    [sym_number_constant_expr] = STATE(164),
    [sym_string_constant_expr] = STATE(164),
    [sym_anonymous_function_expr] = STATE(174),
    [sym_value_expr] = STATE(110),
    [sym_unit_expr] = STATE(174),
    [sym_list_expr] = STATE(174),
    [sym_record_expr] = STATE(110),
    [sym_if_else_expr] = STATE(174),
    [sym__if] = STATE(833),
    [sym_when_is_expr] = STATE(174),
    [sym_let_in_expr] = STATE(174),
    [aux_sym_function_call_expr_repeat1] = STATE(14),
    [sym_lower_case_identifier] = ACTIONS(289),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(292),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_SQUOTE] = ACTIONS(298),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(68),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [sym_upper_case_identifier] = ACTIONS(313),
    [sym_number_literal] = ACTIONS(316),
    [sym_when] = ACTIONS(319),
    [sym_backslash] = ACTIONS(322),
    [sym_dot] = ACTIONS(325),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_SLASH_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_SLASH_EQ] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_PLUS_PLUS] = ACTIONS(51),
    [anon_sym_LT_PIPE] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(51),
    [anon_sym_LT_SLASH_GT] = ACTIONS(51),
    [anon_sym_LT_QMARK_GT] = ACTIONS(51),
    [anon_sym_PIPE_DOT] = ACTIONS(51),
    [anon_sym_PIPE_EQ] = ACTIONS(51),
    [sym__virtual_end_decl] = ACTIONS(285),
    [sym__virtual_end_section] = ACTIONS(285),
    [sym_minus_without_trailing_whitespace] = ACTIONS(328),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_upper_case_qid] = STATE(198),
    [sym_value_qid] = STATE(198),
    [sym_field_accessor_function_expr] = STATE(216),
    [sym_operator_as_function_expr] = STATE(216),
    [sym__operator_as_function_inner] = STATE(221),
    [sym__atom] = STATE(239),
    [sym_field_access_expr] = STATE(196),
    [sym__field_access_start] = STATE(632),
    [sym_negate_expr] = STATE(216),
    [sym_parenthesized_expr] = STATE(196),
    [sym__literal_expr_group] = STATE(216),
    [sym_char_constant_expr] = STATE(211),
    [sym_number_constant_expr] = STATE(211),
    [sym_string_constant_expr] = STATE(211),
    [sym_anonymous_function_expr] = STATE(216),
    [sym_value_expr] = STATE(196),
    [sym_unit_expr] = STATE(216),
    [sym_list_expr] = STATE(216),
    [sym_record_expr] = STATE(196),
    [sym_if_else_expr] = STATE(216),
    [sym__if] = STATE(812),
    [sym_when_is_expr] = STATE(216),
    [sym_let_in_expr] = STATE(216),
    [aux_sym_function_call_expr_repeat1] = STATE(18),
    [sym_lower_case_identifier] = ACTIONS(331),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(337),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(339),
    [anon_sym_DQUOTE] = ACTIONS(341),
    [anon_sym_LBRACK] = ACTIONS(343),
    [anon_sym_if] = ACTIONS(106),
    [anon_sym_let] = ACTIONS(345),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [sym_upper_case_identifier] = ACTIONS(347),
    [sym_number_literal] = ACTIONS(349),
    [sym_when] = ACTIONS(351),
    [sym_backslash] = ACTIONS(353),
    [sym_dot] = ACTIONS(355),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_SLASH_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_SLASH_EQ] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_PLUS_PLUS] = ACTIONS(51),
    [anon_sym_LT_PIPE] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(51),
    [anon_sym_LT_SLASH_GT] = ACTIONS(51),
    [anon_sym_LT_QMARK_GT] = ACTIONS(51),
    [anon_sym_PIPE_DOT] = ACTIONS(51),
    [anon_sym_PIPE_EQ] = ACTIONS(51),
    [sym__virtual_end_decl] = ACTIONS(285),
    [sym_minus_without_trailing_whitespace] = ACTIONS(357),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_upper_case_qid] = STATE(198),
    [sym_value_qid] = STATE(198),
    [sym_field_accessor_function_expr] = STATE(216),
    [sym_operator_as_function_expr] = STATE(216),
    [sym__operator_as_function_inner] = STATE(221),
    [sym__atom] = STATE(239),
    [sym_field_access_expr] = STATE(196),
    [sym__field_access_start] = STATE(632),
    [sym_negate_expr] = STATE(216),
    [sym_parenthesized_expr] = STATE(196),
    [sym__literal_expr_group] = STATE(216),
    [sym_char_constant_expr] = STATE(211),
    [sym_number_constant_expr] = STATE(211),
    [sym_string_constant_expr] = STATE(211),
    [sym_anonymous_function_expr] = STATE(216),
    [sym_value_expr] = STATE(196),
    [sym_unit_expr] = STATE(216),
    [sym_list_expr] = STATE(216),
    [sym_record_expr] = STATE(196),
    [sym_if_else_expr] = STATE(216),
    [sym__if] = STATE(812),
    [sym_when_is_expr] = STATE(216),
    [sym_let_in_expr] = STATE(216),
    [aux_sym_function_call_expr_repeat1] = STATE(18),
    [sym_lower_case_identifier] = ACTIONS(359),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(362),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_SQUOTE] = ACTIONS(368),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(377),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(380),
    [anon_sym_COLON_COLON] = ACTIONS(128),
    [sym_upper_case_identifier] = ACTIONS(383),
    [sym_number_literal] = ACTIONS(386),
    [sym_when] = ACTIONS(389),
    [sym_backslash] = ACTIONS(392),
    [sym_dot] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(128),
    [anon_sym_DASH] = ACTIONS(128),
    [anon_sym_STAR] = ACTIONS(128),
    [anon_sym_SLASH] = ACTIONS(128),
    [anon_sym_SLASH_SLASH] = ACTIONS(128),
    [anon_sym_CARET] = ACTIONS(128),
    [anon_sym_EQ_EQ] = ACTIONS(128),
    [anon_sym_SLASH_EQ] = ACTIONS(128),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(128),
    [anon_sym_LT_EQ] = ACTIONS(128),
    [anon_sym_GT_EQ] = ACTIONS(128),
    [anon_sym_AMP_AMP] = ACTIONS(128),
    [anon_sym_PIPE_PIPE] = ACTIONS(128),
    [anon_sym_PLUS_PLUS] = ACTIONS(128),
    [anon_sym_LT_PIPE] = ACTIONS(128),
    [anon_sym_PIPE_GT] = ACTIONS(128),
    [anon_sym_LT_LT] = ACTIONS(128),
    [anon_sym_GT_GT] = ACTIONS(128),
    [anon_sym_LT_SLASH_GT] = ACTIONS(128),
    [anon_sym_LT_QMARK_GT] = ACTIONS(128),
    [anon_sym_PIPE_DOT] = ACTIONS(128),
    [anon_sym_PIPE_EQ] = ACTIONS(128),
    [sym__virtual_end_decl] = ACTIONS(254),
    [sym_minus_without_trailing_whitespace] = ACTIONS(398),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_upper_case_qid] = STATE(198),
    [sym_value_qid] = STATE(198),
    [sym_field_accessor_function_expr] = STATE(216),
    [sym_operator_as_function_expr] = STATE(216),
    [sym__operator_as_function_inner] = STATE(221),
    [sym__atom] = STATE(239),
    [sym_field_access_expr] = STATE(196),
    [sym__field_access_start] = STATE(632),
    [sym_negate_expr] = STATE(216),
    [sym_parenthesized_expr] = STATE(196),
    [sym__literal_expr_group] = STATE(216),
    [sym_char_constant_expr] = STATE(211),
    [sym_number_constant_expr] = STATE(211),
    [sym_string_constant_expr] = STATE(211),
    [sym_anonymous_function_expr] = STATE(216),
    [sym_value_expr] = STATE(196),
    [sym_unit_expr] = STATE(216),
    [sym_list_expr] = STATE(216),
    [sym_record_expr] = STATE(196),
    [sym_if_else_expr] = STATE(216),
    [sym__if] = STATE(812),
    [sym_when_is_expr] = STATE(216),
    [sym_let_in_expr] = STATE(216),
    [aux_sym_function_call_expr_repeat1] = STATE(18),
    [sym_lower_case_identifier] = ACTIONS(401),
    [anon_sym_LBRACE_DASH] = ACTIONS(44),
    [sym_line_comment] = ACTIONS(46),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_SQUOTE] = ACTIONS(410),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(416),
    [anon_sym_LBRACK] = ACTIONS(419),
    [anon_sym_if] = ACTIONS(68),
    [anon_sym_let] = ACTIONS(422),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [sym_upper_case_identifier] = ACTIONS(425),
    [sym_number_literal] = ACTIONS(428),
    [sym_when] = ACTIONS(431),
    [sym_backslash] = ACTIONS(434),
    [sym_dot] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_SLASH_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_SLASH_EQ] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_PLUS_PLUS] = ACTIONS(51),
    [anon_sym_LT_PIPE] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(51),
    [anon_sym_LT_SLASH_GT] = ACTIONS(51),
    [anon_sym_LT_QMARK_GT] = ACTIONS(51),
    [anon_sym_PIPE_DOT] = ACTIONS(51),
    [anon_sym_PIPE_EQ] = ACTIONS(51),
    [sym__virtual_end_decl] = ACTIONS(285),
    [sym_minus_without_trailing_whitespace] = ACTIONS(440),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(20), 1,
      sym_block_comment,
    STATE(21), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(36), 1,
      sym__field_access_segment,
    STATE(933), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(445), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(443), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [70] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      anon_sym_DOT,
    STATE(36), 1,
      sym__field_access_segment,
    STATE(933), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(452), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    STATE(21), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(447), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [140] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(22), 1,
      sym_block_comment,
    STATE(23), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(695), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(458), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(454), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [209] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(23), 1,
      sym_block_comment,
    STATE(24), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(943), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(462), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(460), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [278] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(943), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(469), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    STATE(24), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(464), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [345] = 9,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(25), 1,
      sym_block_comment,
    STATE(27), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(201), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(475), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(471), 20,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
    ACTIONS(473), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [416] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(201), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(482), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    STATE(26), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(477), 20,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
    ACTIONS(479), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [485] = 9,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(26), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(27), 1,
      sym_block_comment,
    STATE(201), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(486), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(484), 20,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
    ACTIONS(473), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [556] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(488), 1,
      anon_sym_DOT,
    STATE(28), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(469), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(464), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [622] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(29), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(491), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [685] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(30), 1,
      sym_block_comment,
    ACTIONS(499), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(497), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [746] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(31), 1,
      sym_block_comment,
    ACTIONS(503), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(501), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [807] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(32), 1,
      sym_block_comment,
    ACTIONS(507), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(505), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [868] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(33), 1,
      sym_block_comment,
    ACTIONS(469), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(464), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [929] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(34), 1,
      sym_block_comment,
    ACTIONS(512), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [994] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(35), 1,
      sym_block_comment,
    ACTIONS(517), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(515), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1055] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(36), 1,
      sym_block_comment,
    ACTIONS(521), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(519), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1116] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(37), 1,
      sym_block_comment,
    ACTIONS(525), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(523), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1177] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(38), 1,
      sym_block_comment,
    ACTIONS(529), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(527), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1242] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(39), 1,
      sym_block_comment,
    ACTIONS(533), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(531), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1303] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(40), 1,
      sym_block_comment,
    ACTIONS(537), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(535), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1364] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(41), 1,
      sym_block_comment,
    ACTIONS(541), 3,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(539), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1425] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(42), 1,
      sym_block_comment,
    ACTIONS(529), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(527), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1487] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(43), 1,
      sym_block_comment,
    ACTIONS(545), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(543), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1547] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(44), 1,
      sym_block_comment,
    ACTIONS(549), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(547), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1607] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(45), 1,
      sym_block_comment,
    ACTIONS(553), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(551), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1667] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(46), 1,
      sym_block_comment,
    ACTIONS(557), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(555), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1727] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(47), 1,
      sym_block_comment,
    ACTIONS(561), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(559), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1787] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(48), 1,
      sym_block_comment,
    ACTIONS(565), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(563), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1847] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(49), 1,
      sym_block_comment,
    ACTIONS(569), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(567), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1907] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(50), 1,
      sym_block_comment,
    ACTIONS(573), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(571), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1967] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(51), 1,
      sym_block_comment,
    ACTIONS(577), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(575), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2027] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(52), 1,
      sym_block_comment,
    ACTIONS(581), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(579), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2087] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(53), 1,
      sym_block_comment,
    ACTIONS(585), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(583), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2147] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(54), 1,
      sym_block_comment,
    ACTIONS(589), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(587), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2207] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(55), 1,
      sym_block_comment,
    ACTIONS(593), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(591), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2267] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(56), 1,
      sym_block_comment,
    ACTIONS(597), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(595), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2327] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(57), 1,
      sym_block_comment,
    ACTIONS(601), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(599), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2387] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(58), 1,
      sym_block_comment,
    ACTIONS(512), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2449] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(59), 1,
      sym_block_comment,
    ACTIONS(475), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(471), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2509] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(60), 1,
      sym_block_comment,
    ACTIONS(605), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(603), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2569] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(61), 1,
      sym_block_comment,
    ACTIONS(609), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(607), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2629] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(62), 1,
      sym_block_comment,
    ACTIONS(613), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(611), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2689] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(63), 1,
      sym_block_comment,
    ACTIONS(617), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(615), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2749] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(64), 1,
      sym_block_comment,
    ACTIONS(621), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(619), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2809] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(65), 1,
      sym_block_comment,
    STATE(68), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(102), 1,
      sym__field_access_segment,
    STATE(847), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(445), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(443), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2875] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(66), 1,
      sym_block_comment,
    ACTIONS(482), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(477), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2935] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(67), 1,
      sym_block_comment,
    ACTIONS(625), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(623), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2995] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      anon_sym_DOT,
    STATE(102), 1,
      sym__field_access_segment,
    STATE(847), 1,
      sym__dot_without_leading_whitespace,
    STATE(68), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(452), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(447), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3061] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(69), 1,
      sym_block_comment,
    ACTIONS(629), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(627), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3121] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(70), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(491), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3181] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(71), 1,
      sym_block_comment,
    ACTIONS(633), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(631), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3241] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(72), 1,
      sym_block_comment,
    ACTIONS(637), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(635), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3301] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(73), 1,
      sym_block_comment,
    ACTIONS(641), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(639), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3361] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(74), 1,
      sym_block_comment,
    ACTIONS(645), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(643), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3421] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(75), 1,
      sym_block_comment,
    ACTIONS(649), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(647), 44,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_is,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3481] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(76), 1,
      sym_block_comment,
    STATE(77), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(894), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(462), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(460), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3546] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(894), 1,
      sym__dot_without_leading_whitespace,
    STATE(77), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(469), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(464), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3609] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(76), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(78), 1,
      sym_block_comment,
    STATE(726), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(458), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(454), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3674] = 9,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(79), 1,
      sym_block_comment,
    STATE(80), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(189), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(475), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(471), 14,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(473), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3741] = 9,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_block_comment,
    STATE(81), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(189), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(486), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(484), 14,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(473), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3808] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(189), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    STATE(81), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(482), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(477), 14,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(479), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3873] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(82), 1,
      sym_block_comment,
    STATE(90), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(188), 1,
      sym__field_access_segment,
    STATE(991), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(445), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(443), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3937] = 33,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(651), 1,
      anon_sym_RBRACK,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(83), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(674), 1,
      sym__expression,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4051] = 33,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    ACTIONS(655), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(84), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(694), 1,
      sym__expression,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4165] = 33,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    ACTIONS(657), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(85), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(711), 1,
      sym__expression,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4279] = 33,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    ACTIONS(659), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(86), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(725), 1,
      sym__expression,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4393] = 33,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    ACTIONS(661), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(87), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(663), 1,
      sym__expression,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4507] = 33,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    ACTIONS(663), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(88), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(736), 1,
      sym__expression,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4621] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(488), 1,
      anon_sym_DOT,
    STATE(89), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(469), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(464), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [4683] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      anon_sym_DOT,
    STATE(188), 1,
      sym__field_access_segment,
    STATE(991), 1,
      sym__dot_without_leading_whitespace,
    STATE(90), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(452), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(447), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [4747] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(91), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(970), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4858] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(92), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(940), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [4969] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(93), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(529), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(527), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5032] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(94), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(335), 1,
      sym__call_or_atom,
    STATE(409), 1,
      sym_record_expr,
    STATE(449), 1,
      sym_bin_op_expr,
    STATE(632), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(935), 1,
      sym__expression,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [5143] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(335), 1,
      sym__call_or_atom,
    STATE(409), 1,
      sym_record_expr,
    STATE(449), 1,
      sym_bin_op_expr,
    STATE(632), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(904), 1,
      sym__expression,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [5254] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(96), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(984), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [5365] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(97), 1,
      sym_block_comment,
    ACTIONS(517), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(515), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5422] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(98), 1,
      sym_block_comment,
    ACTIONS(537), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(535), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5479] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(99), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(804), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [5590] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(100), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(819), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [5701] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(101), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(335), 1,
      sym__call_or_atom,
    STATE(409), 1,
      sym_record_expr,
    STATE(449), 1,
      sym_bin_op_expr,
    STATE(450), 1,
      sym__expression,
    STATE(632), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [5812] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(102), 1,
      sym_block_comment,
    ACTIONS(521), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(519), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5869] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(103), 1,
      sym_block_comment,
    ACTIONS(525), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(523), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5926] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(104), 1,
      sym_block_comment,
    ACTIONS(533), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(531), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5983] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(105), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(335), 1,
      sym__call_or_atom,
    STATE(409), 1,
      sym_record_expr,
    STATE(449), 1,
      sym_bin_op_expr,
    STATE(451), 1,
      sym__expression,
    STATE(632), 1,
      sym__field_access_start,
    STATE(781), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [6094] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(106), 1,
      sym_block_comment,
    ACTIONS(541), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(539), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6151] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(107), 1,
      sym_block_comment,
    ACTIONS(503), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(501), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6208] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(108), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(335), 1,
      sym__call_or_atom,
    STATE(409), 1,
      sym_record_expr,
    STATE(449), 1,
      sym_bin_op_expr,
    STATE(454), 1,
      sym__expression,
    STATE(632), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [6319] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(109), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(512), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6382] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(110), 1,
      sym_block_comment,
    ACTIONS(495), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(491), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6441] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(111), 1,
      sym_block_comment,
    ACTIONS(499), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(497), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6498] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(112), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(335), 1,
      sym__call_or_atom,
    STATE(409), 1,
      sym_record_expr,
    STATE(438), 1,
      sym__expression,
    STATE(449), 1,
      sym_bin_op_expr,
    STATE(632), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [6609] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(113), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(732), 1,
      sym__expression,
    STATE(828), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [6720] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(114), 1,
      sym_block_comment,
    ACTIONS(507), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(505), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6777] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(892), 1,
      sym__dot_without_leading_whitespace,
    STATE(115), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(469), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(464), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6838] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(116), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(969), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [6949] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(117), 1,
      sym_block_comment,
    ACTIONS(469), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(464), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [7006] = 9,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(118), 1,
      sym_block_comment,
    STATE(140), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(206), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(475), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(471), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(473), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [7071] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(119), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(978), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7182] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(120), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(841), 1,
      sym__expression,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7293] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(118), 1,
      sym__call_or_atom,
    STATE(121), 1,
      sym_block_comment,
    STATE(196), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(224), 1,
      sym__expression,
    STATE(235), 1,
      sym_bin_op_expr,
    STATE(243), 1,
      sym__function_call_target,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(234), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(236), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(203), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(216), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7404] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(118), 1,
      sym__call_or_atom,
    STATE(122), 1,
      sym_block_comment,
    STATE(196), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(225), 1,
      sym__expression,
    STATE(235), 1,
      sym_bin_op_expr,
    STATE(243), 1,
      sym__function_call_target,
    STATE(632), 1,
      sym__field_access_start,
    STATE(817), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(234), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(236), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(203), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(216), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7515] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(118), 1,
      sym__call_or_atom,
    STATE(123), 1,
      sym_block_comment,
    STATE(196), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(226), 1,
      sym__expression,
    STATE(235), 1,
      sym_bin_op_expr,
    STATE(243), 1,
      sym__function_call_target,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(234), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(236), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(203), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(216), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7626] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(118), 1,
      sym__call_or_atom,
    STATE(124), 1,
      sym_block_comment,
    STATE(196), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(229), 1,
      sym__expression,
    STATE(235), 1,
      sym_bin_op_expr,
    STATE(243), 1,
      sym__function_call_target,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(234), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(236), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(203), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(216), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7737] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(25), 1,
      sym__call_or_atom,
    STATE(29), 1,
      sym_record_expr,
    STATE(46), 1,
      sym__expression,
    STATE(59), 1,
      sym_bin_op_expr,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(125), 1,
      sym_block_comment,
    STATE(246), 1,
      sym__function_call_target,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(58), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(61), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(34), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(70), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7848] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(25), 1,
      sym__call_or_atom,
    STATE(29), 1,
      sym_record_expr,
    STATE(47), 1,
      sym__expression,
    STATE(59), 1,
      sym_bin_op_expr,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(126), 1,
      sym_block_comment,
    STATE(246), 1,
      sym__function_call_target,
    STATE(641), 1,
      sym__field_access_start,
    STATE(824), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(58), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(61), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(34), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(70), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [7959] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(25), 1,
      sym__call_or_atom,
    STATE(29), 1,
      sym_record_expr,
    STATE(49), 1,
      sym__expression,
    STATE(59), 1,
      sym_bin_op_expr,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(127), 1,
      sym_block_comment,
    STATE(246), 1,
      sym__function_call_target,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(58), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(61), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(34), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(70), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8070] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(25), 1,
      sym__call_or_atom,
    STATE(29), 1,
      sym_record_expr,
    STATE(52), 1,
      sym__expression,
    STATE(59), 1,
      sym_bin_op_expr,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(128), 1,
      sym_block_comment,
    STATE(246), 1,
      sym__function_call_target,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(58), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(61), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(34), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(70), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8181] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(129), 1,
      sym_block_comment,
    STATE(144), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(743), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(458), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(454), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [8244] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(130), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(369), 1,
      sym__expression,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8355] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(131), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(370), 1,
      sym__expression,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(831), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8466] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(132), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(372), 1,
      sym__expression,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8577] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(133), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(354), 1,
      sym__expression,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8688] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(134), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(317), 1,
      sym__expression,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8799] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(135), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(889), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [8910] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(79), 1,
      sym__call_or_atom,
    STATE(110), 1,
      sym_record_expr,
    STATE(136), 1,
      sym_block_comment,
    STATE(155), 1,
      sym__expression,
    STATE(170), 1,
      sym_bin_op_expr,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(247), 1,
      sym__function_call_target,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(169), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(172), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(109), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(174), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9021] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(79), 1,
      sym__call_or_atom,
    STATE(110), 1,
      sym_record_expr,
    STATE(137), 1,
      sym_block_comment,
    STATE(170), 1,
      sym_bin_op_expr,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(184), 1,
      sym__expression,
    STATE(247), 1,
      sym__function_call_target,
    STATE(635), 1,
      sym__field_access_start,
    STATE(834), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(169), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(172), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(109), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(174), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9132] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(79), 1,
      sym__call_or_atom,
    STATE(110), 1,
      sym_record_expr,
    STATE(138), 1,
      sym_block_comment,
    STATE(170), 1,
      sym_bin_op_expr,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(186), 1,
      sym__expression,
    STATE(247), 1,
      sym__function_call_target,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(169), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(172), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(109), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(174), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9243] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(79), 1,
      sym__call_or_atom,
    STATE(110), 1,
      sym_record_expr,
    STATE(139), 1,
      sym_block_comment,
    STATE(157), 1,
      sym__expression,
    STATE(170), 1,
      sym_bin_op_expr,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(247), 1,
      sym__function_call_target,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(169), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(172), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(109), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(174), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9354] = 9,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(140), 1,
      sym_block_comment,
    STATE(145), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(206), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(486), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(484), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(473), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9419] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(141), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(287), 1,
      sym__expression,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(768), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9530] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(142), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(292), 1,
      sym__expression,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9641] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(143), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(301), 1,
      sym__expression,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9752] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(115), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(144), 1,
      sym_block_comment,
    STATE(892), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(462), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(460), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9815] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(206), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    STATE(145), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(482), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(477), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(479), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9878] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(146), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(967), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [9989] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(147), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(968), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10100] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(148), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(979), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10211] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(149), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(971), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10322] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(150), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(973), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10433] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(151), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(974), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10544] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(152), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(976), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10655] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(153), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(284), 1,
      sym_record_expr,
    STATE(300), 1,
      sym_bin_op_expr,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(977), 1,
      sym__expression,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10766] = 32,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(154), 1,
      sym_block_comment,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(244), 1,
      sym__function_call_target,
    STATE(322), 1,
      sym__call_or_atom,
    STATE(347), 1,
      sym_record_expr,
    STATE(380), 1,
      sym_bin_op_expr,
    STATE(635), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(835), 1,
      sym__expression,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [10877] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(155), 1,
      sym_block_comment,
    ACTIONS(557), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(555), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10933] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(156), 1,
      sym_block_comment,
    ACTIONS(577), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(575), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10989] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(157), 1,
      sym_block_comment,
    ACTIONS(581), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(579), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11045] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(158), 1,
      sym_block_comment,
    ACTIONS(585), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(583), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11101] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(159), 1,
      sym_block_comment,
    ACTIONS(589), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(587), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11157] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(160), 1,
      sym_block_comment,
    ACTIONS(593), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(591), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11213] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(161), 1,
      sym_block_comment,
    ACTIONS(597), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(595), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11269] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(162), 1,
      sym_block_comment,
    ACTIONS(645), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(643), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11325] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(163), 1,
      sym_block_comment,
    ACTIONS(601), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(599), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11381] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(164), 1,
      sym_block_comment,
    ACTIONS(605), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(603), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11437] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(165), 1,
      sym_block_comment,
    ACTIONS(613), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(611), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11493] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(166), 1,
      sym_block_comment,
    ACTIONS(617), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(615), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11549] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(167), 1,
      sym_block_comment,
    ACTIONS(625), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(623), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11605] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(168), 1,
      sym_block_comment,
    ACTIONS(629), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(627), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11661] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(169), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(512), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11721] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(170), 1,
      sym_block_comment,
    ACTIONS(475), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(471), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11777] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(171), 1,
      sym_block_comment,
    ACTIONS(649), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(647), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11833] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(172), 1,
      sym_block_comment,
    ACTIONS(609), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(607), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11889] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(173), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(529), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(527), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11949] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(174), 1,
      sym_block_comment,
    ACTIONS(495), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(491), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12005] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(175), 1,
      sym_block_comment,
    ACTIONS(637), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(635), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12061] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(176), 1,
      sym_block_comment,
    ACTIONS(633), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(631), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12117] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(488), 1,
      anon_sym_DOT,
    STATE(177), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(469), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(464), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12177] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(178), 1,
      sym_block_comment,
    ACTIONS(641), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(639), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12233] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(179), 1,
      sym_block_comment,
    ACTIONS(621), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(619), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12289] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(180), 1,
      sym_block_comment,
    ACTIONS(545), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(543), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12345] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(181), 1,
      sym_block_comment,
    ACTIONS(482), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(477), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12401] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(182), 1,
      sym_block_comment,
    ACTIONS(549), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(547), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12457] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(183), 1,
      sym_block_comment,
    ACTIONS(553), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(551), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12513] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(184), 1,
      sym_block_comment,
    ACTIONS(561), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(559), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12569] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(185), 1,
      sym_block_comment,
    ACTIONS(565), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(563), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12625] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(186), 1,
      sym_block_comment,
    ACTIONS(569), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(567), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12681] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(187), 1,
      sym_block_comment,
    ACTIONS(573), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(571), 38,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12737] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(188), 1,
      sym_block_comment,
    ACTIONS(521), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(519), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12792] = 30,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(110), 1,
      sym_record_expr,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(181), 1,
      sym__call_or_atom,
    STATE(189), 1,
      sym_block_comment,
    STATE(247), 1,
      sym__function_call_target,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(169), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(172), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(109), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(174), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [12897] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(190), 1,
      sym_block_comment,
    ACTIONS(503), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(501), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12952] = 30,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(191), 1,
      sym_block_comment,
    STATE(244), 1,
      sym__function_call_target,
    STATE(347), 1,
      sym_record_expr,
    STATE(407), 1,
      sym__call_or_atom,
    STATE(635), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(173), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(385), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(93), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(363), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [13057] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(192), 1,
      sym_block_comment,
    ACTIONS(507), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(505), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13112] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    ACTIONS(495), 1,
      sym__virtual_end_decl,
    STATE(193), 1,
      sym_block_comment,
    ACTIONS(529), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(527), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13173] = 31,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(709), 1,
      ts_builtin_sym_end,
    ACTIONS(711), 1,
      sym_port,
    STATE(194), 1,
      sym_block_comment,
    STATE(257), 1,
      aux_sym__top_decl_list,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(478), 1,
      aux_sym__import_list,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(881), 1,
      sym_import_clause,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [13280] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(195), 1,
      sym_block_comment,
    ACTIONS(541), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(539), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13335] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(196), 1,
      sym_block_comment,
    ACTIONS(495), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(491), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13392] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(197), 1,
      sym_block_comment,
    ACTIONS(533), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(531), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13447] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(198), 1,
      sym_block_comment,
    ACTIONS(537), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(535), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13502] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(199), 1,
      sym_block_comment,
    ACTIONS(517), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(515), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13557] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(200), 1,
      sym_block_comment,
    ACTIONS(469), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(464), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13612] = 30,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(29), 1,
      sym_record_expr,
    STATE(66), 1,
      sym__call_or_atom,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(201), 1,
      sym_block_comment,
    STATE(246), 1,
      sym__function_call_target,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(58), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(61), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(34), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(70), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [13717] = 31,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(711), 1,
      sym_port,
    ACTIONS(713), 1,
      ts_builtin_sym_end,
    STATE(194), 1,
      aux_sym__import_list,
    STATE(202), 1,
      sym_block_comment,
    STATE(252), 1,
      aux_sym__top_decl_list,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(881), 1,
      sym_import_clause,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [13824] = 8,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    ACTIONS(495), 1,
      sym__virtual_end_decl,
    STATE(203), 1,
      sym_block_comment,
    ACTIONS(512), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13885] = 30,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(204), 1,
      sym_block_comment,
    STATE(245), 1,
      sym__function_call_target,
    STATE(284), 1,
      sym_record_expr,
    STATE(311), 1,
      sym__call_or_atom,
    STATE(641), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(42), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(303), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(38), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(306), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [13990] = 30,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    STATE(205), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__function_call_target,
    STATE(409), 1,
      sym_record_expr,
    STATE(420), 1,
      sym__call_or_atom,
    STATE(632), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(445), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(193), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(432), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [14095] = 30,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(196), 1,
      sym_record_expr,
    STATE(206), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(237), 1,
      sym__call_or_atom,
    STATE(243), 1,
      sym__function_call_target,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(234), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(236), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(203), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(216), 8,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [14200] = 31,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(711), 1,
      sym_port,
    ACTIONS(715), 1,
      ts_builtin_sym_end,
    STATE(207), 1,
      sym_block_comment,
    STATE(253), 1,
      aux_sym__top_decl_list,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(478), 1,
      aux_sym__import_list,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(881), 1,
      sym_import_clause,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [14307] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(208), 1,
      sym_block_comment,
    ACTIONS(499), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(497), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14362] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(209), 1,
      sym_block_comment,
    ACTIONS(525), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      anon_sym_DOT,
      sym_backslash,
    ACTIONS(523), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14417] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(210), 1,
      sym_block_comment,
    ACTIONS(565), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(563), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14471] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(211), 1,
      sym_block_comment,
    ACTIONS(605), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(603), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14525] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(212), 1,
      sym_block_comment,
    ACTIONS(613), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(611), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14579] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(213), 1,
      sym_block_comment,
    ACTIONS(617), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(615), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14633] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(214), 1,
      sym_block_comment,
    ACTIONS(625), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(623), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14687] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(215), 1,
      sym_block_comment,
    ACTIONS(629), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(627), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14741] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(216), 1,
      sym_block_comment,
    ACTIONS(495), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(491), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14795] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(217), 1,
      sym_block_comment,
    ACTIONS(633), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(631), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14849] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(218), 1,
      sym_block_comment,
    ACTIONS(641), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(639), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14903] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(219), 1,
      sym_block_comment,
    ACTIONS(545), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(543), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14957] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(495), 1,
      sym__virtual_end_decl,
    STATE(220), 1,
      sym_block_comment,
    ACTIONS(529), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(527), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15015] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(221), 1,
      sym_block_comment,
    ACTIONS(649), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(647), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15069] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(222), 1,
      sym_block_comment,
    ACTIONS(549), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(547), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15123] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(223), 1,
      sym_block_comment,
    ACTIONS(553), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(551), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15177] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(224), 1,
      sym_block_comment,
    ACTIONS(557), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(555), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15231] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(225), 1,
      sym_block_comment,
    ACTIONS(561), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(559), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15285] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(226), 1,
      sym_block_comment,
    ACTIONS(569), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(567), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15339] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(227), 1,
      sym_block_comment,
    ACTIONS(573), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(571), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15393] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(228), 1,
      sym_block_comment,
    ACTIONS(577), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(575), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15447] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(229), 1,
      sym_block_comment,
    ACTIONS(581), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(579), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15501] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(230), 1,
      sym_block_comment,
    ACTIONS(585), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(583), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15555] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(231), 1,
      sym_block_comment,
    ACTIONS(589), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(587), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15609] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(232), 1,
      sym_block_comment,
    ACTIONS(593), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(591), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15663] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(233), 1,
      sym_block_comment,
    ACTIONS(597), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(595), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15717] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(495), 1,
      sym__virtual_end_decl,
    STATE(234), 1,
      sym_block_comment,
    ACTIONS(512), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
    ACTIONS(491), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15775] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(235), 1,
      sym_block_comment,
    ACTIONS(475), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(471), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15829] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(236), 1,
      sym_block_comment,
    ACTIONS(609), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(607), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15883] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(237), 1,
      sym_block_comment,
    ACTIONS(482), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(477), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15937] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(238), 1,
      sym_block_comment,
    ACTIONS(621), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(619), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15991] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(239), 1,
      sym_block_comment,
    ACTIONS(637), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(635), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16045] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(240), 1,
      sym_block_comment,
    ACTIONS(645), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(643), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16099] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(241), 1,
      sym_block_comment,
    ACTIONS(601), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(599), 37,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16153] = 27,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(17), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(239), 1,
      sym__atom,
    STATE(242), 1,
      sym_block_comment,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(196), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(216), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16250] = 27,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(19), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(239), 1,
      sym__atom,
    STATE(243), 1,
      sym_block_comment,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(196), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(216), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16347] = 27,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(15), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(175), 1,
      sym__atom,
    STATE(244), 1,
      sym_block_comment,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(110), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(174), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16444] = 27,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(3), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(72), 1,
      sym__atom,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(245), 1,
      sym_block_comment,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(29), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(70), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16541] = 27,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(2), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(72), 1,
      sym__atom,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(246), 1,
      sym_block_comment,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(29), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(70), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16638] = 27,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(16), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(175), 1,
      sym__atom,
    STATE(247), 1,
      sym_block_comment,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(110), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(174), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16735] = 26,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(259), 1,
      sym_lower_case_identifier,
    ACTIONS(261), 1,
      anon_sym_LPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_SQUOTE,
    ACTIONS(267), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(269), 1,
      anon_sym_DQUOTE,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_let,
    ACTIONS(275), 1,
      sym_upper_case_identifier,
    ACTIONS(277), 1,
      sym_number_literal,
    ACTIONS(279), 1,
      sym_when,
    ACTIONS(281), 1,
      sym_backslash,
    ACTIONS(283), 1,
      sym_dot,
    ACTIONS(287), 1,
      sym_minus_without_trailing_whitespace,
    STATE(171), 1,
      sym__operator_as_function_inner,
    STATE(176), 1,
      sym__atom,
    STATE(248), 1,
      sym_block_comment,
    STATE(635), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(98), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(164), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(110), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(174), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16829] = 26,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_SQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_let,
    ACTIONS(187), 1,
      sym_number_literal,
    ACTIONS(191), 1,
      sym_backslash,
    ACTIONS(193), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(653), 1,
      sym_when,
    ACTIONS(717), 1,
      sym_lower_case_identifier,
    ACTIONS(719), 1,
      anon_sym_LPAREN,
    ACTIONS(721), 1,
      sym_upper_case_identifier,
    ACTIONS(723), 1,
      sym_dot,
    STATE(249), 1,
      sym_block_comment,
    STATE(293), 1,
      sym__operator_as_function_inner,
    STATE(310), 1,
      sym__atom,
    STATE(655), 1,
      sym__field_access_start,
    STATE(802), 1,
      sym__if,
    STATE(280), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(309), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(284), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(306), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [16923] = 26,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(669), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(673), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LBRACK,
    ACTIONS(677), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_number_literal,
    ACTIONS(681), 1,
      sym_when,
    ACTIONS(683), 1,
      sym_backslash,
    ACTIONS(685), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(725), 1,
      sym_lower_case_identifier,
    ACTIONS(727), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      sym_upper_case_identifier,
    ACTIONS(731), 1,
      sym_dot,
    STATE(250), 1,
      sym_block_comment,
    STATE(433), 1,
      sym__operator_as_function_inner,
    STATE(456), 1,
      sym__atom,
    STATE(653), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__if,
    STATE(412), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(421), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(409), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(432), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [17017] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(711), 1,
      sym_port,
    ACTIONS(715), 1,
      ts_builtin_sym_end,
    STATE(251), 1,
      sym_block_comment,
    STATE(254), 1,
      aux_sym__top_decl_list,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [17115] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(709), 1,
      ts_builtin_sym_end,
    ACTIONS(711), 1,
      sym_port,
    STATE(252), 1,
      sym_block_comment,
    STATE(254), 1,
      aux_sym__top_decl_list,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [17213] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(711), 1,
      sym_port,
    ACTIONS(733), 1,
      ts_builtin_sym_end,
    STATE(253), 1,
      sym_block_comment,
    STATE(254), 1,
      aux_sym__top_decl_list,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [17311] = 27,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(735), 1,
      ts_builtin_sym_end,
    ACTIONS(737), 1,
      sym_lower_case_identifier,
    ACTIONS(740), 1,
      anon_sym_LPAREN,
    ACTIONS(743), 1,
      anon_sym_LBRACE,
    ACTIONS(746), 1,
      anon_sym_SQUOTE,
    ACTIONS(749), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(752), 1,
      anon_sym_DQUOTE,
    ACTIONS(755), 1,
      anon_sym_LBRACK,
    ACTIONS(758), 1,
      sym_upper_case_identifier,
    ACTIONS(761), 1,
      sym_number_literal,
    ACTIONS(764), 1,
      sym_type,
    ACTIONS(767), 1,
      sym_port,
    ACTIONS(770), 1,
      sym_infix,
    ACTIONS(773), 1,
      sym_underscore,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(254), 2,
      sym_block_comment,
      aux_sym__top_decl_list,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [17407] = 26,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(689), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      anon_sym_SQUOTE,
    ACTIONS(693), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(697), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_let,
    ACTIONS(701), 1,
      sym_number_literal,
    ACTIONS(703), 1,
      sym_when,
    ACTIONS(705), 1,
      sym_backslash,
    ACTIONS(707), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(776), 1,
      sym_lower_case_identifier,
    ACTIONS(778), 1,
      anon_sym_LPAREN,
    ACTIONS(780), 1,
      sym_upper_case_identifier,
    ACTIONS(782), 1,
      sym_dot,
    STATE(255), 1,
      sym_block_comment,
    STATE(364), 1,
      sym__atom,
    STATE(381), 1,
      sym__operator_as_function_inner,
    STATE(643), 1,
      sym__field_access_start,
    STATE(828), 1,
      sym__if,
    STATE(353), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(357), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(347), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(363), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [17501] = 26,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(92), 1,
      sym_lower_case_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    ACTIONS(98), 1,
      anon_sym_SQUOTE,
    ACTIONS(100), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(102), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_let,
    ACTIONS(110), 1,
      sym_upper_case_identifier,
    ACTIONS(112), 1,
      sym_number_literal,
    ACTIONS(114), 1,
      sym_when,
    ACTIONS(116), 1,
      sym_backslash,
    ACTIONS(118), 1,
      sym_dot,
    ACTIONS(120), 1,
      sym_minus_without_trailing_whitespace,
    STATE(71), 1,
      sym__atom,
    STATE(75), 1,
      sym__operator_as_function_inner,
    STATE(256), 1,
      sym_block_comment,
    STATE(641), 1,
      sym__field_access_start,
    STATE(820), 1,
      sym__if,
    STATE(40), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(29), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(70), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [17595] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(711), 1,
      sym_port,
    ACTIONS(784), 1,
      ts_builtin_sym_end,
    STATE(254), 1,
      aux_sym__top_decl_list,
    STATE(257), 1,
      sym_block_comment,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(924), 1,
      sym_pattern,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(954), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [17693] = 26,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(106), 1,
      anon_sym_if,
    ACTIONS(331), 1,
      sym_lower_case_identifier,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACE,
    ACTIONS(337), 1,
      anon_sym_SQUOTE,
    ACTIONS(339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_LBRACK,
    ACTIONS(345), 1,
      anon_sym_let,
    ACTIONS(347), 1,
      sym_upper_case_identifier,
    ACTIONS(349), 1,
      sym_number_literal,
    ACTIONS(351), 1,
      sym_when,
    ACTIONS(353), 1,
      sym_backslash,
    ACTIONS(355), 1,
      sym_dot,
    ACTIONS(357), 1,
      sym_minus_without_trailing_whitespace,
    STATE(217), 1,
      sym__atom,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(258), 1,
      sym_block_comment,
    STATE(632), 1,
      sym__field_access_start,
    STATE(812), 1,
      sym__if,
    STATE(198), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(211), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(196), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(216), 10,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_when_is_expr,
      sym_let_in_expr,
  [17787] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(259), 1,
      sym_block_comment,
    STATE(260), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(893), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(460), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(462), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17842] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(893), 1,
      sym__dot_without_leading_whitespace,
    STATE(260), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(464), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17895] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(261), 1,
      sym_block_comment,
    STATE(264), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(882), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(460), 9,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(462), 23,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17950] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      anon_sym_DOT,
    STATE(281), 1,
      sym__field_access_segment,
    STATE(905), 1,
      sym__dot_without_leading_whitespace,
    STATE(262), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(447), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(452), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18005] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(262), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(263), 1,
      sym_block_comment,
    STATE(281), 1,
      sym__field_access_segment,
    STATE(905), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(443), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18060] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(882), 1,
      sym__dot_without_leading_whitespace,
    STATE(264), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(464), 9,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 23,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18113] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_block_comment,
    STATE(266), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(865), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(462), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18167] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(865), 1,
      sym__dot_without_leading_whitespace,
    STATE(266), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(464), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18219] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(204), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    STATE(267), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(482), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      sym_is,
    ACTIONS(786), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18273] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(265), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(268), 1,
      sym_block_comment,
    STATE(712), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(454), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(458), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18327] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(204), 1,
      sym_operator,
    STATE(269), 1,
      sym_block_comment,
    STATE(270), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(473), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(475), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      sym_is,
    ACTIONS(789), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18383] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(204), 1,
      sym_operator,
    STATE(267), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(270), 1,
      sym_block_comment,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(473), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(486), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      sym_is,
    ACTIONS(789), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18439] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(271), 1,
      sym_block_comment,
    ACTIONS(464), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 27,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18486] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(272), 1,
      sym_block_comment,
    ACTIONS(464), 9,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 24,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18533] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(273), 1,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(499), 28,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_exposing,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18580] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(488), 1,
      anon_sym_DOT,
    STATE(274), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(464), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18631] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(275), 1,
      sym_block_comment,
    ACTIONS(505), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 28,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_exposing,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18678] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(276), 1,
      sym_block_comment,
    ACTIONS(539), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(541), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18724] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(277), 1,
      sym_block_comment,
    ACTIONS(643), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18770] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(278), 1,
      sym_block_comment,
    ACTIONS(515), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(517), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18816] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(279), 1,
      sym_block_comment,
    ACTIONS(464), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18862] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(280), 1,
      sym_block_comment,
    ACTIONS(535), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(537), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18908] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(281), 1,
      sym_block_comment,
    ACTIONS(519), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18954] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(282), 1,
      sym_block_comment,
    ACTIONS(523), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19000] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(283), 1,
      sym_block_comment,
    ACTIONS(531), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19046] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(284), 1,
      sym_block_comment,
    ACTIONS(491), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19094] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(285), 1,
      sym_block_comment,
    ACTIONS(501), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(503), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19140] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(286), 1,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(577), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19185] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(287), 1,
      sym_block_comment,
    ACTIONS(559), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19230] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(288), 1,
      sym_block_comment,
    ACTIONS(615), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19275] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(289), 1,
      sym_block_comment,
    ACTIONS(563), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(565), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19320] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(290), 1,
      sym_block_comment,
    ACTIONS(623), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19365] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(291), 1,
      sym_block_comment,
    ACTIONS(627), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19410] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(292), 1,
      sym_block_comment,
    ACTIONS(567), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19455] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(293), 1,
      sym_block_comment,
    ACTIONS(647), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(649), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19500] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(294), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19545] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(295), 1,
      sym_block_comment,
    ACTIONS(619), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19590] = 20,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(791), 1,
      sym_lower_case_identifier,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(797), 1,
      sym_as,
    STATE(296), 1,
      sym_block_comment,
    STATE(299), 1,
      aux_sym_union_pattern_repeat1,
    STATE(483), 1,
      sym_upper_case_qid,
    STATE(488), 1,
      sym__union_argument_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(795), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_eq,
      sym_arrow,
    STATE(489), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__parenthesized_pattern,
  [19665] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(297), 1,
      sym_block_comment,
    ACTIONS(547), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19710] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(298), 1,
      sym_block_comment,
    STATE(302), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(345), 1,
      sym__field_access_segment,
    STATE(877), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(443), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19761] = 19,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(799), 1,
      sym_lower_case_identifier,
    ACTIONS(802), 1,
      anon_sym_LPAREN,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(810), 1,
      anon_sym_SQUOTE,
    ACTIONS(813), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_DQUOTE,
    ACTIONS(819), 1,
      anon_sym_LBRACK,
    ACTIONS(822), 1,
      sym_upper_case_identifier,
    ACTIONS(825), 1,
      sym_number_literal,
    ACTIONS(828), 1,
      sym_as,
    ACTIONS(830), 1,
      sym_underscore,
    STATE(483), 1,
      sym_upper_case_qid,
    STATE(488), 1,
      sym__union_argument_pattern,
    STATE(299), 2,
      sym_block_comment,
      aux_sym_union_pattern_repeat1,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(805), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_eq,
      sym_arrow,
    STATE(489), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__parenthesized_pattern,
  [19834] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(300), 1,
      sym_block_comment,
    ACTIONS(471), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(475), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19879] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(301), 1,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(581), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19924] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      anon_sym_DOT,
    STATE(345), 1,
      sym__field_access_segment,
    STATE(877), 1,
      sym__dot_without_leading_whitespace,
    STATE(302), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(447), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(452), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19975] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(303), 1,
      sym_block_comment,
    ACTIONS(607), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20020] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(304), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20065] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(305), 1,
      sym_block_comment,
    ACTIONS(587), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20110] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(306), 1,
      sym_block_comment,
    ACTIONS(491), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20155] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(307), 1,
      sym_block_comment,
    ACTIONS(599), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20200] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(308), 1,
      sym_block_comment,
    ACTIONS(591), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(593), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20245] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(309), 1,
      sym_block_comment,
    ACTIONS(603), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20290] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(310), 1,
      sym_block_comment,
    ACTIONS(631), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20335] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(311), 1,
      sym_block_comment,
    ACTIONS(477), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(482), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20380] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(312), 1,
      sym_block_comment,
    ACTIONS(639), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20425] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(313), 1,
      sym_block_comment,
    ACTIONS(595), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(597), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20470] = 20,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(791), 1,
      sym_lower_case_identifier,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(835), 1,
      sym_as,
    STATE(296), 1,
      aux_sym_union_pattern_repeat1,
    STATE(314), 1,
      sym_block_comment,
    STATE(483), 1,
      sym_upper_case_qid,
    STATE(488), 1,
      sym__union_argument_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(833), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_eq,
      sym_arrow,
    STATE(489), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__parenthesized_pattern,
  [20545] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(315), 1,
      sym_block_comment,
    ACTIONS(551), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(553), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20590] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(316), 1,
      sym_block_comment,
    ACTIONS(611), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20635] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(317), 1,
      sym_block_comment,
    ACTIONS(555), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(557), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20680] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(318), 1,
      sym_block_comment,
    ACTIONS(543), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(545), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_is,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20725] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(319), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(747), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [20809] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(259), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(320), 1,
      sym_block_comment,
    STATE(737), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(454), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(458), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20859] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(321), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(775), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [20943] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(191), 1,
      sym_operator,
    STATE(322), 1,
      sym_block_comment,
    STATE(329), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(475), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    ACTIONS(473), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20995] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(191), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    STATE(323), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(482), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(786), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21045] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(324), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(750), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21129] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(325), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(753), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21213] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(326), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(756), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21297] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(327), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(760), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21381] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(837), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(328), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(764), 1,
      sym__inner_declaration,
    STATE(797), 1,
      sym_value_declaration,
    STATE(798), 1,
      sym_type_annotation,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(897), 1,
      sym_function_declaration_left,
    STATE(898), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21465] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(191), 1,
      sym_operator,
    STATE(323), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(329), 1,
      sym_block_comment,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(486), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    ACTIONS(473), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21517] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      anon_sym_DOT,
    STATE(414), 1,
      sym__field_access_segment,
    STATE(887), 1,
      sym__dot_without_leading_whitespace,
    STATE(330), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(447), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(452), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21566] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(330), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(331), 1,
      sym_block_comment,
    STATE(414), 1,
      sym__field_access_segment,
    STATE(887), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(443), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21615] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(488), 1,
      anon_sym_DOT,
    STATE(332), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(464), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21662] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(333), 1,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(499), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21704] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(334), 1,
      sym_block_comment,
    ACTIONS(501), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(503), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21746] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(475), 1,
      sym__virtual_end_decl,
    STATE(205), 1,
      sym_operator,
    STATE(335), 1,
      sym_block_comment,
    STATE(346), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(473), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21796] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(336), 1,
      sym_block_comment,
    ACTIONS(505), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21838] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(841), 1,
      sym_arrow,
    STATE(337), 1,
      sym_block_comment,
    STATE(339), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21916] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(843), 1,
      sym_arrow,
    STATE(338), 1,
      sym_block_comment,
    STATE(339), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [21994] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(845), 1,
      sym_lower_case_identifier,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_LBRACE,
    ACTIONS(854), 1,
      anon_sym_SQUOTE,
    ACTIONS(857), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(860), 1,
      anon_sym_DQUOTE,
    ACTIONS(863), 1,
      anon_sym_LBRACK,
    ACTIONS(866), 1,
      sym_upper_case_identifier,
    ACTIONS(869), 1,
      sym_number_literal,
    ACTIONS(872), 1,
      sym_arrow,
    ACTIONS(874), 1,
      sym_underscore,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(339), 2,
      sym_block_comment,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [22070] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(482), 1,
      sym__virtual_end_decl,
    STATE(205), 1,
      sym_operator,
    STATE(496), 1,
      sym_operator_identifier,
    STATE(340), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(786), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22118] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(261), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(341), 1,
      sym_block_comment,
    STATE(675), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(454), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(458), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22166] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(877), 1,
      sym_arrow,
    STATE(339), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(342), 1,
      sym_block_comment,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [22244] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(879), 1,
      sym_arrow,
    STATE(339), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(343), 1,
      sym_block_comment,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [22322] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(881), 1,
      sym_arrow,
    STATE(339), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(344), 1,
      sym_block_comment,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [22400] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(345), 1,
      sym_block_comment,
    ACTIONS(519), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22442] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(486), 1,
      sym__virtual_end_decl,
    STATE(205), 1,
      sym_operator,
    STATE(340), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(346), 1,
      sym_block_comment,
    STATE(496), 1,
      sym_operator_identifier,
    ACTIONS(473), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22492] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(347), 1,
      sym_block_comment,
    ACTIONS(491), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22536] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(348), 1,
      sym_block_comment,
    ACTIONS(523), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22578] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(349), 1,
      sym_block_comment,
    ACTIONS(531), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22620] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(350), 1,
      sym_block_comment,
    ACTIONS(539), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(541), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22662] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(883), 1,
      sym_arrow,
    STATE(339), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(351), 1,
      sym_block_comment,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [22740] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(352), 1,
      sym_block_comment,
    ACTIONS(515), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(517), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22782] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(353), 1,
      sym_block_comment,
    ACTIONS(535), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(537), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22824] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(354), 1,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(581), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22865] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(342), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(355), 1,
      sym_block_comment,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [22940] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(356), 1,
      sym_block_comment,
    ACTIONS(599), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22981] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(357), 1,
      sym_block_comment,
    ACTIONS(603), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23022] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(358), 1,
      sym_block_comment,
    ACTIONS(611), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23063] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(359), 1,
      sym_block_comment,
    ACTIONS(615), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23104] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(360), 1,
      sym_block_comment,
    ACTIONS(623), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23145] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(361), 1,
      sym_block_comment,
    ACTIONS(627), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23186] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(885), 1,
      anon_sym_RPAREN,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(362), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(957), 1,
      sym_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [23261] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(363), 1,
      sym_block_comment,
    ACTIONS(491), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23302] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(364), 1,
      sym_block_comment,
    ACTIONS(631), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23343] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(365), 1,
      sym_block_comment,
    ACTIONS(639), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23384] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(366), 1,
      sym_block_comment,
    ACTIONS(543), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(545), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23425] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(367), 1,
      sym_block_comment,
    ACTIONS(547), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23466] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(368), 1,
      sym_block_comment,
    ACTIONS(551), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(553), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23507] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(369), 1,
      sym_block_comment,
    ACTIONS(555), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(557), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23548] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(370), 1,
      sym_block_comment,
    ACTIONS(559), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23589] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(371), 1,
      sym_block_comment,
    ACTIONS(563), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(565), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23630] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(372), 1,
      sym_block_comment,
    ACTIONS(567), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23671] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(373), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23712] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(374), 1,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(577), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23753] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(885), 1,
      anon_sym_RPAREN,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(375), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(868), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [23828] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(376), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23869] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(377), 1,
      sym_block_comment,
    ACTIONS(587), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23910] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(378), 1,
      sym_block_comment,
    ACTIONS(591), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(593), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23951] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(379), 1,
      sym_block_comment,
    ACTIONS(595), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(597), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23992] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(380), 1,
      sym_block_comment,
    ACTIONS(471), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(475), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24033] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(381), 1,
      sym_block_comment,
    ACTIONS(647), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(649), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24074] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(382), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(630), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24149] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(383), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(629), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24224] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(384), 1,
      sym_block_comment,
    ACTIONS(619), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24265] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(385), 1,
      sym_block_comment,
    ACTIONS(607), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24306] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(386), 1,
      sym_block_comment,
    ACTIONS(643), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24347] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(387), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(724), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24422] = 10,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(388), 1,
      sym_block_comment,
    STATE(389), 1,
      aux_sym_union_pattern_repeat1,
    STATE(483), 1,
      sym_upper_case_qid,
    STATE(488), 1,
      sym__union_argument_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(835), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    STATE(489), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__parenthesized_pattern,
    ACTIONS(833), 9,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
  [24473] = 10,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(299), 1,
      aux_sym_union_pattern_repeat1,
    STATE(389), 1,
      sym_block_comment,
    STATE(483), 1,
      sym_upper_case_qid,
    STATE(488), 1,
      sym__union_argument_pattern,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(797), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    STATE(489), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__parenthesized_pattern,
    ACTIONS(795), 9,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
  [24524] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(887), 1,
      anon_sym_RBRACK,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(390), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(766), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24599] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(338), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(391), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24674] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(392), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(662), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24749] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(393), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(595), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24824] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(351), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(394), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24899] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(395), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(642), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [24974] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(396), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(601), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25049] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(337), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(397), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25124] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(398), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(657), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25199] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(399), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(608), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25274] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(343), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(400), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25349] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(401), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(637), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25424] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(402), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(613), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25499] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(403), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(644), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25574] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(404), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(618), 1,
      sym_when_is_branch,
    STATE(867), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25649] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(344), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(405), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(527), 1,
      sym_pattern,
    STATE(899), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [25724] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(488), 1,
      anon_sym_DOT,
    STATE(406), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(464), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(469), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25769] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(407), 1,
      sym_block_comment,
    ACTIONS(477), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(482), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25810] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(408), 1,
      sym_block_comment,
    ACTIONS(531), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25850] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(493), 1,
      anon_sym_DOT,
    STATE(409), 1,
      sym_block_comment,
    ACTIONS(491), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25892] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(410), 1,
      sym_block_comment,
    ACTIONS(515), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(517), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25932] = 21,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(411), 1,
      sym_block_comment,
    STATE(487), 1,
      sym__parenthesized_pattern,
    STATE(493), 1,
      sym_cons_pattern,
    STATE(494), 1,
      sym__single_pattern,
    STATE(832), 1,
      sym_pattern,
    STATE(878), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(481), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
  [26004] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(412), 1,
      sym_block_comment,
    ACTIONS(535), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(537), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26044] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(413), 1,
      sym_block_comment,
    ACTIONS(501), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(503), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26084] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(414), 1,
      sym_block_comment,
    ACTIONS(519), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26124] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(415), 1,
      sym_block_comment,
    ACTIONS(539), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(541), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26164] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(416), 1,
      sym_block_comment,
    ACTIONS(505), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26204] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(417), 1,
      sym_block_comment,
    ACTIONS(523), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26244] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(418), 1,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(499), 21,
      sym__virtual_end_decl,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26284] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(419), 1,
      sym_block_comment,
    ACTIONS(619), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26323] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(420), 1,
      sym_block_comment,
    ACTIONS(477), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(482), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26362] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(421), 1,
      sym_block_comment,
    ACTIONS(603), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26401] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(422), 1,
      sym_block_comment,
    ACTIONS(611), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26440] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(423), 1,
      sym_block_comment,
    ACTIONS(615), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26479] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(424), 1,
      sym_block_comment,
    ACTIONS(639), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26518] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(425), 1,
      sym_block_comment,
    ACTIONS(623), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26557] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(426), 1,
      sym_block_comment,
    ACTIONS(627), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26596] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(427), 1,
      sym_block_comment,
    ACTIONS(643), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26635] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(889), 1,
      anon_sym_RPAREN,
    STATE(428), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26676] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      anon_sym_RPAREN,
    STATE(429), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26717] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(895), 1,
      anon_sym_RPAREN,
    STATE(430), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26758] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(431), 1,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(577), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26797] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(432), 1,
      sym_block_comment,
    ACTIONS(491), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26836] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(433), 1,
      sym_block_comment,
    ACTIONS(647), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(649), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26875] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(898), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26916] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(901), 1,
      anon_sym_RPAREN,
    STATE(435), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26957] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(904), 1,
      anon_sym_RPAREN,
    STATE(436), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26998] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(907), 1,
      anon_sym_RPAREN,
    STATE(437), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27039] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(438), 1,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(581), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27078] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(910), 1,
      anon_sym_RPAREN,
    STATE(439), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27119] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(913), 1,
      anon_sym_RPAREN,
    STATE(440), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27160] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(441), 1,
      sym_block_comment,
    STATE(869), 1,
      sym_operator_identifier,
    ACTIONS(185), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(916), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27201] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(918), 1,
      anon_sym_RPAREN,
    STATE(442), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27242] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(921), 1,
      anon_sym_RPAREN,
    STATE(443), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27283] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(444), 1,
      sym_block_comment,
    ACTIONS(547), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27322] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(445), 1,
      sym_block_comment,
    ACTIONS(607), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27361] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(446), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27400] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(447), 1,
      sym_block_comment,
    ACTIONS(587), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27439] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(448), 1,
      sym_block_comment,
    ACTIONS(551), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(553), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27478] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(449), 1,
      sym_block_comment,
    ACTIONS(471), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(475), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27517] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(450), 1,
      sym_block_comment,
    ACTIONS(555), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(557), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27556] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(451), 1,
      sym_block_comment,
    ACTIONS(559), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27595] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(452), 1,
      sym_block_comment,
    ACTIONS(563), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(565), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27634] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(924), 1,
      anon_sym_RPAREN,
    STATE(453), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27675] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(454), 1,
      sym_block_comment,
    ACTIONS(567), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27714] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(455), 1,
      sym_block_comment,
    ACTIONS(543), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(545), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27753] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(456), 1,
      sym_block_comment,
    ACTIONS(631), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27792] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(457), 1,
      sym_block_comment,
    ACTIONS(591), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(593), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27831] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(458), 1,
      sym_block_comment,
    ACTIONS(595), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(597), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27870] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(459), 1,
      sym_block_comment,
    ACTIONS(599), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27909] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(460), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27948] = 18,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(314), 1,
      sym_upper_case_qid,
    STATE(461), 1,
      sym_block_comment,
    STATE(492), 1,
      sym_cons_pattern,
    STATE(552), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(487), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym__parenthesized_pattern,
  [28012] = 18,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(388), 1,
      sym_upper_case_qid,
    STATE(462), 1,
      sym_block_comment,
    STATE(492), 1,
      sym_cons_pattern,
    STATE(507), 1,
      sym__single_pattern_cons,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(487), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym__parenthesized_pattern,
  [28076] = 19,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(791), 1,
      sym_lower_case_identifier,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(927), 1,
      anon_sym_COLON_COLON,
    ACTIONS(929), 1,
      sym_as,
    ACTIONS(931), 1,
      sym_eq,
    ACTIONS(933), 1,
      sym_colon,
    STATE(463), 1,
      sym_block_comment,
    STATE(468), 1,
      aux_sym_function_declaration_left_repeat1,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(530), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym__parenthesized_pattern,
  [28142] = 19,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(791), 1,
      sym_lower_case_identifier,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(927), 1,
      anon_sym_COLON_COLON,
    ACTIONS(929), 1,
      sym_as,
    ACTIONS(931), 1,
      sym_eq,
    ACTIONS(935), 1,
      sym_colon,
    STATE(464), 1,
      sym_block_comment,
    STATE(468), 1,
      aux_sym_function_declaration_left_repeat1,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(530), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym__parenthesized_pattern,
  [28208] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(465), 1,
      sym_block_comment,
    STATE(466), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(990), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(460), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(462), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28251] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(990), 1,
      sym__dot_without_leading_whitespace,
    STATE(466), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(464), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(469), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28292] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(465), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(467), 1,
      sym_block_comment,
    STATE(990), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(454), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(458), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28335] = 16,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    ACTIONS(937), 1,
      sym_eq,
    STATE(468), 1,
      sym_block_comment,
    STATE(470), 1,
      aux_sym_function_declaration_left_repeat1,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(530), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym__parenthesized_pattern,
  [28392] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(469), 1,
      sym_block_comment,
    ACTIONS(464), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(469), 15,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28427] = 15,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(939), 1,
      sym_lower_case_identifier,
    ACTIONS(942), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_SQUOTE,
    ACTIONS(951), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(954), 1,
      anon_sym_DQUOTE,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(960), 1,
      sym_number_literal,
    ACTIONS(963), 1,
      sym_eq,
    ACTIONS(965), 1,
      sym_underscore,
    STATE(470), 2,
      sym_block_comment,
      aux_sym_function_declaration_left_repeat1,
    STATE(486), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(530), 7,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym__parenthesized_pattern,
  [28482] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(471), 1,
      sym_block_comment,
    ACTIONS(929), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(927), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28514] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(472), 1,
      sym_block_comment,
    ACTIONS(968), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(970), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28545] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(473), 1,
      sym_block_comment,
    ACTIONS(972), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(974), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28576] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(474), 1,
      sym_block_comment,
    ACTIONS(976), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(978), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28607] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(475), 1,
      sym_block_comment,
    ACTIONS(980), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(982), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28638] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(476), 1,
      sym_block_comment,
    ACTIONS(984), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(986), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28669] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(477), 1,
      sym_block_comment,
    ACTIONS(599), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(601), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28700] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(992), 1,
      sym_import,
    STATE(881), 1,
      sym_import_clause,
    STATE(478), 2,
      sym_block_comment,
      aux_sym__import_list,
    ACTIONS(990), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(988), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_underscore,
  [28735] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(479), 1,
      sym_block_comment,
    ACTIONS(995), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(997), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28766] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(986), 1,
      anon_sym_COLON_COLON,
    STATE(480), 1,
      sym_block_comment,
    ACTIONS(999), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1001), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28799] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1007), 1,
      anon_sym_COLON_COLON,
    STATE(481), 1,
      sym_block_comment,
    ACTIONS(1003), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1005), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28832] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(482), 1,
      sym_block_comment,
    ACTIONS(1009), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1011), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28863] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(483), 1,
      sym_block_comment,
    ACTIONS(1013), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1015), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28894] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(484), 1,
      sym_block_comment,
    ACTIONS(615), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(617), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28925] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(485), 1,
      sym_block_comment,
    ACTIONS(623), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(625), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28956] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(486), 1,
      sym_block_comment,
    ACTIONS(603), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(605), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [28987] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(487), 1,
      sym_block_comment,
    ACTIONS(1017), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1007), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29018] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(488), 1,
      sym_block_comment,
    ACTIONS(1019), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1021), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29049] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(489), 1,
      sym_block_comment,
    ACTIONS(1023), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1025), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29080] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(490), 1,
      sym_block_comment,
    ACTIONS(611), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(613), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29111] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(491), 1,
      sym_block_comment,
    ACTIONS(627), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(629), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29142] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(492), 1,
      sym_block_comment,
    ACTIONS(1027), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1029), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29172] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1035), 1,
      sym_as,
    STATE(493), 1,
      sym_block_comment,
    ACTIONS(1031), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
    ACTIONS(1033), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29204] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1041), 1,
      sym_as,
    STATE(494), 1,
      sym_block_comment,
    ACTIONS(1037), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
    ACTIONS(1039), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29236] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(495), 1,
      sym_block_comment,
    ACTIONS(1045), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1043), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29265] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(496), 1,
      sym_block_comment,
    ACTIONS(1049), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(1047), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
  [29294] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(497), 1,
      sym_block_comment,
    ACTIONS(1053), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(1051), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_when,
      sym_dot,
  [29323] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(498), 1,
      sym_block_comment,
    ACTIONS(990), 7,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_import,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(988), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_underscore,
  [29352] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(499), 1,
      sym_block_comment,
    ACTIONS(1057), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1055), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29381] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_block_comment,
    STATE(501), 1,
      aux_sym_type_ref_repeat1,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(539), 1,
      sym__single_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
    ACTIONS(1063), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [29423] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(501), 1,
      sym_block_comment,
    STATE(503), 1,
      aux_sym_type_ref_repeat1,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(539), 1,
      sym__single_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
    ACTIONS(1067), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [29465] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(502), 1,
      sym_block_comment,
    ACTIONS(1069), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(735), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_underscore,
  [29493] = 11,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1071), 1,
      sym_lower_case_identifier,
    ACTIONS(1074), 1,
      anon_sym_LPAREN,
    ACTIONS(1079), 1,
      anon_sym_LBRACE,
    ACTIONS(1082), 1,
      sym_upper_case_identifier,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(539), 1,
      sym__single_type_expression,
    STATE(503), 2,
      sym_block_comment,
      aux_sym_type_ref_repeat1,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
    ACTIONS(1077), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [29533] = 11,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1085), 1,
      sym_lower_case_identifier,
    ACTIONS(1088), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACE,
    ACTIONS(1094), 1,
      sym_upper_case_identifier,
    STATE(547), 1,
      sym__single_type_expression,
    STATE(555), 1,
      sym_upper_case_qid,
    STATE(504), 2,
      sym_block_comment,
      aux_sym_type_ref_repeat1,
    ACTIONS(1077), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(548), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29572] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1097), 1,
      sym_lower_case_identifier,
    ACTIONS(1099), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1103), 1,
      sym_upper_case_identifier,
    STATE(504), 1,
      aux_sym_type_ref_repeat1,
    STATE(505), 1,
      sym_block_comment,
    STATE(547), 1,
      sym__single_type_expression,
    STATE(555), 1,
      sym_upper_case_qid,
    ACTIONS(1067), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(548), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29613] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1097), 1,
      sym_lower_case_identifier,
    ACTIONS(1099), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1103), 1,
      sym_upper_case_identifier,
    STATE(505), 1,
      aux_sym_type_ref_repeat1,
    STATE(506), 1,
      sym_block_comment,
    STATE(547), 1,
      sym__single_type_expression,
    STATE(555), 1,
      sym_upper_case_qid,
    ACTIONS(1063), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(548), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29654] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1105), 1,
      anon_sym_COLON_COLON,
    STATE(507), 1,
      sym_block_comment,
    ACTIONS(1027), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1029), 8,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
  [29683] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_upper_case_qid,
    STATE(508), 1,
      sym_block_comment,
    STATE(627), 1,
      sym__type_expression_inner,
    STATE(658), 1,
      sym_type_ref,
    STATE(659), 1,
      sym__single_type_expression,
    STATE(866), 1,
      sym_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29725] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(509), 1,
      sym_block_comment,
    STATE(519), 1,
      sym_upper_case_qid,
    STATE(709), 1,
      sym__type_expression_inner,
    STATE(788), 1,
      sym_type_ref,
    STATE(815), 1,
      sym__single_type_expression,
    STATE(941), 1,
      sym_type_expression,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29767] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1097), 1,
      sym_lower_case_identifier,
    ACTIONS(1099), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1103), 1,
      sym_upper_case_identifier,
    STATE(506), 1,
      sym_upper_case_qid,
    STATE(510), 1,
      sym_block_comment,
    STATE(634), 1,
      sym__type_expression_inner,
    STATE(744), 1,
      sym_type_ref,
    STATE(745), 1,
      sym__single_type_expression,
    STATE(818), 1,
      sym_type_expression,
    STATE(548), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29809] = 11,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1115), 1,
      sym_lower_case_identifier,
    ACTIONS(1118), 1,
      anon_sym_LPAREN,
    ACTIONS(1121), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      sym_upper_case_identifier,
    STATE(564), 1,
      sym_upper_case_qid,
    STATE(573), 1,
      sym__single_type_expression,
    ACTIONS(1077), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(511), 2,
      sym_block_comment,
      aux_sym_type_ref_repeat1,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29847] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_upper_case_qid,
    STATE(512), 1,
      sym_block_comment,
    STATE(627), 1,
      sym__type_expression_inner,
    STATE(658), 1,
      sym_type_ref,
    STATE(659), 1,
      sym__single_type_expression,
    STATE(857), 1,
      sym_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29889] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(513), 1,
      sym_block_comment,
    STATE(519), 1,
      sym_upper_case_qid,
    STATE(709), 1,
      sym__type_expression_inner,
    STATE(788), 1,
      sym_type_ref,
    STATE(815), 1,
      sym__single_type_expression,
    STATE(929), 1,
      sym_type_expression,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29931] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1127), 1,
      sym_lower_case_identifier,
    ACTIONS(1129), 1,
      sym_line_comment,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1135), 1,
      anon_sym_LBRACE,
    ACTIONS(1137), 1,
      sym_upper_case_identifier,
    STATE(514), 1,
      sym_block_comment,
    STATE(521), 1,
      aux_sym_union_variant_repeat1,
    STATE(562), 1,
      sym__single_type_expression,
    STATE(572), 1,
      sym_upper_case_qid,
    ACTIONS(1133), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
    STATE(575), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [29971] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_upper_case_qid,
    STATE(515), 1,
      sym_block_comment,
    STATE(627), 1,
      sym__type_expression_inner,
    STATE(658), 1,
      sym_type_ref,
    STATE(659), 1,
      sym__single_type_expression,
    STATE(915), 1,
      sym_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30013] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(511), 1,
      aux_sym_type_ref_repeat1,
    STATE(516), 1,
      sym_block_comment,
    STATE(564), 1,
      sym_upper_case_qid,
    STATE(573), 1,
      sym__single_type_expression,
    ACTIONS(1067), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30053] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(517), 1,
      sym_block_comment,
    STATE(519), 1,
      sym_upper_case_qid,
    STATE(709), 1,
      sym__type_expression_inner,
    STATE(788), 1,
      sym_type_ref,
    STATE(815), 1,
      sym__single_type_expression,
    STATE(903), 1,
      sym_type_expression,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30095] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_upper_case_qid,
    STATE(518), 1,
      sym_block_comment,
    STATE(627), 1,
      sym__type_expression_inner,
    STATE(658), 1,
      sym_type_ref,
    STATE(659), 1,
      sym__single_type_expression,
    STATE(891), 1,
      sym_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30137] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(516), 1,
      aux_sym_type_ref_repeat1,
    STATE(519), 1,
      sym_block_comment,
    STATE(564), 1,
      sym_upper_case_qid,
    STATE(573), 1,
      sym__single_type_expression,
    ACTIONS(1063), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30177] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(519), 1,
      sym_upper_case_qid,
    STATE(520), 1,
      sym_block_comment,
    STATE(709), 1,
      sym__type_expression_inner,
    STATE(788), 1,
      sym_type_ref,
    STATE(815), 1,
      sym__single_type_expression,
    STATE(914), 1,
      sym_type_expression,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30219] = 11,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1139), 1,
      sym_lower_case_identifier,
    ACTIONS(1142), 1,
      sym_line_comment,
    ACTIONS(1145), 1,
      anon_sym_LPAREN,
    ACTIONS(1150), 1,
      anon_sym_LBRACE,
    ACTIONS(1153), 1,
      sym_upper_case_identifier,
    STATE(562), 1,
      sym__single_type_expression,
    STATE(572), 1,
      sym_upper_case_qid,
    ACTIONS(1148), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
    STATE(521), 2,
      sym_block_comment,
      aux_sym_union_variant_repeat1,
    STATE(575), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30257] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1127), 1,
      sym_lower_case_identifier,
    ACTIONS(1129), 1,
      sym_line_comment,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1135), 1,
      anon_sym_LBRACE,
    ACTIONS(1137), 1,
      sym_upper_case_identifier,
    STATE(514), 1,
      aux_sym_union_variant_repeat1,
    STATE(522), 1,
      sym_block_comment,
    STATE(562), 1,
      sym__single_type_expression,
    STATE(572), 1,
      sym_upper_case_qid,
    ACTIONS(1156), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
    STATE(575), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30297] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_upper_case_qid,
    STATE(523), 1,
      sym_block_comment,
    STATE(627), 1,
      sym__type_expression_inner,
    STATE(658), 1,
      sym_type_ref,
    STATE(659), 1,
      sym__single_type_expression,
    STATE(806), 1,
      sym_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30339] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1059), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      anon_sym_LBRACE,
    STATE(500), 1,
      sym_upper_case_qid,
    STATE(524), 1,
      sym_block_comment,
    STATE(652), 1,
      sym__type_expression_inner,
    STATE(658), 1,
      sym_type_ref,
    STATE(659), 1,
      sym__single_type_expression,
    STATE(535), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30378] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1097), 1,
      sym_lower_case_identifier,
    ACTIONS(1099), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1103), 1,
      sym_upper_case_identifier,
    STATE(506), 1,
      sym_upper_case_qid,
    STATE(525), 1,
      sym_block_comment,
    STATE(667), 1,
      sym__type_expression_inner,
    STATE(744), 1,
      sym_type_ref,
    STATE(745), 1,
      sym__single_type_expression,
    STATE(548), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30417] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(519), 1,
      sym_upper_case_qid,
    STATE(526), 1,
      sym_block_comment,
    STATE(788), 1,
      sym_type_ref,
    STATE(801), 1,
      sym__type_expression_inner,
    STATE(815), 1,
      sym__single_type_expression,
    STATE(569), 3,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
  [30456] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(527), 1,
      sym_block_comment,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1158), 9,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
  [30481] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(261), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(528), 1,
      sym_block_comment,
    STATE(882), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(454), 4,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
    ACTIONS(458), 4,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_arrow,
  [30512] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(454), 1,
      anon_sym_LBRACE,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(259), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(529), 1,
      sym_block_comment,
    STATE(893), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(458), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30542] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(530), 1,
      sym_block_comment,
    ACTIONS(1164), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1162), 8,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_underscore,
  [30566] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(456), 1,
      anon_sym_DOT,
    ACTIONS(460), 1,
      anon_sym_LBRACE,
    STATE(531), 1,
      sym_block_comment,
    STATE(533), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(880), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(462), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [30593] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(454), 1,
      anon_sym_LBRACE,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(531), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(532), 1,
      sym_block_comment,
    STATE(880), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(458), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [30620] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(464), 1,
      anon_sym_LBRACE,
    ACTIONS(466), 1,
      anon_sym_DOT,
    STATE(880), 1,
      sym__dot_without_leading_whitespace,
    STATE(533), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(469), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [30645] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1168), 1,
      anon_sym_LBRACE,
    STATE(534), 1,
      sym_block_comment,
    ACTIONS(1166), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30667] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1172), 1,
      anon_sym_LBRACE,
    STATE(535), 1,
      sym_block_comment,
    ACTIONS(1170), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30689] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1176), 1,
      anon_sym_LBRACE,
    STATE(536), 1,
      sym_block_comment,
    ACTIONS(1174), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30711] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1178), 1,
      anon_sym_LBRACE,
    STATE(537), 1,
      sym_block_comment,
    ACTIONS(1063), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30733] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1182), 1,
      anon_sym_LBRACE,
    STATE(538), 1,
      sym_block_comment,
    ACTIONS(1180), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30755] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1186), 1,
      anon_sym_LBRACE,
    STATE(539), 1,
      sym_block_comment,
    ACTIONS(1184), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30777] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    STATE(540), 1,
      sym_block_comment,
    ACTIONS(1188), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30799] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1194), 1,
      anon_sym_LBRACE,
    STATE(541), 1,
      sym_block_comment,
    ACTIONS(1192), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30821] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1196), 1,
      sym_lower_case_identifier,
    ACTIONS(1198), 1,
      anon_sym_LPAREN,
    ACTIONS(1200), 1,
      sym_upper_case_identifier,
    ACTIONS(1202), 1,
      sym_double_dot,
    STATE(542), 1,
      sym_block_comment,
    STATE(785), 1,
      sym__operator_as_function_inner,
    STATE(706), 3,
      sym_exposed_value,
      sym_exposed_type,
      sym_exposed_operator,
  [30851] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1206), 1,
      anon_sym_LBRACE,
    STATE(543), 1,
      sym_block_comment,
    ACTIONS(1204), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30873] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1210), 1,
      anon_sym_LBRACE,
    STATE(544), 1,
      sym_block_comment,
    ACTIONS(1208), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30895] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    STATE(545), 1,
      sym_block_comment,
    ACTIONS(1188), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30916] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1168), 1,
      anon_sym_LBRACE,
    STATE(546), 1,
      sym_block_comment,
    ACTIONS(1166), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30937] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1186), 1,
      anon_sym_LBRACE,
    STATE(547), 1,
      sym_block_comment,
    ACTIONS(1184), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30958] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1172), 1,
      anon_sym_LBRACE,
    STATE(548), 1,
      sym_block_comment,
    ACTIONS(1170), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [30979] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1196), 1,
      sym_lower_case_identifier,
    ACTIONS(1198), 1,
      anon_sym_LPAREN,
    ACTIONS(1200), 1,
      sym_upper_case_identifier,
    STATE(549), 1,
      sym_block_comment,
    STATE(785), 1,
      sym__operator_as_function_inner,
    STATE(805), 3,
      sym_exposed_value,
      sym_exposed_type,
      sym_exposed_operator,
  [31006] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1194), 1,
      anon_sym_LBRACE,
    STATE(550), 1,
      sym_block_comment,
    ACTIONS(1192), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31027] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(464), 1,
      anon_sym_LBRACE,
    STATE(551), 1,
      sym_block_comment,
    ACTIONS(469), 7,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31046] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1212), 1,
      anon_sym_COLON_COLON,
    STATE(552), 1,
      sym_block_comment,
    ACTIONS(1029), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      sym_as,
      sym_eq,
      sym_arrow,
  [31067] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1206), 1,
      anon_sym_LBRACE,
    STATE(553), 1,
      sym_block_comment,
    ACTIONS(1204), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31088] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1176), 1,
      anon_sym_LBRACE,
    STATE(554), 1,
      sym_block_comment,
    ACTIONS(1174), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31109] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1178), 1,
      anon_sym_LBRACE,
    STATE(555), 1,
      sym_block_comment,
    ACTIONS(1063), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31130] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1210), 1,
      anon_sym_LBRACE,
    STATE(556), 1,
      sym_block_comment,
    ACTIONS(1208), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31151] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1182), 1,
      anon_sym_LBRACE,
    STATE(557), 1,
      sym_block_comment,
    ACTIONS(1180), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31172] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    STATE(558), 1,
      sym_block_comment,
    ACTIONS(1188), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31192] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    STATE(559), 1,
      sym_block_comment,
    ACTIONS(1214), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31210] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1176), 1,
      anon_sym_LBRACE,
    STATE(560), 1,
      sym_block_comment,
    ACTIONS(1174), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31228] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1210), 1,
      anon_sym_LBRACE,
    STATE(561), 1,
      sym_block_comment,
    ACTIONS(1208), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31248] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1220), 1,
      anon_sym_LBRACE,
    STATE(562), 1,
      sym_block_comment,
    ACTIONS(1218), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31266] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1176), 1,
      anon_sym_LBRACE,
    STATE(563), 1,
      sym_block_comment,
    ACTIONS(1174), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31286] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1178), 1,
      anon_sym_LBRACE,
    STATE(564), 1,
      sym_block_comment,
    ACTIONS(1063), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31306] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym_block_comment,
    STATE(767), 1,
      sym_field,
    STATE(843), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
    STATE(902), 1,
      sym__record_inner,
  [31334] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1206), 1,
      anon_sym_LBRACE,
    STATE(566), 1,
      sym_block_comment,
    ACTIONS(1204), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31352] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1210), 1,
      anon_sym_LBRACE,
    STATE(567), 1,
      sym_block_comment,
    ACTIONS(1208), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31370] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1226), 1,
      anon_sym_RBRACE,
    STATE(568), 1,
      sym_block_comment,
    STATE(767), 1,
      sym_field,
    STATE(843), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
    STATE(923), 1,
      sym__record_inner,
  [31398] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1172), 1,
      anon_sym_LBRACE,
    STATE(569), 1,
      sym_block_comment,
    ACTIONS(1170), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31418] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    STATE(570), 1,
      sym_block_comment,
    ACTIONS(1188), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31436] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1228), 1,
      anon_sym_RBRACE,
    STATE(571), 1,
      sym_block_comment,
    STATE(767), 1,
      sym_field,
    STATE(843), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
    STATE(985), 1,
      sym__record_inner,
  [31464] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1178), 1,
      anon_sym_LBRACE,
    STATE(572), 1,
      sym_block_comment,
    ACTIONS(1063), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31482] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1186), 1,
      anon_sym_LBRACE,
    STATE(573), 1,
      sym_block_comment,
    ACTIONS(1184), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31502] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1230), 1,
      anon_sym_RBRACE,
    STATE(574), 1,
      sym_block_comment,
    STATE(767), 1,
      sym_field,
    STATE(843), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
    STATE(987), 1,
      sym__record_inner,
  [31530] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1172), 1,
      anon_sym_LBRACE,
    STATE(575), 1,
      sym_block_comment,
    ACTIONS(1170), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31548] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1182), 1,
      anon_sym_LBRACE,
    STATE(576), 1,
      sym_block_comment,
    ACTIONS(1180), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31566] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1206), 1,
      anon_sym_LBRACE,
    STATE(577), 1,
      sym_block_comment,
    ACTIONS(1204), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31586] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1232), 1,
      anon_sym_RBRACE,
    STATE(578), 1,
      sym_block_comment,
    STATE(767), 1,
      sym_field,
    STATE(843), 1,
      sym__record_base,
    STATE(874), 1,
      sym__record_inner,
    STATE(885), 1,
      sym_record_base_identifier,
  [31614] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1234), 1,
      anon_sym_RBRACE,
    STATE(579), 1,
      sym_block_comment,
    STATE(767), 1,
      sym_field,
    STATE(843), 1,
      sym__record_base,
    STATE(875), 1,
      sym__record_inner,
    STATE(885), 1,
      sym_record_base_identifier,
  [31642] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1168), 1,
      anon_sym_LBRACE,
    STATE(580), 1,
      sym_block_comment,
    ACTIONS(1166), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31660] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1182), 1,
      anon_sym_LBRACE,
    STATE(581), 1,
      sym_block_comment,
    ACTIONS(1180), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31680] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1194), 1,
      anon_sym_LBRACE,
    STATE(582), 1,
      sym_block_comment,
    ACTIONS(1192), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31700] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1168), 1,
      anon_sym_LBRACE,
    STATE(583), 1,
      sym_block_comment,
    ACTIONS(1166), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [31720] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(1194), 1,
      anon_sym_LBRACE,
    STATE(584), 1,
      sym_block_comment,
    ACTIONS(1192), 6,
      sym__virtual_end_decl,
      sym_line_comment,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
  [31738] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1236), 1,
      anon_sym_DQUOTE,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    STATE(585), 1,
      sym_block_comment,
    STATE(626), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [31761] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1236), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    STATE(586), 1,
      sym_block_comment,
    STATE(623), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [31784] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1248), 1,
      sym_arrow,
    STATE(587), 2,
      sym_block_comment,
      aux_sym_type_expression_repeat1,
    ACTIONS(1246), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [31803] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1251), 1,
      sym_lower_case_identifier,
    ACTIONS(1253), 1,
      sym_upper_case_identifier,
    STATE(588), 1,
      sym_block_comment,
    STATE(909), 1,
      sym_value_expr,
    STATE(412), 2,
      sym_upper_case_qid,
      sym_value_qid,
  [31826] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1255), 1,
      sym_as,
    ACTIONS(1257), 1,
      sym_exposing,
    ACTIONS(1259), 1,
      sym__virtual_end_decl,
    STATE(589), 1,
      sym_block_comment,
    STATE(670), 1,
      sym_as_clause,
    STATE(855), 1,
      sym_exposing_list,
  [31851] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1261), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(590), 1,
      sym_block_comment,
    STATE(592), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [31874] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1261), 1,
      anon_sym_DQUOTE,
    STATE(591), 1,
      sym_block_comment,
    STATE(593), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [31897] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1263), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(592), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [31920] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1263), 1,
      anon_sym_DQUOTE,
    STATE(593), 1,
      sym_block_comment,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [31943] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1265), 1,
      sym_lower_case_identifier,
    ACTIONS(1267), 1,
      anon_sym_RBRACE,
    STATE(594), 1,
      sym_block_comment,
    STATE(673), 1,
      sym_field_type,
    STATE(803), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
  [31968] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1269), 1,
      anon_sym_RPAREN,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1273), 1,
      sym__virtual_end_section,
    STATE(595), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(772), 1,
      sym__more_when_is_branches,
  [31993] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1275), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(596), 1,
      sym_block_comment,
    STATE(598), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32016] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1275), 1,
      anon_sym_DQUOTE,
    STATE(597), 1,
      sym_block_comment,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32039] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1277), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(598), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32062] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1277), 1,
      anon_sym_DQUOTE,
    STATE(599), 1,
      sym_block_comment,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32085] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1265), 1,
      sym_lower_case_identifier,
    ACTIONS(1279), 1,
      anon_sym_RBRACE,
    STATE(600), 1,
      sym_block_comment,
    STATE(693), 1,
      sym_field_type,
    STATE(813), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
  [32110] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1281), 1,
      anon_sym_RPAREN,
    ACTIONS(1283), 1,
      sym__virtual_end_section,
    STATE(601), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(774), 1,
      sym__more_when_is_branches,
  [32135] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1285), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(602), 1,
      sym_block_comment,
    STATE(604), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32158] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1285), 1,
      anon_sym_DQUOTE,
    STATE(603), 1,
      sym_block_comment,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32181] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1287), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(604), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32204] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1287), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      sym_block_comment,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32227] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1265), 1,
      sym_lower_case_identifier,
    ACTIONS(1289), 1,
      anon_sym_RBRACE,
    STATE(606), 1,
      sym_block_comment,
    STATE(710), 1,
      sym_field_type,
    STATE(821), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
  [32252] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1293), 1,
      sym_arrow,
    STATE(587), 1,
      aux_sym_type_expression_repeat1,
    STATE(607), 1,
      sym_block_comment,
    ACTIONS(1291), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [32273] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1295), 1,
      anon_sym_RPAREN,
    ACTIONS(1297), 1,
      sym__virtual_end_section,
    STATE(608), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(826), 1,
      sym__more_when_is_branches,
  [32298] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1299), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(609), 1,
      sym_block_comment,
    STATE(611), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32321] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1299), 1,
      anon_sym_DQUOTE,
    STATE(610), 1,
      sym_block_comment,
    STATE(612), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32344] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1301), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(611), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32367] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1301), 1,
      anon_sym_DQUOTE,
    STATE(612), 1,
      sym_block_comment,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32390] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1303), 1,
      anon_sym_RPAREN,
    ACTIONS(1305), 1,
      sym__virtual_end_section,
    STATE(613), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(778), 1,
      sym__more_when_is_branches,
  [32415] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1307), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(614), 1,
      sym_block_comment,
    STATE(616), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32438] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1307), 1,
      anon_sym_DQUOTE,
    STATE(615), 1,
      sym_block_comment,
    STATE(617), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32461] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1309), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(616), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32484] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1309), 1,
      anon_sym_DQUOTE,
    STATE(617), 1,
      sym_block_comment,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32507] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1311), 1,
      anon_sym_RPAREN,
    ACTIONS(1313), 1,
      sym__virtual_end_section,
    STATE(618), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(793), 1,
      sym__more_when_is_branches,
  [32532] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1315), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(619), 1,
      sym_block_comment,
    STATE(621), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32555] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1315), 1,
      anon_sym_DQUOTE,
    STATE(620), 1,
      sym_block_comment,
    STATE(622), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32578] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1317), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(621), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32601] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1317), 1,
      anon_sym_DQUOTE,
    STATE(622), 1,
      sym_block_comment,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32624] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1319), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(623), 1,
      sym_block_comment,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1244), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32647] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1321), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1323), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(624), 2,
      sym_block_comment,
      aux_sym_string_constant_expr_repeat1,
  [32668] = 6,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1329), 1,
      anon_sym_DQUOTE,
    ACTIONS(1331), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1334), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(625), 2,
      sym_block_comment,
      aux_sym_string_constant_expr_repeat2,
  [32689] = 7,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1238), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1319), 1,
      anon_sym_DQUOTE,
    STATE(625), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(626), 1,
      sym_block_comment,
    ACTIONS(1240), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [32712] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1293), 1,
      sym_arrow,
    STATE(607), 1,
      aux_sym_type_expression_repeat1,
    STATE(627), 1,
      sym_block_comment,
    ACTIONS(1337), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [32733] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1265), 1,
      sym_lower_case_identifier,
    ACTIONS(1339), 1,
      anon_sym_RBRACE,
    STATE(628), 1,
      sym_block_comment,
    STATE(735), 1,
      sym_field_type,
    STATE(794), 1,
      sym__record_base,
    STATE(885), 1,
      sym_record_base_identifier,
  [32758] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1341), 1,
      anon_sym_RPAREN,
    ACTIONS(1343), 1,
      sym__virtual_end_section,
    STATE(629), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(839), 1,
      sym__more_when_is_branches,
  [32783] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1345), 1,
      sym__virtual_end_section,
    STATE(630), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(928), 1,
      sym__more_when_is_branches,
  [32805] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1347), 1,
      anon_sym_LPAREN,
    STATE(631), 1,
      sym_block_comment,
    STATE(782), 1,
      sym_exposed_union_constructors,
    ACTIONS(1349), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [32825] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(82), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(188), 1,
      sym__field_access_segment,
    STATE(632), 1,
      sym_block_comment,
    STATE(991), 1,
      sym__dot_without_leading_whitespace,
  [32847] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1351), 1,
      sym_lower_case_identifier,
    ACTIONS(1353), 1,
      sym_eq,
    STATE(633), 1,
      sym_block_comment,
    STATE(645), 1,
      aux_sym_type_declaration_repeat1,
    STATE(799), 1,
      sym_lower_type_name,
  [32869] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1355), 1,
      sym_arrow,
    STATE(634), 1,
      sym_block_comment,
    STATE(638), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(1337), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [32889] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(65), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(102), 1,
      sym__field_access_segment,
    STATE(635), 1,
      sym_block_comment,
    STATE(847), 1,
      sym__dot_without_leading_whitespace,
  [32911] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1359), 1,
      sym__virtual_end_decl,
    ACTIONS(1357), 2,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    STATE(636), 2,
      sym_block_comment,
      aux_sym__more_when_is_branches_repeat1,
  [32929] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1362), 1,
      sym__virtual_end_section,
    STATE(637), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(856), 1,
      sym__more_when_is_branches,
  [32951] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1355), 1,
      sym_arrow,
    STATE(638), 1,
      sym_block_comment,
    STATE(639), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(1291), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [32971] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1364), 1,
      sym_arrow,
    ACTIONS(1246), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    STATE(639), 2,
      sym_block_comment,
      aux_sym_type_expression_repeat1,
  [32989] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1367), 1,
      anon_sym_PIPE,
    ACTIONS(1370), 1,
      sym__virtual_end_decl,
    STATE(795), 1,
      sym__more_union_variants,
    STATE(640), 2,
      sym_block_comment,
      aux_sym_type_declaration_repeat2,
  [33009] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(20), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(36), 1,
      sym__field_access_segment,
    STATE(641), 1,
      sym_block_comment,
    STATE(933), 1,
      sym__dot_without_leading_whitespace,
  [33031] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1372), 1,
      sym__virtual_end_section,
    STATE(642), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(849), 1,
      sym__more_when_is_branches,
  [33053] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(298), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(345), 1,
      sym__field_access_segment,
    STATE(643), 1,
      sym_block_comment,
    STATE(877), 1,
      sym__dot_without_leading_whitespace,
  [33075] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1374), 1,
      sym__virtual_end_section,
    STATE(644), 1,
      sym_block_comment,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(884), 1,
      sym__more_when_is_branches,
  [33097] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1351), 1,
      sym_lower_case_identifier,
    ACTIONS(1376), 1,
      sym_eq,
    STATE(645), 1,
      sym_block_comment,
    STATE(660), 1,
      aux_sym_type_declaration_repeat1,
    STATE(799), 1,
      sym_lower_type_name,
  [33119] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    STATE(636), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(646), 1,
      sym_block_comment,
    ACTIONS(1378), 2,
      sym__virtual_end_section,
      anon_sym_RPAREN,
  [33139] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1351), 1,
      sym_lower_case_identifier,
    ACTIONS(1380), 1,
      sym_eq,
    STATE(647), 1,
      sym_block_comment,
    STATE(661), 1,
      aux_sym_type_declaration_repeat1,
    STATE(799), 1,
      sym_lower_type_name,
  [33161] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1382), 1,
      anon_sym_PIPE,
    ACTIONS(1384), 1,
      sym__virtual_end_decl,
    STATE(640), 1,
      aux_sym_type_declaration_repeat2,
    STATE(648), 1,
      sym_block_comment,
    STATE(795), 1,
      sym__more_union_variants,
  [33183] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1382), 1,
      anon_sym_PIPE,
    ACTIONS(1386), 1,
      sym__virtual_end_decl,
    STATE(649), 1,
      sym_block_comment,
    STATE(651), 1,
      aux_sym_type_declaration_repeat2,
    STATE(795), 1,
      sym__more_union_variants,
  [33205] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1390), 1,
      aux_sym_string_constant_expr_token1,
    STATE(650), 1,
      sym_block_comment,
    ACTIONS(1388), 3,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_string_escape,
      sym_invalid_string_escape,
  [33223] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1382), 1,
      anon_sym_PIPE,
    ACTIONS(1392), 1,
      sym__virtual_end_decl,
    STATE(640), 1,
      aux_sym_type_declaration_repeat2,
    STATE(651), 1,
      sym_block_comment,
    STATE(795), 1,
      sym__more_union_variants,
  [33245] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(652), 1,
      sym_block_comment,
    ACTIONS(1394), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [33261] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(331), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(414), 1,
      sym__field_access_segment,
    STATE(653), 1,
      sym_block_comment,
    STATE(887), 1,
      sym__dot_without_leading_whitespace,
  [33283] = 5,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    ACTIONS(1398), 1,
      aux_sym_string_constant_expr_token2,
    STATE(654), 1,
      sym_block_comment,
    ACTIONS(1396), 3,
      anon_sym_DQUOTE,
      sym_string_escape,
      sym_invalid_string_escape,
  [33301] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(263), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(281), 1,
      sym__field_access_segment,
    STATE(655), 1,
      sym_block_comment,
    STATE(905), 1,
      sym__dot_without_leading_whitespace,
  [33323] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1382), 1,
      anon_sym_PIPE,
    ACTIONS(1400), 1,
      sym__virtual_end_decl,
    STATE(648), 1,
      aux_sym_type_declaration_repeat2,
    STATE(656), 1,
      sym_block_comment,
    STATE(795), 1,
      sym__more_union_variants,
  [33345] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1402), 1,
      sym__virtual_end_section,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(657), 1,
      sym_block_comment,
    STATE(922), 1,
      sym__more_when_is_branches,
  [33367] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(658), 1,
      sym_block_comment,
    ACTIONS(1404), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [33383] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(659), 1,
      sym_block_comment,
    ACTIONS(1406), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [33399] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1408), 1,
      sym_lower_case_identifier,
    ACTIONS(1411), 1,
      sym_eq,
    STATE(799), 1,
      sym_lower_type_name,
    STATE(660), 2,
      sym_block_comment,
      aux_sym_type_declaration_repeat1,
  [33419] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1351), 1,
      sym_lower_case_identifier,
    ACTIONS(1413), 1,
      sym_eq,
    STATE(660), 1,
      aux_sym_type_declaration_repeat1,
    STATE(661), 1,
      sym_block_comment,
    STATE(799), 1,
      sym_lower_type_name,
  [33441] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym__virtual_end_decl,
    ACTIONS(1415), 1,
      sym__virtual_end_section,
    STATE(646), 1,
      aux_sym__more_when_is_branches_repeat1,
    STATE(662), 1,
      sym_block_comment,
    STATE(854), 1,
      sym__more_when_is_branches,
  [33463] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1419), 1,
      anon_sym_RBRACK,
    STATE(663), 1,
      sym_block_comment,
    STATE(741), 1,
      aux_sym_list_expr_repeat1,
  [33482] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1421), 1,
      anon_sym_else,
    STATE(452), 1,
      sym__else,
    STATE(664), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_if_else_expr_repeat1,
  [33501] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_COMMA,
    ACTIONS(1426), 1,
      anon_sym_RBRACE,
    STATE(665), 2,
      sym_block_comment,
      aux_sym_record_type_repeat1,
  [33518] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1430), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(666), 1,
      sym_block_comment,
  [33537] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(667), 1,
      sym_block_comment,
    ACTIONS(1394), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [33552] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1432), 1,
      anon_sym_COMMA,
    ACTIONS(1434), 1,
      anon_sym_RPAREN,
    STATE(668), 1,
      sym_block_comment,
    STATE(696), 1,
      aux_sym_exposing_list_repeat1,
  [33571] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1421), 1,
      anon_sym_else,
    STATE(444), 1,
      sym__else,
    STATE(664), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(669), 1,
      sym_block_comment,
  [33590] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1257), 1,
      sym_exposing,
    ACTIONS(1436), 1,
      sym__virtual_end_decl,
    STATE(670), 1,
      sym_block_comment,
    STATE(913), 1,
      sym_exposing_list,
  [33609] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1438), 1,
      anon_sym_COMMA,
    ACTIONS(1440), 1,
      anon_sym_RBRACE,
    STATE(671), 1,
      sym_block_comment,
    STATE(672), 1,
      aux_sym__record_inner_repeat1,
  [33628] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1442), 1,
      anon_sym_COMMA,
    ACTIONS(1445), 1,
      anon_sym_RBRACE,
    STATE(672), 2,
      sym_block_comment,
      aux_sym__record_inner_repeat1,
  [33645] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1447), 1,
      anon_sym_RBRACE,
    STATE(673), 1,
      sym_block_comment,
    STATE(678), 1,
      aux_sym_record_type_repeat1,
  [33664] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1449), 1,
      anon_sym_RBRACK,
    STATE(674), 1,
      sym_block_comment,
    STATE(680), 1,
      aux_sym_list_expr_repeat1,
  [33683] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1451), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1453), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(675), 1,
      sym_block_comment,
    STATE(681), 1,
      aux_sym_value_qid_repeat1,
  [33702] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1455), 1,
      anon_sym_COMMA,
    ACTIONS(1458), 1,
      anon_sym_RBRACK,
    STATE(676), 2,
      sym_block_comment,
      aux_sym_list_expr_repeat1,
  [33719] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1460), 1,
      anon_sym_else,
    STATE(297), 1,
      sym__else,
    STATE(677), 1,
      sym_block_comment,
    STATE(691), 1,
      aux_sym_if_else_expr_repeat1,
  [33738] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1462), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(678), 1,
      sym_block_comment,
  [33757] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1464), 1,
      anon_sym_RBRACE,
    STATE(679), 1,
      sym_block_comment,
    STATE(684), 1,
      aux_sym_record_type_repeat1,
  [33776] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1466), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      aux_sym_list_expr_repeat1,
    STATE(680), 1,
      sym_block_comment,
  [33795] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1468), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1470), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(681), 1,
      sym_block_comment,
    STATE(688), 1,
      aux_sym_value_qid_repeat1,
  [33814] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1474), 1,
      sym__virtual_end_section,
    STATE(682), 1,
      sym_block_comment,
    STATE(705), 1,
      aux_sym_let_in_expr_repeat1,
  [33833] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1476), 1,
      anon_sym_else,
    STATE(210), 1,
      sym__else,
    STATE(683), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_if_else_expr_repeat1,
  [33852] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1478), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(684), 1,
      sym_block_comment,
  [33871] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1480), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(685), 1,
      sym_block_comment,
  [33890] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(297), 1,
      sym__else,
    STATE(686), 1,
      sym_block_comment,
    STATE(691), 1,
      aux_sym_if_else_expr_repeat1,
  [33909] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(687), 1,
      sym_block_comment,
    ACTIONS(1484), 3,
      anon_sym_left,
      anon_sym_right,
      anon_sym_non,
  [33924] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1486), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1489), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(688), 2,
      sym_block_comment,
      aux_sym_value_qid_repeat1,
  [33941] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1491), 1,
      anon_sym_else,
    STATE(48), 1,
      sym__else,
    STATE(689), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_if_else_expr_repeat1,
  [33960] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1493), 1,
      anon_sym_RBRACE,
    STATE(666), 1,
      aux_sym_record_type_repeat1,
    STATE(690), 1,
      sym_block_comment,
  [33979] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1460), 1,
      anon_sym_else,
    STATE(289), 1,
      sym__else,
    STATE(691), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_if_else_expr_repeat1,
  [33998] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1246), 1,
      sym__virtual_end_decl,
    ACTIONS(1495), 1,
      sym_arrow,
    STATE(692), 2,
      sym_block_comment,
      aux_sym_type_expression_repeat1,
  [34015] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1498), 1,
      anon_sym_RBRACE,
    STATE(693), 1,
      sym_block_comment,
    STATE(698), 1,
      aux_sym_record_type_repeat1,
  [34034] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1500), 1,
      anon_sym_RBRACK,
    STATE(694), 1,
      sym_block_comment,
    STATE(700), 1,
      aux_sym_list_expr_repeat1,
  [34053] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1502), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1504), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(695), 1,
      sym_block_comment,
    STATE(701), 1,
      aux_sym_value_qid_repeat1,
  [34072] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1506), 1,
      anon_sym_COMMA,
    ACTIONS(1509), 1,
      anon_sym_RPAREN,
    STATE(696), 2,
      sym_block_comment,
      aux_sym_exposing_list_repeat1,
  [34089] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1476), 1,
      anon_sym_else,
    STATE(222), 1,
      sym__else,
    STATE(683), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(697), 1,
      sym_block_comment,
  [34108] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1511), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(698), 1,
      sym_block_comment,
  [34127] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1513), 1,
      anon_sym_RBRACE,
    STATE(699), 1,
      sym_block_comment,
    STATE(702), 1,
      aux_sym_record_type_repeat1,
  [34146] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1515), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      aux_sym_list_expr_repeat1,
    STATE(700), 1,
      sym_block_comment,
  [34165] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1468), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1517), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(688), 1,
      aux_sym_value_qid_repeat1,
    STATE(701), 1,
      sym_block_comment,
  [34184] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1519), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(702), 1,
      sym_block_comment,
  [34203] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(222), 1,
      sym__else,
    STATE(683), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(703), 1,
      sym_block_comment,
  [34222] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1521), 1,
      anon_sym_COMMA,
    ACTIONS(1523), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_block_comment,
    STATE(734), 1,
      aux_sym_record_pattern_repeat1,
  [34241] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1525), 1,
      sym__virtual_end_decl,
    ACTIONS(1528), 1,
      sym__virtual_end_section,
    STATE(705), 2,
      sym_block_comment,
      aux_sym_let_in_expr_repeat1,
  [34258] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1432), 1,
      anon_sym_COMMA,
    ACTIONS(1530), 1,
      anon_sym_RPAREN,
    STATE(668), 1,
      aux_sym_exposing_list_repeat1,
    STATE(706), 1,
      sym_block_comment,
  [34277] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1532), 1,
      anon_sym_else,
    STATE(371), 1,
      sym__else,
    STATE(707), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_if_else_expr_repeat1,
  [34296] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(444), 1,
      sym__else,
    STATE(664), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(708), 1,
      sym_block_comment,
  [34315] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      sym__virtual_end_decl,
    ACTIONS(1534), 1,
      sym_arrow,
    STATE(709), 1,
      sym_block_comment,
    STATE(749), 1,
      aux_sym_type_expression_repeat1,
  [34334] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1536), 1,
      anon_sym_RBRACE,
    STATE(710), 1,
      sym_block_comment,
    STATE(714), 1,
      aux_sym_record_type_repeat1,
  [34353] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1538), 1,
      anon_sym_RBRACK,
    STATE(711), 1,
      sym_block_comment,
    STATE(716), 1,
      aux_sym_list_expr_repeat1,
  [34372] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1540), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1542), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(712), 1,
      sym_block_comment,
    STATE(717), 1,
      aux_sym_value_qid_repeat1,
  [34391] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1491), 1,
      anon_sym_else,
    STATE(44), 1,
      sym__else,
    STATE(689), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(713), 1,
      sym_block_comment,
  [34410] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1544), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(714), 1,
      sym_block_comment,
  [34429] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1546), 1,
      anon_sym_RBRACE,
    STATE(715), 1,
      sym_block_comment,
    STATE(718), 1,
      aux_sym_record_type_repeat1,
  [34448] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1548), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      aux_sym_list_expr_repeat1,
    STATE(716), 1,
      sym_block_comment,
  [34467] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1468), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1550), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(688), 1,
      aux_sym_value_qid_repeat1,
    STATE(717), 1,
      sym_block_comment,
  [34486] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1552), 1,
      anon_sym_RBRACE,
    STATE(665), 1,
      aux_sym_record_type_repeat1,
    STATE(718), 1,
      sym_block_comment,
  [34505] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(44), 1,
      sym__else,
    STATE(689), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(719), 1,
      sym_block_comment,
  [34524] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(720), 1,
      sym_block_comment,
    ACTIONS(1554), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [34539] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1556), 1,
      anon_sym_COMMA,
    ACTIONS(1559), 1,
      anon_sym_RBRACE,
    STATE(721), 2,
      sym_block_comment,
      aux_sym_record_pattern_repeat1,
  [34556] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_else,
    STATE(185), 1,
      sym__else,
    STATE(722), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_if_else_expr_repeat1,
  [34575] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1563), 1,
      anon_sym_COMMA,
    ACTIONS(1566), 1,
      anon_sym_RBRACK,
    STATE(723), 2,
      sym_block_comment,
      aux_sym_list_pattern_repeat1,
  [34592] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(724), 1,
      sym_block_comment,
    ACTIONS(1568), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
  [34607] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1570), 1,
      anon_sym_RBRACK,
    STATE(725), 1,
      sym_block_comment,
    STATE(728), 1,
      aux_sym_list_expr_repeat1,
  [34626] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1572), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1574), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(726), 1,
      sym_block_comment,
    STATE(729), 1,
      aux_sym_value_qid_repeat1,
  [34645] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1532), 1,
      anon_sym_else,
    STATE(367), 1,
      sym__else,
    STATE(707), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(727), 1,
      sym_block_comment,
  [34664] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1576), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      aux_sym_list_expr_repeat1,
    STATE(728), 1,
      sym_block_comment,
  [34683] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1468), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1578), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(688), 1,
      aux_sym_value_qid_repeat1,
    STATE(729), 1,
      sym_block_comment,
  [34702] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(367), 1,
      sym__else,
    STATE(707), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(730), 1,
      sym_block_comment,
  [34721] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1438), 1,
      anon_sym_COMMA,
    ACTIONS(1580), 1,
      anon_sym_RBRACE,
    STATE(671), 1,
      aux_sym__record_inner_repeat1,
    STATE(731), 1,
      sym_block_comment,
  [34740] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(732), 1,
      sym_block_comment,
    ACTIONS(1582), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
  [34755] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1438), 1,
      anon_sym_COMMA,
    ACTIONS(1584), 1,
      anon_sym_RBRACE,
    STATE(672), 1,
      aux_sym__record_inner_repeat1,
    STATE(733), 1,
      sym_block_comment,
  [34774] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1521), 1,
      anon_sym_COMMA,
    ACTIONS(1586), 1,
      anon_sym_RBRACE,
    STATE(721), 1,
      aux_sym_record_pattern_repeat1,
    STATE(734), 1,
      sym_block_comment,
  [34793] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1428), 1,
      anon_sym_COMMA,
    ACTIONS(1588), 1,
      anon_sym_RBRACE,
    STATE(685), 1,
      aux_sym_record_type_repeat1,
    STATE(735), 1,
      sym_block_comment,
  [34812] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1590), 1,
      anon_sym_RBRACK,
    STATE(736), 1,
      sym_block_comment,
    STATE(739), 1,
      aux_sym_list_expr_repeat1,
  [34831] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1592), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1594), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(737), 1,
      sym_block_comment,
    STATE(740), 1,
      aux_sym_value_qid_repeat1,
  [34850] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_else,
    STATE(182), 1,
      sym__else,
    STATE(722), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(738), 1,
      sym_block_comment,
  [34869] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1596), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      aux_sym_list_expr_repeat1,
    STATE(739), 1,
      sym_block_comment,
  [34888] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1468), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1598), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(688), 1,
      aux_sym_value_qid_repeat1,
    STATE(740), 1,
      sym_block_comment,
  [34907] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_COMMA,
    ACTIONS(1600), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      aux_sym_list_expr_repeat1,
    STATE(741), 1,
      sym_block_comment,
  [34926] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(182), 1,
      sym__else,
    STATE(722), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(742), 1,
      sym_block_comment,
  [34945] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1602), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1604), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(743), 1,
      sym_block_comment,
    STATE(748), 1,
      aux_sym_value_qid_repeat1,
  [34964] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(744), 1,
      sym_block_comment,
    ACTIONS(1404), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [34979] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(745), 1,
      sym_block_comment,
    ACTIONS(1406), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [34994] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(746), 1,
      sym_block_comment,
    ACTIONS(1606), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35009] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1608), 1,
      sym__virtual_end_section,
    STATE(682), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(747), 1,
      sym_block_comment,
  [35028] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1468), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1610), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(688), 1,
      aux_sym_value_qid_repeat1,
    STATE(748), 1,
      sym_block_comment,
  [35047] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1291), 1,
      sym__virtual_end_decl,
    ACTIONS(1534), 1,
      sym_arrow,
    STATE(692), 1,
      aux_sym_type_expression_repeat1,
    STATE(749), 1,
      sym_block_comment,
  [35066] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1612), 1,
      sym__virtual_end_section,
    STATE(750), 1,
      sym_block_comment,
    STATE(751), 1,
      aux_sym_let_in_expr_repeat1,
  [35085] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1614), 1,
      sym__virtual_end_section,
    STATE(705), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(751), 1,
      sym_block_comment,
  [35104] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(752), 1,
      sym_block_comment,
    ACTIONS(1616), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35119] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1618), 1,
      sym__virtual_end_section,
    STATE(753), 1,
      sym_block_comment,
    STATE(754), 1,
      aux_sym_let_in_expr_repeat1,
  [35138] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1620), 1,
      sym__virtual_end_section,
    STATE(705), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(754), 1,
      sym_block_comment,
  [35157] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(755), 1,
      sym_block_comment,
    ACTIONS(1622), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35172] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1624), 1,
      sym__virtual_end_section,
    STATE(756), 1,
      sym_block_comment,
    STATE(757), 1,
      aux_sym_let_in_expr_repeat1,
  [35191] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1626), 1,
      sym__virtual_end_section,
    STATE(705), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(757), 1,
      sym_block_comment,
  [35210] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(758), 1,
      sym_block_comment,
    ACTIONS(1628), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35225] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1630), 1,
      anon_sym_COMMA,
    ACTIONS(1632), 1,
      anon_sym_RBRACK,
    STATE(723), 1,
      aux_sym_list_pattern_repeat1,
    STATE(759), 1,
      sym_block_comment,
  [35244] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1634), 1,
      sym__virtual_end_section,
    STATE(760), 1,
      sym_block_comment,
    STATE(761), 1,
      aux_sym_let_in_expr_repeat1,
  [35263] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1636), 1,
      sym__virtual_end_section,
    STATE(705), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(761), 1,
      sym_block_comment,
  [35282] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(762), 1,
      sym_block_comment,
    ACTIONS(1638), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35297] = 4,
    ACTIONS(44), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(46), 1,
      sym_line_comment,
    STATE(763), 1,
      sym_block_comment,
    ACTIONS(1640), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35312] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1642), 1,
      sym__virtual_end_section,
    STATE(764), 1,
      sym_block_comment,
    STATE(765), 1,
      aux_sym_let_in_expr_repeat1,
  [35331] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1472), 1,
      sym__virtual_end_decl,
    ACTIONS(1644), 1,
      sym__virtual_end_section,
    STATE(705), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(765), 1,
      sym_block_comment,
  [35350] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1630), 1,
      anon_sym_COMMA,
    ACTIONS(1646), 1,
      anon_sym_RBRACK,
    STATE(759), 1,
      aux_sym_list_pattern_repeat1,
    STATE(766), 1,
      sym_block_comment,
  [35369] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1438), 1,
      anon_sym_COMMA,
    ACTIONS(1648), 1,
      anon_sym_RBRACE,
    STATE(733), 1,
      aux_sym__record_inner_repeat1,
    STATE(767), 1,
      sym_block_comment,
  [35388] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(686), 1,
      sym__then,
    STATE(768), 1,
      sym_block_comment,
  [35404] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(769), 1,
      sym_block_comment,
    ACTIONS(1652), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
  [35418] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(770), 1,
      sym_block_comment,
    ACTIONS(1654), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [35432] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1257), 1,
      sym_exposing,
    STATE(771), 1,
      sym_block_comment,
    STATE(871), 1,
      sym_exposing_list,
  [35448] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1656), 1,
      anon_sym_RPAREN,
    ACTIONS(1658), 1,
      sym__virtual_end_section,
    STATE(772), 1,
      sym_block_comment,
  [35464] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(499), 1,
      sym_lower_pattern,
    STATE(773), 1,
      sym_block_comment,
  [35480] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1660), 1,
      anon_sym_RPAREN,
    ACTIONS(1662), 1,
      sym__virtual_end_section,
    STATE(774), 1,
      sym_block_comment,
  [35496] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(775), 1,
      sym_block_comment,
    ACTIONS(1664), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [35510] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(776), 1,
      sym_block_comment,
    ACTIONS(1666), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [35524] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(704), 1,
      sym_lower_pattern,
    STATE(777), 1,
      sym_block_comment,
  [35540] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1668), 1,
      anon_sym_RPAREN,
    ACTIONS(1670), 1,
      sym__virtual_end_section,
    STATE(778), 1,
      sym_block_comment,
  [35556] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    STATE(779), 1,
      sym_block_comment,
    STATE(988), 1,
      sym_upper_case_qid,
  [35572] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1672), 1,
      sym_lower_case_identifier,
    STATE(780), 1,
      sym_block_comment,
    STATE(810), 1,
      sym_field,
  [35588] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(708), 1,
      sym__then,
    STATE(781), 1,
      sym_block_comment,
  [35604] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(782), 1,
      sym_block_comment,
    ACTIONS(1674), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [35618] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1676), 1,
      anon_sym_PIPE,
    ACTIONS(1678), 1,
      sym_colon,
    STATE(783), 1,
      sym_block_comment,
  [35634] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(669), 1,
      sym__then,
    STATE(784), 1,
      sym_block_comment,
  [35650] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(785), 1,
      sym_block_comment,
    ACTIONS(1680), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [35664] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1257), 1,
      sym_exposing,
    STATE(786), 1,
      sym_block_comment,
    STATE(934), 1,
      sym_exposing_list,
  [35680] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1682), 1,
      anon_sym_else,
    STATE(787), 2,
      sym_block_comment,
      aux_sym_if_else_expr_repeat1,
  [35694] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(788), 1,
      sym_block_comment,
    ACTIONS(1404), 2,
      sym__virtual_end_decl,
      sym_arrow,
  [35708] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1685), 1,
      anon_sym_if,
    STATE(789), 1,
      sym_block_comment,
    STATE(829), 1,
      sym__if,
  [35724] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(790), 1,
      sym_block_comment,
    ACTIONS(1687), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [35738] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1689), 1,
      sym_upper_case_identifier,
    STATE(769), 1,
      sym_union_variant,
    STATE(791), 1,
      sym_block_comment,
  [35754] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(495), 1,
      sym_lower_pattern,
    STATE(792), 1,
      sym_block_comment,
  [35770] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1691), 1,
      anon_sym_RPAREN,
    ACTIONS(1693), 1,
      sym__virtual_end_section,
    STATE(793), 1,
      sym_block_comment,
  [35786] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1695), 1,
      sym_lower_case_identifier,
    STATE(690), 1,
      sym_field_type,
    STATE(794), 1,
      sym_block_comment,
  [35802] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(795), 1,
      sym_block_comment,
    ACTIONS(1697), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
  [35816] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(796), 1,
      sym_block_comment,
    ACTIONS(1699), 2,
      sym_lower_case_identifier,
      sym_eq,
  [35830] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(797), 1,
      sym_block_comment,
    ACTIONS(1701), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [35844] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(798), 1,
      sym_block_comment,
    ACTIONS(1703), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [35858] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(799), 1,
      sym_block_comment,
    ACTIONS(1705), 2,
      sym_lower_case_identifier,
      sym_eq,
  [35872] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1695), 1,
      sym_lower_case_identifier,
    STATE(776), 1,
      sym_field_type,
    STATE(800), 1,
      sym_block_comment,
  [35888] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(801), 1,
      sym_block_comment,
    ACTIONS(1394), 2,
      sym__virtual_end_decl,
      sym_arrow,
  [35902] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(677), 1,
      sym__then,
    STATE(802), 1,
      sym_block_comment,
  [35918] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1695), 1,
      sym_lower_case_identifier,
    STATE(679), 1,
      sym_field_type,
    STATE(803), 1,
      sym_block_comment,
  [35934] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(804), 1,
      sym_block_comment,
    ACTIONS(1707), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [35948] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(805), 1,
      sym_block_comment,
    ACTIONS(1509), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [35962] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(806), 1,
      sym_block_comment,
    ACTIONS(1709), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [35976] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1711), 1,
      sym_upper_case_identifier,
    ACTIONS(1713), 1,
      sym_alias,
    STATE(807), 1,
      sym_block_comment,
  [35992] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(456), 1,
      anon_sym_DOT,
    STATE(808), 1,
      sym_block_comment,
    STATE(827), 1,
      sym__dot_without_leading_whitespace,
  [36008] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(809), 1,
      sym_block_comment,
    ACTIONS(1715), 2,
      sym__virtual_end_decl,
      sym_exposing,
  [36022] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(810), 1,
      sym_block_comment,
    ACTIONS(1717), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [36036] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    STATE(811), 1,
      sym_block_comment,
    STATE(837), 1,
      sym_upper_case_qid,
  [36052] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(697), 1,
      sym__then,
    STATE(812), 1,
      sym_block_comment,
  [36068] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1695), 1,
      sym_lower_case_identifier,
    STATE(699), 1,
      sym_field_type,
    STATE(813), 1,
      sym_block_comment,
  [36084] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1113), 1,
      sym_upper_case_identifier,
    STATE(589), 1,
      sym_upper_case_qid,
    STATE(814), 1,
      sym_block_comment,
  [36100] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(815), 1,
      sym_block_comment,
    ACTIONS(1406), 2,
      sym__virtual_end_decl,
      sym_arrow,
  [36114] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1689), 1,
      sym_upper_case_identifier,
    STATE(649), 1,
      sym_union_variant,
    STATE(816), 1,
      sym_block_comment,
  [36130] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(703), 1,
      sym__then,
    STATE(817), 1,
      sym_block_comment,
  [36146] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(818), 1,
      sym_block_comment,
    ACTIONS(1719), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [36160] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(819), 1,
      sym_block_comment,
    ACTIONS(1721), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [36174] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(713), 1,
      sym__then,
    STATE(820), 1,
      sym_block_comment,
  [36190] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1695), 1,
      sym_lower_case_identifier,
    STATE(715), 1,
      sym_field_type,
    STATE(821), 1,
      sym_block_comment,
  [36206] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1689), 1,
      sym_upper_case_identifier,
    STATE(656), 1,
      sym_union_variant,
    STATE(822), 1,
      sym_block_comment,
  [36222] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(823), 1,
      sym_block_comment,
    ACTIONS(1723), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [36236] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(719), 1,
      sym__then,
    STATE(824), 1,
      sym_block_comment,
  [36252] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    STATE(771), 1,
      sym_upper_case_qid,
    STATE(825), 1,
      sym_block_comment,
  [36268] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1725), 1,
      anon_sym_RPAREN,
    ACTIONS(1727), 1,
      sym__virtual_end_section,
    STATE(826), 1,
      sym_block_comment,
  [36284] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(827), 1,
      sym_block_comment,
    ACTIONS(1489), 2,
      sym__upper_case_identifier_without_leading_whitespace,
      sym__lower_case_identifier_without_leading_whitespace,
  [36298] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(727), 1,
      sym__then,
    STATE(828), 1,
      sym_block_comment,
  [36314] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(829), 1,
      sym_block_comment,
    STATE(859), 1,
      sym__then,
  [36330] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1729), 1,
      sym_lower_case_identifier,
    ACTIONS(1731), 1,
      sym_module,
    STATE(830), 1,
      sym_block_comment,
  [36346] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(730), 1,
      sym__then,
    STATE(831), 1,
      sym_block_comment,
  [36362] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(832), 1,
      sym_block_comment,
    ACTIONS(1733), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [36376] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(738), 1,
      sym__then,
    STATE(833), 1,
      sym_block_comment,
  [36392] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1650), 1,
      anon_sym_then,
    STATE(742), 1,
      sym__then,
    STATE(834), 1,
      sym_block_comment,
  [36408] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(835), 1,
      sym_block_comment,
    ACTIONS(1735), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [36422] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(839), 1,
      sym_lower_case_identifier,
    STATE(823), 1,
      sym_lower_pattern,
    STATE(836), 1,
      sym_block_comment,
  [36438] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1257), 1,
      sym_exposing,
    STATE(837), 1,
      sym_block_comment,
    STATE(944), 1,
      sym_exposing_list,
  [36454] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1198), 1,
      anon_sym_LPAREN,
    STATE(838), 1,
      sym_block_comment,
    STATE(949), 1,
      sym__operator_as_function_inner,
  [36470] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1737), 1,
      anon_sym_RPAREN,
    ACTIONS(1739), 1,
      sym__virtual_end_section,
    STATE(839), 1,
      sym_block_comment,
  [36486] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(840), 1,
      sym_block_comment,
    ACTIONS(1741), 2,
      sym__upper_case_identifier_without_leading_whitespace,
      sym__lower_case_identifier_without_leading_whitespace,
  [36500] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(841), 1,
      sym_block_comment,
    ACTIONS(1743), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [36514] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1676), 1,
      anon_sym_PIPE,
    ACTIONS(1745), 1,
      sym_eq,
    STATE(842), 1,
      sym_block_comment,
  [36530] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1672), 1,
      sym_lower_case_identifier,
    STATE(731), 1,
      sym_field,
    STATE(843), 1,
      sym_block_comment,
  [36546] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    STATE(786), 1,
      sym_record_expr,
    STATE(844), 1,
      sym_block_comment,
  [36562] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1747), 1,
      sym__virtual_open_section,
    STATE(845), 1,
      sym_block_comment,
  [36575] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1749), 1,
      sym_lower_case_identifier,
    STATE(846), 1,
      sym_block_comment,
  [36588] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1751), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(847), 1,
      sym_block_comment,
  [36601] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1753), 1,
      anon_sym_RPAREN,
    STATE(848), 1,
      sym_block_comment,
  [36614] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1755), 1,
      sym__virtual_end_section,
    STATE(849), 1,
      sym_block_comment,
  [36627] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1757), 1,
      sym_upper_case_identifier,
    STATE(850), 1,
      sym_block_comment,
  [36640] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1759), 1,
      anon_sym_in,
    STATE(851), 1,
      sym_block_comment,
  [36653] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1761), 1,
      anon_sym_in,
    STATE(852), 1,
      sym_block_comment,
  [36666] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1745), 1,
      sym_eq,
    STATE(853), 1,
      sym_block_comment,
  [36679] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1763), 1,
      sym__virtual_end_section,
    STATE(854), 1,
      sym_block_comment,
  [36692] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1765), 1,
      sym__virtual_end_decl,
    STATE(855), 1,
      sym_block_comment,
  [36705] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1767), 1,
      sym__virtual_end_section,
    STATE(856), 1,
      sym_block_comment,
  [36718] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1769), 1,
      anon_sym_RPAREN,
    STATE(857), 1,
      sym_block_comment,
  [36731] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1771), 1,
      anon_sym_in,
    STATE(858), 1,
      sym_block_comment,
  [36744] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1482), 1,
      anon_sym_else,
    STATE(859), 1,
      sym_block_comment,
  [36757] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1773), 1,
      anon_sym_SQUOTE,
    STATE(860), 1,
      sym_block_comment,
  [36770] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1678), 1,
      sym_colon,
    STATE(861), 1,
      sym_block_comment,
  [36783] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1775), 1,
      anon_sym_SQUOTE,
    STATE(862), 1,
      sym_block_comment,
  [36796] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1777), 1,
      anon_sym_RPAREN,
    STATE(863), 1,
      sym_block_comment,
  [36809] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1779), 1,
      anon_sym_LPAREN,
    STATE(864), 1,
      sym_block_comment,
  [36822] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1781), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(865), 1,
      sym_block_comment,
  [36835] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    STATE(866), 1,
      sym_block_comment,
  [36848] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1785), 1,
      sym_arrow,
    STATE(867), 1,
      sym_block_comment,
  [36861] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
    STATE(868), 1,
      sym_block_comment,
  [36874] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1789), 1,
      anon_sym_RPAREN,
    STATE(869), 1,
      sym_block_comment,
  [36887] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1791), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(870), 1,
      sym_block_comment,
  [36900] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1793), 1,
      sym__virtual_end_decl,
    STATE(871), 1,
      sym_block_comment,
  [36913] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1795), 1,
      anon_sym_RPAREN,
    STATE(872), 1,
      sym_block_comment,
  [36926] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1797), 1,
      anon_sym_RPAREN,
    STATE(873), 1,
      sym_block_comment,
  [36939] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1799), 1,
      anon_sym_RBRACE,
    STATE(874), 1,
      sym_block_comment,
  [36952] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1801), 1,
      anon_sym_RBRACE,
    STATE(875), 1,
      sym_block_comment,
  [36965] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1803), 1,
      anon_sym_SQUOTE,
    STATE(876), 1,
      sym_block_comment,
  [36978] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1805), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(877), 1,
      sym_block_comment,
  [36991] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1212), 1,
      anon_sym_COLON_COLON,
    STATE(878), 1,
      sym_block_comment,
  [37004] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1807), 1,
      sym__virtual_end_decl,
    STATE(879), 1,
      sym_block_comment,
  [37017] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1809), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(880), 1,
      sym_block_comment,
  [37030] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1811), 1,
      sym__virtual_end_decl,
    STATE(881), 1,
      sym_block_comment,
  [37043] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1813), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(882), 1,
      sym_block_comment,
  [37056] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1815), 1,
      anon_sym_DASH_RBRACE,
    STATE(883), 1,
      sym_block_comment,
  [37069] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1817), 1,
      sym__virtual_end_section,
    STATE(884), 1,
      sym_block_comment,
  [37082] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1819), 1,
      anon_sym_PIPE,
    STATE(885), 1,
      sym_block_comment,
  [37095] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1821), 1,
      anon_sym_SQUOTE,
    STATE(886), 1,
      sym_block_comment,
  [37108] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1823), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(887), 1,
      sym_block_comment,
  [37121] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1825), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(888), 1,
      sym_block_comment,
  [37134] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1827), 1,
      sym_is,
    STATE(889), 1,
      sym_block_comment,
  [37147] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1829), 1,
      anon_sym_SQUOTE,
    STATE(890), 1,
      sym_block_comment,
  [37160] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1831), 1,
      anon_sym_RPAREN,
    STATE(891), 1,
      sym_block_comment,
  [37173] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1833), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(892), 1,
      sym_block_comment,
  [37186] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1835), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(893), 1,
      sym_block_comment,
  [37199] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1837), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(894), 1,
      sym_block_comment,
  [37212] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1839), 1,
      anon_sym_RPAREN,
    STATE(895), 1,
      sym_block_comment,
  [37225] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1841), 1,
      anon_sym_RPAREN,
    STATE(896), 1,
      sym_block_comment,
  [37238] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1843), 1,
      sym_eq,
    STATE(897), 1,
      sym_block_comment,
  [37251] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1845), 1,
      sym_eq,
    STATE(898), 1,
      sym_block_comment,
  [37264] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1105), 1,
      anon_sym_COLON_COLON,
    STATE(899), 1,
      sym_block_comment,
  [37277] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1847), 1,
      sym_upper_case_identifier,
    STATE(900), 1,
      sym_block_comment,
  [37290] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1849), 1,
      sym_colon,
    STATE(901), 1,
      sym_block_comment,
  [37303] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1851), 1,
      anon_sym_RBRACE,
    STATE(902), 1,
      sym_block_comment,
  [37316] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1853), 1,
      sym__virtual_end_decl,
    STATE(903), 1,
      sym_block_comment,
  [37329] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1743), 1,
      sym__virtual_end_decl,
    STATE(904), 1,
      sym_block_comment,
  [37342] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1855), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(905), 1,
      sym_block_comment,
  [37355] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1857), 1,
      anon_sym_in,
    STATE(906), 1,
      sym_block_comment,
  [37368] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1859), 1,
      anon_sym_RPAREN,
    STATE(907), 1,
      sym_block_comment,
  [37381] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1861), 1,
      sym__virtual_open_section,
    STATE(908), 1,
      sym_block_comment,
  [37394] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1863), 1,
      sym__virtual_end_decl,
    STATE(909), 1,
      sym_block_comment,
  [37407] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1865), 1,
      sym__virtual_end_decl,
    STATE(910), 1,
      sym_block_comment,
  [37420] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1867), 1,
      anon_sym_in,
    STATE(911), 1,
      sym_block_comment,
  [37433] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1869), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(912), 1,
      sym_block_comment,
  [37446] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1871), 1,
      sym__virtual_end_decl,
    STATE(913), 1,
      sym_block_comment,
  [37459] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1719), 1,
      sym__virtual_end_decl,
    STATE(914), 1,
      sym_block_comment,
  [37472] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1873), 1,
      anon_sym_RPAREN,
    STATE(915), 1,
      sym_block_comment,
  [37485] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1875), 1,
      sym__virtual_open_section,
    STATE(916), 1,
      sym_block_comment,
  [37498] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1877), 1,
      anon_sym_in,
    STATE(917), 1,
      sym_block_comment,
  [37511] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1879), 1,
      anon_sym_in,
    STATE(918), 1,
      sym_block_comment,
  [37524] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1881), 1,
      sym__virtual_open_section,
    STATE(919), 1,
      sym_block_comment,
  [37537] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1883), 1,
      anon_sym_RPAREN,
    STATE(920), 1,
      sym_block_comment,
  [37550] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1885), 1,
      anon_sym_RPAREN,
    STATE(921), 1,
      sym_block_comment,
  [37563] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1887), 1,
      sym__virtual_end_section,
    STATE(922), 1,
      sym_block_comment,
  [37576] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1889), 1,
      anon_sym_RBRACE,
    STATE(923), 1,
      sym_block_comment,
  [37589] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1891), 1,
      sym_eq,
    STATE(924), 1,
      sym_block_comment,
  [37602] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1893), 1,
      sym_number_literal,
    STATE(925), 1,
      sym_block_comment,
  [37615] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1895), 1,
      sym_eq,
    STATE(926), 1,
      sym_block_comment,
  [37628] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1897), 1,
      anon_sym_SQUOTE,
    STATE(927), 1,
      sym_block_comment,
  [37641] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1899), 1,
      sym__virtual_end_section,
    STATE(928), 1,
      sym_block_comment,
  [37654] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1901), 1,
      sym__virtual_end_decl,
    STATE(929), 1,
      sym_block_comment,
  [37667] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1903), 1,
      anon_sym_in,
    STATE(930), 1,
      sym_block_comment,
  [37680] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1905), 1,
      sym_lower_case_identifier,
    STATE(931), 1,
      sym_block_comment,
  [37693] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1907), 1,
      sym_double_dot,
    STATE(932), 1,
      sym_block_comment,
  [37706] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1909), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(933), 1,
      sym_block_comment,
  [37719] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1911), 1,
      sym__virtual_end_decl,
    STATE(934), 1,
      sym_block_comment,
  [37732] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1735), 1,
      sym__virtual_end_decl,
    STATE(935), 1,
      sym_block_comment,
  [37745] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1913), 1,
      anon_sym_in,
    STATE(936), 1,
      sym_block_comment,
  [37758] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1915), 1,
      sym__block_comment_content,
    STATE(937), 1,
      sym_block_comment,
  [37771] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1917), 1,
      anon_sym_SQUOTE,
    STATE(938), 1,
      sym_block_comment,
  [37784] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1919), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(939), 1,
      sym_block_comment,
  [37797] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1921), 1,
      sym_is,
    STATE(940), 1,
      sym_block_comment,
  [37810] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1923), 1,
      sym__virtual_end_decl,
    STATE(941), 1,
      sym_block_comment,
  [37823] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1925), 1,
      sym__virtual_end_decl,
    STATE(942), 1,
      sym_block_comment,
  [37836] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1927), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(943), 1,
      sym_block_comment,
  [37849] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1929), 1,
      sym__virtual_end_decl,
    STATE(944), 1,
      sym_block_comment,
  [37862] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1931), 1,
      anon_sym_in,
    STATE(945), 1,
      sym_block_comment,
  [37875] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1933), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(946), 1,
      sym_block_comment,
  [37888] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1935), 1,
      anon_sym_in,
    STATE(947), 1,
      sym_block_comment,
  [37901] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1937), 1,
      sym__virtual_end_decl,
    STATE(948), 1,
      sym_block_comment,
  [37914] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1939), 1,
      sym_eq,
    STATE(949), 1,
      sym_block_comment,
  [37927] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1941), 1,
      ts_builtin_sym_end,
    STATE(950), 1,
      sym_block_comment,
  [37940] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1943), 1,
      sym__virtual_open_section,
    STATE(951), 1,
      sym_block_comment,
  [37953] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1945), 1,
      sym__virtual_open_section,
    STATE(952), 1,
      sym_block_comment,
  [37966] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1947), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(953), 1,
      sym_block_comment,
  [37979] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1949), 1,
      sym__virtual_end_decl,
    STATE(954), 1,
      sym_block_comment,
  [37992] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1951), 1,
      sym__virtual_open_section,
    STATE(955), 1,
      sym_block_comment,
  [38005] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1953), 1,
      sym__virtual_open_section,
    STATE(956), 1,
      sym_block_comment,
  [38018] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1955), 1,
      anon_sym_RPAREN,
    STATE(957), 1,
      sym_block_comment,
  [38031] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1957), 1,
      sym__virtual_open_section,
    STATE(958), 1,
      sym_block_comment,
  [38044] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1959), 1,
      sym__virtual_open_section,
    STATE(959), 1,
      sym_block_comment,
  [38057] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1053), 1,
      anon_sym_RPAREN,
    STATE(960), 1,
      sym_block_comment,
  [38070] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1961), 1,
      sym__virtual_open_section,
    STATE(961), 1,
      sym_block_comment,
  [38083] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1963), 1,
      sym__virtual_open_section,
    STATE(962), 1,
      sym_block_comment,
  [38096] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1965), 1,
      sym__virtual_open_section,
    STATE(963), 1,
      sym_block_comment,
  [38109] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1967), 1,
      sym__virtual_open_section,
    STATE(964), 1,
      sym_block_comment,
  [38122] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1969), 1,
      sym__virtual_open_section,
    STATE(965), 1,
      sym_block_comment,
  [38135] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1971), 1,
      anon_sym_RPAREN,
    STATE(966), 1,
      sym_block_comment,
  [38148] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1973), 1,
      sym_is,
    STATE(967), 1,
      sym_block_comment,
  [38161] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1975), 1,
      sym_is,
    STATE(968), 1,
      sym_block_comment,
  [38174] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1977), 1,
      anon_sym_then,
    STATE(969), 1,
      sym_block_comment,
  [38187] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1979), 1,
      sym_is,
    STATE(970), 1,
      sym_block_comment,
  [38200] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1981), 1,
      sym_is,
    STATE(971), 1,
      sym_block_comment,
  [38213] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1983), 1,
      sym__virtual_open_section,
    STATE(972), 1,
      sym_block_comment,
  [38226] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1985), 1,
      sym_is,
    STATE(973), 1,
      sym_block_comment,
  [38239] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1987), 1,
      sym_is,
    STATE(974), 1,
      sym_block_comment,
  [38252] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1989), 1,
      sym__virtual_open_section,
    STATE(975), 1,
      sym_block_comment,
  [38265] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1991), 1,
      sym_is,
    STATE(976), 1,
      sym_block_comment,
  [38278] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1993), 1,
      sym_is,
    STATE(977), 1,
      sym_block_comment,
  [38291] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1995), 1,
      sym_is,
    STATE(978), 1,
      sym_block_comment,
  [38304] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1997), 1,
      sym_is,
    STATE(979), 1,
      sym_block_comment,
  [38317] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1999), 1,
      sym__virtual_open_section,
    STATE(980), 1,
      sym_block_comment,
  [38330] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2001), 1,
      anon_sym_RPAREN,
    STATE(981), 1,
      sym_block_comment,
  [38343] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2003), 1,
      anon_sym_RPAREN,
    STATE(982), 1,
      sym_block_comment,
  [38356] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2005), 1,
      anon_sym_RPAREN,
    STATE(983), 1,
      sym_block_comment,
  [38369] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2007), 1,
      anon_sym_else,
    STATE(984), 1,
      sym_block_comment,
  [38382] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2009), 1,
      anon_sym_RBRACE,
    STATE(985), 1,
      sym_block_comment,
  [38395] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2011), 1,
      anon_sym_in,
    STATE(986), 1,
      sym_block_comment,
  [38408] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2013), 1,
      anon_sym_RBRACE,
    STATE(987), 1,
      sym_block_comment,
  [38421] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2015), 1,
      sym_where,
    STATE(988), 1,
      sym_block_comment,
  [38434] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2017), 1,
      sym_module,
    STATE(989), 1,
      sym_block_comment,
  [38447] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2019), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    STATE(990), 1,
      sym_block_comment,
  [38460] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(2021), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(991), 1,
      sym_block_comment,
  [38473] = 1,
    ACTIONS(2023), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(20)] = 0,
  [SMALL_STATE(21)] = 70,
  [SMALL_STATE(22)] = 140,
  [SMALL_STATE(23)] = 209,
  [SMALL_STATE(24)] = 278,
  [SMALL_STATE(25)] = 345,
  [SMALL_STATE(26)] = 416,
  [SMALL_STATE(27)] = 485,
  [SMALL_STATE(28)] = 556,
  [SMALL_STATE(29)] = 622,
  [SMALL_STATE(30)] = 685,
  [SMALL_STATE(31)] = 746,
  [SMALL_STATE(32)] = 807,
  [SMALL_STATE(33)] = 868,
  [SMALL_STATE(34)] = 929,
  [SMALL_STATE(35)] = 994,
  [SMALL_STATE(36)] = 1055,
  [SMALL_STATE(37)] = 1116,
  [SMALL_STATE(38)] = 1177,
  [SMALL_STATE(39)] = 1242,
  [SMALL_STATE(40)] = 1303,
  [SMALL_STATE(41)] = 1364,
  [SMALL_STATE(42)] = 1425,
  [SMALL_STATE(43)] = 1487,
  [SMALL_STATE(44)] = 1547,
  [SMALL_STATE(45)] = 1607,
  [SMALL_STATE(46)] = 1667,
  [SMALL_STATE(47)] = 1727,
  [SMALL_STATE(48)] = 1787,
  [SMALL_STATE(49)] = 1847,
  [SMALL_STATE(50)] = 1907,
  [SMALL_STATE(51)] = 1967,
  [SMALL_STATE(52)] = 2027,
  [SMALL_STATE(53)] = 2087,
  [SMALL_STATE(54)] = 2147,
  [SMALL_STATE(55)] = 2207,
  [SMALL_STATE(56)] = 2267,
  [SMALL_STATE(57)] = 2327,
  [SMALL_STATE(58)] = 2387,
  [SMALL_STATE(59)] = 2449,
  [SMALL_STATE(60)] = 2509,
  [SMALL_STATE(61)] = 2569,
  [SMALL_STATE(62)] = 2629,
  [SMALL_STATE(63)] = 2689,
  [SMALL_STATE(64)] = 2749,
  [SMALL_STATE(65)] = 2809,
  [SMALL_STATE(66)] = 2875,
  [SMALL_STATE(67)] = 2935,
  [SMALL_STATE(68)] = 2995,
  [SMALL_STATE(69)] = 3061,
  [SMALL_STATE(70)] = 3121,
  [SMALL_STATE(71)] = 3181,
  [SMALL_STATE(72)] = 3241,
  [SMALL_STATE(73)] = 3301,
  [SMALL_STATE(74)] = 3361,
  [SMALL_STATE(75)] = 3421,
  [SMALL_STATE(76)] = 3481,
  [SMALL_STATE(77)] = 3546,
  [SMALL_STATE(78)] = 3609,
  [SMALL_STATE(79)] = 3674,
  [SMALL_STATE(80)] = 3741,
  [SMALL_STATE(81)] = 3808,
  [SMALL_STATE(82)] = 3873,
  [SMALL_STATE(83)] = 3937,
  [SMALL_STATE(84)] = 4051,
  [SMALL_STATE(85)] = 4165,
  [SMALL_STATE(86)] = 4279,
  [SMALL_STATE(87)] = 4393,
  [SMALL_STATE(88)] = 4507,
  [SMALL_STATE(89)] = 4621,
  [SMALL_STATE(90)] = 4683,
  [SMALL_STATE(91)] = 4747,
  [SMALL_STATE(92)] = 4858,
  [SMALL_STATE(93)] = 4969,
  [SMALL_STATE(94)] = 5032,
  [SMALL_STATE(95)] = 5143,
  [SMALL_STATE(96)] = 5254,
  [SMALL_STATE(97)] = 5365,
  [SMALL_STATE(98)] = 5422,
  [SMALL_STATE(99)] = 5479,
  [SMALL_STATE(100)] = 5590,
  [SMALL_STATE(101)] = 5701,
  [SMALL_STATE(102)] = 5812,
  [SMALL_STATE(103)] = 5869,
  [SMALL_STATE(104)] = 5926,
  [SMALL_STATE(105)] = 5983,
  [SMALL_STATE(106)] = 6094,
  [SMALL_STATE(107)] = 6151,
  [SMALL_STATE(108)] = 6208,
  [SMALL_STATE(109)] = 6319,
  [SMALL_STATE(110)] = 6382,
  [SMALL_STATE(111)] = 6441,
  [SMALL_STATE(112)] = 6498,
  [SMALL_STATE(113)] = 6609,
  [SMALL_STATE(114)] = 6720,
  [SMALL_STATE(115)] = 6777,
  [SMALL_STATE(116)] = 6838,
  [SMALL_STATE(117)] = 6949,
  [SMALL_STATE(118)] = 7006,
  [SMALL_STATE(119)] = 7071,
  [SMALL_STATE(120)] = 7182,
  [SMALL_STATE(121)] = 7293,
  [SMALL_STATE(122)] = 7404,
  [SMALL_STATE(123)] = 7515,
  [SMALL_STATE(124)] = 7626,
  [SMALL_STATE(125)] = 7737,
  [SMALL_STATE(126)] = 7848,
  [SMALL_STATE(127)] = 7959,
  [SMALL_STATE(128)] = 8070,
  [SMALL_STATE(129)] = 8181,
  [SMALL_STATE(130)] = 8244,
  [SMALL_STATE(131)] = 8355,
  [SMALL_STATE(132)] = 8466,
  [SMALL_STATE(133)] = 8577,
  [SMALL_STATE(134)] = 8688,
  [SMALL_STATE(135)] = 8799,
  [SMALL_STATE(136)] = 8910,
  [SMALL_STATE(137)] = 9021,
  [SMALL_STATE(138)] = 9132,
  [SMALL_STATE(139)] = 9243,
  [SMALL_STATE(140)] = 9354,
  [SMALL_STATE(141)] = 9419,
  [SMALL_STATE(142)] = 9530,
  [SMALL_STATE(143)] = 9641,
  [SMALL_STATE(144)] = 9752,
  [SMALL_STATE(145)] = 9815,
  [SMALL_STATE(146)] = 9878,
  [SMALL_STATE(147)] = 9989,
  [SMALL_STATE(148)] = 10100,
  [SMALL_STATE(149)] = 10211,
  [SMALL_STATE(150)] = 10322,
  [SMALL_STATE(151)] = 10433,
  [SMALL_STATE(152)] = 10544,
  [SMALL_STATE(153)] = 10655,
  [SMALL_STATE(154)] = 10766,
  [SMALL_STATE(155)] = 10877,
  [SMALL_STATE(156)] = 10933,
  [SMALL_STATE(157)] = 10989,
  [SMALL_STATE(158)] = 11045,
  [SMALL_STATE(159)] = 11101,
  [SMALL_STATE(160)] = 11157,
  [SMALL_STATE(161)] = 11213,
  [SMALL_STATE(162)] = 11269,
  [SMALL_STATE(163)] = 11325,
  [SMALL_STATE(164)] = 11381,
  [SMALL_STATE(165)] = 11437,
  [SMALL_STATE(166)] = 11493,
  [SMALL_STATE(167)] = 11549,
  [SMALL_STATE(168)] = 11605,
  [SMALL_STATE(169)] = 11661,
  [SMALL_STATE(170)] = 11721,
  [SMALL_STATE(171)] = 11777,
  [SMALL_STATE(172)] = 11833,
  [SMALL_STATE(173)] = 11889,
  [SMALL_STATE(174)] = 11949,
  [SMALL_STATE(175)] = 12005,
  [SMALL_STATE(176)] = 12061,
  [SMALL_STATE(177)] = 12117,
  [SMALL_STATE(178)] = 12177,
  [SMALL_STATE(179)] = 12233,
  [SMALL_STATE(180)] = 12289,
  [SMALL_STATE(181)] = 12345,
  [SMALL_STATE(182)] = 12401,
  [SMALL_STATE(183)] = 12457,
  [SMALL_STATE(184)] = 12513,
  [SMALL_STATE(185)] = 12569,
  [SMALL_STATE(186)] = 12625,
  [SMALL_STATE(187)] = 12681,
  [SMALL_STATE(188)] = 12737,
  [SMALL_STATE(189)] = 12792,
  [SMALL_STATE(190)] = 12897,
  [SMALL_STATE(191)] = 12952,
  [SMALL_STATE(192)] = 13057,
  [SMALL_STATE(193)] = 13112,
  [SMALL_STATE(194)] = 13173,
  [SMALL_STATE(195)] = 13280,
  [SMALL_STATE(196)] = 13335,
  [SMALL_STATE(197)] = 13392,
  [SMALL_STATE(198)] = 13447,
  [SMALL_STATE(199)] = 13502,
  [SMALL_STATE(200)] = 13557,
  [SMALL_STATE(201)] = 13612,
  [SMALL_STATE(202)] = 13717,
  [SMALL_STATE(203)] = 13824,
  [SMALL_STATE(204)] = 13885,
  [SMALL_STATE(205)] = 13990,
  [SMALL_STATE(206)] = 14095,
  [SMALL_STATE(207)] = 14200,
  [SMALL_STATE(208)] = 14307,
  [SMALL_STATE(209)] = 14362,
  [SMALL_STATE(210)] = 14417,
  [SMALL_STATE(211)] = 14471,
  [SMALL_STATE(212)] = 14525,
  [SMALL_STATE(213)] = 14579,
  [SMALL_STATE(214)] = 14633,
  [SMALL_STATE(215)] = 14687,
  [SMALL_STATE(216)] = 14741,
  [SMALL_STATE(217)] = 14795,
  [SMALL_STATE(218)] = 14849,
  [SMALL_STATE(219)] = 14903,
  [SMALL_STATE(220)] = 14957,
  [SMALL_STATE(221)] = 15015,
  [SMALL_STATE(222)] = 15069,
  [SMALL_STATE(223)] = 15123,
  [SMALL_STATE(224)] = 15177,
  [SMALL_STATE(225)] = 15231,
  [SMALL_STATE(226)] = 15285,
  [SMALL_STATE(227)] = 15339,
  [SMALL_STATE(228)] = 15393,
  [SMALL_STATE(229)] = 15447,
  [SMALL_STATE(230)] = 15501,
  [SMALL_STATE(231)] = 15555,
  [SMALL_STATE(232)] = 15609,
  [SMALL_STATE(233)] = 15663,
  [SMALL_STATE(234)] = 15717,
  [SMALL_STATE(235)] = 15775,
  [SMALL_STATE(236)] = 15829,
  [SMALL_STATE(237)] = 15883,
  [SMALL_STATE(238)] = 15937,
  [SMALL_STATE(239)] = 15991,
  [SMALL_STATE(240)] = 16045,
  [SMALL_STATE(241)] = 16099,
  [SMALL_STATE(242)] = 16153,
  [SMALL_STATE(243)] = 16250,
  [SMALL_STATE(244)] = 16347,
  [SMALL_STATE(245)] = 16444,
  [SMALL_STATE(246)] = 16541,
  [SMALL_STATE(247)] = 16638,
  [SMALL_STATE(248)] = 16735,
  [SMALL_STATE(249)] = 16829,
  [SMALL_STATE(250)] = 16923,
  [SMALL_STATE(251)] = 17017,
  [SMALL_STATE(252)] = 17115,
  [SMALL_STATE(253)] = 17213,
  [SMALL_STATE(254)] = 17311,
  [SMALL_STATE(255)] = 17407,
  [SMALL_STATE(256)] = 17501,
  [SMALL_STATE(257)] = 17595,
  [SMALL_STATE(258)] = 17693,
  [SMALL_STATE(259)] = 17787,
  [SMALL_STATE(260)] = 17842,
  [SMALL_STATE(261)] = 17895,
  [SMALL_STATE(262)] = 17950,
  [SMALL_STATE(263)] = 18005,
  [SMALL_STATE(264)] = 18060,
  [SMALL_STATE(265)] = 18113,
  [SMALL_STATE(266)] = 18167,
  [SMALL_STATE(267)] = 18219,
  [SMALL_STATE(268)] = 18273,
  [SMALL_STATE(269)] = 18327,
  [SMALL_STATE(270)] = 18383,
  [SMALL_STATE(271)] = 18439,
  [SMALL_STATE(272)] = 18486,
  [SMALL_STATE(273)] = 18533,
  [SMALL_STATE(274)] = 18580,
  [SMALL_STATE(275)] = 18631,
  [SMALL_STATE(276)] = 18678,
  [SMALL_STATE(277)] = 18724,
  [SMALL_STATE(278)] = 18770,
  [SMALL_STATE(279)] = 18816,
  [SMALL_STATE(280)] = 18862,
  [SMALL_STATE(281)] = 18908,
  [SMALL_STATE(282)] = 18954,
  [SMALL_STATE(283)] = 19000,
  [SMALL_STATE(284)] = 19046,
  [SMALL_STATE(285)] = 19094,
  [SMALL_STATE(286)] = 19140,
  [SMALL_STATE(287)] = 19185,
  [SMALL_STATE(288)] = 19230,
  [SMALL_STATE(289)] = 19275,
  [SMALL_STATE(290)] = 19320,
  [SMALL_STATE(291)] = 19365,
  [SMALL_STATE(292)] = 19410,
  [SMALL_STATE(293)] = 19455,
  [SMALL_STATE(294)] = 19500,
  [SMALL_STATE(295)] = 19545,
  [SMALL_STATE(296)] = 19590,
  [SMALL_STATE(297)] = 19665,
  [SMALL_STATE(298)] = 19710,
  [SMALL_STATE(299)] = 19761,
  [SMALL_STATE(300)] = 19834,
  [SMALL_STATE(301)] = 19879,
  [SMALL_STATE(302)] = 19924,
  [SMALL_STATE(303)] = 19975,
  [SMALL_STATE(304)] = 20020,
  [SMALL_STATE(305)] = 20065,
  [SMALL_STATE(306)] = 20110,
  [SMALL_STATE(307)] = 20155,
  [SMALL_STATE(308)] = 20200,
  [SMALL_STATE(309)] = 20245,
  [SMALL_STATE(310)] = 20290,
  [SMALL_STATE(311)] = 20335,
  [SMALL_STATE(312)] = 20380,
  [SMALL_STATE(313)] = 20425,
  [SMALL_STATE(314)] = 20470,
  [SMALL_STATE(315)] = 20545,
  [SMALL_STATE(316)] = 20590,
  [SMALL_STATE(317)] = 20635,
  [SMALL_STATE(318)] = 20680,
  [SMALL_STATE(319)] = 20725,
  [SMALL_STATE(320)] = 20809,
  [SMALL_STATE(321)] = 20859,
  [SMALL_STATE(322)] = 20943,
  [SMALL_STATE(323)] = 20995,
  [SMALL_STATE(324)] = 21045,
  [SMALL_STATE(325)] = 21129,
  [SMALL_STATE(326)] = 21213,
  [SMALL_STATE(327)] = 21297,
  [SMALL_STATE(328)] = 21381,
  [SMALL_STATE(329)] = 21465,
  [SMALL_STATE(330)] = 21517,
  [SMALL_STATE(331)] = 21566,
  [SMALL_STATE(332)] = 21615,
  [SMALL_STATE(333)] = 21662,
  [SMALL_STATE(334)] = 21704,
  [SMALL_STATE(335)] = 21746,
  [SMALL_STATE(336)] = 21796,
  [SMALL_STATE(337)] = 21838,
  [SMALL_STATE(338)] = 21916,
  [SMALL_STATE(339)] = 21994,
  [SMALL_STATE(340)] = 22070,
  [SMALL_STATE(341)] = 22118,
  [SMALL_STATE(342)] = 22166,
  [SMALL_STATE(343)] = 22244,
  [SMALL_STATE(344)] = 22322,
  [SMALL_STATE(345)] = 22400,
  [SMALL_STATE(346)] = 22442,
  [SMALL_STATE(347)] = 22492,
  [SMALL_STATE(348)] = 22536,
  [SMALL_STATE(349)] = 22578,
  [SMALL_STATE(350)] = 22620,
  [SMALL_STATE(351)] = 22662,
  [SMALL_STATE(352)] = 22740,
  [SMALL_STATE(353)] = 22782,
  [SMALL_STATE(354)] = 22824,
  [SMALL_STATE(355)] = 22865,
  [SMALL_STATE(356)] = 22940,
  [SMALL_STATE(357)] = 22981,
  [SMALL_STATE(358)] = 23022,
  [SMALL_STATE(359)] = 23063,
  [SMALL_STATE(360)] = 23104,
  [SMALL_STATE(361)] = 23145,
  [SMALL_STATE(362)] = 23186,
  [SMALL_STATE(363)] = 23261,
  [SMALL_STATE(364)] = 23302,
  [SMALL_STATE(365)] = 23343,
  [SMALL_STATE(366)] = 23384,
  [SMALL_STATE(367)] = 23425,
  [SMALL_STATE(368)] = 23466,
  [SMALL_STATE(369)] = 23507,
  [SMALL_STATE(370)] = 23548,
  [SMALL_STATE(371)] = 23589,
  [SMALL_STATE(372)] = 23630,
  [SMALL_STATE(373)] = 23671,
  [SMALL_STATE(374)] = 23712,
  [SMALL_STATE(375)] = 23753,
  [SMALL_STATE(376)] = 23828,
  [SMALL_STATE(377)] = 23869,
  [SMALL_STATE(378)] = 23910,
  [SMALL_STATE(379)] = 23951,
  [SMALL_STATE(380)] = 23992,
  [SMALL_STATE(381)] = 24033,
  [SMALL_STATE(382)] = 24074,
  [SMALL_STATE(383)] = 24149,
  [SMALL_STATE(384)] = 24224,
  [SMALL_STATE(385)] = 24265,
  [SMALL_STATE(386)] = 24306,
  [SMALL_STATE(387)] = 24347,
  [SMALL_STATE(388)] = 24422,
  [SMALL_STATE(389)] = 24473,
  [SMALL_STATE(390)] = 24524,
  [SMALL_STATE(391)] = 24599,
  [SMALL_STATE(392)] = 24674,
  [SMALL_STATE(393)] = 24749,
  [SMALL_STATE(394)] = 24824,
  [SMALL_STATE(395)] = 24899,
  [SMALL_STATE(396)] = 24974,
  [SMALL_STATE(397)] = 25049,
  [SMALL_STATE(398)] = 25124,
  [SMALL_STATE(399)] = 25199,
  [SMALL_STATE(400)] = 25274,
  [SMALL_STATE(401)] = 25349,
  [SMALL_STATE(402)] = 25424,
  [SMALL_STATE(403)] = 25499,
  [SMALL_STATE(404)] = 25574,
  [SMALL_STATE(405)] = 25649,
  [SMALL_STATE(406)] = 25724,
  [SMALL_STATE(407)] = 25769,
  [SMALL_STATE(408)] = 25810,
  [SMALL_STATE(409)] = 25850,
  [SMALL_STATE(410)] = 25892,
  [SMALL_STATE(411)] = 25932,
  [SMALL_STATE(412)] = 26004,
  [SMALL_STATE(413)] = 26044,
  [SMALL_STATE(414)] = 26084,
  [SMALL_STATE(415)] = 26124,
  [SMALL_STATE(416)] = 26164,
  [SMALL_STATE(417)] = 26204,
  [SMALL_STATE(418)] = 26244,
  [SMALL_STATE(419)] = 26284,
  [SMALL_STATE(420)] = 26323,
  [SMALL_STATE(421)] = 26362,
  [SMALL_STATE(422)] = 26401,
  [SMALL_STATE(423)] = 26440,
  [SMALL_STATE(424)] = 26479,
  [SMALL_STATE(425)] = 26518,
  [SMALL_STATE(426)] = 26557,
  [SMALL_STATE(427)] = 26596,
  [SMALL_STATE(428)] = 26635,
  [SMALL_STATE(429)] = 26676,
  [SMALL_STATE(430)] = 26717,
  [SMALL_STATE(431)] = 26758,
  [SMALL_STATE(432)] = 26797,
  [SMALL_STATE(433)] = 26836,
  [SMALL_STATE(434)] = 26875,
  [SMALL_STATE(435)] = 26916,
  [SMALL_STATE(436)] = 26957,
  [SMALL_STATE(437)] = 26998,
  [SMALL_STATE(438)] = 27039,
  [SMALL_STATE(439)] = 27078,
  [SMALL_STATE(440)] = 27119,
  [SMALL_STATE(441)] = 27160,
  [SMALL_STATE(442)] = 27201,
  [SMALL_STATE(443)] = 27242,
  [SMALL_STATE(444)] = 27283,
  [SMALL_STATE(445)] = 27322,
  [SMALL_STATE(446)] = 27361,
  [SMALL_STATE(447)] = 27400,
  [SMALL_STATE(448)] = 27439,
  [SMALL_STATE(449)] = 27478,
  [SMALL_STATE(450)] = 27517,
  [SMALL_STATE(451)] = 27556,
  [SMALL_STATE(452)] = 27595,
  [SMALL_STATE(453)] = 27634,
  [SMALL_STATE(454)] = 27675,
  [SMALL_STATE(455)] = 27714,
  [SMALL_STATE(456)] = 27753,
  [SMALL_STATE(457)] = 27792,
  [SMALL_STATE(458)] = 27831,
  [SMALL_STATE(459)] = 27870,
  [SMALL_STATE(460)] = 27909,
  [SMALL_STATE(461)] = 27948,
  [SMALL_STATE(462)] = 28012,
  [SMALL_STATE(463)] = 28076,
  [SMALL_STATE(464)] = 28142,
  [SMALL_STATE(465)] = 28208,
  [SMALL_STATE(466)] = 28251,
  [SMALL_STATE(467)] = 28292,
  [SMALL_STATE(468)] = 28335,
  [SMALL_STATE(469)] = 28392,
  [SMALL_STATE(470)] = 28427,
  [SMALL_STATE(471)] = 28482,
  [SMALL_STATE(472)] = 28514,
  [SMALL_STATE(473)] = 28545,
  [SMALL_STATE(474)] = 28576,
  [SMALL_STATE(475)] = 28607,
  [SMALL_STATE(476)] = 28638,
  [SMALL_STATE(477)] = 28669,
  [SMALL_STATE(478)] = 28700,
  [SMALL_STATE(479)] = 28735,
  [SMALL_STATE(480)] = 28766,
  [SMALL_STATE(481)] = 28799,
  [SMALL_STATE(482)] = 28832,
  [SMALL_STATE(483)] = 28863,
  [SMALL_STATE(484)] = 28894,
  [SMALL_STATE(485)] = 28925,
  [SMALL_STATE(486)] = 28956,
  [SMALL_STATE(487)] = 28987,
  [SMALL_STATE(488)] = 29018,
  [SMALL_STATE(489)] = 29049,
  [SMALL_STATE(490)] = 29080,
  [SMALL_STATE(491)] = 29111,
  [SMALL_STATE(492)] = 29142,
  [SMALL_STATE(493)] = 29172,
  [SMALL_STATE(494)] = 29204,
  [SMALL_STATE(495)] = 29236,
  [SMALL_STATE(496)] = 29265,
  [SMALL_STATE(497)] = 29294,
  [SMALL_STATE(498)] = 29323,
  [SMALL_STATE(499)] = 29352,
  [SMALL_STATE(500)] = 29381,
  [SMALL_STATE(501)] = 29423,
  [SMALL_STATE(502)] = 29465,
  [SMALL_STATE(503)] = 29493,
  [SMALL_STATE(504)] = 29533,
  [SMALL_STATE(505)] = 29572,
  [SMALL_STATE(506)] = 29613,
  [SMALL_STATE(507)] = 29654,
  [SMALL_STATE(508)] = 29683,
  [SMALL_STATE(509)] = 29725,
  [SMALL_STATE(510)] = 29767,
  [SMALL_STATE(511)] = 29809,
  [SMALL_STATE(512)] = 29847,
  [SMALL_STATE(513)] = 29889,
  [SMALL_STATE(514)] = 29931,
  [SMALL_STATE(515)] = 29971,
  [SMALL_STATE(516)] = 30013,
  [SMALL_STATE(517)] = 30053,
  [SMALL_STATE(518)] = 30095,
  [SMALL_STATE(519)] = 30137,
  [SMALL_STATE(520)] = 30177,
  [SMALL_STATE(521)] = 30219,
  [SMALL_STATE(522)] = 30257,
  [SMALL_STATE(523)] = 30297,
  [SMALL_STATE(524)] = 30339,
  [SMALL_STATE(525)] = 30378,
  [SMALL_STATE(526)] = 30417,
  [SMALL_STATE(527)] = 30456,
  [SMALL_STATE(528)] = 30481,
  [SMALL_STATE(529)] = 30512,
  [SMALL_STATE(530)] = 30542,
  [SMALL_STATE(531)] = 30566,
  [SMALL_STATE(532)] = 30593,
  [SMALL_STATE(533)] = 30620,
  [SMALL_STATE(534)] = 30645,
  [SMALL_STATE(535)] = 30667,
  [SMALL_STATE(536)] = 30689,
  [SMALL_STATE(537)] = 30711,
  [SMALL_STATE(538)] = 30733,
  [SMALL_STATE(539)] = 30755,
  [SMALL_STATE(540)] = 30777,
  [SMALL_STATE(541)] = 30799,
  [SMALL_STATE(542)] = 30821,
  [SMALL_STATE(543)] = 30851,
  [SMALL_STATE(544)] = 30873,
  [SMALL_STATE(545)] = 30895,
  [SMALL_STATE(546)] = 30916,
  [SMALL_STATE(547)] = 30937,
  [SMALL_STATE(548)] = 30958,
  [SMALL_STATE(549)] = 30979,
  [SMALL_STATE(550)] = 31006,
  [SMALL_STATE(551)] = 31027,
  [SMALL_STATE(552)] = 31046,
  [SMALL_STATE(553)] = 31067,
  [SMALL_STATE(554)] = 31088,
  [SMALL_STATE(555)] = 31109,
  [SMALL_STATE(556)] = 31130,
  [SMALL_STATE(557)] = 31151,
  [SMALL_STATE(558)] = 31172,
  [SMALL_STATE(559)] = 31192,
  [SMALL_STATE(560)] = 31210,
  [SMALL_STATE(561)] = 31228,
  [SMALL_STATE(562)] = 31248,
  [SMALL_STATE(563)] = 31266,
  [SMALL_STATE(564)] = 31286,
  [SMALL_STATE(565)] = 31306,
  [SMALL_STATE(566)] = 31334,
  [SMALL_STATE(567)] = 31352,
  [SMALL_STATE(568)] = 31370,
  [SMALL_STATE(569)] = 31398,
  [SMALL_STATE(570)] = 31418,
  [SMALL_STATE(571)] = 31436,
  [SMALL_STATE(572)] = 31464,
  [SMALL_STATE(573)] = 31482,
  [SMALL_STATE(574)] = 31502,
  [SMALL_STATE(575)] = 31530,
  [SMALL_STATE(576)] = 31548,
  [SMALL_STATE(577)] = 31566,
  [SMALL_STATE(578)] = 31586,
  [SMALL_STATE(579)] = 31614,
  [SMALL_STATE(580)] = 31642,
  [SMALL_STATE(581)] = 31660,
  [SMALL_STATE(582)] = 31680,
  [SMALL_STATE(583)] = 31700,
  [SMALL_STATE(584)] = 31720,
  [SMALL_STATE(585)] = 31738,
  [SMALL_STATE(586)] = 31761,
  [SMALL_STATE(587)] = 31784,
  [SMALL_STATE(588)] = 31803,
  [SMALL_STATE(589)] = 31826,
  [SMALL_STATE(590)] = 31851,
  [SMALL_STATE(591)] = 31874,
  [SMALL_STATE(592)] = 31897,
  [SMALL_STATE(593)] = 31920,
  [SMALL_STATE(594)] = 31943,
  [SMALL_STATE(595)] = 31968,
  [SMALL_STATE(596)] = 31993,
  [SMALL_STATE(597)] = 32016,
  [SMALL_STATE(598)] = 32039,
  [SMALL_STATE(599)] = 32062,
  [SMALL_STATE(600)] = 32085,
  [SMALL_STATE(601)] = 32110,
  [SMALL_STATE(602)] = 32135,
  [SMALL_STATE(603)] = 32158,
  [SMALL_STATE(604)] = 32181,
  [SMALL_STATE(605)] = 32204,
  [SMALL_STATE(606)] = 32227,
  [SMALL_STATE(607)] = 32252,
  [SMALL_STATE(608)] = 32273,
  [SMALL_STATE(609)] = 32298,
  [SMALL_STATE(610)] = 32321,
  [SMALL_STATE(611)] = 32344,
  [SMALL_STATE(612)] = 32367,
  [SMALL_STATE(613)] = 32390,
  [SMALL_STATE(614)] = 32415,
  [SMALL_STATE(615)] = 32438,
  [SMALL_STATE(616)] = 32461,
  [SMALL_STATE(617)] = 32484,
  [SMALL_STATE(618)] = 32507,
  [SMALL_STATE(619)] = 32532,
  [SMALL_STATE(620)] = 32555,
  [SMALL_STATE(621)] = 32578,
  [SMALL_STATE(622)] = 32601,
  [SMALL_STATE(623)] = 32624,
  [SMALL_STATE(624)] = 32647,
  [SMALL_STATE(625)] = 32668,
  [SMALL_STATE(626)] = 32689,
  [SMALL_STATE(627)] = 32712,
  [SMALL_STATE(628)] = 32733,
  [SMALL_STATE(629)] = 32758,
  [SMALL_STATE(630)] = 32783,
  [SMALL_STATE(631)] = 32805,
  [SMALL_STATE(632)] = 32825,
  [SMALL_STATE(633)] = 32847,
  [SMALL_STATE(634)] = 32869,
  [SMALL_STATE(635)] = 32889,
  [SMALL_STATE(636)] = 32911,
  [SMALL_STATE(637)] = 32929,
  [SMALL_STATE(638)] = 32951,
  [SMALL_STATE(639)] = 32971,
  [SMALL_STATE(640)] = 32989,
  [SMALL_STATE(641)] = 33009,
  [SMALL_STATE(642)] = 33031,
  [SMALL_STATE(643)] = 33053,
  [SMALL_STATE(644)] = 33075,
  [SMALL_STATE(645)] = 33097,
  [SMALL_STATE(646)] = 33119,
  [SMALL_STATE(647)] = 33139,
  [SMALL_STATE(648)] = 33161,
  [SMALL_STATE(649)] = 33183,
  [SMALL_STATE(650)] = 33205,
  [SMALL_STATE(651)] = 33223,
  [SMALL_STATE(652)] = 33245,
  [SMALL_STATE(653)] = 33261,
  [SMALL_STATE(654)] = 33283,
  [SMALL_STATE(655)] = 33301,
  [SMALL_STATE(656)] = 33323,
  [SMALL_STATE(657)] = 33345,
  [SMALL_STATE(658)] = 33367,
  [SMALL_STATE(659)] = 33383,
  [SMALL_STATE(660)] = 33399,
  [SMALL_STATE(661)] = 33419,
  [SMALL_STATE(662)] = 33441,
  [SMALL_STATE(663)] = 33463,
  [SMALL_STATE(664)] = 33482,
  [SMALL_STATE(665)] = 33501,
  [SMALL_STATE(666)] = 33518,
  [SMALL_STATE(667)] = 33537,
  [SMALL_STATE(668)] = 33552,
  [SMALL_STATE(669)] = 33571,
  [SMALL_STATE(670)] = 33590,
  [SMALL_STATE(671)] = 33609,
  [SMALL_STATE(672)] = 33628,
  [SMALL_STATE(673)] = 33645,
  [SMALL_STATE(674)] = 33664,
  [SMALL_STATE(675)] = 33683,
  [SMALL_STATE(676)] = 33702,
  [SMALL_STATE(677)] = 33719,
  [SMALL_STATE(678)] = 33738,
  [SMALL_STATE(679)] = 33757,
  [SMALL_STATE(680)] = 33776,
  [SMALL_STATE(681)] = 33795,
  [SMALL_STATE(682)] = 33814,
  [SMALL_STATE(683)] = 33833,
  [SMALL_STATE(684)] = 33852,
  [SMALL_STATE(685)] = 33871,
  [SMALL_STATE(686)] = 33890,
  [SMALL_STATE(687)] = 33909,
  [SMALL_STATE(688)] = 33924,
  [SMALL_STATE(689)] = 33941,
  [SMALL_STATE(690)] = 33960,
  [SMALL_STATE(691)] = 33979,
  [SMALL_STATE(692)] = 33998,
  [SMALL_STATE(693)] = 34015,
  [SMALL_STATE(694)] = 34034,
  [SMALL_STATE(695)] = 34053,
  [SMALL_STATE(696)] = 34072,
  [SMALL_STATE(697)] = 34089,
  [SMALL_STATE(698)] = 34108,
  [SMALL_STATE(699)] = 34127,
  [SMALL_STATE(700)] = 34146,
  [SMALL_STATE(701)] = 34165,
  [SMALL_STATE(702)] = 34184,
  [SMALL_STATE(703)] = 34203,
  [SMALL_STATE(704)] = 34222,
  [SMALL_STATE(705)] = 34241,
  [SMALL_STATE(706)] = 34258,
  [SMALL_STATE(707)] = 34277,
  [SMALL_STATE(708)] = 34296,
  [SMALL_STATE(709)] = 34315,
  [SMALL_STATE(710)] = 34334,
  [SMALL_STATE(711)] = 34353,
  [SMALL_STATE(712)] = 34372,
  [SMALL_STATE(713)] = 34391,
  [SMALL_STATE(714)] = 34410,
  [SMALL_STATE(715)] = 34429,
  [SMALL_STATE(716)] = 34448,
  [SMALL_STATE(717)] = 34467,
  [SMALL_STATE(718)] = 34486,
  [SMALL_STATE(719)] = 34505,
  [SMALL_STATE(720)] = 34524,
  [SMALL_STATE(721)] = 34539,
  [SMALL_STATE(722)] = 34556,
  [SMALL_STATE(723)] = 34575,
  [SMALL_STATE(724)] = 34592,
  [SMALL_STATE(725)] = 34607,
  [SMALL_STATE(726)] = 34626,
  [SMALL_STATE(727)] = 34645,
  [SMALL_STATE(728)] = 34664,
  [SMALL_STATE(729)] = 34683,
  [SMALL_STATE(730)] = 34702,
  [SMALL_STATE(731)] = 34721,
  [SMALL_STATE(732)] = 34740,
  [SMALL_STATE(733)] = 34755,
  [SMALL_STATE(734)] = 34774,
  [SMALL_STATE(735)] = 34793,
  [SMALL_STATE(736)] = 34812,
  [SMALL_STATE(737)] = 34831,
  [SMALL_STATE(738)] = 34850,
  [SMALL_STATE(739)] = 34869,
  [SMALL_STATE(740)] = 34888,
  [SMALL_STATE(741)] = 34907,
  [SMALL_STATE(742)] = 34926,
  [SMALL_STATE(743)] = 34945,
  [SMALL_STATE(744)] = 34964,
  [SMALL_STATE(745)] = 34979,
  [SMALL_STATE(746)] = 34994,
  [SMALL_STATE(747)] = 35009,
  [SMALL_STATE(748)] = 35028,
  [SMALL_STATE(749)] = 35047,
  [SMALL_STATE(750)] = 35066,
  [SMALL_STATE(751)] = 35085,
  [SMALL_STATE(752)] = 35104,
  [SMALL_STATE(753)] = 35119,
  [SMALL_STATE(754)] = 35138,
  [SMALL_STATE(755)] = 35157,
  [SMALL_STATE(756)] = 35172,
  [SMALL_STATE(757)] = 35191,
  [SMALL_STATE(758)] = 35210,
  [SMALL_STATE(759)] = 35225,
  [SMALL_STATE(760)] = 35244,
  [SMALL_STATE(761)] = 35263,
  [SMALL_STATE(762)] = 35282,
  [SMALL_STATE(763)] = 35297,
  [SMALL_STATE(764)] = 35312,
  [SMALL_STATE(765)] = 35331,
  [SMALL_STATE(766)] = 35350,
  [SMALL_STATE(767)] = 35369,
  [SMALL_STATE(768)] = 35388,
  [SMALL_STATE(769)] = 35404,
  [SMALL_STATE(770)] = 35418,
  [SMALL_STATE(771)] = 35432,
  [SMALL_STATE(772)] = 35448,
  [SMALL_STATE(773)] = 35464,
  [SMALL_STATE(774)] = 35480,
  [SMALL_STATE(775)] = 35496,
  [SMALL_STATE(776)] = 35510,
  [SMALL_STATE(777)] = 35524,
  [SMALL_STATE(778)] = 35540,
  [SMALL_STATE(779)] = 35556,
  [SMALL_STATE(780)] = 35572,
  [SMALL_STATE(781)] = 35588,
  [SMALL_STATE(782)] = 35604,
  [SMALL_STATE(783)] = 35618,
  [SMALL_STATE(784)] = 35634,
  [SMALL_STATE(785)] = 35650,
  [SMALL_STATE(786)] = 35664,
  [SMALL_STATE(787)] = 35680,
  [SMALL_STATE(788)] = 35694,
  [SMALL_STATE(789)] = 35708,
  [SMALL_STATE(790)] = 35724,
  [SMALL_STATE(791)] = 35738,
  [SMALL_STATE(792)] = 35754,
  [SMALL_STATE(793)] = 35770,
  [SMALL_STATE(794)] = 35786,
  [SMALL_STATE(795)] = 35802,
  [SMALL_STATE(796)] = 35816,
  [SMALL_STATE(797)] = 35830,
  [SMALL_STATE(798)] = 35844,
  [SMALL_STATE(799)] = 35858,
  [SMALL_STATE(800)] = 35872,
  [SMALL_STATE(801)] = 35888,
  [SMALL_STATE(802)] = 35902,
  [SMALL_STATE(803)] = 35918,
  [SMALL_STATE(804)] = 35934,
  [SMALL_STATE(805)] = 35948,
  [SMALL_STATE(806)] = 35962,
  [SMALL_STATE(807)] = 35976,
  [SMALL_STATE(808)] = 35992,
  [SMALL_STATE(809)] = 36008,
  [SMALL_STATE(810)] = 36022,
  [SMALL_STATE(811)] = 36036,
  [SMALL_STATE(812)] = 36052,
  [SMALL_STATE(813)] = 36068,
  [SMALL_STATE(814)] = 36084,
  [SMALL_STATE(815)] = 36100,
  [SMALL_STATE(816)] = 36114,
  [SMALL_STATE(817)] = 36130,
  [SMALL_STATE(818)] = 36146,
  [SMALL_STATE(819)] = 36160,
  [SMALL_STATE(820)] = 36174,
  [SMALL_STATE(821)] = 36190,
  [SMALL_STATE(822)] = 36206,
  [SMALL_STATE(823)] = 36222,
  [SMALL_STATE(824)] = 36236,
  [SMALL_STATE(825)] = 36252,
  [SMALL_STATE(826)] = 36268,
  [SMALL_STATE(827)] = 36284,
  [SMALL_STATE(828)] = 36298,
  [SMALL_STATE(829)] = 36314,
  [SMALL_STATE(830)] = 36330,
  [SMALL_STATE(831)] = 36346,
  [SMALL_STATE(832)] = 36362,
  [SMALL_STATE(833)] = 36376,
  [SMALL_STATE(834)] = 36392,
  [SMALL_STATE(835)] = 36408,
  [SMALL_STATE(836)] = 36422,
  [SMALL_STATE(837)] = 36438,
  [SMALL_STATE(838)] = 36454,
  [SMALL_STATE(839)] = 36470,
  [SMALL_STATE(840)] = 36486,
  [SMALL_STATE(841)] = 36500,
  [SMALL_STATE(842)] = 36514,
  [SMALL_STATE(843)] = 36530,
  [SMALL_STATE(844)] = 36546,
  [SMALL_STATE(845)] = 36562,
  [SMALL_STATE(846)] = 36575,
  [SMALL_STATE(847)] = 36588,
  [SMALL_STATE(848)] = 36601,
  [SMALL_STATE(849)] = 36614,
  [SMALL_STATE(850)] = 36627,
  [SMALL_STATE(851)] = 36640,
  [SMALL_STATE(852)] = 36653,
  [SMALL_STATE(853)] = 36666,
  [SMALL_STATE(854)] = 36679,
  [SMALL_STATE(855)] = 36692,
  [SMALL_STATE(856)] = 36705,
  [SMALL_STATE(857)] = 36718,
  [SMALL_STATE(858)] = 36731,
  [SMALL_STATE(859)] = 36744,
  [SMALL_STATE(860)]