#include "IconMap.h"
#include "WildcardCompare.h"
#include "Png.h"

#include <string.h> // memset()

#include <algorithm>
#include <sstream>
#include <fstream>
#include <sys/stat.h>

#ifdef HAVE_GTK
#include <stdint.h>
#include <gtk/gtk.h>
#endif

#ifdef HAVE_KDE
#include <QImage>
#include <QPixmap>

#include <stdint.h>
#include <kicon.h>
#include <kiconloader.h>
#endif

using namespace PieDock;

const char IconMap::fallbackPng[] = {
	(char) 0x89, (char) 0x50, (char) 0x4e, (char) 0x47, (char) 0xd, (char) 0xa, (char) 0x1a, (char) 0xa, (char) 0x0, (char) 0x0, (char) 0x0, (char) 0xd,
	(char) 0x49, (char) 0x48, (char) 0x44, (char) 0x52, (char) 0x0, (char) 0x0, (char) 0x0, (char) 0x80, (char) 0x0, (char) 0x0, (char) 0x0, (char) 0x80,
	(char) 0x8, (char) 0x6, (char) 0x0, (char) 0x0, (char) 0x0, (char) 0xc3, (char) 0x3e, (char) 0x61, (char) 0xcb, (char) 0x0, (char) 0x0, (char) 0x0,
	(char) 0x6, (char) 0x62, (char) 0x4b, (char) 0x47, (char) 0x44, (char) 0x0, (char) 0x80, (char) 0x0, (char) 0x80, (char) 0x0, (char) 0x80, (char) 0x44,
	(char) 0x28, (char) 0x93, (char) 0x4d, (char) 0x0, (char) 0x0, (char) 0x0, (char) 0x9, (char) 0x70, (char) 0x48, (char) 0x59, (char) 0x73, (char) 0x0,
	(char) 0x0, (char) 0x7d, (char) 0xaa, (char) 0x0, (char) 0x0, (char) 0x7d, (char) 0xaa, (char) 0x1, (char) 0xd7, (char) 0x9c, (char) 0x3a, (char) 0xa7,
	(char) 0x0, (char) 0x0, (char) 0x0, (char) 0x7, (char) 0x74, (char) 0x49, (char) 0x4d, (char) 0x45, (char) 0x7, (char) 0xd7, (char) 0x5, (char) 0x5,
	(char) 0xb, (char) 0x17, (char) 0x18, (char) 0x26, (char) 0x6b, (char) 0xa, (char) 0x54, (char) 0x0, (char) 0x0, (char) 0x1a, (char) 0xe9, (char) 0x49,
	(char) 0x44, (char) 0x41, (char) 0x54, (char) 0x78, (char) 0xda, (char) 0xed, (char) 0x5d, (char) 0xf9, (char) 0x73, (char) 0x13, (char) 0xe7, (char) 0xdd,
	(char) 0xff, (char) 0x3c, (char) 0x7b, (char) 0x68, (char) 0x75, (char) 0x4b, (char) 0xab, (char) 0x5b, (char) 0xb2, (char) 0x7c, (char) 0x1b, (char) 0x8c,
	(char) 0x71, (char) 0xc3, (char) 0x51, (char) 0x8e, (char) 0x50, (char) 0x48, (char) 0x9a, (char) 0x49, (char) 0xe9, (char) 0xa4, (char) 0x85, (char) 0x76,
	(char) 0xda, (char) 0x7f, (char) 0x36, (char) 0x3f, (char) 0x90, (char) 0x26, (char) 0xb4, (char) 0x4c, (char) 0x20, (char) 0x94, (char) 0x23, (char) 0x85,
	(char) 0x1, (char) 0x6c, (char) 0xb0, (char) 0xc1, (char) 0x80, (char) 0xc, (char) 0xb6, (char) 0x2c, (char) 0xeb, (char) 0xbe, (char) 0xaf, (char) 0xd5,
	(char) 0xee, (char) 0xbe, (char) 0x3f, (char) 0x68, (char) 0x57, (char) 0x7e, (char) 0xbc, (char) 0x48, (char) 0xb6, (char) 0xe9, (char) 0xdb, (char) 0x49,
	(char) 0x24, (char) 0xb1, (char) 0xcf, (char) 0xcc, (char) 0x33, (char) 0xb2, (char) 0x35, (char) 0x58, (char) 0x48, (char) 0xfa, (char) 0x7e, (char) 0xbe,
	(char) 0xf7, (char) 0x5, (char) 0x98, (char) 0xc7, (char) 0x3c, (char) 0xe6, (char) 0x31, (char) 0x8f, (char) 0x79, (char) 0xcc, (char) 0x63, (char) 0x1e,
	(char) 0xf3, (char) 0x98, (char) 0xc7, (char) 0x3c, (char) 0xe6, (char) 0xf9, (char) 0xb4, (char) 0xe, (char) 0x31, (char) 0x3f, (char) 0x77, (char) 0xdf,
	(char) 0xa3, (char) 0x9a, (char) 0x5f, (char) 0xc4, (char) 0xf8, (char) 0x7d, (char) 0x36, (char) 0x72, (char) 0xc4, (char) 0xcf, (char) 0xae, (char) 0x1e,
	(char) 0xf0, (char) 0xbb, (char) 0x6a, (char) 0x2, (char) 0x60, (char) 0x74, (char) 0x3e, (char) 0xf, (char) 0xa1, (char) 0x7e, (char) 0x27, (char) 0x7d,
	(char) 0x7e, (char) 0xef, (char) 0xf7, (char) 0x37, (char) 0x6a, (char) 0x9f, (char) 0x47, (char) 0xfa, (char) 0xf6, (char) 0xfb, (char) 0x37, (char) 0x26,
	(char) 0x0, (char) 0x86, (char) 0xe8, (char) 0x73, (char) 0xd0, (char) 0x84, (char) 0x66, (char) 0x6, (char) 0xfc, (char) 0x4c, (char) 0xfa, (char) 0x0,
	(char) 0x2, (char) 0x6, (char) 0x82, (char) 0x3, (char) 0x80, (char) 0x42, (char) 0xfd, (char) 0xae, (char) 0x18, (char) 0x1e, (char) 0xfb, (char) 0x1,
	(char) 0xc3, (char) 0x4, (char) 0xc0, (char) 0xaf, (char) 0xf4, (char) 0xfe, (char) 0x8d, (char) 0x44, (char) 0xa7, (char) 0x2f, (char) 0xdb, (char) 0xe7,
	(char) 0x39, (char) 0xe6, (char) 0x8, (char) 0x0, (char) 0xd0, (char) 0x89, (char) 0x4d, (char) 0x5f, (char) 0x59, (char) 0xbb, (char) 0xc6, (char) 0xe7,
	(char) 0x47, (char) 0x1a, (char) 0x8, (char) 0x64, (char) 0xc4, (char) 0x81, (char) 0xab, (char) 0x13, (char) 0x93, (char) 0xa5, (char) 0x8, (char) 0xce,
	(char) 0x2, (char) 0xe0, (char) 0xc, (char) 0x8f, (char) 0xf4, (char) 0xd5, (char) 0x41, (char) 0xc0, (char) 0x53, (char) 0xcf, (char) 0x11, (char) 0x8d,
	(char) 0x80, (char) 0x92, (char) 0x46, (char) 0x64, (char) 0xc9, (char) 0x40, (char) 0x74, (char) 0x19, (char) 0x40, (char) 0x87, (char) 0xba, (char) 0x32,
	(char) 0xf5, (char) 0x38, (char) 0xd2, (char) 0x40, (char) 0xe0, (char) 0x46, (char) 0x98, (char) 0xeb, (char) 0x69, (char) 0x2e, (char) 0xe7, (char) 0xb4,
	(char) 0xcb, (char) 0x53, (char) 0x97, (char) 0x3, (char) 0x60, (char) 0x5, (char) 0xe0, (char) 0x0, (char) 0xe0, (char) 0xd4, (char) 0x1e, (char) 0xad,
	(char) 0x0, (char) 0x4, (char) 0xa, (char) 0x18, (char) 0x8c, (char) 0x81, (char) 0x9, (char) 0x14, (char) 0xa, (char) 0x0, (char) 0x6d, (char) 0x0,
	(char) 0xd, (char) 0x0, (char) 0x35, (char) 0x0, (char) 0x15, (char) 0xed, (char) 0xb1, (char) 0xa9, (char) 0x3d, (char) 0x2f, (char) 0x51, (char) 0xb7,
	(char) 0x63, (char) 0x90, (char) 0xe, (char) 0x23, (char) 0x65, (char) 0x1f, (char) 0x90, (char) 0x11, (char) 0xe5, (char) 0x7a, (char) 0x9a, (char) 0xf0,
	(char) 0x3c, (char) 0x0, (char) 0xb, (char) 0x75, (char) 0x1d, (char) 0x0, (char) 0xbc, (char) 0x0, (char) 0x44, (char) 0x0, (char) 0x6e, (char) 0x0,
	(char) 0x76, (char) 0x8d, (char) 0xe8, (char) 0x3c, (char) 0x2d, (char) 0x1, (char) 0x18, (char) 0x86, (char) 0x21, (char) 0xc, (char) 0xc3, (char) 0x10,
	(char) 0x42, (char) 0xba, (char) 0x2f, (char) 0xab, (char) 0xaa, (char) 0x2a, (char) 0x14, (char) 0x45, (char) 0x51, (char) 0x15, (char) 0x45, (char) 0xd1,
	(char) 0xb9, (char) 0x58, (char) 0xa6, (char) 0xc0, (char) 0xd0, (char) 0x4, (char) 0x50, (char) 0x5, (char) 0x50, (char) 0x4, (char) 0x90, (char) 0x7,
	(char) 0x50, (char) 0x2, (char) 0x50, (char) 0xd7, (char) 0xc0, (char) 0xa0, (char) 0x5f, (char) 0x5d, (char) 0x3a, (char) 0x28, (char) 0xa3, (char) 0x4,
	(char) 0x4, (char) 0x32, (char) 0x82, (char) 0x5c, (char) 0xaf, (char) 0x8b, (char) 0x6d, (char) 0x5e, (char) 0x23, (char) 0xac, (char) 0x5, (char) 0x80,
	(char) 0xd, (char) 0x80, (char) 0x7, (char) 0x40, (char) 0x10, (char) 0x40, (char) 0x0, (char) 0x80, (char) 0x4b, (char) 0x7b, (char) 0x8e, (char) 0x17,
	(char) 0x4, (char) 0x81, (char) 0x73, (char) 0xbb, (char) 0xdd, (char) 0x8c, (char) 0x28, (char) 0x8a, (char) 0xc4, (char) 0xed, (char) 0x76, (char) 0xc3,
	(char) 0xe1, (char) 0x70, (char) 0x10, (char) 0xab, (char) 0xd5, (char) 0xa, (char) 0x41, (char) 0x10, (char) 0xc0, (char) 0xf3, (char) 0x3c, (char) 0x58,
	(char) 0x96, (char) 0x5, (char) 0x21, (char) 0x4, (char) 0x8a, (char) 0xa2, (char) 0x40, (char) 0x92, (char) 0x24, (char) 0xb4, (char) 0x5a, (char) 0x2d,
	(char) 0x34, (char) 0x9b, (char) 0x4d, (char) 0xd4, (char) 0x6a, (char) 0x35, (char) 0x94, (char) 0x4a, (char) 0x25, (char) 0x35, (char) 0x9f, (char) 0xcf,
	(char) 0xab, (char) 0xe5, (char) 0x72, (char) 0x59, (char) 0x69, (char) 0xb5, (char) 0x5a, (char) 0x1d, (char) 0x0, (char) 0x2d, (char) 0xd, (char) 0x8,
	(char) 0x79, (char) 0x0, (char) 0x69, (char) 0x0, (char) 0x59, (char) 0x83, (char) 0x64, (char) 0x68, (char) 0x53, (char) 0x12, (char) 0x61, (char) 0x24,
	(char) 0x54, (char) 0x2, (char) 0x19, (char) 0x31, (char) 0xe2, (char) 0xeb, (char) 0xa2, (char) 0xde, (char) 0xa2, (char) 0x11, (char) 0xdf, (char) 0xa6,
	(char) 0x71, (char) 0x7a, (char) 0x18, (char) 0x40, (char) 0x8, (char) 0x80, (char) 0x87, (char) 0x10, (char) 0x62, (char) 0x73, (char) 0xb9, (char) 0x5c,
	(char) 0x7c, (char) 0x30, (char) 0x18, (char) 0x64, (char) 0x22, (char) 0x91, (char) 0x8, (char) 0x9, (char) 0x6, (char) 0x83, (char) 0x8, (char) 0x4,
	(char) 0x2, (char) 0xf0, (char) 0xfb, (char) 0xfd, (char) 0xf0, (char) 0x78, (char) 0x3c, (char) 0x70, (char) 0x3a, (char) 0x9d, (char) 0xb0, (char) 0xdb,
	(char) 0xed, (char) 0xb0, (char) 0x5a, (char) 0xad, (char) 0x3, (char) 0x1, (char) 0x50, (char) 0xab, (char) 0xd5, (char) 0x50, (char) 0xad, (char) 0x56,
	(char) 0x51, (char) 0x28, (char) 0x14, (char) 0x90, (char) 0xcd, (char) 0x66, (char) 0x91, (char) 0x4e, (char) 0xa7, (char) 0xb1, (char) 0xb3, (char) 0xb3,
	(char) 0x83, (char) 0x9d, (char) 0x9d, (char) 0x1d, (char) 0x25, (char) 0x97, (char) 0xcb, (char) 0xc9, (char) 0xcd, (char) 0x66, (char) 0xb3, (char) 0xa5,
	(char) 0xa9, (char) 0x85, (char) 0x5d, (char) 0x0, (char) 0x3b, (char) 0x1a, (char) 0x10, (char) 0xea, (char) 0x1a, (char) 0x40, (char) 0x5a, (char) 0x6,
	(char) 0x69, (char) 0x30, (char) 0xd4, (char) 0x0, (char) 0xe0, (char) 0x46, (char) 0x84, (char) 0xf8, (char) 0x46, (char) 0xae, (char) 0xb7, (char) 0x69,
	(char) 0x7a, (char) 0x3d, (char) 0xaa, (char) 0xdd, (char) 0x0, (char) 0xcf, (char) 0xf3, (char) 0x76, (char) 0xbf, (char) 0xdf, (char) 0xcf, (char) 0x4f,
	(char) 0x4c, (char) 0x4c, (char) 0x30, (char) 0x33, (char) 0x33, (char) 0x33, (char) 0x98, (char) 0x9e, (char) 0x9e, (char) 0xc6, (char) 0xc4, (char) 0xc4,
	(char) 0x4, (char) 0x22, (char) 0x91, (char) 0x8, (char) 0x82, (char) 0xc1, (char) 0x20, (char) 0x7c, (char) 0x3e, (char) 0x1f, (char) 0x3c, (char) 0x1e,
	(char) 0xf, (char) 0x1c, (char) 0xe, (char) 0x7, (char) 0x78, (char) 0x9e, (char) 0x87, (char) 0xa2, (char) 0x28, (char) 0xe8, (char) 0x74, (char) 0x3a,
	(char) 0x0, (char) 0x0, (char) 0x8b, (char) 0xc5, (char) 0x2, (char) 0x41, (char) 0x10, (char) 0xc0, (char) 0x71, (char) 0x1c, (char) 0x3a, (char) 0x9d,
	(char) 0xe, (char) 0x1a, (char) 0x8d, (char) 0x46, (char) 0xf, (char) 0x0, (char) 0xb9, (char) 0x5c, (char) 0xe, (char) 0xbb, (char) 0xbb, (char) 0xbb,
	(char) 0xd8, (char) 0xda, (char) 0xda, (char) 0xc2, (char) 0xdb, (char) 0xb7, (char) 0x6f, (char) 0x99, (char) 0xd7, (char) 0xaf, (char) 0x5f, (char) 0x33,
	(char) 0x89, (char) 0x44, (char) 0x82, (char) 0x4b, (char) 0xa5, (char) 0x52, (char) 0xd6, (char) 0x7a, (char) 0xbd, (char) 0xee, (char) 0xd0, (char) 0xd4,
	(char) 0x8c, (char) 0x43, (char) 0x3, (char) 0x42, (char) 0x59, (char) 0x7b, (char) 0xbf, (char) 0x2d, (char) 0xed, (char) 0xfd, (char) 0xf, (char) 0x3d,
	(char) 0x8, (char) 0xc8, (char) 0x8, (char) 0x71, (char) 0xbe, (char) 0xce, (char) 0xf5, (char) 0x76, (char) 0x0, (char) 0x3e, (char) 0x0, (char) 0x71,
	(char) 0x0, (char) 0x31, (char) 0x86, (char) 0x61, (char) 0xbc, (char) 0x7e, (char) 0xbf, (char) 0x5f, (char) 0x98, (char) 0x9e, (char) 0x9e, (char) 0x66,
	(char) 0x16, (char) 0x17, (char) 0x17, (char) 0xb1, (char) 0xb4, (char) 0xb4, (char) 0x84, (char) 0xf9, (char) 0xf9, (char) 0x79, (char) 0xcc, (char) 0xcc,
	(char) 0xcc, (char) 0x60, (char) 0x62, (char) 0x62, (char) 0x2, (char) 0x3e, (char) 0x9f, (char) 0xf, (char) 0x36, (char) 0x9b, (char) 0xd, (char) 0x8a,
	(char) 0xa2, (char) 0xa0, (char) 0x50, (char) 0x28, (char) 0x20, (char) 0x99, (char) 0x4c, (char) 0xe2, (char) 0xfd, (char) 0xfb, (char) 0xf7, (char) 0xc8,
	(char) 0x66, (char) 0xb3, (char) 0xa8, (char) 0xd5, (char) 0x6a, (char) 0x50, (char) 0x14, (char) 0x5, (char) 0x16, (char) 0x8b, (char) 0x5, (char) 0x5e,
	(char) 0xaf, (char) 0x17, (char) 0xb1, (char) 0x58, (char) 0xc, (char) 0x93, (char) 0x93, (char) 0x93, (char) 0x8, (char) 0x85, (char) 0x42, (char) 0xb0,
	(char) 0xd9, (char) 0x6c, (char) 0x20, (char) 0x84, (char) 0x40, (char) 0x96, (char) 0x65, (char) 0xd4, (char) 0x6a, (char) 0x35, (char) 0xa4, (char) 0xd3,
	(char) 0x69, (char) 0x24, (char) 0x12, (char) 0x9, (char) 0xbc, (char) 0x7a, (char) 0xf5, (char) 0xa, (char) 0xcf, (char) 0x9e, (char) 0x3d, (char) 0xc3,
	(char) 0xb3, (char) 0x67, (char) 0xcf, (char) 0xf0, (char) 0xfa, (char) 0xf5, (char) 0x6b, (char) 0x25, (char) 0x9d, (char) 0x4e, (char) 0xb7, (char) 0x65,
	(char) 0x59, (char) 0xce, (char) 0x3, (char) 0x78, (char) 0xaf, (char) 0xdd, (char) 0x82, (char) 0x66, (char) 0x3c, (char) 0xb6, (char) 0x28, (char) 0xaf,
	(char) 0x62, (char) 0x68, (char) 0x41, (char) 0x30, (char) 0xcc, (char) 0x0, (char) 0x60, (char) 0xc, (char) 0xc4, (char) 0xb7, (char) 0x6a, (char) 0x9c,
	(char) 0x1f, (char) 0x6, (char) 0x30, (char) 0x5, (char) 0x20, (char) 0x66, (char) 0xb7, (char) 0xdb, (char) 0xdd, (char) 0x93, (char) 0x93, (char) 0x93,
	(char) 0xec, (char) 0xd2, (char) 0xd2, (char) 0x12, (char) 0x39, (char) 0x77, (char) 0xee, (char) 0x1c, (char) 0x4e, (char) 0x9d, (char) 0x3a, (char) 0x85,
	(char) 0xe3, (char) 0xc7, (char) 0x8f, (char) 0x23, (char) 0x16, (char) 0x8b, (char) 0xc1, (char) 0xe9, (char) 0x74, (char) 0x82, (char) 0x61, (char) 0x18,
	(char) 0xa8, (char) 0xaa, (char) 0x8a, (char) 0x4a, (char) 0xa5, (char) 0x82, (char) 0xcd, (char) 0xcd, (char) 0x4d, (char) 0xac, (char) 0xac, (char) 0xac,
	(char) 0xe0, (char) 0xf9, (char) 0xf3, (char) 0xe7, (char) 0xd8, (char) 0xdc, (char) 0xdc, (char) 0x44, (char) 0x2e, (char) 0x97, (char) 0x43, (char) 0xa3,
	(char) 0xd1, (char) 0xe8, (char) 0x1, (char) 0xc0, (char) 0xed, (char) 0x76, (char) 0x23, (char) 0x1a, (char) 0x8d, (char) 0x62, (char) 0x71, (char) 0x71,
	(char) 0x11, (char) 0x67, (char) 0xce, (char) 0x9c, (char) 0xc1, (char) 0xf1, (char) 0xe3, (char) 0xc7, (char) 0x11, (char) 0x8, (char) 0x4, (char) 0xc0,
	(char) 0x30, (char) 0x4c, (char) 0xcf, (char) 0x48, (char) 0x6c, (char) 0xb7, (char) 0xdb, (char) 0xc8, (char) 0x66, (char) 0xb3, (char) 0x78, (char) 0xf5,
	(char) 0xea, (char) 0x15, (char) 0x1e, (char) 0x3d, (char) 0x7a, (char) 0x84, (char) 0xbb, (char) 0x77, (char) 0xef, (char) 0xe2, (char) 0xd9, (char) 0xb3,
	(char) 0x67, (char) 0xea, (char) 0xbb, (char) 0x77, (char) 0xef, (char) 0x3a, (char) 0xcd, (char) 0x66, (char) 0x33, (char) 0xf, (char) 0x60, (char) 0x53,
	(char) 0xbb, (char) 0xfd, (char) 0x40, (char) 0x30, (char) 0x94, (char) 0xf6, (char) 0x0, (char) 0x37, (char) 0x2, (char) 0xa2, (char) 0x9f, (char) 0x16,
	(char) 0xfb, (char) 0x61, (char) 0x0, (char) 0xb3, (char) 0x0, (char) 0x26, (char) 0x44, (char) 0x51, (char) 0x74, (char) 0x2c, (char) 0x2c, (char) 0x2c,
	(char) 0xb0, (char) 0xe7, (char) 0xcf, (char) 0x9f, (char) 0xc7, (char) 0x95, (char) 0x2b, (char) 0x57, (char) 0x70, (char) 0xe6, (char) 0xcc, (char) 0x19,
	(char) 0x4c, (char) 0x4e, (char) 0x4e, (char) 0xc2, (char) 0xe5, (char) 0x72, (char) 0x81, (char) 0xb6, (char) 0xec, (char) 0xb, (char) 0x85, (char) 0x2,
	(char) 0x9e, (char) 0x3f, (char) 0x7f, (char) 0x8e, (char) 0x9f, (char) 0x7e, (char) 0xfa, (char) 0x9, (char) 0xf, (char) 0x1e, (char) 0x3c, (char) 0xc0,
	(char) 0xfa, (char) 0xfa, (char) 0xba, (char) 0x9a, (char) 0x4c, (char) 0x26, (char) 0xd5, (char) 0x52, (char) 0xa9, (char) 0xa4, (char) 0x28, (char) 0x8a,
	(char) 0xa2, (char) 0x5b, (char) 0xeb, (char) 0xc4, (char) 0x66, (char) 0xb3, (char) 0x31, (char) 0xc1, (char) 0x60, (char) 0x90, (char) 0x99, (char) 0x9f,
	(char) 0x9f, (char) 0x27, (char) 0x9b, (char) 0x9b, (char) 0x9b, (char) 0xf8, (char) 0xfa, (char) 0xeb, (char) 0xaf, (char) 0x71, (char) 0xe6, (char) 0xcc,
	(char) 0x19, (char) 0x44, (char) 0x22, (char) 0x11, (char) 0x30, (char) 0xc, (char) 0x3, (char) 0x42, (char) 0x8, (char) 0x4, (char) 0x41, (char) 0x40,
	(char) 0x2c, (char) 0x16, (char) 0x83, (char) 0xcf, (char) 0xe7, (char) 0x43, (char) 0x2c, (char) 0x16, (char) 0x43, (char) 0x34, (char) 0x1a, (char) 0x85,
	(char) 0xc7, (char) 0xe3, (char) 0x21, (char) 0xf, (char) 0x1e, (char) 0x3c, (char) 0xe0, (char) 0xde, (char) 0xbc, (char) 0x79, (char) 0xe3, (char) 0xab,
	(char) 0xd7, (char) 0xeb, (char) 0xa0, (char) 0x62, (char) 0x4, (char) 0xc6, (char) 0x60, (char) 0x91, (char) 0x6c, (char) 0xda, (char) 0x0, (char) 0xff,
	(char) 0xbd, (char) 0xe8, (char) 0xb7, (char) 0x2, (char) 0xf0, (char) 0x3, (char) 0x98, (char) 0x6, (char) 0x30, (char) 0x11, (char) 0x8, (char) 0x4,
	(char) 0x9c, (char) 0x4b, (char) 0x4b, (char) 0x4b, (char) 0xcc, (char) 0x97, (char) 0x5f, (char) 0x7e, (char) 0x89, (char) 0x3f, (char) 0xfc, (char) 0xe1,
	(char) 0xf, (char) 0x58, (char) 0x5e, (char) 0x5e, (char) 0x46, (char) 0x30, (char) 0x18, (char) 0x4, (char) 0xcb, (char) 0xb2, (char) 0xfb, (char) 0x5e,
	(char) 0xa8, (char) 0x54, (char) 0x2a, (char) 0x61, (char) 0x75, (char) 0x75, (char) 0x15, (char) 0xdf, (char) 0x7d, (char) 0xf7, (char) 0x1d, (char) 0xfe,
	(char) 0xf5, (char) 0xaf, (char) 0x7f, (char) 0x61, (char) 0x7d, (char) 0x7d, (char) 0x5d, (char) 0xc9, (char) 0xe5, (char) 0x72, (char) 0xba, (char) 0x5b,
	(char) 0xd7, (char) 0xd0, (char) 0xb8, (char) 0x53, (char) 0x5, (char) 0xc0, (char) 0x36, (char) 0x1a, (char) 0xd, (char) 0xeb, (char) 0xbb, (char) 0x77,
	(char) 0xef, (char) 0x6c, (char) 0xd9, (char) 0x6c, (char) 0x56, (char) 0xc8, (char) 0x64, (char) 0x32, (char) 0x6c, (char) 0xa3, (char) 0xd1, (char) 0x0,
	(char) 0xcb, (char) 0xb2, (char) 0x10, (char) 0x4, (char) 0x1, (char) 0x7e, (char) 0xbf, (char) 0x7f, (char) 0xef, (char) 0xcd, (char) 0x11, (char) 0x2,
	(char) 0x9b, (char) 0xcd, (char) 0x86, (char) 0xf9, (char) 0xf9, (char) 0x79, (char) 0x38, (char) 0x9d, (char) 0x4e, (char) 0xb8, (char) 0x5c, (char) 0x2e,
	(char) 0xb0, (char) 0x2c, (char) 0x4b, (char) 0x54, (char) 0x55, (char) 0xe5, (char) 0x36, (char) 0x36, (char) 0x36, (char) 0xc4, (char) 0x56, (char) 0xab,
	(char) 0x15, (char) 0xa7, (char) 0xb8, (char) 0x5f, (char) 0x36, (char) 0xa8, (char) 0x80, (char) 0xa1, (char) 0x53, (char) 0x5, (char) 0xec, (char) 0x10,
	(char) 0x8b, (char) 0x7e, (char) 0x9e, (char) 0x72, (char) 0xf1, (char) 0xbc, (char) 0x1a, (char) 0xe7, (char) 0x4f, (char) 0xfa, (char) 0x7c, (char) 0x3e,
	(char) 0xf7, (char) 0xf2, (char) 0xf2, (char) 0x32, (char) 0xf3, (char) 0xcd, (char) 0x37, (char) 0xdf, (char) 0xe0, (char) 0xfa, (char) 0xf5, (char) 0xeb,
	(char) 0x38, (char) 0x75, (char) 0xea, (char) 0x14, (char) 0xfc, (char) 0x7e, (char) 0x7f, (char) 0x4f, (char) 0x54, (char) 0xeb, (char) 0xa7, (char) 0xd5,
	(char) 0x6a, (char) 0xe1, (char) 0xe5, (char) 0xcb, (char) 0x97, (char) 0xf8, (char) 0xe1, (char) 0x87, (char) 0x1f, (char) 0x70, (char) 0xe3, (char) 0xc6,
	(char) 0xd, (char) 0xac, (char) 0xae, (char) 0xae, (char) 0x2a, (char) 0xc5, (char) 0x62, (char) 0xb1, (char) 0xae, (char) 0x59, (char) 0xec, (char) 0x5b,
	(char) 0x0, (char) 0xde, (char) 0x1, (char) 0xd8, (char) 0x6, (char) 0x90, (char) 0xd2, (char) 0x9e, (char) 0xab, (char) 0x2, (char) 0xe8, (char) 0x48,
	(char) 0x92, (char) 0xc4, (char) 0x97, (char) 0x4a, (char) 0x25, (char) 0xbe, (char) 0x5e, (char) 0xaf, (char) 0x33, (char) 0x82, (char) 0x20, (char) 0x20,
	(char) 0x1c, (char) 0xe, (char) 0x23, (char) 0x10, (char) 0x8, (char) 0x80, (char) 0xe3, (char) 0xf6, (char) 0xf3, (char) 0xa, (char) 0xc3, (char) 0x30,
	(char) 0x70, (char) 0x38, (char) 0x1c, (char) 0xf0, (char) 0x78, (char) 0x3c, (char) 0xb0, (char) 0xdb, (char) 0xed, (char) 0x28, (char) 0x95, (char) 0x4a,
	(char) 0xa4, (char) 0x58, (char) 0x2c, (char) 0x32, (char) 0xc5, (char) 0x62, (char) 0x91, (char) 0xd7, (char) 0x88, (char) 0x5c, (char) 0xa7, (char) 0x40,
	(char) 0xa0, (char) 0xc, (char) 0xab, (char) 0x1d, (char) 0xc0, (char) 0xe, (char) 0x21, (char) 0xf7, (char) 0xeb, (char) 0xbe, (char) 0xbe, (char) 0x85,
	(char) 0x8a, (char) 0xe4, (char) 0x4d, (char) 0x2, (char) 0x98, (char) 0x71, (char) 0x3a, (char) 0x9d, (char) 0xde, (char) 0xa5, (char) 0xa5, (char) 0x25,
	(char) 0xf6, (char) 0xea, (char) 0xd5, (char) 0xab, (char) 0xb8, (char) 0x76, (char) 0xed, (char) 0x1a, (char) 0x96, (char) 0x97, (char) 0x97, (char) 0xe1,
	(char) 0x76, (char) 0xbb, (char) 0x7b, (char) 0x22, (char) 0xbf, (char) 0x17, (char) 0xce, (char) 0x53, (char) 0x14, (char) 0x6c, (char) 0x6f, (char) 0x6f,
	(char) 0xe3, (char) 0xc7, (char) 0x1f, (char) 0x7f, (char) 0xc4, (char) 0x77, (char) 0xdf, (char) 0x7d, (char) 0x87, (char) 0xa7, (char) 0x4f, (char) 0x9f,
	(char) 0x2a, (char) 0xe5, (char) 0x72, (char) 0xb9, (char) 0x6, (char) 0x20, (char) 0xa9, (char) 0xe9, (char) 0xe8, (char) 0x94, (char) 0x66, (char) 0xb1,
	(char) 0xd7, (char) 0x35, (char) 0x69, (char) 0xd0, (char) 0xd2, (char) 0x7e, (char) 0xee, (char) 0xca, (char) 0x70, (char) 0x59, (char) 0xb6, (char) 0xd5,
	(char) 0xeb, (char) 0x75, (char) 0x8b, (char) 0xc5, (char) 0x62, (char) 0x21, (char) 0x7e, (char) 0xbf, (char) 0x1f, (char) 0xf1, (char) 0x78, (char) 0x1c,
	(char) 0x2e, (char) 0x97, (char) 0xeb, (char) 0xc3, (char) 0x37, (char) 0x4b, (char) 0x8, (char) 0xec, (char) 0x76, (char) 0x3b, (char) 0x9c, (char) 0x4e,
	(char) 0x27, (char) 0x14, (char) 0x45, (char) 0x41, (char) 0x36, (char) 0x9b, (char) 0x25, (char) 0xf9, (char) 0x7c, (char) 0x9e, (char) 0xad, (char) 0xd7,
	(char) 0xeb, (char) 0xac, (char) 0xf6, (char) 0xba, (char) 0x65, (char) 0x43, (char) 0xc8, (char) 0xd8, (char) 0x4, (char) 0xc0, (char) 0x11, (char) 0x1,
	(char) 0xc0, (char) 0x51, (char) 0xdc, (char) 0x1f, (char) 0x4, (char) 0x30, (char) 0xcb, (char) 0xb2, (char) 0x6c, (char) 0x70, (char) 0x7e, (char) 0x7e,
	(char) 0x9e, (char) 0xff, (char) 0xf2, (char) 0xcb, (char) 0x2f, (char) 0xc9, (char) 0xf5, (char) 0xeb, (char) 0xd7, (char) 0xf1, (char) 0xd9, (char) 0x67,
	(char) 0x9f, (char) 0xf5, (char) 0x25, (char) 0xa, (char) 0x0, (char) 0x54, (char) 0xab, (char) 0x55, (char) 0x3c, (char) 0x7e, (char) 0xfc, (char) 0x18,
	(char) 0xdf, (char) 0x7f, (char) 0xff, (char) 0x3d, (char) 0xee, (char) 0xdf, (char) 0xbf, (char) 0xaf, (char) 0xa6, (char) 0xd3, (char) 0xe9, (char) 0x96,
	(char) 0xe6, (char) 0xa6, (char) 0x6d, (char) 0x52, (char) 0xc1, (char) 0x9b, (char) 0x86, (char) 0x21, (char) 0x80, (char) 0xa3, (char) 0xeb, (char) 0x6e,
	(char) 0x9, (char) 0x80, (char) 0xb5, (char) 0xdd, (char) 0x6e, (char) 0xdb, (char) 0x1, (char) 0x70, (char) 0x3e, (char) 0x9f, (char) 0x8f, (char) 0x4c,
	(char) 0x4c, (char) 0x4c, (char) 0x20, (char) 0x1a, (char) 0x8d, (char) 0x7e, (char) 0x20, (char) 0x65, (char) 0x68, (char) 0x10, (char) 0x58, (char) 0x2c,
	(char) 0x16, (char) 0x94, (char) 0x4a, (char) 0x25, (char) 0xa4, (char) 0x52, (char) 0x29, (char) 0x92, (char) 0xc9, (char) 0x64, (char) 0x18, (char) 0x2d,
	(char) 0xa2, (char) 0x58, (char) 0xd6, (char) 0xfe, (char) 0x8f, (char) 0xa1, (char) 0x5, (char) 0x1, (char) 0x33, (char) 0xc4, (char) 0xd1, (char) 0x3e,
	(char) 0x5e, (char) 0x93, (char) 0x0, (char) 0x21, (char) 0x0, (char) 0xfe, (char) 0x40, (char) 0x20, (char) 0x60, (char) 0x59, (char) 0x5e, (char) 0x5e,
	(char) 0x26, (char) 0x57, (char) 0xae, (char) 0x5c, (char) 0xc1, (char) 0xc9, (char) 0x93, (char) 0x27, (char) 0x7, (char) 0x12, (char) 0x5f, (char) 0x55,
	(char) 0x55, (char) 0xa4, (char) 0x52, (char) 0x29, (char) 0x3c, (char) 0x7d, (char) 0xfa, (char) 0x14, (char) 0xab, (char) 0xab, (char) 0xab, (char) 0x48,
	(char) 0xa5, (char) 0x52, (char) 0x1d, (char) 0x2d, (char) 0x84, (char) 0xbb, (char) 0xd, (char) 0x20, (char) 0xa7, (char) 0x89, (char) 0xfa, (char) 0x1a,
	(char) 0xc5, (char) 0xf1, (char) 0x75, (char) 0x2a, (char) 0xe6, (char) 0x5f, (char) 0xd3, (char) 0xc2, (char) 0xbc, (char) 0xbb, (char) 0x0, (char) 0xea,
	(char) 0xbb, (char) 0xbb, (char) 0xbb, (char) 0x4a, (char) 0x22, (char) 0x91, (char) 0x40, (char) 0x22, (char) 0x91, (char) 0x40, (char) 0xad, (char) 0x56,
	(char) 0x1b, (char) 0xf8, (char) 0xc6, (char) 0x79, (char) 0x9e, (char) 0xc7, (char) 0xf4, (char) 0xf4, (char) 0x34, (char) 0x4e, (char) 0x9d, (char) 0x3a,
	(char) 0x85, (char) 0xc5, (char) 0xc5, (char) 0x45, (char) 0xf8, (char) 0x7c, (char) 0x3e, (char) 0x5e, (char) 0x8b, (char) 0x4c, (char) 0xfa, (char) 0xa9,
	(char) 0xbc, (char) 0x44, (char) 0xbf, (char) 0xdc, (char) 0x83, (char) 0x9, (char) 0x80, (char) 0x3, (char) 0x54, (char) 0x0, (char) 0xaf, (char) 0x85,
	(char) 0x74, (char) 0x83, (char) 0x1c, (char) 0xc7, (char) 0xd9, (char) 0xa6, (char) 0xa6, (char) 0xa6, (char) 0x98, (char) 0xb3, (char) 0x67, (char) 0xcf,
	(char) 0xe2, (char) 0xd4, (char) 0xa9, (char) 0x53, (char) 0xf0, (char) 0xf9, (char) 0x7c, (char) 0x1f, (char) 0x88, (char) 0x7d, (char) 0xfd, (char) 0x34,
	(char) 0x1a, (char) 0xd, (char) 0x6c, (char) 0x6c, (char) 0x6c, (char) 0xe0, (char) 0xc5, (char) 0x8b, (char) 0x17, (char) 0xd8, (char) 0xdc, (char) 0xdc,
	(char) 0x54, (char) 0x25, (char) 0x49, (char) 0x6a, (char) 0x6a, (char) 0x61, (char) 0xdb, (char) 0xc, (char) 0x25, (char) 0xf2, (char) 0x75, (char) 0xb1,
	(char) 0xaf, (char) 0x73, (char) 0x7f, (char) 0x8b, (char) 0xba, (char) 0xd, (char) 0x2d, (char) 0xd4, (char) 0x5b, (char) 0xa9, (char) 0x54, (char) 0x2a,
	(char) 0x9d, (char) 0x9d, (char) 0x9d, (char) 0x1d, (char) 0x6c, (char) 0x6d, (char) 0x6d, (char) 0x21, (char) 0x9f, (char) 0xcf, (char) 0x1f, (char) 0xf8,
	(char) 0xc6, (char) 0x9d, (char) 0x4e, (char) 0x27, (char) 0x8e, (char) 0x1f, (char) 0x3f, (char) 0x8e, (char) 0xc5, (char) 0xc5, (char) 0x45, (char) 0x44,
	(char) 0xa3, (char) 0x51, (char) 0xa2, (char) 0x49, (char) 0x2f, (char) 0xbf, (char) 0x1e, (char) 0x92, (char) 0xa6, (char) 0x0, (char) 0x30, (char) 0x54,
	(char) 0xee, (char) 0xf7, (char) 0x30, (char) 0x2, (char) 0x40, (char) 0x77, (char) 0xff, (char) 0x38, (char) 0x2d, (char) 0xcc, (char) 0xeb, (char) 0xf6,
	(char) 0x7a, (char) 0xbd, (char) 0xfc, (char) 0xc2, (char) 0xc2, (char) 0x2, (char) 0x96, (char) 0x96, (char) 0x96, (char) 0x10, (char) 0x8f, (char) 0xc7,
	(char) 0x3f, (char) 0xb0, (char) 0xf6, (char) 0xe9, (char) 0x93, (char) 0xcf, (char) 0xe7, (char) 0xb1, (char) 0xb1, (char) 0xb1, (char) 0x81, (char) 0x44,
	(char) 0x22, (char) 0x81, (char) 0x5c, (char) 0x2e, (char) 0xd7, (char) 0xd1, (char) 0xc4, (char) 0x70, (char) 0x9a, (char) 0x12, (char) 0xf9, (char) 0xba,
	(char) 0x6f, (char) 0x4e, (char) 0x67, (char) 0xf1, (char) 0x74, (char) 0xf1, (char) 0xaf, (char) 0x3, (char) 0xa2, (char) 0xae, (char) 0x85, (char) 0x7a,
	(char) 0xa5, (char) 0x6c, (char) 0x36, (char) 0xab, (char) 0xa6, (char) 0xd3, (char) 0x69, (char) 0x64, (char) 0x32, (char) 0x19, (char) 0xa8, (char) 0xea,
	(char) 0x60, (char) 0xe9, (char) 0xcd, (char) 0x30, (char) 0xc, (char) 0x62, (char) 0xb1, (char) 0x18, (char) 0x66, (char) 0x66, (char) 0x66, (char) 0x10,
	(char) 0x8f, (char) 0xc7, (char) 0x89, (char) 0xd5, (char) 0x6a, (char) 0xe5, (char) 0x34, (char) 0x0, (char) 0x3b, (char) 0xd, (char) 0xdc, (char) 0x6f,
	(char) 0x4a, (char) 0x80, (char) 0x23, (char) 0xaa, (char) 0x0, (char) 0x56, (char) 0xb3, (char) 0xfe, (char) 0x85, (char) 0x50, (char) 0x28, (char) 0x44,
	(char) 0x66, (char) 0x67, (char) 0x67, (char) 0x31, (char) 0x33, (char) 0x33, (char) 0x3, (char) 0x87, (char) 0xc3, (char) 0x31, (char) 0xf0, (char) 0x5,
	(char) 0x74, (char) 0xe3, (char) 0x6f, (char) 0x73, (char) 0x73, (char) 0x13, (char) 0xef, (char) 0xdf, (char) 0xbf, (char) 0x57, (char) 0x25, (char) 0x49,
	(char) 0x6a, (char) 0x6b, (char) 0xe2, (char) 0xbf, (char) 0xd8, (char) 0x87, (char) 0xf0, (char) 0x83, (char) 0xa, (char) 0x3e, (char) 0x74, (char) 0x3b,
	(char) 0xa0, (char) 0x2, (char) 0x40, (char) 0xca, (char) 0xe7, (char) 0xf3, (char) 0x6a, (char) 0xa1, (char) 0x50, (char) 0x40, (char) 0xa1, (char) 0x50,
	(char) 0x38, (char) 0xf4, (char) 0x3, (char) 0xb8, (char) 0x5c, (char) 0xae, (char) 0x5e, (char) 0x7c, (char) 0xc0, (char) 0xeb, (char) 0xf5, (char) 0xb2,
	(char) 0x9a, (char) 0xa, (char) 0x73, (char) 0x9b, (char) 0x2a, (char) 0xe0, (char) 0xbf, (char) 0x53, (char) 0x3, (char) 0xbc, (char) 0x16, (char) 0xf6,
	(char) 0xe5, (char) 0x82, (char) 0xc1, (char) 0x20, (char) 0x89, (char) 0x44, (char) 0x22, (char) 0x88, (char) 0x44, (char) 0x22, (char) 0x3, (char) 0x45,
	(char) 0x3f, (char) 0x0, (char) 0x34, (char) 0x9b, (char) 0x4d, (char) 0x6c, (char) 0x6d, (char) 0x6d, (char) 0x61, (char) 0x6b, (char) 0x6b, (char) 0xb,
	(char) 0xd9, (char) 0x6c, (char) 0x56, (char) 0xd1, (char) 0xb8, (char) 0x3e, (char) 0x47, (char) 0x89, (char) 0xfb, (char) 0x7e, (char) 0x99, (char) 0x3a,
	(char) 0xfa, (char) 0xd2, (char) 0x20, (char) 0xa8, (char) 0x1, (char) 0x90, (char) 0xaa, (char) 0xd5, (char) 0xaa, (char) 0x5a, (char) 0x2e, (char) 0x97,
	(char) 0x51, (char) 0x2e, (char) 0x97, (char) 0x21, (char) 0xcb, (char) 0x7, (char) 0xc7, (char) 0x72, (char) 0x58, (char) 0x96, (char) 0x45, (char) 0x30,
	(char) 0x18, (char) 0x44, (char) 0x28, (char) 0x14, (char) 0x82, (char) 0xcf, (char) 0xe7, (char) 0x23, (char) 0xda, (char) 0x67, (char) 0xe8, (char) 0x27,
	(char) 0x1, (char) 0x4c, (char) 0x15, (char) 0x70, (char) 0x88, (char) 0x14, (char) 0xa0, (char) 0xd5, (char) 0x0, (char) 0xe3, (char) 0x70, (char) 0x38,
	(char) 0xe0, (char) 0x72, (char) 0xb9, (char) 0x6, (char) 0x1a, (char) 0x7e, (char) 0xfa, (char) 0x29, (char) 0x16, (char) 0x8b, (char) 0x48, (char) 0x26,
	(char) 0x93, (char) 0xd8, (char) 0xdd, (char) 0xdd, (char) 0x45, (char) 0xa5, (char) 0x52, (char) 0x91, (char) 0x29, (char) 0xa3, (char) 0xce, (char) 0x98,
	(char) 0xaf, (char) 0x37, (char) 0x86, (char) 0x65, (char) 0xfb, (char) 0x95, (char) 0x82, (char) 0x35, (char) 0x1, (char) 0x48, (char) 0xad, (char) 0x56,
	(char) 0x4b, (char) 0x69, (char) 0x34, (char) 0x1a, (char) 0x68, (char) 0x34, (char) 0x1a, (char) 0x68, (char) 0xb7, (char) 0xdb, (char) 0x7, (char) 0xbf,
	(char) 0x79, (char) 0x42, (char) 0x20, (char) 0x8a, (char) 0x22, (char) 0x44, (char) 0x51, (char) 0x84, (char) 0xc7, (char) 0xe3, (char) 0x21, (char) 0xd8,
	(char) 0x2b, (char) 0x4a, (char) 0x31, (char) 0x55, (char) 0xc0, (char) 0x47, (char) 0x1e, (char) 0xd5, (char) 0x68, (char) 0x2c, (char) 0x11, (char) 0x42,
	(char) 0xe, (char) 0xe4, (char) 0x7e, (char) 0x0, (char) 0xbd, (char) 0xd4, (char) 0x6d, (char) 0x26, (char) 0x93, (char) 0x51, (char) 0x15, (char) 0x45,
	(char) 0x91, (char) 0x28, (char) 0x8b, (char) 0xdf, (char) 0xe8, (char) 0x86, (char) 0xa9, (char) 0x3, (char) 0xfe, (char) 0x4f, (char) 0x1a, (char) 0x0,
	(char) 0xbd, (char) 0x18, (char) 0x7e, (char) 0xab, (char) 0xd5, (char) 0x42, (char) 0xab, (char) 0xd5, (char) 0x82, (char) 0x24, (char) 0x49, (char) 0x87,
	(char) 0xbe, (char) 0x71, (char) 0x87, (char) 0xc3, (char) 0x1, (char) 0x87, (char) 0xc3, (char) 0x1, (char) 0xbb, (char) 0xdd, (char) 0xae, (char) 0x7f,
	(char) 0xbf, (char) 0x96, (char) 0x61, (char) 0x15, (char) 0xff, (char) 0xc3, (char) 0x8, (char) 0x0, (char) 0x9a, (char) 0x13, (char) 0x75, (char) 0x5d,
	(char) 0xac, (char) 0x54, (char) 0x2a, (char) 0x15, (char) 0x94, (char) 0x4a, (char) 0x25, (char) 0x94, (char) 0x4a, (char) 0xa5, (char) 0x3, (char) 0xf5,
	(char) 0x7f, (char) 0x36, (char) 0x9b, (char) 0x45, (char) 0x26, (char) 0x93, (char) 0x41, (char) 0x2e, (char) 0x97, (char) 0xd3, (char) 0xeb, (char) 0xfb,
	(char) 0xca, (char) 0x6, (char) 0xbd, (char) 0x7f, (char) 0x58, (char) 0x42, (char) 0x86, (char) 0x2e, (char) 0xf9, (char) 0xd6, (char) 0xed, (char) 0x2,
	(char) 0x55, (char) 0x96, (char) 0x65, (char) 0x48, (char) 0x92, (char) 0x74, (char) 0x24, (char) 0x0, (char) 0xd8, (char) 0x6c, (char) 0x36, (char) 0xd8,
	(char) 0x6c, (char) 0x36, (char) 0x8, (char) 0x82, (char) 0xa0, (char) 0x3, (char) 0x58, (char) 0xd7, (char) 0xff, (char) 0x46, (char) 0xee, (char) 0x27,
	(char) 0x26, (char) 0x0, (char) 0xe, (char) 0xe6, (char) 0xc0, (char) 0x8e, (char) 0xc6, (char) 0xc1, (char) 0x52, (char) 0x2a, (char) 0x95, (char) 0x52,
	(char) 0x5f, (char) 0xbf, (char) 0x7e, (char) 0x8d, (char) 0x37, (char) 0x6f, (char) 0xde, (char) 0xa0, (char) 0xd9, (char) 0x6c, (char) 0xf6, (char) 0xfd,
	(char) 0x63, (char) 0x3d, (char) 0x53, (char) 0x97, (char) 0xcb, (char) 0xe5, (char) 0x50, (char) 0x2a, (char) 0x95, (char) 0x14, (char) 0x43, (char) 0x24,
	(char) 0xee, (char) 0x28, (char) 0x12, (char) 0xc0, (char) 0x8, (char) 0x82, (char) 0xde, (char) 0xcf, (char) 0x8a, (char) 0xa2, (char) 0xf4, (char) 0xee,
	(char) 0xa1, (char) 0x91, (char) 0x35, (char) 0x96, (char) 0xed, (char) 0x5d, (char) 0x83, (char) 0x61, (char) 0x3b, (char) 0x54, (char) 0x84, (char) 0xd7,
	(char) 0xcf, (char) 0x30, (char) 0x26, (char) 0x83, (char) 0x74, (char) 0xce, (char) 0x6b, (char) 0x6b, (char) 0x6, (char) 0x5c, (char) 0x38, (char) 0x9d,
	(char) 0x4e, (char) 0xdb, (char) 0x9e, (char) 0x3c, (char) 0x79, (char) 0xc2, (char) 0xc5, (char) 0x62, (char) 0x31, (char) 0xb8, (char) 0x5c, (char) 0x2e,
	(char) 0xcc, (char) 0xcf, (char) 0xcf, (char) 0xc3, (char) 0x6e, (char) 0xb7, (char) 0xef, (char) 0xcb, (char) 0xfa, (char) 0xe5, (char) 0xf3, (char) 0x79,
	(char) 0xa4, (char) 0x52, (char) 0x29, (char) 0xa4, (char) 0xd3, (char) 0x69, (char) 0x34, (char) 0x9b, (char) 0x4d, (char) 0x99, (char) 0x76, (char) 0xe5,
	(char) 0x3e, (char) 0x22, (char) 0xa, (char) 0xd7, (char) 0x97, (char) 0x4b, (char) 0x75, (char) 0xf5, (char) 0x73, (char) 0x98, (char) 0xa, (char) 0x32,
	(char) 0x6, (char) 0xa4, (char) 0xc, (char) 0xc0, (char) 0xee, (char) 0x7, (char) 0x30, (char) 0x13, (char) 0x0, (char) 0x7d, (char) 0xb8, (char) 0x4f,
	(char) 0xa1, (char) 0xc4, (char) 0x7f, (char) 0x16, (char) 0x40, (char) 0xba, (char) 0x54, (char) 0x2a, (char) 0x39, (char) 0x5e, (char) 0xbe, (char) 0x7c,
	(char) 0xe9, (char) 0xb4, (char) 0x58, (char) 0x2c, (char) 0x4c, (char) 0xbb, (char) 0xdd, (char) 0xc6, (char) 0x85, (char) 0xb, (char) 0x17, (char) 0x30,
	(char) 0x37, (char) 0x37, (char) 0x7, (char) 0xbf, (char) 0xdf, (char) 0xf, (char) 0x9e, (char) 0xe7, (char) 0x51, (char) 0xa9, (char) 0x54, (char) 0xf0,
	(char) 0xf8, (char) 0xf1, (char) 0x63, (char) 0x3c, (char) 0x7d, (char) 0xfa, (char) 0x14, (char) 0xc9, (char) 0x64, (char) 0x52, (char) 0x55, (char) 0x55,
	(char) 0xb5, (char) 0x8d, (char) 0xbd, (char) 0x58, (char) 0xff, (char) 0xc7, (char) 0xe6, (char) 0xe3, (char) 0x89, (char) 0x51, (char) 0x74, (char) 0x73,
	(char) 0x1c, (char) 0x7, (char) 0x9e, (char) 0xe7, (char) 0xc1, (char) 0xf3, (char) 0xfc, (char) 0xa1, (char) 0x7f, (char) 0x6c, (char) 0xb0, (char) 0x17,
	(char) 0xf6, (char) 0xa9, (char) 0x92, (char) 0x61, (char) 0x34, (char) 0xb6, (char) 0xb8, (char) 0x21, (char) 0x23, (char) 0x3e, (char) 0xed, (char) 0x8e,
	(char) 0xb5, (char) 0x35, (char) 0xe, (char) 0xde, (char) 0x2, (char) 0x60, (char) 0x4d, (char) 0xa5, (char) 0x52, (char) 0x13, (char) 0xb2, (char) 0x2c,
	(char) 0xdb, (char) 0xcb, (char) 0xe5, (char) 0x32, (char) 0xf3, (char) 0xf6, (char) 0xed, (char) 0x5b, (char) 0xcc, (char) 0xcf, (char) 0xcf, (char) 0x23,
	(char) 0x10, (char) 0x8, (char) 0xf4, (char) 0x0, (char) 0xf0, (char) 0xec, (char) 0xd9, (char) 0x33, (char) 0x3c, (char) 0x79, (char) 0xf2, (char) 0x4,
	(char) 0xe9, (char) 0x74, (char) 0x5a, (char) 0xf, (char) 0xfe, (char) 0x64, (char) 0xd, (char) 0xae, (char) 0xdf, (char) 0x61, (char) 0xe2, (char) 0xdf,
	(char) 0xe8, (char) 0x81, (char) 0x58, (char) 0x0, (char) 0x70, (char) 0x84, (char) 0x10, (char) 0xc6, (char) 0x6a, (char) 0xb5, (char) 0xd2, (char) 0x7a,
	(char) 0xfd, (char) 0xc0, (char) 0x53, (char) 0xab, (char) 0xd5, (char) 0x50, (char) 0xab, (char) 0xd5, (char) 0xa0, (char) 0xd5, (char) 0x6, (char) 0x28,
	(char) 0x7, (char) 0x0, (char) 0x50, (char) 0x35, (char) 0x1, (char) 0x70, (char) 0xb0, (char) 0x4, (char) 0x60, (char) 0x34, (char) 0x3d, (char) 0x9e,
	(char) 0x6, (char) 0xc0, (char) 0xaa, (char) 0xaa, (char) 0xaa, (char) 0xa4, (char) 0xd3, (char) 0xe9, (char) 0x48, (char) 0xb9, (char) 0x5c, (char) 0x76,
	(char) 0x6c, (char) 0x6d, (char) 0x6d, (char) 0x71, (char) 0xe1, (char) 0x70, (char) 0x98, (char) 0x88, (char) 0xa2, (char) 0x48, (char) 0x78, (char) 0x9e,
	(char) 0x47, (char) 0xb5, (char) 0x5a, (char) 0x45, (char) 0x2a, (char) 0x95, (char) 0x52, (char) 0xd3, (char) 0xe9, (char) 0x74, (char) 0xa7, (char) 0x5c,
	(char) 0x2e, (char) 0x17, (char) 0xd1, (char) 0xcd, (char) 0xfa, (char) 0x65, (char) 0xfa, (char) 0xf8, (char) 0xfe, (char) 0x47, (char) 0xd, (char) 0x42,
	(char) 0x31, (char) 0x5a, (char) 0xc, (char) 0x82, (char) 0xb7, (char) 0xdb, (char) 0xed, (char) 0x44, (char) 0xcf, (char) 0xfb, (char) 0x5b, (char) 0x2c,
	(char) 0x96, (char) 0x43, (char) 0x3f, (char) 0x40, (char) 0xb1, (char) 0x58, (char) 0x44, (char) 0xb1, (char) 0x58, (char) 0x44, (char) 0xb9, (char) 0x5c,
	(char) 0xd6, (char) 0x81, (char) 0xdc, (char) 0xfc, (char) 0x8, (char) 0xfb, (char) 0xc3, (char) 0x4, (char) 0x80, (char) 0xf6, (char) 0x45, (char) 0x11,
	(char) 0x8d, (char) 0x70, (char) 0x2d, (char) 0xed, (char) 0xe7, (char) 0xa4, (char) 0xf6, (char) 0x73, (char) 0xb5, (char) 0xd9, (char) 0x6c, (char) 0x86,
	(char) 0xb7, (char) 0xb7, (char) 0xb7, (char) 0x5d, (char) 0xdb, (char) 0xdb, (char) 0xdb, (char) 0x2, (char) 0xf6, (char) 0xb2, (char) 0x99, (char) 0xb4,
	(char) 0xd5, (char) 0x9f, (char) 0x44, (char) 0x37, (char) 0xd7, (char) 0x4f, (char) 0xfb, (char) 0xff, (char) 0x7, (char) 0x7d, (char) 0xf9, (char) 0xc4,
	(char) 0x10, (char) 0x80, (char) 0xd2, (char) 0xe3, (char) 0xf, (char) 0x4e, (char) 0x0, (char) 0x16, (char) 0xaf, (char) 0xd7, (char) 0x4b, (char) 0x7c,
	(char) 0x3e, (char) 0x1f, (char) 0x44, (char) 0x51, (char) 0xec, (char) 0x9b, (char) 0xd, (char) 0x34, (char) 0x7a, (char) 0x22, (char) 0x99, (char) 0x4c,
	(char) 0xc6, (char) 0xe8, (char) 0x89, (char) 0x54, (char) 0xd1, (char) 0xbf, (char) 0x83, (char) 0xc8, (char) 0x4, (char) 0xc0, (char) 0x21, (char) 0x86,
	(char) 0x60, (char) 0xa7, (char) 0xcf, (char) 0xef, (char) 0x7a, (char) 0x29, (char) 0xb6, (char) 0x1f, (char) 0xdd, (char) 0x6c, (char) 0x9b, (char) 0xa0,
	(char) 0x11, (char) 0x4d, (char) 0xd2, (char) 0xfc, (char) 0xfd, (char) 0xac, (char) 0x76, (char) 0x4b, (char) 0x54, (char) 0xf4, (char) 0xef, (char) 0x28,
	(char) 0xfa, (char) 0xdf, (char) 0x48, (char) 0x7c, (char) 0xb, (char) 0xba, (char) 0x71, (char) 0x7c, (char) 0x4b, (char) 0x20, (char) 0x10, (char) 0xe8,
	(char) 0x95, (char) 0x96, (char) 0x1f, (char) 0x66, (char) 0x4, (char) 0x56, (char) 0xab, (char) 0x55, (char) 0x24, (char) 0x93, (char) 0x49, (char) 0x24,
	(char) 0x93, (char) 0x49, (char) 0x14, (char) 0xa, (char) 0x5, (char) 0xa3, (char) 0x27, (char) 0x32, (char) 0x94, (char) 0x76, (char) 0xc0, (char) 0x30,
	(char) 0x2, (char) 0x40, (char) 0x35, (char) 0x10, (char) 0x9d, (char) 0x36, (char) 0xa4, (char) 0x24, (char) 0xcd, (char) 0xb0, (char) 0xcb, (char) 0x60,
	(char) 0x7f, (char) 0x5f, (char) 0x1f, (char) 0x6d, (char) 0x38, (char) 0xea, (char) 0x9, (char) 0x1d, (char) 0x9, (char) 0x47, (char) 0xcb, (char) 0xc3,
	(char) 0x1b, (char) 0x89, (char) 0xaf, (char) 0x67, (char) 0x21, (char) 0x5d, (char) 0x3c, (char) 0xcf, (char) 0x73, (char) 0xe1, (char) 0x70, (char) 0x98,
	(char) 0xe8, (char) 0xa5, (char) 0xe5, (char) 0x87, (char) 0x59, (char) 0xfd, (char) 0xbb, (char) 0xbb, (char) 0xbb, (char) 0x48, (char) 0x24, (char) 0x12,
	(char) 0x78, (char) 0xff, (char) 0xfe, (char) 0x3d, (char) 0xea, (char) 0xf5, (char) 0xba, (char) 0xee, (char) 0xc6, (char) 0x56, (char) 0x30, (char) 0xc4,
	(char) 0xf5, (char) 0x0, (char) 0xc3, (char) 0x2a, (char) 0x1, (char) 0x6, (char) 0xb5, (char) 0x68, (char) 0xeb, (char) 0x19, (char) 0x3b, (char) 0x9a,
	(char) 0xf8, (char) 0x46, (char) 0x6b, (char) 0xdb, (char) 0x98, (char) 0xe5, (char) 0x3b, (char) 0x8c, (char) 0xf8, (char) 0xc6, (char) 0x14, (char) 0xb4,
	(char) 0x5, (char) 0xdd, (char) 0xb2, (char) 0x73, (char) 0x87, (char) 0x28, (char) 0x8a, (char) 0xac, (char) 0x5e, (char) 0x2a, (char) 0xee, (char) 0x76,
	(char) 0xbb, (char) 0xf, (char) 0x7c, (char) 0xc3, (char) 0xf5, (char) 0x7a, (char) 0x1d, (char) 0xaf, (char) 0x5e, (char) 0xbd, (char) 0xc2, (char) 0xfa,
	(char) 0xfa, (char) 0x3a, (char) 0x92, (char) 0xc9, (char) 0xa4, (char) 0xa2, (char) 0xaa, (char) 0x6a, (char) 0x53, (char) 0x73, (char) 0x63, (char) 0xeb,
	(char) 0xd8, (char) 0x5f, (char) 0x24, (char) 0x6a, (char) 0x2, (char) 0xe0, (char) 0x23, (char) 0x41, (char) 0xa0, (char) 0x1a, (char) 0x8, (char) 0x4c,
	(char) 0x37, (char) 0x86, (char) 0x92, (char) 0x1, (char) 0x41, (char) 0xa4, (char) 0xa3, (char) 0xe8, (char) 0xdb, (char) 0x41, (char) 0xc4, (char) 0x77,
	(char) 0x69, (char) 0x2a, (char) 0xc6, (char) 0x1a, (char) 0x8b, (char) 0xc5, (char) 0xc8, (char) 0xec, (char) 0xec, (char) 0x2c, (char) 0xa6, (char) 0xa7,
	(char) 0xa7, (char) 0xf, (char) 0x34, (char) 0x0, (char) 0x65, (char) 0x59, (char) 0xc6, (char) 0xd6, (char) 0xd6, (char) 0x16, (char) 0x9e, (char) 0x3d,
	(char) 0x7b, (char) 0x86, (char) 0xf5, (char) 0xf5, (char) 0x75, (char) 0x64, (char) 0xb3, (char) 0x59, (char) 0xdd, (char) 0x13, (char) 0xc9, (char) 0xd,
	(char) 0x88, (char) 0x44, (char) 0x9a, (char) 0x36, (char) 0xc0, (char) 0x47, (char) 0x82, (char) 0x0, (char) 0x14, (char) 0x37, (char) 0x1f, (char) 0xa5,
	(char) 0xb7, (char) 0x1f, (char) 0x47, (char) 0xfc, (char) 0xa2, (char) 0x89, (char) 0x81, (char) 0xf8, (char) 0x2, (char) 0xba, (char) 0xbd, (char) 0x85,
	(char) 0x5e, (char) 0xaf, (char) 0xd7, (char) 0xcb, (char) 0xcf, (char) 0xcd, (char) 0xcd, (char) 0x91, (char) 0x63, (char) 0xc7, (char) 0x8e, (char) 0x21,
	(char) 0x1a, (char) 0x8d, (char) 0xe, (char) 0xd4, (char) 0xff, (char) 0xaa, (char) 0xaa, (char) 0x22, (char) 0x97, (char) 0xcb, (char) 0xe1, (char) 0xc9,
	(char) 0x93, (char) 0x27, (char) 0xf8, (char) 0xcf, (char) 0x7f, (char) 0xfe, (char) 0x83, (char) 0x44, (char) 0x22, (char) 0xa1, (char) 0xb4, (char) 0xdb,
	(char) 0xed, (char) 0xba, (char) 0xe6, (char) 0xbd, (char) 0x14, (char) 0x3e, (char) 0xc2, (char) 0x13, (char) 0x31, (char) 0x1, (char) 0xf0, (char) 0x31,
	(char) 0xe1, (char) 0xd9, (char) 0x1, (char) 0x0, (char) 0x38, (char) 0xaa, (char) 0x8f, (char) 0xdd, (char) 0x4f, (char) 0xef, (char) 0xb, (char) 0x9a,
	(char) 0x61, (char) 0x19, (char) 0x22, (char) 0x84, (char) 0xd8, (char) 0xe3, (char) 0xf1, (char) 0x38, (char) 0x39, (char) 0x71, (char) 0xe2, (char) 0x4,
	(char) 0x4e, (char) 0x9c, (char) 0x38, (char) 0x71, (char) 0xa0, (char) 0xf8, (char) 0xaf, (char) 0x54, (char) 0x2a, (char) 0x78, (char) 0xf1, (char) 0xe2,
	(char) 0x5, (char) 0xee, (char) 0xdc, (char) 0xb9, (char) 0x83, (char) 0xd5, (char) 0xd5, (char) 0x55, (char) 0x35, (char) 0x93, (char) 0xc9, (char) 0xb4,
	(char) 0xb1, (char) 0xd7, (char) 0x3c, (char) 0xda, (char) 0xec, (char) 0x13, (char) 0x89, (char) 0x34, (char) 0x55, (char) 0xc0, (char) 0xff, (char) 0x18,
	(char) 0x8, (char) 0x1f, (char) 0x7b, (char) 0xfa, (char) 0x89, (char) 0x7e, (char) 0xbd, (char) 0xf1, (char) 0x24, (char) 0x2, (char) 0xc0, (char) 0xe7,
	(char) 0xf3, (char) 0xf9, (char) 0x2c, (char) 0xc7, (char) 0x8f, (char) 0x1f, (char) 0x27, (char) 0x9f, (char) 0x7d, (char) 0xf6, (char) 0x19, (char) 0xa6,
	(char) 0xa6, (char) 0xa6, (char) 0x6, (char) 0x56, (char) 0x20, (char) 0xe9, (char) 0xc4, (char) 0xbf, (char) 0x79, (char) 0xf3, (char) 0x26, (char) 0x1e,
	(char) 0x3c, (char) 0x78, (char) 0x80, (char) 0x77, (char) 0xef, (char) 0xde, (char) 0xc9, (char) 0xb2, (char) 0x2c, (char) 0x97, (char) 0x34, (char) 0x57,
	(char) 0x54, (char) 0xaf, (char) 0x43, (char) 0x30, (char) 0x3b, (char) 0x83, (char) 0x86, (char) 0xe8, (char) 0x18, (char) 0x89, (char) 0x4f, (char) 0x77,
	(char) 0x19, (char) 0x87, (char) 0x0, (char) 0x44, (char) 0x78, (char) 0x9e, (char) 0x77, (char) 0x4c, (char) 0x4f, (char) 0x4f, (char) 0x33, (char) 0x67,
	(char) 0xce, (char) 0x9c, (char) 0xc1, (char) 0xf2, (char) 0xf2, (char) 0x32, (char) 0xbc, (char) 0x5e, (char) 0x6f, (char) 0x5f, (char) 0xb1, (char) 0x5f,
	(char) 0xad, (char) 0x56, (char) 0xb1, (char) 0xb6, (char) 0xb6, (char) 0x86, (char) 0xef, (char) 0xbf, (char) 0xff, (char) 0x1e, (char) 0xb7, (char) 0x6e,
	(char) 0xdd, (char) 0xc2, (char) 0xab, (char) 0x57, (char) 0xaf, (char) 0x94, (char) 0x6a, (char) 0xb5, (char) 0x5a, (char) 0xc1, (char) 0x5e, (char) 0xaf,
	(char) 0x41, (char) 0x3, (char) 0xfd, (char) 0x8b, (char) 0x50, (char) 0x4c, (char) 0x0, (char) 0xc, (char) 0x9, (char) 0xf1, (char) 0x75, (char) 0xbd,
	(char) 0x6f, (char) 0x45, (char) 0xb7, (char) 0xf6, (char) 0x70, (char) 0x2, (char) 0x80, (char) 0x18, (char) 0x8d, (char) 0x46, (char) 0xb9, (char) 0xd3,
	(char) 0xa7, (char) 0x4f, (char) 0xe3, (char) 0xdc, (char) 0xb9, (char) 0x73, (char) 0x98, (char) 0x9c, (char) 0x9c, (char) 0xfc, (char) 0x80, (char) 0xfb,
	(char) 0x55, (char) 0x55, (char) 0x45, (char) 0xb1, (char) 0x58, (char) 0xc4, (char) 0xda, (char) 0xda, (char) 0x1a, (char) 0x7e, (char) 0xf8, (char) 0xe1,
	(char) 0x7, (char) 0xdc, (char) 0xbc, (char) 0x79, (char) 0x13, (char) 0xcf, (char) 0x9f, (char) 0x3f, (char) 0x57, (char) 0xf2, (char) 0xf9, (char) 0x7c,
	(char) 0x55, (char) 0x23, (char) 0xfe, (char) 0x16, (char) 0x15, (char) 0x87, (char) 0x90, (char) 0x30, (char) 0xe4, (char) 0x1d, (char) 0xc2, (char) 0xdc,
	(char) 0x27, (char) 0x46, (char) 0xfc, (char) 0x7e, (char) 0xfd, (char) 0x86, (char) 0x5e, (char) 0x8d, (char) 0xf8, (char) 0x61, (char) 0x51, (char) 0x14,
	(char) 0xad, (char) 0x4b, (char) 0x4b, (char) 0x4b, (char) 0xe4, (char) 0xd2, (char) 0xa5, (char) 0x4b, (char) 0x38, (char) 0x79, (char) 0xf2, (char) 0xe4,
	(char) 0x7, (char) 0xba, (char) 0x5f, (char) 0x96, (char) 0x65, (char) 0x64, (char) 0x32, (char) 0x19, (char) 0xac, (char) 0xac, (char) 0xac, (char) 0xe0,
	(char) 0xe6, (char) 0xcd, (char) 0x9b, (char) 0xb8, (char) 0x7d, (char) 0xfb, (char) 0x36, (char) 0xd6, (char) 0xd6, (char) 0xd6, (char) 0x94, (char) 0x5c,
	(char) 0x2e, (char) 0x57, (char) 0xd3, (char) 0x88, (char) 0xff, (char) 0x4e, (char) 0x13, (char) 0xfd, (char) 0xcd, (char) 0x23, (char) 0x46, (char) 0x21,
	(char) 0x4d, (char) 0x0, (char) 0xfc, (char) 0x4a, (char) 0x9c, (char) 0xaf, (char) 0x13, (char) 0xdf, (char) 0x5, (char) 0x20, (char) 0x6, (char) 0x60,
	(char) 0xc2, (char) 0x6e, (char) 0xb7, (char) 0x3b, (char) 0x16, (char) 0x16, (char) 0x16, (char) 0x98, (char) 0xcb, (char) 0x97, (char) 0x2f, (char) 0xe3,
	(char) 0xc2, (char) 0x85, (char) 0xb, (char) 0x1f, (char) 0x34, (char) 0x82, (char) 0xe8, (char) 0xf5, (char) 0x86, (char) 0x8f, (char) 0x1e, (char) 0x3d,
	(char) 0xc2, (char) 0xad, (char) 0x5b, (char) 0xb7, (char) 0xf0, (char) 0xe0, (char) 0xc1, (char) 0x3, (char) 0x6c, (char) 0x6c, (char) 0x6c, (char) 0xc8,
	(char) 0xa5, (char) 0x52, (char) 0x49, (char) 0xe7, (char) 0xfc, (char) 0x4, (char) 0xf6, (char) 0xaa, (char) 0x8f, (char) 0x87, (char) 0x5e, (char) 0xf7,
	(char) 0x7f, (char) 0x2a, (char) 0x0, (char) 0x18, (char) 0x44, (char) 0x7c, (char) 0xbb, (char) 0x46, (char) 0xfc, (char) 0x9, (char) 0x0, (char) 0x93,
	(char) 0x3c, (char) 0xcf, (char) 0x7b, (char) 0x67, (char) 0x66, (char) 0x66, (char) 0xd8, (char) 0xcf, (char) 0x3f, (char) 0xff, (char) 0x1c, (char) 0x5f,
	(char) 0x7c, (char) 0xf1, (char) 0x5, (char) 0xe6, (char) 0xe6, (char) 0xe6, (char) 0x7a, (char) 0x99, (char) 0x3f, (char) 0x5d, (char) 0xe4, (char) 0x6f,
	(char) 0x6c, (char) 0x6c, (char) 0xe0, (char) 0xfe, (char) 0xfd, (char) 0xfb, (char) 0xb8, (char) 0x7d, (char) 0xfb, (char) 0x36, (char) 0x9e, (char) 0x3e,
	(char) 0x7d, (char) 0xaa, (char) 0x6e, (char) 0x6e, (char) 0x6e, (char) 0xca, (char) 0x8d, (char) 0x46, (char) 0xa3, (char) 0x4c, (char) 0x71, (char) 0x3e,
	(char) 0xdd, (char) 0x77, (char) 0xd0, (char) 0x86, (char) 0x39, (char) 0x21, (char) 0x64, (char) 0x68, (char) 0x88, (char) 0xcf, (char) 0xe, (char) 0xe0,
	(char) 0xfc, (char) 0x38, (char) 0x80, (char) 0x69, (char) 0x96, (char) 0x65, (char) 0xfd, (char) 0x53, (char) 0x53, (char) 0x53, (char) 0xdc, (char) 0x85,
	(char) 0xb, (char) 0x17, (char) 0xc8, (char) 0x1f, (char) 0xff, (char) 0xf8, (char) 0xc7, (char) 0x5e, (char) 0xbf, (char) 0x21, (char) 0x0, (char) 0x48,
	(char) 0x92, (char) 0x84, (char) 0x9d, (char) 0x9d, (char) 0x1d, (char) 0xac, (char) 0xac, (char) 0xac, (char) 0xe0, (char) 0xce, (char) 0x9d, (char) 0x3b,
	(char) 0xb8, (char) 0x7f, (char) 0xff, (char) 0x3e, (char) 0xd6, (char) 0xd7, (char) 0xd7, (char) 0xd5, (char) 0x54, (char) 0x2a, (char) 0xd5, (char) 0x96,
	(char) 0x65, (char) 0xb9, (char) 0x40, (char) 0xe9, (char) 0xfc, (char) 0x3c, (char) 0xf6, (char) 0xfa, (char) 0xe, (char) 0x86, (char) 0xda, (char) 0xed,
	(char) 0xfb, (char) 0x54, (char) 0x0, (char) 0x40, (char) 0x47, (char) 0xb, (char) 0x75, (char) 0x3f, (char) 0xdf, (char) 0x8a, (char) 0xbd, (char) 0x3a,
	(char) 0xfd, (char) 0x9, (char) 0x0, (char) 0x53, (char) 0x2c, (char) 0xcb, (char) 0x6, (char) 0xa6, (char) 0xa6, (char) 0xa6, (char) 0xf8, (char) 0xf3,
	(char) 0xe7, (char) 0xcf, (char) 0x93, (char) 0x3f, (char) 0xff, (char) 0xf9, (char) 0xcf, (char) 0x38, (char) 0x7b, (char) 0xf6, (char) 0x6c, (char) 0x2f,
	(char) 0xe6, (char) 0x5f, (char) 0xad, (char) 0x56, (char) 0x91, (char) 0x48, (char) 0x24, (char) 0xf0, (char) 0xf3, (char) 0xcf, (char) 0x3f, (char) 0xe3,
	(char) 0xc7, (char) 0x1f, (char) 0x7f, (char) 0xc4, (char) 0xe3, (char) 0xc7, (char) 0x8f, (char) 0xf1, (char) 0xf6, (char) 0xed, (char) 0x5b, (char) 0xb9,
	(char) 0x54, (char) 0x2a, (char) 0x35, (char) 0xb0, (char) 0xd7, (char) 0x61, (char) 0xac, (char) 0x8f, (char) 0x85, (char) 0xa1, (char) 0x3b, (char) 0x8d,
	(char) 0xe4, (char) 0x51, (char) 0x10, (char) 0xfd, (char) 0xe3, (char) 0xa, (char) 0x0, (char) 0x7a, (char) 0x94, (char) 0x1c, (char) 0x9d, (char) 0xd9,
	(char) 0xa3, (char) 0xd, (char) 0xbe, (char) 0x38, (char) 0x80, (char) 0x38, (char) 0xcb, (char) 0xb2, (char) 0x3e, (char) 0x9d, (char) 0xf8, (char) 0x7f,
	(char) 0xfd, (char) 0xeb, (char) 0x5f, (char) 0x71, (char) 0xf1, (char) 0xe2, (char) 0xc5, (char) 0x5e, (char) 0xc4, (char) 0x2f, (char) 0x9f, (char) 0xcf,
	(char) 0x63, (char) 0x7d, (char) 0x7d, (char) 0x1d, (char) 0x77, (char) 0xee, (char) 0xdc, (char) 0xc1, (char) 0xed, (char) 0xdb, (char) 0xb7, (char) 0xb1,
	(char) 0xba, (char) 0xba, (char) 0xaa, (char) 0x6e, (char) 0x6f, (char) 0x6f, (char) 0x77, (char) 0xda, (char) 0xed, (char) 0x76, (char) 0x45, (char) 0x23,
	(char) 0xfa, (char) 0x76, (char) 0x1f, (char) 0x91, (char) 0x2f, (char) 0x8d, (char) 0x82, (char) 0xd1, (char) 0x37, (char) 0xe8, (char) 0xb, (char) 0x1b,
	(char) 0x57, (char) 0x4b, (char) 0x9f, (char) 0x1e, (char) 0x2d, (char) 0xe3, (char) 0x47, (char) 0xb7, (char) 0xcd, (char) 0x3c, (char) 0x26, (char) 0x8,
	(char) 0x82, (char) 0x47, (char) 0x17, (char) 0xfb, (char) 0xd7, (char) 0xaf, (char) 0x5f, (char) 0xc7, (char) 0xa5, (char) 0x4b, (char) 0x97, (char) 0x7a,
	(char) 0x1, (char) 0x9f, (char) 0x74, (char) 0x3a, (char) 0x8d, (char) 0xa7, (char) 0x4f, (char) 0x9f, (char) 0xe2, (char) 0x9f, (char) 0xff, (char) 0xfc,
	(char) 0x27, (char) 0x7e, (char) 0xfa, (char) 0xe9, (char) 0x27, (char) 0xbc, (char) 0x7c, (char) 0xf9, (char) 0x52, (char) 0xc9, (char) 0x64, (char) 0x32,
	(char) 0x2d, (char) 0x55, (char) 0x55, (char) 0xf3, (char) 0x5a, (char) 0x80, (char) 0x27, (char) 0x89, (char) 0x6e, (char) 0xa7, (char) 0x51, (char) 0x3,
	(char) 0x1f, (char) 0x36, (char) 0x9c, (char) 0x8c, (char) 0x14, (char) 0xf1, (char) 0xc7, (char) 0x9, (char) 0x0, (char) 0x7, (char) 0xf9, (char) 0xf8,
	(char) 0xe, (char) 0x74, (char) 0x47, (char) 0xcb, (char) 0x4c, (char) 0x2, (char) 0x88, (char) 0x38, (char) 0x9d, (char) 0x4e, (char) 0xe7, (char) 0xdc,
	(char) 0xdc, (char) 0x1c, (char) 0x73, (char) 0xe1, (char) 0xc2, (char) 0x5, (char) 0xf2, (char) 0xa7, (char) 0x3f, (char) 0xfd, (char) 0x9, (char) 0xe7,
	(char) 0xcf, (char) 0x9f, (char) 0x47, (char) 0x3c, (char) 0x1e, (char) 0x7, (char) 0xc3, (char) 0x30, (char) 0xd8, (char) 0xd9, (char) 0xd9, (char) 0xc1,
	(char) 0xa3, (char) 0x47, (char) 0x8f, (char) 0x70, (char) 0xe3, (char) 0xc6, (char) 0xd, (char) 0xdc, (char) 0xbb, (char) 0x77, (char) 0xf, (char) 0x1b,
	(char) 0x1b, (char) 0x1b, (char) 0x72, (char) 0xa5, (char) 0x52, (char) 0xa9, (char) 0xa3, (char) 0x5b, (char) 0x83, (char) 0xa0, (char) 0x7, (char) 0x78,
	(char) 0x6a, (char) 0xe8, (char) 0xdf, (char) 0x63, (char) 0x38, (char) 0x92, (char) 0xa3, (char) 0x62, (char) 0xc9, (char) 0x98, (char) 0x12, (char) 0xdf,
	(char) 0xe8, (char) 0xe6, (char) 0x4d, (char) 0x2, (char) 0x8, (char) 0xfa, (char) 0xfd, (char) 0x7e, (char) 0xdb, (char) 0xb1, (char) 0x63, (char) 0xc7,
	(char) 0x98, (char) 0xcb, (char) 0x97, (char) 0x2f, (char) 0xe3, (char) 0xea, (char) 0xd5, (char) 0xab, (char) 0x38, (char) 0x7d, (char) 0xfa, (char) 0x34,
	(char) 0xc2, (char) 0xe1, (char) 0x30, (char) 0x18, (char) 0x86, (char) 0x41, (char) 0x32, (char) 0x99, (char) 0xc4, (char) 0xc3, (char) 0x87, (char) 0xf,
	(char) 0xf1, (char) 0xed, (char) 0xb7, (char) 0xdf, (char) 0xe2, (char) 0xde, (char) 0xbd, (char) 0x7b, (char) 0xea, (char) 0xdb, (char) 0xb7, (char) 0x6f,
	(char) 0x75, (char) 0x2b, (char) 0x7f, (char) 0x7, (char) 0xdd, (char) 0xe9, (char) 0x5f, (char) 0x59, (char) 0xec, (char) 0x9f, (char) 0x29, (char) 0x40,
	(char) 0x1b, (char) 0x7b, (char) 0xa, (char) 0x46, (char) 0x74, (char) 0x58, (char) 0x34, (char) 0x37, (char) 0x66, (char) 0xc4, (char) 0xa7, (char) 0xf5,
	(char) 0xbd, (char) 0x5b, (char) 0xd3, (char) 0xf7, (char) 0x53, (char) 0x2c, (char) 0xcb, (char) 0xfa, (char) 0x23, (char) 0x91, (char) 0x88, (char) 0x70,
	(char) 0xf2, (char) 0xe4, (char) 0x49, (char) 0xf2, (char) 0xfb, (char) 0xdf, (char) 0xff, (char) 0x1e, (char) 0x5f, (char) 0x7d, (char) 0xf5, (char) 0x15,
	(char) 0x96, (char) 0x96, (char) 0x96, (char) 0x7a, (char) 0x6d, (char) 0xe6, (char) 0xbb, (char) 0xbb, (char) 0xbb, (char) 0x78, (char) 0xf4, (char) 0xe8,
	(char) 0x11, (char) 0xbe, (char) 0xfd, (char) 0xf6, (char) 0x5b, (char) 0xdc, (char) 0xbd, (char) 0x7b, (char) 0x57, (char) 0x7d, (char) 0xf3, (char) 0xe6,
	(char) 0x4d, (char) 0xa7, (char) 0xdd, (char) 0x6e, (char) 0x17, (char) 0x35, (char) 0xc2, (char) 0x6f, (char) 0x51, (char) 0x22, (char) 0xbf, (char) 0x39,
	(char) 0xea, (char) 0x22, (char) 0x7f, (char) 0x1c, (char) 0x8d, (char) 0xc0, (char) 0x41, (char) 0xd1, (char) 0xbd, (char) 0x69, (char) 0x0, (char) 0x93,
	(char) 0x16, (char) 0x8b, (char) 0x45, (char) 0x9c, (char) 0x9c, (char) 0x9c, (char) 0xe4, (char) 0x4f, (char) 0x9f, (char) 0x3e, (char) 0x4d, (char) 0xae,
	(char) 0x5e, (char) 0xbd, (char) 0x8a, (char) 0xdf, (char) 0xfd, (char) 0xee, (char) 0x77, (char) 0x98, (char) 0x9f, (char) 0x9f, (char) 0xef, (char) 0x4d,
	(char) 0x13, (char) 0x2b, (char) 0x14, (char) 0xa, (char) 0x58, (char) 0x59, (char) 0x59, (char) 0xc1, (char) 0x3f, (char) 0xfe, (char) 0xf1, (char) 0xf,
	(char) 0x9d, (char) 0xf3, (char) 0x3b, (char) 0xed, (char) 0x76, (char) 0xbb, (char) 0x80, (char) 0xee, (char) 0x34, (char) 0x11, (char) 0x3d, (char) 0xac,
	(char) 0x4b, (char) 0xbb, (char) 0x78, (char) 0x23, (char) 0x2d, (char) 0xf2, (char) 0xc7, (char) 0x9, (char) 0x0, (char) 0x83, (char) 0xc4, (char) 0xbe,
	(char) 0x17, (char) 0xc0, (char) 0xc, (char) 0x80, (char) 0x29, (char) 0x9b, (char) 0xcd, (char) 0xe6, (char) 0x9d, (char) 0x99, (char) 0x99, (char) 0xe1,
	(char) 0xce, (char) 0x9f, (char) 0x3f, (char) 0x4f, (char) 0xbe, (char) 0xf9, (char) 0xe6, (char) 0x1b, (char) 0x5c, (char) 0xbc, (char) 0x78, (char) 0x11,
	(char) 0x53, (char) 0x53, (char) 0x53, (char) 0xb0, (char) 0x5a, (char) 0xad, (char) 0x0, (char) 0xf6, (char) 0x86, (char) 0x49, (char) 0xdc, (char) 0xba,
	(char) 0x75, (char) 0xb, (char) 0xff, (char) 0xfe, (char) 0xf7, (char) 0xbf, (char) 0xf1, (char) 0xe6, (char) 0xcd, (char) 0x1b, (char) 0xb9, (char) 0xd5,
	(char) 0x6a, (char) 0x15, (char) 0x35, (char) 0xe2, (char) 0xbf, (char) 0x1f, (char) 0x40, (char) 0xfc, (char) 0x91, (char) 0x16, (char) 0xf9, (char) 0xe3,
	(char) 0x2, (char) 0x80, (char) 0x41, (char) 0xa3, (char) 0xe4, (char) 0x74, (char) 0xce, (char) 0x9f, (char) 0xb6, (char) 0xdb, (char) 0xed, (char) 0xde,
	(char) 0x85, (char) 0x85, (char) 0x5, (char) 0xf6, (char) 0xf3, (char) 0xcf, (char) 0x3f, (char) 0x27, (char) 0xd7, (char) 0xaf, (char) 0x5f, (char) 0xc7,
	(char) 0x6f, (char) 0x7f, (char) 0xfb, (char) 0x5b, (char) 0xc4, (char) 0x62, (char) 0xb1, (char) 0xde, (char) 0xb4, (char) 0x2f, (char) 0x7d, (char) 0x94,
	(char) 0xcc, (char) 0xcf, (char) 0x3f, (char) 0xff, (char) 0x8c, (char) 0x7b, (char) 0xf7, (char) 0xee, (char) 0xe1, (char) 0xf5, (char) 0xeb, (char) 0xd7,
	(char) 0x4a, (char) 0xb3, (char) 0xd9, (char) 0xd4, (char) 0xc3, (char) 0xba, (char) 0xdb, (char) 0xd8, (char) 0x9b, (char) 0x8, (char) 0x3e, (char) 0x92,
	(char) 0xfe, (char) 0xfd, (char) 0xa7, (char) 0x0, (char) 0x0, (char) 0x3a, (char) 0xc8, (char) 0x23, (char) 0x60, (char) 0x2f, (char) 0xb4, (char) 0x3b,
	(char) 0xe5, (char) 0x70, (char) 0x38, (char) 0xbc, (char) 0xb, (char) 0xb, (char) 0xb, (char) 0xec, (char) 0x95, (char) 0x2b, (char) 0x57, (char) 0xc8,
	(char) 0x5f, (char) 0xfe, (char) 0xf2, (char) 0x17, (char) 0x9c, (char) 0x3d, (char) 0x7b, (char) 0x16, (char) 0xa1, (char) 0x50, (char) 0x68, (char) 0x5f,
	(char) 0x66, (char) 0xaf, (char) 0x5a, (char) 0xad, (char) 0xe2, (char) 0xc5, (char) 0x8b, (char) 0x17, (char) 0x78, (char) 0xf8, (char) 0xf0, (char) 0x21,
	(char) 0xd6, (char) 0xd7, (char) 0xd7, (char) 0x55, (char) 0x2d, (char) 0xc0, (char) 0xb3, (char) 0x4b, (char) 0x11, (char) 0xdf, (char) 0xe8, (char) 0xe6,
	(char) 0x29, (char) 0xe3, (char) 0x46, (char) 0xfc, (char) 0x51, (char) 0x5, (char) 0x80, (char) 0x91, (char) 0xfb, (char) 0xe9, (char) 0x62, (char) 0x8e,
	(char) 0x49, (char) 0x41, (char) 0x10, (char) 0xc4, (char) 0xd9, (char) 0xd9, (char) 0x59, (char) 0xf6, (char) 0xf2, (char) 0xe5, (char) 0xcb, (char) 0xe4,
	(char) 0x6f, (char) 0x7f, (char) 0xfb, (char) 0x1b, (char) 0xce, (char) 0x9e, (char) 0x3d, (char) 0xbb, (char) 0x6f, (char) 0xe4, (char) 0x2b, (char) 0xcd,
	(char) 0xfd, (char) 0xfa, (char) 0xe8, (char) 0xd8, (char) 0xdd, (char) 0xdd, (char) 0xdd, (char) 0x8e, (char) 0x46, (char) 0x74, (char) 0xdd, (char) 0xc7,
	(char) 0x37, (char) 0xba, (char) 0x79, (char) 0x63, (char) 0x49, (char) 0xfc, (char) 0x51, (char) 0x7, (char) 0x0, (char) 0x4b, (char) 0x1, (char) 0xc0,
	(char) 0x7, (char) 0x20, (char) 0xce, (char) 0x30, (char) 0x8c, (char) 0x6f, (char) 0x72, (char) 0x72, (char) 0x92, (char) 0x3b, (char) 0x7f, (char) 0xfe,
	(char) 0x3c, (char) 0xb9, (char) 0x76, (char) 0xed, (char) 0x5a, (char) 0x2f, (char) 0xb4, (char) 0x6b, (char) 0xac, (char) 0xe7, (char) 0x6b, (char) 0xb5,
	(char) 0x5a, (char) 0x78, (char) 0xfd, (char) 0xfa, (char) 0x35, (char) 0xd6, (char) 0xd7, (char) 0xd7, (char) 0xe9, (char) 0x41, (char) 0x52, (char) 0x19,
	(char) 0xec, (char) 0xa5, (char) 0x72, (char) 0x3f, (char) 0x9, (char) 0xe2, (char) 0x3, (char) 0xc3, (char) 0x3b, (char) 0x20, (char) 0xe2, (char) 0x63,
	(char) 0x74, (char) 0xbf, (char) 0xd, (char) 0xda, (char) 0xc8, (char) 0xf8, (char) 0x60, (char) 0x30, (char) 0x28, (char) 0x2c, (char) 0x2f, (char) 0x2f,
	(char) 0x93, (char) 0xab, (char) 0x57, (char) 0xaf, (char) 0xf6, (char) 0x38, (char) 0xbf, (char) 0x5f, (char) 0x31, (char) 0x67, (char) 0xb9, (char) 0x5c,
	(char) 0xd6, (char) 0xe7, (char) 0x8, (char) 0x21, (char) 0x97, (char) 0xcb, (char) 0xc9, (char) 0xe8, (char) 0xd6, (char) 0xef, (char) 0x67, (char) 0xb0,
	(char) 0x3f, (char) 0x95, (char) 0x3b, (char) 0xf6, (char) 0xc4, (char) 0x1f, (char) 0x45, (char) 0x0, (char) 0xc0, (char) 0xc0, (char) 0xfd, (char) 0xbc,
	(char) 0x66, (char) 0xf8, (char) 0x5, (char) 0x5, (char) 0x41, (char) 0xb0, (char) 0xcf, (char) 0xce, (char) 0xce, (char) 0x32, (char) 0x97, (char) 0x2e,
	(char) 0x5d, (char) 0xc2, (char) 0xb9, (char) 0x73, (char) 0xe7, (char) 0x7a, (char) 0x43, (char) 0x9e, (char) 0xfb, (char) 0x9d, (char) 0x4c, (char) 0x26,
	(char) 0x83, (char) 0x9d, (char) 0x9d, (char) 0x1d, (char) 0xa4, (char) 0x52, (char) 0x29, (char) 0x55, (char) 0xea, (char) 0xb6, (char) 0xf1, (char) 0x56,
	(char) 0xd0, (char) 0x4d, (char) 0xea, (char) 0xb4, (char) 0x3f, (char) 0x25, (char) 0xe2, (char) 0x8f, (char) 0x8b, (char) 0x4, (char) 0x8, (char) 0x0,
	(char) 0xf0, (char) 0x4, (char) 0x2, (char) 0x1, (char) 0x6e, (char) 0x69, (char) 0x69, (char) 0x9, (char) 0x67, (char) 0xce, (char) 0x9c, (char) 0xc1,
	(char) 0xd4, (char) 0xd4, (char) 0xd4, (char) 0x7, (char) 0xb3, (char) 0x7d, (char) 0x69, (char) 0xfd, (char) 0x9f, (char) 0xcb, (char) 0xe5, (char) 0x90,
	(char) 0xcb, (char) 0xe5, (char) 0xf4, (char) 0xd9, (char) 0x7f, (char) 0x3a, (char) 0x0, (char) 0xc6, (char) 0x2a, (char) 0xc0, (char) 0x33, (char) 0x8e,
	(char) 0x0, (char) 0xe8, (char) 0xd7, (char) 0xc4, (char) 0xa9, (char) 0xd7, (char) 0xf3, (char) 0x9, (char) 0x13, (char) 0x13, (char) 0x13, (char) 0xcc,
	(char) 0xe2, (char) 0xe2, (char) 0x22, (char) 0x8e, (char) 0x1d, (char) 0x3b, (char) 0xa6, (char) 0xcf, (char) 0xe7, (char) 0x19, (char) 0x8, (char) 0x80,
	(char) 0x4a, (char) 0xa5, (char) 0xa2, (char) 0x5f, (char) 0xbd, (char) 0x7d, (char) 0xbb, (char) 0x86, (char) 0xf, (char) 0xf7, (char) 0x2, (char) 0x9a,
	(char) 0x0, (char) 0x18, (char) 0xf2, (char) 0xe0, (char) 0xf, (char) 0x87, (char) 0x6e, (char) 0xa2, (char) 0xc7, (char) 0x21, (char) 0x8, (char) 0x2,
	(char) 0x17, (char) 0x8d, (char) 0x46, (char) 0x11, (char) 0x8f, (char) 0xc7, (char) 0x11, (char) 0xe, (char) 0x87, (char) 0xf, (char) 0x6c, (char) 0xe2,
	(char) 0x54, (char) 0x14, (char) 0x5, (char) 0xcd, (char) 0x66, (char) 0xb3, (char) 0x77, (char) 0xb1, (char) 0x37, (char) 0x8b, (char) 0xe0, (char) 0x93,
	(char) 0x21, (char) 0xfa, (char) 0xb8, (char) 0xa8, (char) 0x0, (char) 0xbd, (char) 0x87, (char) 0xdf, (char) 0xe2, (char) 0x74, (char) 0x3a, (char) 0x19,
	(char) 0xbf, (char) 0xdf, (char) 0x8f, (char) 0x40, (char) 0x20, (char) 0x70, (char) 0x20, (char) 0xf7, (char) 0xeb, (char) 0x12, (char) 0x40, (char) 0x9f,
	(char) 0xf7, (char) 0xa3, (char) 0xee, (char) 0xcd, (char) 0x71, (char) 0xf9, (char) 0xa4, (char) 0x88, (char) 0x3e, (char) 0xea, (char) 0x46, (char) 0x20,
	(char) 0x2d, (char) 0x9, (char) 0xac, (char) 0x0, (char) 0x38, (char) 0xa7, (char) 0xd3, (char) 0x9, (char) 0xb7, (char) 0xdb, (char) 0xd, (char) 0x97,
	(char) 0xcb, (char) 0x75, (char) 0x68, (char) 0xf, (char) 0x3f, (char) 0xc3, (char) 0x30, (char) 0xf4, (char) 0x20, (char) 0x27, (char) 0x7a, (char) 0x1c,
	(char) 0x8c, (char) 0x71, (char) 0xad, (char) 0x2c, (char) 0xad, (char) 0x76, (char) 0x4c, (char) 0x0, (char) 0xc, (char) 0xa1, (char) 0x14, (char) 0xe8,
	(char) 0x11, (char) 0x4e, (char) 0x10, (char) 0x4, (char) 0x62, (char) 0xb1, (char) 0x58, (char) 0x8e, (char) 0x34, (char) 0xc1, (char) 0x83, (char) 0x10,
	(char) 0x42, (char) 0xcf, (char) 0xf2, (char) 0xd3, (char) 0x5f, (char) 0xc3, (char) 0x86, (char) 0xfd, (char) 0x6b, (char) 0x66, (char) 0xf, (char) 0xdb,
	(char) 0x31, (char) 0x6c, (char) 0x2, (char) 0x60, (char) 0x98, (char) 0xc, (char) 0xc3, (char) 0x8f, (char) 0x99, (char) 0xe2, (char) 0xc5, (char) 0x30,
	(char) 0x4c, (char) 0x6f, (char) 0x9a, (char) 0xa7, (char) 0x28, (char) 0x8a, (char) 0x44, (char) 0xf3, (char) 0x24, (char) 0xf4, (char) 0x61, (char) 0x13,
	(char) 0xfa, (char) 0xf6, (char) 0xd1, (char) 0x7e, (char) 0x23, (char) 0xde, (char) 0xc7, (char) 0x12, (char) 0x14, (char) 0xa3, (char) 0xa, (char) 0x0,
	(char) 0x7a, (char) 0x98, (char) 0x94, (char) 0x22, (char) 0x49, (char) 0x92, (char) 0x7a, (char) 0xd4, (char) 0x41, (char) 0x8e, (char) 0x0, (char) 0x10,
	(char) 0x89, (char) 0x44, (char) 0xa0, (char) 0x2d, (char) 0x81, (char) 0x20, (char) 0x2c, (char) 0xcb, (char) 0xea, (char) 0x0, (char) 0xf0, (char) 0x60,
	(char) 0xaf, (char) 0x70, (char) 0x54, (char) 0x5f, (char) 0x35, (char) 0xcb, (char) 0x1b, (char) 0xc0, (char) 0xc0, (char) 0x62, (char) 0x88, (char) 0xe7,
	(char) 0xfe, (char) 0x7e, (char) 0x2a, (char) 0x0, (char) 0xa0, (char) 0xf3, (char) 0xf0, (char) 0x2d, (char) 0x0, (char) 0x72, (char) 0xb5, (char) 0x5a,
	(char) 0x45, (char) 0xb5, (char) 0x5a, (char) 0x45, (char) 0xad, (char) 0x56, (char) 0x3b, (char) 0x70, (char) 0xa4, (char) 0xbb, (char) 0x7e, (char) 0x7c,
	(char) 0x3e, (char) 0x1f, (char) 0x16, (char) 0x16, (char) 0x16, (char) 0x30, (char) 0x37, (char) 0x37, (char) 0x87, (char) 0x40, (char) 0x20, (char) 0xc0,
	(char) 0x69, (char) 0xc4, (char) 0x8f, (char) 0x6a, (char) 0x41, (char) 0x25, (char) 0x3b, (char) 0x75, (char) 0x75, (char) 0x30, (char) 0x8, (char) 0x94,
	(char) 0x84, (char) 0x30, (char) 0x82, (char) 0x62, (char) 0xa4, (char) 0x41, (char) 0xc0, (char) 0x8e, (char) 0xd0, (char) 0x7b, (char) 0x1d, (char) 0xb8,
	(char) 0x51, (char) 0x44, (char) 0x55, (char) 0x55, (char) 0x5b, (char) 0x3c, (char) 0x1e, (char) 0x67, (char) 0x66, (char) 0x67, (char) 0x67, (char) 0x31,
	(char) 0x37, (char) 0x37, (char) 0x77, (char) 0xe8, (char) 0x3c, (char) 0x3f, (char) 0x8e, (char) 0xe3, (char) 0x40, (char) 0x8, (char) 0x41, (char) 0xb9,
	(char) 0x5c, (char) 0x46, (char) 0x3a, (char) 0x9d, (char) 0x26, (char) 0xb9, (char) 0x5c, (char) 0x8e, (char) 0x95, (char) 0x24, (char) 0x49, (char) 0x9f,
	(char) 0x37, (char) 0xa4, (char) 0xa7, (char) 0x7c, (char) 0xe9, (char) 0x6c, (char) 0x23, (char) 0x67, (char) 0xb8, (char) 0xc, (char) 0xc6, (char) 0x44,
	(char) 0x5, (char) 0x8c, (char) 0x1a, (char) 0x0, (char) 0x80, (char) 0xf, (char) 0xfb, (char) 0xfa, (char) 0xfd, (char) 0x9d, (char) 0x4e, (char) 0xc7,
	(char) 0x25, (char) 0x8a, (char) 0x22, (char) 0x17, (char) 0x8f, (char) 0xc7, (char) 0x31, (char) 0x33, (char) 0x33, (char) 0xd3, (char) 0x77, (char) 0x91,
	(char) 0x94, (char) 0xd1, (char) 0x10, (char) 0x14, (char) 0x4, (char) 0x1, (char) 0x2c, (char) 0xcb, (char) 0xa2, (char) 0xd1, (char) 0x68, (char) 0xa0,
	(char) 0x58, (char) 0x2c, (char) 0x32, (char) 0x95, (char) 0x4a, (char) 0x85, (char) 0x97, (char) 0x24, (char) 0x49, (char) 0xdf, (char) 0x34, (char) 0xce,
	(char) 0x61, (char) 0x7f, (char) 0x99, (char) 0x99, (char) 0xd1, (char) 0x36, (char) 0x60, (char) 0xc, (char) 0xd2, (char) 0x53, (char) 0x35, (char) 0x1,
	(char) 0xf0, (char) 0xcb, (char) 0x4a, (char) 0x1, (char) 0x5a, (char) 0x17, (char) 0xbb, (char) 0x1, (char) 0x78, (char) 0x58, (char) 0x96, (char) 0xb5,
	(char) 0xf8, (char) 0x7c, (char) 0x3e, (char) 0xa2, (char) 0x2f, (char) 0x6c, (char) 0x18, (char) 0x14, (char) 0xa, (char) 0xd6, (char) 0xf, (char) 0xcf,
	(char) 0xf3, (char) 0xb0, (char) 0xdb, (char) 0xed, (char) 0xb0, (char) 0xdb, (char) 0xed, (char) 0x90, (char) 0x65, (char) 0x19, (char) 0xcd, (char) 0x66,
	(char) 0x93, (char) 0xa9, (char) 0xd7, (char) 0xeb, (char) 0x7c, (char) 0xb3, (char) 0xd9, (char) 0xb4, (char) 0x6b, (char) 0xaf, (char) 0xa9, (char) 0xaf,
	(char) 0xa0, (char) 0xf7, (char) 0xa1, (char) 0x1b, (char) 0x6e, (char) 0x8e, (char) 0xa2, (char) 0x5b, (char) 0x63, (char) 0x18, (char) 0x41, (char) 0x77,
	(char) 0x84, (char) 0x9c, (char) 0xd2, (char) 0x27, (char) 0x80, (char) 0xa4, (char) 0x9a, (char) 0x0, (char) 0xf8, (char) 0xe5, (char) 0x41, (char) 0xc0,
	(char) 0x3, (char) 0xf0, (char) 0xb6, (char) 0xdb, (char) 0x6d, (char) 0xbb, (char) 0xc5, (char) 0x62, (char) 0x61, (char) 0x44, (char) 0x51, (char) 0xd4,
	(char) 0x37, (char) 0x7a, (char) 0x1e, (char) 0x18, (char) 0x13, (char) 0xd0, (char) 0xb7, (char) 0x7d, (char) 0xb9, (char) 0xdd, (char) 0x6e, (char) 0x88,
	(char) 0xa2, (char) 0x8, (char) 0xab, (char) 0xd5, (char) 0xaa, (char) 0x2f, (char) 0x80, (char) 0x64, (char) 0xdb, (char) 0xed, (char) 0xb6, (char) 0xd0,
	(char) 0x6e, (char) 0xb7, (char) 0x1d, (char) 0xe8, (char) 0x16, (char) 0x99, (char) 0x78, (char) 0x35, (char) 0x10, (char) 0x88, (char) 0xd4, (char) 0xb5,
	(char) 0x6a, (char) 0x84, (char) 0x2f, (char) 0x61, (char) 0x7f, (char) 0xf8, (char) 0x78, (char) 0xe4, (char) 0xa4, (char) 0xc1, (char) 0xa8, (char) 0x4a,
	(char) 0x0, (char) 0xda, (char) 0x16, (char) 0x50, (char) 0x1, (char) 0xd8, (char) 0x24, (char) 0x49, (char) 0x72, (char) 0xc9, (char) 0xb2, (char) 0x6c,
	(char) 0x51, (char) 0x55, (char) 0x95, (char) 0x88, (char) 0xa2, (char) 0x8, (char) 0xbf, (char) 0xdf, (char) 0xf, (char) 0x87, (char) 0xc3, (char) 0x71,
	(char) 0xa8, (char) 0x2a, (char) 0xb0, (char) 0xdb, (char) 0xed, (char) 0x10, (char) 0x45, (char) 0x11, (char) 0xa1, (char) 0x50, (char) 0x8, (char) 0x7e,
	(char) 0xbf, (char) 0x1f, (char) 0xa2, (char) 0x28, (char) 0x92, (char) 0x40, (char) 0x20, (char) 0xc0, (char) 0xf8, (char) 0xfd, (char) 0x7e, (char) 0xd6,
	(char) 0xeb, (char) 0xf5, (char) 0x72, (char) 0xa2, (char) 0x28, (char) 0x5a, (char) 0x42, (char) 0xa1, (char) 0x90, (char) 0x25, (char) 0x1e, (char) 0x8f,
	(char) 0x5b, (char) 0xdc, (char) 0x6e, (char) 0xb7, (char) 0x85, (char) 0xe3, (char) 0x38, (char) 0xbe, (char) 0xdd, (char) 0x6e, (char) 0x5b, (char) 0xb5,
	(char) 0xb5, (char) 0x70, (char) 0xfa, (char) 0x8e, (char) 0x60, (char) 0x23, (char) 0x8, (char) 0x4c, (char) 0x0, (char) 0xfc, (char) 0x42, (char) 0x20,
	(char) 0xa0, (char) 0x23, (char) 0x76, (char) 0xb6, (char) 0x7a, (char) 0xbd, (char) 0xee, (char) 0x90, (char) 0x24, (char) 0x89, (char) 0x6d, (char) 0x36,
	(char) 0x9b, (char) 0xbd, (char) 0xf1, (char) 0xae, (char) 0xe, (char) 0x87, (char) 0xe3, (char) 0x50, (char) 0x49, (char) 0x60, (char) 0xb5, (char) 0x5a,
	(char) 0xe1, (char) 0xf7, (char) 0xfb, (char) 0x11, (char) 0x8b, (char) 0xc5, (char) 0x10, (char) 0x8f, (char) 0xc7, (char) 0x7b, (char) 0x5b, (char) 0xc4,
	(char) 0x67, (char) 0x67, (char) 0x67, (char) 0xc9, (char) 0xb1, (char) 0x63, (char) 0xc7, (char) 0xc8, (char) 0xd2, (char) 0xd2, (char) 0x12, (char) 0x59,
	(char) 0x5e, (char) 0x5e, (char) 0x26, (char) 0xa2, (char) 0x28, (char) 0xa2, (char) 0xd3, (char) 0xe9, (char) 0x90, (char) 0x42, (char) 0xa1, (char) 0x40,
	(char) 0x5a, (char) 0xad, (char) 0x96, (char) 0x82, (char) 0x6e, (char) 0x16, (char) 0x31, (char) 0x8f, (char) 0x11, (char) 0x4e, (char) 0x1f, (char) 0x8f,
	(char) 0x62, (char) 0x45, (char) 0x90, (char) 0x71, (char) 0x70, (char) 0x64, (char) 0xb, (char) 0xdd, (char) 0x62, (char) 0xe, (char) 0x47, (char) 0xa7,
	(char) 0xd3, (char) 0xb1, (char) 0x6e, (char) 0x6e, (char) 0x6e, (char) 0x6, (char) 0x59, (char) 0x96, (char) 0xe5, (char) 0x64, (char) 0x59, (char) 0x26,
	(char) 0xe5, (char) 0x72, (char) 0x19, (char) 0xe7, (char) 0xce, (char) 0x9d, (char) 0xc3, (char) 0xf4, (char) 0xf4, (char) 0x34, (char) 0x9c, (char) 0x4e,
	(char) 0xe7, (char) 0x81, (char) 0xd2, (char) 0xc0, (char) 0x62, (char) 0xb1, (char) 0x20, (char) 0x1a, (char) 0x8d, (char) 0x22, (char) 0x14, (char) 0xa,
	(char) 0xe1, (char) 0xe4, (char) 0xc9, (char) 0x93, (char) 0xfa, (char) 0xbc, (char) 0x5f, (char) 0x34, (char) 0x9b, (char) 0x4d, (char) 0x34, (char) 0x1a,
	(char) 0xd, (char) 0xe4, (char) 0xf3, (char) 0x79, (char) 0xb4, (char) 0x5a, (char) 0x2d, (char) 0xb0, (char) 0x2c, (char) 0xb, (char) 0x55, (char) 0x55,
	(char) 0xe9, (char) 0x72, (char) 0x34, (char) 0xd3, (char) 0xd, (char) 0xfc, (char) 0x15, (char) 0x3d, (char) 0x2, (char) 0xfa, (char) 0x51, (char) 0x2,
	(char) 0x80, (char) 0x4e, (char) 0xa7, (char) 0x63, (char) 0x29, (char) 0x97, (char) 0xcb, (char) 0x42, (char) 0xa9, (char) 0x54, (char) 0x62, (char) 0xb2,
	(char) 0xd9, (char) 0x2c, (char) 0x29, (char) 0x97, (char) 0xcb, (char) 0xa8, (char) 0xd7, (char) 0xeb, (char) 0x50, (char) 0x14, (char) 0x5, (char) 0xfa,
	(char) 0xd8, (char) 0xf7, (char) 0x83, (char) 0xa2, (char) 0x86, (char) 0xc, (char) 0xc3, (char) 0x40, (char) 0xf, (char) 0x2b, (char) 0x33, (char) 0xc,
	(char) 0x83, (char) 0x6a, (char) 0xb5, (char) 0x8a, (char) 0xed, (char) 0xed, (char) 0x6d, (char) 0xac, (char) 0xad, (char) 0xad, (char) 0x61, (char) 0x65,
	(char) 0x65, (char) 0x5, (char) 0x9b, (char) 0x9b, (char) 0x9b, (char) 0x6a, (char) 0x3e, (char) 0x9f, (char) 0xef, (char) 0x74, (char) 0x3a, (char) 0x9d,
	(char) 0x2, (char) 0xba, (char) 0xad, (char) 0x62, (char) 0x39, (char) 0xec, (char) 0x55, (char) 0xd, (char) 0x8f, (char) 0x9c, (char) 0xa, (char) 0x18,
	(char) 0xd5, (char) 0xaa, (char) 0x60, (char) 0x7a, (char) 0x72, (char) 0x28, (char) 0x41, (char) 0xb7, (char) 0x8e, (char) 0x8f, (char) 0xa0, (char) 0x5b,
	(char) 0xcb, (char) 0xaf, (char) 0xb6, (char) 0x5a, (char) 0xad, (char) 0xce, (char) 0xdb, (char) 0xb7, (char) 0x6f, (char) 0xfd, (char) 0xe5, (char) 0x72,
	(char) 0xd9, (char) 0xba, (char) 0xb3, (char) 0xb3, (char) 0xc3, (char) 0xac, (char) 0xaf, (char) 0xaf, (char) 0xe3, (char) 0xd8, (char) 0xb1, (char) 0x63,
	(char) 0x98, (char) 0x9a, (char) 0x9a, (char) 0x42, (char) 0x24, (char) 0x12, (char) 0x81, (char) 0xcf, (char) 0xe7, (char) 0x83, (char) 0xd3, (char) 0xe9,
	(char) 0x84, (char) 0xd5, (char) 0x6a, (char) 0x5, (char) 0x21, (char) 0x4, (char) 0x8a, (char) 0xa2, (char) 0xa0, (char) 0xd3, (char) 0xe9, (char) 0xa0,
	(char) 0xd5, (char) 0x6a, (char) 0xa1, (char) 0xd1, (char) 0x68, (char) 0xa0, (char) 0x52, (char) 0xa9, (char) 0x20, (char) 0x9f, (char) 0xcf, (char) 0x23,
	(char) 0x93, (char) 0xc9, (char) 0x60, (char) 0x7b, (char) 0x7b, (char) 0x1b, (char) 0x89, (char) 0x44, (char) 0x2, (char) 0x6f, (char) 0xde, (char) 0xbc,
	(char) 0xc1, (char) 0xfb, (char) 0xf7, (char) 0xef, (char) 0x95, (char) 0x4c, (char) 0x26, (char) 0xd3, (char) 0xd6, (char) 0x88, (char) 0x9f, (char) 0x44,
	(char) 0xb7, (char) 0x5d, (char) 0xcc, (char) 0x38, (char) 0x8, (char) 0xc2, (char) 0xec, (char) 0xd, (char) 0xfc, (char) 0x5, (char) 0xdf, (char) 0xbb,
	(char) 0xb1, (char) 0x19, (char) 0xd4, (char) 0xa6, (char) 0xb9, (char) 0x68, (char) 0x51, (char) 0x74, (char) 0x4b, (char) 0xc4, (char) 0x83, (char) 0x1c,
	(char) 0xc7, (char) 0xd9, (char) 0x7d, (char) 0x3e, (char) 0x1f, (char) 0x1f, (char) 0x8d, (char) 0x46, (char) 0xc9, (char) 0xc4, (char) 0xc4, (char) 0x4,
	(char) 0xd1, (char) 0x8d, (char) 0xbd, (char) 0x83, (char) 0x0, (char) 0x50, (char) 0x2e, (char) 0x97, (char) 0x51, (char) 0x28, (char) 0x14, (char) 0x90,
	(char) 0xcb, (char) 0xe5, (char) 0xf4, (char) 0x31, (char) 0xf4, (char) 0x4a, (char) 0xa9, (char) 0x54, (char) 0xea, (char) 0xc8, (char) 0xb2, (char) 0xac,
	(char) 0xaf, (char) 0xa1, (char) 0xd3, (char) 0x7b, (char) 0x7, (char) 0xa, (char) 0xd8, (char) 0xdf, (char) 0x2b, (char) 0xa8, (char) 0x98, (char) 0x0,
	(char) 0xf8, (char) 0xf5, (char) 0x41, (char) 0x20, (char) 0x68, (char) 0x6e, (char) 0x9a, (char) 0xf, (char) 0xdd, (char) 0xae, (char) 0xe0, (char) 0x10,
	(char) 0xba, (char) 0xa1, (char) 0x5e, (char) 0x9b, (char) 0xc5, (char) 0x62, (char) 0xe1, (char) 0x5c, (char) 0x2e, (char) 0x17, (char) 0xeb, (char) 0xf5,
	(char) 0x7a, (char) 0x89, (char) 0xd3, (char) 0xe9, (char) 0x84, (char) 0x20, (char) 0x8, (char) 0x20, (char) 0x84, (char) 0x40, (char) 0x55, (char) 0x55,
	(char) 0x23, (char) 0x0, (char) 0xd4, (char) 0x6a, (char) 0xb5, (char) 0xaa, (char) 0x68, (char) 0xab, (char) 0x67, (char) 0x24, (char) 0xec, (char) 0x4d,
	(char) 0xfd, (char) 0xce, (char) 0xa0, (char) 0x3b, (char) 0x7, (char) 0x28, (char) 0x87, (char) 0xfe, (char) 0xbd, (char) 0x82, (char) 0x66, (char) 0x77,
	(char) 0xf0, (char) 0xaf, (char) 0xc, (char) 0x2, (char) 0xae, (char) 0xf, (char) 0x10, (char) 0xf4, (char) 0x25, (char) 0xce, (char) 0x3e, (char) 0x4d,
	(char) 0x3a, (char) 0x58, (char) 0xf1, (char) 0xe1, (char) 0x2e, (char) 0x5f, (char) 0x5a, (char) 0xad, (char) 0xd0, (char) 0x43, (char) 0xa9, (char) 0x9b,
	(char) 0x9a, (char) 0xa5, (char) 0x5f, (char) 0xd0, (char) 0x6e, (char) 0x5, (char) 0xfb, (char) 0x37, (char) 0x8e, (char) 0xd3, (char) 0x4d, (char) 0x23,
	(char) 0x23, (char) 0xd9, (char) 0x2e, (char) 0x36, (char) 0x4e, (char) 0xf3, (char) 0x1, (char) 0x98, (char) 0x3e, (char) 0x40, (char) 0xd0, (char) 0xc1,
	(char) 0xa0, (char) 0x77, (char) 0xf, (char) 0xe9, (char) 0xc1, (char) 0x1d, (char) 0x87, (char) 0xf6, (char) 0x3c, (char) 0xa7, (char) 0xfd, (char) 0xad,
	(char) 0x71, (char) 0x57, (char) 0x51, (char) 0x13, (char) 0x7b, (char) 0x1b, (char) 0xc6, (char) 0x5b, (char) 0x94, (char) 0x88, (char) 0xa7, (char) 0xaf,
	(char) 0x71, (char) 0x5, (char) 0xad, (char) 0x3a, (char) 0xaa, (char) 0x5f, (char) 0x1c, (char) 0xc6, (char) 0x8, (char) 0x4, (char) 0x46, (char) 0x20,
	(char) 0xe8, (char) 0x60, (char) 0xa0, (char) 0xaf, (char) 0x31, (char) 0xa5, (char) 0x8b, (char) 0x1, (char) 0x52, (char) 0xc0, (char) 0xb8, (char) 0x58,
	(char) 0xba, (char) 0xdf, (char) 0x18, (char) 0xfa, (char) 0x91, (char) 0xaf, (char) 0x23, (char) 0x1c, (char) 0xb7, (char) 0x4a, (char) 0x17, (char) 0xd2,
	(char) 0x47, (char) 0x22, (char) 0xd0, (char) 0x7b, (char) 0x80, (char) 0x58, (char) 0xc3, (char) 0xf3, (char) 0xc4, (char) 0x40, (char) 0x7c, (char) 0x50,
	(char) 0x44, (char) 0xa5, (char) 0x81, (char) 0xd0, (char) 0x6f, (char) 0xc, (char) 0xfd, (char) 0x48, (char) 0x86, (char) 0x7e, (char) 0xc7, (char) 0x1d,
	(char) 0x0, (char) 0x83, (char) 0x80, (char) 0x30, (char) 0xa8, (char) 0xa2, (char) 0xe7, (char) 0xa0, (char) 0x91, (char) 0xf3, (char) 0xca, (char) 0x80,
	(char) 0x9f, (char) 0xc7, (char) 0xaa, (char) 0x90, (char) 0x74, (char) 0xdc, (char) 0x8b, (char) 0x1e, (char) 0x49, (char) 0x9f, (char) 0xcb, (char) 0xa0,
	(char) 0x7f, (char) 0xd1, (char) 0xa7, (char) 0x7a, (char) 0xc0, (char) 0xc5, (char) 0xb8, (char) 0x11, (char) 0x7e, (char) 0xd4, (char) 0x3, (char) 0x41,
	(char) 0xff, (char) 0x2b, (char) 0x30, (char) 0xa0, (char) 0xf, (char) 0x51, (char) 0xf, (char) 0x3, (char) 0x0, (char) 0x4c, (char) 0x0, (char) 0x8c,
	(char) 0xae, (char) 0x51, (char) 0xc8, (char) 0xf4, (char) 0x51, (char) 0x5, (char) 0x83, (char) 0xd6, (char) 0xcd, (char) 0xc8, (char) 0xe3, (char) 0x4c,
	(char) 0xf8, (char) 0x71, (char) 0x6, (char) 0x80, (char) 0x71, (char) 0x5e, (char) 0xa0, (char) 0xd1, (char) 0x1b, (char) 0x60, (char) 0xfb, (char) 0xc4,
	(char) 0x0, (char) 0x94, (char) 0x3e, (char) 0x16, (char) 0x3f, (char) 0xd3, (char) 0x7, (char) 0x4, (char) 0xe6, (char) 0x7c, (char) 0x80, (char) 0x11,
	(char) 0xe2, (char) 0x7a, (char) 0x63, (char) 0x60, (char) 0x88, (char) 0x9e, (char) 0x1d, (char) 0xa8, (char) 0x5f, (char) 0x46, (char) 0x23, (char) 0x7e,
	(char) 0x13, (char) 0xfb, (char) 0x67, (char) 0x1, (char) 0xd1, (char) 0x7e, (char) 0x3f, (char) 0xc1, (char) 0xfe, (char) 0x44, (char) 0x8f, (char) 0x69,
	(char) 0x3, (char) 0x8c, (char) 0x40, (char) 0x40, (char) 0x88, (char) 0x1e, (char) 0x1c, (char) 0xa5, (char) 0x4f, (char) 0x7, (char) 0xd7, (char) 0x4b,
	(char) 0xbb, (char) 0x44, (char) 0x74, (char) 0x73, (char) 0x6, (char) 0x3c, (char) 0xa5, (char) 0x2, (char) 0xf4, (char) 0x7d, (char) 0x84, (char) 0x5,
	(char) 0x74, (char) 0x13, (char) 0x3c, (char) 0x79, (char) 0xed, (char) 0xf7, (char) 0x7e, (char) 0x9b, (char) 0xc9, (char) 0x4c, (char) 0x9, (char) 0x30,
	(char) 0xe4, (char) 0xdc, (char) 0x6f, (char) 0x9c, (char) 0x1a, (char) 0xe6, (char) 0x43, (char) 0x77, (char) 0x58, (char) 0x64, (char) 0xc, (char) 0x80,
	(char) 0x87, (char) 0x10, (char) 0x22, (char) 0xf0, (char) 0x3c, (char) 0xcf, (char) 0xa, (char) 0x82, (char) 0xc0, (char) 0xb0, (char) 0x2c, (char) 0xab,
	(char) 0xd7, (char) 0x3, (char) 0x2a, (char) 0x92, (char) 0x24, (char) 0xc9, (char) 0xe8, (char) 0xe6, (char) 0xd, (char) 0xc2, (char) 0xe8, (char) 0xe,
	(char) 0x87, (char) 0x4c, (char) 0x6a, (char) 0x80, (char) 0x20, (char) 0x3, (char) 0xe2, (char) 0x4, (char) 0x26, (char) 0x0, (char) 0x86, (char) 0x54,
	(char) 0xf4, (char) 0xd3, (char) 0x93, (char) 0x43, (char) 0x42, (char) 0xe8, (char) 0x8e, (char) 0x8c, (char) 0x8b, (char) 0x9, (char) 0x82, (char) 0xe0,
	(char) 0xe, (char) 0x6, (char) 0x83, (char) 0xfc, (char) 0xc4, (char) 0xc4, (char) 0x4, (char) 0x89, (char) 0x44, (char) 0x22, (char) 0xf0, (char) 0x78,
	(char) 0x3c, (char) 0xe0, (char) 0x38, (char) 0xe, (char) 0x92, (char) 0x24, (char) 0xa1, (char) 0x54, (char) 0x2a, (char) 0xb1, (char) 0x3b, (char) 0x3b,
	(char) 0x3b, (char) 0x7c, (char) 0x32, (char) 0x99, (char) 0xb4, (char) 0x64, (char) 0x32, (char) 0x19, (char) 0xbb, (char) 0x56, (char) 0xf, (char) 0x68,
	(char) 0x43, (char) 0x77, (char) 0x9, (char) 0x44, (char) 0xa6, (char) 0x4f, (char) 0x2c, (char) 0x60, (char) 0x6c, (char) 0x54, (char) 0xc1, (char) 0x38,
	(char) 0x49, (char) 0x0, (char) 0x5a, (char) 0xef, (char) 0xb, (char) 0x9a, (char) 0xa8, (char) 0x9f, (char) 0x6, (char) 0x30, (char) 0x29, (char) 0x8a,
	(char) 0xa2, (char) 0x7b, (char) 0x6e, (char) 0x6e, (char) 0x8e, (char) 0xfd, (char) 0xcd, (char) 0x6f, (char) 0x7e, (char) 0x83, (char) 0xe5, (char) 0xe5,
	(char) 0x65, (char) 0xc4, (char) 0x62, (char) 0x31, (char) 0x23, (char) 0x0, (char) 0xb0, (char) 0xb5, (char) 0xb5, (char) 0x85, (char) 0xd5, (char) 0xd5,
	(char) 0x55, (char) 0x66, (char) 0x65, (char) 0x65, (char) 0xc5, (char) 0x92, (char) 0x48, (char) 0x24, (char) 0x7c, (char) 0xc5, (char) 0x62, (char) 0x91,
	(char) 0xa5, (char) 0xd4, (char) 0x3, (char) 0x1d, (char) 0x11, (char) 0x54, (char) 0x29, (char) 0xe3, (char) 0xd0, (char) 0x4, (char) 0xc0, (char) 0x10,
	(char) 0x73, (char) 0x7f, (char) 0x14, (char) 0x40, (char) 0x4c, (char) 0x14, (char) 0x45, (char) 0xf7, (char) 0xd2, (char) 0xd2, (char) 0x12, (char) 0xfb,
	(char) 0xc5, (char) 0x17, (char) 0x5f, (char) 0xe0, (char) 0xab, (char) 0xaf, (char) 0xbe, (char) 0xc2, (char) 0x89, (char) 0x13, (char) 0x27, (char) 0x10,
	(char) 0xe, (char) 0x87, (char) 0x61, (char) 0xb3, (char) 0xd9, (char) 0xc0, (char) 0x30, (char) 0xc, (char) 0x64, (char) 0x59, (char) 0x46, (char) 0xa3,
	(char) 0xd1, (char) 0x40, (char) 0x2a, (char) 0x95, (char) 0xc2, (char) 0xf2, (char) 0xf2, (char) 0x32, (char) 0x82, (char) 0xc1, (char) 0x20, (char) 0xee,
	(char) 0xde, (char) 0xbd, (char) 0xcb, (char) 0xae, (char) 0xad, (char) 0xad, (char) 0xb9, (char) 0x4b, (char) 0xa5, (char) 0x52, (char) 0xc, (char) 0x7b,
	(char) 0x49, (char) 0x21, (char) 0x3a, (char) 0x1, (char) 0x44, (char) 0xc6, (char) 0x45, (char) 0xa, (char) 0x8c, (char) 0x93, (char) 0xa, (char) 0xa0,
	(char) 0x3b, (char) 0x79, (char) 0x44, (char) 0x0, (char) 0x51, (char) 0x8b, (char) 0xc5, (char) 0xe2, (char) 0x9e, (char) 0x99, (char) 0x99, (char) 0x61,
	(char) 0x2f, (char) 0x5f, (char) 0xbe, (char) 0x8c, (char) 0xbf, (char) 0xff, (char) 0xfd, (char) 0xef, (char) 0xbd, (char) 0x6d, (char) 0x20, (char) 0x74,
	(char) 0x39, (char) 0x18, (char) 0xcb, (char) 0xb2, (char) 0x70, (char) 0x3a, (char) 0x9d, (char) 0x98, (char) 0x9f, (char) 0x9f, (char) 0x47, (char) 0x20,
	(char) 0x10, (char) 0x80, (char) 0xc7, (char) 0xe3, (char) 0x81, (char) 0x2c, (char) 0xcb, (char) 0xa8, (char) 0xd5, (char) 0x6a, (char) 0x6c, (char) 0xb5,
	(char) 0x5a, (char) 0xf5, (char) 0xc8, (char) 0xb2, (char) 0x1c, (char) 0xd1, (char) 0xc, (char) 0x43, (char) 0xe3, (char) 0xb4, (char) 0xd0, (char) 0xb1,
	(char) 0x50, (char) 0x1, (char) 0xec, (char) 0x18, (char) 0x7c, (char) 0x6, (char) 0xe3, (char) 0x72, (char) 0x8, (char) 0x3b, (char) 0xba, (char) 0xd3,
	(char) 0xc1, (char) 0x27, (char) 0x43, (char) 0xa1, (char) 0x90, (char) 0xfd, (char) 0xe2, (char) 0xc5, (char) 0x8b, (char) 0xe4, (char) 0xda, (char) 0xb5,
	(char) 0x6b, (char) 0xb8, (char) 0x70, (char) 0xe1, (char) 0x2, (char) 0xbc, (char) 0x5e, (char) 0xef, (char) 0xc0, (char) 0x5a, (char) 0x40, (char) 0xbd,
	(char) 0x5b, (char) 0xc8, (char) 0xed, (char) 0x76, (char) 0xa3, (char) 0xd3, (char) 0xe9, (char) 0x20, (char) 0x9d, (char) 0x4e, (char) 0x93, (char) 0xdd,
	(char) 0xdd, (char) 0x5d, (char) 0xa6, (char) 0x5e, (char) 0xaf, (char) 0xab, (char) 0xe8, (char) 0x4e, (char) 0x11, (char) 0x2b, (char) 0x61, (char) 0x88,
	(char) 0xb7, (char) 0x80, (char) 0xff, (char) 0x7f, (char) 0xbe, (char) 0xbc, (char) 0x71, (char) 0x74, (char) 0xff, (char) 0x44, (char) 0x0, (char) 0xd6,
	(char) 0x68, (char) 0x34, (char) 0xca, (char) 0xe8, (char) 0xeb, (char) 0x5f, (char) 0x3d, (char) 0x1e, (char) 0xcf, (char) 0xe1, (char) 0x2f, (char) 0x42,
	(char) 0x8, (char) 0xbc, (char) 0x5e, (char) 0x2f, (char) 0x16, (char) 0x17, (char) 0x17, (char) 0xb1, (char) 0xb8, (char) 0xb8, (char) 0x88, (char) 0x70,
	(char) 0x38, (char) 0x4c, (char) 0x34, (char) 0x75, (char) 0x22, (char) 0xe2, (char) 0xc3, (char) 0x76, (char) 0x71, (char) 0xb3, (char) 0x3d, (char) 0x7c,
	(char) 0x48, (char) 0x8, (char) 0x6f, (char) 0x94, (char) 0x4, (char) 0x56, (char) 0x0, (char) 0x76, (char) 0x96, (char) 0x65, (char) 0xd9, (char) 0x70,
	(char) 0x38, (char) 0x8c, (char) 0x58, (char) 0x2c, (char) 0x76, (char) 0xe8, (char) 0xdc, (char) 0xa0, (char) 0x7d, (char) 0x5f, (char) 0x8, (char) 0xc3,
	(char) 0x20, (char) 0x12, (char) 0x89, (char) 0xe8, (char) 0x25, (char) 0xe2, (char) 0xfa, (char) 0x0, (char) 0x9, (char) 0xbb, (char) 0x26, (char) 0x5d,
	(char) 0xc6, (char) 0x8a, (char) 0xf8, (char) 0xe3, (char) 0x22, (char) 0x1, (char) 0x8c, (char) 0x9, (char) 0x1e, (char) 0x1, (char) 0x80, (char) 0x85,
	(char) 0xe3, (char) 0x38, (char) 0xc6, (char) 0xe5, (char) 0x72, (char) 0xc1, (char) 0xe3, (char) 0xf1, (char) 0xc0, (char) 0xe1, (char) 0x70, (char) 0x7c,
	(char) 0xd4, (char) 0xb, (char) 0xba, (char) 0xdd, (char) 0x6e, (char) 0xb8, (char) 0xdd, (char) 0x6e, (char) 0xbd, (char) 0x97, (char) 0x80, (char) 0xc1,
	(char) 0x5e, (char) 0x53, (char) 0xa8, (char) 0x91, (char) 0xf8, (char) 0xc4, (char) 0x4, (char) 0xc0, (char) 0x70, (char) 0xaa, (char) 0x2, (char) 0xc2,
	(char) 0xb2, (char) 0x2c, (char) 0x78, (char) 0x9e, (char) 0x7, (char) 0xc7, (char) 0x71, (char) 0x3, (char) 0x97, (char) 0x3f, (char) 0xf, (char) 0x34,
	(char) 0x8c, (char) 0x58, (char) 0xb6, (char) 0xf7, (char) 0x77, (char) 0x9a, (char) 0xe4, (char) 0x20, (char) 0xe3, (char) 0xc8, (char) 0xfd, (char) 0xe3,
	(char) 0x6, (char) 0x80, (char) 0x7d, (char) 0xc5, (char) 0x1b, (char) 0xb2, (char) 0x2c, (char) 0x43, (char) 0x92, (char) 0x24, (char) 0x74, (char) 0x3a,
	(char) 0x1d, (char) 0xc8, (char) 0xf2, (char) 0xc7, (char) 0xb9, (char) 0xed, (char) 0x92, (char) 0x24, (char) 0xa1, (char) 0xdd, (char) 0x6e, (char) 0x43,
	(char) 0x92, (char) 0x24, (char) 0x7d, (char) 0x92, (char) 0x98, (char) 0xee, (char) 0xfb, (char) 0x1b, (char) 0xc3, (char) 0xc1, (char) 0xaa, (char) 0x9,
	(char) 0x80, (char) 0xe1, (char) 0x21, (char) 0x3c, (char) 0x3d, (char) 0x35, (char) 0xa4, (char) 0xdd, (char) 0xe9, (char) 0x74, (char) 0x94, (char) 0x72,
	(char) 0xb9, (char) 0x8c, (char) 0x62, (char) 0xb1, (char) 0x88, (char) 0x5a, (char) 0xad, (char) 0xf6, (char) 0x51, (char) 0x2f, (char) 0x58, (char) 0x2c,
	(char) 0x16, (char) 0x7b, (char) 0xad, (char) 0x61, (char) 0xaa, (char) 0xaa, (char) 0x2a, (char) 0xd8, (char) 0x9b, (char) 0x1f, (char) 0x3c, (char) 0x16,
	(char) 0x5b, (char) 0x42, (char) 0xc6, (char) 0x9, (char) 0x0, (char) 0xaa, (char) 0x1, (char) 0x4, (char) 0xb2, (char) 0xe6, (char) 0xaf, (char) 0xd7,
	(char) 0x65, (char) 0x59, (char) 0xee, (char) 0xa4, (char) 0x52, (char) 0x29, (char) 0x35, (char) 0x99, (char) 0x4c, (char) 0x62, (char) 0x67, (char) 0x67,
	(char) 0xe7, (char) 0x48, (char) 0xa3, (char) 0x63, (char) 0x80, (char) 0xee, (char) 0x82, (char) 0xe8, (char) 0x64, (char) 0x32, (char) 0x89, (char) 0xed,
	(char) 0xed, (char) 0x6d, (char) 0xec, (char) 0xee, (char) 0xee, (char) 0xaa, (char) 0x9a, (char) 0xeb, (char) 0x57, (char) 0xc3, (char) 0xfe, (char) 0xda,
	(char) 0x7f, (char) 0x53, (char) 0x5, (char) 0xc, (char) 0x21, (char) 0x10, (char) 0xf4, (char) 0x70, (char) 0x6d, (char) 0x1b, (char) 0x5a, (char) 0xc7,
	(char) 0x4e, (char) 0x2a, (char) 0x95, (char) 0x52, (char) 0x9f, (char) 0x3f, (char) 0x7f, (char) 0x8e, (char) 0x17, (char) 0x2f, (char) 0x5e, (char) 0xa0,
	(char) 0x50, (char) 0x28, (char) 0x1c, (char) 0xa, (char) 0x2, (char) 0x55, (char) 0x55, (char) 0x91, (char) 0xcd, (char) 0x66, (char) 0xf1, (char) 0xe2,
	(char) 0xc5, (char) 0xb, (char) 0xac, (char) 0xad, (char) 0xad, (char) 0x21, (char) 0x93, (char) 0xc9, (char) 0x28, (char) 0xd8, (char) 0xcb, (char) 0x12,
	(char) 0x8e, (char) 0xd4, (char) 0x4a, (char) 0xd8, (char) 0x4f, (char) 0x29, (char) 0x10, (char) 0x44, (char) 0x1b, (char) 0x69, (char) 0x74, (char) 0xe5,
	(char) 0x8f, (char) 0xbb, (char) 0xd5, (char) 0x6a, (char) 0x39, (char) 0x0, (char) 0xb0, (char) 0x84, (char) 0x10, (char) 0xe2, (char) 0xf3, (char) 0xf9,
	(char) 0xe0, (char) 0x76, (char) 0xbb, (char) 0x7b, (char) 0xed, (char) 0x60, (char) 0xc6, (char) 0xa3, (char) 0x28, (char) 0xa, (char) 0xb2, (char) 0xd9,
	(char) 0x2c, (char) 0x1e, (char) 0x3f, (char) 0x7e, (char) 0x8c, (char) 0x1b, (char) 0x37, (char) 0x6e, (char) 0xe0, (char) 0xf1, (char) 0xe3, (char) 0xc7,
	(char) 0xea, (char) 0xf6, (char) 0xf6, (char) 0x76, (char) 0x13, (char) 0xdd, (char) 0x6, (char) 0xd0, (char) 0x77, (char) 0xd8, (char) 0x3f, (char) 0x50,
	(char) 0xda, (char) 0x8c, (char) 0x4, (char) 0xe, (char) 0x69, (char) 0x2c, (char) 0x40, (char) 0x7, (char) 0x82, (char) 0x2, (char) 0xc0, (char) 0xa2,
	(char) 0x28, (char) 0x8a, (char) 0xa3, (char) 0xd9, (char) 0x6c, (char) 0x5a, (char) 0x1b, (char) 0x8d, (char) 0x6, (char) 0x53, (char) 0xa9, (char) 0x54,
	(char) 0xf4, (char) 0xf1, (char) 0xb0, (char) 0x60, (char) 0x59, (char) 0xb6, (char) 0x37, (char) 0x33, (char) 0xa0, (char) 0xdd, (char) 0x6e, (char) 0x23,
	(char) 0x9f, (char) 0xcf, (char) 0xf7, (char) 0xb6, (char) 0x83, (char) 0xdf, (char) 0xb8, (char) 0x71, (char) 0x3, (char) 0xf, (char) 0x1f, (char) 0x3e,
	(char) 0x44, (char) 0x22, (char) 0x91, (char) 0xe8, (char) 0xb4, (char) 0xdb, (char) 0xed, (char) 0x9c, (char) 0x46, (char) 0xfc, (char) 0x5d, (char) 0x7c,
	(char) 0x18, (char) 0xa, (char) 0x1e, (char) 0x8b, (char) 0x33, (char) 0xe, (char) 0xb9, (char) 0x0, (char) 0xda, (char) 0xe, (char) 0xa0, (char) 0x7b,
	(char) 0xf9, (char) 0x76, (char) 0x0, (char) 0xd8, (char) 0x4a, (char) 0xa5, (char) 0x12, (char) 0xbb, (char) 0xbe, (char) 0xbe, (char) 0xee, (char) 0x69,
	(char) 0x34, (char) 0x1a, (char) 0x6c, (char) 0x2a, (char) 0x95, (char) 0x22, (char) 0x27, (char) 0x4e, (char) 0x9c, (char) 0x40, (char) 0x2c, (char) 0x16,
	(char) 0x83, (char) 0xdb, (char) 0xed, (char) 0xde, (char) 0x97, (char) 0xd, (char) 0x4c, (char) 0x26, (char) 0x93, (char) 0x78, (char) 0xfe, (char) 0xfc,
	(char) 0x39, (char) 0xd6, (char) 0xd6, (char) 0xd6, (char) 0xd4, (char) 0x77, (char) 0xef, (char) 0xde, (char) 0xc9, (char) 0xb5, (char) 0x5a, (char) 0x4d,
	(char) 0xdf, (char) 0xe, (char) 0xbe, (char) 0x83, (char) 0x11, (char) 0xdc, (char) 0xa, (char) 0xfe, (char) 0xdf, (char) 0x70, (char) 0xcf, (char) 0x38,
	(char) 0x4, (char) 0x83, (char) 0xe8, (char) 0xf1, (char) 0x71, (char) 0x36, (char) 0x74, (char) 0x2b, (char) 0x80, (char) 0xa6, (char) 0x1, (char) 0x4c,
	(char) 0xb0, (char) 0x2c, (char) 0xeb, (char) 0xf1, (char) 0xfb, (char) 0xfd, (char) 0x96, (char) 0x70, (char) 0x38, (char) 0x4c, (char) 0x42, (char) 0xa1,
	(char) 0x10, (char) 0x71, (char) 0xb9, (char) 0x5c, (char) 0x60, (char) 0x59, (char) 0x16, (char) 0x9d, (char) 0x4e, (char) 0x7, (char) 0xe5, (char) 0x72,
	(char) 0x19, (char) 0xbb, (char) 0xbb, (char) 0xbb, (char) 0x6a, (char) 0x3a, (char) 0x9d, (char) 0x56, (char) 0xf2, (char) 0xf9, (char) 0x7c, (char) 0x5b,
	(char) 0x51, (char) 0x14, (char) 0x7d, (char) 0x69, (char) 0xe4, (char) 0x3b, (char) 0xec, (char) 0xad, (char) 0x86, (char) 0x6f, (char) 0x51, (char) 0x20,
	(char) 0x30, (char) 0x1, (char) 0x30, (char) 0xc4, (char) 0x76, (char) 0x80, (char) 0xb1, (char) 0x22, (char) 0xc8, (char) 0x83, (char) 0x6e, (char) 0x35,
	(char) 0x50, (char) 0x4, (char) 0x5a, (char) 0x8e, (char) 0x80, (char) 0x10, (char) 0xc2, (char) 0x31, (char) 0xc, (char) 0xc3, (char) 0x10, (char) 0x42,
	(char) 0x88, (char) 0xa2, (char) 0x28, (char) 0xaa, (char) 0xa2, (char) 0x28, (char) 0x7a, (char) 0x5f, (char) 0x60, (char) 0x43, (char) 0x23, (char) 0xf8,
	(char) 0xe, (char) 0x3e, (char) 0x5c, (char) 0xd, (char) 0x6f, (char) 0x94, (char) 0x0, (char) 0xa6, (char) 0xa, (char) 0x18, (char) 0x52, (char) 0x4f,
	(char) 0x80, (char) 0x6, (char) 0xb6, (char) 0xfe, (char) 0x9c, (char) 0xde, (char) 0xd7, (char) 0xef, (char) 0x7, (char) 0x20, (char) 0xaa, (char) 0xaa,
	(char) 0x6a, (char) 0x97, (char) 0x65, (char) 0x59, (char) 0xaf, (char) 0x9, (char) 0xd4, (char) 0x97, (char) 0x46, (char) 0xd4, (char) 0x35, (char) 0xe2,
	(char) 0xe7, (char) 0xb1, (char) 0x7f, (char) 0x73, (char) 0x58, (char) 0x7b, (char) 0x5c, (char) 0x89, (char) 0x3f, (char) 0x6e, (char) 0x12, (char) 0x80,
	(char) 0x56, (char) 0x5, (char) 0xc6, (char) 0xbd, (char) 0x42, (char) 0x74, (char) 0x65, (char) 0x30, (char) 0x7d, (char) 0x59, (char) 0xca, (char) 0x6e,
	(char) 0x30, (char) 0x76, (char) 0x0, (char) 0xeb, (char) 0x16, (char) 0x7f, (char) 0x67, (char) 0x5c, (char) 0x89, (char) 0x3f, (char) 0x6e, (char) 0x12,
	(char) 0xc0, (char) 0x68, (char) 0x10, (char) 0xd2, (char) 0x12, (char) 0x40, (char) 0x6f, (char) 0xfb, (char) 0xa6, (char) 0xfb, (char) 0x4, (char) 0x8c,
	(char) 0x8d, (char) 0x21, (char) 0xc6, (char) 0x6e, (char) 0xe0, (char) 0x7e, (char) 0x5d, (char) 0xc0, (char) 0x63, (char) 0x77, (char) 0xc6, (char) 0xb9,
	(char) 0x37, (char) 0xd0, (char) 0xd8, (char) 0xb, (char) 0xc8, (char) 0xe0, (char) 0xe0, (char) 0xce, (char) 0x60, (char) 0x5, (char) 0xfd, (char) 0xbb,
	(char) 0x80, (char) 0xc7, (char) 0x7a, (char) 0x8d, (char) 0xcc, (char) 0xa7, (char) 0xd0, (char) 0x1c, (char) 0x6a, (char) 0x54, (char) 0xd, (char) 0xc6,
	(char) 0xf9, (char) 0x82, (char) 0xc6, (char) 0x70, (char) 0xf2, (char) 0x27, (char) 0xd1, (char) 0x13, (char) 0xf8, (char) 0xa9, (char) 0x0, (char) 0x60,
	(char) 0x50, (char) 0xb0, (char) 0xe8, (char) 0x30, (char) 0x15, (char) 0x32, (char) 0xf6, (char) 0x84, (char) 0xff, (char) 0xd4, (char) 0x0, (char) 0x70,
	(char) 0xd8, (char) 0x67, (char) 0x57, (char) 0x61, (char) 0x1e, (char) 0xf3, (char) 0x98, (char) 0xc7, (char) 0x3c, (char) 0xe6, (char) 0x31, (char) 0x8f,
	(char) 0x79, (char) 0xcc, (char) 0x63, (char) 0x1e, (char) 0xf3, (char) 0x98, (char) 0xc7, (char) 0x3c, (char) 0x9f, (char) 0xc4, (char) 0xf9, (char) 0x3f,
	(char) 0x26, (char) 0xb5, (char) 0xd1, (char) 0xf8, (char) 0x17, (char) 0x18, (char) 0xd5, (char) 0x2a, (char) 0x0, (char) 0x0, (char) 0x0, (char) 0x0,
	(char) 0x49, (char) 0x45, (char) 0x4e, (char) 0x44, (char) 0xae, (char) 0x42, (char) 0x60, (char) 0x82
};

/**
 * Free resources
 */
IconMap::~IconMap() {
	freeIcons();
}

/**
 * Reset icon map
 */
void IconMap::reset() {
	paths.clear();
	nameToFile.clear();
	classToFile.clear();
	titleToFile.clear();
	freeIcons();
}

/**
 * Add name alias
 *
 * @param a - alias name
 * @param n - icon name
 */
void IconMap::addNameAlias(std::string a, std::string n) {
	nameToFile[a] = n;
}

/**
 * Add class alias
 *
 * @param a - class alias
 * @param n - icon name
 */
void IconMap::addClassAlias(std::string a, std::string n) {
	classToFile[a] = n;
}

/**
 * Add title alias
 *
 * @param a - title alias
 * @param n - icon name
 */
void IconMap::addTitleAlias(std::string a, std::string n) {
	titleToFile[a] = n;
}

/**
 * Return icon for given window properties
 *
 * @param t - window title
 * @param c - resource class
 * @param n - resource name
 */
Icon *IconMap::getIcon(std::string t, std::string c, std::string n) {
	Icon *icon;

	if (!(icon = getIconByTitle(t)) &&
			!(icon = getIconByClass(c)) &&
			!(icon = getIconByName(n))) {
		return 0;
	}

	return icon;
}

/**
 * Return icon for a window by name
 *
 * @param n - resource name of window
 */
Icon *IconMap::getIconByName(std::string n) {
	// try to resolve alias
	{
		AliasToFile::iterator i;

		if ((i = nameToFile.find(n)) != nameToFile.end()) {
			n = (*i).second;
		}
	}

	// cache look up
	{
		FileToIcon::iterator i;

		if ((i = cache.find(n)) != cache.end()) {
			return (*i).second;
		}
	}

	// load PNG file from disk
	{
		std::string file = n+".png";
		std::transform(
			file.begin(),
			file.end(),
			file.begin(),
			::tolower);

		for (Paths::const_iterator i = paths.begin();
				i != paths.end();
				++i) {
			std::string path = *i+file;
			struct stat buf;

			if (stat(path.c_str(), &buf) > -1) {
				ArgbSurface *s = Png::load(path);
				Icon *icon = createIcon(s, n, Icon::File);
				delete s;
				return icon;
			}
		}
	}

#ifdef HAVE_GTK
	// ask GNOME for icon
	{
		GtkIconTheme *theme = gtk_icon_theme_get_for_screen(
			gdk_screen_get_default());
		GdkPixbuf *pixbuf = 0;

		// theme look up
		{
			GtkIconInfo *iconInfo = gtk_icon_theme_lookup_icon(
				theme,
				n.c_str(),
				128,
				GTK_ICON_LOOKUP_USE_BUILTIN);

			if (iconInfo) {
				pixbuf = gdk_pixbuf_new_from_file_at_size(
					gtk_icon_info_get_filename(iconInfo),
					128,
					-1,
					0);

				gtk_icon_info_free(iconInfo);
			}
		}

		// otherwise try to load the icon blindly
		if (!pixbuf)
			pixbuf = gtk_icon_theme_load_icon(
				theme,
				n.c_str(),
				128,
				GTK_ICON_LOOKUP_FORCE_SVG,
				0);

		if (pixbuf &&
				gdk_pixbuf_get_colorspace(pixbuf) == GDK_COLORSPACE_RGB &&
				gdk_pixbuf_get_bits_per_sample(pixbuf) == 8 &&
				gdk_pixbuf_get_n_channels(pixbuf) == 4 &&
				gdk_pixbuf_get_has_alpha(pixbuf)) {
			unsigned char *src = reinterpret_cast<unsigned char *>(
				gdk_pixbuf_get_pixels(pixbuf));
			int w = gdk_pixbuf_get_width(pixbuf);
			int h = gdk_pixbuf_get_height(pixbuf);
			int p = gdk_pixbuf_get_rowstride(pixbuf) - (w << 2);
			ArgbSurface s(w, h);
			unsigned char *dest = reinterpret_cast<unsigned char *>(
				s.getData());
			int dp = s.getPadding();

			// only 4-byte alignments are sane for 32 bits per pixel
			if (p % 4 || dp % 4) {
				return 0;
			}

			for (int y = s.getHeight(); y--; src += p, dest += dp)
				for (int x = s.getWidth(); x--; src += 4, dest += 4) {
					// swap Red with Blue; GdkPixbuf has BGR order
					dest[0] = src[2];
					dest[1] = src[1];
					dest[2] = src[0];
					dest[3] = src[3];
				}

			return createIcon(&s, n, Icon::File);
		}
	}
#endif

#ifdef HAVE_KDE
	// ask KDE for icon
	{
		KIconLoader *loader;

		if (loader = KIconLoader::global()) {
			QPixmap pixmap = loader->loadIcon(
				n.c_str(),
				KIconLoader::Desktop,
				128,
				KIconLoader::DefaultState,
				QStringList(),
				0L,
				true);

			if (!pixmap.isNull()) {
				QImage image = pixmap.toImage();

				if (image.format() == QImage::Format_ARGB32_Premultiplied) {
					ArgbSurface s(image.width(), image.height());
					unsigned char *dest = reinterpret_cast<unsigned char *>(
						s.getData());
					unsigned char *src = reinterpret_cast<unsigned char *>(
						image.bits());
					int p = image.bytesPerLine()-(image.width() << 2);
					int dp = s.getPadding();

					if (s.getBytesPerLine() == image.bytesPerLine()) {
						memcpy(dest, src, s.getSize());
					} else {
						// only 4-byte alignments are sane
						// for 32 bits per pixel
						if (p%4 || dp%4) {
							return 0;
						}

						for (int y = s.getHeight();
								y--;
								src += p, dest += dp)
							for (int x = s.getWidth();
									x--;
									src += 4, dest += 4)
								*reinterpret_cast<uint32_t *>(dest) =
									*reinterpret_cast<uint32_t *>(src);
					}

					return createIcon(&s, n, Icon::File);
				}
			}
		}
	}
#endif

	return 0;
}

/**
 * Return icon for a window by class
 *
 * @param c - resource class of window
 */
Icon *IconMap::getIconByClass(const std::string c) {
	// resolve alias to filename
	AliasToFile::iterator i;

	if ((i = classToFile.find(c)) != classToFile.end()) {
		return getIconByName((*i).second);
	}

	return 0;
}

/**
 * Return icon for a window by window title; this is by far the slowest
 * method and probably prone to error too; use it only as a fallback !
 * Unfortunately, most Java applications have invalid resource names
 * like "SWT" or the like; to identify those windows there's just
 * one possibility: the window title
 *
 * @param t - window title (may contain wildcards)
 */
Icon *IconMap::getIconByTitle(const std::string t) {
	// resolve alias to filename
	for (AliasToFile::iterator i = titleToFile.begin();
			i != titleToFile.end();
			++i)
		if (WildcardCompare::match(t.c_str(), (*i).first.c_str())) {
			return getIconByName((*i).second);
		}

	return 0;
}

/**
 * Create and return a new icon for missing icons
 *
 * @param n - resource name of window for which there is no icon
 */
Icon *IconMap::getMissingIcon(const std::string n) {
	if (!missingSurface) {
		struct stat buf;

		if (!fileForMissing.empty() &&
				stat(fileForMissing.c_str(), &buf) > -1) {
			if (!(missingSurface = Png::load(fileForMissing))) {
				return 0;
			}
		} else {
			std::string d(fallbackPng, sizeof(fallbackPng));
			std::istringstream iss(d, std::ios::binary);

			if (!(missingSurface = Png::load(iss))) {
				return 0;
			}
		}
	}

	return createIcon(missingSurface, n, Icon::Missing);
}

/**
 * Create and return a new filler icon
 */
Icon *IconMap::getFillerIcon() {
	if (!fillerSurface) {
		struct stat buf;

		if (!fileForFiller.empty() &&
				stat(fileForFiller.c_str(), &buf) > -1) {
			if (!(fillerSurface = Png::load(fileForFiller))) {
				return 0;
			}
		} else {
			if (!(fillerSurface = new ArgbSurface(1, 1))) {
				return 0;
			}

			// clear surface
			memset(
				fillerSurface->getData(),
				0,
				fillerSurface->getSize());
		}
	}

	return createIcon(fillerSurface, "", Icon::Filler);
}

/**
 * Create icon and return it
 *
 * @param s - ARGB surface for icon
 * @param n - resource name of window
 * @param t - icon type
 */
Icon *IconMap::createIcon(
	const ArgbSurface *s,
	const std::string n,
	const Icon::Type t) {
	Icon *icon = new Icon(s, t);
	cache[n] = icon;

	return icon;
}

/**
 * Save icon
 *
 * @param s - ARGB surface for icon
 * @param n - resource name of window
 */
void IconMap::saveIcon(const ArgbSurface *s, const std::string n) const {
	std::string file = n+".png";
	std::transform(
		file.begin(),
		file.end(),
		file.begin(),
		::tolower);

	for (Paths::const_iterator i = paths.begin();
			i != paths.end();
			++i) {
		std::string path = *i+file;
		struct stat buf;

		if (stat(path.c_str(), &buf) == -1) {
			std::ofstream out(path.c_str(), std::ios::out);

			if (out.good()) {
				Png::save(out, s);
			}
		}

		// try first directory only
		break;
	}
}

/**
 * Free icons
 */
void IconMap::freeIcons() {
	for (FileToIcon::iterator i = cache.begin();
			i != cache.end();
			++i) {
		delete(*i).second;
	}

	cache.clear();

	if (missingSurface) {
		delete missingSurface;
		missingSurface = 0;
	}

	if (fillerSurface) {
		delete fillerSurface;
		fillerSurface = 0;
	}
}
