/* ARROWS - a game.
 * Version 0.6 release, 2004-01-11.
 * Author Jeremy Day (nor@noreason.ca)
 * Copyright 1993, 2004 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */

#define ARROWS_MAIN
#include "arrows.h"
#include <stdio.h>

/* Create a new backing pixmap of the appropriate size */
static gboolean configure_event( GtkWidget         *widget,
                                 GdkEventConfigure *event )
{
	if (pixmap)
	{
		return TRUE;
	}

	pixmap = gdk_pixmap_new (widget->window,
			widget->allocation.width,
			widget->allocation.height,
			-1);
	gdk_draw_rectangle (pixmap,
			widget->style->white_gc,
			TRUE,
			0, 0,
			widget->allocation.width,
			widget->allocation.height);

	return TRUE;
}

/* Redraw the screen from the backing pixmap */
static gboolean expose_event( GtkWidget      *widget,
                              GdkEventExpose *event )
{
	gdk_draw_drawable (widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			pixmap,
			event->area.x, event->area.y,
			event->area.x, event->area.y,
			event->area.width, event->area.height);

	return FALSE;
}

/* Draw a rectangle on the screen */
static void draw_brush( GtkWidget *widget,
                        gdouble    x,
                        gdouble    y)
{
	GdkRectangle update_rect;

	update_rect.x = x - 3;
	update_rect.y = y - 3;
	update_rect.width = 6;
	update_rect.height = 6;

	gdk_draw_rectangle 
		(
			pixmap,
			widget->style->black_gc,
			TRUE,
			update_rect.x, update_rect.y,
			update_rect.width, update_rect.height
		);

	gtk_widget_queue_draw_area 
		(
			widget, 
			update_rect.x, update_rect.y,
			update_rect.width, update_rect.height
		);

	draw_arrow(100, 10, UP, 7);
	draw_arrow(100, 10, LEFT, 7);
	draw_arrow(100, 50, RIGHT, 7);
	draw_arrow(100, 50, DOWN, 7);
}

#if 0
static gboolean button_press_event( GtkWidget      *widget,
                                    GdkEventButton *event )
{
	if (event->button == 1 && pixmap != NULL)
		draw_brush (widget, event->x, event->y);

	return TRUE;
}

static gboolean motion_notify_event( GtkWidget *widget,
		                                     GdkEventMotion *event )
{
	int x, y;
//	GdkModifierType state;
	guint state;

	if (event->is_hint)
	gdk_window_get_pointer (event->window, &x, &y, &state);
	else
	{
		x = event->x;
		y = event->y;
		state = (GdkModifierType)event->state;
	}

	if (state & GDK_BUTTON1_MASK && pixmap != NULL)
		draw_brush (widget, x, y);

	return TRUE;
}
#endif

void quit ()
{
	exit (0);
}

void game_main(void);

int main( int   argc, 
          char *argv[] )
{
	GtkWidget *window;
	GtkWidget *vbox;

	pixmap = NULL;

	gtk_init (&argc, &argv);

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name (window, "Arrows");

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_widget_show (vbox);

	g_signal_connect (G_OBJECT (window), "destroy",
	G_CALLBACK (quit), NULL);

	/* keypress events */
	g_signal_connect (G_OBJECT (window), "key_release_event",
			G_CALLBACK (key_released), NULL);
	g_signal_connect (G_OBJECT (window), "key_press_event",
			G_CALLBACK (key_pressed), NULL);

	/* Create the drawing area */
	drawing_area = gtk_drawing_area_new ();
	gtk_widget_set_size_request (GTK_WIDGET (drawing_area), 640, 480);
	gtk_box_pack_start (GTK_BOX (vbox), drawing_area, TRUE, TRUE, 0);
	gtk_widget_show (drawing_area);

	/* Signals used to handle backing pixmap */
	g_signal_connect (G_OBJECT (drawing_area), "expose_event",
	G_CALLBACK (expose_event), NULL);
	g_signal_connect (G_OBJECT (drawing_area),"configure_event",
	G_CALLBACK (configure_event), NULL);

	/* Event signals */
#if 0
	/* this was originally scribble.c from the gtk tutorial. */
	g_signal_connect (G_OBJECT (drawing_area), "motion_notify_event",
			G_CALLBACK (motion_notify_event), NULL);
	g_signal_connect (G_OBJECT (drawing_area), "button_press_event",
			G_CALLBACK (button_press_event), NULL);
#endif
	gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

	gtk_window_set_resizable((GtkWindow *)window, FALSE);
	gtk_widget_show (window);

	game_main();

	return 0;
}

