# Contributing Guidelines

## Commit Policy

Everybody is welcome to committing small fixes and one-liners
without prior notification to the maintainer, provided that the
following rules are followed:

   1. Please keep your commits as small and as atomic as possible.
   2. Do not push both formatting and code changes in the same
      commit.
   3. Do not fix coding style and code issues in the same commit.

For larger commits, please use GitLab or send
and e-mail to the maintainer. A rule of thumb to check whether your
commit is a major commit is if it affects more than 5 lines of code.

Break down larger fixes into smaller commits. Even if you push the
commits with one `git push`, git preserves your commit info.

i18n and documentation fixes, however large they are, may be directly
committed without prior notification.

## Coding Style

Spectacle follows the KDELibs coding style, with a few exceptions:

   1. In class definitions, access modifiers are aligned along with
      member declarations, i.e., at one level right. E.g.:

      ```cpp
      class Hello : public QObject
      {
          Q_OBJECT

          public:

          void function();
      }
      ```

      The access modifier ordering is: public, signals, public slots,
      protected slots, protected, private slots, private. Member variables
      come at the end, after all member functions. This is not strictly
      enforced, but is a good rule to follow.

   2. Member variables follow the format `mCamelCase`, and `not m_camelCase`
      which is more common throughout the rest of the KDE Applications.

   3. Source files are mixed case, named the same as the class they
      contain. i.e., `SomeClass` will be defined in `SomeClass.cpp`, not
      `someclass.cpp`.

### Happy coding!
