/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pl.com.salsoft.sqlitestudioremote.internal.Utils;

public class JsonConverter {
    public static Object fromJsonValue(Object input) {
        if (input instanceof JSONObject) {
            return JsonConverter.fromJson((JSONObject)input);
        }
        if (input instanceof JSONArray) {
            return JsonConverter.fromJson((JSONArray)input);
        }
        return input;
    }

    public static Object toJsonValue(Object o) {
        if (o == null) {
            return JSONObject.NULL;
        }
        if (o instanceof JSONArray || o instanceof JSONObject) {
            return o;
        }
        if (o.equals(JSONObject.NULL)) {
            return o;
        }
        try {
            if (o instanceof Collection) {
                return JsonConverter.collectionToArray((Collection)o);
            }
            if (o instanceof byte[]) {
                JSONArray array = new JSONArray();
                array.put((Object)Utils.toBlobString((byte[])o));
                return array;
            }
            if (o.getClass().isArray()) {
                return JsonConverter.arrayToArray(o);
            }
            if (o instanceof Map) {
                return JsonConverter.mapToObject((Map)o);
            }
            if (o instanceof Boolean || o instanceof Character || o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof Byte || o instanceof String) {
                return o;
            }
            if (o.getClass().getPackage().getName().startsWith("java.")) {
                return o.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object arrayToArray(Object o) {
        JSONArray array = new JSONArray();
        if (o.getClass().getComponentType().isPrimitive()) {
            int length = Array.getLength(o);
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(o, i);
                array.put(obj);
            }
        } else {
            Object[] objects;
            for (Object obj : objects = (Object[])o) {
                array.put(JsonConverter.toJsonValue(obj));
            }
        }
        return array;
    }

    private static Object collectionToArray(Collection o) {
        JSONArray array = new JSONArray();
        for (Object obj : o) {
            array.put(JsonConverter.toJsonValue(obj));
        }
        return array;
    }

    private static Object mapToObject(Map o) {
        JSONObject jsonObj = new JSONObject();
        for (Object key : o.keySet()) {
            try {
                jsonObj.put("" + key, JsonConverter.toJsonValue(o.get(key)));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonObj;
    }

    private static HashMap<String, Object> fromJson(JSONObject object) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, JsonConverter.fromJsonValue(object.opt(key)));
        }
        return map;
    }

    private static List<Object> fromJson(JSONArray array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(JsonConverter.fromJsonValue(array.opt(i)));
        }
        return list;
    }
}

