/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.ArrayType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.BagType;
import net.sf.hibernate.type.CompositeCustomType;
import net.sf.hibernate.type.CurrencyType;
import net.sf.hibernate.type.CustomType;
import net.sf.hibernate.type.IdentifierBagType;
import net.sf.hibernate.type.ListType;
import net.sf.hibernate.type.ManyToOneType;
import net.sf.hibernate.type.MapType;
import net.sf.hibernate.type.OneToOneType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.SetType;
import net.sf.hibernate.type.SortedMapType;
import net.sf.hibernate.type.SortedSetType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;

public final class TypeFactory {
    private static final Map BASIC_TYPES;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$util$TimeZone;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$net$sf$hibernate$type$Type;
    static /* synthetic */ Class class$net$sf$hibernate$CompositeUserType;
    static /* synthetic */ Class class$net$sf$hibernate$UserType;
    static /* synthetic */ Class class$net$sf$hibernate$Lifecycle;
    static /* synthetic */ Class class$net$sf$hibernate$PersistentEnum;

    private TypeFactory() {
        throw new UnsupportedOperationException();
    }

    public static Type oneToOne(Class persistentClass, AssociationType.ForeignKeyType foreignKeyType) {
        return new OneToOneType(persistentClass, foreignKeyType);
    }

    public static Type manyToOne(Class persistentClass) {
        return new ManyToOneType(persistentClass);
    }

    public static Type basic(String name) {
        return (Type)BASIC_TYPES.get(name);
    }

    public static Type hueristicType(String typeName) throws MappingException {
        Type type = TypeFactory.basic(typeName);
        if (type == null) {
            Class typeClass;
            try {
                typeClass = ReflectHelper.classForName(typeName);
            }
            catch (ClassNotFoundException cnfe) {
                typeClass = null;
            }
            if (typeClass != null) {
                if ((class$net$sf$hibernate$type$Type == null ? (class$net$sf$hibernate$type$Type = TypeFactory.class$("net.sf.hibernate.type.Type")) : class$net$sf$hibernate$type$Type).isAssignableFrom(typeClass)) {
                    try {
                        type = (Type)typeClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new MappingException("Could not instantiate Type " + typeClass.getName() + ": " + e);
                    }
                } else if ((class$net$sf$hibernate$CompositeUserType == null ? (class$net$sf$hibernate$CompositeUserType = TypeFactory.class$("net.sf.hibernate.CompositeUserType")) : class$net$sf$hibernate$CompositeUserType).isAssignableFrom(typeClass)) {
                    type = new CompositeCustomType(typeClass);
                } else if ((class$net$sf$hibernate$UserType == null ? (class$net$sf$hibernate$UserType = TypeFactory.class$("net.sf.hibernate.UserType")) : class$net$sf$hibernate$UserType).isAssignableFrom(typeClass)) {
                    type = new CustomType(typeClass);
                } else if ((class$net$sf$hibernate$Lifecycle == null ? (class$net$sf$hibernate$Lifecycle = TypeFactory.class$("net.sf.hibernate.Lifecycle")) : class$net$sf$hibernate$Lifecycle).isAssignableFrom(typeClass)) {
                    type = Hibernate.entity(typeClass);
                } else if ((class$net$sf$hibernate$PersistentEnum == null ? (class$net$sf$hibernate$PersistentEnum = TypeFactory.class$("net.sf.hibernate.PersistentEnum")) : class$net$sf$hibernate$PersistentEnum).isAssignableFrom(typeClass)) {
                    type = Hibernate.enum(typeClass);
                } else if ((class$java$io$Serializable == null ? (class$java$io$Serializable = TypeFactory.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(typeClass)) {
                    type = Hibernate.serializable(typeClass);
                }
            }
        }
        return type;
    }

    public static PersistentCollectionType array(String role, Class elementClass) {
        return new ArrayType(role, elementClass);
    }

    public static PersistentCollectionType list(String role) {
        return new ListType(role);
    }

    public static PersistentCollectionType bag(String role) {
        return new BagType(role);
    }

    public static PersistentCollectionType idbag(String role) {
        return new IdentifierBagType(role);
    }

    public static PersistentCollectionType map(String role) {
        return new MapType(role);
    }

    public static PersistentCollectionType set(String role) {
        return new SetType(role);
    }

    public static PersistentCollectionType sortedMap(String role, Comparator comparator) {
        return new SortedMapType(role, comparator);
    }

    public static PersistentCollectionType sortedSet(String role, Comparator comparator) {
        return new SortedSetType(role, comparator);
    }

    public static void deepCopy(Object[] values, Type[] types, boolean[] copy, Object[] target) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            if (copy[i]) {
                target[i] = types[i].deepCopy(values[i]);
            }
            ++i;
        }
    }

    public static int[] findDirty(Type[] types, Object[] x, Object[] y, boolean[] check, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int i = 0;
        while (i < types.length) {
            if (check[i] && types[i].isDirty(x[i], y[i], session)) {
                if (results == null) {
                    results = new int[types.length];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, Type> basics = new HashMap<String, Type>();
        basics.put(Boolean.TYPE.getName(), Hibernate.BOOLEAN);
        basics.put(Long.TYPE.getName(), Hibernate.LONG);
        basics.put(Short.TYPE.getName(), Hibernate.SHORT);
        basics.put(Integer.TYPE.getName(), Hibernate.INTEGER);
        basics.put(Byte.TYPE.getName(), Hibernate.BYTE);
        basics.put(Float.TYPE.getName(), Hibernate.FLOAT);
        basics.put(Double.TYPE.getName(), Hibernate.DOUBLE);
        basics.put(Character.TYPE.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.CHARACTER.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.INTEGER.getName(), Hibernate.INTEGER);
        basics.put(Hibernate.STRING.getName(), Hibernate.STRING);
        basics.put(Hibernate.DATE.getName(), Hibernate.DATE);
        basics.put(Hibernate.TIME.getName(), Hibernate.TIME);
        basics.put(Hibernate.TIMESTAMP.getName(), Hibernate.TIMESTAMP);
        basics.put(Hibernate.LOCALE.getName(), Hibernate.LOCALE);
        basics.put(Hibernate.CALENDAR.getName(), Hibernate.CALENDAR);
        basics.put(Hibernate.CALENDAR_DATE.getName(), Hibernate.CALENDAR_DATE);
        basics.put(Hibernate.CURRENCY.getName(), Hibernate.CURRENCY);
        basics.put(Hibernate.TIMEZONE.getName(), Hibernate.TIMEZONE);
        basics.put(Hibernate.CLASS.getName(), Hibernate.CLASS);
        basics.put(Hibernate.TRUE_FALSE.getName(), Hibernate.TRUE_FALSE);
        basics.put(Hibernate.YES_NO.getName(), Hibernate.YES_NO);
        basics.put(Hibernate.BINARY.getName(), Hibernate.BINARY);
        basics.put(Hibernate.BLOB.getName(), Hibernate.BLOB);
        basics.put(Hibernate.CLOB.getName(), Hibernate.CLOB);
        basics.put(Hibernate.BIG_DECIMAL.getName(), Hibernate.BIG_DECIMAL);
        basics.put(Hibernate.SERIALIZABLE.getName(), Hibernate.SERIALIZABLE);
        basics.put(Hibernate.OBJECT.getName(), Hibernate.OBJECT);
        basics.put((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), Hibernate.BOOLEAN);
        basics.put((class$java$lang$Long == null ? (class$java$lang$Long = TypeFactory.class$("java.lang.Long")) : class$java$lang$Long).getName(), Hibernate.LONG);
        basics.put((class$java$lang$Short == null ? (class$java$lang$Short = TypeFactory.class$("java.lang.Short")) : class$java$lang$Short).getName(), Hibernate.SHORT);
        basics.put((class$java$lang$Integer == null ? (class$java$lang$Integer = TypeFactory.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), Hibernate.INTEGER);
        basics.put((class$java$lang$Byte == null ? (class$java$lang$Byte = TypeFactory.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), Hibernate.BYTE);
        basics.put((class$java$lang$Float == null ? (class$java$lang$Float = TypeFactory.class$("java.lang.Float")) : class$java$lang$Float).getName(), Hibernate.FLOAT);
        basics.put((class$java$lang$Double == null ? (class$java$lang$Double = TypeFactory.class$("java.lang.Double")) : class$java$lang$Double).getName(), Hibernate.DOUBLE);
        basics.put((class$java$lang$Character == null ? (class$java$lang$Character = TypeFactory.class$("java.lang.Character")) : class$java$lang$Character).getName(), Hibernate.CHARACTER);
        basics.put((class$java$lang$String == null ? (class$java$lang$String = TypeFactory.class$("java.lang.String")) : class$java$lang$String).getName(), Hibernate.STRING);
        basics.put((class$java$util$Date == null ? (class$java$util$Date = TypeFactory.class$("java.util.Date")) : class$java$util$Date).getName(), Hibernate.TIMESTAMP);
        basics.put((class$java$sql$Time == null ? (class$java$sql$Time = TypeFactory.class$("java.sql.Time")) : class$java$sql$Time).getName(), Hibernate.TIME);
        basics.put((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeFactory.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), Hibernate.TIMESTAMP);
        basics.put((class$java$sql$Date == null ? (class$java$sql$Date = TypeFactory.class$("java.sql.Date")) : class$java$sql$Date).getName(), Hibernate.DATE);
        basics.put((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), Hibernate.BIG_DECIMAL);
        basics.put((class$java$util$Locale == null ? (class$java$util$Locale = TypeFactory.class$("java.util.Locale")) : class$java$util$Locale).getName(), Hibernate.LOCALE);
        basics.put((class$java$util$Calendar == null ? (class$java$util$Calendar = TypeFactory.class$("java.util.Calendar")) : class$java$util$Calendar).getName(), Hibernate.CALENDAR);
        basics.put((class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TypeFactory.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar).getName(), Hibernate.CALENDAR);
        if (CurrencyType.CURRENCY_CLASS != null) {
            basics.put(CurrencyType.CURRENCY_CLASS.getName(), Hibernate.CURRENCY);
        }
        basics.put((class$java$util$TimeZone == null ? (class$java$util$TimeZone = TypeFactory.class$("java.util.TimeZone")) : class$java$util$TimeZone).getName(), Hibernate.TIMEZONE);
        basics.put((class$java$lang$Object == null ? (class$java$lang$Object = TypeFactory.class$("java.lang.Object")) : class$java$lang$Object).getName(), Hibernate.OBJECT);
        basics.put((class$java$lang$Class == null ? (class$java$lang$Class = TypeFactory.class$("java.lang.Class")) : class$java$lang$Class).getName(), Hibernate.CLASS);
        basics.put((array$B == null ? (array$B = TypeFactory.class$("[B")) : array$B).getName(), Hibernate.BINARY);
        basics.put((class$java$sql$Blob == null ? (class$java$sql$Blob = TypeFactory.class$("java.sql.Blob")) : class$java$sql$Blob).getName(), Hibernate.BLOB);
        basics.put((class$java$sql$Clob == null ? (class$java$sql$Clob = TypeFactory.class$("java.sql.Clob")) : class$java$sql$Clob).getName(), Hibernate.CLOB);
        basics.put((class$java$io$Serializable == null ? (class$java$io$Serializable = TypeFactory.class$("java.io.Serializable")) : class$java$io$Serializable).getName(), Hibernate.SERIALIZABLE);
        BASIC_TYPES = Collections.unmodifiableMap(basics);
    }
}

