/*
 * Decompiled with CFR 0.152.
 */
package net.pms.xmlwise;

import java.util.LinkedList;
import net.pms.xmlwise.XmlElementAttributes;
import net.pms.xmlwise.XmlParseException;
import net.pms.xmlwise.Xmlwise;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElement
extends LinkedList<XmlElement> {
    private final XmlElementAttributes m_attributes;
    private final String m_value;
    private final String m_name;

    public XmlElement(Element element) {
        this.m_attributes = new XmlElementAttributes(element);
        NodeList children = element.getChildNodes();
        this.m_name = element.getNodeName();
        StringBuilder textValue = new StringBuilder();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                this.add(new XmlElement((Element)node));
            }
            if (node.getNodeType() != 3) continue;
            textValue.append(node.getNodeValue());
        }
        this.m_value = textValue.toString();
    }

    public XmlElement(String name, String value) {
        this.m_attributes = new XmlElementAttributes();
        this.m_name = name;
        this.m_value = value;
    }

    public XmlElement(String name) {
        this.m_attributes = new XmlElementAttributes();
        this.m_name = name;
        this.m_value = "";
    }

    public XmlElement getUnique(String name) throws XmlParseException {
        LinkedList<XmlElement> matches = this.get(name);
        if (matches.size() != 1) {
            throw new XmlParseException("Unexpected number of elements of type " + name + " in element <" + this.getName() + ">");
        }
        return matches.getFirst();
    }

    public int getIntAttribute(String attribute) throws XmlParseException {
        return this.getAttributes().getInt(attribute);
    }

    public int getIntAttribute(String attribute, int defaultValue) throws XmlParseException {
        return this.containsAttribute(attribute) ? this.getIntAttribute(attribute) : defaultValue;
    }

    public double getDoubleAttribute(String attribute) throws XmlParseException {
        return this.getAttributes().getDouble(attribute);
    }

    public double getDoubleAttribute(String attribute, double defaultValue) throws XmlParseException {
        return this.containsAttribute(attribute) ? this.getDoubleAttribute(attribute) : defaultValue;
    }

    public String getAttribute(String attribute, String defaultValue) {
        String value = this.getAttribute(attribute);
        return value == null ? defaultValue : value;
    }

    public String getAttribute(String attribute) {
        return (String)this.getAttributes().get(attribute);
    }

    public boolean getBoolAttribute(String attribute) throws XmlParseException {
        return this.getAttributes().getBoolean(attribute);
    }

    public boolean getBoolAttribute(String attribute, boolean defaultValue) throws XmlParseException {
        return this.containsAttribute(attribute) ? this.getBoolAttribute(attribute) : defaultValue;
    }

    public LinkedList<XmlElement> get(String name) {
        LinkedList<XmlElement> list = new LinkedList<XmlElement>();
        for (XmlElement element : this) {
            if (!element.getName().equals(name)) continue;
            list.add(element);
        }
        return list;
    }

    public void setAttribute(String attribute, Object value) {
        this.m_attributes.put(attribute, value.toString());
    }

    public boolean removeAttribute(String attribute) {
        return this.m_attributes.remove(attribute) != null;
    }

    public boolean contains(String key) {
        for (XmlElement element : this) {
            if (!element.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public String toXml() {
        StringBuilder builder = new StringBuilder("<").append(this.m_name);
        if (this.m_attributes.size() > 0) {
            builder.append(this.m_attributes.toXml());
        }
        if (this.isEmpty() && this.m_value.length() == 0) {
            builder.append("/>");
        } else {
            builder.append('>');
            builder.append(Xmlwise.escapeXML(this.m_value));
            for (XmlElement element : this) {
                builder.append(element.toXml());
            }
            builder.append("</").append(this.m_name).append('>');
        }
        return builder.toString();
    }

    public String getValue() {
        return this.m_value;
    }

    public XmlElementAttributes getAttributes() {
        return this.m_attributes;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean containsAttribute(String attribute) {
        return this.getAttributes().containsKey(attribute);
    }
}

