/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.pms.PMS;
import net.pms.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpTab {
    private static final Logger logger = LoggerFactory.getLogger(HelpTab.class);
    private JEditorPane editorPane;

    public JEditorPane getList() {
        return this.editorPane;
    }

    public JComponent build() {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "pref, fill:default:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.setBackground(Color.WHITE);
        this.updateContents();
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                try {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String urlString = event.getURL().toExternalForm();
                        if (urlString.startsWith("http://") || urlString.startsWith("https://") || urlString.startsWith("ftp://")) {
                            URI uri = new URI(urlString);
                            Desktop.getDesktop().browse(uri);
                        } else {
                            HelpTab.this.editorPane.setPage(event.getURL());
                        }
                    }
                }
                catch (IOException e) {
                    logger.debug("Caught exception", e);
                }
                catch (URISyntaxException e) {
                    logger.debug("Caught exception", e);
                }
            }
        });
        JScrollPane pane = new JScrollPane(this.editorPane, 20, 30);
        pane.setPreferredSize(new Dimension(500, 400));
        builder.add((Component)pane, cc.xy(2, 2));
        return builder.getPanel();
    }

    public void updateContents() {
        if (this.editorPane != null) {
            try {
                String documentationDir = PropertiesUtil.getProjectProperties().get("project.documentation.dir");
                String helpPage = PMS.getHelpPage();
                File file = new File(documentationDir + "/" + helpPage);
                this.editorPane.setPage(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.debug("Caught exception", e);
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
        }
    }
}

