/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaLang;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.PlayerPurpose;
import net.pms.external.ExternalFactory;
import net.pms.external.ExternalListener;
import net.pms.external.FinalizeTranscoderArgsListener;
import net.pms.formats.Format;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.util.FileUtil;
import net.pms.util.Iso639;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Player {
    private static final Logger logger = LoggerFactory.getLogger(Player.class);
    private static List<FinalizeTranscoderArgsListener> finalizeTranscoderArgsListeners = new ArrayList<FinalizeTranscoderArgsListener>();

    public abstract PlayerPurpose getPurpose();

    public abstract JComponent config();

    public abstract String id();

    public abstract String name();

    public abstract int type();

    @Deprecated
    public abstract String[] args();

    public abstract String mimeType();

    public boolean isNative() {
        return false;
    }

    public abstract String executable();

    public static void initializeFinalizeTranscoderArgsListeners() {
        for (ExternalListener listener : ExternalFactory.getExternalListeners()) {
            if (!(listener instanceof FinalizeTranscoderArgsListener)) continue;
            finalizeTranscoderArgsListeners.add((FinalizeTranscoderArgsListener)listener);
        }
    }

    @Deprecated
    public boolean avisynth() {
        return false;
    }

    public boolean excludeFormat(Format extension) {
        return false;
    }

    public boolean isPlayerCompatible(RendererConfiguration renderer) {
        return true;
    }

    public boolean isInternalSubtitlesSupported() {
        return true;
    }

    public boolean isExternalSubtitlesSupported() {
        return true;
    }

    public boolean isTimeSeekable() {
        return false;
    }

    public boolean isVideoHardwareAccelerationReady() {
        return false;
    }

    @Deprecated
    public ProcessWrapper launchTranscode(String filename, DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        return this.launchTranscode(dlna, media, params);
    }

    public abstract ProcessWrapper launchTranscode(DLNAResource var1, DLNAMediaInfo var2, OutputParams var3) throws IOException;

    public String toString() {
        return this.name();
    }

    @Deprecated
    protected String[] finalizeTranscoderArgs(Player player, String filename, DLNAResource dlna, DLNAMediaInfo media, OutputParams params, String[] cmdArgs) {
        return this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArgs);
    }

    protected String[] finalizeTranscoderArgs(String filename, DLNAResource dlna, DLNAMediaInfo media, OutputParams params, String[] cmdArgs) {
        if (finalizeTranscoderArgsListeners.isEmpty()) {
            return cmdArgs;
        }
        List<String> cmdList = new ArrayList<String>(Arrays.asList(cmdArgs));
        for (FinalizeTranscoderArgsListener listener : finalizeTranscoderArgsListeners) {
            try {
                cmdList = listener.finalizeTranscoderArgs(this, filename, dlna, media, params, cmdList);
            }
            catch (Throwable t) {
                logger.error(String.format("Failed to call finalizeTranscoderArgs on listener of type=%s", listener.getClass()), t);
            }
        }
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        return cmdArray;
    }

    public void setAudioAndSubs(String fileName, DLNAMediaInfo media, OutputParams params, PmsConfiguration configuration) {
        if (params.aid == null && media != null) {
            StringTokenizer st = new StringTokenizer(configuration.getAudioLanguages(), ",");
            block0: while (st != null && st.hasMoreTokens()) {
                String lang = st.nextToken();
                lang = lang.trim();
                logger.trace("Looking for an audio track with lang: " + lang);
                for (DLNAMediaAudio audio : media.getAudioTracksList()) {
                    if (!audio.matchCode(lang)) continue;
                    params.aid = audio;
                    logger.trace("Matched audio track: " + audio);
                    st = null;
                    continue block0;
                }
            }
        }
        if (params.aid == null && media.getAudioTracksList().size() > 0) {
            for (DLNAMediaAudio audio : media.getAudioTracksList()) {
                if (!audio.isDTS()) continue;
                params.aid = audio;
                logger.trace("Found priority audio track with DTS: " + audio);
                break;
            }
            if (params.aid == null) {
                params.aid = media.getAudioTracksList().get(0);
                logger.trace("Chose a default audio track: " + params.aid);
            }
        }
        String currentLang = null;
        DLNAMediaLang matchedSub = null;
        if (params.aid != null) {
            currentLang = params.aid.getLang();
        }
        if (params.sid != null && params.sid.getId() == -1) {
            logger.trace("Don't want subtitles!");
            params.sid = null;
            return;
        }
        StringTokenizer st1 = new StringTokenizer(configuration.getAudioSubLanguages(), ";");
        while (st1.hasMoreTokens()) {
            String pair = st1.nextToken();
            if (!pair.contains(",")) continue;
            String audio = pair.substring(0, pair.indexOf(","));
            String sub = pair.substring(pair.indexOf(",") + 1);
            audio = audio.trim();
            sub = sub.trim();
            logger.trace("Searching for a match for: " + currentLang + " with " + audio + " and " + sub);
            if (!Iso639.isCodesMatching(audio, currentLang) && (currentLang == null || !audio.equals("*"))) continue;
            if (sub.equals("off")) {
                matchedSub = new DLNAMediaSubtitle();
                matchedSub.setLang("off");
            } else {
                for (DLNAMediaSubtitle present_sub : media.getSubtitleTracksList()) {
                    if (!present_sub.matchCode(sub) && !sub.equals("*")) continue;
                    matchedSub = present_sub;
                    logger.trace("Found a match: " + matchedSub);
                    break;
                }
            }
            if (matchedSub == null) continue;
            break;
        }
        if (matchedSub != null && params.sid == null) {
            if (configuration.isDisableSubtitles() || matchedSub.getLang() != null && matchedSub.getLang().equals("off")) {
                logger.trace(" Disabled the subtitles: " + matchedSub);
            } else {
                params.sid = matchedSub;
            }
        }
        if (!configuration.isDisableSubtitles() && params.sid == null && media != null) {
            File video = new File(fileName);
            FileUtil.isSubtitlesExists(video, media, false);
            if (configuration.isAutoloadExternalSubtitles()) {
                boolean forcedSubsFound = false;
                for (DLNAMediaSubtitle sub : media.getSubtitleTracksList()) {
                    if (matchedSub != null && matchedSub.getLang() != null && matchedSub.getLang().equals("off")) {
                        StringTokenizer st = new StringTokenizer(configuration.getForcedSubtitleTags(), ",");
                        while (st != null && sub.getFlavor() != null && st.hasMoreTokens()) {
                            String forcedTags = st.nextToken();
                            forcedTags = forcedTags.trim();
                            if (sub.getFlavor().toLowerCase().indexOf(forcedTags) <= -1 || !Iso639.isCodesMatching(sub.getLang(), configuration.getForcedSubtitleLanguage())) continue;
                            logger.trace("Forcing preferred subtitles : " + sub.getLang() + "/" + sub.getFlavor());
                            logger.trace("Forced subtitles track : " + sub);
                            if (sub.getExternalFile() != null) {
                                logger.trace("Found external forced file : " + sub.getExternalFile().getAbsolutePath());
                            }
                            params.sid = sub;
                            forcedSubsFound = true;
                            break;
                        }
                        if (!forcedSubsFound) continue;
                        break;
                    }
                    logger.trace("Found subtitles track: " + sub);
                    if (sub.getExternalFile() == null) continue;
                    logger.trace("Found external file: " + sub.getExternalFile().getAbsolutePath());
                    params.sid = sub;
                    break;
                }
            }
            if (matchedSub != null && matchedSub.getLang() != null && matchedSub.getLang().equals("off")) {
                return;
            }
            if (params.sid == null) {
                StringTokenizer st = new StringTokenizer(configuration.getSubtitlesLanguages(), ",");
                block7: while (st != null && st.hasMoreTokens()) {
                    String lang = st.nextToken();
                    lang = lang.trim();
                    logger.trace("Looking for a subtitle track with lang: " + lang);
                    for (DLNAMediaSubtitle sub : media.getSubtitleTracksList()) {
                        if (!sub.matchCode(lang)) continue;
                        params.sid = sub;
                        logger.trace("Matched sub track: " + params.sid);
                        st = null;
                        continue block7;
                    }
                }
            }
        }
    }

    public abstract boolean isCompatible(DLNAResource var1);
}

