/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.IPushOutput;
import net.pms.dlna.InputFile;
import net.pms.util.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedEntry
extends DLNAResource
implements IPushOutput {
    private static final Logger logger = LoggerFactory.getLogger(ZippedEntry.class);
    private File file;
    private String zeName;
    private long length;
    private ZipFile zipFile;

    @Override
    protected String getThumbnailURL() {
        if (this.getType() == 2 || this.getType() == 1) {
            return null;
        }
        return super.getThumbnailURL();
    }

    public ZippedEntry(File file, String zeName, long length) {
        this.zeName = zeName;
        this.file = file;
        this.length = length;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public String getName() {
        return this.zeName;
    }

    @Override
    public long length() {
        if (this.getPlayer() != null && this.getPlayer().type() != 2) {
            return 0x7FFFFFFF7FFFFFFFL;
        }
        return this.length;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return FilenameUtils.getBaseName(this.file.getAbsolutePath()) + "." + FilenameUtils.getExtension(this.zeName);
    }

    @Override
    public boolean isValid() {
        this.resolveFormat();
        this.setSrtFile(FileUtil.isSubtitlesExists(this.file, null));
        return this.getFormat() != null;
    }

    @Override
    public boolean isUnderlyingSeekSupported() {
        return this.length() < 800000000L;
    }

    @Override
    public void push(final OutputStream out) throws IOException {
        Runnable r = new Runnable(){
            InputStream in = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n = -1;
                    byte[] data = new byte[65536];
                    ZippedEntry.this.zipFile = new ZipFile(ZippedEntry.this.file);
                    ZipEntry ze = ZippedEntry.this.zipFile.getEntry(ZippedEntry.this.zeName);
                    this.in = ZippedEntry.this.zipFile.getInputStream(ze);
                    while ((n = this.in.read(data)) > -1) {
                        out.write(data, 0, n);
                    }
                    this.in.close();
                    this.in = null;
                }
                catch (Exception e) {
                    logger.error("Unpack error. Possibly harmless.", e);
                }
                finally {
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                        ZippedEntry.this.zipFile.close();
                        out.close();
                    }
                    catch (IOException e) {
                        logger.debug("Caught exception", e);
                    }
                }
            }
        };
        new Thread(r, "Zip Extractor").start();
    }

    @Override
    protected void resolveOnce() {
        if (this.getFormat() == null || !this.getFormat().isVideo()) {
            return;
        }
        boolean found = false;
        if (!found) {
            if (this.getMedia() == null) {
                this.setMedia(new DLNAMediaInfo());
            }
            boolean bl = found = !this.getMedia().isMediaparsed() && !this.getMedia().isParsing();
            if (this.getFormat() != null) {
                InputFile input = new InputFile();
                input.setPush(this);
                input.setSize(this.length());
                this.getFormat().parse(this.getMedia(), input, this.getType());
            }
        }
    }

    @Override
    public InputStream getThumbnailInputStream() throws IOException {
        if (this.getMedia() != null && this.getMedia().getThumb() != null) {
            return this.getMedia().getThumbnailInputStream();
        }
        return super.getThumbnailInputStream();
    }
}

