/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.pms.dlna.DLNAMediaLang;
import net.pms.formats.v2.SubtitleType;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAMediaSubtitle
extends DLNAMediaLang
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DLNAMediaSubtitle.class);
    private SubtitleType type = SubtitleType.UNKNOWN;
    private String flavor;
    private File externalFile;
    private String externalFileCharacterSet;

    public boolean isEmbedded() {
        return this.getExternalFile() == null;
    }

    public boolean isExternal() {
        return !this.isEmbedded();
    }

    public String toString() {
        return "DLNAMediaSubtitle{id=" + this.getId() + ", type=" + (Object)((Object)this.type) + ", flavor='" + this.flavor + '\'' + ", lang='" + this.getLang() + '\'' + ", externalFile=" + this.externalFile + ", externalFileCharacterSet='" + this.externalFileCharacterSet + '\'' + '}';
    }

    @Deprecated
    public void checkUnicode() {
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public SubtitleType getType() {
        return this.type;
    }

    public void setType(SubtitleType type) {
        if (type == null) {
            throw new IllegalArgumentException("Can't set null SubtitleType.");
        }
        this.type = type;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    @Deprecated
    public File getPlayableExternalFile() {
        return this.getExternalFile();
    }

    public File getExternalFile() {
        return this.externalFile;
    }

    public void setExternalFile(File externalFile) throws FileNotFoundException {
        if (externalFile == null) {
            throw new FileNotFoundException("Can't read file: no file supplied");
        }
        if (!FileUtil.isFileReadable(externalFile)) {
            throw new FileNotFoundException("Can't read file: " + externalFile.getAbsolutePath());
        }
        this.externalFile = externalFile;
        this.setExternalFileCharacterSet();
    }

    private void setExternalFileCharacterSet() {
        if (this.type == SubtitleType.VOBSUB || this.type == SubtitleType.BMP || this.type == SubtitleType.DIVX || this.type == SubtitleType.PGS) {
            this.externalFileCharacterSet = null;
        } else {
            try {
                this.externalFileCharacterSet = FileUtil.getFileCharset(this.externalFile);
            }
            catch (IOException ex) {
                this.externalFileCharacterSet = null;
                logger.warn("Exception during external file charset detection.", ex);
            }
        }
    }

    public String getExternalFileCharacterSet() {
        return this.externalFileCharacterSet;
    }

    public boolean isExternalFileUtf8() {
        return FileUtil.isCharsetUTF8(this.externalFileCharacterSet);
    }

    public boolean isExternalFileUtf16() {
        return FileUtil.isCharsetUTF16(this.externalFileCharacterSet);
    }

    public boolean isExternalFileUtf32() {
        return FileUtil.isCharsetUTF32(this.externalFileCharacterSet);
    }

    public boolean isExternalFileUtf() {
        return this.isExternalFileUtf8() || this.isExternalFileUtf16() || this.isExternalFileUtf32();
    }
}

