/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import net.pms.PMS;
import net.pms.configuration.ProgramPaths;
import net.pms.io.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsRegistryProgramPaths
implements ProgramPaths {
    private static final Logger logger = LoggerFactory.getLogger(WindowsRegistryProgramPaths.class);
    private final ProgramPaths defaults;

    WindowsRegistryProgramPaths(ProgramPaths defaults) {
        this.defaults = defaults;
    }

    @Override
    public String getFfmpegPath() {
        return this.defaults.getFfmpegPath();
    }

    @Override
    public String getFlacPath() {
        return this.defaults.getFlacPath();
    }

    @Override
    public String getMencoderPath() {
        return this.defaults.getMencoderPath();
    }

    @Override
    public String getMplayerPath() {
        return this.defaults.getMplayerPath();
    }

    @Override
    public String getTsmuxerPath() {
        return this.defaults.getTsmuxerPath();
    }

    @Override
    public String getVlcPath() {
        SystemUtils registry = PMS.get().getRegistry();
        if (registry.getVlcPath() != null) {
            String vlc = registry.getVlcPath();
            String version = registry.getVlcVersion();
            if (new File(vlc).exists() && version != null) {
                logger.debug("Found VLC version " + version + " in Windows Registry: " + vlc);
                return vlc;
            }
        }
        return this.defaults.getVlcPath();
    }

    @Override
    public String getDCRaw() {
        return this.defaults.getDCRaw();
    }
}

