extern crate inflate;

fn get_test_file_data(name: &str) -> Vec<u8> {
    use std::fs::File;
    use std::io::Read;
    let mut input = Vec::new();
    let mut f = File::open(name).unwrap();

    f.read_to_end(&mut input).unwrap();
    input
}

#[test]
/// See https://github.com/PistonDevelopers/inflate/issues/14
fn issue_14() {
    let test_data = get_test_file_data("tests/issue_14.zlib");
    let res = inflate::inflate_bytes_zlib(&test_data);
    // This should fail as the file specifies code lengths that won't work.
    assert!(res.is_err());
}

#[test]
/// Another input that produce invalid code lengths.
fn issue_16() {
    let data = b"M\xff\xffM*\xad\xad\xad\xad\xad\xad\xad\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xad\xad\xad\xad\xad\xad\xad\xad\xad\xad\xad\xadMCMMMM\x00\x00\x00\x00\x00\x00\x00\x00\x00!\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\xcb!\x0a";
    let mut stream = inflate::InflateStream::new();
    let res = stream.update(data);
    assert!(res.is_err());
}

#[test]
/// Similar to 16 but with CLENS being invalid.
fn issue_17() {
    let data = b"\xdd\xff\xff*M\x94ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\x01\x09\x00\x00\xf2\xf2MM\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00*M\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00MMMM\xff\xffM\xff\x00;MM0*\x00\x00\x00\x00\x00\x00\x0a";
    let mut stream = inflate::InflateStream::new();
    let res = stream.update(data);
    assert!(res.is_err());
}

#[test]
fn issue_30_realworld() {
    // In this case, the LZ77 window size is misreported as 256B. The first two bytes should be
    // e.g. [0x78, 0xda] to set the window size to a maximum value (32kiB).
    let data = &[
        0x8, 0xd7, 99, 100, 48, 158, 201, 128, 3, 196, 91, 158, 48, 231, 153, 127, 242, 75,
        226, 194, 227, 22, 184, 212, 48, 51, 72, 249, 98, 213, 57, 47, 180, 153, 225, 195, 133,
        148, 64, 230, 87, 247, 206, 53, 249, 111, 249, 201, 40, 122, 241, 137, 12, 166, 74, 70,
        172, 246, 255, 154, 150, 149, 186, 56, 14, 110, 109, 188, 229, 137, 217, 177, 139, 216,
        178, 166, 49, 50, 48, 252, 199, 175, 63, 222, 242, 68, 130, 238, 124, 199, 89, 88, 12, 221,
        159, 150, 190, 224, 50, 186, 95, 152, 208, 20, 213, 56, 207, 95, 112, 57, 17, 171, 87, 23,
        92, 78, 172, 113, 158, 143, 207, 255, 241, 150, 39, 126, 190, 190, 208, 118, 48, 19, 171,
        254, 139, 79, 100, 52, 217, 183, 136, 136, 163, 4, 4, 138, 253, 230, 60, 243, 83, 2, 153,
        25, 209, 253, 136, 0, 41, 129, 204, 230, 60, 40, 78, 96, 65, 230, 156, 252, 146, 200, 176,
        126, 254, 127, 6, 70, 92, 209, 57, 103, 253, 223, 147, 95, 18, 113, 250, 127, 225, 113, 11,
        87, 115, 134, 120, 203, 19, 88, 245, 31, 186, 165, 234, 106, 206, 64, 32, 252, 90, 246, 38,
        38, 232, 206, 199, 170, 127, 94, 112, 85, 203, 222, 68, 2, 241, 207, 200, 192, 192, 192,
        240, 255, 231, 180, 108, 204, 248, 103, 207, 154, 198, 128, 17, 255, 44, 104, 230, 253,
        103, 96, 96, 96, 96, 76, 93, 28, 151, 160, 59, 31, 18, 156, 115, 214, 255, 213, 84, 100,
        72, 93, 156, 136, 53, 84, 25, 41, 76, 255, 0, 17, 24, 113, 221];
    inflate::inflate_bytes_zlib(data);
}

#[test]
fn issue_30_small() {
    // Invalid data, but should not panic
    // generated by cargo-fuzz
    let data = &[0x08, 0xd7, 0x3a, 0xff, 0x3b, 0x8, 0xd7, 0xfd, 0xff, 0xff, 0xff];
    inflate::inflate_bytes_zlib(data);
}

#[test]
// no checksum present at the end of the data stream (cargo-fuzz test-case)
fn no_checksum() {
    let data = b"\x13\xff\xed\xff\xff\x12\xbfM\x00\x00\x00\x00\xd1";
    let mut stream = inflate::InflateStream::new();
    let res = stream.update(data);
    // This is not an error, because the checksum may be included in the next
    // call to `stream.update`. See issue #27.
    assert!(res.is_ok());
}

#[test]
/// The first byte of the CRC is already read into the BitStream buffer.
fn issue_26() {
    let data = &[120, 156, 189, 138, 65, 13, 0, 32, 16, 195, 64, 2, 22, 176, 128, 5, 44, 96, 1, 11,
        216, 103, 19, 176, 123, 118, 73, 155, 61, 218, 155, 54, 10, 136, 192, 170, 32, 130, 41,
        249, 36, 136, 96, 73, 62, 9, 34, 216, 146, 79, 130, 8, 142, 228, 147, 32, 130, 43, 249, 36,
        136, 224, 73, 62, 9, 32, 248, 250, 192, 22, 113, 123];
    let mut stream = inflate::InflateStream::from_zlib();
    let res = stream.update(data);
    assert!(res.is_ok());
}
