// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: 54d269086772601b2a71f0f8e9c80dc45e576955 $
//
// Copyright (C) 2006-2025 by The Odamex Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// DESCRIPTION:
//  Utility functions
//
// AUTHORS:
//  Russell Rice (russell at odamex dot net)
//  Michael Wood (mwoodj at knology dot net)
//
//-----------------------------------------------------------------------------

#ifndef __NET_UTILS_H__
#define __NET_UTILS_H__

#include "typedefs.h"

#include <string>
#include <sstream>

/**
 * odalpapi namespace.
 *
 * All code for the odamex launcher protocol api is contained within the odalpapi
 * namespace.
 */
namespace odalpapi
{

uint64_t GetMillisNow();
int32_t OdaAddrToComponents(const std::string& HostPort, std::string &AddrOut, 
                            uint16_t &PortOut);
} // namespace

#endif // __NET_UTILS_H__
