<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/active_directory_federation_service.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "Active Directory Federation Service"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Active Directory Federation Service


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibADFS

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Active Directory Federation Services statistics.


It queries 'AD FS' object from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Federation Service

These metrics refer to the Federated Identity and Access Management on host.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| adfs.ad_login_connection_failures | connection | failures/s |
| adfs.certificate_authentications | authentications | authentications/s |
| adfs.db_artifact_failures | connection | failures/s |
| adfs.db_artifact_query_time_seconds | query_time | seconds/s |
| adfs.db_config_failures | connection | failures/s |
| adfs.db_config_query_time_seconds | query_time | seconds/s |
| adfs.device_authentications | authentications | authentications/s |
| adfs.external_authentications | success, failure | authentications/s |
| adfs.federated_authentications | authentications | authentications/s |
| adfs.federation_metadata_requests | requests | requests/s |
| adfs.oauth_authorization_requests | requests | requests/s |
| adfs.oauth_client_authentications | success, failure | authentications/s |
| adfs.oauth_client_credentials_requests | success, failure | requests/s |
| adfs.oauth_client_privkey_jwt_authentications | success, failure | authentications/s |
| adfs.oauth_client_secret_basic_authentications | success, failure | authentications/s |
| adfs.oauth_client_secret_basic_authentications | success, failure | authentications/s |
| adfs.oauth_client_secret_post_authentications | success, failure | authentications/s |
| adfs.oauth_client_windows_authentications | success, failure | requests/s |
| adfs.oauth_logon_certificate_requests | success, failure | requests/s |
| adfs.oauth_password_grant_requests | success, failure | requests/s |
| adfs.oauth_token_requests_success | success | requests/s |
| adfs.passive_requests | passive | requests/s |
| adfs.passport_authentications | passport | authentications/s |
| adfs.password_change_requests | success, failure | requests/s |
| adfs.samlp_token_requests_success | success | requests/s |
| adfs.sso_authentications | success, failure | authentications/s |
| adfs.token_requests | requests | requests/s |
| adfs.userpassword_authentications | success, failure | authentications/s |
| adfs.windows_integrated_authentications | authentications | authentications/s |
| adfs.wsfed_token_requests_success | success | requests/s |
| adfs.wstrust_token_requests_success | success | requests/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| PerflibADFS | An option to enable or disable the data collection. | yes | no |

#### Examples
There are no configuration examples.


